unit uOptions;
{$INCLUDE 'DirSync.inc'}

interface

uses
  //SysUtils, Windows, Classes, Generics.Collections,
  {$IFDEF FAR3} Plugin3, {$ELSE} PluginW, {$ENDIF} FarKeysW, FarColor,
  uSystem, uFAR, uLog,
  uDirSyncConsts;

type
  TDirSyncOptions = class(TFarConfig)
  private
    fProcessSubfolders: boolean;
    fUseMaxScanDepth: boolean;
    fMaxScanDepth: integer;
    fProcessSelected: boolean;
    fCompareTime: boolean;
    fLowPrecisionTime: boolean;
    fIgnorePossibleTimeZoneDifferences: boolean;
    fCompareSize: boolean;
    fCompareContents: boolean;
    fCompareContentsIgnore: boolean;
    fIgnoreNewLines: boolean;
    fIgnoreWhitespace: boolean;
    fShowReport: boolean;
    fMessageWhenNoDiff: boolean;
    fCompareCommand: string;
    fCompareCommandArguments: string;
    fCompareCommandAcceptsNTFileNames: boolean;
    fSilentModeByDefault: boolean;
    fShowDescriptionIsSyncFile: boolean;
  protected
  public
    constructor Create;
    destructor Destroy; override;
    procedure Init;
    procedure Load;
    procedure Save;
    procedure Assign(Options: TDirSyncOptions);
    property ProcessSubfolders: boolean read fProcessSubfolders write fProcessSubfolders;
    property UseMaxScanDepth: boolean read fUseMaxScanDepth write fUseMaxScanDepth;
    property MaxScanDepth: integer read fMaxScanDepth write fMaxScanDepth;
    property ProcessSelected: boolean read fProcessSelected write fProcessSelected;
    property CompareTime: boolean read fCompareTime write fCompareTime;
    property LowPrecisionTime: boolean read fLowPrecisionTime write fLowPrecisionTime;
    property IgnorePossibleTimeZoneDifferences: boolean read fIgnorePossibleTimeZoneDifferences write fIgnorePossibleTimeZoneDifferences;
    property CompareSize: boolean read fCompareSize write fCompareSize;
    property CompareContents: boolean read fCompareContents write fCompareContents;
    property CompareContentsIgnore: boolean read fCompareContentsIgnore write fCompareContentsIgnore;
    property IgnoreNewLines: boolean read fIgnoreNewLines write fIgnoreNewLines;
    property IgnoreWhitespace: boolean read fIgnoreWhitespace write fIgnoreWhitespace;
    property ShowReport: boolean read fShowReport write fShowReport;
    property MessageWhenNoDiff: boolean read fMessageWhenNoDiff write fMessageWhenNoDiff;
    property CompareCommand: string read fCompareCommand write fCompareCommand;
    property CompareCommandArguments: string read fCompareCommandArguments write fCompareCommandArguments;
    property CompareCommandAcceptsNTFileNames: boolean read fCompareCommandAcceptsNTFileNames write fCompareCommandAcceptsNTFileNames;
    property SilentModeByDefault: boolean read fSilentModeByDefault write fSilentModeByDefault;
    property ShowDescriptionIsSyncFile: boolean read fShowDescriptionIsSyncFile write fShowDescriptionIsSyncFile;
  end;

implementation

{ TDirSyncOptions }

procedure TDirSyncOptions.Assign(Options: TDirSyncOptions);
begin
  ProcessSubfolders := Options.ProcessSubfolders;
  UseMaxScanDepth := Options.UseMaxScanDepth;
  MaxScanDepth := Options.MaxScanDepth;
  ProcessSelected := Options.ProcessSelected;
  CompareTime := Options.CompareTime;
  LowPrecisionTime := Options.LowPrecisionTime;
  IgnorePossibleTimeZoneDifferences := Options.IgnorePossibleTimeZoneDifferences;
  CompareSize := Options.CompareSize;
  CompareContents := Options.CompareContents;
  CompareContentsIgnore := Options.CompareContentsIgnore;
  IgnoreNewLines := Options.IgnoreNewLines;
  IgnoreWhitespace := Options.IgnoreWhitespace;
  ShowReport := Options.ShowReport;
  MessageWhenNoDiff := Options.MessageWhenNoDiff;
  CompareCommand := Options.CompareCommand;
  CompareCommandArguments := Options.CompareCommandArguments;
  CompareCommandAcceptsNTFileNames := Options.CompareCommandAcceptsNTFileNames;
  SilentModeByDefault := Options.SilentModeByDefault;
  ShowDescriptionIsSyncFile := Options.ShowDescriptionIsSyncFile;
end;

constructor TDirSyncOptions.Create;
begin
  inherited Create( {$IFDEF FAR3} PLUGIN_GUID {$ELSE} 'DirSync' {$ENDIF} , False);
  Init;
end;

destructor TDirSyncOptions.Destroy;
begin
  inherited;
end;

procedure TDirSyncOptions.Init;
begin
  fProcessSubfolders := False;
  fUseMaxScanDepth := False;
  fMaxScanDepth := 99;
  fProcessSelected := False;
  fCompareTime := True;
  fLowPrecisionTime := True;
  fIgnorePossibleTimeZoneDifferences := True;
  fCompareSize := True;
  fCompareContents := False;
  fCompareContentsIgnore := False;
  fIgnoreNewLines := True;
  fIgnoreWhitespace := False;
  fShowReport := True;
  fMessageWhenNoDiff := False;
  fCompareCommand := 'winmerge';
  fCompareCommandArguments := '${LEFTFILE} ${RIGHTFILE}';
  fCompareCommandAcceptsNTFileNames := False; // WinMerge does not support them
  fSilentModeByDefault := False;
  fShowDescriptionIsSyncFile := True;
end;

procedure TDirSyncOptions.Load;
begin
  if Open then
    try
      ProcessSubfolders := ReadBoolean('ProcessSubfolders', ProcessSubfolders);
      UseMaxScanDepth := ReadBoolean('UseMaxScanDepth', UseMaxScanDepth);
      MaxScanDepth := ReadInteger('MaxScanDepth', MaxScanDepth);
      ProcessSelected := ReadBoolean('ProcessSelected', ProcessSelected);
      CompareTime := ReadBoolean('CompareTime', CompareTime);
      LowPrecisionTime := ReadBoolean('LowPrecisionTime', LowPrecisionTime);
      IgnorePossibleTimeZoneDifferences := ReadBoolean('IgnorePossibleTimeZoneDifferences', IgnorePossibleTimeZoneDifferences);
      CompareSize := ReadBoolean('CompareSize', CompareSize);
      CompareContents := ReadBoolean('CompareContents', CompareContents);
      CompareContentsIgnore := ReadBoolean('CompareContentsIgnore', CompareContentsIgnore);
      IgnoreNewLines := ReadBoolean('IgnoreNewLines', IgnoreNewLines);
      IgnoreWhitespace := ReadBoolean('IgnoreWhitespace', IgnoreWhitespace);
      ShowReport := ReadBoolean('ShowReport', ShowReport);
      MessageWhenNoDiff := ReadBoolean('MessageWhenNoDiff', MessageWhenNoDiff);
      CompareCommand := ReadString('CompareCommand', CompareCommand);
      CompareCommandArguments := ReadString('CompareCommandArguments', CompareCommandArguments);
      CompareCommandAcceptsNTFileNames := ReadBoolean('CompareCommandAcceptsNTFileNames', CompareCommandAcceptsNTFileNames);
      SilentModeByDefault := ReadBoolean('SilentModeByDefault', SilentModeByDefault);
      ShowDescriptionIsSyncFile := ReadBoolean('ShowDescriptionIsSyncFile', ShowDescriptionIsSyncFile);
    finally
      Close;
    end;
end;

procedure TDirSyncOptions.Save;
begin
  if Open then
    try
      WriteBoolean('ProcessSubfolders', ProcessSubfolders);
      WriteBoolean('UseMaxScanDepth', UseMaxScanDepth);
      WriteInteger('MaxScanDepth', MaxScanDepth);
      WriteBoolean('ProcessSelected', ProcessSelected);
      WriteBoolean('CompareTime', CompareTime);
      WriteBoolean('LowPrecisionTime', LowPrecisionTime);
      WriteBoolean('IgnorePossibleTimeZoneDifferences', IgnorePossibleTimeZoneDifferences);
      WriteBoolean('CompareSize', CompareSize);
      WriteBoolean('CompareContents', CompareContents);
      WriteBoolean('CompareContentsIgnore', CompareContentsIgnore);
      WriteBoolean('IgnoreNewLines', IgnoreNewLines);
      WriteBoolean('IgnoreWhitespace', IgnoreWhitespace);
      WriteBoolean('ShowReport', ShowReport);
      WriteBoolean('MessageWhenNoDiff', MessageWhenNoDiff);
      WriteString('CompareCommand', CompareCommand);
      WriteString('CompareCommandArguments', CompareCommandArguments);
      WriteBoolean('CompareCommandAcceptsNTFileNames', CompareCommandAcceptsNTFileNames);
      WriteBoolean('SilentModeByDefault', SilentModeByDefault);
      WriteBoolean('ShowDescriptionIsSyncFile', ShowDescriptionIsSyncFile);
    finally
      Close;
    end;
end;

end.
