unit uMessages;
{$INCLUDE 'DirSync3.inc'}

interface

uses
  {$IFDEF FAR3} Plugin3, {$ELSE} PluginW, {$ENDIF} FarKeysW, FarColor,
  uSystem, uFAR, uLog,
  uDirSyncConsts;

type
  TMessages = (
    MNoLngStringDefined = -1,
    //
    MTitle = 0,
    //
    MOK,
    MCancel,
    MReturnToEditor,
    MSkip,
    MErase,
    MRetry,
    //
    MProcessBox,
    MProcessSubfolders,
    MUseMaxScanDepth,
    MProcessSelected,
    MCompareBox,
    MCompareTime,
    MCompareLowPrecision,
    MCompareIgnoreTimeZone,
    MCompareSize,
    MCompareContents,
    MCompareContentsIgnore,
    MCompareIgnoreNewLines,
    MCompareIgnoreWhitespace,
    MFilePanelsRequired,
    MComparing,
    MComparingWith,
    MComparingFiles,
    MNoDiffTitle,
    MNoDiffBody,
    MEscTitle,
    MEscBody,
    MCopying,
    MCopyingTo,
    MWarning,
    MLeftFileAlreadyExists,
    MRightFileAlreadyExists,
    MLeftFileReadonly,
    MRightFileReadonly,
    MLeftDirReadonly,
    MRightDirReadonly,
    MLeftFileErase,
    MRightFileErase,
    MLeftDirErase,
    MRightDirErase,
    MCantCreateDirectory,
    MNew,
    MExisting,
    MEraseFile,
    MEraseDir,
    MDirectory,
    MOverwrite,
    MFailedCopySrcFile,
    MFailedOpenSrcFile,
    MFailedOpenDstFile,
    MFailedCreateDstFile,
    MFailedEraseFile,
    MFailedEraseDir,
    MFailedCopyDstFile,
    MCopyRightToLeft,
    MOverwriteRightToLeft,
    MCopyLeftToRight,
    MOverwriteLeftToRight,
    MEraseAbsentFiles,
    MEraseAbsentFilesLeft,
    MEraseAbsentFilesRight,
    MReportFileTitle,
    MReportFileNotes1,
    MReportFileNotes2,
    MDeletingFile,
    MDeletingDirectory,
    MFilesAreDifferent,
    MLeftFileName,
    MRightFileName,
    MOverwriteLeft,
    MOverwriteRight,
    MCompare,
    MBothFilesExist,
    MBothFilesExistSameDate,
    MOverwriteLeft2,
    MOverwriteRight2,
    MAskUser,
    MEditLeft,
    MEditRight,
    MCompareCommand,
    MCompareCommandArguments,
    MCompareCommandAcceptsNTFileNames,
    MVisualCompareNotSetUp,
    MKeyOverwriteLeft,
    MKeyOverwriteLeftLong,
    MKeyOverwriteRight,
    MKeyOverwriteRightLong,
    MKeyCompare,
    MKeyCompareLong,
    MKeyEditLeft,
    MKeyEditLeftLong,
    MKeyEditRight,
    MKeyEditRightLong,
    MShowFileInfo,
    MKeyFileInfo,
    MKeyFileInfoLong,
    MShowingFileInfo,
    MFileSize,
    MFileCreationTime,
    MFileModificationTime,
    MFileAccessTime,
    MLeftFile,
    MRightFile,
    MUnknown,
    MUseSilentModeByDefault,
    MSilentMode,
    MShowDescriptionInSyncFile,
    MRememberChoiceForDir,
    MGlobalRemember,
    MSelectOnBothPanels,
    MFindNextToLeft,
    MKeyFindNextToLeft,
    MKeyFindNextToLeftLong,
    MFindNextToRight,
    MKeyFindNextToRight,
    MKeyFindNextToRightLong,
    MReportFileControlsALTF1,
    MReportFileControlsALTF2,
    MReportFileControlsALTF3,
    MReportFileControlsALTF5,
    MReportFileControlsALTF6,
    MReportFileControlsCTRLF1,
    MReportFileControlsCTRLF2,
    MReportFileControlsCTRLF3,
    MReportFileControlsALTF1Notes,
    MSourceNotFound,
    MSourceIsNotDirectory,
    MDestinationIsNotDirectory,
    // These must be at the end!! They are not expected to be translated
    MExtraString1,
    MExtraString2,
    MExtraString3
  );

type
  TPFarCharArray = array of PFarChar;

function GetMsg(MsgId: TMessages): PFarChar; overload;
function GetMsg(MsgId: TMessages; const Strings: array of PFarChar): PFarChar; overload;
function GetMsgPas(MsgId: TMessages): string;
function FarMessage(const Msg: array of TMessages; Flags: TFarMessageFlags; ButtonCount: integer): integer; overload;
function FarMessage(const Msg: array of TMessages; const Strings: array of PFarChar; Flags: TFarMessageFlags; ButtonCount: integer): integer; overload;

implementation

const
  NO_MESSAGE = '';

function GetMsg(MsgId: TMessages; const Strings: array of PFarChar): PFarChar;
var
  StrIdx: integer;
begin
  if MsgId = MNoLngStringDefined then
    Result := NO_MESSAGE
  else if MsgId >= MExtraString1 then begin
    StrIdx := Integer(MsgId) - Integer(MExtraString1);
    if StrIdx < Length(Strings) then
      Result := Strings[StrIdx]
    else
      Result := NO_MESSAGE;
  end
  else
    //Result := FarApi.GetMsg( {$IFDEF FAR3_UP} PLUGIN_GUID {$ELSE} FarApi.ModuleNumber {$ENDIF} , Integer(MsgId));
    Result := TFarUtils.GetMsg(Integer(MsgId));
end;

function GetMsg(MsgId: TMessages): PFarChar;
begin
  Result := GetMsg(MsgId, []);
end;

function GetMsgPas(MsgId: TMessages): string;
begin
  Result := TFarUtils.CopyString(GetMsg(MsgId));
end;

function FarMessage(const Msg: array of TMessages; const Strings: array of PFarChar; Flags: TFarMessageFlags; ButtonCount: integer): integer;
var
  RealMsg: array of PFarChar;
  i, n: integer;
begin
  n := Length(Msg);
  SetLength(RealMsg, n);
  for i := 0 to Pred(n) do
    RealMsg[i] := GetMsg(Msg[i], Strings);
  Result := TFarUtils.ShowMessage(RealMsg, Flags, ButtonCount);
end;

function FarMessage(const Msg: array of TMessages; Flags: TFarMessageFlags; ButtonCount: integer): integer;
begin
  Result := FarMessage(Msg, [], Flags, ButtonCount);
end;

end.
