unit uOptionsDialog;
{$INCLUDE 'DirSync3.inc'}

interface

uses
  SysUtils, Windows, Classes,
  {$IFDEF FAR3} Plugin3, {$ELSE} PluginW, {$ENDIF} FarKeysW, FarColor,
  uSystem, uFAR, uLog,
  uDirSyncConsts, uMessages, uOptions;

type
  TOptionsDialog = class(TFarDialog)
  private
    fOptions: TDirSyncOptions;
  private
    fEditCompareCommand: integer;
    fEditCompareCommandArguments: integer;
    fCheckCompareCommandAcceptsNTFileNames: integer;
    fCheckShowDescription: integer;
    fCheckSilentModeByDefault: integer;
    fCheckGlobalRemember: integer;
    fButtonOK: integer;
    fButtonCancel: integer;
  private
    fCompareCommandBuf: TFarCharArray;
    fCompareCommandArgumentsBuf: TFarCharArray;
  protected
  public
    constructor Create;
    destructor Destroy; override;
    procedure ClearDialog; override;
    function Execute: boolean;
    property Options: TDirSyncOptions read fOptions write fOptions;
  end;

implementation

{ TOptionsDialog }

procedure TOptionsDialog.ClearDialog;
begin
  inherited;
  fEditCompareCommand := -1;
  fEditCompareCommandArguments := -1;
  fCheckCompareCommandAcceptsNTFileNames := -1;
  fCheckSilentModeByDefault := -1;
  fCheckShowDescription := -1;
  fCheckGlobalRemember := -1;
  fButtonOK := -1;
  fButtonCancel := -1;
  SetLength(fCompareCommandBuf, 0);
  SetLength(fCompareCommandArgumentsBuf, 0);
end;

constructor TOptionsDialog.Create;
begin
  inherited Create( {$IFDEF FAR3_UP} PLUGIN_GUID, DIALOG_CONFIG_GUID {$ELSE} FarApi.ModuleNumber {$ENDIF} );
end;

destructor TOptionsDialog.Destroy;
begin
  inherited;
end;

function TOptionsDialog.Execute: boolean;
var
  Button: integer;
begin
  Result := False;
  // Initialize runtime variables
  SetLength(fCompareCommandBuf, Succ(MAX_PATH));
  StrPCopy(PChar(fCompareCommandBuf), Copy(Options.CompareCommand, 1, Pred(Length(fCompareCommandBuf))));
  SetLength(fCompareCommandArgumentsBuf, Succ(MAX_PATH));
  StrPCopy(PChar(fCompareCommandArgumentsBuf), Copy(Options.CompareCommandArguments, 1, Pred(Length(fCompareCommandArgumentsBuf))));
  // Build the dialog
                                            AddDoubleBox(  3,  1, 62, 12, GetMsg(MTitle), 0);
                                            AddLabel    (  5,  2,         GetMsg(MCompareCommand), 0);
  fEditCompareCommand :=                    AddEdit     (  5,  3, 54,     PFarChar(fCompareCommandBuf), nil, nil, Pred(Length(fCompareCommandBuf)), 0);
                                            AddLabel    (  5,  4,         GetMsg(MCompareCommandArguments), 0);
  fEditCompareCommandArguments :=           AddEdit     (  5,  5, 54,     PFarChar(fCompareCommandArgumentsBuf), nil, nil, Pred(Length(fCompareCommandArgumentsBuf)), 0);
  fCheckCompareCommandAcceptsNTFileNames := AddCheckbox (  5,  6,         GetMsg(MCompareCommandAcceptsNTFileNames), Options.CompareCommandAcceptsNTFileNames, 0);
  fCheckShowDescription :=                  AddCheckbox (  5,  7,         GetMsg(MShowDescriptionInSyncFile), Options.ShowDescriptionIsSyncFile, 0);
  fCheckSilentModeByDefault :=              AddCheckbox (  5,  8,         GetMsg(MUseSilentModeByDefault), Options.SilentModeByDefault, 0);
  fCheckGlobalRemember :=                   AddCheckbox (  5,  9,         GetMsg(MGlobalRemember), Options.GlobalRemember, 0);
                                            AddLabel    (  0, 10,         nil, DIF_SEPARATOR);

  fButtonOK :=                              AddButton   (  0, 11,         GetMsg(MOk), DIF_CENTERGROUP);
  fButtonCancel :=                          AddButton   (  0, 11,         GetMsg(MCancel), DIF_CENTERGROUP);
  // Set the default button
  {$IFDEF FAR3_UP}
  Items[fButtonOK].Flags := Items[fButtonOK].Flags or DIF_DEFAULTBUTTON;
  {$ELSE}
  Items[fButtonOK].DefaultButton := 1;
  {$ENDIF}
  // Show the dialog
  if Build(-1, -1, 66, 14, 0, 'Options') then begin
    if inherited Execute(Button) then begin
      if Button = fButtonOK then begin
        //Log('OK pressed, saving the settings');
        Options.Load;
        Options.CompareCommand := ItemText[fEditCompareCommand];
        Options.CompareCommandArguments := ItemText[fEditCompareCommandArguments];
        Options.CompareCommandAcceptsNTFileNames := ItemChecked[fCheckCompareCommandAcceptsNTFileNames];
        Options.SilentModeByDefault := ItemChecked[fCheckSilentModeByDefault];
        Options.ShowDescriptionIsSyncFile := ItemChecked[fCheckShowDescription];
        Options.GlobalRemember := ItemChecked[fCheckGlobalRemember];
        Options.Save;
        Result := True;
      end;
    end;
  end;
end;

end.
