unit uSupportFunctions;
{$INCLUDE 'DirSync3.inc'}

interface

uses
  Windows, SysUtils, Classes;

function RemoveNTSchematicsFromFileName(const FileName: string): string;
function RemoveLastPathComponent(const Path: string): string;

implementation

function RemoveLastPathComponent(const Path: string): string;
var
  i: integer;
begin
  Result := Path;
  if Path <> '' then begin
    i := Length(Result);
    while (i > 1) and (Result[i] <> '\') do
      Dec(i);
    SetLength(Result, i-1);
  end;
end;

function RemoveNTSchematicsFromFileName(const FileName: string): string;
const
  LocalResource = '\\?\';
  NetworkResource = '\\?\UNC\';
begin
  if UpperCase(Copy(FileName, 1, Length(NetworkResource))) = NetworkResource then
    Result := '\\' + Copy(FileName, Succ(Length(NetworkResource)), MaxInt)
  else if Copy(FileName, 1, Length(LocalResource)) = LocalResource then
    Result := Copy(FileName, Succ(Length(LocalResource)), MaxInt)
  else
    Result := FileName;
  //Log('RemoveNTSchematicsFromFileName("%s") -> "%s"', [FileName, Result]);
end;

end.
