//[START OF KOL.pas]
{****************************************************************

        KKKKK    KKKKK    OOOOOOOOO    LLLLL
        KKKKK    KKKKK  OOOOOOOOOOOOO  LLLLL
        KKKKK    KKKKK  OOOOO   OOOOO  LLLLL
        KKKKK  KKKKK    OOOOO   OOOOO  LLLLL
        KKKKKKKKKK      OOOOO   OOOOO  LLLLL
        KKKKK  KKKKK    OOOOO   OOOOO  LLLLL
        KKKKK    KKKKK  OOOOO   OOOOO  LLLLL
        KKKKK    KKKKK  OOOOOOOOOOOOO  LLLLLLLLLLLLL
        KKKKK    KKKKK    OOOOOOOOO    LLLLLLLLLLLLL

  Key Objects Library (C) 2000 by Kladov Vladimir.

//[VERSION]
****************************************************************
* VERSION 2.93
****************************************************************
//[END OF VERSION]

  K.O.L. - is a set of objects to create small programs
  with the Delphi, but without the VCL. KOL allows to
  create executables of size about 10 times smaller then
  those created with the VCL. But this does not mean that
  KOL is less power then the VCL - perhaps just the opposite...

  KOL is provided free with the source code.
  Copyright (C) Vladimir Kladov, 2000-2003.

  For code provided by other  developers (even if later
  changed by me) authors are noted in the source.

  mailto: bonanzas@online.sinor.ru
  Web-Page: http://bonanzas.rinet.ru

  See also Mirror Classes Kit (M.C.K.) which allows
  to create KOL programs visually.

****************************************************************}

//[UNIT DEFINES]
{$I KOLDEF.inc}
{$IFDEF EXTERNAL_KOLDEFS}
  {$INCLUDE PROJECT_KOL_DEFS.INC}
{$ENDIF}
{$IFDEF EXTERNAL_DEFINES}
        {$INCLUDE EXTERNAL_DEFINES.INC}
{$ENDIF EXTERNAL_DEFINES}

  {$DEFINE GDI}

{$UNDEF LIN} {$UNDEF WIN} {$UNDEF GDI}
{$IFDEF LINUX}
  {$DEFINE UNIX}
  {$DEFINE LIN}
  {$DEFINE PAS_VERSION}
  {$DEFINE NOT_USE_RICHEDIT}
  {$IFNDEF GTK}
    {$IFNDEF XQT}
      {$DEFINE GTK} // it is also possible to define GTK as a project option
    {$ENDIF XQT}    // even for Windows system
  {$ENDIF GTK}
{$ELSE}         // to exploit GTK under Win32 rather then native GDI
  {$DEFINE WIN}
  {$DEFINE GDI}
{$ENDIF}

  {$IFDEF GTK} {$UNDEF GDI} {$DEFINE _X_}
               {$DEFINE NOT_USE_RICHEDIT}
  {$ENDIF}
//{$IFDEF Q_T} {$UNDEF GDI} {$DEFINE _X_} {$ENDIF}

{$IFDEF WIN} {$IFDEF GDI}
  {$DEFINE WIN_GDI}
{$ENDIF GDI} {$ENDIF WIN}

{$INCLUDE delphidef.inc}

{$IFDEF WIN_GDI}
  //test
{$ENDIF WIN_GDI}
{$IFDEF LIN}
  //test
{$ENDIF LIN}

//[START OF UNIT]
unit KOL; {-}
{*
   Please note, that KOL does not use keyword 'class'. Instead,
   poor Pascal 'object' is the base of our objects. So, remember,
   how we worked earlier with such Object Pascal's objects:
|<br>
   - to create objects dynamically, use P<objname> instead of
     T<objname> to allocate a pointer for dynamically created
     object instance;
|<br>
   - remember, that constructors of objects can not be virtual.
     Override procedure Init instead in your own derived objects;
|<br>
   - rather then call constructors of objects, call global procedures
     New<objname> (e.g. NewLabel). If not, first (for virtualally
     created objects) call New( ); then call constructor Create
     (which calls Init) - but this is possible only if the constructor
     is overriden by a new one.
|<br>
   - the operator 'is' is not applicable to objects. And operator 'as'
     is not necessary (and is not applicable too), use typecast to desired
     object type, e.g.: "PSomeObjectType( C )" inplace of "C as TSomeClassType".
|<br>
|<hr>
     Also remember, that IF [ MyObj: PMyObj ] THEN

     NOT[ with MyObj do ] BUT[ with MyObj^ do ]

     Though it is possible to skip '^' symbol when accessing member
     fields, methods, properties, e.g. [ MyObj.Execute; ]
|<hr>
|&U=&nbsp;&nbsp;&nbsp;<a href="#%0">%0</a><br>
|&B=<a href="%1.htm">%0</a><br>
|&C=<a href="%1.htm">%0</a>
|     <table border=1 cellpadding=6 width=100%>
|     <colgroup valign=top span=2>
|       <tr>
|         <td>  objects  </td>     <td>   functions by category </td>
|       </tr>
|         <td>
              <C _TObj> <B TObj>
              <C TList> <C TListEx> <C TStrList> <B TStrListEx>
              <C TTree> <C TDirList> <C TIniFile> <C TCabFile>
              <B TStream>
              <B TControl>
              <C TGraphicTool> <C TCanvas> <C TImageList> <C TIcon> <C TBitmap>
              <C TGif> <C TGifDecoder> <B TJpeg>
              <C TTimer> <C TThread> <C TTrayIcon> <C TDirChange> <B TMediaPlayer>
              <C TMenu> <C TOpenSaveDialog> <C TOpenDirDialog> <B TColorDialog>
              <C TAction> <B TActionList>
              <B Exception>
|         </td>
|         <td>
|<a href="kol_pas.htm#visual_objects_constructors">
      Visual objects constructing functions
|</a><br><br>
              <U Working with null-terminated and ansi strings>
              <U Small bit arrays (max 32 bits in array)>
              <U Arithmetics, geometry and other utility functions>
              <U Data sorting (quicksort implementation)>
              <U String to number and number to string conversions>
              <U 64-bit integer numbers>
              <U Floating point numbers>
              <U Date and time handling>
              <U File and directory routines>
              <U System functions and working with windows>
              <U Text in clipboard operations>
              <U Wrappers to registry API functions>
|         </td>
|     </table>

  Following conditional symbols can be used in a project
  (Project | Options | Directories/Conditional Defines)
  to change code generated a bit. There are following:
|<pre>

  EXTERNAL_KOLDEFS      - since there are a lot of such symbols, it may be not
                          possible to include all the desired optional symbols
                          in the Project Options (Delphi has a restriction to 256
                          characters in a semicolon-separated list of included
                          options). This symbol allows to exceed this restriction:
                          you place your defines in an included file
                          EXTERNAL_DEFINES.INC, located in your project directory.
                          Since this is a normal pascal source, use usual Pascal
                          syntax:  add a directive (*$DEFINE symbol*) for each
                          symbol you want, and you can decorate it with usual
                          comments if necessary.
  ENABLE_DEPRECATED     - some old declaration made "deprecated" and moved to
                          KOL_deprecated.inc. This symbol provides including
                          such declarations into KOL.pas and makes it available
                          again.
  DISABLE_DEPRECATED    - (default) - disables deprecated declaration.
  WIN                   - (default) - version for Windows.
  LINUX                 - version for Linux (only PAS_VERSION) -- not yet ready
                          When not defined, symbol WIN is defined automatically.
  LINUX_USE_HOME_STARTFDIR - in Linux app, HOME directory of the user will be
                          returned by GetStartDir function.
  GTK                   - version for GTK (Linux or Win32) -- not yet ready
  XQT                   - version for QT (Linux or Win32) -- not yet ready
  FPC                   - Free Pascal version. KOL can be used with such compiler
                          to create Win32 applications. To create Win-CE
                          applications (with FPC compiler)), use the separate
                          version of KOL specially designed for it.
  INPACKAGE             - version for Mirror Classes Library package (design-time
                          only). This option should be included only in MCK package
                          options and never in options of the KOL/MCK application.
  PAS_VERSION           - to use Pascal version of the code.
  PARANOIA              - to force short versions of asm instructions (for D5
                          and below, D6 and higher use those instructions always).
  USE_CMOV              - force using CMOV machine instruction in asm code (not
                          recommended, still on some machines your application
                          will not work).
  SMALLEST_CODE         - to create minimal code application (affected:
                          (o) SimpleGetCtlBrushHandle - returns solid silver brush
                              always;
                          (o) _NewWindowed
                              - only default system font used by default;
                              font of the parent control is not applied to its
                              children automatically (but see SMALLEST_CODE_PARENTFONT);
                              - fBrush always set to NIL by default (parent Brush
                              is not applied);
                          (o) WndProcDoEraseBkgnd
                              - child controls windows are not created in WM_ERASEBKGND
                              if were not created earlier (in most case, all OK
                              with this - controls are created BTW);
                              - SetBkColor, SetBkMode, SetBrushOrgEx are not
                              called (all OK therefore)
                          (o) by default, NOT_UNLOAD_RICHEDITLIB is defined if
                              UNLOAD_RICHEDITLIB is not defined in project options
                              (this minimizes finalization section).
                          (o) _NewControl
                              - BoundsRect initialized with a rectangle
                                (aParent.fMarginLeft, aParent.fMarginTop,
                                 aParent.fMarginLeft+64, aParent.fMargin+64)
                                rather then with (aParent.fMargin+aParent.fMarginLeft,
                                aParent.fMargin+aParent.fMarginTop,
                                aParent.fMargin+aParent.fMarginLeft+64,
                                aParent.fMargin+aParent.fMarginTop+64).
                                In most cases this is enough.
                          (o) Int2Hex
                              there are no check for second perameter > 15
                          (o) .... other see in code
  SMALLER_CODE          - like smallest code, but fuctionality is the same.
                          The speed can be lower therefore.
  SMALLEST_CODE_PARENTFONT - Parent font therefore is applied for child controls,
                             but initially only.
  NOT_USE_KOLMATH       - Only for _X_ (GTK + Linux): to prevent referencing
                          KOLmath in uses. This makes method TCanvas.Arc
                          unavailable, but the application become smaller.
  NOT_USE_EXCEPTIONS    - to prevent referencing unit ERR.PAS in uses even when
                          KOLmath is listed there.
  REDEFINE_ABS          - usual Abs works as a macro which is better in most
                          cases. But who knows...
  CUSTOM_APPICON        - when this option is defined, the resource name for the
                          application icon is extracted from a file
                          CusomAppIconRsrcName_PAS.inc (place it in your project
                          folder and type there name of the recource in qutations).
                          By default, string 'MAIN' is used like in usual Delphi
                          application.
  USE_NAMES             - to use property Name with any TObj. This makes also
                          available method TObj.FindObj( name ): PObj.
  UNIQUE_NAMES          - provide Name property to be unique among all siblings.
  USE_MHTOOLTIP         - to use KOLMHTOOLTIP.pas (actually it is not a separate
                          unit but a set of portions of code included into KOL.pas
                          in different places). This unit provides tooltips (hints)
                          for arbitrary controls which appear when mouse is over
                          such controls.
  USE_GRUSH             - to use ToGRush.pas unit, which provides automatic
                          redirection of the most cintrols creation functions
                          to the KOLGRushControls.pas.
  (USE_CONSTRUCTORS     - to use constructors like in VCL. Note: this option is
                          not carefully tested!)
  TLIST_FAST            - very fast implementation of TList (for coast of some
                          additional code).
  DFLT_TLIST_NOUSE_BLOCKS - for TLIST_FAST: by default, do not make all TList
                          objects using new (fast) algoritms, but only those of
                          TList objects, which property UseBlocks was set to
                          TRUE after creating it.
  STREAM_LARGE64        - turns on support of streams (and files) of size larger
                          then 4 Gbytes. Data type Int64 used for parameters of
                          the most of methods and functions in such case. (Note:
                          Int64 was introduced since Delphi5, so in earlier Delphi
                          versions using this symbol is not possible).
  STREAM_COMPAT         - still STREAM_LARGE64 appeared (in v2.84), most of
                          methods and functions declarations became incompatible
                          with earlier created extensions. This symbol provides
                          compatibility for such extensions, but it desables
                          using large streams.
  OLD_STREAM_CAPACITY   - to use elder TStream.SetCapacity algorithm (it did not
                          make Capacity smaller than already achieved, but in
                          newer version, Capacity can be set to a smaller value,
                          and for memory streams, rest of memory is freeing in
                          such case).
  OLD_MEMSTREAMS_SETSIZE - to use elder TStream.SetSize for memory streams. In
                          a new version, setting new size also changes Capacity
                          to the same value (in earlier case, a value for
                          Capacity property was calculated to become a bit
                          greater then a value set for Size property).
  OLD_COMPAT            - to use symbol ';' as a file list separator (all operations
                          using DoFileOp function such as DeleteFile2Recycle and
                          CopyMoveFiles).
  OLD_REGKEYGETSUBKEYS  - to use elder version of RegKeyGetSubKeys functions
                          (new version is faster).
  OLD_REGKEYGETVALUENAMES - to use elder version of RegKeyGetValueNames
                          (newer version is faster).
  USE_CUSTOMEXTENSIONS  - to extend TControl with custom additions.
  UNICODE_CTRLS         - to use Unicode versions of controls (WM_XXXXW messages,
                          etc.)
  SAFE_CODE             - use more safe code in some algorithms (but more slowly
                          and taking more code a bit).
  USE_OnIdle            - to use OnIdle event
  SNAPMOUSE2DFLTBTN     - for all MessageBox-based functions, snap mouse to
                          default button is provided if such option is on in
                          mouse driver settings.
  BUTTON_DBLCLICK       - to prevent clicking buttons with double click (separate
                          event OnMouseDblClk is fired in such case), this takes
                          smaller code but buttons can not be pressed with mouse
                          fast. When SMALLEST_CODE on, this option also is on.
  ALL_BUTTONS_RESPOND_TO_ENTER - obvious (by default, buttons respond to key
                        SPACE, since those are working this way in Windows).
  CLICK_DEFAULT_CANCEL_BTN_DIRECTLY - to prevent visual effect of default/cancel
                             button pressing with Enter/Escape keys. Also, button
                             don't become focused in such case.
  DEFAULT_CANCEL_BTN_EXCLUSIVE - to disable assigning to a button properties
                             DefaultBtn and CancelBtn simultaneously.
  NO_DEFAULT_BUTTON_BOLD - to prevent DefaultBtn to be visually with
                             a bold border.
  BITBTN_DISABLEDGLYPH2 - to restore old behaviour of multi-glyph bitbtn, when
                          index 2 was used to represent the button in disabled
                          state, and glyph with index 1 was used forpressed dtate.
                          Now by default index 1 corresponds to the disabled state,
                          and index 2 to the pressed state, i.e. these are swapped.
  ESC_CLOSE_DIALOGS     - to allow closing all dialogs with ESCAPE.
  KEY_PREVIEW           - form also receive WM_KEYDOWN (OnKeyDown event fired)
  SUPPORT_ONDEADCHAR    - to support OnKeyDeadChar event in responce to
                          WM_DEADCHAR, WM_SYSDEADCHAR
  OpenSaveDialog_Extended - to allow using custom extensions for OpenSaveDialog.
  AUTO_CONTEXT_HELP     - to use automatic respond to WM_CONTEXTMENU to call
                        context help.
  NOT_FIX_CURINDEX      - to use old version of TControl.SetItems, which could
                        lead to loose CurIndex value (e.g. for Combobox)
  NOT_FIX_MODAL         - not to fix modal (if fixed, click on any window
                          activates the application. If not fixed, code is
                          smaller very a little, but only click on modal form
                          activates the application). This does not fix calling
                          MsgBox though.
  MODAL_ACTIVATE_FIX    - if this option is set, all the windows of clicked app
                          with active modal form are brought to foreground, not
                          only modal form itself. This option is not necessary if
                          only two forms are visible at a time (the main form and
                          the active modal form).
  NEW_MODAL             - to use extended modalness.
  USE_SETMODALRESULT    - to guarantee ModalResult property assigning handling.
  USE_SHOWMODALPARENTED_ALWAYS - to use TControl.ShowModalParented( Applet )
                          instead of TControl.ShowModal always.
  USE_MENU_CURCTL       - to use CurCtl property in popup menu to detect which
                        control initiated a pop-up.
  NEW_MENU_ACCELL       - to use new menu accelerators handling, without
                        AcceleratorTable (not tested for all cases)
  USE_DROPDOWNCOUNT     - to force setting combobox dropdown count.
  NOT_UNLOAD_RICHEDITLIB - to stop unload Rich Edit library in finalization
                        section (to economy several byte of code).
  NOT_USE_RICHEDIT      - not use richedit (it will not be possible to create richedit)
  TV_DRAG_RBUTTON       - to allow dragging tree view items with right mouse
                          button too.
  TOOLBAR_FORCE_CHILDALIGN - this option provides Align working for child
                          controls of the toolbar control, but when with this option
                          is turned on it is impossible to have neighbour controls
                          on a form correctly aligned. This last disadvantage is
                          not important if a toolbar is always placed on a separate
                          panel-like control as a child.
                          Note: this option has no effect for Win9x, still use of
                          it under Win9x can crash the application!!!
  TOOLBAR_DOT_NOAUTOSIZE_BUTTON - this option forces prefix dot character in
                          button caption to be treated as an instruction to
                          remove TBSTYLE_AUTOSIZE from the button style. Actually,
                          this feature not necessary still custom button size can
                          be set even if such style is on for a button.
  CANRESIZE_THICKFRAME  - to use elder version of CanResize, changing border
                          style of the window (this cause incorrect form view in
                          Vista Aero theme (due a bug in Vista?)).
  ANCHORS_WM_SIZE       - to check WM_SIZE message in Anchor handling window
                          procedure. By default, now used WM_WINDOWPOSCHANGED.   
  USE_PROP              - to use GetProp / SetProp (old style) in place of
                          Get / SetWindowLong( wnd, GWL_USERDATA... ) (slower?)

  PROVIDE_EXITCODE      - PostQuitMessage( value ) assigns value to ExitCode
  INITIALFORMSIZE_FIXMENU - form size initially is really the same as defined at
                          design time even for forms having main menu bar
  USE_GRAPHCTLS         - to use graphic (non-windowed) controls
  RICHEDIT_XPBORDER     - provide correct drawing rich edit control border with
                          XP themes.
  GRAPHCTL_XPSTYLES     - to use XP themed Visual styles for drawing graphic
                          controls. This does not affect windowed controls
                          which visual style is controlled by the manifest.
                          This option also turns on RICHEDIT_XPBORDER option.
  GRAPHCTL_HOTTRACK     - to use hot-tracking also together with XP themed
                          graphic controls (otherwise only static XP themed
                          view is provided). Also, turn this option on if you
                          want to handle OnMouseEnter and OnMouseLeabe events
                          for graphic controls.
  NEW_OPEN_DIR_STYLE_EX - to use new code for TOpenDirDialog, which provides
                          correct working of the dialog with an option
                          odNewDialogStyle set (even in Windows 9x system).
  HTMLHELP_NOTOP        - when Html help is called, its window become a child of
                          the desktop, not application (in such case it is not
                          closed together with the application, and it is apper
                          not on top of the application).
  ICON_DIFF_WH          - to support icons having Width <> Height
  ICONLOAD_PRESERVEBMPS - when an icon is loaded, its bitmap and mask are
                          extracted and in case when such symbol is defined,
                          these one or two bitmaps are preserved until TIcon
                          object is destroyed.
  LOADEX                - to use TBitmap.LoadFromStreamEx while loading icon
                          from a stream or a file.
  USE_OLDCONVERT2MASK   - to use elder Convert2Mask method (newer is more correct).
  FIX_TRANSPBMPPALETTE  - for TBitmap.StretchDrawMasked, bitmaps with PixelFormat
                          = pf4bit or pf8bit are first converted (in a temporary
                          TBitmap object) to pf32bit, and then are drawn. This
                          fixes problems with palette usage for such DIB bitmaps.
  FILL_BROKEN_BITMAP    - TBitmap.LoadFromStreamEx: broken bitmaps rest of
                          scanlines are be filled with zeroes (usually black color)
                          rather then left containing trash memory bits.
  AUTO_REPLACE_CLEARTYPE- to replace automatically CLEARTYPE_QUALITY fonts
                          with ANTIALIASED_QUALITY when running under elder
                          Windows version than XP.
  FORCE_ALTERNATEFILENAME- TDirList.ScanDirectoryFORCE_ALTERNATEFILENAME - forced
                          using an alternate file path and filename for unicode
                          paths (   
                                )

  NEW_GRADIENT - to use new gradient painting by homm (fast).
  OLD_ALIGN    - to prevent using new Align by Galkov.
  NEW_ALIGN    - (default) - to use new Align implementation (faster).
  OLD_TRANSPARENT       - to prevent using NEW_TRANSPARENT
  NEW_TRANSPARENT       - created by Alexander Karpinsky a.k.a. homm (faster)
  SBOX_OLDPOS           - to use elder formulas to calculate scroll box positions
                          (just for compatibility with very old apps using it).
  OLD_REFCOUNT          - to prevent using new RefInc / RefDec behaviour
                          (new style of using RefCount works better).
  OLD_FREE              - to declare Free as a method as in earlier versions of KOL.
                          In new versions, Free is declared as a property, and
                          "calling" it just redirects call to RefDec. OLD_FREE
                          can be used for compatibility with compilers not
                          understanding "calling" a property without assigning
                          something to or from it (Turbo Delphi?).
  SCROLL_OLD            - for compatibility with the old applications using
                          TScrollBar: there was another method of adjusting
                          SBMax and SBPageSize: SBMax should be corrected to
                          (nMaxItems-1-SBPageSize).
  FILE_EXISTS_EX - to use more correct (but a bit large code in FileExists functon)
  USE_AUTOFREE4CONTROLS - (default) - from 2.40, most of control sub-objects are
                          destroying using Add2AutoFree (smaller code).
  NOT_USE_AUTOFREE4CONTROLS - this option returns to previous behaviour (just to
                          compare code size). Will be deprecated in future.
  ENDSESSION_HALT - to halt the process when WM_ENDSESSION comes.
  FILESTREAM_POSITION   - in PAS_VERSION, Stream..fData.fPosition always show
                          current position (for debug purposes)
  PSEUDO_THREADS        - to use pseudo-threads instead of normal threads.
  WAIT_SLEEP            - for PSEUDO_THREADS: sleep 10 ms in a
                          WaitForMultipleObjects loop.
  ENUM_DYN_HANDLERS_AFTER_RUN - to allow all the events handling even when
                        AppletTerminated become TRUE.
  STOP_WNDPROCTRANSPARENT_AFTER_APPLETTERMINATED - use this long-named otpion to
                          prevent any functionality of WndProcTransparent after
                          AppletTerminated is set to true.
  STOPTIMER_AFTER_APPLETTERMINATED - use this symbol to prevent timer event
                          firing after setting AppletTerminated to TRUE.
  TIMER_APPLETWND       - to use Applet window to handle WM_TIMER events
                          (otherwise special single invisible window is created
                          to handle such events).
  SUPPORT_LONG_TIMER    - LINUX only: set this option if TTimer.Interval can be
                          set to a value greater then 1,800,000 (30 minutes).
  DEBUG_MENU            - to debug menu.
  DEBUG_GDIOBJECTS      - to allow counting all the GDI objects used.
  CHK_BITBLT            - to check BitBlt operations.
  DEBUG_ENDSESSION      - to allow debugging WM_ENDSESSION handling.
  DEBUG_CREATEWINDOW    - to debug CreateWindow.
  CRASH_DEBUG           - to fill object memory with $DD before freeing it
                          (program really crashes when the object is
                          attempted to destroy more then once and in most
                          cases when a destroyed object is accessed after the
                          destruction).
  DEBUG_MCK             - specially designed to debug Mirror Classes Kit.
  DEBUG                 - other debugging.
  EXTERNAL_DEFINES      - if count of options necessary to set is very large
                          Delphi ignores past of those. To avoid this problem,
                          set only this option in Project's options, and place
                          all other options to ExternalDefines.inc file as a
                          sequence of {$DEFINE ... directives.
                          But note, such file should be located in a
                          project directory, but not in the directory where KOL.pas
                          is located. This is enough to provide different sets
                          of defines for each project.
  |</pre>
}
{= K.O.L -   . (C)  , 2000-2007.
}

//[OPTIONS]
{$A-} // align off, otherwise code is not good
{+}

{$Q-} // no overflow check: this option makes code wrong
{$R-} // no range checking: this option makes code wrong
{$T-} // not typed @-operator
//{$D+}
//______________________________________________________________________________
//
//{$DEFINE INPACKAGE} // Uncomment this line while rebuild MCK package
// for Delphi3 only, then restore the comment mark!!!!!!!!!!!!!!!!!!!!
//______________________________________________________________________________

{$IFDEF INPACKAGE} // use this symbol in packages requiring kol.pas
  {$WARNINGS OFF}
  {$DEFINE NOT_USE_AUTOFREE4CONTROLS}
  {$DEFINE PAS_VERSION}
  {$UNDEF ASM_VERSION}
  {$UNDEF ASM_UNICODE}
{$ENDIF}
{$IFDEF _D7orHigher}
  {$WARN UNSAFE_TYPE OFF} // Too many such warnings in Delphi7
  {$WARN UNSAFE_CODE OFF}
  {$WARN UNSAFE_CAST OFF}
{$ENDIF}

//[START OF INTERFACE]
interface

{$IFDEF NEW_ALIGN}
  {$UNDEF OLD_ALIGN}
{$ELSE}
  {$IFNDEF OLD_ALIGN}
    {$DEFINE NEW_ALIGN}
  {$ENDIF}
{$ENDIF}

{$IFDEF OLD_ALIGN}
  {$UNDEF NEW_ALIGN}
{$ELSE}
  {$IFNDEF NEW_ALIGN}
    {$DEFINE NEW_ALIGN}
  {$ENDIF}
{$ENDIF}

{$IFNDEF OLD_TRANSPARENT}
  {$DEFINE NEW_TRANSPARENT}
{$ENDIF}

{$IFNDEF NOT_USE_AUTOFREE4CONTROLS}
  {$DEFINE USE_AUTOFREE4CONTROLS}
  {$DEFINE USE_AUTOFREE4CHILDREN}
{$ENDIF}

{$IFDEF SMALLEST_CODE}
  {$DEFINE NOT_UNLOAD_RICHEDITLIB}
  {$DEFINE SMALLER_CODE}
{$ENDIF}

{$IFDEF NOT_USE_RICHEDIT}
  {$DEFINE NOT_UNLOAD_RICHEDITLIB}
{$ENDIF}

//{$DEFINE DEBUG_GDIOBJECTS}
//{$DEFINE CHK_GDI}

//[USES]
uses {$IFDEF WIN}messages, windows {$IFNDEF NOT_USE_RICHEDIT}, RichEdit {$ENDIF}{$ENDIF WIN}
     {$IFDEF LIN}, Libc, Xlib{$ENDIF}
     {$IFDEF GTK}, Glib2 , Gdk2, Gtk2, pango {$ENDIF GTK}
     {$IFDEF CHK_GDI}, ChkGdi {$ENDIF};
//[END OF USES]

{$IFDEF LIN}
  {$DEFINE global_declare} {$I KOL_Linux.inc} {$UNDEF global_declare}
////type HDC = TGC; // from Xlib (temporary definition?)
{$ENDIF LIN}


var
  AppTheming: Boolean;
{$IFDEF DEBUG_GDIOBJECTS}
var
  BrushCount: Integer;
  FontCount: Integer;
  PenCount: Integer;
{$ENDIF}

{$IFDEF UNICODE_CTRLS}
  {$IFDEF _D2}
    {$ERROR 'Delphi 2 cannot compile with UNICODE_CTRLS defined!'}
  {$ENDIF}
const
	SizeOfKOLChar = SizeOf(WideChar);

 type
	 KOLString = WideString;
         KOL_String = type WideString;
	 KOLChar = type WideChar;
	 PKOLChar = PWideChar;
         PKOL_Char = type PWideChar;
{$ELSE}
const
	SizeOfKOLChar = SizeOf(AnsiChar);

 type
	 KOLString = AnsiString;
         KOL_String = type AnsiString;
	 KOLChar = type AnsiChar;
	 PKOLChar = PAnsiChar;
         PKOL_Char = type PAnsiChar;
   {$IFDEF ASM_VERSION}
     {$IFNDEF ASM_NOUNICODE}
       {$DEFINE ASM_UNICODE}
     {$ENDIF}
     {$UNDEF PAS_VERSION}
   {$ENDIF}
{$ENDIF}

{$IFNDEF ASM_VERSION}
  {$DEFINE PAS_VERSION}
{$ENDIF ASM_VERSION}

{BCB++}(*type DWORD = Windows.DWORD;*){--BCB}

{$IFDEF WIN}
//{_#IF [DELPHI]}
{$INCLUDE delphicommctrl.inc}
{$IFDEF UNICODE_CTRLS}
  {$DEFINE interface_part} {$I KOL_unicode.inc} {$UNDEF interface_part}
{$ELSE} // ANSI_CTRLS
  {$DEFINE interface_part} {$I KOL_ansi.inc} {$UNDEF interface_part}
{$ENDIF UNICODE_CTRLS}
//{_#ENDIF}
{$ENDIF WIN}

type
//[_TObj DEFINITION]

{-}
   _TObj = object
   {* auxiliary object type. See TObj. }
   protected
     procedure Init; virtual;
     {* Is called from a constructor to initialize created object instance
        filling its fields with 0. Can be overriden in descendant objects
        to add another initialization code there. (Main reason of intending
        is what constructors can not be virtual in poor objects). }
     {=    . }
   public
     function VmtAddr: Pointer;
     {* Returns addres of virtual methods table of object. ? }
     {=      (VMT). ? }
   end;
{+}

  {++}(* TObj = class;*){--}
  PObj = {-}^{+}TObj;
  {* }

  {++}(* TList = class;*){--}
  PList = {-}^{+}TList;
  {* }

//[TObjectMethod DECLARATION]
  TObjectMethod = procedure of object;
  {* }
  TOnEvent = procedure( Sender: PObj ) of object;
  {* This type of event is the most common - event handler when called can
     know only what object was a sender of this call. Replaces good known
     VCL TNotifyEvent event type. }

  TOnEventMoving = procedure( Sender: PObj; P: PRect ) of object;

//[TPointerList DECLARATION]
   PPointerList = ^TPointerList;
   TPointerList = array[0..MaxInt div 4 - 1] of Pointer;

{ ---------------------------------------------------------------------
                  TObj - base object to derive all others
---------------------------------------------------------------------- }
//[TObj DEFINITION]
   TObj = {-} object( _TObj ) {+}{++}(*class*){--}
   {* Prototype for all objects of KOL. All its methods are important to
      implement objects in a manner similar to Delphi TObject class. }
   {=       KOL. }
   protected
     fRefCount: Integer;
     fOnDestroy: TOnEvent;
     {$IFDEF OLD_REFCOUNT}
     procedure DoDestroy;
     {$ENDIF}
   protected
     fAutoFree: PList;
     {* Is called from a constructor to initialize created object instance
        filling its fields with 0. Can be overriden in descendant objects
        to add another initialization code there. (Main reason of intending
        is what constructors can not be virtual in poor objects). }
     {=    . }
     fTag: DWORD;
     {* Custom data. }
   public
     destructor Destroy; {-} virtual; {+}{++}(* override; *){--}
     {* Disposes memory, allocated to an object. Does not release huge strings,
        dynamic arrays and so on. Such memory should be freeing in overriden
        destructor. }
     {=  ,   .   , 
         ,    ..     
           . }
   {++}(*protected*){--}
     {++}(*
     procedure Init; virtual;
     {* Can be overriden in descendant objects
        to add initialization code there. (Main reason of intending
        is what constructors can not be virtual in poor objects). }
     *){--}
     procedure Final;
     {* It is called in destructor to perform OnDestroy event call and to
        released objects, added to fAutoFree list. }
   public
     procedure RefInc;
     {* See comments below. }
     {= . RefDec . }
     function RefDec: Integer;
     {* Decrements reference count. If it is becoming <0, and Free
        method was already called, object is (self-) destroyed. Otherwise,
        Free method does not destroy object, but only sets flag
        "Free was called".
     |<br>
        Use RefInc..RefDec to provide a block of code, where
        object can not be destroyed by call of Free method.
        This makes code more safe from intersecting flows of processing,
        where some code want to destroy object, but others suppose that it
        is yet existing.
     |<br>
        If You want to release object at the end of block RefInc..RefDec,
        do it immediately BEFORE call of last RefDec (to avoid situation,
        when object is released in result of RefDec, and attempt to
        destroy it follow leads to AV exception).
     |<br>
         Actually, this "function" is a procedure and does not return
         any sensible value. It is declared as a function for internal
         needs (to avoid creating separate code for Free method)
     }
     {=   .     
        < 0,   Free   ,  (-) . ,
         Free   ,     "Free 
        ".
        |<br>
         RefInc..RefDec     
           (   ).
        |<br>
           ()     RefDec, 
         Free    RefDec. }
     property RefCount: Integer read fRefCount;
     {* }
     {$IFDEF OLD_FREE}
     procedure Free;
     {$ELSE NEW_FREE}
     property Free: Integer read RefDec;
     {* Before calling destructor of object, checks if passed pointer is not
        nil - similar what is done in VCL for TObject. It is ALWAYS recommended
        to use Free instead of Destroy - see also comments to RefInc, RefDec. }
     {=   , ,    nil   .
           Free  Destroy - .   RefInc,
        RefDec. }
     {$ENDIF NEW_FREE}

     {-}
     // By Vyacheslav Gavrik:
     function InstanceSize: Integer;
     {* Returns a size of object instance. }
     {+}

     constructor Create;
     {* Constructor. Do not call it. Instead, use New<objectname> function
        call for certain object, e.g., NewLabel( AParent, 'caption' ); }
     {= .    .   ,
            New<->. ,
        NewLabel( MyForm, '1' ); }
     {-}
     class function AncestorOfObject( Obj: Pointer ): Boolean;
     {* Is intended to replace 'is' operator, which is not applicable to objects. }
     {= }
     function VmtAddr: Pointer;
     {* Returns addres of virtual methods table of object. }
     {=      (VMT). }
     {+}
     property OnDestroy: TOnEvent read fOnDestroy write fOnDestroy;
     {* This event is provided for any KOL object, so You can provide your own
        OnDestroy event for it. }
     {=       KOL.  
        -     . }
    procedure Add2AutoFree( Obj: PObj );
    {* Adds an object to the list of objects, destroyed automatically
       when the object is destroyed. Do not add here child controls of
       the TControl (these are destroyed by another way). Only non-control
       objects, which are not destroyed automatically, should be added here. }
    procedure Add2AutoFreeEx( Proc: TObjectMethod );
    {* Adds an event handler to the list of events, called in destructor.
       This method is mainly for internal use, and allows to auto-destroy
       VCL components, located on KOL form at design time (in MCK project). }
    procedure RemoveFromAutoFree( Obj: PObj );
    {* Removes an object from auto-free list }
    procedure RemoveFromAutoFreeEx( Proc: TObjectMethod );
    {* Removes a procedure from auto-free list }
    property Tag: DWORD read fTag write fTag;
    {* Custom data field. }
   protected
     {$IFDEF USE_NAMES}
     fName: AnsiString;
     fNamedObjList: Plist;
     fOwnerObj: PObj;
     {$ENDIF}
   public
     {$IFDEF USE_NAMES}
     procedure SetName( NewOwnerObj: PObj; NewName: AnsiString);
     property  Name: Ansistring read FName;

     property  NamedObjList : PList read fNamedObjList;
     property  OwnerObj: PObj read FOwnerObj;
     function  FindObj(const ObjName: Ansistring): PObj;
     {$ENDIF}
   end;
//[END OF TObj DEFINITION]

{ ---------------------------------------------------------------------
        TList - object to implement list of pointers (or dwords)
---------------------------------------------------------------------- }
//[TList DEFINITION]
  TList = object( TObj )
  {* Simple list of pointers. It is used in KOL instead of standard VCL
     TList to store any kind data (or pointers to these ones). Can be created
     calling function NewList. }
  {=   . }
  protected
    fItems: PPointerList;
    fCount: Integer;
    fCapacity: Integer;
    fAddBy: Integer;
    procedure SetCount(const Value: Integer);
    procedure SetAddBy(Value: Integer);
  {++}(*public*){--}
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* Destroys list, freeing memory, allocated for pointers. Programmer
       is resposible for destroying of data, referenced by the pointers. }
    {= }
  {++}(*protected*){--}
    procedure SetCapacity( Value: Integer );
    function Get( Idx: Integer ): Pointer;
    procedure Put( Idx: Integer; Value: Pointer );
    {$IFDEF USE_CONSTRUCTORS}
    procedure Init; virtual;
    {$ENDIF}
  protected
    {$IFDEF TLIST_FAST}
    fBlockList: PList;
    fLastKnownBlockIdx: Integer;
    fLastKnownCountBefore: Integer;
    fUseBlocks: Boolean;
    {$ENDIF}
  public
    procedure Clear;
    {* Makes Count equal to 0. Not responsible for freeing (or destroying)
       data, referenced by released pointers. }
    procedure Add( Value: Pointer );
    {* Adds pointer to the end of list, increasing Count by one. }
    procedure Insert( Idx: Integer; Value: Pointer );
    {* Inserts pointer before given item. Returns Idx, i.e. index of
       inserted item in the list. Indeces of items, located after insertion
       point, are increasing. To add item to the end of list, pass Count
       as index parameter. To insert item before first item, pass 0 there. }
    function IndexOf( Value: Pointer ): Integer;
    {* Searches first (from start) item pointer with given value and returns
       its index (zero-based) if found. If not found, returns -1. }
    procedure Delete( Idx: Integer );
    {* Deletes given (by index) pointer item from the list, shifting all
       follow item indeces up by one. }
    procedure DeleteRange( Idx, Len: Integer );
    {* Deletes Len items starting from Idx. }
    procedure Remove( Value: Pointer );
    {* Removes first entry of a Value in the list. }
    property Count: Integer read fCount write SetCount;
    {* Returns count of items in the list. It is possible to delete a number
       of items at the end of the list, keeping only first Count items alive,
       assigning new value to Count property (less then Count it is). }
    property Capacity: Integer read fCapacity write SetCapacity;
    {* Returns number of pointers which could be stored in the list
       without reallocating of memory. It is possible change this value
       for optimize usage of the list (for minimize number of reallocating
       memory operations). }
    property Items[ Idx: Integer ]: Pointer read Get write Put; default;
    {* Provides access (read and write) to items of the list. Please note,
       that TList is not responsible for freeing memory, referenced by stored
       pointers. }
    function Last: Pointer;
    {* Returns the last item (or nil, if the list is empty). }
    procedure Swap( Idx1, Idx2: Integer );
    {* Swaps two items in list directly (fast, but without testing of
       index bounds). }
    procedure MoveItem( OldIdx, NewIdx: Integer );
    {* Moves item to new position. Pass NewIdx >= Count to move item
       after the last one. }
    procedure Release;
    {* Especially for lists of pointers to dynamically allocated memory.
       Releases all pointed memory blocks and destroys object itself. }
    procedure ReleaseObjects;
    {* Especially for a list of objects derived from TObj.
       Calls Free for every of the object in the list, and then calls
       Free for the object itself. }
    property AddBy: Integer read fAddBy write SetAddBy;
    {* Value to increment capacity when new items are added or inserted
       and capacity need to be increased. }
    property DataMemory: PPointerList read fItems;
    {* Raw data memory. Can be used for direct access to items of a list.
       Do not use it for TLIST_FAST ! }
    procedure Assign( SrcList: PList );
    {* Copies all source list items. }
    {$IFDEF _D4orHigher}
    procedure AddItems( const AItems: array of Pointer );
    {* Adds a list of items given by a dynamic array. }
    {$ENDIF}
    function ItemAddress( Idx: Integer ): Pointer;
    {* Returns an address of memory occupying by the item with index Idx.
       (If the item is a pointer, returned value is a pointer to a pointer).
       Item with index requested must exist. }
  {$IFDEF TLIST_FAST}
    property UseBlocks: Boolean read fUseBlocks write fUseBlocks;
  {$ENDIF}
  end;
//[END OF TList DEFINITION]

//[NewList DECLARATION]
function NewList: PList;
{* Returns pointer to newly created TList object. Use it instead usual
   TList.Create as it is done in VCL or XCL. }

{$IFDEF _D4orHigher}
function NewListInit( const AItems: array of Pointer ): PList;
{* Creates a list filling it initially with certain Items. }
{$ENDIF}

{$IFNDEF TLIST_FAST}
procedure FastIncNum2Elements( List: TList; FromIdx, Count, Value: Integer );
{* Very fast adds Value to List elements from List[FromIdx] to List[FromIdx+Count-1].
   Given elements must exist. Count must be > 0. }
{$ENDIF}

procedure Free_And_Nil( var Obj );
{* Obj.Free and Obj := nil, where Obj *MUST* be TObj or its descendant
   (TControl, TMenu, etc.) This procedure is not compatible with VCL's
   FreeAndNil, which works with TObject, since this it has another name. }


//[DummyObjProc, DummyObjProcParam DECLARATION]
procedure DummyObjProc( Sender: PObj );
procedure DummyObjProcParam( Sender: PObj; Param: Pointer );

{$IFDEF WIN_GDI}
{ --- threads --- }
//[THREADS]

const
  ABOVE_NORMAL_PRIORITY_CLASS = $8000; // only for Windows 2K
  BELOW_NORMAL_PRIORITY_CLASS = $4000; // and higher !

type
  {++}(*TThread = class;*){--}
  PThread = {-}^{+}TThread;

  TThreadMethod = procedure of object;
  TThreadMethodEx = procedure( Sender: PThread; Param: Pointer ) of object;

  TOnThreadExecute = function(Sender: PThread): Integer of object;
  {* Event to be called when Execute method is called for TThread }

{ ---------------------------------------------------------------------
                            TThread object
---------------------------------------------------------------------- }
//[TThread DEFINITION]
  TThread = object(TObj)
  private
    function GetPriorityBoost: Boolean;
    procedure SetPriorityBoost(const Value: Boolean);
  {* Thread object. It is possible not to derive Your own thread-based
     object, but instead create thread Suspended and assign event
     OnExecute. To create, use one of NewThread of NewThreadEx functions,
     or derive Your own descendant object and write creation function
     (or constructor) for it.
     |<br><br>
     Aknowledgements. Originally class ZThread was developed for XCL:
     |<br> * By: Tim Slusher : junior@nlcomm.com
     |<br> * Home: http://www.nlcomm.com/~junior
   }
  protected
    FSuspended,
    FTerminated: Boolean;
    FHandle: THandle;
    FThreadId: DWORD;
    FOnSuspend: TObjectMethod;
    FOnResume: TOnEvent;
    FData : Pointer;
    FOnExecute : TOnThreadExecute;
    FMethod: TThreadMethod;
    FMethodEx: TThreadMethodEx;
    F_AutoFree: Boolean;
    FPriority: Integer;
    function GetPriorityCls: Integer;
    function GetThrdPriority: Integer;
    procedure SetPriorityCls(Value: Integer);
    procedure SetThrdPriority(Value: Integer);
    procedure Init; virtual;
  {++}(*public*){--}
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* }
  public
    {$IFDEF PSEUDO_THREADS}
    FPrtyCls: Integer;
    DoNotWakeUntil: DWORD;
    AllThreads: PList;        // only for MainThread
    CurrentThread: PThread;
    StackBottom: Pointer;     // except for MainThread
    CurStackPos: Pointer;
    Stack_Empty: Boolean;
    procedure SwitchToThread( T: PThread ); // methods of MainThread
    procedure NextThread;
    {$ENDIF}
  public
    FResult: Integer;
    function Execute: integer; virtual;
    {* Executes thread. Do not call this method from another thread! (Even do
       not call this method at all!) Instead, use Resume.
       |<br>
       Note also that in contrast to VCL, it is not necessary to create your
       own descendant object from TThread and override Execute method. In KOL,
       it is sufficient to create an instance of TThread object (see NewThread,
       NewThreadEx, NewThreadAutoFree functions) and assign OnExecute event
       handler for it. }
    procedure Resume;
    {* Continues executing. It is necessary to make call for every
       nested Suspend. }
    procedure Suspend;
    {* Suspends thread until it will be resumed. Can be called from another
       thread or from the thread itself. }
    procedure Terminate;
    {* Terminates thread. }
    function WaitFor: Integer;
    {* Waits (infinitively) until thead will be finished. }
    function WaitForTime( T: DWORD ): Integer;
    {* Waits (T milliseconds) until thead will be finished. }

    property Handle: THandle read FHandle;
    {* Thread handle. It is created immediately when object is created
       (using NewThread). }
    property Suspended: Boolean read FSuspended;
    {* True, if suspended. }
    property Terminated: Boolean read FTerminated;
    {* True, if terminated. }
    property ThreadId: DWORD read FThreadId;
    {* Thread id. }
    property PriorityClass: Integer read GetPriorityCls write SetPriorityCls;
    {* Thread priority class. One of following values: HIGH_PRIORITY_CLASS,
       IDLE_PRIORITY_CLASS, NORMAL_PRIORITY_CLASS, REALTIME_PRIORITY_CLASS. }
    property ThreadPriority: Integer read GetThrdPriority write SetThrdPriority;
    {* Thread priority value. One of following values: THREAD_PRIORITY_ABOVE_NORMAL,
       THREAD_PRIORITY_BELOW_NORMAL, THREAD_PRIORITY_HIGHEST, THREAD_PRIORITY_IDLE,
       THREAD_PRIORITY_LOWEST, THREAD_PRIORITY_NORMAL, THREAD_PRIORITY_TIME_CRITICAL. }
    property Data : Pointer read FData write FData;
    {* Custom data pointer. Use it for Youe own purpose. }

    property OnExecute: TOnThreadExecute read FOnExecute write FOnExecute;
    {* Is called, when Execute is starting. }
    property OnSuspend: TObjectMethod read FOnSuspend write FOnSuspend;
    {* Is called, when Suspend is performed. }
    property OnResume: TOnEvent read FOnResume write FOnResume;
    {* Is called, when resumed. }
    procedure Synchronize( Method: TThreadMethod );
    {* Call it to execute given method in main thread context. Applet variable
       must exist for that time. }
    procedure SynchronizeEx( Method: TThreadMethodEx; Param: Pointer );
    {* Call it to execute given method in main thread context, with a given
       parameter. Applet variable must exist for that time. Param must not be nil. }
    {$IFDEF USE_CONSTRUCTORS}
    constructor ThreadCreate;
    constructor ThreadCreateEx( const Proc: TOnThreadExecute );
    {$ENDIF USE_CONSTRUCTORS}

    property AutoFree: Boolean read F_AutoFree write F_AutoFree;
    {* Set this property to true to provide automatic destroying of thread
       object when its executing is finished. }
    property PriorityBoost: Boolean read GetPriorityBoost write SetPriorityBoost;
    {* By default, priority boost is enabled for all threads. }
  end;
//[END OF TThread DEFINITION]

//[NewThread, NewThreadEx, NewThreadAutoFree DECLARATIONS]
function NewThread: PThread;
{* Creates thread object (always suspended). After creating, set event
   OnExecute and perform Resume operation. }

function NewThreadEx( const Proc: TOnThreadExecute ): PThread; stdcall;
{* Creates thread object, assigns Proc to its OnExecute event and runs
   it. }

function NewThreadAutoFree( const Proc: TOnThreadExecute ): PThread;
{* Creates thread object similar to NewThreadEx, but freeing automatically
   when executing of such thread finished. Be sure that a thread is resumed
   at least to provide its object keeper freeing. }

{$IFDEF PSEUDO_THREADS}
var MainThread: PThread;
    PseudoThreadStackSize: DWORD = 1024 * 1024;
    CreatingMainThread: Boolean;

function WaitForSingleObject( hHandle: THandle; dwMilliseconds: DWORD ): DWORD; stdcall;
function WaitForMultipleObjects( nCount: DWORD;
  lpHandles: PHandle; fWaitAll: BOOL; dwMilliseconds: DWORD ): DWORD; stdcall;
procedure Sleep( n: DWORD );
{$ENDIF}

{ -- streams -- }
//[STREAMS]

{$ENDIF WIN_GDI}
type
  TMoveMethod = ( spBegin, spCurrent, spEnd );
{$IFDEF WIN_GDI}
type
  {$IFDEF STREAM_LARGE64}
  TStrmSize = Int64;
  TStrmMove = Int64;
    {$UNDEF ASM_STREAM}
    {$UNDEF STREAM_COMPAT}
  {$ELSE}
  TStrmSize = DWORD;
  TStrmMove = Integer;
    {$IFDEF ASM_VERSION}
      {$IFNDEF ASM_NOSTREAM}
        {$DEFINE ASM_STREAM}
      {$ENDIF}
    {$ENDIF}
  {$ENDIF}

  {++}(*TStream = class;*){--}
  PStream = {-}^{+}TStream;

  PStreamMethods = ^TStreamMethods;
  TStreamMethods = Packed Record
    fSeek: function( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveMethod: TMoveMethod ): TStrmSize;
    fGetSiz: function( Strm: PStream ): TStrmSize;
    fSetSiz: procedure( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Value: TStrmSize );
    fRead: function( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
    fWrite: function( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
    fClose: procedure( Strm: PStream );
    fCustom: Pointer;
    fWait: procedure( Strm: PStream );
  end;

  TStreamData = Packed Record
    fHandle: THandle;
    fCapacity, fSize, fPosition: TStrmSize;
    fThread: PThread;
    CASE Integer OF
    2: (
         fStream1,
         fStream2: PStream;
       );
    3: (
         fBaseStream: PStream;
         fFromPos: TStrmSize;
       )
  end;

{ ---------------------------------------------------------------------
                TStream - streaming objects incapsulation
---------------------------------------------------------------------- }
//[TStream DEFINITION]
  TStream = object(TObj)
  {* Simple stream object. Can be opened for file, or as memory stream (see
     NewReadFileStream, NewWriteFileStream, NewMemoryStream, etc.). And, another
     type of streaming object can be derived (without inheriting new object
     type, just by writing another New...Stream method, which calls
     _NewStream and pass methods record to it). }
  protected
    fPMethods: PStreamMethods;
    fMethods: TStreamMethods;
    fMemory: Pointer;
    fData: TStreamData;
    fParam1, fParam2: TStrmMove; // parameters to use in thread
    fOnChangePos: TOnEvent;
    function GetCapacity: TStrmSize;
    procedure SetCapacity(const Value: TStrmSize);
    function DoAsyncRead( Sender: PThread ): Integer;
    function DoAsyncWrite( Sender: PThread ): Integer;
    function DoAsyncSeek( Sender: PThread ): Integer;
  protected
    function GetFileStreamHandle: THandle;
    procedure SetPosition(const Value: TStrmSize);
    function GetPosition: TStrmSize;
    function GetSize: TStrmSize;
    procedure SetSize(const NewSize: TStrmSize);
  {++}(*public*){--}
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
  public
    function Read(var Buffer; const Count: TStrmSize): TStrmSize;
    {* Reads Count bytes from a stream. Returns number of bytes read. }
    function Seek({$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveMethod: TMoveMethod): TStrmSize;
    {* Allows to change current position or to obtain it. Property
       Position uses this method both for get and set position. }
    function Write(var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize): TStrmSize;
    {* Writes Count bytes from Buffer, starting from current position
       in a stream. Returns how much bytes are written. }
    function WriteVal( Value: DWORD; Count: DWORD ): DWORD;
    {* Writes maximum 4 bytes of Value to a stream. Allows writing constants
       easier than via Write. }
    function WriteStr( S: AnsiString ): DWORD;
    {* Writes string to the stream, not including ending #0. Exactly
       Length( S ) characters are written. }
    function WriteStrZ( S: AnsiString ): DWORD;
    {* Writes string, adding #0. Number of bytes written is returned. }
    {$IFDEF _D3orHigher}
    function WriteWStrZ( S: WideString ): DWORD;
    {* Writes string, adding #0. Number of bytes written is returned. }
    {$ENDIF}
    function ReadStrZ: AnsiString;
    {* Reads string, finished by #0. After reading, current position in
       the stream is set to the byte, follows #0. }
    {$IFDEF _D3orHigher}
    function ReadWStrZ: WideString;
    {* Reads string, finished by #0. After reading, current position in
       the stream is set to the byte, follows #0. }
    {$ENDIF}
    function ReadStr: AnsiString;
    {* Reads string, finished by #13, #10 or #13#10 symbols. Terminating symbols
       #13 and/or #10 are not added to the end of returned string though
       stream positioned follow it. }
    function ReadStrLen( Len: Integer ): AnsiString;
    {* Reads string of the given length Len. }
    function WriteStrEx(S: AnsiString): DWord;
    {* Writes string S to stream, also saving its size for future use by
       ReadStrEx* functions. Returns number of actually written characters. }
    function ReadStrExVar(var S: AnsiString): DWord;
    {* Reads string from stream and assigns it to S.
       Returns number of actually read characters.
       Note:
         String must be written by using WriteStrEx function.
         Return value is count of characters READ, not the length of string. }
    function ReadStrEx: AnsiString;
    {* Reads string from stream and returns it. }
    function WriteStrPas( S: AnsiString ): DWORD;
    {* Writes a string in Pascal short string format - 1 byte length, then string
       itself without trailing #0 char. S parameter length should not exceed 255
       chars, rest chars are truncated while writing. Total amount of bytes
       written is returned. }
    function ReadStrPas: AnsiString;
    {* Reads 1 byte from a stream, then treat it as a length of following string
       which is read and returned. A purpose of this function is reading strings
       written using WriteStrPas. }
    property Size: TStrmSize read GetSize write SetSize;
    {* Returns stream size. For some custom streams, can be slow
       operation, or even always return undefined value (-1 recommended). }
    property Position: TStrmSize read GetPosition write SetPosition;
    {* Current position. }

    property Memory: Pointer read fMemory;
    {* Only for memory stream. }
    property Handle: THandle read GetFileStreamHandle;
    {* Only for file stream. It is possible to check that Handle <>
       INVALID_HANDLE_VALUE to ensure that file stream is created OK. }

    //---------- for asynchronous operations (using thread - not tested):
    procedure SeekAsync(MoveTo: TStrmMove; MoveMethod: TMoveMethod);
    {* Changes current position asynchronously. To wait for finishing the
       operation, use method Wait. }
    procedure ReadAsync(var Buffer; Count: DWord);
    {* Reads Count bytes from a stream asynchronously. To wait finishing the
       operation, use method Wait. }
    procedure WriteAsync(var Buffer; Count: DWord);
    {* Writes Count bytes from Buffer, starting from current position
       in a stream - asynchronously. To wait finishing the operation,
       use method Wait. }
    function Busy: Boolean;
    {* Returns TRUE until finishing the last asynchronous operation
       started by calling SeekAsync, ReadAsync, WriteAsync methods. }
    procedure Wait;
    {* Waits for finishing the last asynchronous operation. }

    property Methods: PStreamMethods read fPMethods;
    {* Pointer to TStreamMethods record. Useful to implement custom-defined
       streams, which can access its fCustom field, or even to change
       methods when necessary. }
    property Data: TStreamData read fData;
    {* Pointer to TStreamData record. Useful to implement custom-defined
    streams, which can access Data fields directly when implemented. }

    property Capacity: TStrmSize read GetCapacity write SetCapacity;
    {* Amound of memory allocated for data (MemoryStream). }

    procedure SaveToFile( const Filename: KOLString; const Start, CountSave: TStrmSize );
    {* }

    property OnChangePos: TOnEvent read fOnChangePos write fOnChangePos;
    {* To allow using this event, create stream with special constructing
       function like NewMemoryStreamWithEvent or NewReadFileStreamWithEvent,
       or replace reading / writing methods to certain supporting OnChangePos
       event. }
  end;
//[END OF TStream DEFINITION]

//[_NewStream DECLARATION]
function _NewStream( const StreamMethods: TStreamMethods ): PStream;
{* Use this method only to define your own stream type. See also declared
   below (in KOL.pas) methods used to implement standard KOL streams. You can use it in
   your code to create streams, which are partially based on standard
   methods. }

// Methods below are declared here to simplify creating your
// own streams with some methods standard and some non-standard
// together:
function SeekFileStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveFrom: TMoveMethod ): TStrmSize;
function GetSizeFileStream( Strm: PStream ): TStrmSize;
function ReadFileStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
function ReadFileStreamWithEvent( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
var ReadFileStreamProc: function( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize
    = ReadFileStream;

function WriteFileStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
function WriteFileStreamWithEvent( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
function WriteFileStreamEOF( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
function WriteFileStreamEOFWithEvent( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
procedure CloseFileStream( Strm: PStream );
function SeekMemStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveFrom: TMoveMethod ): TStrmSize;
function SeekMemStreamWithEvent( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveFrom: TMoveMethod ): TStrmSize;
function GetSizeMemStream( Strm: PStream ): TStrmSize;

var CapacityMask: DWORD = $4000 - 1; // must be 2**n-1
procedure SetSizeMemStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} NewSize: TStrmSize );
function ReadMemStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
function ReadMemStreamWithEvent( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
function WriteMemStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
function WriteMemStreamWithEvent( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
procedure CloseMemStream( Strm: PStream );
procedure SetSizeFileStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} NewSize: TStrmSize );

function SeekConcatStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveFrom: TMoveMethod ): TStrmSize;
function GetSizeConcatStream( Strm: PStream ): TStrmSize;
procedure SetSizeConcatStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} NewSize: TStrmSize );
function ReadConcatStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
function WriteConcatStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
procedure CloseConcatStream( Strm: PStream );

function SeekSubStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveFrom: TMoveMethod ): TStrmSize;
function GetSizeSubStream( Strm: PStream ): TStrmSize;
procedure SetSizeSubStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} NewSize: TStrmSize );
function ReadSubStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
function WriteSubStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
procedure CloseSubStream( Strm: PStream );

procedure DummyCloseStream( Strm: PStream );

function DummyReadWrite( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
procedure DummySetSize( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Value: TStrmSize );
procedure DummyStreamProc(Strm: PStream);

//[NewFileStream DECLARATION]
function NewFileStream( const FileName: KOLString; Options: DWORD ): PStream;
{* Creates file stream for read and write. Exact set of open attributes
   should be passed through Options parameter (see FileCreate where those
   flags are listed). }

function NewFileStreamWithEvent( const FileName: KOLString; Options: DWORD ): PStream;
{* Creates file stream for read and write. Exact set of open attributes
   should be passed through Options parameter (see FileCreate where those
   flags are listed). Also, resulting stream is supporting OnChangePos event. }

function NewReadFileStream( const FileName: KOLString ): PStream;
{* Creates file stream for read only. }

function NewReadFileStreamWithEvent( const FileName: KOLString ): PStream;
{* Creates file stream for read only, supporting OnChangePos event. }

function NewWriteFileStream( const FileName: KOLString ): PStream;
{* Creates file stream for write only. Truncating of file (if needed)
   is provided automatically. }

function NewWriteFileStreamWithEvent( const FileName: KOLString ): PStream;
{* Creates file stream for write only. Truncating of file (if needed)
   is provided automatically. Created stream supports OnChangePos event. }

function NewReadWriteFileStream( const FileName: KOLString ): PStream;
{* Creates stream for read and write file. To truncate file, if it is
   necessary, change Size property. }

{$IFDEF _D3orHigher}
function NewReadFileStreamW( const FileName: WideString ): PStream;
{* Creates file stream for read only. }

function NewWriteFileStreamW( const FileName: WideString ): PStream;
{* Creates file stream for write only. Truncating of file (if needed)
   is provided automatically. }

function NewReadWriteFileStreamW( const FileName: WideString ): PStream;
{* Creates stream for read and write file. To truncate file, if it is
   necessary, change Size property. }
{$ENDIF}

function NewExFileStream( F: HFile ): PStream;
{* Creates read only stream to read from opened file or pipe from the current
   position.
   When stream is destroyed, file handle still not closed (your code should do
   this) and file position is not changed (after the last read operation). }

//[NewMemoryStream DECLARATION]
function NewMemoryStream: PStream;
{* Creates memory stream (read and write). }

function NewMemoryStreamWithEvent: PStream;
{* Creates memory stream (read and write). Created stream support OnChangePos
   event. }

function NewExMemoryStream( ExistingMem: Pointer; Size: DWORD ): PStream;
{* Creates memory stream on base of existing memory. It is not possible
   to write out of top bound given by Size (i.e. memory can not be resized,
   or reallocated. When stream object is destroyed this memory is not freed. }

function NewConcatStream( Stream1, Stream2: PStream ): PStream;
{* Creates a stream which is a concatenation of two source stream. After
   the call, both source streams are belonging to the resulting stream and these
   will be destroyed together with the resulting stream. (So forget about it).

   After the call, first stream will not be changed in size via methods of
   concatenated stream (and it is not recommended to use further Stream1 and
   Stream2 methods too). But Stream2 can still be increased, if it allows doing
   so when some data are appended or Size of resulting stream is changed (but
   not less then Stream1.Size).

   Nature and physical location of Stream1 and Stream2 are not important and
   can be absolutely different. But it is supposed that both streams are not
   compressed and its Size is known always and Seek operation is valid.

   This function accepts recursive (multi-level) usage: resulting concatenation
   stream can be used as a left or right parameter to create another concatenation
   stream later, so it is possible to build a tree of streams concatenated,
   concatenating this way several different streams and use it as a single
   data streaming object.
}

function NewSubStream( BaseStream: PStream; const FromPos, Size: TStrmSize ): PStream;
{* Creates a stream which is a subpart of BaseStream passes, starting from
   FromPos and with given Size. Like in function NewConcatStream, passes
   BaseStream become owned by newly created sub-stream object, and will be
   destroyed automatically together with a sub-stream.

   If you want to provide more long life time for a base stream (e.g. if you
   plan to use it after a sub-stream based on it is destroyed), use method
   RefInc for base stream once to prevent it from destroying when the sub-stream
   is destroyed.

   Note: be careful and avoid direct calling methods and properties of the base
   stream, while you have a sub-stream created on base it, since the sub-stream
   actually redirects all the requests to the parent base stream.

   Sub-stream accepts setting Size to greater value later, and if some data
   are written to it, it is written actually to the base stream, and when it
   is written beyond the end position, this will increase size of the base
   stream too (and if it is a file stream, this also will increase size of the
   file on which the base stream was created).

   This function accepts recursive (multi-level) usage: it is possible to create
   later another sub-stream on base of existing sub-stream, still it is actully
   can be treated as usual stream.
}

//[Stream2Stream DECLARATION]
function Stream2Stream( Dst, Src: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
{* Copies Count (or less, if the rest of Src is not sufficiently long)
   bytes from Src to Dst, but with optimizing in cases, when Src or/and
   Dst are memory streams (intermediate buffer is not allocated). }
function Stream2StreamEx( Dst, Src: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
{* Copies Count bytes from Src to Dst, but without any optimization.
   Unlike Stream2Stream function, it can be applied to very large streams.
   See also Stream2StreamExBufSz. }
function Stream2StreamExBufSz( Dst, Src: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize; BufSz: DWORD ): TStrmSize;
{* Copies Count bytes from Src to Dst using buffer of given size, but without
   other optimizations.
   Unlike Stream2Stream function, it can be applied to very large streams }

//[Resource2Stream DECLARATION]
function Resource2Stream( DestStrm : PStream; Inst : HInst;
                          ResName : PKOLChar; ResType : PKOLChar ): Integer;
{* Loads given resource to DestStrm. Useful for non-standard
   resources to load it into memory (use memory stream for such
   purpose). Use one of following resource types to pass as ResType:
   |<pre>
RT_ACCELERATOR	Accelerator table
RT_ANICURSOR	Animated cursor
RT_ANIICON	Animated icon
RT_BITMAP	Bitmap resource
RT_CURSOR	Hardware-dependent cursor resource
RT_DIALOG	Dialog box
RT_FONT	        Font resource
RT_FONTDIR	Font directory resource
RT_GROUP_CURSOR	Hardware-independent cursor resource
RT_GROUP_ICON	Hardware-independent icon resource
RT_ICON	        Hardware-dependent icon resource
RT_MENU	        Menu resource
RT_MESSAGETABLE	Message-table entry
RT_RCDATA	Application-defined resource (raw data)
RT_STRING	String-table entry
RT_VERSION	Version resource
   |</pre>
   |<br>For example:
   !var MemStrm: PStream;
   !    JpgObj: PJpeg;
   !......
   ! MemStrm := NewMemoryStream;
   ! JpgObj := NewJpeg;
   !......
   ! Resource2Stream( MemStrm, hInstance, 'MYJPEG', RT_RCDATA );
   ! MemStrm.Position := 0;
   ! JpgObj.LoadFromStream( MemStrm );
   ! MemStrm.Free;
   !......
   }
{$ENDIF WIN_GDI}

{ -- string list objects -- }
//[TStrList]

type
  TCompareStrListFun = function( const S1, S2: PAnsiChar ): Integer;

  {++}(*TStrList = class;*){--}
  PStrList = {-}^{+}TStrList;
{ ---------------------------------------------------------------------
                TStrList - string list
---------------------------------------------------------------------- }
//[TStrList DEFINITION]
  TStrList = object(TObj)
  {* Easy string list implementation (non-visual, just to store
     string data). It is well improved and has very high performance
     allowing to work fast with huge text files (more then megabyte
     of text data).
     |
     Please note that #0 charaster if stored in string lines, will cut it
     preventing reading the rest of a line. Be careful, if your data
     contain such characters. }
  protected
    procedure Init; virtual;
  protected
    fList: PList;
    fCount: Integer;
    fCaseSensitiveSort: Boolean;
    fAnsiSort: Boolean;
    fTextBuf: PAnsiChar;
    fTextSiz: DWORD;
    fCompareStrListFun: TCompareStrListFun;
    function GetPChars(Idx: Integer): PAnsiChar;
    //procedure AddTextBuf( Src: PAnsiChar; Len: DWORD );
  protected
    function Get(Idx: integer): Ansistring;
    function GetTextStr: Ansistring;
    procedure Put(Idx: integer; const Value: Ansistring);
    procedure SetTextStr(const Value: Ansistring);
  {++}(*public*){--}
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
  protected
    // by Dod:
    procedure SetValue(const AName, Value: Ansistring);
    function GetValue(const AName: Ansistring): Ansistring;
  public
    // by Dod:
    function IndexOfName(AName: Ansistring): Integer;
    {* by Dod. Returns index of line starting like Name=... }
    property Values[const AName: Ansistring]: Ansistring read GetValue write SetValue;
    {* by Dod. Returns right side of a line starting like Name=... }
  public
    function Add(const S: Ansistring): integer;
    {* Adds a string to list. }
    procedure AddStrings(Strings: PStrList);
    {* Merges string list with given one. Very fast - more preferrable to
       use than any loop with calling Add method. }
    procedure Assign(Strings: PStrList);
    {* Fills string list with strings from other one. The same as AddStrings,
       but Clear is called first. }
    procedure Clear;
    {* Makes string list empty. }
    procedure Delete(Idx: integer);
    {* Deletes string with given index (it *must* exist). }
    procedure DeleteLast;
    {* Deletes the last string (it *must* exist). }
    function IndexOf(const S: AnsiString): integer;
    {* Returns index of first string, equal to given one. }
    function IndexOf_NoCase(const S: Ansistring): integer;
    {* Returns index of first string, equal to given one (while comparing it
       without case sensitivity). }
    function IndexOfStrL_NoCase( Str: PAnsiChar; L: Integer ): integer;
    {* Returns index of first string, equal to given one (while comparing it
       without case sensitivity). }
    function Find(const S: AnsiString; var Index: Integer): Boolean;
    {* Returns Index of the string, equal or greater to given pattern, but
       works only for sorted TStrList object. Returns TRUE if exact string found,
       otherwise nearest (greater then a pattern) string index is returned,
       and the result is FALSE. And in such _case Index is returned negated
       when the S string is less then the string found. }
    function FindFirst(const S: AnsiString; var Index: Integer): Boolean;
    {* Like above but always returns Index of the first string, equal or greater
       to given pattern. Also works only for sorted TStrList object. Returns TRUE
       if exact string found, otherwise nearest (greater then a pattern) string
       index is returned, and the result is FALSE. }
    procedure Insert(Idx: integer; const S: Ansistring);
    {* Inserts string before one with given index. }
    procedure Move(CurIndex, NewIndex: integer);
    {* Moves string to another location. }
    procedure SetText(const S: Ansistring; Append2List: Boolean);
    {* Allows to set strings of string list from given string (in which
       strings are separated by $0D,$0A or $0D characters). Text must not
       contain #0 characters. Works very fast. This method is used in
       all others, working with text arrays (LoadFromFile, MergeFromFile,
       Assign, AddStrings). }
    procedure SetUnixText( const S: AnsiString; Append2List: Boolean );
    {* Allows to assign UNIX-style text (with #10 as string separator). }
    property Count: integer read fCount;
    {* Number of strings in a string list. }
    property Items[Idx: integer]: Ansistring read Get write Put; default;
    {* Strings array items. If item does not exist, empty string is returned.
       But for assign to property, string with given index *must* exist. }
    property ItemPtrs[ Idx: Integer ]: PAnsiChar read GetPChars;
    {* Fast access to item strings as PChars. }
    function Last: AnsiString;
    {* Last item (or '', if string list is empty). }
    property Text: Ansistring read GetTextStr write SetTextStr;
    {* Content of string list as a single string (where strings are separated
       by characters $0D,$0A). }
    procedure Swap( Idx1, Idx2 : Integer );
    {* Swaps to strings with given indeces. }
    procedure Sort( CaseSensitive: Boolean );
    {* Call it to sort string list. }
    procedure AnsiSort( CaseSensitive: Boolean );
    {* Call it to sort ANSI string list. }

    // by Alexander Pravdin:
  protected
    fNameDelim: AnsiChar;
    function GetLineName( Idx: Integer ): AnsiString;
    procedure SetLineName( Idx: Integer; const NV: AnsiString );
    function GetLineValue(Idx: Integer): Ansistring;
    procedure SetLineValue(Idx: Integer; const Value: Ansistring);
  public
    property LineName[ Idx: Integer ]: Ansistring read GetLineName write SetLineName;
    property LineValue[ Idx: Integer ]: Ansistring read GetLineValue write SetLineValue;
    property NameDelimiter: AnsiChar read fNameDelim write fNameDelim;
    function Join( const sep: AnsiString ): AnsiString;
    {* by Sergey Shishmintzev. }
    {$IFDEF WIN_GDI}
    function LoadFromFile(const FileName: KOLString): Boolean;
    {* Loads string list from a file. (If file does not exist, nothing
       happens). Very fast even for huge text files. }
    procedure LoadFromStream(Stream: PStream; Append2List: Boolean);
    {* Loads string list from a stream (from current position to the end of
       a stream). Very fast even for huge text. }
    procedure MergeFromFile(const FileName: KOLString);
    {* Merges string list with strings in a file. Fast. }
    function SaveToFile(const FileName: KOLString): Boolean;
    {* Stores string list to a file. }
    procedure SaveToStream(Stream: PStream);
    {* Saves string list to a stream (from current position). }
    function AppendToFile(const FileName: KOLString): Boolean;
    {* Appends strings of string list to the end of a file. }
    {$ENDIF WIN_GDI}
  end;
//[END OF TStrList DEFINITION]

//[DefaultNameDelimiter]
var DefaultNameDelimiter: AnsiChar = '=';
    ThsSeparator: AnsiChar = ',';

//[NewStrList DECLARATION]
function NewStrList: PStrList;
{* Creates string list object. }

{$IFDEF WIN}
function  GetFileList(const dir: Ansistring): PStrList;
{* By Alexander Shakhaylo. Returns list of file names of the given directory. }
{$ENDIF WIN}

{$IFNDEF _FPC}
function WStrLen( W: PWideChar ): Integer;
{* Returns Length of null-terminated Unicode string. }

{$IFDEF _D3orHigher}
function UTF8_2WideString( const s: AnsiString ): WideString;
{$ENDIF}
{$ENDIF _FPC}

//[TStrListEx]
type
  {++}(*TStrListEx = class;*){--}
  PStrListEx = {-}^{+}TStrListEx;

//[TStrListEx DEFINITION]
  TStrListEx = object( TStrList )
  {* Extended string list object. Has additional capability to associate
     numbers or objects with string list items. }
  protected
    FObjects: PList;
    function GetObjects(Idx: Integer): DWORD;
    function GetObjectCount: Integer;
    procedure SetObjects(Idx: Integer; const Value: DWORD);
    procedure Init; {-}virtual;{+}{++}(*override;*){--}
    procedure ProvideObjCapacity( NewCap: Integer );
  public
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* }
    property Objects[ Idx: Integer ]: DWORD read GetObjects write SetObjects;
    {* Objects are just 32-bit values. You can treat and use it as pointers to
       any other data in the memory. But it is your task to free allocated
       memory in such case therefore.
       |<br>
       If the last item of a string list is deleted vis DeleteLast method (but
       not via Delete method), it's object still is preserved. As well, it is
       possible to set Objects[idx] for idx >= Count.
       To get know object's count, rather then strings count, use ObjectCount
       property. }
    property ObjectCount: Integer read GetObjectCount;
    {* Returns number of objects available. This value can differ from Count
       after some operations: objects are stored in the independant list and
       only synchronization is provided while using methods Delete, Insert,
       Add, AddObject, InsertObject while changing the list. }
    procedure AddStrings(Strings: PStrListEx);
    {* Merges string list with given one. Very fast - more preferrable to
       use than any loop with calling Add method. }
    procedure Assign(Strings: PStrListEx);
    {* Fills string list with strings from other one. The same as AddStrings,
       but Clear is called first. }
    procedure Clear;
    {* Makes string list empty. }
    procedure Delete(Idx: integer);
    {* Deletes string with given index (it *must* exist). }
    procedure DeleteLast;
    {* Deletes the last string and correspondent object in the list. }
    procedure Move(CurIndex, NewIndex: integer);
    {* Moves string to another location. }
    procedure Swap( Idx1, Idx2 : Integer );
    {* Swaps to strings with given indeces. }
    procedure Sort( CaseSensitive: Boolean );
    {* Call it to sort string list. }
    procedure AnsiSort( CaseSensitive: Boolean );
    {* Call it to sort ANSI string list. }
    function LastObj: DWORD;
    {* Object assotiated with the last string. }
    function AddObject( const S: AnsiString; Obj: DWORD ): Integer;
    {* Adds a string and associates given number with it. Index of the item added
       is returned. }
    procedure InsertObject( Before: Integer; const S: AnsiString; Obj: DWORD );
    {* Inserts a string together with object associated. }
    function IndexOfObj( Obj: Pointer ): Integer;
    {* Returns an index of a string associated with the object passed as a
       parameter. If there are no such strings, -1 is returned. }
  end;
//[END OF TStrListEx DEFINITION]

//[NewStrListEx DECLARATION]
function NewStrListEx: PStrListEx;
{* Creates extended string list object. }

//[TWStrList]

{-}
{$IFNDEF _FPC}
procedure WStrCopy( Dest, Src: PWideChar );
{* Copies null-terminated Unicode string (terminated null also copied). }
procedure WStrLCopy( Dest, Src: PWideChar; MaxLen: Integer );
{* Copies null-terminated Unicode string (terminated null also copied). }
function WStrCmp( W1, W2: PWideChar ): Integer;
{* Compares two null-terminated Unicode strings. }
function WStrCmp_NoCase( W1, W2: PWideChar ): Integer;
{* Compares two null-terminated Unicode strings. }
{$ENDIF _FPC}

{$IFDEF WIN_GDI}
{$IFNDEF _D2} //------------------ WideString is not supported in D2 -----------

type
  PWStrList = ^TWstrList;
  {* }
//[TWstrList DEFINITION]
  TWStrList = object( TObj )
  {* String list to store Unicode (null-terminated) strings. }
  protected
    function GetCount: Integer;
    function GetItems(Idx: Integer): WideString;
    procedure SetItems(Idx: Integer; const Value: WideString);
    function GetPtrs(Idx: Integer): PWideChar;
    function GetText: WideString;
  protected
    fList: PList;
    fText: PWideChar;
    fTextBufSz: Integer;
    fTmp1, fTmp2: WideString;
    procedure Init; virtual;
  public
    procedure SetText(const Value: WideString);
    {* See also TStrList.SetText }
    destructor Destroy; virtual;
    {* }
    procedure Clear;
    {* See also TStrList.Clear }
    property Items[ Idx: Integer ]: WideString read GetItems write SetItems;
    {* See also TStrList.Items }
    property ItemPtrs[ Idx: Integer ]: PWideChar read GetPtrs;
    {* See also TStrList.ItemPtrs }
    property Count: Integer read GetCount;
    {* See also TStrList.Count }
    function Add( const W: WideString ): Integer;
    {* See also TStrList.Add }
    procedure Insert( Idx: Integer; const W: WideString );
    {* See also TStrList.Insert }
    procedure Delete( Idx: Integer );
    {* See also TStrList.Delete }
    property Text: WideString read GetText write SetText;
    {* See also TStrList.Text }
    procedure AddWStrings( WL: PWStrList );
    {* See also TStrList.AddStrings }
    procedure Assign( WL: PWStrList );
    {* See also TStrList.Assign }
    function LoadFromFile( const Filename: KOLString ): Boolean;
    {* See also TStrList.LoadFromFile }
    procedure LoadFromStream( Strm: PStream );
    {* See also TStrList.LoadFromStream }
    function MergeFromFile( const Filename: KOLString ): Boolean;
    {* See also TStrList.MergeFromFile }
    procedure MergeFromStream( Strm: PStream );
    {* See also TStrList.MergeFromStream }
    function SaveToFile( const Filename: KOLString ): Boolean;
    {* See also TStrList.SaveToFile }
    procedure SaveToStream( Strm: PStream );
    {* See also TStrList.SaveToStream }
    function AppendToFile( const Filename: KOLString ): Boolean;
    {* See also TStrList.AppendToFile }
    procedure Swap( Idx1, Idx2: Integer );
    {* See also TStrList.Swap }
    procedure Sort( CaseSensitive: Boolean );
    {* See also TStrList.Sort }
    procedure Move( IdxOld, IdxNew: Integer );
    {* See also TStrList.Move }
    function IndexOf( const s: WideString ): Integer;
    {* }
    function IndexOf_NoCase( const s: WideString ): Integer;
    {* }
    function Last: WideString;
    {* }
    procedure Put(Idx: integer; const Value: WideString);
    {* +azsd for TBButton }
  end;
//[END OF TWStrList DEFINITION]

//[TWStrListEx]
  PWStrListEx = ^TWStrListEx;

//[TWStrListEx DEFINITION]
  TWStrListEx = object( TWStrList )
  {* Extended Unicode string list (with Objects). }
  protected
    function GetObjects(Idx: Integer): DWORD;
    procedure SetObjects(Idx: Integer; const Value: DWORD);
    procedure ProvideObjectsCapacity( NewCap: Integer );
  protected
    fObjects: PList;
    procedure Init; virtual;
  public
    destructor Destroy; virtual;
    {* }
    property Objects[ Idx: Integer ]: DWORD read GetObjects write SetObjects;
    {* }
    procedure AddWStrings( WL: PWStrListEx );
    {* }
    procedure Assign( WL: PWStrListEx );
    {* }
    procedure Clear;
    {* }
    procedure Delete( Idx: Integer );
    {* }
    procedure Move( IdxOld, IdxNew: Integer );
    {* }
    function AddObject( const S: WideString; Obj: DWORD ): Integer;
    {* Adds a string and associates given number with it. Index of the item added
       is returned. }
    procedure InsertObject( Before: Integer; const S: WideString; Obj: DWORD );
    {* Inserts a string together with object associated. }
    function IndexOfObj( Obj: Pointer ): Integer;
    {* Returns an index of a string associated with the object passed as a
       parameter. If there are no such strings, -1 is returned. }
  end;
//[END OF TWStrListEx DEFINITION]

//[NewWStrList DECLARATION]
function NewWStrList: PWStrList;
{* Creates new TWStrList object and returns a pointer to it. }

//[NewWStrListEx DECLARATION]
function NewWStrListEx: PWStrListEx;
{* Creates new TWStrListEx objects and returns a pointer to it. }

{$ENDIF not _D2}
{$ENDIF WIN_GDI}

{$IFDEF UNICODE_CTRLS}
{$IFNDEF _D2}
type TKOLStrList = TWStrList;
     PKOLStrList = PWStrList;
     TKOLStrListEx = TWStrListEx;
     PKOLStrListEx = PWStrListEx;
{$ELSE}
type TKOLStrList = TStrList;
     PKOLStrList = PStrList;
     TKOLStrListEx = TStrListEx;
     PKOLStrListEx = PStrListEx;
{$ENDIF}
{$ELSE}
type TKOLStrList = TStrList;
     PKOLStrList = PStrList;
     TKOLStrListEx = TStrListEx;
     PKOLStrListEx = PStrListEx;
{$ENDIF}

function NewKOLStrList: PKOLStrList;
function NewKOLStrListEx: PKOLStrListEx;

{+}
////////////////////////////////////////////////////////////////////////////////
//                            GRAPHIC OBJECTS                                 //
////////////////////////////////////////////////////////////////////////////////
//[GRAPHIC OBJECTS]
{
  It is very important, that the most of code, implementing graphic objets
  from this section, is included into executable ONLY if really accessed in your
  project directly (e.g., if Font or Brush properies of a control are accessed
  or changed).
}
type
  TColor = Integer;
const
//[COLOR CONSTANTS]
  clScrollBar = TColor(COLOR_SCROLLBAR or $80000000);
  clBackground = TColor(COLOR_BACKGROUND or $80000000);
  clActiveCaption = TColor(COLOR_ACTIVECAPTION or $80000000);
  clInactiveCaption = TColor(COLOR_INACTIVECAPTION or $80000000);
  clMenu = TColor(COLOR_MENU or $80000000);
  clWindow = TColor(COLOR_WINDOW or $80000000);
  clWindowFrame = TColor(COLOR_WINDOWFRAME or $80000000);
  clMenuText = TColor(COLOR_MENUTEXT or $80000000);
  clWindowText = TColor(COLOR_WINDOWTEXT or $80000000);
  clCaptionText = TColor(COLOR_CAPTIONTEXT or $80000000);
  clActiveBorder = TColor(COLOR_ACTIVEBORDER or $80000000);
  clInactiveBorder = TColor(COLOR_INACTIVEBORDER or $80000000);
  clAppWorkSpace = TColor(COLOR_APPWORKSPACE or $80000000);
  clHighlight = TColor(COLOR_HIGHLIGHT or $80000000);
  clHighlightText = TColor(COLOR_HIGHLIGHTTEXT or $80000000);
  clBtnFace = TColor(COLOR_BTNFACE or $80000000);
  clBtnShadow = TColor(COLOR_BTNSHADOW or $80000000);
  clGrayText = TColor(COLOR_GRAYTEXT or $80000000);
  clGreyText = TColor(COLOR_GRAYTEXT or $80000000);
  clBtnText = TColor(COLOR_BTNTEXT or $80000000);
  clInactiveCaptionText = TColor(COLOR_INACTIVECAPTIONTEXT or $80000000);
  clBtnHighlight = TColor(COLOR_BTNHIGHLIGHT or $80000000);
  cl3DDkShadow = TColor(COLOR_3DDKSHADOW or $80000000);
  cl3DLight = TColor(COLOR_3DLIGHT or $80000000);
  clInfoText = TColor(COLOR_INFOTEXT or $80000000);
  clInfoBk = TColor(COLOR_INFOBK or $80000000);

  clBlack = TColor($000000);
  clMaroon = TColor($000080);
  clGreen = TColor($008000);
  clOlive = TColor($008080);
  clNavy = TColor($800000);
  clPurple = TColor($800080);
  clTeal = TColor($808000);
  clGray = TColor($808080);
  clGrey = TColor($808080);
  clSilver = TColor($C0C0C0);
  clRed = TColor($0000FF);
  clLime = TColor($00FF00);
  clYellow = TColor($00FFFF);
  clBlue = TColor($FF0000);
  clFuchsia = TColor($FF00FF);
  clAqua = TColor($FFFF00);
  clLtGray = TColor($C0C0C0);
  clLtGrey = TColor($C0C0C0);
  clDkGray = TColor($808080);
  clDkGrey = TColor($808080);
  clWhite = TColor($FFFFFF);
  clNone = TColor($1FFFFFFF);
  clDefault = TColor($20000000);

  clMoneyGreen = TColor($C0DCC0);
  clSkyBlue = TColor($F0CAA6);
  clCream = TColor($F0FBFF);
  clMedGray = TColor($A4A0A0);
  clMedGrey = TColor($A4A0A0);
  clOrange = TColor( $3399FF );
  clBrown = TColor( $505080 );
  clDkBrown = TColor( $282840 );

  clGRushHiLight = TColor( $F3706C );
  clGRushLighten = TColor( $F1EEDF );
  clGRushLight = TColor( $e1cebf );
  clGRushNormal = TColor( $D1beaf );
  clGRushMedium = TColor( $b6bFc6 );
  clGRushDark = TColor( $9EACB4 );
//[END OF COLOR CONSTANTS]

const
//[TGraphicTool FIELD OFFSET CONSTANTS]
  go_Color                 = 0;
  go_FontHeight            = 4;
  go_FontWidth             = 8;
  go_FontEscapement        = 12;
  go_FontOrientation       = 16;
  go_FontWeight            = 20;
  go_FontItalic            = 24;
  go_FontUnderline         = 25;
  go_FontStrikeOut         = 26;
  go_FontCharSet           = 27;
  go_FontOutPrecision      = 28;
  go_FontClipPrecision     = 29;
  go_FontQuality           = 30;
  go_FontPitch             = 31;
  go_FontName              = 32;
  go_BrushBitmap           = 4;
  go_BrushStyle            = 8;
  go_BrushLineColor        = 9;
  go_PenBrushBitmap        = 4;
  go_PenBrushStyle         = 8;
  go_PenStyle              = 9;
  go_PenWidth              = 10;
  go_PenMode               = 14;
  go_PenGeometric          = 15;
  go_PenEndCap             = 16;
  go_PenJoin               = 17;
//[END OF TGraphicTool FIELD OFFSET CONSTANTS]

//[TGraphicTool]
type
   TGraphicToolType = ( gttBrush, gttFont, gttPen );
   {* Graphic object types, mainly for internal use. }

   {++}(*TGraphicTool = class;*){--}
   PGraphicTool = {-}^{+}TGraphicTool;
   {* }
   TOnGraphicChange = procedure ( Sender: PGraphicTool ) of object;
   {* An event mainly for internal use. }

   TBrushStyle = (bsSolid, bsClear, bsHorizontal, bsVertical,
    bsFDiagonal, bsBDiagonal, bsCross, bsDiagCross);
   {* Available brush styles. }

   TFontStyles = (fsBold, fsItalic, fsUnderline, fsStrikeOut);
   {* Available font styles. }
   TFontStyle = set of TFontStyles;
   {* Font style is representing as a set of XFontStyles. }
   TFontPitch = (fpDefault, fpFixed, fpVariable);
   {* Availabe font pitch values. }
   TFontName = type string;
   {* Font name is represented as a string. }
   TFontCharset = 0..255;
   {* Font charset is represented by number from 0 to 255. }
   TFontQuality = (fqDefault, fqDraft, fqProof, fqNonAntialiased, fqAntialiased
                , fqClearType);
   {* Font quality. }

   TPenStyle = (psSolid, psDash, psDot, psDashDot, psDashDotDot, psClear,
    psInsideFrame);
   {* Available pen styles. For more info see Delphi or Win32 help files. }
   TPenMode = (pmBlack, pmNotMerge, pmMaskNotPen, pmNotCopy, pmMaskPenNot,
               pmNot, pmXor, pmNotMask, pmMask, pmNotXor, pmNop, pmMergePenNot,
               pmCopy, pmMergeNotPen, pmMerge, pmWhite);
   {* Available pen modes. For more info see Delphi or Win32 help files. }
   TPenEndCap = (pecRound, pecSquare, pecFlat);
   {* Avalable (for geometric pen) end cap styles. }
   TPenJoin = (pjRound, pjBevel, pjMiter);
   {* Available (for geometric pen) join styles. }

//[TGdiFont]
   TGDIFont = packed record
     Height: Integer;
     Width: Integer;
     Escapement: Integer;
     Orientation: Integer;
     Weight: Integer;
     Italic: Boolean;
     Underline: Boolean;
     StrikeOut: Boolean;
     CharSet: TFontCharset;
     OutPrecision: Byte;
     ClipPrecision: Byte;
     Quality: TFontQuality;
     Pitch: TFontPitch;
     Name: array[0..LF_FACESIZE - 1] of KOLChar;
   end;

//[TGDIBrush]
   TGDIBrush = packed record
     Bitmap: HBitmap;
     Style: TBrushStyle;
     LineColor: TColor;
   end;

//[TGDIPen]
   TGDIPen = packed record
     BrushBitmap: HBitmap;
     BrushStyle: TBrushStyle;
     Style: TPenStyle;
     Width: Integer;
     Mode: TPenMode;
     Geometric: Boolean;
     EndCap: TPenEndCap;
     Join: TPenJoin;
   end;

//[TGDIToolData]
   TGDIToolData = packed record
     Color: TColor;
     case Integer of
     1: (Font: TGDIFont);
     2: (Pen: TGDIPen);
     3: (Brush: TGDIBrush);
   end;

//[TNewGraphicTool]
   TNewGraphicTool = function: PGraphicTool;

{ ---------------------------------------------------------------------
     TGraphicTool - object to implement GDI-tools (brush, pen, font)
---------------------------------------------------------------------- }
//[TGraphicTool DEFINITION]
  TGraphicTool = object( TObj )
  {* Incapsulates all GDI objects: Pen, Brush and Font. }
  protected
    fType: TGraphicToolType;
    {$IFDEF GDI}
    fHandle: THandle;
    fParentGDITool: PGraphicTool;
    {$ENDIF GDI}
    fColorRGB: TColor;
    fOnChange: TOnGraphicChange;
    fData: TGDIToolData;
    fNewProc: TNewGraphicTool;
    {$IFDEF GDI}
    fMakeHandleProc: function( Self_: PGraphicTool ): THandle;
    {$ENDIF GDI}
    procedure SetInt( const Index: Integer; Value: Integer );
    function GetInt( const Index: Integer ): Integer;
    procedure SetColor( Value: TColor );
    {$IFDEF GDI}
    function GetBrushBitmap: HBitmap; // for BCB only
    procedure SetBrushBitmap(const Value: HBitmap);
    function GetBrushStyle: TBrushStyle; // for BCB only
    {$ENDIF GDI}
    procedure SetBrushStyle(const Value: TBrushStyle);
    function GetFontName: KOLString;
    procedure SetFontName(const Value: KOLString);
    function GetFontStyle: TFontStyle;
    procedure SetFontStyle(const Value: TFontStyle);
    function GetFontWeight: Integer; // for BCB only
    procedure SetFontWeight(const Value: Integer);
    {$IFDEF GDI}
    function GetFontCharset: TFontCharset; // for BCB only
    procedure SetFontCharset(const Value: TFontCharset);
    function GetFontQuality: TFontQuality; // for BCB only
    procedure SetFontQuality(const Value: TFontQuality);
    function GetFontOrientation: Integer; // for BCB only
    procedure SetFontOrientation(Value: Integer);
    function GetFontPitch: TFontPitch; // for BCB only
    procedure SetFontPitch(const Value: TFontPitch);
    function GetPenMode: TPenMode; // for BCB only
    procedure SetPenMode(const Value: TPenMode);
    function GetPenStyle: TPenStyle; // for BCB only
    procedure SetPenStyle(const Value: TPenStyle);
    function GetGeometricPen: Boolean; // for BCB only
    procedure SetGeometricPen(const Value: Boolean);
    function GetPenEndCap: TPenEndCap; // for BCB only
    procedure SetPenEndCap(const Value: TPenEndCap);
    function GetPenJoin: TPenJoin; // for BCB only
    procedure SetPenJoin(const Value: TPenJoin);
    procedure SetLogFontStruct(const Value: TLogFont);
    function GetLogFontStruct: TLogFont;
    {$ENDIF GDI}
  protected
    procedure Changed;
    {* }
    {$IFDEF GDI}
    function GetHandle: THandle;
    {* }
    {$ENDIF GDI}
  protected
    {$IFDEF _X_}
    {$IFDEF GTK}
    fPangoFontDesc: PPangoFontDescription;
    function GetPangoFontDesc: PPangoFontDescription;
    {$ENDIF GTK}
    {$ENDIF _X_}
  public
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* }
    {$IFDEF _X_}
    {$IFDEF GTK}
    property FontHandle: PPangoFontDescription read GetPangoFontDesc;
    {$ENDIF GTK}
    {$ENDIF _X_}
    {$IFDEF GDI}
    property Handle: THandle read GetHandle;
    {* Every time, when accessed, real GDI object is created (if it is
       not yet created). So, to prevent creating of the handle, use
       HandleAllocated instead of comparing Handle with value 0.  }
    function HandleAllocated: Boolean;
    {* Returns True, if handle is allocated (i.e., if real GDI
       objet is created. }
    {$ENDIF GDI}
    property OnChange: TOnGraphicChange read fOnChange write fOnChange;
    {* Called, when object is changed. }
    {$IFDEF GDI}
    function ReleaseHandle: Integer;
    {* Returns Handle value (if allocated), releasing it from the
       object (so, it is no more knows about this handle and its
       HandleAllocated function returns False. }
    {$ENDIF GDI}
    property Color: TColor {index go_Color} read fData.Color write SetColor;
    {* Color is the most common property for all Pen, Brush and
       Font objects, so it is placed in its common for all of them. }
    function Assign( Value: PGraphicTool ): PGraphicTool;
    {* Assigns properties of the same (only) type graphic object,
       excluding Handle. If assigning is really leading to change
       object, procedure Changed is called. }
    {$IFDEF GDI}
    procedure AssignHandle( NewHandle: Integer );
    {* Assigns value to Handle property. }

    property BrushBitmap: HBitmap read {-BCB-}fData.Brush.Bitmap{+BCB+}
                                       {BCB++}(*GetBrushBitmap*){--BCB}
       write SetBrushBitmap;
    {* Brush bitmap. For more info about using brush bitmap,
       see Delphi or Win32 help files. }
    {$ENDIF GDI}
    property BrushStyle: TBrushStyle read {-BCB-}fData.Brush.Style{+BCB+}
                                          {BCB++}(*GetBrushStyle*){--BCB}
       write SetBrushStyle;
    {$IFDEF GDI}
    {* Brush style. }
    property BrushLineColor: TColor index go_BrushLineColor
             {$IFDEF F_P}
             read GetInt
             {$ELSE DELPHI}
             read {-BCB-}fData.Brush.LineColor{+BCB+}
                  {BCB++}(*GetInt*){--BCB}
             {$ENDIF F_P/DELPHI}
             write SetInt;
    {* Brush line color, used to represent lines in hatched brush. Default value is clBlack. }

    {$ENDIF GDI}
    property FontHeight: Integer index go_FontHeight
             {$IFDEF F_P}
             read GetInt
             {$ELSE DELPHI}
             read {-BCB-}fData.Font.Height{+BCB+}
                  {BCB++}(*GetInt*){--BCB}
             {$ENDIF F_P/DELPHI}
             write SetInt;
    {* Font height. Value 0 (default) says to use system default value,
       negative values are to represent font height in "points", positive
       - in pixels. In XCL usually positive values (if not 0) are used to
       make appearance independent from different local settings. }
    {$IFDEF GDI}
    property FontWidth: Integer index go_FontWidth
             {$IFDEF F_P}
             read GetInt
             {$ELSE DELPHI}
             read {-BCB-}fData.Font.Width{+BCB+}
                  {BCB++}(*GetInt*){--BCB}
             {$ENDIF F_P/DELPHI}
             write SetInt;
    {* Font width in logical units. If FontWidth = 0, then as it is said
       in Win32.hlp, "the aspect ratio of the device is matched against the
       digitization aspect ratio of the available fonts to find the closest match,
       determined by the absolute value of the difference." }
    property FontPitch: TFontPitch read {-BCB-}fData.Font.Pitch{+BCB+}
                                        {BCB++}(*GetFontPitch*){--BCB}
      write SetFontPitch;
    {* Font pitch. Change it very rare. }
    {$ENDIF GDI}
    property FontStyle: TFontStyle read GetFontStyle write SetFontStyle;
    {* Very useful property to control text appearance. }
    {$IFDEF GDI}
    property FontCharset: TFontCharset read {-BCB-}fData.Font.Charset{+BCB+}
                                            {BCB++}(*GetFontCharset*){--BCB}
      write SetFontCharset;
    {* Do not change it if You do not know what You do. }
    property FontQuality: TFontQuality read {-BCB-}fData.Font.Quality{+BCB+}
                                            {BCB++}(*GetFontQuality*){--BCB}
      write SetFontQuality;
    {* Font quality. }
    property FontOrientation: Integer read {-BCB-}fData.Font.Orientation{+BCB+}
                                           {BCB++}(*GetFontOrientation*){--BCB}
      write SetFontOrientation;
    {* It is possible to rotate text in XCL just by changing this
       property of a font (tenths of degree, i.e. value 900 represents
       90 degree - text written from bottom to top). }
    {$ENDIF GDI}
    property FontWeight: Integer read {-BCB-}fData.Font.Weight{+BCB+}
                                      {BCB++}(*GetFontWeight*){--BCB}
      write SetFontWeight;
    {* Additional font weight for bold fonts (must be 0..1000). When set to
       value <> 0, fsBold is added to FontStyle. And otherwise, when set to 0,
       fsBold is removed from FontStyle. Value 700 corresponds to Bold,
       400 to Normal. }
    property FontName: KOLString read GetFontName write SetFontName;
    {* Font face name. }
    {$IFDEF GDI}
    function IsFontTrueType: Boolean;
    {* Returns True, if font is True Type. Requires of creating of a Handle,
       if it is not yet created. }

    property PenWidth: Integer index go_PenWidth
             {$IFDEF F_P}
             read GetInt
             {$ELSE DELPHI}
             read {-BCB-}fData.Pen.Width{+BCB+}
                  {BCB++}(*GetInt*){--BCB}
             {$ENDIF F_P/DELPHI}
             write SetInt;
    {* Value 0 means default pen width. }
    property PenStyle: TPenStyle read {-BCB-}fData.Pen.Style{+BCB+}
                                      {BCB++}(*GetPenStyle*){--BCB}
      write SetPenStyle;
    {* Pen style. }
    property PenMode: TPenMode read {-BCB-}fData.Pen.Mode{+BCB+}
                                    {BCB++}(*GetPenMode*){--BCB}
      write SetPenMode;
    {* Pen mode. }

    property GeometricPen: Boolean read {-BCB-}fData.Pen.Geometric{+BCB+}
                                        {BCB++}(*GetGeometricPen*){--BCB}
      write SetGeometricPen;
    {* True if Pen is geometric. Note, that under Win95/98 only pen styles
       psSolid, psNull, psInsideFrame are supported by OS. }
    property PenBrushStyle: TBrushStyle read {-BCB-}fData.Pen.BrushStyle{+BCB+}
                                             {BCB++}(*GetBrushStyle*){--BCB}
      write SetBrushStyle;
    {* Brush style for hatched geometric pen. }
    property PenBrushBitmap: HBitmap read {-BCB-}fData.Pen.BrushBitmap{+BCB+}
                                          {BCB++}(*GetBrushBitmap*){--BCB}
      write SetBrushBitmap;
    {* Brush bitmap for geometric pen (if assigned Pen is functioning as
       its style = BS_PATTERN, regadless of PenBrushStyle value). }
    property PenEndCap: TPenEndCap read {-BCB-}fData.Pen.EndCap{+BCB+}
                                        {BCB++}(*GetPenEndCap*){--BCB}
      write SetPenEndCap;
    {* Pen end cap mode - for GeometricPen only. }
    property PenJoin: TPenJoin read {-BCB-}fData.Pen.Join{+BCB+}
                                    {BCB++}(*GetPenJoin*){--BCB}
      write SetPenJoin;
    {* Pen join mode - for GeometricPen only. }
    property LogFontStruct: TLogFont read GetLogFontStruct write SetLogFontStruct;
    {* by Alex Pravdin: a property to change all font structure items at once. }
    {$ENDIF GDI}
  end;
//[END OF TGraphicTool DEFINITION]

//[Color2XXX FUNCTIONS]
function Color2RGB( Color: TColor ): TColor;
{* Function to get RGB color from system color. Parameter can be also RGB
   color, in that case result is just equal to a parameter. }
function RGB2BGR( Color: TColor ): TColor;
{* Converts RGB color to BGR }
{$IFDEF GTK}
function Color2GDKColor( Color: TColor ): TGdkColor;
{$ENDIF GTK}
function ColorsMix( Color1, Color2: TColor ): TColor;
{* Returns color, which RGB components are build as an (approximate)
   arithmetic mean of correspondent RGB components of both source
   colors (these both are first converted from system to RGB, and
   result is always RGB color). Please note: this function is fast,
   but can be not too exact. }
{$IFDEF WIN_GDI}
function Color2RGBQuad( Color: TColor ): TRGBQuad;
{* Converts color to RGB, used to represent RGB values in palette entries
   (actually swaps R and B bytes). }
function Color2Color16( Color: TColor ): WORD;
{* Converts Color to RGB, packed to word (as it is used in format pf16bit). }
function Color2Color15( Color: TColor ): WORD;
{* Converts Color to RGB, packed to word (as it is used in format pf15bit). }

//[DefFont VARIABLE]
var    // New TFont instances are intialized with the values in this structure:
  DefFont: TGDIFont = (
     Height: 0;
     Width: 0;
     Escapement: 0;
     Orientation: 0;
     Weight: 0;
     Italic: FALSE;
     Underline: FALSE;
     StrikeOut: FALSE;
     CharSet: 1;
     OutPrecision: 0;
     ClipPrecision: 0;
     Quality: fqDefault;
     Pitch: fpDefault;
     {$IFDEF UNICODE_CTRLS}
     Name: ( 'T', 'a', 'h', 'o', 'm', 'a',
             #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0,
             #0, #0, #0, #0, #0, #0, #0, #0, #0 );
     {$ELSE}
     Name: 'System';
     {$ENDIF}
  );
  DefFontColor: TColor = clWindowText;
  {* Default font color. }

//[GlobalGraphics_UseFontOrient]
  GlobalGraphics_UseFontOrient: Boolean;
  {* Global flag. If stays False (default), Orientation property of Font
     objects is ignored. This flag is set to True automatically in
     RotateFonts add-on. }

{$ENDIF WIN_GDI}
{ -- Constructors for different GDI tools -- }

//[New FUNCTIONS FOR TGraphicTool]
function NewFont: PGraphicTool;
{* Creates and returns font graphic tool object. }
function NewBrush: PGraphicTool;
{* Creates and returns new brush object. }
function NewPen: PGraphicTool;
{* Creates and returns new pen object. }

{ -- TCanvas object -- }
//[TCanvas]
const
  HandleValid = 1;
  PenValid    = 2;
  BrushValid  = 4;
  FontValid   = 8;
  ChangingCanvas = 16;

{$IFDEF WIN_GDI}
type
   TFillStyle = (fsSurface, fsBorder);
   {* Available filling styles. For more info see Win32 or Delphi help files. }
   TFillMode = (fmAlternate, fmWinding);
   {* Available filling modes. For more info see Win32 or Delphi help files. }
   TCopyMode = Integer;
   {* Available copying modes are following:
      |  cmBlackness<br>
      |  cmDstInvert<br>
      |  cmMergeCopy<br>
      |  cmMergePaint<br>
      |  cmNotSrcCopy<br>
      |  cmNotSrcErase<br>
      |  cmPatCopy<br>
      |  cmPatInvert<br>
      |  cmPatPaint<br>
      |  cmSrcAnd<br>
      |  cmSrcCopy<br>
      |  cmSrcErase<br>
      |  cmSrcInvert<br>
      |  cmSrcPaint<br>
      |  cmWhiteness<br>&nbsp;&nbsp;&nbsp;
      Also it is possible to use any other available ROP2 modes. For more info,
      see Win32 help files. }

const
  cmBlackness = BLACKNESS;
  cmDstInvert = DSTINVERT;
  cmMergeCopy = MERGECOPY;
  cmMergePaint = MERGEPAINT;
  cmNotSrcCopy = NOTSRCCOPY;
  cmNotSrcErase = NOTSRCERASE;
  cmPatCopy = PATCOPY;
  cmPatInvert = PATINVERT;
  cmPatPaint = PATPAINT;
  cmSrcAnd = SRCAND;
  cmSrcCopy = SRCCOPY;
  cmSrcErase = SRCERASE;
  cmSrcInvert = SRCINVERT;
  cmSrcPaint = SRCPAINT;
  cmWhiteness = WHITENESS;

{$ENDIF WIN_GDI}
type
  {$IFDEF _X_}
  {$IFDEF GTK}
  HDC = PGdkGC;
  {$ENDIF GTK}
  {$ENDIF _X_}
  {++}(*TCanvas = class;*){--}
  PCanvas = {-}^{+}TCanvas;
  {* }
  TOnGetHandle = function( Canvas: PCanvas ): HDC of object;
  {* For internal use mainly. }
  TOnTextArea = procedure( Sender: PCanvas; var Size : TSize; var P0 : TPoint );
  {* Event to calculate actual area, occupying by a text. It is used
     to optionally extend calculating of TextArea taking into considaration
     font Orientation property. }

{ ---------------------------------------------------------------------
                TCanvas - high-level drawing helper object
----------------------------------------------------------------------- }
//[TCanvas DEFINITION]
  TCanvas = object( TObj )
  {* Very similar to VCL's TCanvas object. But with some changes, specific
     for KOL: there is no necessary to use canvases in all applications.
     And graphic tools objects are not created with canvas, but only
     if really accessed in program. (Actually, even if paint box used,
     only programmer decides, if to implement painting using Canvas or
     to call low level API drawing functions working directly with DC).
     Therefore TCanvas has some powerful extensions: rotated text support,
     geometric pen support - just by changing correspondent properties
     of certain graphic tool objects (Font.FontOrientation, Pen.GeometricPen).
     See also additional Font properties (Font.FontWeight, Font.FontQuality,
     etc. }
  protected
    fOwnerControl: Pointer; //PControl;
    {$IFDEF _X_}
    {$IFDEF GTK}
    fDrawable: PGdkDrawable;
    fTmpColor: PGdkColor;
    {$ENDIF GTK}
    {$ENDIF _X_}
    fHandle : HDC;
    fPenPos : TPoint;
    fState : Byte;
    fBrush, fPen: PGraphicTool;
    fFont : PGraphicTool; // order is important for ASM version
  {$IFDEF GDI}
    fCopyMode : TCopyMode;
    fOnChange: TOnEvent;
    {$ENDIF GDI}
    fOnGetHandle: TOnGetHandle;
    {$IFDEF _X_}
    {$IFDEF GTK}
    fSavedState: TGdkGCValues;
    procedure SaveState;
    procedure RestoreState;
    {$ENDIF GTK}
    {$ENDIF _X_}
    {$IFDEF GDI}
    procedure SetHandle( Value : HDC );
    {$ENDIF GDI}
    procedure SetPenPos( const Value : TPoint );
    {$IFDEF GDI}
    procedure CreatePen;
    procedure CreateBrush;
    procedure CreateFont;
    procedure Changing;
    {$ENDIF GDI}
    procedure ObjectChanged( Sender : PGraphicTool );
    function GetBrush: PGraphicTool;
    function GetFont: PGraphicTool;
    function GetPen: PGraphicTool;
    function GetHandle: HDC;
    procedure AssignChangeEvents;
    {$IFDEF GDI}
    function GetPixels(X, Y: Integer): TColor;
    procedure SetPixels(X, Y: Integer; const Value: TColor);
  protected
    fIsPaintDC : Boolean;
    {* TRUE, if DC obtained during current WM_PAINT (or WM_ERASEBKGND?)
       processing for a control. This affects a way how Handle is released. }
  {++}(*public*){--}
    destructor Destroy;{-}virtual;{+}{++}(*override;*){--}
    {* }
  {++}(*protected*){--}
    {$ENDIF GDI}
    property OnGetHandle: TOnGetHandle read fOnGetHandle write fOnGetHandle;
    {* For internal use only. }
    {$IFDEF GDI}
  {$ENDIF GDI}
  public
    property Handle : HDC read GetHandle {$IFDEF GDI} write SetHandle {$ENDIF GDI};
    {* GDI device context object handle. Never created by
       Canvas itself (to use Canvas with memory bitmaps,
       always create DC by yourself and assign it to the
       Handle property of Canvas object, or use property
       Canvas of a bitmap). }
    property PenPos : TPoint read FPenPos write SetPenPos;
    {* Position of a pen. }
    property Pen : PGraphicTool read GetPen;
    {* Pen of Canvas object. Do not change its Pen.OnChange event value. }
    property Brush : PGraphicTool read GetBrush;
    {* Brush of Canvas object. Do not change its Brush.OnChange event value. }
    property Font : PGraphicTool read GetFont;
    {* Font of Canvas object. Do not change its Font.OnChange event value. }
    procedure OffsetAndRotate( Xoff, Yoff: Integer; Angle: Double );
    {* Transforms world coordinates so that Xoff and Yoff become the
       coordinates of the origin (0,0) and all further drawing is done
       rotated around that point by the Angle (which is given in radians) }
    {$IFNDEF NOT_USE_KOLMATH} // if using KOLmath disabled, Arc becomes unavailable
    procedure Arc(X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer); stdcall;
    {* Draws arc. For more info, see Delphi TCanvas help. }
    {$ENDIF NOT_USE_KOLMATH}
    {$IFDEF GDI}
    procedure Chord(X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer); stdcall;
    {* Draws chord. For more info, see Delphi TCanvas help. }
    procedure DrawFocusRect({$IFNDEF FPC}const{$ENDIF} Rect: TRect);
    {* Draws rectangle to represent focused visual object.
       For more info, see Delphi TCanvas help. }
    procedure Ellipse(X1, Y1, X2, Y2: Integer);
    {* Draws an ellipse. For more info, see Delphi TCanvas help. }
    {$ENDIF GDI}
    procedure FillRect({$IFNDEF FPC}const{$ENDIF} Rect: TRect);
    {* Fills rectangle. For more info, see Delphi TCanvas help. }
    {$IFDEF GDI}
    procedure FillRgn( const Rgn : HRgn );
    {* Fills region. For more info, see Delphi TCanvas help. }
    procedure FloodFill(X, Y: Integer; Color: TColor; FillStyle: TFillStyle);
    {* Fills a figure with givien color, floodfilling its surface.
       For more info, see Delphi TCanvas help. }
    procedure FrameRect({$IFNDEF FPC}const{$ENDIF} Rect: TRect);
    {* Draws a rectangle using Brush settings (color, etc.).
       For more info, see Delphi TCanvas help. }
    {$ENDIF GDI}
    procedure MoveTo( X, Y : Integer );
    {* Moves current PenPos to a new position.
       For more info, see Delphi TCanvas help. }
    procedure LineTo( X, Y : Integer );
    {* Draws a line from current PenPos up to new position.
       For more info, see Delphi TCanvas help. }
    {$IFDEF GDI}
    procedure Pie(X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer); stdcall;
    {* Draws a pie. For more info, see Delphi TCanvas help. }
    procedure Polygon(const Points: array of TPoint);
    {* Draws a polygon. For more info, see Delphi TCanvas help. }
    procedure Polyline(const Points: array of TPoint);
    {* Draws a bound for polygon. For more info, see Delphi TCanvas help. }
    procedure Rectangle(X1, Y1, X2, Y2: Integer);
    {* Draws a rectangle using current Pen and/or Brush.
       For more info, see Delphi TCanvas help. }
    procedure RoundRect(X1, Y1, X2, Y2, X3, Y3: Integer);
    {* Draws a rounded rectangle. For more info, see Delphi TCanvas help. }
    {$ENDIF GDI}
    procedure TextOutA(X, Y: Integer; const Text: AnsiString); stdcall;
    {* Draws an ANSI text. For more info, see Delphi TCanvas help. }
    procedure TextOut(X, Y: Integer; const Text: KOLString); stdcall;
    {* Draws a text. For more info, see Delphi TCanvas help. }
    procedure ExtTextOut( X, Y: Integer; Options: DWORD; const Rect: TRect; const Text: AnsiString;
              const Spacing: array of Integer );
    {* }
    procedure TextRect(const Rect: TRect; X, Y: Integer; const Text: Ansistring);
    {* Draws a text, clipping output into given rectangle.
       For more info, see Delphi TCanvas help. }
    {$IFDEF GDI}
    procedure DrawText(Text: AnsiString; var Rect:TRect; Flags:DWord);
    {* }
    {$ENDIF GDI}
    function TextExtent(const Text: Ansistring): TSize;
    {* Calculates size of a Text, using current Font settings.
       Does not need in Handle for Canvas object (if it is not
       yet allocated, temporary device context is created and used. }
    procedure TextArea( const Text : AnsiString; var Sz : TSize; var P0 : TPoint );
    {* Calculates size and starting point to output Text,
       taking into considaration all Font attributes, including
       Orientation (only if GlobalGraphics_UseFontOrient flag
       is set to True, i.e. if rotated fonts are used).
       Like for TextExtent, does not need in Handle (and if this
       last is not yet allocated/assigned, temporary device context
       is created and used). }
    {$IFDEF _D3orHigher}
    procedure WTextArea( const Text : WideString; var Sz : TSize; var P0 : TPoint );
    {* Calculates size and starting point to output Text,
       taking into considaration all Font attributes, including
       Orientation (only if GlobalGraphics_UseFontOrient flag
       is set to True, i.e. if rotated fonts are used).
       Like for TextExtent, does not need in Handle (and if this
       last is not yet allocated/assigned, temporary device context
       is created and used). }
    {$ENDIF _D3orHigher}
    function TextWidth(const Text: Ansistring): Integer;
    {* Calculates text width (using TextArea). }
    function TextHeight(const Text: Ansistring): Integer;
    {* Calculates text height (using TextArea). }
    {$IFDEF GDI}
    function ClipRect: TRect;
    {* returns ClipBox. by Dmitry Zharov. }

    {$IFNDEF _FPC}
    {$IFNDEF _D2} //------- WideString not supported in D2
    procedure WTextOut(X, Y: Integer; const WText: WideString); stdcall;
    {* Draws a Unicode text. }
    procedure WExtTextOut( X, Y: Integer; Options: DWORD; const Rect: TRect;
              const WText: WideString; const Spacing: array of Integer );
    {* }
    procedure WDrawText(WText: WideString; var Rect:TRect; Flags:DWord);
    {* }
    procedure WTextRect(const Rect: TRect; X, Y: Integer;
              const WText: WideString);
    {* Draws a Unicode text, clipping output into given rectangle. }
    function WTextExtent( const WText: WideString ): TSize;
    {* Calculates Unicode text width and height. }
    function WTextWidth( const WText: WideString ): Integer;
    {* Calculates Unicode text width. }
    function WTextHeight( const WText: WideString ): Integer;
    {* Calculates Unicode text height. }
    {$ENDIF _D2}
    {$ENDIF _FPC}

    property ModeCopy : TCopyMode read fCopyMode write fCopyMode;
    {* Current copy mode. Is used in CopyRect method. }
    procedure CopyRect( const DstRect : TRect; SrcCanvas : PCanvas; const SrcRect : TRect );
    {* Copyes a rectangle from source to destination, using StretchBlt. }
    property OnChange: TOnEvent read fOnChange write fOnChange;
    {* }
    function Assign( SrcCanvas : PCanvas ) : Boolean;
    {* }
    {$ENDIF GDI}
    {$IFDEF _X_}
    protected // for _X_ case, RequiredState is protected yet (???)
      procedure ForeBack(fg_color, bk_color: TColor); // install colors just before drawing
    {$ENDIF _X_}
    {$IFDEF GDI}
    function RequiredState( ReqState : DWORD ): HDC; stdcall;// public now
    {* It is possible to call this method before using Handle property
       to pass it into API calls - to provide valid combinations of
       pen, brush and font, selected into device context. This method
       can not provide valid Handle - You always must create it by
       yourself and assign to TCanvas.Handle property manually.
       To optimize assembler version, returns Handle value. }
  public
    {$ENDIF GDI}
    procedure DeselectHandles;
    {* Call this method to deselect all graphic tool objects from the canvas. }
    {$IFDEF GDI}
    property Pixels[ X, Y: Integer ]: TColor read GetPixels write SetPixels;
    {* Obvious. }
    {$ENDIF GDI}
  end;
//[END OF TCanvas DEFINITION]

//[NewCanvas DECLARATION]
function NewCanvas( DC: HDC ): PCanvas;
{* Use to construct Canvas on base of memory DC. }

//[GlobalCanvas_OnTextArea]
var
    GlobalCanvas_OnTextArea : TOnTextArea;
    {* Global event to extend Canvas with possible add-ons, applied
       when rotated fonts are used only (to take into consideration
       Font.Orientation property in TextArea method). }

{$IFDEF WIN_GDI}

//[Extended FUNCTIONS TO WORK WITH CANVAS]
{++}(*
{$IFDEF F_P}
function Windows_Polygon(DC: HDC; var Points; Count: Integer): BOOL; stdcall;
function Windows_Polyline(DC: HDC; var Points; Count: Integer): BOOL; stdcall;
function FillRect(hDC: HDC; const lprc: TRect; hbr: HBRUSH): Integer; stdcall;
function OffsetRect(var lprc: TRect; dx, dy: Integer): BOOL; stdcall;
function CreateAcceleratorTable(var Accel; Count: Integer): HACCEL; stdcall;
function TrackPopupMenu(hMenu: HMENU; uFlags: UINT; x, y, nReserved: Integer;
  hWnd: HWND; prcRect: PRect): BOOL; stdcall;
function AdjustTokenPrivileges(TokenHandle: THandle; DisableAllPrivileges: BOOL;
  const NewState: TTokenPrivileges; BufferLength: DWORD;
  var PreviousState: TTokenPrivileges; var ReturnLength: DWORD): BOOL; stdcall;
function InflateRect(var lprc: TRect; dx, dy: Integer): BOOL; stdcall;
{$IFDEF F_P105ORBELOW}
function InvalidateRect(hWnd: HWND; lpRect: PRect; bErase: BOOL): BOOL; stdcall;
function ValidateRect(hWnd: HWND; lpRect: PRect): BOOL; stdcall;
{$ENDIF F_P105ORBELOW}
{$ENDIF}
*){--}

{ -- Image list object -- }
//[IMAGE LIST]

type
  TImageListColors = (ilcColor,ilcColor4,ilcColor8,ilcColor16,
                      ilcColor24,ilcColor32,ilcColorDDB,ilcDefault);
  {* ImageList color schemes available. }

  TDrawingStyles = ( dsBlend25, dsBlend50, dsMask, dsTransparent );
  {* ImageList drawing styles available. }
  TDrawingStyle = Set of TDrawingStyles;
  {* Style of drawing is a combination of all available drawing styles. }

  TImageType = (itBitmap,itIcon,itCursor);
  {* ImageList types available. }

  {++}(*TImageList = class;*){--}
  PImageList = {-}^{+}TImageList;
  {* }

  TImgLOVrlayIdx = 1..15;

{ ---------------------------------------------------------------------
                TImageList - images container
----------------------------------------------------------------------- }
//[TImageList DEFINITION]
  TImageList = object( TObj )
  {* ImageList incapsulation. }
  protected
    FHandle: THandle;
    FControl: Pointer; // PControl;
    fPrev, fNext: PImageList;
    FColors: TImageListColors;
    FMasked: Boolean;
    FImgWidth: Integer;
    FImgHeight: Integer;
    FDrawingStyle: TDrawingStyle;
    FBlendColor: TColor;
    fBkColor: TColor;
    FAllocBy: Integer;
    FShareImages: Boolean;
    FOverlay: array[ TImgLOVrlayIdx ] of Integer;
    function HandleNeeded : Boolean;
    procedure SetColors(const Value: TImageListColors);
    procedure SetMasked(const Value: Boolean);
    procedure SetImgWidth(const Value: Integer);
    procedure SetImgHeight(const Value: Integer);
    function GetCount: Integer;
    function GetBkColor: TColor;
    procedure SetBkColor(const Value: TColor);
    function GetBitmap: HBitmap;
    function GetMask: HBitmap;
    function GetDrawStyle : DWord;
    procedure SetAllocBy(const Value: Integer);
    function GetHandle: THandle;
    function GetOverlay(Idx: TImgLOVrlayIdx): Integer;
    procedure SetOverlay(Idx: TImgLOVrlayIdx; const Value: Integer);
  protected
    procedure SetHandle(const Value: THandle);
    {*}
  public
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {*}
    property Handle : THandle read GetHandle write SetHandle;
    {* Handle of ImageList object. }
    property ShareImages : Boolean read FShareImages write FShareImages;
    {* True if images are shared between processes (it is set to True,
       if its Handle is assigned to given value, which is a handle of
       already existing ImageList object). }
    property Colors : TImageListColors read FColors write SetColors;
    {* Colors used to represent images. }
    property Masked : Boolean read FMasked write SetMasked;
    {* True, if mask is used. It is set to True, if first added image
       is icon, e.g. }
    property ImgWidth : Integer read FImgWidth write SetImgWidth;
    {* Width of every image in list. If change, ImageList is cleared. }
    property ImgHeight : Integer read FImgHeight write SetImgHeight;
    {* Height of every image in list. If change, ImageList is cleared. }
    property Count : Integer read GetCount;
    {* Number of images in list. }
    property AllocBy : Integer read FAllocBy write SetAllocBy;
    {* Allocation factor. Default is 1. Set it to size of ImageList if this
       value is known - to optimize speed of allocation. }
    property BkColor : TColor read GetBkColor write SetBkColor;
    {* Background color. }
    property BlendColor : TColor read FBlendColor write FBlendColor;
    {* Blend color. }

    property Bitmap : HBitmap read GetBitmap;
    {* Bitmap, containing all ImageList images (tiled horizontally). }
    property Mask : HBitmap read GetMask;
    {* Monochrome bitmap, containing masks for all images in list (if not
       Masked, always returns nil). }
    function ImgRect( Idx : Integer ) : TRect;
    {* Rectangle occupied of given image in ImageList. }

    function Add( Bmp, Msk : HBitmap ) : Integer;
    {* Adds bitmap and given mask to ImageList. }
    function AddMasked( Bmp : HBitmap; Color : TColor ) : Integer;
    {* Adds bitmap to ImageList, using given color to create mask. }
    function AddIcon( Ico : HIcon ) : Integer;
    {* Adds icon to ImageList (always masked). }
    procedure Delete( Idx : Integer );
    {* Deletes given image from ImageList. }
    procedure Clear;
    {* Makes ImageList empty. }
    function Replace( Idx : Integer; Bmp, Msk : HBitmap ) : Boolean;
    {* Replaces given (by index) image with bitmap and its mask with mask bitmap. }
    function ReplaceIcon( Idx : Integer; Ico : HIcon ) : Boolean;
    {* Replaces given (by index) image with an icon. }
    function Merge( Idx : Integer; ImgList2 : PImageList; Idx2 : Integer; X, Y : Integer )
             : PImageList;
    {* Merges two ImageList objects, returns resulting ImageList. }
    function ExtractIcon( Idx : Integer ) : HIcon;
    {* Extracts icon by index. }
    function ExtractIconEx( Idx : Integer ) : HIcon;
    {* Extracts icon (is created using current drawing style). }

    property DrawingStyle : TDrawingStyle read FDrawingStyle write FDrawingStyle;
    {* Drawing style. }
    procedure Draw( Idx : Integer; DC : HDC; X, Y : Integer );
    {* Draws given (by index) image from ImageList onto passed Device Context. }
    procedure StretchDraw( Idx : Integer; DC : HDC; const Rect : TRect );
    {* Draws given image with stratching. }

    function LoadBitmap( ResourceName : PKOLChar; TranspColor : TColor ) : Boolean;
    {* Loads ImageList from resource. }
    //function LoadIcon( ResourceName : PAnsiChar ) : Boolean;
    //function LoadCursor( ResourceName : PAnsiChar ) : Boolean;
    function LoadFromFile( FileName : PKOLChar; TranspColor : TColor; ImgType : TImageType ) : Boolean;
    {* Loads ImageList from file. }
    function LoadSystemIcons( SmallIcons : Boolean ) : Boolean;
    {* Assigns ImageList to system icons list (big or small). }

    property Overlay[ Idx: TImgLOVrlayIdx ]: Integer read GetOverlay write SetOverlay;
    {* Overlay images for image list (images, used as overlay images to draw over
       other images from the image list). These overalay images can be used in
       listview and treeview as overlaying images (up to four masks at the same
       time). }
    {$IFDEF USE_CONSTRUCTORS}
    constructor CreateImageList( POwner: Pointer );
    {$ENDIF USE_CONSTRUCTORS}
  end;
//[END OF TImageList DEFINITION]

//[IMAGE LIST API]

const
  CLR_NONE                = $FFFFFFFF;
  CLR_DEFAULT             = $FF000000;

type
  HImageList = THandle;

const
  ILC_MASK                = $0001;
  ILC_COLOR               = $00FE;
  ILC_COLORDDB            = $00FE;
  ILC_COLOR4              = $0004;
  ILC_COLOR8              = $0008;
  ILC_COLOR16             = $0010;
  ILC_COLOR24             = $0018;
  ILC_COLOR32             = $0020;
  ILC_PALETTE             = $0800;

const
  ILD_NORMAL              = $0000;
  ILD_TRANSPARENT         = $0001;
  ILD_MASK                = $0010;
  ILD_IMAGE               = $0020;
  ILD_BLEND25             = $0002;
  ILD_BLEND50             = $0004;
  ILD_OVERLAYMASK         = $0F00;

const
  ILD_SELECTED            = ILD_BLEND50;
  ILD_FOCUS               = ILD_BLEND25;
  ILD_BLEND               = ILD_BLEND50;
  CLR_HILIGHT             = CLR_DEFAULT;

function ImageList_Create(CX, CY: Integer; Flags: UINT;
  Initial, Grow: Integer): HImageList; stdcall;
function ImageList_Destroy(ImageList: HImageList): Bool; stdcall;
function ImageList_GetImageCount(ImageList: HImageList): Integer; stdcall;
function ImageList_SetImageCount(ImageList: HImageList; Count: Integer): Integer; stdcall;
function ImageList_Add(ImageList: HImageList; Image, Mask: HBitmap): Integer; stdcall;
function ImageList_ReplaceIcon(ImageList: HImageList; Index: Integer;
  Icon: HIcon): Integer; stdcall;
function ImageList_SetBkColor(ImageList: HImageList; ClrBk: TColorRef): TColorRef; stdcall;
function ImageList_GetBkColor(ImageList: HImageList): TColorRef; stdcall;
function ImageList_SetOverlayImage(ImageList: HImageList; Image: Integer;
  Overlay: Integer): Bool; stdcall;

function ImageList_AddIcon(ImageList: HImageList; Icon: HIcon): Integer;

function Index2OverlayMask(Index: Integer): Integer;

function ImageList_Draw(ImageList: HImageList; Index: Integer;
  Dest: HDC; X, Y: Integer; Style: UINT): Bool; stdcall;

function ImageList_Replace(ImageList: HImageList; Index: Integer;
  Image, Mask: HBitmap): Bool; stdcall;
function ImageList_AddMasked(ImageList: HImageList; Image: HBitmap;
  Mask: TColorRef): Integer; stdcall;
function ImageList_DrawEx(ImageList: HImageList; Index: Integer;
  Dest: HDC; X, Y, DX, DY: Integer; Bk, Fg: TColorRef; Style: Cardinal): Bool; stdcall;
function ImageList_Remove(ImageList: HImageList; Index: Integer): Bool; stdcall;
function ImageList_GetIcon(ImageList: HImageList; Index: Integer;
  Flags: Cardinal): HIcon; stdcall;
{$IFDEF UNICODE_CTRLS}
function ImageList_LoadImage(Instance: THandle; Bmp: PWideChar; CX, Grow: Integer;
  Mask: TColorRef; pType, Flags: Cardinal): HImageList; stdcall;
{$ELSE}
function ImageList_LoadImage(Instance: THandle; Bmp: PAnsiChar; CX, Grow: Integer;
  Mask: TColorRef; pType, Flags: Cardinal): HImageList; stdcall;
{$ENDIF}
function ImageList_BeginDrag(ImageList: HImageList; Track: Integer;
  XHotSpot, YHotSpot: Integer): Bool; stdcall;
function ImageList_EndDrag: Bool; stdcall;
function ImageList_DragEnter(LockWnd: HWnd; X, Y: Integer): Bool; stdcall;
function ImageList_DragLeave(LockWnd: HWnd): Bool; stdcall;
function ImageList_DragMove(X, Y: Integer): Bool; stdcall;
function ImageList_SetDragCursorImage(ImageList: HImageList; Drag: Integer;
  XHotSpot, YHotSpot: Integer): Bool; stdcall;
function ImageList_DragShowNolock(Show: Bool): Bool; stdcall;
function ImageList_GetDragImage(Point, HotSpot: PPoint): HImageList; stdcall;

{ macros }
procedure ImageList_RemoveAll(ImageList: HImageList); stdcall;
function ImageList_ExtractIcon(Instance: THandle; ImageList: HImageList;
  Image: Integer): HIcon; stdcall;
function ImageList_LoadBitmap(Instance: THandle; Bmp: PKOLChar;
  CX, Grow: Integer; MasK: TColorRef): HImageList; stdcall;

//function ImageList_Read(Stream: IStream): HImageList; stdcall;
//function ImageList_Write(ImageList: HImageList; Stream: IStream): BOOL; stdcall;

//[TImageInfo]
type
  PImageInfo = ^TImageInfo;
  TImageInfo = packed record
    hbmImage: HBitmap;
    hbmMask: HBitmap;
    Unused1: Integer;
    Unused2: Integer;
    rcImage: TRect;
  end;

function ImageList_GetIconSize(ImageList: HImageList; var CX, CY: Integer): Bool; stdcall;
function ImageList_SetIconSize(ImageList: HImageList; CX, CY: Integer): Bool; stdcall;
function ImageList_GetImageInfo(ImageList: HImageList; Index: Integer;
  var ImageInfo: TImageInfo): Bool; stdcall;
function ImageList_Merge(ImageList1: HImageList; Index1: Integer;
  ImageList2: HImageList; Index2: Integer; DX, DY: Integer)://Bool - ERROR IN VCL
  HImageList; stdcall;

//[LoadBmp]
function LoadBmp( Instance: Integer; Rsrc: PKOLChar; MasterObj: PObj ): HBitmap;

//[BITMAPS]
type
  tagBitmap = Windows.TBitmap;

  TPixelFormat = ( pfDevice, pf1bit, pf4bit, pf8bit, pf15bit, pf16bit, pf24bit,
                   pf32bit, pfCustom );
  {* Available pixel formats. }
  TBitmapHandleType = ( bmDIB, bmDDB );
  {* Available bitmap handle types. }

  {++}(*TBitmap = class;*){--}
  PBitmap = {-}^{+}TBitmap;
{ ----------------------------------------------------------------------
                      TBitmap - bitmap image
----------------------------------------------------------------------- }
//[TBitmap DEFINITION]
  TBitmap = object( TObj )
  {* Bitmap incapsulation object. }
  protected
    fHeight: Integer;
    fWidth: Integer;
    fHandle: HBitmap;
    fCanvas: PCanvas;
    fScanLineSize: Integer;
    fBkColor: TColor;
    fApplyBkColor2Canvas: procedure( Sender: PBitmap );
    fDetachCanvas: procedure( Sender: PBitmap );
    fCanvasAttached : Integer;
    fHandleType: TBitmapHandleType;
    fDIBHeader: PBitmapInfo;
    fDIBBits: Pointer;
    fDIBSize: Integer;
    fNewPixelFormat: TPixelFormat;
    fFillWithBkColor: procedure( BmpObj: PBitmap; DC: HDC; oldW, oldH: Integer );
                        //stdcall;
    fTransMaskBmp: PBitmap;
    fTransColor: TColor;
    fGetDIBPixels: function( Bmp: PBitmap; X, Y: Integer ): TColor;
    fSetDIBPixels: procedure( Bmp: PBitmap; X, Y: Integer; Value: TColor );
    fScanLine0: PByte;
    fScanLineDelta: Integer;
    fPixelMask: DWORD;
    fPixelsPerByteMask: Integer;
    fBytesPerPixel: Integer;
    fDIBAutoFree: Boolean;
    procedure SetHeight(const Value: Integer);
    procedure SetWidth(const Value: Integer);
    function GetEmpty: Boolean;
    function GetHandle: HBitmap;
    function GetHandleAllocated: Boolean;
    procedure SetHandle(const Value: HBitmap);
    procedure SetPixelFormat(Value: TPixelFormat);
    procedure FormatChanged;
    function GetCanvas: PCanvas;
    procedure CanvasChanged( Sender: PObj );
    function GetScanLine(Y: Integer): Pointer;
    function GetScanLineSize: Integer;
    procedure ClearData;
    procedure ClearTransImage;
    procedure SetBkColor(const Value: TColor);
    function GetDIBPalEntries(Idx: Integer): TColor;
    function GetDIBPalEntryCount: Integer;
    procedure SetDIBPalEntries(Idx: Integer; const Value: TColor);
    procedure SetHandleType(const Value: TBitmapHandleType);
    function GetPixelFormat: TPixelFormat;
    function GetPixels(X, Y: Integer): TColor;
    procedure SetPixels(X, Y: Integer; const Value: TColor);
    function GetDIBPixels(X, Y: Integer): TColor;
    procedure SetDIBPixels(X, Y: Integer; const Value: TColor);
    function GetBoundsRect: TRect;
  protected
  {++}(*public*){--}
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
  public
    property Width: Integer read fWidth write SetWidth;
    {* Width of bitmap. To make code smaller, avoid changing Width or Height
       after bitmap is created (using NewBitmap) or after it is loaded from
       file, stream of resource. }
    property Height: Integer read fHeight write SetHeight;
    {* Height of bitmap. To make code smaller, avoid changing Width or Height
       after bitmap is created (using NewBitmap) or after it is loaded from
       file, stream of resource. }
    property BoundsRect: TRect read GetBoundsRect;
    {* Returns rectangle (0,0,Width,Height). }
    property Empty: Boolean read GetEmpty;
    {* Returns True if Width or Height is 0. }
    procedure Clear;
    {* Makes bitmap empty, setting its Width and Height to 0. }
    procedure LoadFromFile( const Filename: KOLString );
    {* Loads bitmap from file (LoadFromStream used). }
    function LoadFromFileEx( const Filename: KOLString ): Boolean;
    {* Loads bitmap from a file. If necessary, bitmap is RLE-decoded. Code given
       by Vyacheslav A. Gavrik. }
    procedure SaveToFile( const Filename: KOLString );
    {* Stores bitmap to file (SaveToStream used). }
    procedure LoadFromStream( Strm: PStream );
    {* Loads bitmap from stream. Follow loading, bitmap has DIB format (without
       handle allocated). It is possible to draw DIB bitmap without creating
       handle for it, which can economy GDI resources. }
    function LoadFromStreamEx( Strm: PStream ): Boolean;
    {* Loads bitmap from a stream. Difference is that RLE decoding supported.
       Code given by Vyacheslav A. Gavrik. }
    procedure SaveToStream( Strm: PStream );
    {* Saves bitmap to stream. If bitmap is not DIB, it is converted to DIB
       before saving. }
    procedure LoadFromResourceID( Inst: DWORD; ResID: Integer );
    {* Loads bitmap from resource using integer ID of resource. To load by name,
       use LoadFromResurceName. To load resource of application itself, pass
       hInstance as first parameter. This method also can be used to load system
       predefined bitmaps, if 0 is passed as Inst parameter:
       |<pre>
       OBM_BTNCORNERS	OBM_REDUCE
       OBM_BTSIZE       OBM_REDUCED
       OBM_CHECK        OBM_RESTORE
       OBM_CHECKBOXES   OBM_RESTORED
       OBM_CLOSE        OBM_RGARROW
       OBM_COMBO        OBM_RGARROWD
       OBM_DNARROW      OBM_RGARROWI
       OBM_DNARROWD     OBM_SIZE
       OBM_DNARROWI     OBM_UPARROW
       OBM_LFARROW      OBM_UPARROWD
       OBM_LFARROWD     OBM_UPARROWI
       OBM_LFARROWI     OBM_ZOOM
       OBM_MNARROW      OBM_ZOOMD
       |</pre>        }
    procedure LoadFromResourceName( Inst: DWORD; ResName: PKOLChar );
    {* Loads bitmap from resurce (using passed name of bitmap resource. }
    function Assign( SrcBmp: PBitmap ): Boolean;
    {* Assigns bitmap from another. Returns False if not success.
       Note: remember, that Canvas is not assigned - only bitmap image
       is copied. And for DIB, handle is not allocating due this process. }
    property Handle: HBitmap read GetHandle write SetHandle;
    {* Handle of bitmap. Created whenever property accessed. To check if handle
       is allocated (without allocating it), use HandleAllocated property. }
    property HandleAllocated: Boolean read GetHandleAllocated;
    {* Returns True, if Handle already allocated. }
    function ReleaseHandle: HBitmap;
    {* Returns Handle and releases it, so bitmap no more know about handle.
       This method does not destroy bitmap image, but converts it into DIB.
       Returned Handle actually is a handle of copy of original bitmap. If
       You need not in keping it up, use Dormant method instead. }
    procedure Dormant;
    {* Releases handle from bitmap and destroys it. But image is not destroyed
       and its data are preserved in DIB format. Please note, that in KOL, DIB
       bitmaps can be drawn onto given device context without allocating of
       handle. So, it is very useful to call Dormant preparing it using
       Canvas drawing operations - to economy GDI resources. }
    property HandleType: TBitmapHandleType read fHandleType write SetHandleType;
    {* bmDIB, if DIB part of image data is filled and stored internally in
       TBitmap object. DIB image therefore can have Handle allocated, which
       require resources. Use HandleAllocated funtion to determine if handle
       is allocated and Dormant method to remove it, if You want to economy
       GDI resources. (Actually Handle needed for DIB bitmap only in case
       when Canvas is used to draw on bitmap surface). Please note also, that
       before saving bitmap to file or stream, it is converted to DIB. }
    property PixelFormat: TPixelFormat read GetPixelFormat write SetPixelFormat;
    {* Current pixel format. If format of bitmap is unknown, or bitmap is DDB,
       value is pfDevice. Setting PixelFormat to any other format converts
       bitmap to DIB, back to pfDevice converts bitmap to DDB again. Avoid
       such conversations for large bitmaps or for numerous bitmaps in your
       application to keep good performance. }
    function BitsPerPixel: Integer;
    {* Returns bits per pixel if possible. }
    procedure Draw( DC: HDC; X, Y: Integer );
    {* Draws bitmap to given device context. If bitmap is DIB, it is always
       drawing using SetDIBitsToDevice API call, which does not require bitmap
       handle (so, it is very sensible to call Dormant method to free correspondent
       GDI resources). }
    procedure StretchDraw( DC: HDC; const Rect: TRect );
    {* Draws bitmap onto DC, stretching it to fit given rectangle Rect. }
    procedure DrawTransparent( DC: HDC; X, Y: Integer; TranspColor: TColor );
    {* Draws bitmap onto DC transparently, using TranspColor as transparent.
       See function DesktopPixelFormat also. }
    procedure StretchDrawTransparent( DC: HDC; const Rect: TRect; TranspColor: TColor );
    {* Draws bitmap onto given rectangle of destination DC (with stretching it
       to fit Rect) - transparently, using TranspColor as transparent.
       See function DesktopPixelFormat also. }
    procedure DrawMasked( DC: HDC; X, Y: Integer; Mask: HBitmap );
    {* Draws bitmap to destination DC transparently by mask. It is possible
       to pass as a mask handle of another TBitmap, previously converted to
       monochrome mask using Convert2Mask method. }
    procedure StretchDrawMasked( DC: HDC; const Rect: TRect; Mask: HBitmap );
    {* Like DrawMasked, but with stretching image onto given rectangle. }
    procedure Convert2Mask( TranspColor: TColor );
    {* Converts bitmap to monochrome (mask) bitmap with TranspColor replaced
       to clBlack and all other ones to clWhite. Such mask bitmap can be used
       to draw original bitmap transparently, with given TranspColor as
       transparent. (To preserve original bitmap, create new instance of
       TBitmap and assign original bitmap to it). See also DrawTransparent and
       StretchDrawTransparent methods. }
    procedure Invert;
    {* Obvious. }
    property Canvas: PCanvas read GetCanvas;
    {* Canvas can be used to draw onto bitmap. Whenever it is accessed, handle
       is allocated for bitmap, if it is not yet (to make it possible
       to select bitmap to display compatible device context). }
    procedure RemoveCanvas;
    {* Call this method to destroy Canvas and free GDI resources. }
    property BkColor: TColor read fBkColor write SetBkColor;
    {* Used to fill background for Bitmap, when its width or height is increased.
       Although this value always synchronized with Canvas.Brush.Color, use it
       instead if You do not use Canvas for drawing on bitmap surface. }
    property Pixels[ X, Y: Integer ]: TColor read GetPixels write SetPixels;
    {* Allows to obtain or change certain pixels of a bitmap. This method is
       both for DIB and DDB bitmaps, and leads to allocate handle anyway. For
       DIB bitmaps, it is possible to use property DIBPixels[ ] instead,
       which is much faster and does not require in Handle. }
    property ScanLineSize: Integer read GetScanLineSize;
    {* Returns size of scan line in bytes. Use it to measure size of a single
       ScanLine. To calculate increment value from first byte of ScanLine to
       first byte of next ScanLine, use difference
       !  Integer(ScanLine[1]-ScanLine[0])
       (this is because bitmap can be oriented from bottom to top, so
       step can be negative). }
    property ScanLine[ Y: Integer ]: Pointer read GetScanLine;
    {* Use ScanLine to access DIB bitmap pixels in memory to direct access it
       fast. Take in attention, that for different pixel formats, different
       bit counts are used to represent bitmap pixels. Also do not forget, that
       for formats pf4bit and pf8bit, pixels actually are indices to palette
       entries, and for formats pf16bit, pf24bit and pf32bit are actually
       RGB values (for pf16bit B:5-G:6-R:5, for pf15bit B:5-G:5-R:5 (high order
       bit not used), for pf24bit B:8-G:8-R:8, and for pf32bit high order byte
       of TRGBQuad structure is not used). }
    property DIBPixels[ X, Y: Integer ]: TColor read GetDIBPixels write SetDIBPixels;
    {* Allows direct access to pixels of DIB bitmap, faster then Pixels[ ]
       property. Access to read is slower for pf15bit, pf16bit formats (because
       some conversation needed to translate packed RGB color to TColor). And
       for write, operation performed most slower for pf4bit, pf8bit (searching
       nearest color required) and fastest for pf24bit, pf32bit and pf1bit. }
    property DIBPalEntryCount: Integer read GetDIBPalEntryCount;
    {* Returns palette entries count for DIB image. Always returns 2 for pf1bit,
       16 for pf4bit, 256 for pf8bit and 0 for other pixel formats. }
    property DIBPalEntries[ Idx: Integer ]: TColor read GetDIBPalEntries write
             SetDIBPalEntries;
    {* Provides direct access to DIB palette. }
    function DIBPalNearestEntry( Color: TColor ): Integer;
    {* Returns index of entry in DIB palette with color nearest (or matching)
       to given one. }
    property DIBBits: Pointer read fDIBBits;
    {* This property is mainly for internal use. }
    property DIBSize: Integer read fDIBSize;
    {* Size of DIBBits array. }
    property DIBHeader: PBitmapInfo read fDIBHeader;
    {* This property is mainly for internal use. }
    procedure DIBDrawRect( DC: HDC; X, Y: Integer; const R: TRect );
    {* This procedure copies given rectangle to the target device context,
       but only for DIB bitmap (using SetDIBBitsToDevice API call). }
    procedure RotateRight;
    {* Rotates bitmap right (90 degree). Bitmap must be DIB. If You definitevely
       know format of a bitmap, use instead one of methods RotateRightMono,
       RotateRight4bit, RotateRight8bit, RotateRight16bit or RotateRightTrueColor
       - this will economy code. But if for most of formats such methods are
       called, this can be more economy just to call always universal method
       RotateRight. }
    procedure RotateLeft;
    {* Rotates bitmap left (90 degree). Bitmap must be DIB. If You definitevely
       know format of a bitmap, use instead one of methods RotateLeftMono,
       RotateLeft4bit, RotateLeft8bit, RotateLeft16bit or RotateLeftTrueColor
       - this will economy code. But if for most of formats such methods are
       called, this can be more economy just to call always universal method
       RotateLeft. }
    procedure RotateRightMono;
    {* Rotates bitmat right, but only if bitmap is monochrome (pf1bit). }
    procedure RotateLeftMono;
    {* Rotates bitmap left, but only if bitmap is monochrome (pf1bit). }
    procedure RotateRight4bit;
    {* Rotates bitmap right, but only if PixelFormat is pf4bit. }
    procedure RotateLeft4bit;
    {* Rotates bitmap left, but only if PixelFormat is pf4bit. }
    procedure RotateRight8bit;
    {* Rotates bitmap right, but only if PixelFormat is pf8bit. }
    procedure RotateLeft8bit;
    {* Rotates bitmap left, but only if PixelFormat is pf8bit. }
    procedure RotateRight16bit;
    {* Rotates bitmap right, but only if PixelFormat is pf16bit. }
    procedure RotateLeft16bit;
    {* Rotates bitmap left, but only if PixelFormat is pf16bit. }
    procedure RotateRightTrueColor;
    {* Rotates bitmap right, but only if PixelFormat is pf24bit or pf32bit. }
    procedure RotateLeftTrueColor;
    {* Rotates bitmap left, but only if PixelFormat is pf24bit or pf32bit. }
    procedure FlipVertical;
    {* Flips bitmap vertically }
    procedure FlipHorizontal;
    {* Flips bitmap horizontally }
    procedure CopyRect( const DstRect : TRect; SrcBmp : PBitmap; const SrcRect : TRect );
    {* It is possible to use Canvas.CopyRect for such purpose, but if You
       do not want use TCanvas, it is possible to copy rectangle from one
       bitmap to another using this function. }
    function CopyToClipboard: Boolean;
    {* Copies bitmap to clipboard. }
    function PasteFromClipboard: Boolean;
    {* Takes CF_DIB format bitmap from clipboard and assigns it to the
       TBitmap object. }
  end;
//[END OF TBitmap DEFINITION]

//
function Bits2PixelFormat( BitsPerPixel: Integer ): TPixelFormat;

//[NewBitmap DECLARATION]
function NewBitmap( W, H: Integer ): PBitmap;
{* Creates bitmap object of given size. If it is possible, do not change its
   size (Width and Heigth) later - this can economy code a bit. See TBitmap. }

function NewDIBBitmap( W, H: Integer; PixelFormat: TPixelFormat ): PBitmap;
{* Creates DIB bitmap object of given size and pixel format. If it is possible,
   do not change its size (Width and Heigth) later - this can economy code a bit.
   See TBitmap. }

//[CalcScanLineSize DECLARATION]
function CalcScanLineSize( Header: PBitmapInfoHeader ): Integer;
{* May be will be useful. }

//[DefaultPixelFormat VARIABLE]
var
  //DefaultBitsPerPixel: Integer = 16;
  DefaultPixelFormat: TPixelFormat = pf16bit;

//[Mapped bitmaps]

{ -- Function to load bitmap mapping some its colors. -- }
function LoadMappedBitmap( hInst: THandle; BmpResID: Integer; const Map: array of TColor )
         : HBitmap;
{* This function can be used to load bitmap and replace some it colors to
   desired ones. This function especially useful when loaded by the such way
   bitmap is used as toolbar bitmap - to replace some original colors to
   system default colors. To use this function properly, the bitmap shoud
   be prepared as 16-color bitmap, which uses only system colors. To do so,
   create a new 16-color bitmap with needed dimensions in Borland Image Editor
   and paste a bitmap image, copyed in another graphic tool, and then save it.
   If this is not done, bitmap will not be loaded correctly! }
function LoadMappedBitmapEx( MasterObj: PObj; hInst: THandle; BmpResName: PKOLChar;
         const Map: array of TColor ): HBitmap;
{* by Alex Pravdin: like LoadMappedBitmap, but much powerful. It uses
   CreateMappedBitmapEx, so it understands any bitmap color format, including
   pf24bit. Also, LoadMappedBitmapEx provides auto-destroying loaded resource
   when MasterObj is destroyed. }
function CreateMappedBitmap(Instance: THandle; Bitmap: Integer;
  Flags: UINT; ColorMap: PColorMap; NumMaps: Integer): HBitmap; stdcall;
{* Creates mapped bitmap replacing colors correspondently to the
   ColorMap (each pare of colors defines color replaced and a color
   used for replace it in the bitmap). See also CreateMappedBitmapEx. }
function CreateMappedBitmapEx(Instance: THandle; BmpRsrcName: PKOLChar; Flags:
  Cardinal; ColorMap: PColorMap; NumMaps: Integer): HBitmap;
{* By Alex Pravdin.
Creates mapped bitmap independently from bitmap color format (works
correctly with bitmaps having format deeper than 8bit per pixel). }

//[ICONS]

type
  {++}(*TIcon = class;*){--}
  PIcon = {-}^{+}TIcon;
{ ----------------------------------------------------------------------
                          TIcon - icon image
----------------------------------------------------------------------- }
//[TIcon DEFINITION]
  TIcon = object( TObj )
  {* Object type to incapsulate icon or cursor image. }
  protected
    {$IFDEF ICON_DIFF_WH}
    FWidth: Integer;
    FHeight: Integer;
    {$ELSE}
    FSize : Integer;
    {$ENDIF}
    FHandle: HIcon;
    FShareIcon: Boolean;
    procedure SetSize(const Value: Integer);
    {$IFDEF ICON_DIFF_WH}
    function GetIconSize: Integer;
    {$ENDIF}
    procedure SetHandle(const Value: HIcon);
    function GetHotSpot: TPoint;
    function GetEmpty: Boolean;
  protected
  {++}(*public*){--}
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
  public
    {$IFDEF ICONLOAD_PRESERVEBMPS}
    ImgBmp, MskBmp : PBitmap;
    Only_Bmp: Boolean;
    {$ENDIF ICONLOAD_PRESERVEBMPS}
    property Size : Integer read
      {$IFDEF ICON_DIFF_WH}
      GetIconSize
      {$ELSE}
      FSize
      {$ENDIF}
    write SetSize;
    {* Icon dimension (width and/or height, which are equal to each other always). }
    {$IFDEF ICON_DIFF_WH}
    property Width: Integer read FWidth;
    property Height: Integer read FHeight;
    {$ENDIF}
    property Handle : HIcon read FHandle write SetHandle;
    {* Windows icon object handle. }
    procedure SetHandleEx( NewHandle: HIcon );
    {* Set Handle without changing Size (Width/Height). }
    procedure Clear;
    {* Clears icon, freeing image and allocated GDI resource (Handle). }
    property Empty: Boolean read GetEmpty;
    {* Returns True if icon is Empty. }
    property ShareIcon : Boolean read FShareIcon write FShareIcon;
    {* True, if icon object is shared and can not be deleted when TIcon object
       is destroyed (set this flag is to True, if an icon is obtained from another
       TIcon object, for example). }
    property HotSpot : TPoint read GetHotSpot;
    {* Hot spot point - for cursors. }
    procedure Draw( DC : HDC; X, Y : Integer );
    {* Draws icon onto given device context. Icon always is drawn transparently
       using its transparency mask (stored internally in icon object). }
    procedure StretchDraw( DC : HDC; Dest : TRect );
    {* Draws icon onto given device context with stretching it to fit destination
       rectangle. See also Draw. }
    procedure LoadFromStream( Strm : PStream );
    {* Loads icon from stream. If stream contains several icons (of
       different dimentions), icon with the most appropriate size is loading. }
    procedure LoadFromFile( const FileName : KOLString );
    {* Load icon from file. If file contains several icons (of
       different dimensions), icon with the most appropriate size is loading. }
    procedure LoadFromResourceID( Inst: Integer; ResID: Integer; DesiredSize: Integer );
    {* Loads icon from resource. To load system default icon, pass 0 as Inst and
       one of followin values as ResID:
       |<pre>
       IDI_APPLICATION  Default application icon.
       IDI_ASTERISK     Asterisk (used in informative messages).
       IDI_EXCLAMATION  Exclamation point (used in warning messages).
       IDI_HAND         Hand-shaped icon (used in serious warning messages).
       IDI_QUESTION     Question mark (used in prompting messages).
       IDI_WINLOGO      Windows logo.
       |</pre> It is also possible to load icon from resources of another module,
       if pass instance handle of loaded module as Inst parameter. }
    procedure LoadFromResourceName( Inst: Integer; ResName: PKOLChar; DesiredSize: Integer );
    {* Loads icon from resource. To load own application resource, pass
       hInstance as Inst parameter. It is possible to load resource from
       another module, if pass its instance handle as Inst. }
    procedure LoadFromExecutable( const FileName: KOLString; IconIdx: Integer );
    {* Loads icon from executable (exe or dll file). Always default sized icon
       is loaded. It is possible also to get know how much icons are contained
       in executable using gloabl function GetFileIconCount. To obtain icon of
       another size, try to load given executable and use LoadFromResourceID
       method. }
    procedure SaveToStream( Strm : PStream );
    {* Saves single icon to stream. To save icons with several different
       dimensions, use global procedure SaveIcons2Stream. }
    procedure SaveToFile( const FileName : KOLString );
    {* Saves single icon to file. To save icons with several different
       dimensions, use global procedure SaveIcons2File. }
    function Convert2Bitmap( TranColor: TColor ): HBitmap;
    {* Converts icon to bitmap, returning Windows GDI bitmap resource as
       a result. It is possible later to assign returned bitmap handle to
       Handle property of TBitmap object to use features of TBitmap.
       Pass TranColor to replace transparent area of icon with given color. }
  end;
//[END OF TIcon DEFINITION]

//[Icon save functions]

  procedure SaveIcons2Stream( const Icons : array of PIcon; Strm : PStream );
  {* Saves several icons (of different dimentions) to stream. }
  function SaveIcons2StreamEx( const BmpHandles: array of HBitmap; Strm: PStream ): Boolean;
  {* Saves icons creating it from pairs of bitmaps and their masks.
     BmpHandles array must contain pairs of bitmap handles, each pair
     of color bitmap and mask bitmap of the same size. }
  procedure SaveIcons2File( const Icons : array of PIcon; const FileName : KOLString );
  {* Saves several icons (of different dimentions) to file. (Single file
     with extension .ico can contain several different sized icon images
     to use later one with the most appropriate size). }

//[NewIcon DECLARATION]
  function NewIcon: PIcon;
  {* Creates new icon object, setting its Size to 32 by default. Created icon
     is Empty. }

//[GetFileIconCount DECLARATION]
  function GetFileIconCount( const FileName: KOLString ): Integer;
  {* Returns number of icon resources stored in given (executable) file. }

//[ICON STRUCTURES]
type
  TIconHeader = packed record
    idReserved: Word; (* Always set to 0 *)
    idType: Word;     (* Always set to 1 *)
    idCount: Word;    (* Number of icon images *)
    (* immediately followed by idCount TIconDirEntries *)
  end;

  TIconDirEntry = packed record
    bWidth: Byte;          (* Width *)
    bHeight: Byte;         (* Height *)
    bColorCount: Byte;     (* Nr. of colors used *)
    bReserved: Byte;       (* not used, 0 *)
    wPlanes: Word;         (* not used, 0 *)
    wBitCount: Word;       (* not used, 0 *)
    dwBytesInRes: Longint; (* total number of bytes in images *)
    dwImageOffset: Longint;(* location of image from the beginning of file *)
  end;

//[LoadImgIcon DECLARATION]
function LoadImgIcon( RsrcName: PKOLChar; Size: Integer ): HIcon;
{* Loads icon of specified size from the resource. }

////////////////////////////////////////////////////////////////////////////////
//                       UNIVERSAL CONTROL OBJECT                             //
////////////////////////////////////////////////////////////////////////////////

//[CM_XXX CONSTANTS]

const
  CM_EXECPROC       = $8FFF;
  CM_BASE           = $B000;
  CM_ACTIVATE       = CM_BASE + 0;
  CM_DEACTIVATE     = CM_BASE + 1;
  CM_ENTER          = CM_BASE + 2;
  CM_RELEASE        = CM_BASE + 3;
  CM_QUIT           = CM_BASE + 4;
  CM_COMMAND        = CM_BASE + 5;
  CM_MEASUREITEM    = CM_BASE + 6;
  CM_DRAWITEM       = CM_BASE + 7;
  CM_TRAYICON       = CM_BASE + 8;
  CM_INVALIDATE     = CM_BASE + 9;
  CM_UPDATE         = CM_BASE + 10;
  CM_NCUPDATE       = CM_BASE + 11;
  CM_SIZEPOS        = CM_BASE + 12;
  CM_SIZE           = CM_BASE + 13;
  CM_SETFOCUS       = CM_BASE + 14;
  CM_CBN_SELCHANGE  = 15;

  CM_UIACTIVATE     = CM_BASE + 16;
  CM_UIDEACTIVATE   = CM_BASE + 17;
  CM_PROCESS        = CM_BASE + 18;
  CM_SHOW           = CM_BASE + 19;

  CM_AUTOSIZE          = CM_BASE + 20;
  CM_MDIClientShowEdge = CM_BASE + 21;

  CM_INVALIDATECHILD   = CM_BASE + 22;
  CM_FOCUSGRAPHCTL     = CM_BASE + 23;

  WM_SYNCPAINT         = $88;

//[CN_XXX CONSTANTS]

  CN_BASE = $BC00;
  CN_CHARTOITEM        = CN_BASE + WM_CHARTOITEM;
  CN_COMMAND           = CN_BASE + WM_COMMAND;
  CN_COMPAREITEM       = CN_BASE + WM_COMPAREITEM;

  CN_CTLCOLORMSGBOX    = CN_BASE + WM_CTLCOLORMSGBOX;
  CN_CTLCOLOREDIT      = CN_BASE + WM_CTLCOLOREDIT;
  CN_CTLCOLORLISTBOX   = CN_BASE + WM_CTLCOLORLISTBOX;
  CN_CTLCOLORBTN       = CN_BASE + WM_CTLCOLORBTN;
  CN_CTLCOLORDLG       = CN_BASE + WM_CTLCOLORDLG;
  CN_CTLCOLORSCROLLBAR = CN_BASE + WM_CTLCOLORSCROLLBAR;
  CN_CTLCOLORSTATIC    = CN_BASE + WM_CTLCOLORSTATIC;

  CN_DELETEITEM        = CN_BASE + WM_DELETEITEM;
  CN_DRAWITEM          = CN_BASE + WM_DRAWITEM;
  CN_HSCROLL           = CN_BASE + WM_HSCROLL;
  CN_MEASUREITEM       = CN_BASE + WM_MEASUREITEM;
  CN_PARENTNOTIFY      = CN_BASE + WM_PARENTNOTIFY;
  CN_VKEYTOITEM        = CN_BASE + WM_VKEYTOITEM;
  CN_VSCROLL           = CN_BASE + WM_VSCROLL;
  CN_KEYDOWN           = CN_BASE + WM_KEYDOWN;
  CN_KEYUP             = CN_BASE + WM_KEYUP;
  CN_CHAR              = CN_BASE + WM_CHAR;
  CN_SYSKEYDOWN        = CN_BASE + WM_SYSKEYDOWN;
  CN_SYSCHAR           = CN_BASE + WM_SYSCHAR;
  CN_NOTIFY            = CN_BASE + WM_NOTIFY;

{$ENDIF WIN_GDI}
//[ID_SELF DEFINED]
const
  ID_SELF: array[ 0..5 ] of KOLChar = ( 'S','E','L','F','_',#0 );
  {* Identifier for window property "Self", stored directly in window, when
     it is created. This property is used to [fast] find TControl object,
     correspondent to given window handle (using API call GetProp). }
{$IFDEF WIN_GDI}

//[ID_PREVPROC DEFINED]
  ID_PREVPROC: array[ 0..9 ] of KOLChar = ( 'P','R','E','V','_','P','R','O','C',#0 );
  {* }

{$ENDIF WIN_GDI}
//[MK_ALT DEFINED]
const
  MK_LBUTTON = 1;
  MK_RBUTTON = 2;
  MK_SHIFT = 4;
  MK_CONTROL = 8;
  MK_MBUTTON = $10;
  MK_ALT = $20;
  MK_LOCK = $40; // CAPS LOCK or SHIFT LOCK 
{$IFDEF WIN_GDI}

{$IFNDEF NOT_USE_RICHEDIT}
//[RICHEDIT STRUCTURES]
type
  {$IFDEF UNICODE_CTRLS}
  TCharFormat2 = TCharFormat2W;
  {$ELSE}
  {$IFDEF _D3orHigher}
  TCharFormat2 = TCharFormat2A;
  {$ELSE} // Delphi2
  TCharFormat2 = packed record
    cbSize: UINT;
    dwMask: DWORD;
    dwEffects: DWORD;
    yHeight: Longint;
    yOffset: Longint;
    crTextColor: TColorRef;
    bCharSet: Byte;
    bPitchAndFamily: Byte;
    szFaceName: array[0..LF_FACESIZE - 1] of KOLChar;
    R2Bytes: Word;
    wWeight: Word;                   { Font weight (LOGFONT value)		 }
    sSpacing: Smallint;              { Amount to space between letters	 }
    crBackColor: TColorRef;          { Background color					 }
    lid: LCID;                       { Locale ID						 }
    dwReserved: DWORD;               { Reserved. Must be 0				 }
    sStyle: Smallint;                { Style handle						 }
    wKerning: Word;                  { Twip size above which to kern char pair }
    bUnderlineType: Byte;            { Underline type					 }
    bAnimation: Byte;                { Animated text like marching ants	 }
    bRevAuthor: Byte;                { Revision author index			 }
    bReserved1: Byte;
  end;  {$ENDIF _D3orHigher}
  {$ENDIF}

  TParaFormat2 = packed record
    cbSize: UINT;
    dwMask: DWORD;
    wNumbering: Word;
    wReserved: Word;
    dxStartIndent: Longint;
    dxRightIndent: Longint;
    dxOffset: Longint;
    wAlignment: Word;
    cTabCount: Smallint;
    rgxTabs: array [0..MAX_TAB_STOPS - 1] of Longint;
    dySpaceBefore: Longint;     { Vertical spacing before para			 }
    dySpaceAfter: Longint;      { Vertical spacing after para			 }
    dyLineSpacing: Longint;     { Line spacing depending on Rule		 }
    sStyle: Smallint;           { Style handle							 }
    bLineSpacingRule: Byte;     { Rule for line spacing (see tom.doc)	 }
    bCRC: Byte;                 { Reserved for CRC for rapid searching	 }
    wShadingWeight: Word;       { Shading in hundredths of a per cent	 }
    wShadingStyle: Word;        { Nibble 0: style, 1: cfpat, 2: cbpat	 }
    wNumberingStart: Word;      { Starting value for numbering			 }
    wNumberingStyle: Word;      { Alignment, roman/arabic, (), ), ., etc. }
    wNumberingTab: Word;        { Space bet 1st indent and 1st-line text }
    wBorderSpace: Word;         { Space between border and text (twips) }
    wBorderWidth: Word;         { Border pen width (twips)				 }
    wBorders: Word;             { Byte 0: bits specify which borders	 }
                                { Nibble 2: border style, 3: color index }
  end;

  TGetTextLengthEx = packed record
    flags: DWORD;              { flags (see GTL_XXX defines)				 }
    codepage: UINT;            { code page for translation (CP_ACP for default,
                                 1200 for Unicode 					 }
  end;

const
  PFM_SPACEBEFORE                     = $00000040;
  PFM_SPACEAFTER                      = $00000080;
  PFM_LINESPACING                     = $00000100;
  PFM_STYLE                           = $00000400;
  PFM_BORDER                          = $00000800;      { (*)	 }
  PFM_SHADING                         = $00001000;      { (*)	 }
  PFM_NUMBERINGSTYLE                  = $00002000;      { (*)	 }
  PFM_NUMBERINGTAB                    = $00004000;      { (*)	 }
  PFM_NUMBERINGSTART                  = $00008000;      { (*)	 }

  PFM_RTLPARA                         = $00010000;
  PFM_KEEP                            = $00020000;      { (*)	 }
  PFM_KEEPNEXT                        = $00040000;      { (*)	 }
  PFM_PAGEBREAKBEFORE                 = $00080000;      { (*)	 }
  PFM_NOLINENUMBER                    = $00100000;      { (*)	 }
  PFM_NOWIDOWCONTROL                  = $00200000;      { (*)	 }
  PFM_DONOTHYPHEN                     = $00400000;      { (*)	 }
  PFM_SIDEBYSIDE                      = $00800000;      { (*)	 }

  PFM_TABLE                           = $c0000000;      { (*)	 }
  EM_REDO                             = WM_USER + 84;
  EM_AUTOURLDETECT                    = WM_USER + 91;
  EM_GETAUTOURLDETECT                 = WM_USER + 92;
  CFM_UNDERLINETYPE           = $00800000;              { (*)	 }
  CFM_HIDDEN                  = $0100;                  { (*)	 }
  CFM_BACKCOLOR               = $04000000;
  CFE_AUTOBACKCOLOR           = CFM_BACKCOLOR;
  GTL_USECRLF         = 1;      { compute answer using CRLFs for paragraphs }
  GTL_PRECISE         = 2;      { compute a precise answer					 }
  GTL_CLOSE           = 4;      { fast computation of a "close" answer		 }
  GTL_NUMCHARS        = 8;      { return the number of characters			 }
  GTL_NUMBYTES        = 16;     { return the number of _bytes_				 }
  EM_GETTEXTLENGTHEX                  = WM_USER + 95;
  EM_SETLANGOPTIONS                   = WM_USER + 120;
  EM_GETLANGOPTIONS                   = WM_USER + 121;

  EM_SETEDITSTYLE = $400 + 204;
  EM_GETEDITSTYLE = $400 + 205;

  SES_EMULATESYSEDIT = 1;
  SES_BEEPONMAXTEXT = 2;
  SES_EXTENDBACKCOLOR = 4;
  SES_MAPCPS = 8;
  SES_EMULATE10 = 16;
  SES_USECRLF = 32;
  SES_USEAIMM = 64;
  SES_NOIME = 128;
  SES_ALLOWBEEPS = 256;
  SES_UPPERCASE = 512;
  SES_LOWERCASE = 1024;
  SES_NOINPUTSEQUENCECHK = 2048;
  SES_BIDI = 4096;
  SES_SCROLLONKILLFOCUS = 8192;
  SES_XLTCRCRLFTOCR = 16384;

  EM_GETSCROLLPOS = WM_USER + 221;
  EM_SETSCROLLPOS = WM_USER + 222;
  EM_GETZOOM	  = WM_USER + 224;
  EM_SETZOOM      = WM_USER + 225;
{$ENDIF NOT_USE_RICHEDIT}
{$ENDIF WIN_GDI}

//[CONTROLS]

type
  {++}(*TControl = class;*){--}
  PControl = {-}^{+}TControl;
  {* Type of pointer to TControl visual object. All
     |<a href="kol_pas.htm#visual_objects_constructors">
     constructing functions
     |</a>
     New[ControlName] are returning
     pointer of this type. Do not forget about some difference
     of using objects from using classes. Identifier Self for
     methods of object is not of pointer type, and to pass
     pointer to Self, it is necessary to pass @Self instead.
     At the same time, to use pointer to object in 'WITH' operator,
     it is necessary to apply suffix '^' to pointer to get know
     to compiler, what do You want. }
{$IFDEF WIN}
//[TWindowFunc TYPE]
  TWindowFunc = function( Sender: PControl; var Msg: TMsg; var Rslt: Integer )
                          : Boolean;
{$ENDIF WIN}
  {* Event type to define custom extended message handlers (as pointers to
     procedure entry points). Such handlers are usually defined like add-ons,
     extending behaviour of certain controls and attached using AttachProc
     method of TControl. If the handler detects, that it is necessary to stop
     further message processing, it should return True. }

//[Mouse TYPES]
  TMouseButton = ( mbNone, mbLeft, mbRight, mbMiddle );
  {* Available mouse buttons. mbNone is useful to get know, that
     there were no mouse buttons pressed. }

  TMouseEventData = packed Record
  {* Record to pass it to mouse handling routines, assigned to OnMouseXXXX
     events. }
    Button: TMouseButton;
    StopHandling: Boolean; // Set it to True in OnMouseXXXX event handler to
                           // stop further processing
    R1, R2: Byte; // Not used
    Shift : DWORD;    // HiWord( Shift ) = zDelta in WM_MOUSEWHEEL
    X, Y  : SmallInt;
  end;

  TOnMouse = procedure( Sender: PControl; var Mouse: TMouseEventData ) of object;
  {* Common mouse handling event type. }

//[Key TYPES]
  TOnKey = procedure( Sender: PControl; var Key: Longint; Shift: DWORD ) of object;
  {* Key events. Shift is a combination of flags MK_SHIFT, MK_CONTROL, MK_ALT.
     (See GetShiftState funtion). }

  TOnChar = procedure( Sender: PControl; var Key: KOLChar; Shift: DWORD ) of object;
  {* Char event. Shift is a combination of flags MK_SHIFT, MK_CONTROL, MK_ALT. }

  TTabKey = ( tkTab, tkLeftRight, tkUpDown, tkPageUpPageDn );
  {* Available tabulating key groups. }
  TTabKeys = Set of TTabKey;
  {* Set of tabulating key groups, allowed to be used in with a control
     (are installed by TControl.LookTabKey property). }

//[Event TYPES]
{$IFDEF WIN}
  TOnMessage = function( var Msg: TMsg; var Rslt: Integer ): Boolean of object;
  {* Event type for events, which allows to extend behaviour of windowed controls
     descendants using add-ons. }
{$ENDIF WIN}

  TOnEventAccept = procedure( Sender: PObj; var Accept: Boolean ) of object;
  {* Event type for OnClose event. }
  TCloseQueryReason = ( qClose, qShutdown, qLogoff );
  {* Request reason type to call OnClose and OnQueryEndSession. }
  TWindowState = ( wsNormal, wsMinimized, wsMaximized );
  {* Avalable states of TControl's window object. }

  TOnSplit = function( Sender: PControl; NewSize1, NewSize2: Integer ): Boolean of object;
  {* Event type for OnSplit event handler, designed specially for splitter
     control. Event handler must return True to accept new size of previous
     (to splitter) control and new size of the rest of client area of parent. }

  TOnTVBeginDrag = procedure( Sender: PControl; Item: THandle ) of object;
  {* Event type for OnTVBeginDrag event (defined for tree view control). }
  TOnTVBeginEdit = function( Sender: PControl; Item: THandle ): Boolean of object;
  {* Event type for OnTVBeginEdit event (for tree view control). }
  TOnTVEndEdit = function( Sender: PControl; Item: THandle; const NewTxt: KOL_String )
               : Boolean of object;
  {* Event type for TOnTVEndEdit event. }
  TOnTVExpanding = function( Sender: PControl; Item: THandle; Expand: Boolean )
                 : Boolean of object;
  {* Event type for TOnTVExpanding event. }
  TOnTVExpanded = procedure( Sender: PControl; Item: THandle; Expand: Boolean )
                of object;
  {* Event type for OnTVExpanded event. }
  TOnTVDelete = procedure( Sender: PControl; Item: THandle ) of object;
  {* Event type for OnTVDelete event. }

  //--------- by Sergey Shisminzev:
  TOnTVSelChanging = function(Sender: PControl; oldItem, newItem: THandle): Boolean  //~ss
                  of object;
  {* When the handler returns False, selection is not changed. }
  //-------------------------------
  TOnDrag = function( Sender: PControl; ScrX, ScrY: Integer; var CursorShape: Integer;
            var Stop: Boolean ): Boolean of object;
  {* Event, called during dragging operation (it is initiated
     with method Drag, where callback function of type TOnDrag is
     passed as a parameter). Callback function receives Stop parameter True,
     when operation is finishing. Otherwise, it can set it to True to force
     finishing the operation (in such case, returning False means cancelling
     drag operation, True - successful drag and in this last case callback is
     no more called). During the operation, when input Stop value is False,
     callback function can control Cursor shape, and return True, if the operation
     can be finished successfully at the given ScrX, ScrY position.
     ScrX, ScrY are screen coordinates of the mouse cursor. }

{$IFDEF WIN}
//[Create Window STRUCTURES]
  TCreateParams = packed record
  {* Record to pass it through CreateSubClass method. }
	Caption: PKOLChar;
    Style: cardinal;
    ExStyle: cardinal;
    X, Y: Integer;
    Width, Height: Integer;
    WndParent: HWnd;
    Param: Pointer;
    WindowClass: TWndClass;
    WinClassName: array[0..63] of KOLChar;
  end;

  TCreateWndParams = packed Record
    ExStyle: DWORD;
	WinClassName: PKOLChar;
	Caption: PKOLChar;
    Style: DWORD;
    X, Y, Width, Height: Integer;
    WndParent: HWnd;
    Menu: HMenu;
    Inst: THandle;
    Param: Pointer;
	WinClsNamBuf: array[ 0..63 ] of KOLChar;
	WindowClass: TWndClass;
  end;

//[COMMAND ACTIONS TYPE FOR DIFFERENT CONTROLS]
  PCommandActions = ^TCommandActions;
  TCommandActions = packed Record
    aClear: procedure( Sender: PControl );
    aAddText: procedure( Sender: PControl; const S: AnsiString );
    aClick, aEnter, aLeave: WORD; aChange: SmallInt; aSelChange: SmallInt;
    aGetCount, aSetCount, aGetItemLength, aGetItemText, aSetItemText,
    aGetItemData, aSetItemData: WORD;
    aAddItem, aDeleteItem, aInsertItem: WORD;
    aFindItem, aFindPartial: WORD;
    aItem2Pos, aPos2Item: BYTE;
    {aGetSelStart,} aGetSelCount, aGetSelected, aGetSelRange,
    {aExGetSelRange,} aGetCurrent,
    aSetSelected, aSetCurrent, aSetSelRange, aExSetSelRange,
    aGetSelection, aReplaceSel: WORD;
    aTextAlignLeft, aTextAlignRight, aTextAlignCenter: WORD;
    aTextAlignMask: Byte;
    aVertAlignCenter, aVertAlignTop, aVertAlignBottom: Byte;
    aDir, aSetLimit: Word; aSetImgList: Word;
    aAutoSzX, aAutoSzY: Word;
    aSetBkColor: Word;
    aItem2XY: Word;
  end;
{$ENDIF WIN}

//[Align TYPES]
  TTextAlign = ( taLeft, taRight, taCenter );
  {* Text alignments available. }
  TRichTextAlign = ( raLeft, raRight, raCenter,
                 // all other are only set but can not be displayed:
                 raJustify, // displayed like raLeft (though stored normally)
                 raInterLetter, raScaled, raGlyphs, raSnapGrid );
  {* Text alignment styles, available for RichEdit control. }
  TVerticalAlign = ( vaCenter, vaTop, vaBottom );
  {* Vertical alignments available. }
  TControlAlign = ( caNone, caLeft, caTop, caRight, caBottom, caClient );
  {* Control alignments available. }
  TAligning = (oaWaitAlign,oaFromSelf,oaAligning);
  TAlignings = set of TAligning;

//[BitBtn TYPES]
  TBitBtnOption = ( bboImageList,
                    bboNoBorder,
                    bboNoCaption,
                    bboFixed,
                    bboFocusRect );
  {* Options available for NewBitBtn. }
  TBitBtnOptions = set of TBitBtnOption;
  {* Set of options, available for NewBitBtn. }
  TGlyphLayout = ( glyphLeft, glyphTop, glyphRight, glyphBottom, glyphOver );
  {* Layout of glyph (for NewBitBtn). Layout glyphOver means that text is
     drawn over glyph. }
  TOnBitBtnDraw = function( Sender: PControl; BtnState: Integer ): Boolean of object;
  {* Event type for TControl.OnBitBtnDraw event (which is called just before
     drawing the BitBtn). If handler returns True, there are no drawing occure.
     BtnState, passed to a handler, determines current button state and can
     be following: 0 - not pressed, 1 - pressed, 2 - disabled, 3 - focused.
     Value 4 is reserved for highlight state (then mouse is over it), but
     highlighting is provided only if property Flat is set to True (or one
     of events OnMouseEnter / OnMouseLeave is assigned to something). }

//[ListView TYPES]
  TListViewStyle = ( lvsIcon, lvsSmallIcon, lvsList, lvsDetail, lvsDetailNoHeader );
  {* Styles of view for ListView control (see NewListVew). }

  TListViewItemStates = ( lvisFocus, lvisSelect, lvisBlend, lvisHighlight );
  TListViewItemState = Set of TListViewItemStates;
  TListViewOption = (
    lvoIconLeft,      // in lvsIcon, lvsSmallIcon place icon left from text (rather then top)
    lvoAutoArrange,   // keep icons auto arranged in lvsIcon and lvsSmallIcon view
    lvoButton,        // icons look like buttons in lvsIcon view
    lvoEditLabel,     // allows edit labels inplace (first column #0 text)
    lvoNoLabelWrap,   // item text on a single line in lvsIcon view (by default, item text may wrap in lvsIcon view).
    lvoNoScroll,      // obvious
    lvoNoSortHeader,  // click on header button does not lead to sort items
    lvoHideSel,       // hide selection when not in focus
    lvoMultiselect,   // allow to select multiple items
    lvoSortAscending,
    lvoSortDescending,
      // extended styles (not documented in my Win32.hlp :( , got from VCL source:
    lvoGridLines,
    lvoSubItemImages,
    lvoCheckBoxes,
    lvoTrackSelect,
    lvoHeaderDragDrop,
    lvoRowSelect,
    lvoOneClickActivate,
    lvoTwoClickActivate,
    lvoFlatsb,
    lvoRegional,
    lvoInfoTip,
    lvoUnderlineHot,
    lvoMultiWorkares,
      // virtual list view style:
    lvoOwnerData,
      // custom draw style:
    lvoOwnerDrawFixed
     );
  TListViewOptions = Set of TListViewOption;

  TOnEditLVItem = function( Sender: PControl; Idx, Col: Integer; NewText: PKOL_Char ): Boolean
                  of object;
  {* Event type for OnEndEditLVItem. Return True in handler to accept new text value. }
  TOnDeleteLVItem = procedure( Sender: PControl; Idx: Integer ) of object;
  {* Event type for OnDeleteLVItem event. }
  TOnLVData = procedure( Sender: PControl; Idx, SubItem: Integer;
              var Txt: KOL_String; var ImgIdx: Integer; var State: DWORD;
              var Store: Boolean ) of object;
  {* Event type for OnLVData event. Used to provide virtual list view control
     (i.e. having lvoOwnerData style) with actual data on request. Use parameter
     Store as a flag if control should store obtained data by itself or not. }
  {$IFDEF ENABLE_DEPRECATED}
  {$DEFINE interface_1} {$I KOL_deprecated.inc} {$UNDEF interface_1}
  {$ENDIF DISABLE_DEPRECATED}
  TOnCompareLVItems = function( Sender: PControl; Idx1, Idx2: Integer ): Integer
                    of object;
  {* Event type to compare two items of the list view (while sorting it). }
  TOnLVColumnClick = procedure( Sender: PControl; Idx: Integer ) of object;
  {* Event type for OnColumnClick event. }
  TOnLVStateChange = procedure( Sender: PControl; IdxFrom, IdxTo: Integer; OldState, NewState: DWORD )
                   of object;
  {* Event type for OnLVStateChange event, called in responce to select/unselect
     a single item or items range in list view control). }

  TDrawActions = ( odaEntire, odaFocus, odaSelect );
  TDrawAction = Set of TDrawActions;
  TDrawStates = ( odsSelected, odsGrayed, odsDisabled, odsChecked, odsFocused,
                  odsDefault, odsHotlist, odsInactive,
                  odsNoAccel, odsNoFocusRect,
                  ods400reserved, ods800reserved,
                  odsComboboxEdit,
                  // specific for common controls:
                  odsMarked, odsIndeterminate );
  {* Possible draw states.
     |<br>odsSelected - The menu item's status is selected.
     |<br>odsGrayed - The item is to be grayed. This bit is used only in a menu.
     |<br>odsDisabled - The item is to be drawn as disabled.
     |<br>odsChecked - The menu item is to be checked. This bit is used only in
                     a menu.
     |<br>odsFocused - The item has the keyboard focus.
     |<br>odsDefault - The item is the default item.
     |<br>odsHotList - <b>Windows 98, Windows 2000:</b> The item is being
                     hot-tracked, that is, the item will be highlighted when
                     the mouse is on the item.
     |<br>odsInactive - <b>Windows 98, Windows 2000:</b> The item is inactive
                      and the window associated with the menu is inactive.
     |<br>odsNoAccel - <b>Windows 2000:</b> The control is drawn without the
                     keyboard accelerator cues.
     |<br>odsNoFocusRect - <b>Windows 2000:</b> The control is drawn without
                         focus indicator cues.
     |<br>odsComboboxEdit - The drawing takes place in the selection field
                          (edit control) of an owner-drawn combo box.
     |<br>odsMarked - for Common controls only. The item is marked. The meaning
                    of this is up to the implementation.
     |<br>odsIndeterminate - for Common Controls only. The item is in an
                           indeterminate state. }
  TDrawState = Set of TDrawStates;
  {* Set of possible draw states. }
  TOnDrawItem = function( Sender: PObj; DC: HDC; const Rect: TRect; ItemIdx: Integer;
                           DrawAction: TDrawAction; ItemState: TDrawState ): Boolean of object;
  {* Event type for OnDrawItem event (applied to list box, combo box, list view). }
  TOnMeasureItem = function( Sender: PObj; Idx: Integer ): Integer of object;
  {* Event type for OnMeasureItem event. The event handler must return height of list box
     item as a result. }
  TGetLVItemPart = ( lvipBounds, lvipIcon, lvipLabel, lvupIconAndLabel );
  {* }
  TWherePosLVItem = ( lvwpOnIcon, lvwpOnLabel, lvwpOnStateIcon, lvwpOnColumn,
                  lvwpOnItem );
  {* }

  TOnLVCustomDraw = function( Sender: PControl; DC: HDC; Stage: DWORD;
                  ItemIdx, SubItemIdx: Integer; const Rect: TRect;
                  ItemState: TDrawState; var TextColor, BackColor: TColor )
                  : DWORD of object;
  {* Event type for OnLVCustomDraw event. }

//[Paint TYPES]
  TOnPaint = procedure( Sender: PControl; DC: HDC ) of object;
  TPaintProc = procedure( DC: HDC ) of object;

  TGradientStyle = ( gsVertical, gsHorizontal, gsRectangle, gsElliptic, gsRombic,
                     gsTopToBottom, gsBottomToTop );
  {* Gradient fill styles. See also TGradientLayout. }
  TGradientLayout = ( glTopLeft, glTop, glTopRight,
                      glLeft, glCenter, glRight,
                      glBottomLeft, glBottom, glBottomRight );
  {* Position of starting line / point for gradient filling. Depending on
     TGradientStyle, means either position of first line of first rectangle
     (ellipse) to be expanded in a loop to fit entire gradient panel area. }

//[Edit TYPES]
  TEditOption = ( eoNoHScroll, eoNoVScroll, eoLowercase, eoMultiline,
                  eoNoHideSel, eoOemConvert, eoPassword, eoReadonly,
                  eoUpperCase, eoWantReturn, eoWantTab, eoNumber );
  {* Available edit options.
  |<br> Please note, that eoWantTab option just removes TAB key from a list
  of keys available to tabulate from the edit control. To provide insertion
  of tabulating key, do so in TControl.OnChar event handler. Sorry for
  inconvenience, but this is because such behaviour is not must in all cases.
  See also TControl.EditTabChar property.  }
  TEditOptions = Set of TEditOption;
  {* Set of available edit options. }

  TEditPositions = packed record
    SelStart: Integer;
    SelLength: Integer;
    TopLine: Integer;
    TopColumn: Integer;
    ScrollPos: TPoint;
    RestoreScroll: Boolean;
  end;

  TRichFmtArea = ( raSelection, raWord, raAll );
  {* Characters formatting area for RichEdit. }
  TRETextFormat = ( reRTF, reText, rePlainRTF, reRTFNoObjs, rePlainRTFNoObjs,
                    reTextized, reUnicode, reTextUnicode );
  {* Available formats for transfer RichEdit text using property
     TControl.RE_Text.
     |<pre>
     reRTF - normal rich text (no transformations)
     reText - plain text only (without OLE objects)
     reTextized - plain text with text representation of COM objects
     rePlainRTF - reRTF without language-specific keywords
     reRTFNoObjs - reRTF without OLE objects
     rePlainRTFNoObjs - rePlainRTF without OLE objects
     reUnicode - stream is 2-byte Unicode characters rather then 1-byte Ansi
     |</pre> }
  TRichUnderline = ( ruSingle, ruWord, ruDouble, ruDotted,
                 //all other - only for RichEditv3.0:
                 ruDash, ruDashDot, ruDashDotDot, ruWave, ruThick, ruHairLine );
  {* Rich text exteded underline styles (available only for RichEdit v2.0,
     and even for RichEdit v2.0 additional styles can not displayed - but
     ruDotted under Windows2000 is working). }
  TRichTextSizes = ( rtsNoUseCRLF, rtsNoPrecise, rtsClose, rtsBytes );
  {* Options to calculate size of rich text. Available only for RichEdit2.0
     or higher. }
  TRichTextSize = set of TRichTextSizes;
  {* Set of all available optioins to calculate rich text size using
     property TControl.RE_TextSize[ options ]. }
  TRichNumbering = ( rnNone, rnBullets, rnArabic, rnLLetter, rnULetter,
                rnLRoman, rnURoman );
  {* Advanced numbering styles for paragraph (RichEdit).
     |<pre>
     rnNone     - no numbering
     rnBullets  - bullets only
     rnArabic   - 1, 2, 3, 4, ...
     rnLLetter  - a, b, c, d, ...
     rnULetter  - A, B, C, D, ...
     rnLRoman   - i, ii, iii, iv, ...
     rnURoman   - I, II, III, IV, ...
     rnNoNumber - do not show any numbers (but numbering is taking place).
     |</pre> }
  TRichNumBrackets = ( rnbRight, rnbBoth, rnbPeriod, rnbPlain, rnbNoNumber );
  {* Brackets around number:
     |<pre>
     rnbRight   - 1) 2) 3)     - this is default !
     rnbBoth    - (1) (2) (3)
     rnbPeriod  - 1. 2. 3.
     rnbPlain   - 1 2 3
     |</pre> }
  TBorderEdge = (beLeft, beTop, beRight, beBottom);
  {* Borders of rectangle. }

  {$IFNDEF NOT_USE_RICHEDIT}
  {$IFDEF _D3orHigher}
  TCharFormat = TCharFormat2;
  {$ENDIF _D3orHigher}
  TParaFormat = TParaFormat2;
  {$ENDIF NOT_USE_RICHEDIT}

  TOnTestMouseOver = function( Sender: PControl ): Boolean of object;
  {* Event type for TControl.OnTestMouseOver event. The handler should
     return True, if it dectects, that mouse is over control. }

  TEdgeStyle = ( esRaised, esLowered, esNone, esTransparent, esSolid );
  {* Edge styles (for panel - see NewPanel).
     esTransparent and esSolid - special styles equivalent to esNone
     except GRushControls are used via USE_GRUSH symbol (ToGRush.pas) }

//[List TYPES]
  TListOption = ( loNoHideScroll, loNoExtendSel, loMultiColumn, loMultiSelect,
                  loNoIntegralHeight, loNoSel, loSort, loTabstops,
                  loNoStrings, loNoData, loOwnerDrawFixed, loOwnerDrawVariable,
                  loHScroll );
  {* Options for ListBox (see NewListbox).
     To use loHScroll, you also have to send LB_SETHORIZONTALEXTENT with a
     maximum width of a line in pixels (wParam)! }
  TListOptions = Set of TListOption;
  {* Set of available options for Listbox. }

  TComboOption = ( coReadOnly, coNoHScroll, coAlwaysVScroll, coLowerCase,
                   coNoIntegralHeight, coOemConvert, coSort, coUpperCase,
                   coOwnerDrawFixed, coOwnerDrawVariable, coSimple );
  {* Options for combobox. }
  TComboOptions = Set of TComboOption;
  {* Set of options available for combobox. }

//[Progress TYPES]
  TProgressbarOption = ( pboVertical, pboSmooth );
  {* Options for progress bar. }
  TProgressbarOptions = set of TProgressbarOption;
  {* Set of options available for progress bar. }

//[TreeView TYPES]
  TTreeViewOption = ( tvoNoLines, tvoLinesRoot, tvoNoButtons, tvoEditLabels, tvoHideSel,
                  tvoDragDrop, tvoNoTooltips, tvoCheckBoxes, tvoTrackSelect,
                  tvoSingleExpand, tvoInfoTip, tvoFullRowSelect, tvoNoScroll,
                  tvoNonEvenHeight );
  {* Tree view options. }
  TTreeViewOptions = set of TTreeViewOption;
  {* Set of tree view options. }

//[TabControl TYPES]
  TTabControlOption = ( tcoButtons, tcoFixedWidth, tcoFocusTabs,
                        tcoIconLeft, tcoLabelLeft,
                        tcoMultiline, tcoMultiselect, tcoFitRows, tcoScrollOpposite,
                        tcoBottom, tcoVertical, tcoFlat, tcoHotTrack, tcoBorder,
                        tcoOwnerDrawFixed );
  {* Options, available for TabControl. }
  TTabControlOptions = set of TTabControlOption;
  {* Set of options, available for TAbControl during its creation (by
     NewTabControl function). }

//[Toolbar TYPES]
  TToolbarOption = ( tboTextRight, tboTextBottom, tboFlat, tboTransparent,
                 tboWrapable, tboNoDivider, tbo3DBorder, tboCustomErase );
  {* Toolbar options. When tboFlat is set and toolbar is placed onto panel,
     set its property Transparent to TRUE to provide its correct view. }
  TToolbarOptions = Set of TToolbarOption;
  {* Set of toolbar options. }
  TOnToolbarButtonClick = procedure( Sender: PControl; BtnID: Integer ) of object;
  {* Special event type to handle separate toolbar buttons click events. }
  TOnTBCustomDraw = function( Sender: PControl; var NMCD: TNMTBCustomDraw ): Integer of object;
  {* Event type for OnTBCustomDraw event. }

  TDateTimePickerOption = ( dtpoTime, dtpoDateLong, dtpoUpDown, dtpoRightAlign,
    dtpoShowNone, dtpoParseInput );
  {* }
  TDateTimePickerOptions = set of TDateTimePickerOption;
  {* }
  TDTParseInputEvent = procedure(Sender: PControl; const UserString: Ansistring;
    var DateAndTime: TDateTime; var AllowChange: Boolean) of object;
  {* }
  TDateTimeRange = packed record
    FromDate, ToDate: TDateTime;
  end;
  {* }
  TDateTimePickerColor = ( dtpcBackground, dtpcMonthBk, dtpcText, dtpcTitleBk,
    dtpcTitleText, dtpcTrailingText );

//[TOnDropFiles TYPE]
  TOnDropFiles = procedure( Sender: PControl; const FileList: KOL_String; const Pt: TPoint ) of object;
  {* An event type for OnDropFiles event. When the event is occur, FileList
     parameter contains a list of files dropped. File names in a list are
     separated with #13 character. This allows You to assign it to TStrList
     object using its property Text (for example):
     ! procedure TSomeObject.DropFiles( Sender: PControl; const FileList: AnsiString;
     !           const Pt: TPoint ); )
     ! var FList: PStrList;
     !     I: Integer;
     ! begin
     !   FList := NewStrList;
     !   FList.Text := FileList;
     !   for I := 0 to FList.Count-1 do
     !   begin
     !     // do something with FList.Items[ I ]
     !   end;
     !   FList.Free;
     ! end; }

//[Scroll TYPES]
  TScrollerBar = ( sbHorizontal, sbVertical );
  TScrollerBars = set of TScrollerBar;

  TOnScroll = procedure( Sender: PControl; Bar: TScrollerBar; ScrollCmd: DWORD;
            ThumbPos: DWORD ) of object;

//[TOnHelp EVENT TYPE]
  TOnHelp = procedure( var Sender: PControl; var Context: Integer; var Popup: Boolean )
            of object;

//[ScrollBar TYPES]
  TOnSBBeforeScroll =
    procedure(
      Sender: PControl; OldPos, NewPos: Integer; Cmd: Word;
      var AllowChange: Boolean) of object;
  TOnSBScroll = procedure(Sender: PControl; Cmd: Word) of object;

{$IFDEF WIN_GDI}
  TOnGraphCtlMouse = procedure( var Msg: TMsg ) of object;
{$ENDIF WIN_GDI}
  TTriStateCheck = (tsUnchecked{=0}, tsChecked{=1}, tsIndeterminate{=2});

{$IFDEF _X_}
  //---- in GTK+, each type of widget requieres its own getcaption/setcaption call
  TGetCaption = function( Ctl: PControl ): KOLString;
  TSetCaption = procedure( Ctl: PControl; const Value: KOLString );

  {$IFDEF GTK}
  //---- in GTK+, to allow setting absolute position for children,
  // we should use one of special clients like gtk_fixed, gtk_layout
  TGetClientArea = function( Ctl: PControl ): PGtkWidget;
  TChildSetPos = procedure( Ctl, Chld: PControl; x, y: Integer );
  {$ENDIF GTK}
{$ENDIF _X_}

  {$IFDEF USE_MHTOOLTIP}
  {$DEFINE pre_interface}
  {$I KOLMHToolTip}
  {$UNDEF pre_interface}
  {$ENDIF}

{ ----------------------------------------------------------------------
             TControl - object to implement any visual control
----------------------------------------------------------------------- }
//[TControl DEFINITION]
  TControl = object( TObj )
  {*! TControl is the basic visual object of KOL. And now, all visual
     objects have the same type PControl, differing only in "constructor",
     which during creating of object adjusts it so it can play role of
     desired control. Idea of incapsulating of all visual objects having
     the most common set of properties, is belonging to Vladimir Kladov,
     (C) 2000.
     |<br>&nbsp;&nbsp;&nbsp;<b> Since all visual objects are represented
     in KOL by this single object type, not all methods, properties and
     events defined in TControl, are applicable to different visual objects.
     See also notes about certain control kinds, located together with its
     |<a href="kol_pas.htm#visual_objects_constructors">
     |constructing functions definitions</a></b>. }
  {$IFDEF GDI}
  protected
    fSBMinMax: TPoint;
    fSBPageSize: Integer;
    fSBPosition: Integer;
    procedure SetSBMax(Value: Longint);
    procedure SetSBMin(Value: Longint);
    procedure SetSBPageSize(Value: Integer);
    procedure SetSBPosition(Value: Integer);
    procedure SetSBMinMax(const Value: TPoint);

    function GetDate: TDateTime;
    function GetTime: TDateTime;
    procedure SetDate(const Value: TDateTime);
    procedure SetTime(const Value: TDateTime);
  {$ENDIF GDI}
  protected
  {$IFDEF GDI}
    function GetHelpPath: KOLString;
    procedure SetHelpPath(const Value: KOLString);
    procedure SetOnQueryEndSession(const Value: TOnEventAccept);
    procedure SetOnMinMaxRestore(const Index: Integer; const Value: TOnEvent);
    procedure SetOnMinimize( const Value: TOnEvent );
    procedure SetOnMaximize( const Value: TOnEvent );
    procedure SetOnRestore( const Value: TOnEvent );
    procedure SetConstraint(const Index, Value: Integer);
    {$IFDEF F_P}
    function GetOnMinMaxRestore(const Index: Integer): TOnEvent;
    function GetConstraint(const Index: Integer): Integer;
    {$ENDIF F_P}
    procedure SetOnScroll(const Value: TOnScroll);
    function GetLVColalign(Idx: Integer): TTextAlign;
    procedure SetLVColalign(Idx: Integer; const Value: TTextAlign);

    {$ENDIF GDI}
    procedure SetParent( Value: PControl );
    function GetLeft: Integer;
    procedure SetLeft( Value: Integer );
    function GetTop: Integer;
    procedure SetTop( Value: Integer );
    function GetWidth: Integer;
    procedure SetWidth( Value: Integer );
    function GetHeight: Integer;
    procedure SetHeight( Value: Integer );
    function GetPosition: TPoint;
    procedure Set_Position( Value: TPoint );
    function GetMembers(Idx: Integer): PControl;
    function GetFont: PGraphicTool;
    procedure FontChanged( Sender: PGraphicTool );
    {$IFDEF GDI}
    function GetBrush: PGraphicTool;
    procedure BrushChanged( Sender: PGraphicTool );
    function GetClientHeight: Integer;
    function GetClientWidth: Integer;
    procedure SetClientHeight(const Value: Integer);
    procedure SetClientWidth(const Value: Integer);
    function GetHasBorder: Boolean;
    procedure SetHasBorder(const Value: Boolean);

    function GetHasCaption: Boolean;
    procedure SetHasCaption(const Value: Boolean);

    function GetCanResize: Boolean;
    procedure SetCanResize( const Value: Boolean );

    function GetStayOnTop: Boolean;
    procedure SetStayOnTop(const Value: Boolean);
    function GetChecked: Boolean;
    procedure Set_Checked(const Value: Boolean);

    function GetCheck3: TTriStateCheck;
    procedure SetCheck3(value: TTriStateCheck);

    function GetSelStart: Integer;
    procedure SetSelStart(const Value: Integer);
    function GetSelLength: Integer;
    procedure SetSelLength(const Value: Integer);

    function GetItems(Idx: Integer): KOLString;
    procedure SetItems(Idx: Integer; const Value: KOLString);

    function GetItemsCount: Integer;
    function GetItemSelected(ItemIdx: Integer): Boolean;
    procedure SetItemSelected(ItemIdx: Integer; const Value: Boolean);

    procedure SetCtl3D(const Value: Boolean);
    function GetCurIndex: Integer;
    procedure SetCurIndex(const Value: Integer);

    {$ENDIF GDI}
    function GetTextAlign: TTextAlign;
    procedure SetTextAlign(const Value: TTextAlign);
    function GetVerticalAlign: TVerticalAlign;
    procedure SetVerticalAlign(const Value: TVerticalAlign);
    function GetCanvas: PCanvas;
    {$IFDEF _X_}
    {$IFDEF GTK}
  protected
    fInBkPaint: Boolean;
    fSetTextAlign: procedure( Self_: PControl );
    function ProvideCanvasHandle( Sender: PCanvas ): HDC;
    {$ENDIF GTK}
    {$ENDIF _X_}
    {$IFDEF GDI}
    function Dc2Canvas( Sender: PCanvas ): HDC;
    procedure SetShadowDeep(const Value: Integer);
    procedure SetDoubleBuffered(const Value: Boolean);

    procedure SetStatusText(Index: Integer; Value: PKOLChar);
    function GetStatusText( Index: Integer ): PKOLChar;
    function GetStatusPanelX(Idx: Integer): Integer;
    procedure SetStatusPanelX(Idx: Integer; const Value: Integer);

    procedure SetTransparent(const Value: Boolean);
    function GetImgListIdx(const Index: Integer): PImageList;

    procedure SetImgListIdx(const Index: Integer; const Value: PImageList);
    function GetLVColText(Idx: Integer): KOLString;
    procedure SetLVColText(Idx: Integer; const Value: KOLString);
    {$IFDEF ENABLE_DEPRECATED}
    {$DEFINE interface_2} {$I KOL_deprecated.inc} {$UNDEF interface_2}
    {$ENDIF DISABLE_DEPRECATED}
  protected
    function LVGetItemText(Idx, Col: Integer): KOLString;
    procedure LVSetItemText(Idx, Col: Integer; const Value: KOLString);
    procedure SetLVOptions(const Value: TListViewOptions);
    procedure SetLVStyle(const Value: TListViewStyle);
    function GetLVColEx(Idx: Integer; const Index: Integer): Integer;
    procedure SetLVColEx(Idx: Integer; const Index: Integer;
      const Value: Integer);
    {$ENDIF GDI}
    function GetChildCount: Integer;
    {$IFDEF GDI}
    function LVGetItemPos(Idx: Integer): TPoint;
    procedure LVSetItemPos(Idx: Integer; const Value: TPoint);
    procedure LVSetColorByIdx(const Index: Integer; const Value: TColor);
    {$IFDEF F_P}
    function LVGetColorByIdx(const Index: Integer): TColor;
    {$ENDIF F_P}
    function GetIntVal(const Index: Integer): Integer;
    procedure SetIntVal(const Index, Value: Integer);
    function GetItemVal(Item: Integer; const Index: Integer): Integer;
    procedure SetItemVal(Item: Integer; const Index, Value: Integer);
    function TBGetButtonVisible(BtnID: Integer): Boolean;
    procedure TBSetButtonVisible(BtnID: Integer; const Value: Boolean);

    function TBGetBtnStt(BtnID: Integer; const Index: Integer): Boolean;
    procedure TBSetBtnStt(BtnID: Integer; const Index: Integer; const Value: Boolean);
    function TBGetButtonText(BtnID: Integer): KOLString;
    function TBGetButtonRect(BtnID: Integer): TRect;

    function TBGetRows: Integer;
    procedure TBSetRows(const Value: Integer);
    procedure SetProgressColor(const Value: TColor);
    function TBGetBtnImgIdx(BtnID: Integer): Integer;
    procedure TBSetBtnImgIdx(BtnID: Integer; const Value: Integer);

    procedure TBSetButtonText(BtnID: Integer; const Value: KOLString);

    function TBGetBtnWidth(BtnID: Integer): Integer;
    procedure TBSetBtnWidth(BtnID: Integer; const Value: Integer);
    procedure TBSetBtMinMaxWidth(const Idx: Integer; const Value: Integer);
    {$IFDEF F_P}
    function TBGetBtMinMaxWidth(const Idx: Integer): Integer;
    {$ENDIF F_P}
    procedure TBFreeTBevents;
    function TBGetButtonLParam(const Idx: Integer): DWORD;
    procedure TBSetButtonLParam(const Idx: Integer; const Value: DWORD);
    procedure Set_Align(const Value: TControlAlign);
    function GetSelection: KOLString;
    procedure SetSelection(const Value: KOLString);
    procedure SetTabOrder(const Value: Integer);
    function GetFocused: Boolean;
    procedure SetFocused(const Value: Boolean);
    {$IFNDEF NOT_USE_RICHEDIT}
    function REGetFont: PGraphicTool;
    procedure RESetFont(Value: PGraphicTool);
    procedure RESetFontEx(const Index: Integer);
    function REGetFontEffects(const Index: Integer): Boolean;
    function REGetFontMask(const Index: Integer): Boolean;
    procedure RESetFontEffect(const Index: Integer; const Value: Boolean);
    function REGetFontAttr(const Index: Integer): Integer;
    procedure RESetFontAttr(const Index, Value: Integer);
    procedure RESetFontAttr1(const Index, Value: Integer);
    function REGetFontSizeValid: Boolean;
    function REGetCharformat: TCharFormat;
    procedure RESetCharFormat(const Value: TCharFormat);
    function REReadText(Format: TRETextFormat;
      SelectionOnly: Boolean): KOLString;
    procedure REWriteText(Format: TRETextFormat; SelectionOnly: Boolean;
      const Value: KOLString);
    function REGetFontName: KOLString;
    procedure RESetFontName(const Value: KOLString);
    function REGetParaFmt: TParaFormat;
    procedure RESetParaFmt(const Value: TParaFormat);
    function REGetNumbering: Boolean;
    function REGetParaAttr( const Index: Integer ): Integer;
    function REGetParaAttrValid( const Index: Integer ): Boolean;
    function REGetTabCount: Integer;
    function REGetTabs(Idx: Integer): Integer;
    function REGetTextAlign: TRichTextAlign;
    procedure RESetNumbering(const Value: Boolean);
    procedure RESetParaAttr(const Index, Value: Integer);
    procedure RESetTabCount(const Value: Integer);
    procedure RESetTabs(Idx: Integer; const Value: Integer);
    procedure RESetTextAlign(const Value: TRichTextAlign);
    function REGetStartIndentValid: Boolean;
    function REGetAutoURLDetect: Boolean;
    procedure RESetAutoURLDetect(const Value: Boolean);
    procedure RESetZoom( const Value: TSmallPoint );
    function REGetZoom: TSmallPoint;

    function GetMaxTextSize: DWORD;
    procedure SetMaxTextSize(const Value: DWORD);
    {$ENDIF NOT_USE_RICHEDIT}

    procedure SetOnResize(const Value: TOnEvent);

    procedure DoSelChange;

    {$IFNDEF NOT_USE_RICHEDIT}
    function REGetUnderlineEx: TRichUnderline;
    procedure RESetUnderlineEx(const Value: TRichUnderline);

    function GetTextSize: Integer;
    function REGetTextSize(Units: TRichTextSize): Integer;

    function REGetNumStyle: TRichNumbering;
    procedure RESetNumStyle(const Value: TRichNumbering);
    function REGetNumBrackets: TRichNumBrackets;
    procedure RESetNumBrackets(const Value: TRichNumBrackets);
    function REGetNumTab: Integer;
    procedure RESetNumTab(const Value: Integer);
    function REGetNumStart: Integer;
    procedure RESetNumStart(const Value: Integer);
    function REGetSpacing(const Index: Integer): Integer;
    procedure RESetSpacing(const Index, Value: Integer);
    function REGetSpacingRule: Integer;
    procedure RESetSpacingRule(const Value: Integer);
    function REGetLevel: Integer;
    function REGetBorder(Side: TBorderEdge; const Index: Integer): Integer;
    procedure RESetBorder(Side: TBorderEdge; const Index: Integer;
      const Value: Integer);
    function REGetParaEffect(const Index: Integer): Boolean;
    procedure RESetParaEffect(const Index: Integer; const Value: Boolean);
    function REGetOverwite: Boolean;
    procedure RESetOverwrite(const Value: Boolean);
    procedure RESetOvrDisable(const Value: Boolean);
    function REGetTransparent: Boolean;
    procedure RESetTransparent(const Value: Boolean);
    procedure RESetOnURL(const Index: Integer; const Value: TOnEvent);
    procedure SetOnRE_URLClick( const Value: TOnEvent );
    procedure SetOnRE_OverURL( const Value: TOnEvent );
    {$IFDEF F_P}
    function REGetOnURL(const Index: Integer): TOnEvent;
    {$ENDIF F_P}
    function REGetLangOptions(const Index: Integer): Boolean;
    procedure RESetLangOptions(const Index: Integer; const Value: Boolean);
    {$ENDIF NOT_USE_RICHEDIT}
    function LVGetItemImgIdx(Idx: Integer): Integer;
    procedure LVSetItemImgIdx(Idx: Integer; const Value: Integer);
    procedure SetFlat(const Value: Boolean);
    procedure SetOnMouseEnter(const Value: TOnEvent);
    procedure SetOnMouseLeave(const Value: TOnEvent);
    procedure EdSetTransparent(const Value: Boolean);
    procedure SetOnTestMouseOver(const Value: TOnTestMouseOver);
    function GetPages(Idx: Integer): PControl;
    function TCGetItemText(Idx: Integer): KOLString;
    procedure TCSetItemText(Idx: Integer; const Value: KOLString);
    function TCGetItemImgIDx(Idx: Integer): Integer;
    procedure TCSetItemImgIdx(Idx: Integer; const Value: Integer);
    function TCGetItemRect(Idx: Integer): TRect;
    function TVGetItemIdx(const Index: Integer): THandle;
    procedure TVSetItemIdx(const Index: Integer; const Value: THandle);
    function TVGetItemNext(Item: THandle; const Index: Integer): THandle;
    function TVGetItemRect(Item: THandle; TextOnly: Boolean): TRect;
    function TVGetItemVisible(Item: THandle): Boolean;
    procedure TVSetITemVisible(Item: THandle; const Value: Boolean);
    function TVGetItemStateFlg(Item: THandle; const Index: Integer): Boolean;
    procedure TVSetItemStateFlg(Item: THandle; const Index: Integer;
      const Value: Boolean);
    function TVGetItemImage(Item: THandle; const Index: Integer): Integer;
    procedure TVSetItemImage(Item: THandle; const Index: Integer;
      const Value: Integer);
    function TVGetItemText(Item: THandle): KOLString;
    procedure TVSetItemText(Item: THandle; const Value: KOLString);
    function TV_GetItemHasChildren(Item: THandle): Boolean;
    procedure TV_SetItemHasChildren(Item: THandle; const Value: Boolean);
    function TV_GetItemChildCount(Item: THandle): Integer;
    function TVGetItemData(Item: THandle): Pointer;
    procedure TVSetItemData(Item: THandle; const Value: Pointer);

    function GetToBeVisible: Boolean;

    procedure SetAlphaBlend(const Value: Byte);
    procedure SetMaxProgress(const Index, Value: Integer);
    procedure SetDroppedWidth(const Value: Integer);
    function LVGetItemState(Idx: Integer): TListViewItemState;
    procedure LVSetItemState(Idx: Integer; const Value: TListViewItemState);
    function LVGetSttImgIdx(Idx: Integer): Integer;
    procedure LVSetSttImgIdx(Idx: Integer; const Value: Integer);
    function LVGetOvlImgIdx(Idx: Integer): Integer;
    procedure LVSetOvlImgIdx(Idx: Integer; const Value: Integer);
    function LVGetItemData(Idx: Integer): DWORD;
    procedure LVSetItemData(Idx: Integer; const Value: DWORD);
    function LVGetItemIndent(Idx: Integer): Integer;
    procedure LVSetItemIndent(Idx: Integer; const Value: Integer);
    procedure SetOnDeleteAllLVItems(const Value: TOnEvent);
    procedure SetOnDeleteLVItem(const Value: TOnDeleteLVItem);
    procedure SetOnEndEditLVItem(const Value: TOnEditLVItem);
    procedure SetOnLVData(const Value: TOnLVData);
    procedure SetOnColumnClick(const Value: TOnLVColumnClick);
    procedure SetOnDrawItem(const Value: TOnDrawItem);
    procedure SetOnMeasureItem(const Value: TOnMeasureItem);

    procedure SetItemsCount(const Value: Integer);

    function GetItemData(Idx: Integer): DWORD;
    procedure SetItemData(Idx: Integer; const Value: DWORD);
    function GetLVCurItem: Integer;
    procedure SetLVCurItem(const Value: Integer);
    function GetLVFocusItem: Integer;
    procedure SetOnDropFiles(const Value: TOnDropFiles);
    procedure SetOnHide(const Value: TOnEvent);
    procedure SetOnShow(const Value: TOnEvent);
    procedure SetClientMargin(const Index, Value: Integer);
    {$IFDEF F_P}
    function GetClientMargin(const Index: Integer): Integer;
    {$ENDIF F_P}
    {$ENDIF GDI}
  protected
    {$IFDEF _X_}
    {$IFDEF GTK}
    fExposeEvent: Integer;
    {$ENDIF GTK}
    {$ENDIF _X_}
    procedure SetOnPaint(const Value: TOnPaint);
    {$IFDEF GDI}
    procedure SetOnEraseBkgnd(const Value: TOnPaint);
    procedure SetTVRightClickSelect(const Value: Boolean);
    procedure SetOnLVStateChange(const Value: TOnLVStateChange);
    procedure SetOnMove(const Value: TOnEvent);
    procedure SetOnMoving(const Value: TOnEventMoving);
    procedure SetColor1(const Value: TColor);
    procedure SetColor2(const Value: TColor);
    procedure SetGradientLayout(const Value: TGradientLayout);
    procedure SetGradientStyle(const Value: TGradientStyle);
    procedure SetDroppedDown(const Value: Boolean);
    function get_ClassName: KOLString;
    procedure set_ClassName(const Value: KOLString);
    procedure SetClsStyle( Value: DWord );

{$IFDEF GRAPHCTL_XPSTYLES}
    procedure SetEdgeStyle( Value: TEdgeStyle );
{$ENDIF}

    procedure SetStyle( Value: DWord );
    procedure SetExStyle( Value: DWord );

    procedure SetCursor( Value: HCursor );

    procedure SetIcon( Value: HIcon );
    procedure SetMenu( Value: HMenu );
    {$ENDIF GDI}
  protected
    {$IFDEF _X_}
    fGetCaption: TGetCaption;
    fSetCaption: TSetCaption;
    {$ENDIF _X_}
	function GetCaption: KOLString;
	procedure SetCaption( const Value: KOLString );
    {$IFDEF GDI}

    procedure SetWindowState( Value: TWindowState );
    function GetWindowState: TWindowState;

    {$ENDIF GDI}
    procedure ApplyFont2Wnd;
    {$IFDEF GDI}
    procedure DoClick;

    function TBAddInsButtons( Idx: Integer; const Buttons: array of PKOLChar;
              const BtnImgIdxArray: array of Integer ): Integer; stdcall;
    procedure SetBitBtnDrawMnemonic(const Value: Boolean);
    function GetBitBtnImgIdx: Integer;
    procedure SetBitBtnImgIdx(const Value: Integer);
    function GetBitBtnImageList: THandle;
    procedure SetBitBtnImageList(const Value: THandle);

    function GetModal: Boolean;
    {$IFDEF USE_SETMODALRESULT}
    procedure SetModalResult( const Value: Integer );
    {$ENDIF}

  {$ENDIF GDI}
  protected
    {$IFDEF GDI}
      fHandle: HWnd;
    {$ELSE}
       {$IFDEF GTK} fHandle: PGtkWidget;
                    fCaptionHandle: PGtkWidget;
                    fEventboxHandle: PGtkWidget;
                    fGetClientArea: TGetClientArea;
                    fClient: PGtkWidget;
                    fChildPut: TChildSetPos;
                    fChildSetPos: TChildSetPos;
       {$ENDIF}
       {$IFDEF Q_T} fHandle: sometypehere  ;      {$ENDIF}
    {$ENDIF}
  {$IFDEF GDI}
    fFocusHandle: HWnd;
    fClsStyle: DWord;
    fStyle: DWord;
    fExStyle: DWord;
    fCursor: HCursor;
    fCursorShared: Boolean;
    fIcon: HIcon;
    fIconShared: Boolean;
  {$ENDIF GDI}
    fIgnoreWndCaption: Boolean;
    {$IFDEF GDI}

{$IFDEF GRAPHCTL_XPSTYLES}
    fEdgeStyle : TEdgeStyle;
{$ENDIF}

    fWindowState: TWindowState;
    //fShowAction: Integer;
    fDefWndProc: Pointer;
    fNCDestroyed: Boolean;

    {$ENDIF GDI}
    FParent: PControl;
    FParentWnd: HWnd;  //<<-- ++ for InitOrthaned !!
    fEnabled: Boolean; // Caution!!! fVisible must follow fEnabled! ___
    fVisible: Boolean; //____________________________________________//
    fTabstop: Boolean;
    fTabOrder: Integer;
    fTextAlign: TTextAlign;
    fVerticalAlign: TVerticalAlign;
    fWordWrap: Boolean;
    fPreventResize: Boolean;
    {$IFDEF GDI}
    fAlphaBlend: Byte;
    {$ENDIF GDI}
    FDroppedWidth: Integer;

    // Caution!!! order of following 5 fields is important!!!
    fDynHandlers: PList;
    fChildren: PList;
    {* List of children. }
    fTBttCmd: PList;
    fTBttTxt: {$IFDEF UNICODE_CTRLS} PWStrList {$ELSE} PStrList {$ENDIF};
    {$IFDEF GDI}
    fTmpFont: PGraphicTool;
    {$ENDIF GDI}
    //________________________________________________________//
    {$IFDEF GDI}

    fMDIClient: PControl;
    {* MDI client window control }
    fMDIChildren: PList;
    {* List of MDI children. It is filled for MDI client window. }
    fWndFunc: Pointer;
    {* Initially pointer to WndFunc. For MDI child window, points to DefMDIChildProc. }
    fExMsgProc: function( Applet: PControl; var Msg: TMsg ): Boolean;
    {* Additional message handler called directly from Applet.ProcessMessage.
       Used to call TranslateMDISysAccel API function for MDI application. }
    fMDIDestroying: Boolean;
    {* }

    fTmpBrush: HBrush;
    {* Brush handle to return in response to some color set messages.
       Intended for internal use instead of Brush.Color if possible
       to avoid using it. }
    fTmpBrushColorRGB: TColor;
    { }
    fMembersCount: Integer;
    {* Memebers count is first used in XCustomControl to separate
       some internal child controls from common XControl.Children
       and make it invisible among Children[]. }
    fDrawCtrl1st: PControl;
    {* Child control to draw it first, i.e. foreground of others. }
    FCreating: Boolean;
    {* True, when creating of object is in progress. }
    fDestroying: Boolean;
    {* True, when destroying of the window is started. }
    fBeginDestroying: Boolean;
    {* true, when destroying of the window is initiated by the system, i.e.
       message WM_DESTROY fired }
    fNestedMsgHandling: Integer;
    {* level of nested message handling for a control. Only when it is 0 at
       the end of message handling and fBeginDestroying set, the control is
       destroyed. }
    fMenu: HMenu;
    {* Usually used to store handle of attached main menu, but sometimes
       is used to store control ID (for standard GUI controls only). }
    {$ENDIF GDI}
    fMenuObj: PObj;
    {* PMenu pointer to TMenu object. Freed automatically with entire
       chain of menu objects attached to a control (or form). }
    {$IFDEF _X_}
    {$IFDEF GTK}
    //fMenuBar: PGtkWidget;
    {$ENDIF GTK}
    {$ENDIF _X_}
    {$IFDEF GDI}
{$IFNDEF NEW_MENU_ACCELL}
    fAccelTable: HAccel;
    procedure DoDestroyAccelTable;
{$ENDIF}
  {$ENDIF GDI}
  protected
  {$IFDEF GDI}
    {* Handle of accelerator table created by menu(s). }
    fImageList: PImageList;
    {* Pointer to first private image list. Control can own several image,
       lists, linked to a chain of image list objects. All these image lists
       are released automatically, when control is destroyed. }
    fCtlImageListSml: PImageList;
    {* ImageList object (with small icons 16x16) to use with a control (e.g.,
       with ListView control).
       If not set, but control has a list of image list objects, last added
       image list with small icons is used automatically. }
    fCtlImageListNormal: PImageList;
    {* ImageList object (with big icons 32x32) to use with a control.
       If not set, last added image list with big icons is used. }
    fCtlImgListState: PImageList;
    {* ImageList object to use as a state image list (for ListView control). }
    {$ENDIF GDI}
    fIsApplet: Boolean;
    {* True, if the object represent application taskbar button. }
    fIsForm: Boolean;
    {* True, if the object is form. }
    fIsButton: Boolean;
    {$IFDEF GDI}
    fSizeGrip: Boolean;
    {$ENDIF GDI}
    fIsMDIChild: Boolean;
    {* TRUE, if the object is MDI child form. }
    fIsControl: Boolean;
    {* True, if it is a control on form. }
    fIsStaticControl: Byte;
    {* True, if it is static control with a caption. (To prevent flickering
       it in DoubleBuffered mode. }
    {$IFDEF GDI}
    fIsCommonControl: Boolean;
    {* True, if it is common control. }
    {$ENDIF GDI}
    fChangedPosSz: Byte;
    {* Flags of changing left (1), top (2), width (4) or height (8) }
    {$IFDEF GDI}
    fCannotDoubleBuf: Boolean;
    {* True, if cannot set DoubleBuffered to True (RichEdit). }
    fUpdRgn: HRgn;
    fCollectUpdRgn: HRGN;
    fEraseUpdRgn: Boolean;
    fPaintDC: HDC;
    {$ENDIF GDI}
    fLookTabKeys: TTabKeys;
    {$IFDEF GDI}
    fNotUpdate: Boolean;
    fColumn: Integer;
    FSupressTab: Boolean;
    fUpdateCount: Integer;
    fPaintLater: Boolean;
    fOnLeave: TOnEvent;
    fEditing: Boolean;
    fAutoPopupMenu: PObj;
    fHelpContext: Integer;
    {$IFDEF USE_GRAPHCTLS}
    fDoInvalidate: procedure of object;
    {$ENDIF}

    {$IFDEF GTK}
    fDeltaX, fDeltaY: Integer;
    {$ENDIF GTK}
    // Order of following fields is important:
    //_______________________________________________________________________________________________
    fPass2DefProc: function( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;
    fOnDynHandlers: TWindowFunc;                                                                   //
    fWndProcKeybd: function( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;         //
    fControlClick: procedure( Sender : PObj );                                                     //
    {$ENDIF GDI}
    fAutoSize: procedure( Self_: PObj );
    fControlClassName: PKOLChar;                                                                      //
    {$IFDEF GDI}
    fWindowed: Boolean;                                                                            //
    {* True, if control is windowed (or is a form). It is set to FALSE only for
       graphic controls. }
    //                                                                                             //
    fCtlClsNameChg: Boolean;                                                                       //
    {* True, if control class name changed and memory is allocated to store it. }                  //
    fWndProcResizeFlicks: function( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;  //
    {$ENDIF GDI}
    fGotoControl: function( Self_: PControl; Key: DWORD; CheckOnly: Boolean ): Boolean;            //
    {$IFDEF GDI}
    fCtl3Dchild: Boolean;                                                                          //
    fCtl3D: Boolean;                                                                               //
    {$ENDIF GDI}
    fTextColor: TColor;                                                                            //
    fColor: TColor;                                                                                //
    {* Color of text. Used instead of fFont.Color internally to                                    //
       avoid usage of Font object if user is not accessing and changing it. }                      //
    fFont: PGraphicTool;                                                                           //
    fBrush: PGraphicTool;                                                                          //
    fCanvas: PCanvas;
    {* Color of control background. }                                                              //
    fMargin: Integer;                                                                              //
    fBoundsRect: TRect;                                                                            //
    fClientTop, fClientBottom, fClientLeft, fClientRight: Integer;                                 //
    {* Store adjustment factor of ClientRect for some 'idiosincrasies' windows,                    //
       such as Groupbox or Tabcontrol. }                                                           //
    //_____________________________________________________________________________________________//
    // this is the end of fiels set, which order is important
    {$IFDEF GDI}

    fDoubleBuffered: Boolean;
    fTransparent: Boolean;
{$IFDEF GRAPHCTL_XPSTYLES}
    fClassicTransparent : Boolean;
{$ENDIF}                 
    fRETransparent: Boolean;
    fParentRequirePaint: Boolean;
    fSelfRequirePaint: Boolean;
    fDblExcludeRgn: HDC;

    fOnMessage: TOnMessage;
    fOldOnMessage: TOnMessage;

    {$ENDIF GDI}
    fOnClick: TOnEvent;
    fClickedEvent: Integer;
    {$IFDEF _X_}
    procedure SetOnClick( const Value: TOnEvent );
    {$ENDIF _X_}
  protected
    {$IFDEF GDI}
    fRightClick: Boolean;
    fCurrentControl: PControl;
    fCreateVisible, fCreateHidden: Boolean;
    fRadio1st, fRadioLast : THandle;
    fDropDownProc: procedure( Sender : PObj );
    fDropped: Boolean;
    fCurIdxAtDrop: Integer;
    fPrevWndProc: Pointer;
    fClickDisabled: Byte;
    fCurItem, fCurIndex: Integer;
    FOnScroll: TOnScroll;
    FScrollLineDist: array[ 0..1 ] of Integer;

    fDefaultBtn: Boolean;
    fCancelBtn: Boolean;
    fDefaultBtnCtl: PControl;
    fCancelBtnCtl: PControl;
    fAllBtnReturnClick: Boolean;
    fIgnoreDefault: Boolean;

    {$ENDIF GDI}
    fOnMouseDown: TOnMouse; // CAUTION!!! Order of mouse event handlers is important. ____
    fOnMouseUp: TOnMouse;                                                               //
    fOnMouseMove: TOnMouse;                                                             //
    fOnMouseDblClk: TOnMouse;                                                           //
    fOnMouseWheel: TOnMouse;     //_____________________________________________________//
    f3ButtonPress: Boolean;
    {$IFDEF GDI}

    fOldDefWndProc: Pointer;

    fOnChange: TOnEvent;
    fOnEnter: TOnEvent;

    FOnLVCustomDraw: TOnLVCustomDraw;
    FOnSBBeforeScroll: TOnSBBeforeScroll;
    FOnSBScroll: TOnSBScroll;
  protected
    procedure SetOnLVCustomDraw(const Value: TOnLVCustomDraw);
  public
    fCommandActions: TCommandActions;
  {$ENDIF GDI}
  protected
  {$IFDEF GDI}
    fOnChar: TOnChar;
    {$IFDEF SUPPORT_ONDEADCHAR}
    fOnDeadChar: TOnChar;
    {$ENDIF SUPPORT_ONDEADCHAR}
    fOnKeyUp: TOnKey;
    fOnKeyDown: TOnKey;

    {$ENDIF GDI}
    fOnPaint: TOnPaint;
    {$IFDEF GDI}
    fOnPaint2: TOnPaint;
    fPaintMsg: TMsg;
    fOnPrepaint: TOnPaint;
    fOnPostPaint: TOnPaint;
    fPaintProc: TPaintProc;

    {$ENDIF GDI}
    FMaxWidth: Integer;
    FMinWidth: Integer;
    FMaxHeight: Integer;
    FMinHeight: Integer;
    {$IFDEF GDI}
    fShadowDeep: Integer;
    fStatusCtl: PControl;
    fStatusWnd: HWnd;
    fColor1: TColor;
    fColor2: TColor;
    fLVColCount: Integer;
    fLVOptions: TListViewOptions;
    fLVStyle: TListViewStyle;
    fOnEndEditLVITem: TOnEditLVItem;
    fLVTextBkColor: TColor;
    fLVItemHeight: Integer;

    fOnDropDown: TOnEvent;
    fOnCloseUp: TOnEvent;

    fModalResult: Integer;

    fModal: Integer;
    fModalForm: PControl;

    {$ENDIF GDI}
    fAlign: TControlAlign;
    fAligning:TAlignings;
    fNotUseAlign: Boolean;
    {$IFDEF GDI}
    fDragCallback: TOnDrag;
    fDragging, fInDoDrag: Boolean;
    fDragStartPos: TPoint;
    fMouseStartPos: TPoint;
    fSplitStartPos: TPoint;
    fSplitStartPos2: TPoint;
    fSplitStartSize: Integer;
    fSplitMinSize1, fSplitMinSize2: Integer;
    fOnSplit: TOnSplit;
    fSecondControl: PControl;
    fOnSelChange: TOnEvent;

    {$IFNDEF NOT_USE_RICHEDIT}
    fRECharFormatRec: TCharFormat;
    fREError: Integer;
    fREStream: PStream;
    fREStrLoadLen: DWORD;
    fREParaFmtRec: TParaFormat2;
    {$ENDIF NOT_USE_RICHEDIT}
    FOnResize: TOnEvent;
    fOnProgress: TOnEvent;
    fCharFmtDeltaSz: Integer;
    fParaFmtDeltaSz: Integer;
    fREOvr: Boolean;
    fReOvrDisable: Boolean;
    fOnREInsModeChg: TOnEvent;
    fREScrolling: Boolean;
    fUpdCount: Integer;
    fOnREOverURL: TOnEvent;
    fOnREURLClick: TOnEvent;
    fRECharArea: TRichFmtArea;
    fBitBtnOptions : TBitBtnOptions;
    fGlyphLayout : TGlyphLayout;
    fGlyphBitmap : HBitmap;
    fGlyphCount : Integer;
    fGlyphWidth, fGlyphHeight: Integer;
    fOnBitBtnDraw: TOnBitBtnDraw;
    fFlat: Boolean;
    fSizeRedraw: Boolean; {YS}

    fOnMouseLeave: TOnEvent;
    fOnMouseEnter: TOnEvent;
    fOnTestMouseOver: TOnTestMouseOver;

    fMouseInControl: Boolean;
    fRepeatInterval: Integer;
    fChecked: Boolean;
    fPushed: Boolean;
    fPrevFocusWnd: HWnd;

    fOnTVBeginDrag: TOnTVBeginDrag;
    fOnTVBeginEdit: TOnTVBeginEdit;
    fOnTVEndEdit: TOnTVEndEdit;
    fOnTVExpanded: TOnTVExpanded;
    fOnTVExpanding: TOnTVExpanding;
    fOnTVDelete: TOnTVDelete;

    fOnDeleteLVItem: TOnDeleteLVItem;
    fOnDeleteAllLVItems: TOnEvent;
    fOnLVData: TOnLVData;
    fOnCompareLVItems: TOnCompareLVItems;
    fOnColumnClick: TOnLVColumnClick;
    fOnDrawItem: TOnDrawItem;
    fOnMeasureItem: TOnMeasureItem;
    fREUrl: KOLString;
    FMinimizeWnd: PControl;
    FFixWidth: Integer;
    FFixHeight: Integer;
    FOnDropFiles: TOnDropFiles;
    FOnHide: TOnEvent;
    FOnShow: TOnEvent;
    fOnEraseBkgnd: TOnPaint;
    {$ENDIF GDI}
    //----- order of following 3 events important: //
    fCaption: KOLString;
    fCustomData: Pointer;
    {$IFDEF GDI}
    fStatusTxt: PKOLChar;
    //---------------------------------------------//
    fCustomObj: PObj;
    fOnTVSelChanging: TOnTVSelChanging;

    fOnClose: TOnEventAccept;
    fOnQueryEndSession: TOnEventAccept;
    fCloseQueryReason: TCloseQueryReason;

    fShowAction: DWORD;
    //----- order of following 3 events important: //
    fOnMinimize: TOnEvent;                         //
    fOnMaximize: TOnEvent;                         //
    fOnRestore: TOnEvent;                          //
    //---------------------------------------------//

    //fCreateParamsExt: procedure( Self_: PControl; var Params: TCreateParams );
    fCreateWndExt: procedure( Sender: PControl );

    fTBevents: PList; // events for TBAssignEvents
    fTBBtnImgWidth: Integer; // custom toolbar bitmap width
    FTBBtMinWidth: Integer;
    FTBBtMaxWidth: Integer;
    fGradientStyle: TGradientStyle;
    fGradientLayout: TGradientLayout;
    fVisibleWoParent: Boolean;

    fTVRightClickSelect: Boolean;
    FOnMove: TOnEvent;
    FOnMoving: TOnEventMoving;
    FOnLVStateChange: TOnLVStateChange;
    fNotAvailable: Boolean;
    FPressedMnemonic: DWORD;
    FBitBtnDrawMnemonic: Boolean;
    FBitBtnGetCaption: function( Self_: PControl; const S: KOLString ): KOLString;
    FBitBtnExtDraw: procedure( Self_: PControl; DC: HDC; X, Y: Integer; const R: TRect;
                    const CapText, CapTxtOrig: KOLString; Color: TColor );
    FTextShiftX, FTextShiftY: Integer;
    fNotifyChild: procedure( Self_, Child: PControl );
    fScrollChildren: procedure( Self_: PControl );
    fOnHelp: TOnHelp;

    FOnDTPUserString: TDTParseInputEvent;

    fOnTBCustomDraw: TOnTBCustomDraw;

    {$IFDEF USE_MHTOOLTIP}
    {$DEFINE var}
    {$I KOLMHToolTip}
    {$UNDEF var}

    {$DEFINE function}
    {$I KOLMHToolTip}
    {$UNDEF function}
    {$ENDIF}

    {$ENDIF GDI}

    procedure Init; {-}virtual;{+}{++}(*override;*){--}
    {* }            //CLASSES         //BCB_CLASSES
    {$IFDEF GDI}
    procedure InitParented( AParent: PControl ); virtual;
    {* Initialization of visual object. }
    procedure InitOrthaned( AParentWnd: HWnd ); virtual;
    {* Initialization of visual object. }
    {$ENDIF GDI}
    {$IFDEF _X_}
    {$IFDEF GTK}
    procedure InitParented( AParent: PControl; widget: PGtkWidget;
      need_eventbox: Boolean ); virtual;
    {* Initialization of visual object. }
    {$ENDIF GTK}
    {$ENDIF _X_}
    {$IFDEF GDI}
    procedure DestroyChildren;
    {* Destroys children. Is called in destructor, and can be
       called in descending classes as earlier as needed to
       prevent problems of too late destroying of visuals.
       |<br>
       Note: since v 2.40, used only for case when a symbol NOT_USE_AUTOFREE4CONTROLS
       is defined, otherwise all children are destroyed using common mechanism of
       Add2AutoFree. }

    function GetParentWnd( NeedHandle: Boolean ): HWnd;
    {* Returns handle of parent window. }
    function GetParentWindow: HWnd;
    {* }
    procedure SetEnabled( Value: Boolean );
    {* Changes Enabled property value. Overriden here to change enabling
       status of a window. }
    function GetEnabled: Boolean;
    {* Returns True, if Enabled. Overriden here to obtain real window
       state. }
    procedure SetVisible( Value: Boolean );
    {* Sets Visible property value. Overriden here to change visibility
       of correspondent window. }
    procedure Set_Visible( Value: Boolean );
    {* }
    function GetVisible: Boolean;
    {* Returns True, if correspondent window is Visible. Overriden
       to get visibility of real window, not just value stored in object. }
    function Get_Visible: Boolean;
    {* Returns True, if correspondent window is Visible, for forms and applet,
       or if fVisible flag is set, for controls. }
    {$ENDIF GDI}
    procedure SetCtlColor( Value: TColor );
    {* Sets TControl's Color property value. }
    procedure SetBoundsRect( const Value: TRect );
    {* Sets BoudsRect property value. }
    function GetBoundsRect: TRect;
    {* Returns bounding rectangle. }
    {$IFDEF GDI}
    function GetIcon: HIcon;
    {* Returns Icon property. By default, if it is not set,
       returns Icon property of an Applet. }

	procedure CreateSubclass( var Params: TCreateParams; ControlClassName: PKOLChar );
    {* Can be used in descending classes to subclass window with given
       standard Windows ControlClassName - must be called after
       creating Params but before CreateWindow. Usually it is called
       in overriden method CreateParams after calling of the inherited one. }

    function UpdateWndStyles: PControl;
    {* Updates fStyle, fExStyle, fClsStyle from window handle }
    procedure SetOnChar(const Value: TOnChar);
    {* }
    {$IFDEF SUPPORT_ONDEADCHAR}
    procedure SetOnDeadChar(const Value: TOnChar);
    {* }
    {$ENDIF SUPPORT_ONDEADCHAR}
    procedure SetOnKeyDown(const Value: TOnKey);
    {* }
    procedure SetOnKeyUp(const Value: TOnKey);
    {* }
    {$ENDIF GDI}
    procedure SetOnMouseDown(const Value: TOnMouse);
    {* }
    procedure SetOnMouseMove(const Value: TOnMouse);
    {* }
    procedure SetOnMouseUp(const Value: TOnMouse);
    {* }
    procedure SetOnMouseWheel(const Value: TOnMouse);
    {* }
    procedure SetOnMouseDblClk(const Value: TOnMouse);
    {* }
    {$IFDEF GDI}
    procedure SetHelpContext( Value: Integer );
    {* }
    procedure SetOnTVDelete( const Value: TOnTVDelete );
    {* }
    procedure SetDefaultBtn(const Index: Integer; const Value: Boolean);
    {$IFDEF F_P}
    function GetDefaultBtn(const Index: Integer): Boolean;
    {$ENDIF F_P}
    function DefaultBtnProc( var Msg: TMsg; var Rslt: Integer ): Boolean;
    {* }

    procedure SetDateTime( Value: TDateTime );
    function GetDateTime: TDateTime;
    procedure SetDateTimeRange( Value: TDateTimeRange );
    function GetDateTimeRange: TDateTimeRange;
    procedure SetDateTimePickerColor( Index: TDateTimePickerColor; Value: TColor );
    function GetDateTimePickerColor( Index: TDateTimePickerColor ): TColor;
    procedure SetDateTimeFormat( const Value: AnsiString );
    function Get_SystemTime: TSystemTime;
    procedure Set_SystemTime(const Value: TSystemTime);

    procedure SetOnTBCustomDraw( const Value: TOnTBCustomDraw );

  {$ENDIF GDI}
    procedure DoAutoSize;

  public
    {$IFDEF GDI}
    constructor CreateParented( AParent: PControl );
    {* Creates new instance of TControl object, calling InitParented }
    constructor CreateOrthaned( AParentWnd: HWnd );
    {* Creates new instance of TControl object, calling InitOrthaned }
    {$ENDIF GDI}
    {$IFDEF _X_}
    {$IFDEF GTK}
    constructor CreateParented( AParent: PControl; widget: PGtkWidget;
      need_eventbox: Boolean );
    {* Creates new instance of TControl object, calling InitParented }
    {$ENDIF GTK}
    {$ENDIF _X_}
  {$IFDEF GDI}
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* Destroyes object. First of all, destructors for all children
       are called. }

    function GetWindowHandle: HWnd;
    {* Returns window handle. If window is not yet created,
       method CreateWindow is called. }
    procedure CreateChildWindows;
    {* Enumerates all children recursively and calls CreateWindow for all
       of these. }
    {$ENDIF GDI}
    property Parent: PControl read fParent write SetParent;
    {* Parent of TParent object. Also must be of TParent type or derived from TParent. }
    //property Tag: Integer read FTag write FTag; //--------- moved to TObj --------
    {* User-defined pointer, which can contain any data or reference to
       anywhere in memory (when used as a pointer).
    }
    function ChildIndex( Child: PControl ): Integer;
    {* Returns index of given child. }
    procedure MoveChild( Child: PControl; NewIdx: Integer );
    {* Moves given Child into new position. }

    {$IFDEF GDI}
    property Enabled: Boolean read GetEnabled write SetEnabled;
    {* Enabled usually used to decide if control can get keyboard focus
       or been clicked by mouse. }
    procedure EnableChildren( Enable, Recursive: Boolean );
    {* Enables (Enable = TRUE) or disables (Enable = FALSE) all the children
       of the control. If Recursive = TRUE then all the children of all the
       children are enabled or disabled recursively. }
    property Visible: Boolean read Get_Visible write SetVisible;
    {* Obvious. }
    property ToBeVisible: Boolean read GetToBeVisible;
    {* Returns True, if a control is supposed to be visible when its
       form is showing. Thus is, True is returned if either control
       is Visible or hidden, but marked with flag fCreateHidden. }
    property CreateVisible: Boolean read fCreateVisible write fCreateVisible;
    {* False by default. If You want your form to be created visible and
       flick due creation, set it to True. This does not affect size of
       executable anyway. }
    property Align: TControlAlign read FAlign write Set_Align;
    {* Align style of a control. If this property is not used in your
       application, there are no additional code added. Aligning of
       controls is made in KOL like in VCL. To align controls when
       initially create ones, use "transparent" function SetAlign
       ("transparent" means that it returns @Self as a result).
       |<br>
       Note, that it is better not to align combobox caClient, caLeft or
       caRight (better way is to place a panel with Border = 0 and
       EdgeStyle = esNone, align it as desired and to place a combobox on it
       aligning caTop or caBottom). Otherwise, big problems could be under
       Win9x/Me, and some delay could occur under any other systems.
       |<br> Do not attempt to align some kinds of controls (like combobox)
       caLeft or caRight, this can cause infinite recursion. }
    {$ENDIF GDI}
    property BoundsRect: TRect read GetBoundsRect write SetBoundsRect;
    {* Bounding rectangle of the visual. Coordinates are relative
       to top left corner of parent's ClientRect, or to top left corner
       of screen (for TForm). }
    property Left: Integer read GetLeft write SetLeft;
    {* Left horizontal position. }
    property Top: Integer read GetTop write SetTop;
    {* Top vertical position. }
    property Width: Integer read GetWidth write SetWidth;
    {* Width of TVisual object. }
    property Height: Integer read GetHeight write SetHeight;
    {* Height of TVisual object. }
    property Position: TPoint read GetPosition write Set_Position;
    {* Represents top left position of the object. See also BoundsRect. }
    {$IFDEF GDI}
    property MinWidth: Integer index 0
             {$IFDEF F_P}   read GetConstraint
             {$ELSE DELPHI} read FMinWidth
             {$ENDIF F_P/DELPHI} write SetConstraint;
    {* Minimal width constraint. }
    property MinHeight: Integer index 1
             {$IFDEF F_P}   read GetConstraint
             {$ELSE DELPHI} read FMinHeight
             {$ENDIF F_P/DELPHI} write SetConstraint;
    {* Minimal height constraint. }
    property MaxWidth: Integer index 2
             {$IFDEF F_P}   read GetConstraint
             {$ELSE DELPHI} read FMaxWidth
             {$ENDIF F_P/DELPHI} write SetConstraint;
    {* Maximal width constraint. }
    property MaxHeight: Integer index 3
             {$IFDEF F_P}   read GetConstraint
             {$ELSE DELPHI} read FMaxHeight
             {$ENDIF F_P/DELPHI} write SetConstraint;
    {* Maximal height constraint. }

    {$ENDIF GDI}
    function ClientRect: TRect;
    {* Client rectangle of TControl. Contrary to VCL, for some
       classes (e.g. for graphic controls) can be relative
       not to itself, but to top left corner of the parent's ClientRect
       rectangle. }
    {$IFDEF GDI}
    property ClientWidth: Integer read GetClientWidth write SetClientWidth;
    {* Obvious. Accessing this property, program forces window latent creation. }
    property ClientHeight: Integer read GetClientHeight write SetClientHeight;
    {* Obvious. Accessing this property, program forces window latent creation. }

    function ControlRect: TRect;
    {* Absolute bounding rectangle relatively to nearest
       Windowed parent client rectangle (at least to a form, but usually to
       a Parent).
       Useful while drawing on device context, provided by such
       Windowed parent. For form itself is the same as BoundsRect. }

    function ControlAtPos( X, Y: Integer; IgnoreDisabled: Boolean ): PControl;
    {* Searches control at the given position (relatively to top left
       corner of the ClientRect). }
    {$ENDIF GDI}
    procedure Invalidate;
    {* Invalidates rectangle, occupied by the visual (but only if Showing =
       True). }
    {$IFDEF GDI}
  protected
    {$IFDEF USE_GRAPHCTLS}
    procedure InvalidateWindowed;
    procedure InvalidateNonWindowed;
    {$ENDIF}
  public
    procedure InvalidateEx;
    {* Invalidates the window and all its children. }
    procedure InvalidateNC( Recursive: Boolean );
    {* Invalidates the window and all its children including non-client area. }
    procedure Update;
    {* Updates control's window and calls Update for all child controls. }
    procedure BeginUpdate;
    {* |<#treeview>
       |<#listview>
       |<#richedit>
       |<#memo>
       |<#listbox>
       Call this method to stop visual updates of the control until correspondent
       EndUpdate called (pairs BeginUpdate - EndUpdate can be nested). }
    procedure EndUpdate;
    {* See BeginUpdate. }

    property Windowed: Boolean read fWindowed write fWindowed;
    {* Constantly returns True, if object is windowed (i.e. owns
        correspondent window handle). Otherwise, returns False.
        |<br>
        By now, all the controls are windowed (there are no controls in KOL, which are
        emulating window, acually belonging to Parent - like TGraphicControl
        in VCL).
        |<br>
        Writing of this property provided only for internal purposes,
        do not change it directly unless you understand well what you do. }

    function HandleAllocated: Boolean;
    {* Returns True, if window handle is allocated. Has no sense for
       non-Windowed objects (but now, the KOL has no non-Windowed controls). }
    property MDIClient: PControl read fMDIClient;
    {* For MDI forms only: returns MDI client window control, containng all MDI
       children. Use this window to send specific messages to rule MDI children. }
    {$ENDIF GDI}

    property ChildCount: Integer read GetChildCount;//GetChildCountWOMembers;
    {* Returns number of commonly accessed child objects (without
       MembersCount). }
    property Children[ Idx: Integer ]: PControl read GetMembers;
    {* Child items of TVisual object. Property is reintroduced here
       to separate access to always visible Children[] from restricted
       a bit Members[]. }
    {$IFDEF GDI}
    property MembersCount: Integer read FMembersCount;
    {* Returns number of "internal" child objects, which are
       not accessible through common Children[] property. }
    property Members[ Idx: Integer ]: PControl read GetMembers;
    {* Members and children array of the object (first from 0 to
       MembersCount-1 are Members[], and Children[] are followed by
       them. Usually You do not need to use this list. Use instead
       Children[0..ChildCount] property, Members[] is intended for
       internal needs of XCL (and in KOL by now Members and Children
       actually are the same properties). }

    procedure PaintBackground( DC: HDC; Rect: PRect );
    {* Is called to paint background in given rectangle. This
       method is filling clipped area of the Rect rectangle with
       Color, but only if global event Global_OnPaintBkgnd is
       not assigned. If assigned, this one is called instead here.
       |<br>&nbsp;&nbsp;&nbsp;
       This method made public, so it can be called directly to
       fill some device context's rectangle. But remember, that
       independantly of Rect, top left corner of background piece
       will be located so, if drawing is occure into ControlRect
       rectangle. }
    property WindowedParent: PControl read fParent;
    {* Returns nearest windowed parent, the same as Parent. }
    {$ENDIF GDI}
    function ParentForm: PControl;
    {* |<#form>
       Returns parent form for a control (of @Self for form itself. }
    {$IFDEF GDI}
    property ActiveControl: PControl read fCurrentControl write fCurrentControl;
    {* }
    function Client2Screen( const P: TPoint ): TPoint;
    {* Converts the client coordinates of a specified point to screen coordinates. }
    function Screen2Client( const P: TPoint ): TPoint;
    {* Converts screen coordinates of a specified point to client coordinates. }
    function CreateWindow: Boolean; virtual;
    {* |<#form>
       Creates correspondent window object. Returns True if success (if
       window is already created, False is returned). If applied to a form,
       all child controls also allocates handles that time.
       |<br>&nbsp;&nbsp;&nbsp;
       Call this method to ensure, that a hanle is allocated for a form,
       an application button or a control. (It is not necessary to do so in
       the most cases, even if You plan to work with control's handle directly.
       But immediately after creating the object, if You want to pass its
       handle to API function, this can be helpful). }
    {$ENDIF GDI}
    {$IFDEF _X_}
    procedure VisualizyWindow; // for _X_, makes actually visible a window and
      // all its subwindows recursively, if they are having Visible = TRUE
    {$ENDIF _X_}
    {$IFDEF GDI}
    procedure Close;
    {* |<#appbutton>
       |<#form>
       Closes window. If a window is the main form, this closes application,
       terminating it. Also it is possible to call Close method for Applet
       window to stop application. }

    {$IFDEF USE_MHTOOLTIP}
    {$DEFINE public}
    {$I KOLMHToolTip}
    {$UNDEF public}
    {$ENDIF}

    property Handle: HWnd read fHandle; //GetHandle;
    {* Returns descriptor of system window object. If window is not yet
       created, 0 is returned. To allocate handle, call CreateWindow method. }

    property ParentWindow: HWnd read GetParentWindow;
    {* Returns handle of parent window (not TControl object, but system
       window object handle). }
    property ClsStyle: DWord read fClsStyle write SetClsStyle;
    {* Window class style. Available styles are:
       |<table border=0>
       |&L=<tr><td valign=top><font face=Fixedsys>%1</font></td><td>
       |&E=</td></tr>
       |&N=<br>&nbsp;&nbsp;&nbsp;
       <L CS_BYTEALIGNCLIENT> - Aligns the window's client area on the byte boundary
          (in the x direction) to enhance performance during
       drawing operations. <E>
       <L CS_BYTEALIGNWINDOW> - Aligns a window on a byte boundary (in the x
          direction). <E>
       <L CS_CLASSDC> - Allocates one device context to be shared by all
          windows in the class. <E>
       <L CS_DBLCLKS> - Sends double-click messages to the window
          procedure when the user double-clicks the mouse while the
          cursor is within a window belonging to the class. <E>
       <L CS_GLOBALCLASS> - Allows an application to create a window of
          the class regardless of the value of the hInstance parameter.
       <N> You can create a global class by creating
          the window class in a dynamic-link library (DLL) and listing the
          name of the DLL in the registry under specific keys. <E>
       <L CS_HREDRAW> - Redraws the entire window if a movement or
          size adjustment changes the width of the client area. <E>
       <L CS_NOCLOSE>  - Disables the Close command on the System menu. <E>
       <L CS_OWNDC> - Allocates a unique device context for each window
          in the class. <E>
       <L CS_PARENTDC> - Sets the clipping region of the child window to
          that of the parent window so that the child can draw on the parent. <E>
       <L CS_SAVEBITS> - Saves, as a bitmap, the portion of the screen
          image obscured by a window. Windows uses the saved bitmap to re-create
          the screen image when the window is removed. <E>
       <L CS_VREDRAW> - Redraws the entire window if a movement or size
          adjustment changes the height of the client area. <E>
       |</table> For more info, see Win32.hlp (keyword 'WndClass');
    }


{$IFDEF GRAPHCTL_XPSTYLES}
    property edgeStyle : TEdgeStyle read fEdgeStyle write SetEdgeStyle;
{$ENDIF}

    property Style: DWord read fStyle write SetStyle;
    {* Window styles. Available styles are:
       |<table border=0>
       <L WS_BORDER>	Creates a window that has a thin-line border. <E>
       <L WS_CAPTION>	Creates a window that has a title bar (includes the
          WS_BORDER style). <E>
       <L WS_CHILD>	Creates a child window. This style cannot be used with
          the WS_POPUP style. <E>
       <L WS_CHILDWINDOW>	Same as the WS_CHILD style. <E>
       <L WS_CLIPCHILDREN>	Excludes the area occupied by child windows
          when drawing occurs within the parent window. This style is used
          when creating the parent window. <E>
       <L WS_CLIPSIBLINGS>	Clips child windows relative to each other;
          that is, when a particular child window receives a WM_PAINT message,
          the WS_CLIPSIBLINGS style clips all other overlapping child windows
          out of the region of the child window to be updated. If
          WS_CLIPSIBLINGS is not specified and child windows overlap, it is
          possible, when drawing within the client area of a child window,
          to draw within the client area of a neighboring child window. <E>
       <L WS_DISABLED>	Creates a window that is initially disabled. A
          disabled window cannot receive input from the user. <E>
       <L WS_DLGFRAME>	Creates a window that has a border of a style
          typically used with dialog boxes. A window with this style cannot
          have a title bar. <E>
       <L WS_GROUP>	Specifies the first control of a group of controls.
          The group consists of this first control and all  controls defined
          after it, up to the next control with the WS_GROUP style.
          The first control in each group usually has the WS_TABSTOP
          style so that the user can move from group to group. The user
          can subsequently change the keyboard focus from one control in
          the group to the next control in the group by using the direction
          keys. <E>
       <L WS_HSCROLL>	Creates a window that has a horizontal scroll bar. <E>
       <L WS_ICONIC>	Creates a window that is initially minimized. Same as
          the WS_MINIMIZE style. <E>
       <L WS_MAXIMIZE>	Creates a window that is initially maximized. <E>
       <L WS_MAXIMIZEBOX>	Creates a window that has a Maximize button.
          Cannot be combined with the WS_EX_CONTEXTHELP style. The WS_SYSMENU
          style must also be specified. <E>
       <L WS_MINIMIZE>	Creates a window that is initially minimized.
          Same as the WS_ICONIC style. <E>
       <L WS_MINIMIZEBOX>	Creates a window that has a Minimize button.
          Cannot be combined with the WS_EX_CONTEXTHELP style. The WS_SYSMENU
          style must also be specified. <E>
       <L WS_OVERLAPPED>	Creates an overlapped window. An overlapped
          window has a title bar and a border. Same as the WS_TILED style. <E>
       <L WS_OVERLAPPEDWINDOW>	Creates an overlapped window with the
          WS_OVERLAPPED, WS_CAPTION, WS_SYSMENU, WS_THICKFRAME, WS_MINIMIZEBOX,
          and WS_MAXIMIZEBOX styles. Same as the WS_TILEDWINDOW style. <E>
       <L WS_POPUP>	Creates a pop-up window. This style cannot be used with
          the WS_CHILD style. <E>
       <L WS_POPUPWINDOW>	Creates a pop-up window with WS_BORDER,
          WS_POPUP, and WS_SYSMENU styles. The WS_CAPTION and WS_POPUPWINDOW
          styles must be combined to make the window menu visible. <E>
       <L WS_SIZEBOX>	Creates a window that has a sizing border. Same as the
          WS_THICKFRAME style. <E>
       <L WS_SYSMENU>	Creates a window that has a window-menu on its title
          bar. The WS_CAPTION style must also be specified. <E>
       <L WS_TABSTOP>	Specifies a control that can receive the keyboard focus
          when the user presses the TAB key. Pressing the TAB key changes
          the keyboard focus to the next control with the WS_TABSTOP style. <E>
       <L WS_THICKFRAME>	Creates a window that has a sizing border.
          Same as the WS_SIZEBOX style. <E>
       <L WS_TILED>	Creates an overlapped window. An overlapped window has
          a title bar and a border. Same as the WS_OVERLAPPED style. <E>
       <L WS_TILEDWINDOW>	Creates an overlapped window with the
          WS_OVERLAPPED, WS_CAPTION, WS_SYSMENU, WS_THICKFRAME,
          WS_MINIMIZEBOX, and WS_MAXIMIZEBOX styles. Same as the
          WS_OVERLAPPEDWINDOW style. <E>
       <L WS_VISIBLE>	Creates a window that is initially visible. <E>
       <L WS_VSCROLL>	Creates a window that has a vertical scroll bar. <E>
       |</table>
       See also Win32.hlp (topic CreateWindow).
    }
    property ExStyle: DWord read fExStyle write SetExStyle;
    {* Extra window styles. Available flags are following:
       |<table border=0>
       <L WS_EX_ACCEPTFILES>	Specifies that a window created with this style
          accepts drag-drop files. <E>
       <L WS_EX_APPWINDOW>	Forces a top-level window onto the taskbar
          when the window is minimized. <E>
       <L WS_EX_CLIENTEDGE>	Specifies that a window has a border with a
          sunken edge. <E>
       <L WS_EX_CONTEXTHELP>	Includes a question mark in the title bar of
          the window. When the user clicks the question mark, the cursor
          changes to a question mark with a pointer. If the user then clicks
          a child window, the child receives a WM_HELP message. The child
          window should pass the message to the parent window procedure,
          which should call the WinHelp function using the HELP_WM_HELP
          command. The Help application displays a pop-up window that
          typically contains help for the child window.WS_EX_CONTEXTHELP
          cannot be used with the WS_MAXIMIZEBOX or WS_MINIMIZEBOX styles. <E>
       <L WS_EX_CONTROLPARENT> Allows the user to navigate among the child
          windows of the window by using the TAB key. <E>
       <L WS_EX_DLGMODALFRAME> Creates a window that has a double border;
          the window can, optionally, be created with a title bar by
          specifying the WS_CAPTION style in the dwStyle parameter. <E>
       <L WS_EX_LEFT>	Window has generic "left-aligned" properties. This
          is the default. <E>
       <L WS_EX_LEFTSCROLLBAR> If the shell language is Hebrew, Arabic, or
          another language that supports reading order alignment, the
          vertical scroll bar (if present) is to the left of the client
          area. For other languages, the style is ignored and not treated
          as an error. <E>
       <L WS_EX_LTRREADING>	The window text is displayed using Left to
          Right reading-order properties. This is the default. <E>
       <L WS_EX_MDICHILD>	Creates an MDI child window. <E>
       <L WS_EX_NOPARENTNOTIFY>	Specifies that a child window created
          with this style does not send the WM_PARENTNOTIFY message to its
          parent window when it is created or destroyed. <E>
       <L WS_EX_OVERLAPPEDWINDOW>	Combines the WS_EX_CLIENTEDGE and
          WS_EX_WINDOWEDGE styles. <E>
       <L WS_EX_PALETTEWINDOW> Combines the WS_EX_WINDOWEDGE,
          WS_EX_TOOLWINDOW, and WS_EX_TOPMOST styles. <E>
       <L WS_EX_RIGHT> Window has generic "right-aligned" properties.
          This depends on the window class. This style has an effect only
          if the shell language is Hebrew, Arabic, or another language that
          supports reading order alignment; otherwise, the style is
          ignored and not treated as an error. <E>
       <L WS_EX_RIGHTSCROLLBAR> Vertical scroll bar (if present) is to the
          right of the client area. This is the default. <E>
       <L WS_EX_RTLREADING>	If the shell language is Hebrew, Arabic, or
          another language that supports reading order alignment, the
          window text is displayed using Right to Left reading-order
          properties. For other languages, the style is ignored and not
          treated as an error. <E>
       <L WS_EX_STATICEDGE>	Creates a window with a three-dimensional
          border style intended to be used for items that do not accept
          user input. <E>
       <L WS_EX_TOOLWINDOW>	Creates a tool window; that is, a window
          intended to be used as a floating toolbar. A tool window has
          a title bar that is shorter than a normal title bar, and the
          window title is drawn using a smaller font. A tool window does
          not appear in the taskbar or in the dialog that appears when
          the user presses ALT+TAB. <E>
       <L WS_EX_TOPMOST> Specifies that a window created with this style
          should be placed above all non-topmost windows and should stay
          above them, even when the window is deactivated. To add or remove
          this style, use the SetWindowPos function. <E>
       <L WS_EX_TRANSPARENT>	Specifies that a window created with this
          style is to be transparent. That is, any windows that are
          beneath the window are not obscured by the window. A window
          created with this style receives WM_PAINT messages only after
          all sibling windows beneath it have been updated. <E>
       <L WS_EX_WINDOWEDGE>	Specifies that a window has a border with
          a raised edge. <E>
       |</table>
       See also Win32.hlp (topic CreateWindowEx).
    }

    property Cursor: HCursor read fCursor write SetCursor;
    {* Current cursor. For most of controls, sets initially to IDC_ARROW. See
       also ScreenCursor. }
    procedure CursorLoad( Inst: Integer; ResName: PKOLChar );
    {* Loads Cursor from the resource. See also comments for Icon property. }

    property Icon: HIcon read {$IFDEF SMALLEST_CODE} fIcon {$ELSE} GetIcon {$ENDIF}
      write SetIcon;
    {* |<#appbutton>
       |<#form>
       Icon. By default, icon of the Applet is used. To load icon from the
       resource, use IconLoad or IconLoadCursor method - this is more correct, because
       in such case a special flag is set to prevent attempts to destroy
       shared icon object in the destructor of the control. }

    procedure IconLoad( Inst: Integer; ResName: PKOLChar );
    {* |<#appbutton>
       |<#form>
       See Icon property. }
    procedure IconLoadCursor( Inst: Integer; ResName: PKOLChar );
    {* |<#appbutton>
       |<#form>
       Loads Icon from the cursor resource. See also Icon property. }

    property Menu: HMenu read fMenu write SetMenu;

    {* Menu (or ID of control - for standard GUI controls). }
    property HelpContext: Integer read fHelpContext write SetHelpContext;
    {* Help context. }
    function AssignHelpContext( Context: Integer ): PControl;
    {* Assigns HelpContext and returns @ Self (can be used in initialization
       of a control in a chain of "transparent" calls). }

    procedure CallHelp( Context: Integer; CtxCtl: PControl {; CtlID: Integer} );
    {* Method of a form or Applet. Call it to show help with the given context
       ID. If the Context = 0, help contents is displayed. By default,
       WinHelp is used. To allow using HtmlHelp, call AssignHtmlHelp global
       function. When WinHelp used, HelpPath variable can be assigned directly.
       If HelpPath variable is not assigned, application name
       (and path) is used, with extension replaced to '.hlp'. }

    property HelpPath: KOLString read GetHelpPath write SetHelpPath;
    {* Property of a form or an Applet. Change it to provide custom path to
       WinHelp format help file. If HtmlHelp used, call global procedure
       AssignHtmlHelp instead. }

    property OnHelp: TOnHelp read fOnHelp write fOnHelp;
    {* An event of a form, it is called when F1 pressed or help topic requested
       by any other way. To prevent showing help, nullify Sender. Set Popup to
       TRUE to provide showing help in a pop-up window. It is also possible to
       change Context dynamically. }

    {$ENDIF GDI}
    property Caption: KOLString read GetCaption write SetCaption;
    {* |<#appbutton>
       |<#form>
       |<#button>
       |<#bitbtn>
       |<#label>
       |<#wwlabel>
       |<#3dlabel>
       Caption of a window. For standard Windows buttons, labels and so on
       not a caption of a window, but text of the window. }
    property Text: KOLString read GetCaption write SetCaption;
    {* |<#edit>
       |<#memo>
       The same as Caption. To make more convenient with Edit controls. For
       Rich Edit control, use property RE_Text. }

    {$IFDEF GDI}
    property SelStart: Integer read GetSelStart write SetSelStart;
    {* |<#edit>
       |<#memo>
       |<#richedit>
       Start of selection (editbox - character position). }
    property SelLength: Integer read GetSelLength write SetSelLength;
    {* |<#edit>
       |<#memo>
       |<#richedit>
       |<#listbox>
       |<#listview>
       Length of selection (editbox - number of characters selected, multiselect
       listbox or listview - number of items selected).
       |<br>
       Note, that for combobox and single-select listbox it always returns 0
       (though for single-select listview, returns 1, if there is an item
       selected).
       |<br>
       It is possible to set SelLength only for memo and richedit controls. }

    property Selection: KOLString read GetSelection write SetSelection;
    {* |<#edit>
       |<#memo>
       |<#richedit>
       Selected text (editbox, richedit) as string. Can be useful to replace
       selection. For rich edit, use RE_Text[ reText, TRUE ], if you want to
       read correctly characters from another locale then ANSI only. }
    procedure SelectAll;
    {* |<#edit>
       |<#memo>
       |<#richedit>
       Makes all the text in editbox or RichEdit, or all items in listbox
       selected. }

    procedure ReplaceSelection( const Value: KOLString; aCanUndo: Boolean );
    {* |<#edit>
       |<#memo>
       |<#richedit>
       Replaces selection (in edit, RichEdit). Unlike assigning new value
       to Selection property, it is possible to specify, if operation can
       be undone. }

    procedure DeleteLines( FromLine, ToLine: Integer );
    {* |<#edit>
       |<#memo>
       |<#richedit>
       Deletes lines from FromLine to ToLine (inclusively, i.e. 0 to 0 deletes
       one line with index 0). Current selection is restored as possible. }
    property CurIndex: Integer read GetCurIndex write SetCurIndex;
    {* |<#listbox>
       |<#combo>
       |<#toolbar>
       Index of current item (for listbox, combobox) or button index pressed
       or dropped down (for toolbar button, and only in appropriate event
       handler call).
       |<br>
       You cannot use it to set or remove a selection in a multiple-selection
       list box, so you should set option loNoExtendSel to true.
       |<br>
       In OnClick event handler, CurIndex has not yet changed for listbox or combobox.
       Use OnSelChange to respond to selection changes. }

    property Count: Integer read GetItemsCount write SetItemsCount;
    {* |<#listbox>
       |<#combo>
       |<#listview>
       |<#treeview>
       |<#edit>
       |<#memo>
       |<#richedit>
       |<#toolbar>
       Number of items (listbox, combobox, listview) or lines (multiline
       editbox, richedit control) or buttons (toolbar). It is possible to
       assign a value to this property only for listbox control with loNoData
       style and for list view control with lvoOwnerData style (virtual list
       box and list view). }

    property Items[ Idx: Integer ]: KOLString read GetItems write SetItems;
    {* |<#edit>
       |<#listbox>
       |<#combo>
       |<#memo>
       |<#richedit>
       Obvious. Used with editboxes, listbox, combobox. With list view, use
       property LVItems instead. }

    function Item2Pos( ItemIdx: Integer ): DWORD;
    {* |<#edit>
       |<#memo>
       Only for edit controls: converts line index to character position. }
    function Pos2Item( Pos: Integer ): DWORD;
    {* |<#edit>
       |<#memo>
       Only for edit controls: converts character position to line index. }

    function SavePosition: TEditPositions;
    {* |<#edit>
       |<#memo>
       Only for edit controls: saves current editor selection and scroll
       positions. To restore position, use RestorePosition with a structure,
       containing saved position as a parameter. }
    procedure RestorePosition( const p: TEditPositions );
    {* |<#edit>
       |<#memo>
       Call RestorePosition with a structure, containing saved position
       as a parameter (this structure filled in in SavePosition method).
       If you set RestoreScroll to FALSE, only selection is restored,
       without scroll position. }
    procedure UpdatePosition( var p: TEditPositions; FromPos,
              CountInsertDelChars, CountInsertDelLines: Integer );
    {* |<#edit>
       |<#memo>
       If you called SavePosition and then make some changes in the edit control,
       calling RestorePosition will fail if chages are affecting selection size.
       The problem can be solved updating saved position info using this method.
       Pass a count of inserted characters and lines as a positive number and a
       count of deleted characters as a negative number here. CountInsertDelLines
       is optional paramters: if you do not specify it, only selection is fixed.
    }

    function EditTabChar: PControl;
    {* |<#edit>
       |<#memo>
       Call this method (once) to provide insertion of tab character (code #9)
       when tab key is pressed on keyboard. }

    function IndexOf( const S: KOLString ): Integer;
    {* |<#listbox>
       |<#combobox>
       |<#tabcontrol>
       Works for the most of control types, though some of those
       have its own methods to search given item. If a control is not
       list box or combobox, item is finding by enumerating all
       the Items one by one. See also SearchFor method. }
    function SearchFor( const S: KOLString; StartAfter: Integer; Partial: Boolean ): Integer;
    {* |<#listbox>
       |<#combobox>
       |<#tabcontrol>
       Works for the most of control types, though some of those
       have its own methods to search given item. If a control is not
       list box or combobox, item is finding by enumerating all
       the Items one by one. See also IndexOf method. }

    property ItemSelected[ ItemIdx: Integer ]: Boolean read GetItemSelected write SetItemSelected;
    {* |<#edit>
       |<#memo>
       |<#listbox>
       |<#combo>
       |<#listview>
       Returns True, if a line (in editbox) or an item (in listbox, combobox,
       listview) is selected.
       Can be set only for listboxes. For listboxes, which are not multiselect, and
       for combo lists, it is possible only to set to True, to change selection. }

    property ItemData[ Idx: Integer ]: DWORD read GetItemData write SetItemData;
    {* |<#listbox>
       |<#combo>
       Access to user-defined data, associated with the item of a list box and
       combo box. }
    property OnDropDown: TOnEvent read fOnDropDown write fOnDropDown;
    {* |<#combo>
       |<#toolbar>
       Is called when combobox is dropped down (or drop-down button of
       toolbar is pressed - see also OnTBDropDown). }
    property OnCloseUp: TOnEvent read fOnCloseUp write fOnCloseUp;
    {* |<#combo>
       Is called when combobox is closed up. When drop down list is closed
       because user pressed "Escape" key, previous selection is restored.
       To test if it is so, call GetKeyState( VK_ESCAPE ) and check, if
       negative value is returned (i.e. Escape key is pressed when event
       handler is calling). }
    property DroppedWidth: Integer read FDroppedWidth write SetDroppedWidth;
    {* |<#combo>
       Allows to change width of dropped down items list for combobox (only!)
       control. }
    property DroppedDown: Boolean read fDropped write SetDroppedDown;
    {* |<#combo>
       Dropped down state for combo box. Set it to TRUE or FALSE to change
       dropped down state. }
    procedure AddDirList( const Filemask: KOLString; Attrs: DWORD );
    {* |<#listbox>
       |<#combo>
       Can be used only with listbox and combobox - to add directory list items,
       filtered by given Filemask (can contain wildcards) and Attrs. Following
       flags can be combined in Attrs:
       |<table border=0>
       |&L=<tr><td>%1</td><td>
       <L DDL_ARCHIVE> Include archived files. <E>
       <L DDL_DIRECTORY> Includes subdirectories. Subdirectory names are
          enclosed in square brackets ([ ]). <E>
       <L DDL_DRIVES> Includes drives. Drives are listed in the form [-x-],
          where x is the drive letter. <E>
       <L DDL_EXCLUSIVE> Includes only files with the specified attributes.
          By default, read-write files are listed even if DDL_READWRITE is
          not specified. Also, this flag needed to list directories only,
          etc. <E>
       <L DDL_HIDDEN> Includes hidden files. <E>
       <L DDL_READONLY> Includes read-only files. <E>
       <L DDL_READWRITE> Includes read-write files with no additional
          attributes. <E>
       <L DDL_SYSTEM> Includes system files. <E>
       </table>
       If the listbox is sorted, directory items will be sorted (alpabetically). }
    property OnBitBtnDraw: TOnBitBtnDraw read fOnBitBtnDraw write fOnBitBtnDraw;
    {* |<#bitbtn>
       Special event for BitBtn. Using it, it is possible to provide
       additional effects, such as highlighting button text (by changing
       its Font and other properties). If the handler returns True, it is
       supposed that it made all drawing and there are no further drawing
       occure. }
    property BitBtnDrawMnemonic: Boolean read FBitBtnDrawMnemonic write SetBitBtnDrawMnemonic;
    {* |<#bitbtn>
       Set this property to TRUE to provide correct drawing of bit btn control
       caption with '&' characters (to remove such characters, and underline
       follow ones). }
    property TextShiftX: Integer read fTextShiftX write fTextShiftX;
    {* |<#bitbtn>
       Horizontal shift for bitbtn text when the bitbtn is pressed. }
    property TextShiftY: Integer read fTextShiftY write fTextShiftY;
    {* |<#bitbtn>
       Vertical shift for bitbtn text when the bitbtn is pressed. }
    property BitBtnImgIdx: Integer read GetBitBtnImgIdx write SetBitBtnImgIdx;
    {* |<#bitbtn>
       BitBtn image index for the first image in list view, used as bitbtn
       image. It is used only in case when BitBtn is created with bboImageList
       option. }
    property BitBtnImgList: THandle read GetBitBtnImageList write SetBitBtnImageList;
    {* |<#bitbtn>
       BitBtn Image list. Assign image list handle to change it. }

    function SetButtonIcon( aIcon: HIcon ): PControl;
    {* |<#button>
       Sets up button icon image and changes its styles. Returns button itself. }
    function SetButtonBitmap( aBmp: HBitmap ): PControl;
    {* |<#button>
       Sets up button icon image and changes its styles. Returns button itself. }

    property OnMeasureItem: TOnMeasureItem read fOnMeasureItem write SetOnMeasureItem;
    {* |<#combo>
       |<#listbox>
       |<#listview>
       This event is called for owner-drawn controls, such as list box, combo box,
       list view with appropriate owner-drawn style. For fixed item height controls
       (list box with loOwnerDrawFixed style, combobox with coOwnerDrawFixed and
       list view with lvoOwnerDrawFixed option) this event is called once. For
       list box with loOwnerDrawVariable style and for combobox with coOwnerDrawVariable
       style this event is called for every item. }

    property DefaultBtn: Boolean index 13
             {$IFDEF F_P}   read GetDefaultBtn
             {$ELSE DELPHI} read fDefaultBtn
             {$ENDIF F_P/DELPHI} write SetDefaultBtn;
    {* |<#button>
       |<#bitbtn>
       Set this property to true to make control clicked when ENTER key is pressed.
       This property uses OnMessage event of the parent form, storing it into
       fOldOnMessage field and calling in chain. So, assign default button
       after setting OnMessage event for the form. }
    property CancelBtn: Boolean index 27
             {$IFDEF F_P}   read GetDefaultBtn
             {$ELSE DELPHI} read fCancelBtn
             {$ENDIF F_P/DELPHI} write SetDefaultBtn;
    {* |<#button>
       |<#bitbtn>
       Set this property to true to make control clicked when escape key is pressed.
       This property uses OnMessage event of the parent form, storing it into
       fOldOnMessage field and calling in chain. So, assign cancel button
       after setting OnMessage event for the form. }
    function AllBtnReturnClick: PControl;
    {* Call this method for a form or any its control to provide clicking
       a focused button when ENTER pressed. By default, a button can be clicked
       only by SPACE key from the keyboard, or by mouse. }
    property IgnoreDefault: Boolean read fIgnoreDefault write fIgnoreDefault;
    {* Change this property to TRUE to ignore default button reaction on
       press ENTER key when a focus is grabbed of the control. Default
       value is different for different controls. By default, DefaultBtn
       ignored in memo, richedit (even if read-only). }

    {$ENDIF GDI}
    property Color: TColor read fColor write SetCtlColor;
    {* Property Color is one of the most common for all visual
       elements (like form, control etc.) Please note, that standard GUI button
       can not change its color and the most characteristics of the Font. Also,
       standard button can not become Transparent. Use bitbtn for such purposes.
       Also, changing Color property for some kinds of control has no effect (rich edit,
       list view, tree view, etc.). To solve this, use native (for such controls)
       color property, or call Perform method with appropriate message to set the
       background color. }
    property Font: PGraphicTool read GetFont;
    {* If the Font property is not accessed, correspondent TGraphicTool object
       is not created and its methods are not included into executable. Leaving
       properties Font and Brush untouched can economy executable size a lot. }
    {$IFDEF GDI}
    property Brush: PGraphicTool read GetBrush;
    {* If not accessed, correspondent TGraphicTool object is not created
       and its methods are not referenced. See also note on Font property. }

    property Ctl3D: Boolean read fCtl3D write SetCtl3D;
    {* Inheritable from parent controls to child ones. }

    procedure Show;
    {* |<#appbutton>
       |<#form>
       Makes control visible and activates it. }
    function ShowModal: Integer;
    {* |<#form>
       Can be used only with a forms to show it modal. See also global function
       ShowMsgModal.
       |<br>
       To use a form as a modal, it is possible to make it either auto-created
       or dynamically created. For a first case, You (may be prefer to hide a
       form after showing it as a modal:
       !
       !  procedure TForm1.Button1Click( Sender: PObj );
       !  begin
       !    Form2.Form.ShowModal;
       !    Form2.Form.Hide;
       !  end;
       !
       Another way is to create modal form just before showing it (this economies
       system resources):
       !
       !  procedure TForm1.Button1Click( Sender: PObj );
       !  begin
       !    NewForm2( Form2, Applet );
       !    Form2.Form.ShowModal;
       !    Form2.Form.Free; // Never call Form2.Free or Form2.Form.Close
       !  end;               // but always Form2.Form.Free; (!)
       !
       In samples above, You certainly can place any wished code before and after
       calling ShowModal method.
       |<br>
       Do not forget that if You have more than a single form in your project,
       separate Applet object should be used.
       |<br>
       See also ShowModalEx.
       }
    function ShowModalParented( const AParent: PControl ): Integer;
    {* by Alexander Pravdin. The same as ShowModal, but with a certain
       form as a parent. }
    function ShowModalEx: Integer;
    {* The same as ShowModal, but all the windows of current thread are
       disabled while showing form modal. This is useful if KOL form from
       a DLL is used modally in non-KOL application. }
    property ModalResult: Integer read fModalResult write
    {$IFDEF USE_SETMODALRESULT}
    SetModalResult;
    {$ELSE}
    fModalResult;
    {$ENDIF}
    {* |<#form>
       Modal result. Set it to value<>0 to stop modal dialog. By agreement,
       value 1 corresponds 'OK', 2 - 'Cancel'. But it is totally by decision
       of yours how to interpret this value. }
    property Modal: Boolean read GetModal;
    {* |<#form>
       TRUE, if the form is shown modal. }
    property ModalForm: PControl read fModalForm write fModalForm;
    {* |<#form>
       |<#appbutton>
       Form currently shown modal from this form or from Applet. }

    procedure Hide;
    {* |<#appbutton>
       |<#form>
       Makes control hidden. }
    property OnShow: TOnEvent read FOnShow write SetOnShow;
    {* Is called when a control or form is to be shown. This event is not fired
       for a form, if its WindowState initially is set to wsMaximized or
       wsMinimized. This behaviour is by design (the window does not receive
       WM_SHOW message in such case). }
    property OnHide: TOnEvent read FOnHide write SetOnHide;
    {* Is called when a control or form becomes hidden. }
    property WindowState: TWindowState read GetWindowState write SetWindowState;
    {* |<#form>
       Window state. }

    {$ENDIF GDI}
    property Canvas: PCanvas read GetCanvas;
    {* |<#paintbox>
       Placeholder for Canvas: PCanvas. But in KOL, it is possible to
       create applets without canvases at all. To do so, avoid using
       Canvas and use DC directly (which is passed in OnPaint event). }
    {$IFDEF GDI}
    function CallDefWndProc( var Msg: TMsg ): Integer;
    {* Function to be called in WndProc method to redirect message handling
       to default window procedure. }
    function DoSetFocus: Boolean;
    {* Sets focus for Enabled window. Returns True, if success. }

    procedure MinimizeNormalAnimated;
    {* |<#form>
       Apply this method to a main form (not to another form or Applet,
       even when separate Applet control is not used and main form matches it!).
       This provides normal animated visual minimization for the application.
       It therefore has no effect, if animation during minimize/resore is
       turned off by user.
       |<br>
       Applying this method also provides for the main form (only for it)
       correct restoring the form maximized if it was maximized while
       minimizing the application. See also RestoreNormalMaximized method. }
    procedure RestoreNormalMaximized;
    {* |<#form>
       Apply to any form for which it is important to restore it maximized
       when the application was minimizing while such form was maximized.
       If the method MinimizeNormalAnimated was called for the main form,
       then the correct behaviour is already provided for the main form, so
       in such case it is no more necessary to call also this method, but
       calling it therefore is not an error. }

    property OnMessage: TOnMessage read fOnMessage write fOnMessage;
    {* |<#appbutton>
       |<#form>
       Is called for every message processed by TControl object. And for
       Applet window, this event is called also for all messages, handled by
       all its child windows (forms). }

    {$ENDIF GDI}
    function IsMainWindow: Boolean;
    {* |<#appbutton>
       |<#form>
       Returns True, if a window is the main in application (created first
       after the Applet, or matches the Applet). }
    property IsApplet: Boolean read FIsApplet;
    {* Returns true, if the control is created using NewApplet (or CreateApplet).
    }
    property IsForm: Boolean read fIsForm;
    {* Returns True, if the object is form window. }
    property IsMDIChild: Boolean read fIsMDIChild;
    {* Returns TRUE, if the object is MDI child form. In such case, IsForm also
       returns TRUE. }
    property IsControl: Boolean read fIsControl;
    {* Returns True, is the control is control (not form or applet). }
    property IsButton: Boolean read fIsButton;
    {* Returns True, if the control is button-like or containing buttons (button,
       bitbtn, checkbox, radiobox, toolbar). }

    {$IFDEF GDI}
    function ProcessMessage: Boolean;
    {* |<#appbutton>
       Processes one message. See also ProcessMessages. }

    procedure ProcessMessages;
    {* |<#appbutton>
       Processes pending messages during long cycle of calculation,
       allowing to window to be repainted if needed and to respond to other
       messages. But if there are no such messages, your application can be
       stopped until such one appear in messages queue. To prevent such
       situation, use method ProcessPendingMessages instead. }

    procedure ProcessMessagesEx;
    {* Version of ProcessMessages, which works always correctly, even if
       the application is minimized or background. }

    procedure ProcessPendingMessages;
    {* |<#appbutton>
       Similar to ProcessMessages, but without waiting of
       message in messages queue. I.e., if there are no pending
       messages, this method immediately returns control to your
       code. This method is better to call during long cycle of
       calculation (then ProcessMessages). }
    procedure ProcessPaintMessages;
    {* }
    function WndProc( var Msg: TMsg ): Integer; virtual; //{$IFNDEF DEBUG_MCK} virtual; {$ENDIF}
    {* Responds to all Windows messages, posted (sended) to the
       window, before all other proceeding. You can override it in
       derived controls, but in KOL there are several other ways
       to control message flow of existing controls without deriving
       another costom controls for only such purposes. See OnMessage,
       AttachProc.  }
    property HasBorder: Boolean read GetHasBorder write SetHasBorder;
    {* |<#form>
       Obvious. Form-aware. }

    property HasCaption: Boolean read GetHasCaption write SetHasCaption;
    {* |<#form>
       Obvious. Form-aware. }
    property CanResize: Boolean read GetCanResize write SetCanResize;
    {* |<#form>
       Obvious. Form-aware. }
    property StayOnTop: Boolean read GetStayOnTop write SetStayOnTop;
    {* |<#form>
       Obvious. Form-aware, but can be applied to controls. }
    property Border: Integer read fMargin write fMargin;
    {* |<#form>
       Distance between edges and child controls and between child
       controls by default (if methods PlaceRight, PlaceDown, PlaceUnder,
       ResizeParent, ResizeParentRight, ResizeParentBottom are called).
       |<br>
       Originally was named Margin, now I recommend to use the name 'Border' to
       avoid confusion with MarginTop, MarginBottom, MarginLeft and
       MarginRight properties.
       |<br>
       Initial value is always 2. Border property is used in realigning
       child controls (when its Align property is not caNone), and value
       of this property determines size of borders between edges of children
       and its parent and between aligned controls too.
       |<br>
       See also properties MarginLeft, MarginRight, MarginTop, MarginBottom. }
    function SetBorder( Value: Integer ): PControl;
    {* Assigns new Border value, and returns @ Self. }

    property Margin: Integer read fMargin write fMargin;
    {* |<#form>
       Old name for property Border. }

    property MarginTop: Integer index 1
             {$IFDEF F_P}   read GetClientMargin
             {$ELSE DELPHI} read fClientTop
             {$ENDIF F_P/DELPHI} write SetClientMargin;
    {* Additional distance between true window client top and logical top of
       client rectangle. This value is added to Top of rectangle, returning
       by property ClientRect. Together with other margins and property Border,
       this property allows to change view of form for case, that Align property
       is used to align controls on parent (it is possible to provide some
       distance from child controls to its parent, and between child controls.
       |<br>
       Originally this property was introduced to compensate incorrect
       ClientRect property, calculated for some types of controls.
       |<br>
       See also properties Border, MarginBottom, MarginLeft, MarginRight. }
    property MarginBottom: Integer index 2
             {$IFDEF F_P}   read GetClientMargin
             {$ELSE DELPHI} read fClientBottom
             {$ENDIF F_P/DELPHI} write SetClientMargin;
    {* The same as MarginTop, but a distance between true window Bottom of
       client rectangle and logical bottom one. Take in attention, that this value
       should be POSITIVE to make logical bottom edge located above true edge.
       |<br>
       See also properties Border, MarginTop, MarginLeft, MarginRight. }
    property MarginLeft: Integer index 3
             {$IFDEF F_P}   read GetClientMargin
             {$ELSE DELPHI} read fClientLeft
             {$ENDIF F_P/DELPHI} write SetClientMargin;
    {* The same as MarginTop, but a distance between true window Left of
       client rectangle and logical left edge.
       |<br>
       See also properties Border, MarginTop, MarginRight, MarginBottom. }
    property MarginRight: Integer index 4
             {$IFDEF F_P}   read GetClientMargin
             {$ELSE DELPHI} read fClientRight
             {$ENDIF F_P/DELPHI} write SetClientMargin;
    {* The same as MarginLeft, but a distance between true window Right of
       client rectangle and logical bottom one. Take in attention, that this value
       should be POSITIVE to make logical right edge located left of true edge.
       |<br>
       See also properties Border, MarginTop, MarginLeft, MarginBottom. }

    property Tabstop: Boolean read fTabstop write fTabstop;
    {* True, if control can be focused using tabulating between controls.
       Set it to False to make control unavailable for keyboard, but only
       for mouse. }

    property TabOrder: Integer read fTabOrder write SetTabOrder;
    {* Order of tabulating of controls. Initially, TabOrder is equal to
       creation order of controls. If TabOrder changed, TabOrder of
       all controls with not less value of one is shifted up. To place
       control before another, assign TabOrder of one to another.
       For example:
       !             Button1.TabOrder := EditBox1.TabOrder;
       In code above, Button1 is placed just before EditBox1 in tabulating
       order (value of TabOrder of EditBox1 is incremented, as well as
       for all follow controls). }

    property Focused: Boolean read GetFocused write SetFocused;
    {* True, if the control is current on form (but check also, what form
       itself is focused). For form it is True, if the form is active (i.e.
       it is foreground and capture keyboard). Set this value to True to make
       control current and focused (if applicable). }

    function BringToFront: PControl;
    {* Changes z-order of the control, bringing it to the topmost level. }
    function SendToBack: PControl;
    {* Changes z-order of the control, sending it to the back of siblings. }
    {$ENDIF GDI}
    property TextAlign: TTextAlign read GetTextAlign write SetTextAlign;
    {* |<#label>
       |<#panel>
       |<#button>
       |<#bitbtn>
       |<#edit>
       |<#memo>
       Text horizontal alignment. Applicable to labels, buttons,
       multi-line edit boxes, panels. }
    property VerticalAlign: TVerticalAlign read GetVerticalAlign write SetVerticalAlign;
    {* |<#button>
       |<#label>
       |<#panel>
       Text vertical alignment. Applicable to buttons, labels and panels. }
    {$IFDEF GDI}
    property WordWrap: Boolean read fWordWrap write fWordWrap;
    {* TRUE, if this is a label, created using NewWordWrapLabel. }
    property ShadowDeep: Integer read FShadowDeep write SetShadowDeep;
    {* |<#3dlabel>
       Deep of a shadow (for label effect only, created calling NewLabelEffect). }

    property CannotDoubleBuf: Boolean read fCannotDoubleBuf write fCannotDoubleBuf;
    {* }
    property DoubleBuffered: Boolean read fDoubleBuffered write SetDoubleBuffered;
    {* Set it to true for some controls, which are flickering in repainting
       (like label effect). Slow, and requires additional code. This property
       is inherited by all child controls.
       |<br>&nbsp;&nbsp;&nbsp;
       Note: RichEdit control can not become DoubleBuffered. }
    function DblBufTopParent: PControl;
    {* Returns the topmost DoubleBuffered Parent control. }
    property Transparent: Boolean read fTransparent write SetTransparent;
    {* Set it to true to get special effects. Transparency also uses
       DoubleBuffered and inherited by child controls.
       |<br>&nbsp;&nbsp;&nbsp;
       Please note, that some controls can not be shown properly, when
       Transparent is set to True for it. If You want to make edit control
       transparent (e.g., over gradient filled panel), handle its OnChanged
       property and call there Invalidate to provide repainting of edit
       control content. Note also, that for RichEdit control property
       Transparent has no effect (as well as DoubleBuffered). But special
       property RE_Transparent is designed especially for RichEdit control
       (it works fine, but with great number of flicks while resizing
       of a control). Another note is about Edit control. To allow editing
       of transparent edit box, it is necessary to invalidate it for
       every pressed character. Or, use Ed_Transparent property instead. }
    property Ed_Transparent: Boolean read fTransparent write EdSetTransparent;
    {* |<#edit>
       |<#memo>
       Use this property for editbox to make it really Transparent. Remember,
       that though Transparent property is inherited by child controls from
       its parent, this is not so for Ed_Transparent. So, it is necessary to
       set Ed_Transparent to True for every edit control explicitly. }
    property AlphaBlend: Byte read fAlphaBlend write SetAlphaBlend;
    {* |<#form>
       If assigned to 0..254, makes window (form or control) semi-transparent
       (Win2K only).
       |<br>
       Depending on value assigned, it is possible to adjust transparency
       level ( 0 - totally transparent, 255 - totally opaque).  }
    function MouseTransparent: PControl;
    {* Call this method to set up mouse transparent control (which always
       returns HTTRANSPARENT in responce to WM_NCHITTEST). This function
       returns a pointer to a control itself. }

    property LookTabKeys: TTabKeys read fLookTabKeys write fLookTabKeys;
    {* Set of keys which can be used as tabulation keys in a control. }
    procedure GotoControl( Key: DWORD );
    {* |<#form>
       Emulates tabulation key press w/o sending message to current control.
       Can be applied to a form or to any its control. If VK_TAB is used,
       state of shift kay is checked in: if it is pressed, tabulate is in
       backward direction. }
    property SubClassName: KOLString read get_ClassName write set_ClassName;
    {* Name of window class - unique for every window class
       in every run session of a program. }

  protected
    procedure SetOnClose( const AOnClose: TOnEventAccept );
    procedure SetFormOnClick( const AOnClick: TOnEvent );
  public
    property OnClose: TOnEventAccept read fOnClose write SetOnClose;
    {* |<#form>
       |<#applet>
       Called before closing the window. It is possible to set Accept
       parameter to False to prevent closing the window. This event events
       is not called when windows session is finishing (to handle this
       event, handle WM_QUERYENDSESSION message, or assign OnQueryEndSession
       event to another or the same event handler). }

    property OnQueryEndSession: TOnEventAccept read fOnQueryEndSession write SetOnQueryEndSession;
    {* |<#form>
       |<#applet>
       Called when WM_QUERYENDSESSION message come in. It is possible to set Accept
       parameter to False to prevent closing the window (in such case session ending
       is halted). It is possible to check CloseQueryReason property to find out,
       why event occur.
       |<br>
       To provide normal application close while handling OnQueryEndSession,
       call in your code PostQuitMessage( 0 ) or call method Close for the main form,
       this is enough to provide all OnClose and OnDestroy handlers to be called. }
    property CloseQueryReason: TCloseQueryReason read fCloseQueryReason;
    {* Reason why OnClose or OnQueryEndSession called. }
    property OnMinimize: TOnEvent index 0
             {$IFDEF F_P}   read GetOnMinMaxRestore
             {$ELSE DELPHI} read fOnMinimize
             {$ENDIF F_P/DELPHI} write SetOnMinMaxRestore;
    {* |<#form>
       Called when window is minimized. }
    property OnMaximize: TOnEvent index 8
             {$IFDEF F_P}   read GetOnMinMaxRestore
             {$ELSE DELPHI} read fOnMaximize
             {$ENDIF F_P/DELPHI} write SetOnMinMaxRestore;
    {* |<#form>
       Called when window is maximized. }
    property OnRestore: TOnEvent index 16
             {$IFDEF F_P}   read GetOnMinMaxRestore
             {$ELSE DELPHI} read fOnRestore
             {$ENDIF F_P/DELPHI} write SetOnMinMaxRestore;
    {* |<#form>
       Called when window is restored from minimized or maximized state. }

    property UpdateRgn: HRgn read fUpdRgn;
    {* A handle of update region. Valid only in OnPaint method. You
       can use it to improve painting (for speed), if necessary. When
       UpdateRgn is obtained in response to WM_PAINT message, value
       of the property EraseBackground is used to pass it to the API
       function GetUpdateRgn. If UpdateRgn = 0, this means that entire
       window should be repainted. Otherwise, You (e.g.) can check
       if the rectangle is in clipping region using API function
       RectInRegion. }

    property EraseBackground: Boolean read fEraseUpdRgn write fEraseUpdRgn;
    {* This value is used to pass it to the API function GetUpdateRgn,
       when UpadateRgn property is obtained first in responce to WM_PAINT
       message. If EraseBackground is set to True, system is responsible
       for erasing background of update region before painting. If not
       (default), the entire region invalidated should be painted by your
       event handler. }
    {$ENDIF GDI}
    property OnPaint: TOnPaint read fOnPaint write SetOnPaint;
    {* Event to set to override standard control painting. Can be applied
       to any control (though originally was designed only for paintbox
       control). When an event handler is called, it is possible to use
       UpdateRgn to examine what parts of window require painting to
       improve performance of the painting operation. }
    {$IFDEF GDI}
    property OnPrePaint: TOnPaint read fOnPrePaint write fOnPrePaint;
    {* Only for graphic controls. If you assign it, call Invalidate also. }
    property OnPostPaint: TOnPaint read fOnPostPaint write fOnPostPaint;
    {* Only for graphic controls. If you assign it, call Invalidate also. }

    property OnEraseBkgnd: TOnPaint read fOnEraseBkgnd write SetOnEraseBkgnd;
    {* This event allows to override erasing window background in response
       to WM_ERASEBKGND message. This allows to add some decorations to
       standard controls without overriding its painting in total.
       Note: When erase background, remember, that property ClientRect can
       return not true client rectangle of the window - use GetClientRect
       API function instead. For example:
    !
    !var BkBmp: HBitmap;
    !
    !procedure TForm1.KOLForm1FormCreate(Sender: PObj);
    !begin
    !  Toolbar1.OnEraseBkgnd := DecorateToolbar;
    !  BkBmp := LoadBitmap( hInstance, 'BK1' );
    !end;
    !
    !procedure TForm1.DecorateToolbar(Sender: PControl; DC: HDC);
    !var CR: TRect;
    !begin
    !  GetClientRect( Sender.Handle, CR );
    !  Sender.Canvas.Brush.BrushBitmap := BkBmp;
    !  Sender.Canvas.FillRect( CR );
    !end;
    !
     }

    {$ENDIF GDI}
    property OnClick: TOnEvent read fOnClick write
      {$IFDEF GDI} fOnClick
      {$ELSE  _X_} SetOnClick {$ENDIF _X_};
    {* |<#button>
       |<#checkbox>
       |<#radiobox>
       |<#toolbar>
       Called on click at control. For buttons, checkboxes and radioboxes
       is called regadless if control clicked by mouse or keyboard. For toolbar,
       the same event is used for all toolbar buttons and toolbar itself.
       To determine which toolbar button is clicked, check CurIndex property.
       And note, that all the buttons including separator buttons are enumerated
       starting from 0. Though images are stored (and prepared) only for
       non-separator buttons. And to determine, if toolbar button was clicked
       with right mouse button, check RightClick property.
       |<br>
       This event does not work on a Form, still it is fired in responce to
       WM_COMMAND window message mainly rather direct to mouse down. But, if
       you want to have OnClick event to be fired on a Form, use (following)
       property OnFormClick to assign it. }
    {$IFDEF GDI}
    property OnFormClick: TOnEvent read fOnClick write SetFormOnClick;
    {* |<#form>
       Assign you OnClick event handler using this property, if you want it to
       be fired in result of mouse click on a form surface. Use to assign the
       event only for forms (to avoid doublicated firing the handler).
       |<br>
       Note: for a form, in case of WM_xDOUBLECLK event, this event is fired
       for both clicks. So if you install both OnFormClick and OnMouseDblClk,
       handlers will be called in the following sequence for each double click:
       OnFormClick; OnMouseDblClk; OnFormClick. }
    property RightClick: Boolean read fRightClick;
    {* |<#toolbar>
       |<#listview>
       Use this property to determine which mouse button was clicked
       (applicable to toolbar in the OnClick event handler). }
    property OnEnter: TOnEvent read fOnEnter write fOnEnter;
    {* Called when control receives focus. }
    property OnLeave: TOnEvent read fOnLeave write fOnLeave;
    {* Called when control looses focus. }
    property OnChange: TOnEvent read fOnChange write fOnChange;
    {* |<#edit>
       |<#memo>
       |<#listbox>
       |<#combo>
       |<#tabcontrol>
       Called when edit control is changed, or selection in listbox or
       current index in combobox is changed (but if OnSelChanged assigned,
       the last is called for change selection). To respond to check/uncheck
       checkbox or radiobox events, use OnClick instead. }
    property OnSelChange: TOnEvent read fOnSelChange write fOnSelChange;
    {* |<#richedit>
       |<#listbox>
       |<#combo>
       |<#treeview>
       Called for rich edit control, listbox, combobox or treeview when current selection
       (range, or current item) is changed. If not assigned, but OnChange is
       assigned, OnChange is called instead. }
    property OnResize: TOnEvent read FOnResize write SetOnResize;
    {* Called whenever control receives message WM_SIZE (thus is, if
       control is resized. }
    property OnMove: TOnEvent read FOnMove write SetOnMove;
    {* Called whenever control receives message WM_MOVE (i.e. when control is
       moved over its parent). }
    property OnMoving: TOnEventMoving read FOnMoving write SetOnMoving;
    {* Called whenever control receives message WM_MOVE (i.e. when control is
       moved over its parent). }

    property MinSizePrev: Integer read fSplitMinSize1 write fSplitMinSize1;
    {* |<#splitter>
       Minimal allowed (while dragging splitter) size of previous control
       for splitter (see NewSplitter). }
    property SplitMinSize1: Integer read fSplitMinSize1 write fSplitMinSize1;
    {* The same as MinSizePrev. }
    property MinSizeNext: Integer read fSplitMinSize2 write fSplitMinSize2;
    {* |<#splitter>
       Minimal allowed (while dragging splitter) size of the rest of parent
       of splitter or of SecondControl (see NewSplitter). }
    property SplitMinSize2: Integer read fSplitMinSize2 write fSplitMinSize2;
    {* The same as MinSizeNext. }
    property SecondControl: PControl read fSecondControl write fSecondControl;
    {* |<#splitter>
       Second control to check (while dragging splitter) if its size not less
       than SplitMinSize2 (see NewSplitter). By default, second control is
       not necessary, and needed only in rare case when SecondControl can not
       be determined automatically to restrict splitter right (bottom) position. }
    property OnSplit: TOnSplit read fOnSplit write fOnSplit;
    {* |<#splitter>
       Called when splitter control is dragging - to allow for
       your event handler to decide if to accept new size of
       left (top) control, and new size of the rest area of parent. }
    property Dragging: Boolean read FDragging;
    {* |<#splitter>
       True, if splitter control is dragging now by user with left
       mouse button. Also, this property can be used to detect if the control
       is dragging with mouse (after calling DragStartEx method). }
    procedure DragStart;
    {* Call this method for a form or control to drag it with left mouse button,
       when mouse left button is already down. Dragging is stopped when left mouse
       button is released. See also DragStartEx, DragStopEx. }
    procedure DragStartEx;
    {* Call this method to start dragging the form by mouse. To stop
       dragging, call DragStopEx method. (Tip: to detect mouse up event,
       use OnMouseUp event of the dragging control). This method can be used
       to move any control with the mouse, not only entire form. State of
       mouse button is not significant. Determine dragging state of the control
       checking its Dragging property. }
    procedure DragStopEx;
    {* Call this method to stop dragging the form (started by DragStopEx). }
    procedure DragItem( OnDrag: TOnDrag );
    {* Starts dragging something with mouse. During the process,
       callback function OnDrag is called, which allows to control
       drop target, change cursor shape, etc. }

    property OnKeyDown: TOnKey read fOnKeyDown write SetOnKeyDown;
    {* Obvious. }
    property OnKeyUp: TOnKey read fOnKeyUp write SetOnKeyUp;
    {* Obvious. }
    property OnChar: TOnChar read fOnChar write SetOnChar;
    {* Deprecated event, use OnKeyChar. }
    property OnKeyChar: TOnChar read fOnChar write SetOnChar;
    {* Obviuos. }
    {$IFDEF SUPPORT_ONDEADCHAR}
    property OnKeyDeadChar: TOnChar read fOnDeadChar write SetOnDeadChar;
    {* Obviuos. }
    {$ENDIF SUPPORT_ONDEADCHAR}

    {$ENDIF GDI}
    property OnMouseUp: TOnMouse read fOnMouseUp write SetOnMouseUp;
    {* Obvious. }
    property OnMouseDown: TOnMouse read fOnMouseDown write SetOnMouseDown;
    {* Obvious. }
    property OnMouseMove: TOnMouse read fOnMouseMove write SetOnMouseMove;
    {* Obvious. }
    property OnMouseDblClk: TOnMouse read fOnMouseDblClk write SetOnMouseDblClk;
    {* Obvious. }
    property ThreeButtonPress: Boolean read f3ButtonPress;
    {* TRUE, if 3 button press detected. Check this flag in OnMouseDblClk event
       handler. If 3rd button click is done for a short period of time after the
       double click, the control receives OnMouseDblClk the second time and this
       flag is set. (Applicable to the GDK and other Linux systems). }
    property OnMouseWheel: TOnMouse read fOnMouseWheel write SetOnMouseWheel;
    {* Mouse wheel (up or down) event. In Windows, only focused controls and
       controls having scrollbars (or a scrollbar iteself) receive such
       message. To get direction and amount of wheel, use typecast:
       SmallInt( HiWord( Mouse.Shift ) ). Value 120 corresponds to one wheel
       step (-120 - for step back). }
    {$IFDEF GDI}

    property OnMouseEnter: TOnEvent read fOnMouseEnter write SetOnMouseEnter;
    {* Is called when mouse is entered into control. See also OnMouseLeave. }
    property OnMouseLeave: TOnEvent read fOnMouseLeave write SetOnMouseLeave;
    {* Is called when mouse is leaved control. If this event is assigned,
       then mouse is captured on mouse enter event to handle all other
       mouse events until mouse cursor leaves the control. }
    property OnTestMouseOver: TOnTestMouseOver read fOnTestMouseOver write SetOnTestMouseOver;
    {* |<#bitbtn>
       Special event, which allows to extend OnMouseEnter / OnMouseLeave
       (and also Flat property for BitBtn control). If a handler is assigned
       to this event, actual testing whether mouse is in control or not,
       is occuring in the handler. So, it is possible to simulate more
       careful hot tracking for controls with non-rectangular shape (such
       as glyphed BitBtn control). }

    property MouseInControl: Boolean read fMouseInControl;
    {* |<#bitbtn>
       This property can return True only if OnMouseEnter / OnMouseLeave
       event handlers are set for a control (or, for BitBtn, property Flat
       is set to True. Otherwise, False is returned always. }

    property Flat: Boolean read fFlat write SetFlat;
    {* |<#bitbtn>
       Set it to True for BitBtn, to provide either flat border for a button
       or availability of "highlighting" (correspondent to glyph index 4).
       |<br>
       Note: this can work incorrectly a bit under win95 without comctl32.dll
       updated. Therefore, application will launch. To enforce correct working
       even under Win95, use your own timer, which event handler checks for
       mouse over bitbtn control, e.g.:
       !    procedure TForm1.Timer1Timer(Sender: PObj);
       !    var P: TPoint;
       !    begin
       !      if not BitBtn1.MouseInControl then Exit;
       !      GetCursorPos( P );
       !      P := BitBtn1.Screen2Client( P );
       !      if not PtInRect( BitBtn1.ClientRect, P ) then
       !      begin
       !        BitBtn1.Flat := FALSE;
       !        BitBtn1.Flat := TRUE;
       !      end;
       !    end;
    }
    property RepeatInterval: Integer read fRepeatInterval write fRepeatInterval;
    {* |<#bitbtn>
       If this property is set to non-zero, it is interpreted (for BitBtn
       only) as an interval in milliseconds between repeat button down events,
       which are generated after first mouse or button click and until
       button is released. Though, if the button is pressed with keyboard (with
       space key), RepeatInterval value is ignored and frequency of repeatitive
       clicking is determined by user keyboard settings only. }
    function LikeSpeedButton: PControl;
    {* |<#button>
       |<#bitbtn>
       Transparent method (returns control itself). Makes button not focusable. }

    function Add( const S: KOLString ): Integer;
    {* |<#listbox>
       |<#combo>
       Only for listbox and combobox. }

    function Insert( Idx: Integer; const S: KOLString ): Integer;
    {* |<#listbox>
       |<#combo>
       Only for listbox and combobox. }
    procedure Delete( Idx: Integer );
    {* |<#listbox>
       |<#combo>
       Only for listbox and combobox. }
    procedure Clear;
    {* Clears object content. Has different sense for different controls.
       E.g., for label, editbox, button and other simple controls it
       assigns empty string to Caption property. For listbox, combobox,
       listview it deletes all items. For toolbar, it deletes all buttons.
       Et so on. }

    property Progress: Integer index ((PBM_SETPOS or $8000) shl 16) or PBM_GETPOS
                               read GetIntVal write SetIntVal;
    {* |<#progressbar>
       Only for ProgressBar. }
    property MaxProgress: Integer index ((PBM_SETRANGE32 or $8000) shl 16) or PBM_GETRANGE
                               read GetIntVal write SetMaxProgress;
    {* |<#progressbar>
       Only for ProgressBar. 100 is the default value. }
    property ProgressColor: TColor read fTextColor write SetProgressColor;
    {* |<#progressbar>
       Only for ProgressBar. }
    property ProgressBkColor: TColor read fColor write SetCtlColor; //SetProgressBkColor;
    {* |<#progressbar>
       Obsolete. Now the same as Color. }

    property StatusText[ Idx: Integer ]: PKOLChar read GetStatusText write SetStatusText;
    {* |<#form>
       Only for forms to set/retrieve status text to/from given status panel.
       Panels are enumerated from 0 to 254, 255 is to indicate simple
       status bar. Size grip in right bottom corner of status window is
       displayed only if form still CanResize.
       |<br>
       When a status text is set first time, status bar window is created
       (always aligned to bottom), and form is resizing to preset client height.
       While status bar is showing, client height value is returned without
       height of status bar. To remove status bar, call RemoveStatus method for
       a form.
       |<br>
       By default, text is left-aligned within the specified part of a status
       window. You can embed tab characters (#9) in the text to center or
       right-align it. Text to the right of a single tab character is centered,
       and text to the right of a second tab character is right-aligned.
       |<br>
       If You use separate status bar onto several panels, these automatically
       align its widths to the same value (width divided to number of panels).
       To adjust status panel widths for every panel, use property StatusPanelRightX.
    }
    property SimpleStatusText: PKOLChar index 255 read GetStatusText write SetStatusText;
    {* |<#form>
       Only for forms to set/retrive status text to/from simple status bar.
       Size grip in right bottom corner of status window is displayed only
       if form CanResize.
       |<br>
       When status text set first time, (simple) status bar window is created
       (always aligned to bottom), and form is resizing to preset client height.
       While status bar is showing, client height value is returned without
       height of status bar. To remove status bar, call RemoveStatus method for
       a form.
       |<br>
       By default, text is left-aligned within the specified part of a status
       window. You can embed tab characters (#9) in the text to center or
       right-align it. Text to the right of a single tab character is centered,
       and text to the right of a second tab character is right-aligned.
    }
    property StatusCtl: PControl read fStatusCtl;
    {* Pointer to Status bar control. To "create" child controls on
       the status bar, first create it as a child of form, for instance, and
       then change its property Parent, e.g.:
       ! var Progress1: PControl;
       ! ...
       ! Progress1 := NewProgressBar( Form1 );
       ! Progress1.Parent := Form1.StatusCtl;
       (If you use MCK, code should be another a bit, and in this case it is
       possible to create and adjust the control at design-time, and at run-time
       change its parent control. E.g. (Progress1 is created at run-time here too):
       ! Progress1 := NewProgressBar( Form );
       ! Progress1.Parent := Form.StatusCtl;
       ).
       Do not forget to provide StatusCtl to be existing first (e.g. assign
       one-space string to SimpleStatusText property of the form, for MCK do
       so using Object Inspector).
       }
    property SizeGrip: Boolean read fSizeGrip write fSizeGrip;
    {* Size grip for status bar. Has effect only before creating window. }

    procedure RemoveStatus;
    {* |<#form>
       Call it to remove status bar from a form (created in result of assigning
       value(s) to StatusText[], SimpleStatusText properties). When status bar is
       removed, form is resized to preset client height. }
    function StatusPanelCount: Integer;
    {* |<#form>
       Returns number of status panels defined in status bar. }
    property StatusPanelRightX[ Idx: Integer ]: Integer read GetStatusPanelX write SetStatusPanelX;
    {* |<#form>
       Use this property to adjust status panel right edges (if the status bar is
       divided onto several subpanels). If the right edge for the last panel is
       set to -1 (by default) it is expanded to the right edge of a form window.
       Otherwise, status bar can be shorter then form width. }
    property StatusWindow: HWND read fStatusWnd;
    {* |<#form>
       Provided for case if You want to use API direct message sending to
       status bar. }

    property Color1: TColor read fColor1 write SetColor1;
    {* |<#gradient>
       Top line color for GradientPanel. }
    property Color2: TColor read fColor2 write SetColor2;
    {* |<#gradient>
       |<#3Dlabel>
       Bottom line color for GradientPanel, or shadow color for LabelEffect.
       (If clNone, shadow color for LabelEffect is calculated as a mix bitween
       TextColor and clBlack). }
    property GradientStyle: TGradientStyle read FGradientStyle write SetGradientStyle;
    {* |<#gradient>
       Styles other then gsVertical and gsHorizontal has effect only for
       gradient panel, created by NewGradientPanelEx. }
    property GradientLayout: TGradientLayout read FGradientLayout write SetGradientLayout;
    {* |<#gradient>
       Has only effect for gradient panel, created by NewGradientPanelEx.
       Ignored for styles gsVertical and gsHorizontal. }

    //======== Image lists (for ListView, TreeView, ToolBar and TabControl):
    property ImageListSmall: PImageList index 16 read GetImgListIdx write SetImgListIdx;
    {* |<#listview>
       Image list with small icons used with List View control. If not set,
       last added (i.e. created with a control as an owner) image list with
       small icons is used. }
    property ImageListNormal: PImageList index 32 read GetImgListIdx write SetImgListIdx;
    {* |<#listview>
       |<#treeview>
       |<#tabcontrol>
       |<#bitbtn>
       Image list with normal size icons used with List View control (or with
       icons for BitBtn, TreeView or TabControl). If not set,
       last added (i.e. created with a control as an owner) image list is used.
       }
    property ImageListState: PImageList index 0 read GetImgListIdx write SetImgListIdx;
    {* |<#listview>
       |<#treeview>
       Image list used as a state images list for ListView or TreeView control. }

    //========
    function SetUnicode( Unicode: Boolean ): PControl;
    {* |<#listview>
       |<#treeview>
       |<#tabcontrol>
       Sets control as Unicode or not. The control itself is returned as for
       other "transparent" functions. A conditional define UNICODE_CTRLS must
       be added to a project to provide handling unicode messages. }

    //======== TabControl-specific properties and methods:
    property Pages[ Idx: Integer ]: PControl read GetPages;
    {* |<#tabcontrol>
       Returns controls, which can be used as parent for controls, placed on
       different pages of a tab control. Use it like in follows example:
       | Label1 := NewLabel( TabControl1.Pages[ 0 ], 'Label1' );
       To find number of pages available, check out Count property of the tab
       control. Pages are enumerated from 0 to Count - 1, as usual. }
    property TC_Pages[ Idx: Integer ]: PControl read GetPages;
    {* |<#tabcontrol>
       The same as above. }
    function TC_Insert( Idx: Integer; const TabText: KOLString; TabImgIdx: Integer ): PControl;
    {* |<#tabcontrol>
       Inserts new tab before given, returns correspondent page control
       (which can be used as a parent for controls to place on the page). }
    procedure TC_Delete( Idx: Integer );
    {* |<#tabcontrol>
       Removes tab from tab control, destroying all its child controls. }
{$IFNDEF OLD_ALIGN}
    procedure TC_InsertControl( Idx: Integer; const TabText: KOLString; TabImgIdx: Integer; Page: PControl);
    {* |<#tabcontrol>
       Inserts new tab before given, but not construt this Page
       (this control must be created before inserting, and may be not a Panel). }
    function TC_Remove( Idx: Integer ):PControl;
    {* |<#tabcontrol>
       Only removes tab from tab control, and return this Page as Result. }
{$ENDIF}
    property TC_Items[ Idx: Integer ]: KOLString read TCGetItemText write TCSetItemText;
    {* |<#tabcontrol>
       Text, displayed on tab control tabs. }
    property TC_Images[ Idx: Integer ]: Integer read TCGetItemImgIDx write TCSetItemImgIdx;
    {* |<#tabcontrol>
       Image index for a tab in tab control. }
    property TC_ItemRect[ Idx: Integer ]: TRect read TCGetItemRect;
    {* |<#tabcontrol>
       Item rectangle for a tab in tab control. }
    procedure TC_SetPadding( cx, cy: Integer );
    {* |<#tabcontrol>
       Sets space padding around tab text in a tab of tab control. }
    function TC_TabAtPos( x, y: Integer ): Integer;
    {* |<#tabcontrol>
       Returns index of tab, found at the given position (relative to
       a client rectangle of tab control). If no tabs found at the
       position, -1 is returned. }
    function TC_DisplayRect: TRect;
    {* |<#tabcontrol>
       Returns rectangle, occupied by a page rather then tab. }
    function TC_IndexOf(const S: KOLString): Integer;
    {* |<#tabcontrol>
       By Mr Brdo. Index of page by its Caption. }
    function TC_SearchFor(const S: KOLString; StartAfter: Integer; Partial: Boolean): Integer;
    {* |<#tabcontrol>
       By Mr Brdo. Index of page by its Caption. }

    //======== ListView style and options:
    property LVStyle: TListViewStyle read fLVStyle write SetLVStyle;
    {* |<#listview>
       ListView style of view. Can be changed at run time. }

    property LVOptions: TListViewOptions read fLVOptions write SetLVOptions;
    {* |<#listview>
       ListView options. Can be changed at run time. }

    property LVTextColor: TColor index LVM_GETTEXTCOLOR
             {$IFDEF F_P}   read LVGetColorByIdx
             {$ELSE DELPHI} read fTextColor
             {$ENDIF F_P/DELPHI} write LVSetColorByIdx;
    {* |<#listview>
       ListView text color. Use it instead of Font.Color. }
    property LVTextBkColor: TColor index LVM_GETTEXTBKCOLOR
             {$IFDEF F_P}   read LVGetColorByIdx
             {$ELSE DELPHI} read fLVTextBkColor
             {$ENDIF F_P/DELPHI} write LVSetColorByIdx;
    {* |<#listview>
       ListView background color for text. }
    property LVBkColor: TColor read fColor write SetCtlColor; //LVSetBkColor;
    {* |<#listview>
       ListView background color.  Use it instead of Color. }

    //======== List View columns handling:
    property LVColCount: Integer read fLVColCount;
    {* |<#listview>
       ListView (additional) column count. Value 0 means that there are
       no columns (single item text / icon is used). If You want
       to provide several columns, first call LVColAdd to "insert" column 0,
       i.e. to provide header text for first column (with index 0).
       If there are no column, nothing will be shown in lvsDetail /
       lvsDetailNoHeader view style. }
    procedure LVColAdd( const aText: KOLString; aalign: TTextAlign; aWidth: Integer );
    {* |<#listview>
       Adds new column. Pass 'width' <= 0 to provide default column width.
       'text' is a column header text. }
    procedure LVColInsert( ColIdx: Integer; const aText: KOLString; aAlign: TTextAlign; aWidth: Integer );
    {* |<#listview>
       Inserts new column at the Idx position (1-based column index). }
    procedure LVColDelete( ColIdx: Integer );
    {* |<#listview>
       Deletes column from List View }
    property LVColWidth[ Item: Integer ]: Integer index LVM_GETCOLUMNWIDTH
             read GetItemVal write SetItemVal;
    {* |<#listview>
       Retrieves or changes column width. For lvsList view style, the same width
       is returned for all columns (ColIdx is ignored). It is possible to use
       special values to assign to a property:
       |<br> LVSCW_AUTOSIZE - Automatically sizes the column
       |<br> LVSCW_AUTOSIZE_USEHEADER - Automatically sizes the column to fit
       the header text
       |<br>
       To set coumn width in lvsList view mode, column index must be -1
       (and Width to set must be in range 0..32767 always). }
    property LVColText[ Idx: Integer ]: KOLString read GetLVColText write SetLVColText;
    {* |<#listview>
       Allows to get/change column header text at run time. }
    property LVColAlign[ Idx: Integer ]: TTextAlign read GetLVColalign write SetLVColalign;
    {* |<#listview>
       Column text aligning. }
    property LVColImage[ Idx: Integer ]: Integer index LVCF_IMAGE or (24 shl 16) read GetLVColEx write SetLVColEx;
    {* |<#listview>
       Only starting from comctrl32.dll of version 4.70 (IE4+). Allows to
       set an image for list view column itself from the ImageListSmall.
    }
    property LVColOrder[ Idx: Integer ]: Integer index LVCF_ORDER or (28 shl 16) read GetLVColEx write SetLVColEx;
    {* |<#listview>
       Only starting from comctrl32.dll of version 4.70 (IE4+). Allows to
       set visual order of the list view column from the ImageListSmall.
       This value does not affect the index, by which the column is still
       accessible in the column array.
    }

    //======== List View items handling:
    property LVCount: Integer read GetItemsCount write SetItemsCount;
    {* |<#listview>
       Returns item count for ListView control. It is possible to use Count
       property instead when obtaining of item count is needed only. But this this
       property allows also to set actual count of list view items when a list
       view is virtual. }

    property LVCurItem: Integer read GetLVCurItem write SetLVCurItem;
    {* |<#listview>
       Returns first selected item index in a list view. See also LVNextSelected,
       LVNextItem and LVFocusItem functions. }

    property LVFocusItem: Integer read GetLVFocusItem;
    {* |<#listview>
       Returns focused item index in a list view. See also LVCurItem. }

    function LVNextItem( IdxPrev: Integer; Attrs: DWORD ): Integer;
    {* |<#listview>
       Returns an index of the next after IdxPrev item with given attributes in
       the list view. Attributes can be:
       LVNI_ALL - Searches for a subsequent item by index, the default value.
       |<br><br>
       Searchs by physical relationship to the index of the item where the
       search is to begin.
       LVNI_ABOVE - Searches for an item that is above the specified item.
       LVNI_BELOW - Searches for an item that is below the specified item.
       LVNI_TOLEFT - Searches for an item to the left of the specified item.
       LVNI_TORIGHT - Searches for an item to the right of the specified item.
       |<br><br>
       The state of the item to find can be specified with one or a combination
       of the following values:
       LVNI_CUT - The item has the LVIS_CUT state flag set.
       LVNI_DROPHILITED - The item has the LVIS_DROPHILITED state flag set
       LVNI_FOCUSED - The item has the LVIS_FOCUSED state flag set.
       LVNI_SELECTED - The item has the LVIS_SELECTED state flag set.}
    function LVNextSelected( IdxPrev: Integer ): Integer;
    {* |<#listview>
       Returns an index of next (after IdxPrev) selected item in a list view. }

    function LVAdd( const aText: KOLString; ImgIdx: Integer; State: TListViewItemState;
                     StateImgIdx, OverlayImgIdx: Integer; Data: DWORD ): Integer;
    {* |<#listview>
       Adds new line to the end of ListView control. Only content of item itself
       is set (aText, ImgIdx). To change other column text and attributes of
       item added, use appropriate properties / methods ().
       |<br>
       Returns an index of added item.
       |<br>
       There is no Unicode version defined, use LVItemAddW instead. }
    function LVItemAdd( const aText: KOLString ): Integer;
    {* |<#listview>
       Adds an item to the end of list view. Returns an index of the item added. }
    function LVInsert( Idx: Integer; const aText: KOLString; ImgIdx: Integer;
              State: TListViewItemState;  StateImgIdx, OverlayImgIdx: Integer; Data: DWORD ): Integer;
    {* |<#listview>
       Inserts new line before line with index Idx in ListView control. Only
       content of item itself is set (aText, ImgIdx). To change other column
       text and attributes of item added, use appropriate properties / methods ().
       if ImgIdx = I_IMAGECALLBACK, event handler OnGetLVItemImgIdx is responsible
       for returning image index for an item ( /// not implemented yet /// )
       Pass StateImgIdx and OverlayImgIdx = 0 (ignored in that case) or 1..15 to
       use correspondent icon from ImageListState image list.
       |<br> Returns an index of item inserted.
       |<br> There is no unicode version of this method, use LVItemInsertW. }
    function LVItemInsert( Idx: Integer; const aText: KOLString ): Integer;
    {* |<#listview>
       Inserts an item to Idx position. }

    procedure LVDelete( Idx: Integer );
    {* |<#listview>
       Deletes item of ListView with subitems (full row - in lvsDetail view style. }
    procedure LVSetItem( Idx, Col: Integer; const aText: KOLString; ImgIdx: Integer;
              State: TListViewItemState; StateImgIdx, OverlayImgIdx: Integer; Data: DWORD );
    {* |<#listview>
       Use this method to set item data and item columns data for ListView control.
       It is possible to pass I_SKIP as ImgIdx, StateImgIdx, OverlayImgIdx values to
       skip setting this fields. But all other are set always. Like in LVInsert /
       LVAdd, ImgIdx can be I_IMAGECALLBACK to determine that image will be
       retrieved in OnGetItemImgIdx event handler when needed.
       |<br>
       If this method is called to set data for column > 0, parameters ImgIdx and
       Data are ignored anyway.
       |<br> There is no unicode version of this method, use other methods
       to set up listed properties separately using correspondent W-functions. }

    property LVItemState[ Idx: Integer ]: TListViewItemState read LVGetItemState write LVSetItemState;
    {* |<#listview>
       Access to list view item states set [lvisBlend, lvisHighlight, lvisFocus,
       lvisSelect]. When assign new value to the property, it is possible to use
       special index value -1 to change state for all items for a list view
       (but only when lvoMultiselect style is applied to the list view, otherwise
       index -1 is referring to the last item of the list view). }

    property LVItemIndent[ Idx: Integer ]: Integer read LVGetItemIndent write LVSetItemIndent;
    {* Item indentation. Indentation is calculated as this value multiplied to
       image list ImgWidth value (Image list must be applied to list view).
       Note: indentation supported only if IE3.0 or higher installed. }
    property LVItemStateImgIdx[ Idx: Integer ]: Integer read LVGetSttImgIdx write LVSetSttImgIdx;
    {* |<#listview>
       Access to state image of the item. Use index -1 to assign the same state
       image index to all items of the list view at once (fast).
       Option lvoCheckBoxes just means, that control itself creates special inner
       image list for two state images. Later it is possible to examine checked
       state for items or set checked state programmatically by changing
       LVItemStateImgIdx[ ] property. Value 1 corresponds to unchecked state,
       2 to checked. Value 0 allows to remove checkbox at all. So, to check all
       added items by default (e.g.), do following:
       ! ListView1.LVItemStateImgIdx[ -1 ] := 2;
       |<br>Use 1-based index of the image
       in image list ImageListState. Value 0 reserved to use as "no state image".
       Values 1..15 can be used only - this is the Windows restriction on
       state images. }
    property LVItemOverlayImgIdx[ Idx: Integer ]: Integer read LVGetOvlImgIdx write LVSetOvlImgIdx;
    {* |<#listview>
       Access to overlay image of the item. Use index -1 to assign the same
       overlay image to all items of the list view at once (fast). }
    property LVItemData[ Idx: Integer ]: DWORD read LVGetItemData write LVSetItemData;
    {* |<#listview>
       Access to user defined data, assiciated with the item of the list view. }
    procedure LVSelectAll;
    {* |<#listview>
       Call this method to select all the items of the list view control. }
    property LVSelCount: Integer read GetSelLength; // write SetSelLength;
    {* |<#listview>
       Returns number of items selected in listview. }
    property LVItemImageIndex[ Idx: Integer ]: Integer read LVGetItemImgIdx write LVSetItemImgIdx;
    {* |<#listview>
       Image index of items in listview. When an item is created (using LVItemAdd
       or LVItemInsert), image index 0 is set by default (not -1 like in VCL!). }
    property LVItems[ Idx, Col: Integer ]: KOLString read LVGetItemText write LVSetItemText;
    {* |<#listview>
       Access to List View item text. }
    function LVItemRect( Idx: Integer; Part: TGetLVItemPart ): TRect;
    {* |<#listview>
       Returns rectangle occupied by given item part(s) in ListView window.
       Empty rectangle is returned, if the item is not viewing currently. }
    function LVSubItemRect( Idx, ColIdx: Integer ): TRect;
    {* |<#listview>
       Returns rectangle occupied by given item's subitem in ListView window,
       in lvsDetail or lvsDetailNoHeader style. Empty rectangle (0,0,0,0) is
       returned if the item is not viewing currently. Left or/and right bounds
       of the rectangle returned can be outbound item rectangle if only a part
       of the subitem is visible or the subitem is not visible in the item,
       which is visible itself. }
    property LVItemPos[ Idx: Integer ]: TPoint read LVGetItemPos write LVSetItemPos;
    {* |<#listview>
       Position of List View item (can be changed in icon or small icon view). }
    function LVItemAtPos( X, Y: Integer ): Integer;
    {* |<#listview>
       Return index of item at the given position. }
    function LVItemAtPosEx( X, Y: Integer; var Where: TWherePosLVItem ): Integer;
    {* |<#listview>
       Retrieves index of item and sets in Where, what part of item is under
       given coordinates. If there are no items at the specified position,
       -1 is returned. }
    procedure LVMakeVisible( Item: Integer; PartiallyOK: Boolean );
    {* |<#listview>
       Makes listview item visible. Ignred when Item passed < 0. }
    procedure LVEditItemLabel( Idx: Integer );
    {* |<#listview>
       Begins in-place editing of item label (first column text). }
    procedure LVSort;
    {* |<#listview>
       Initiates sorting of list view items. This sorting procedure is available only
       for Win2K, WinNT4 with IE5, Win98 or Win95 with IE5. See also LVSortData. }
    procedure LVSortData;
    {* |<#listview>
       Initiates sorting of list view items. This sorting procedure is always available
       in Windows95/98, NT/2000. But OnCompareLVItems procedure receives not indexes of
       items compared but its Data field associated instead. }
    procedure LVSortColumn( Idx: Integer );
    {* |<#listview>
       This is a method to simplify sort by column. Just call it in your OnColumnClick
       event passing column index and enjoy with your list view sorted automatically
       when column header is clicked. Requieres Windows2000 or Winows98, not supported
       under WinNT 4.0 and below and under Windows95.
       |<br>
       Either lvoSortAscending or lvoSortDescending option must be set in
       LVOptions, otherwise no sorting is performed. }
    function LVIndexOf( const S: KOLString ): Integer;
    {* Returns first list view item index with caption matching S.
       The same as LVSearchFor( S, -1, FALSE ). }
    function LVSearchFor( const S: KOLString; StartAfter: Integer; Partial: Boolean ): Integer;
    {* Searches an item with Caption equal to S (or starting from S, if Partial = TRUE).
       Searching is started after an item specified by StartAfter parameter. }

    //======== List view page:
    property LVTopItem: Integer index LVM_GETTOPINDEX read GetIntVal; //LVGetTopItem;
    {* |<#listview>
       Returns index of topmost visible item of ListView in lvsList view style. }
    property LVPerPage: Integer index LVM_GETCOUNTPERPAGE read GetIntVal; //LVGetPerPage;
    {* |<#listview>
       Returns the number of fully-visible items if successful. If the current
       view is icon or small icon view, the return value is the total number
       of items in the list view control. }

    //======== List View specific events:
    property OnEndEditLVItem: TOnEditLVItem read fOnEndEditLVITem write SetOnEndEditLVItem;
    {* |<#listview>
       Called when edit of an item label in ListView control finished. Return
       True to accept new label text, or false - to not accept it (item label
       will not be changed). If handler not set to an event, all changes are
       accepted. }

    property OnLVDelete: TOnDeleteLVItem read fOnDeleteLVItem write SetOnDeleteLVItem;
    {* |<#listview>
       This event is called when an item is deleted in the listview.
       Do not add, delete, or rearrange items in the list view while processing
       this notification. }
    property OnDeleteLVItem: TOnDeleteLVItem read fOnDeleteLVItem write SetOnDeleteLVItem;
    {* |<#listview>
       Called for every deleted list view item. }
    property OnDeleteAllLVItems: TOnEvent read fOnDeleteAllLVItems write SetOnDeleteAllLVItems;
    {* |<#listview>
       Called when all the items of the list view control are to be deleted. If after
       returning from this event handler event OnDeleteLVItem is yet assigned,
       an event OnDeleteLVItem will be called for every deleted item. }
    property OnLVData: TOnLVData read fOnLVData write SetOnLVData;
    {* |<#listview>
       Called to provide virtual list view with actual data. To use list view as
       virtaul list view, define also lvsOwnerData style and set Count property
       to actual row count of the list view. This manner of working with list view
       control can greatly improve performance of an application when working with
       huge data sets represented in listview control. }

    property OnCompareLVItems: TOnCompareLVItems read fOnCompareLVItems write fOnCompareLVItems;
    {* |<#listview>
       Event to compare two list view items during sort operation (initiated by
       LVSort method call). Do not send any messages to the list view control
       while it is sorting - results can be unpredictable! }
    property OnColumnClick: TOnLVColumnClick read fOnColumnClick write SetOnColumnClick;
    {* |<#listview>
       This event handler is called when column of the list view control is clicked.
       You can use this event to initiate sorting of list view items by this column. }
    property OnLVStateChange: TOnLVStateChange read FOnLVStateChange write SetOnLVStateChange;
    {* |<#listview>
       This event occure when an item or items range in list view control are
       changing its state (e.g. selected or unselected). }
    property OnDrawItem: TOnDrawItem read fOnDrawItem write SetOnDrawItem;
    {* |<#listview>
       |<#listbox>
       |<#combo>
       This event can be used to implement custom drawing for list view, list box, dropped
       list of a combobox. For a list view, custom drawing using this event is possible
       only in lvsDetail and lvsDetailNoHeader styles, and OnDrawItem is called to draw
       entire row at once only. See also OnLVCustomDraw event. }

    property OnLVCustomDraw: TOnLVCustomDraw read FOnLVCustomDraw write SetOnLVCustomDraw;
    {* |<#listview>
       Custom draw event for listview. For every item to be drawn, this event
       can be called several times during a single drawing cycle - depending on
       a result, returned by an event handler. Stage can have one of following
       values:
       |<pre>
       CDDS_PREERASE
       CDDS_POSTERASE
       CDDS_ITEMPREERASE
       CDDS_PREPAINT
       CDDS_ITEMPREPAINT
       CDDS_ITEM
       CDDS_SUBITEM + CDDS_ITEMPREPAINT
       CDDS_SUBITEM + CDDS_ITEMPOSTPAINT
       CDDS_ITEMPOSTPAINT
       CDDS_POSTPAINT
       </pre>
       When called, see on Stage to get know, on what stage the event is
       activated. And depend on the stage and on what you want to paint,
       return a value as a result, which instructs the system, if to use
       default drawing on this (and follows) stage(s) for the item, and if
       to notify further about different stages of drawing the item during
       this drawing cycle. Possible values to return are:
       |<pre>
       CDRF_DODEFAULT - perform default drawing. Do not notify further for this
                      item (subitem) (or for entire listview, if called with
                      flag CDDS_ITEM reset - ?);
       CDRF_NOTIFYITEMDRAW - return this value, when the event is called the
                      first time in a cycle of drawing, with ItemIdx = -1 and
                      flag CDDS_ITEM reset in Stage parameter;
       CDRF_NOTIFYPOSTERASE - usually can be used to provide default erasing,
                      if you want to perform drawing immediately after that;
       CDRF_NOTIFYPOSTPAINT - return this value to provide calling the event
                      after performing default drawing. Useful when you wish
                      redraw only a part of the (sub)item;
       CDRF_SKIPDEFAULT - return this value to inform the system that all
                      drawing is done and system should not peform any more
                      drawing for the (sub)item during this drawing cycle.
       CDRF_NEWFONT - informs the system, that font is changed and default
                      drawing should be performed with changed font;
       |</pre>
       If you want to get notifications for each subitem, do not use option
       lvoOwnerDrawFixed, because such style prevents system from notifying
       the application for each subitem to be drawn in the listview and only
       notifications will be sent about entire items.
       |<br>
       See also NM_CUSTOMDRAW in API Help.
    }

    procedure Set_LVItemHeight(Value: Integer);
    function SetLVItemHeight(Value: Integer): PControl;
    property LVItemHeight: Integer read fLVItemHeight write Set_LVItemHeight;
    {* |<#listview>
       |<#listbox>
       |#combo>
       It is possible to assign a value to LVItemHeight property only to
       control with "owner-draw" style (lvoOwnerDrawFixed for listview,
       loOwnerDrawFixed or loOwnerDrawVariable for listbox and
       coOwnerDrawFixed or coOwnerDrawVariable for combobox. At least, the
       control should have such option while creating it (after showing it
       the first time it is possible to change its options to avoid owner
       drawing later). }

    //======== TreeView specific properties and methods:
    function TVInsert( nParent, nAfter: THandle; const Txt: KOLString ): THandle;
    {* |<#treeview>
       Inserts item to a tree view. If nParent is 0 or TVI_ROOT, the item is
       inserted at the root of tree view. It is possible to pass following special
       values as nAfter parameter:
       |<pre>
       TVI_FIRST        Inserts the item at the beginning of the list.
       TVI_LAST	        Inserts the item at the end of the list.
       TVI_SORT	        Inserts the item into the list in alphabetical order.
       |</pre> }
    procedure TVDelete( Item: THandle );
    {* |<#treeview>
       Removes an item from the tree view. If value TVI_ROOT is passed, all items
       are removed. }

    property TVSelected: THandle index TVGN_CARET read TVGetItemIdx write TVSetItemIdx;
    {* |<#treeview>
       Returns or sets currently selected item handle in tree view. }

    property TVDropHilighted: THandle index TVGN_DROPHILITE read TVGetItemIdx write TVSetItemIdx;
    {* |<#treeview>
       Returns or sets item, which is currently highlighted as a drop target. }
    property TVDropHilited: THandle index TVGN_DROPHILITE read TVGetItemIdx write TVSetItemIdx;
    {* The same as TVDropHilighted. }
    property TVFirstVisible: THandle index TVGN_FIRSTVISIBLE read TVGetItemIdx write TVSetItemIdx;
    {* |<#treeview>
       Returns or sets given item to top of tree view. }

    property TVIndent: Integer index TVM_GETINDENT read GetIntVal write SetIntVal;
    {* |<#treeview>
       The amount, in pixels, that child items are indented relative to their
       parent items. }
    property TVVisibleCount: Integer index TVM_GETVISIBLECOUNT read GetIntVal;
    {* |<#treeview>
       Returns number of fully (not partially) visible items in tree view. }

    property TVRoot: THandle index TVGN_ROOT read TVGetItemIdx;
    {* |<#treeview>
       Returns handle of root item in tree view (or 0, if tree is empty). }
    property TVItemChild[ Item: THandle ]: THandle index TVGN_CHILD read TVGetItemNext;
    {* |<#treeview>
       Returns first child item for given one. }
    property TVItemHasChildren[ Item: THandle ]: Boolean read TV_GetItemHasChildren write TV_SetItemHasChildren;
    {* |<#treeview>
       TRUE, if an Item has children. Set this value to true if you want to
       force [+] sign appearing left from the node, even if there are no
       subnodes added to the node yet. }
    property TVItemChildCount[ Item: THandle ]: Integer read TV_GetItemChildCount;
    {* |<#treeview>
       Returns number of node child items in tree view.
    }
    property TVItemNext[ Item: THandle ]: THandle index TVGN_NEXT read TVGetItemNext;
    {* |<#treeview>
       Returns next sibling item handle for given one (or 0, if passed item is
       the last child for its parent node). }
    property TVItemPrevious[ Item: THandle ]: THandle index TVGN_PREVIOUS read TVGetItemNext;
    {* |<#treeview>
       Returns previous sibling item (or 0, if the is no such item). }
    property TVItemNextVisible[ Item: THandle ]: THandle index TVGN_NEXTVISIBLE read TVGetItemNext;
    {* |<#treeview>
       Returns next visible item (passed item must be visible too, to determine,
       if it is really visible, use property TVItemRect or TVItemVisible. }
    property TVItemPreviousVisible[ Item: THandle ]: THandle index TVGN_PREVIOUSVISIBLE read TVGetItemNext;
    {* |<#treeview>
       Returns previous visible item. }
    property TVItemParent[ Item: THandle ]: THandle index TVGN_PARENT read TVGetItemNext;
    {* |<#treeview>
       Returns parent item for given one (or 0 for root item). }

    property TVItemText[ Item: THandle ]: KOLString read TVGetItemText write TVSetItemText;
    {* |<#treeview>
       Text of tree view item. }
    function TVItemPath( Item: THandle; Delimiter: KOLChar ): KOLString;
    {* |<#treeview>
       Returns full path from the root item to given item. Path is calculated
       as a concatenation of all parent nodes text strings, separated by
       given delimiter character.
       |<br>Please note, that returned path has no trailing delimiter, this
       character is only separating different parts of the path.
       |<br>If Item is not specified ( =0 ), path is returned
       for Selected item. }

    property TVItemRect[ Item: THandle; TextOnly: Boolean ]: TRect read TVGetItemRect;
    {* |<#treeview>
       Returns rectangle, occupied by an item in tree view. }

    property TVItemVisible[ Item: THandle ]: Boolean read TVGetItemVisible write TVSetITemVisible;
    {* |<#treeview>
       Returs True, if item is visible in tree view. It is also possible to
       assign True to this property to ensure that a tree view item is visible
       (if False is assigned, this does nothing). }
    function TVItemAtPos( x, y: Integer; var Where: DWORD ): THandle;
    {* |<#treeview>
       Returns handle of item found at specified position (relative to upper left
       corener of client area of the tree view). If no item found, 0 is returned.
       Variable Where receives additional flags combination, describing more
       detailed, on which part of item or tree view given point is located,
       such as:
       |<pre>
       TVHT_ABOVE              Above the client area
       TVHT_BELOW              Below the client area
       TVHT_NOWHERE            In the client area, but below the last item
       TVHT_ONITEM	       On the bitmap or label associated with an item
       TVHT_ONITEMBUTTON       On the button associated with an item
       TVHT_ONITEMICON	       On the bitmap associated with an item
       TVHT_ONITEMINDENT       In the indentation associated with an item
       TVHT_ONITEMLABEL	       On the label (string) associated with an item
       TVHT_ONITEMRIGHT	       In the area to the right of an item
       TVHT_ONITEMSTATEICON    On the state icon for a tree-view item that is in a user-defined state
       TVHT_TOLEFT	       To the right of the client area
       TVHT_TORIGHT	       To the left of the client area
       |</pre> }

    property TVRightClickSelect: Boolean read fTVRightClickSelect write SetTVRightClickSelect;
    {* |<#treeview>
       Set this property to True to allow change selection to an item, clicked with right mouse button. }
    property TVEditing: Boolean read fEditing;
    {* |<#treeview>
       Returns True, if tree view control is editing its item label. }

    property TVItemBold[ Item: THandle ]: Boolean index TVIS_BOLD read TVGetItemStateFlg write TVSetItemStateFlg;
    {* |<#treeview>
       True, if item is bold. }
    property TVItemCut[ Item: THandle ]: Boolean index TVIS_CUT read TVGetITemStateFlg write TVSetItemStateFlg;
    {* |<#treeview>
       True, if item is selected as part of "cut and paste" operation. }
    property TVItemDropHighlighted[ Item: THandle ]: Boolean index TVIS_DROPHILITED read TVGetITemStateFlg write TVSetItemStateFlg;
    {* |<#treeview>
       True, if item is selected as drop target. }
    property TVItemDropHilited[ Item: THandle ]: Boolean index TVIS_DROPHILITED read TVGetITemStateFlg write TVSetItemStateFlg;
    {* The same as TVItemDropHighlighted. }
    property TVItemExpanded[ Item: THandle ]: Boolean index TVIS_EXPANDED read TVGetITemStateFlg; // write TVSetItemStateFlg;
    {* |<#treeview>
       True, if item's list of child items is currently expanded. To change
       expanded state, use method TVExpand. }
    property TVItemExpandedOnce[ Item: THandle ]: Boolean index TVIS_EXPANDEDONCE read TVGetITemStateFlg; // write TVSetItemStateFlg;
    {* |<#treeview>
       True, if item's list of child items has been expanded at least once. }
    property TVItemSelected[ Item: THandle ]: Boolean index TVIS_SELECTED read TVGetITemStateFlg write TVSetItemStateFlg;
    {* |<#treeview>
       True, if item is selected. }

    procedure TVExpand( Item: THandle; Flags: DWORD );
    {* |<#treeview>
       Call it to expand/collapse item's child nodes. Possible values for Flags
       parameter are:
       <pre>
       TVE_COLLAPSE         Collapses the list.
       TVE_COLLAPSERESET    Collapses the list and removes the child items. Note
                            that TVE_COLLAPSE must also be specified.
       TVE_EXPAND	    Expands the list.
       TVE_TOGGLE	    Collapses the list if it is currently expanded or
                            expands it if it is currently collapsed.
       </pre>
       }
    procedure TVSort( N: THandle );
    {* |<#treeview>
       By Alex Mokrov. Sorts treeview. If N = 0, entire treeview is sorted.
       Otherwise, children of the given node only.
    }

    property TVItemImage[ Item: THandle ]: Integer index TVIF_IMAGE read TVGetItemImage write TVSetItemImage;
    {* |<#treeview>
       Image index for an item of tree view. To tell that there are no image
       set, use index -2 (value -1 is reserved for callback image). }
    property TVItemSelImg[ Item: THandle ]: Integer index TVIF_SELECTEDIMAGE read TVGetItemImage write TVSetItemImage;
    {* |<#treeview>
       Image index for an item of tree view in selected state. Use value -2 to
       provide no image, -1 used for callback image. }
    property TVItemOverlay[ Item: THandle ]: Integer index TVIS_OVERLAYMASK or $80000
                             read TVGetItemImage write TVSetItemImage;
    {* |<#treeview>
       Overlay image index for an item in tree view.
       Values 1..15 can be used only - this is the Windows restriction on
       overlay images. }
    property TVItemStateImg[ Item: THandle ]: Integer index TVIS_STATEIMAGEMASK or $C0000
                              read TVGetItemImage write TVSetItemImage;
    {* |<#treeview>
       State image index for an item in tree view. Use 1-based index of the image
       in image list ImageListState. Value 0 reserved to use as "no state image".
    }

    property TVItemData[ Item: THandle ]: Pointer read TVGetItemData write TVSetItemData;
    {* |<#treeview>
       Stores any program-defined pointer with the item. }
    procedure TVEditItem( Item: THandle );
    {* |<#treeview>
       Begins editing given item label in tree view. }
    procedure TVStopEdit( Cancel: Boolean );
    {* |<#treeview>
       Ends editing item label, started by user or explicitly by TVEditItem method. }

    property OnTVBeginDrag: TOnTVBeginDrag read fOnTVBeginDrag write fOnTVBeginDrag;
    {* |<#treeview>
       Is called for tree view, when its item is to be dragging. }
    property OnTVBeginEdit: TOnTVBeginEdit read fOnTVBeginEdit write fOnTVBeginEdit;
    {* |<#treeview>
       Is called for tree view, when its item label is to be editing. }
    property OnTVEndEdit: TOnTVEndEdit read fOnTVEndEdit write fOnTVEndEdit;
    {* |<#treeview>
       Is called when item label is edited. It is possible to cancel
       edit, returning False as a result. }
    property OnTVExpanding: TOnTVExpanding read fOnTVExpanding write fOnTVExpanding;
    {* |<#treeview>
       Is called just before expanding/collapsing item. It is possible to
       return TRUE to prevent expanding item, otherwise FALSE should be returned. }
    property OnTVExpanded: TOnTVExpanded read fOnTVExpanded write fOnTVExpanded;
    {* |<#treeview>
       Is called after expanding/collapsing item children. }
    property OnTVDelete: TOnTVDelete read fOnTVDelete write SetOnTVDelete;
    {* |<#treeview>
       Is called just before deleting item. You may use this event to free
       resources, associated with an item (see TVItemData property). }
    //----------------- by Sergey Shisminzev:
    property OnTVSelChanging: TOnTVSelChanging read fOnTVSelChanging write fOnTVSelChanging;
    {* |<#treeview>
       Is called before changing the selection. The handler can return FALSE
       to prevent changing the selection. }
    //--------------------------------------

    //======== Toolbar specific methods:
    procedure TBAddBitmap( Bitmap: HBitmap );
    {* |<#toolbar>
       Adds bitmaps to a toolbar. You can pass special values as Bitmap to
       add one of predefined system button images bitmaps:
       |<br> THandle(-1) to add standard small icons,
       |<br> THandle(-2) to add standard large icons,
       |<br> THandle(-5) to add standard small view icons,
       |<br> THandle(-6) to add standard large view icons,
       |<br> THandle(-9) to add standard small history icons,
       |<br> THandle(-10) to add standard large history icons,
       (in that case use following values as indexes to the standard and view
       bitmaps:
       |<br>
       STD_COPY, STD_CUT, STD_DELETE, STD_FILENEW, STD_FILEOPEN, STD_FILESAVE,
       STD_FIND, STD_HELP, STD_PASTE, STD_PRINT, STD_PRINTPRE, STD_PROPERTIES,
       STD_REDO, STD_REPLACE, STD_UNDO,
       |<br>
       VIEW_LARGEICONS, VIEW_SMALLICONS,
       VIEW_LIST, VIEW_DETAILS, VIEW_SORTNAME, VIEW_SORTSIZE, VIEW_SORTDATE,
       VIEW_SORTTYPE (use it as parameters BtnImgIdxArray in TBAddButtons or
       TBInsertButtons methods, and in assigning value to TBButtonImage[ ]
       property).
       Added bitmaps have indeces starting from previous count of images
       (as these are appended to existing - if any).
       |<br>
       Note, that if You add your own (custom) bitmap, it is not transparent.
       Do not assume that clSilver is always equal to clBtnFace. Use API
       function CreateMappedBitmap to load bitmap from resource and map
       desired colors as you wish (e.g., convert clTeal to clBtnFace). Or,
       call defined in KOL function LoadMappedBitmap to do the same more easy.
       Unfortunately, resource identifier for bitmap to pass it to LoadMappedBitmap
       or to CreateMappedBitmap seems must be integer, so it is necessary to
       create rc-file manually and compile using Borland Resource Compiler to
       figure it out. }

    function TBAddButtons( const Buttons: array of PKOLChar; const BtnImgIdxArray: array
              of Integer ): Integer;
    {* |<#toolbar>
       Adds buttons to toolbar. Last string in Buttons array *must* be empty
       ('' or nil), so to add buttons without text, pass ' ' string (one space
       char). It is not necessary to provide image indexes for all
       buttons (it is sufficient to assign index for first button only).
       But in place, correspondent to separator button (defined by string '-'),
       any integer must be passed to assign follow image indexes correctly.
       See example.
       |*Toolbar adding buttons sample.
       Code below shows how to call TBAddButtons method to add two buttons with
       a separator between these buttons. idxNew and idxOld are integer
       expressions assigning image indexes to buttons 'New' and 'Old'. This
       indexes are zero-based and refer to bitmap images, added earlier (either
       in creating toolbar by call of NewToolbar or later in call of TBAddBitmap).
       !
       !     TBAddButtons( [ '&New', '-', '&Old', '' ], [ idxNew, 0, idxOld ] );
       !
       |*
       To add check buttons, use prefix '+' or '-' in button definition
       string. If next character is '!', such buttons are grouped to a
       radio-group. Also, it is possible to use '^' prefix (must be first) to
       define button with small drop-down section (use also OnTBDropDown event
       to respond to clicking drop down section of such buttons).
       |<br>
       This function returns command id for first added button (other
       id's can be calculated incrementing the result by one for each
       button, except separators, which have no command id).
       |<br>
       Note: for static toolbar (single in application and created
       once) ids are started from value 100. }

    function TBInsertButtons( BeforeIdx: Integer; Buttons: array of PKOLChar;
             BtnImgIdxArray: array of Integer ): Integer;
    {* |<#toolbar>
       Inserts buttons before button with given index on toolbar. Returns
       command identifier for first button inserted (other can be calculated
       incrementing returned value needed times. See also TBAddButtons. }

    procedure TBDeleteButton( BtnID: Integer );
    {* |<#toolbar>
       Deletes single button given by its command id. To delete separator,
       use TBDeleteBtnByIdx instead. }

    procedure TBDeleteBtnByIdx( Idx: Integer );
    {* |<#toolbar>
       Deletes single button given by its index in toolbar (not by command ID). }

    procedure TBClear;
    {* |<#toolbar>
       Deletes all buttons. Dufa }

    procedure TBAssignEvents( BtnID: Integer; Events: array of TOnToolbarButtonClick );
    {* |<#toolbar>
       Allows to assign separate OnClick events for every toolbar button.
       BtnID should be toolbar button ID or index of the first button to
       assign event. If it is an ID, events are assigned to buttons in
       creation order. Otherwise, events are assigned in placement order.
       Anyway, separator buttons are not skipped, so pass at least nil for such
       button as an event.
       |<br>
       Please note, that though not all buttons should exist before
       assigning events to it, therefore at least the first button
       (specified by BtnID) must be already added before calling TBAssignEvents. }

    procedure TBResetImgIdx( BtnID, BtnCount: Integer );
    {* |<#toolbar>
       Resets image index for BtnCount buttons starting from BtnID. }

    property CurItem: Integer read fCurItem;
    {* |<#toolbar>
       For toolbar, in OnClick event this property can be used to determine
       which button was clicked (100-based button id in toolbar). It is also
       possible to use CurIndex property (zero-based) for this purpose as
       well, but do not assume, that CurItem always equal to CurIndex+100.
       At least, it is possible to call TBItem2Index function to convert
       button ID to its index in toolbar.
    }

    property TBButtonCount: Integer read GetItemsCount; //TBGetButtonCount;
    {* |<#toolbar>
       Returns count of buttons on toolbar. The same as Count. }

    property TBBtnImgWidth: Integer read fTBBtnImgWidth write fTBBtnImgWidth;
    {* |<#toolbar>
       Custom toolbar buttons width. Set it before assigning buttons bitmap.
       Changing this property after assigning the bitmap has no effect. }

    function TBItem2Index( BtnID: Integer ): Integer;
    {* |<#toolbar>
       Converts button command id to button index for tool bar. }

    function TBIndex2Item( Idx: Integer ): Integer;
    {* |<#toolbar>
       Converts toolbar button index to its command ID. }

    procedure TBConvertIdxArray2ID( const IdxVars: array of PDWORD );
    {* |<#toolbar>
       Converts toolbar button indexes to its command IDs for an array
       of indexes (each item in the array passed is a pointer to
       Integer, containing button index when the procedure is callled,
       then all these indexes are relaced with a correspondent button ID).}

    property TBButtonEnabled[ BtnID: Integer ]: Boolean index TB_ENABLEBUTTON
             read TBGetBtnStt write TBSetBtnStt;
    {* |<#toolbar>
       Obvious. }

    property TBButtonVisible[ BtnID: Integer ]: Boolean read TBGetButtonVisible
                              write TBSetButtonVisible;
    {* |<#toolbar>
       Allows to hide/show some of toolbar buttons. }

    property TBButtonChecked[ BtnID: Integer ]: Boolean index TB_CHECKBUTTON
             read TBGetBtnStt write TBSetBtnStt;
    {* |<#toolbar>
       Allows to determine 'checked' state of a button (e.g., radio-button),
       and to check it programmatically. }

    property TBButtonMarked[ BtnID: Integer ]: Boolean index TB_MARKBUTTON
             read TBGetBtnStt write TBSetBtnStt;
    {* |<#toolbar>
       Returns True if toolbar button is marked (highlighted). Allows to
       highlight buttons assigning True to this value. }

    property TBButtonPressed[ BtnID: Integer ]: Boolean index TB_PRESSBUTTON
             read TBGetBtnStt write TBSetBtnStt;
    {* |<#toolbar>
       Allows to detrmine if toolbar button (given by its command ID) pressed,
       and press/unpress it programmatically. }

    property TBButtonText[ BtnID: Integer ]: KOLString read TBGetButtonText write TBSetButtonText;
    {* |<#toolbar>
       Obtains toolbar button text and allows to change it. Be sure that text
       is not empty for all buttons, if You want for it to be shown (if at least
       one button has empty text, no text labels will be shown at all). At
       least set it to ' ' for buttons, which You do not want to show labels,
       if You want from other ones to have it. }

    property TBButtonImage[ BtnID: Integer ]: Integer read TBGetBtnImgIdx write TBSetBtnImgIdx;
    {* |<#toolbar>
       Allows to access/change button image. Do not read this property for
       separator buttons, returning value is not proper. If you do not know,
       is the button a separator, using function below. }

    function TBButtonSeparator( BtnID: Integer ): Boolean;
    {* |<#toolbar>
       Returns TRUE, if a toolbar button is separator. }

    property TBButtonRect[ BtnID: Integer ]: TRect read TBGetButtonRect;
    {* |<#toolbar>
       Obtains rectangle occupied by toolbar button in toolbar window.
       (It is not possible to obtain rectangle for buttons, currently
       not visible). See also function ToolbarButtonRect. }

    property TBButtonWidth[ BtnID: Integer ]: Integer read TBGetBtnWidth write TBSetBtnWidth;
    {* |<#toolbar>
       Allows to obtain / change toolbar button width. }

    property TBButtonLParam[const Idx: Integer]: DWORD read TBGetButtonLParam write TBSetButtonLParam;
    {* |<#toolbar>
       Allows to access/change LParam. Dufa }

    property TBButtonsMinWidth: Integer index 0
             {$IFDEF F_P}   read TBGetBtMinMaxWidth
             {$ELSE DELPHI} read FTBBtMinWidth
             {$ENDIF F_P/DELPHI} write TBSetBtMinMaxWidth;
    {* |<#toolbar>
       Allows to set minimal width for all toolbar buttons. }
    property TBButtonsMaxWidth: Integer index 1
             {$IFDEF F_P}   read TBGetBtMinMaxWidth
             {$ELSE DELPHI} read FTBBtMaxWidth
             {$ENDIF F_P/DELPHI} write TBSetBtMinMaxWidth;
    {* |<#toolbar>
       Allows to set maximal width for all toolbar buttons. }

    function TBButtonAtPos( X, Y: Integer ): Integer;
    {* |<#toolbar>
       Returns command ID of button at the given position on toolbar,
       or -1, if there are no button at the position. Value 0 is returned
       for separators. }

    function TBBtnIdxAtPos( X, Y: Integer ): Integer;
    {* |<#toolbar>
       Returns index of button at the given position on toolbar.
       This also can be index of separator button. -1 is returned if
       there are no buttons found at the position. }

    function TBMoveBtn( FromIdx, ToIdx: Integer ): Boolean;
    {* |<#toolbar>
       By TR"]F. Moves button from one position to another. }

    property TBRows: Integer read TBGetRows write TBSetRows;
    {* |<#toolbar>
       Returns number of rows for toolbar and allows to try to set
       desired number of rows (but system can set another number of
       rows in some cases). This property has no effect if tboWrapable
       style not present in Options when toolbar is created. }

    procedure TBSetTooltips( BtnID1st: Integer; const Tooltips: array of PKOLChar );
    {* |<#toolbar>
       Allows to assign tooltips to several buttons. Until this procedure
       is not called, tooltips list is not created and no code is added
       to executable. This method of tooltips maintainance for toolbar buttons
       is useful both for static and dynamic toolbars (meaning "dynamic" -
       toolbars with buttons, deleted and inserted at run-time). }

    property OnTBDropDown: TOnEvent read fOnDropDown write fOnDropDown;
    {* |<#toolbar>
       This event is called for drop down buttons, when user click drop part
       of drop down button. To determine for which button event is called,
       look at CurItem or CurIndex property. It is also possible to use
       common (with combobox) property OnDropDown. }

    property OnTBClick: TOnEvent read fOnClick write fOnClick;
    {* |<#toolbar>
       The same as OnClick. }

    property OnTBCustomDraw: TOnTBCustomDraw read fOnTBCustomDraw write SetOnTBCustomDraw;
    {* |<#toolbar>
       An event (mainly) to customize toolbar background. }

    //================== RichEdit specific: ==================
    {$IFNDEF NOT_USE_RICHEDIT}
    property MaxTextSize: DWORD read GetMaxTextSize write SetMaxTextSize;
    {* |<#richedit>
       This property valid also for simple edit control, not only for RichEdit.
       But for usual edit control, maximum text size available is 32K. For
       RichEdit, limit is 4Gb. By default, RichEdit is limited to
       32767 bytes (to set maximum size available to 2Gb, assign MaxInt value
       to a property). Also, to get current text size of RichEdit, use property
       TextSize or RE_TextSize[ ]. }
    property TextSize: Integer read GetTextSize;
    {* |<#richedit>
       Common for edit and rich edit controls property, which returns size of
       text in edit control. Also, for any other control (or form, or applet
       window) returns size (in characters) of Caption or Text (what is, the
       same property actually). }
    property RE_TextSize[ Units: TRichTextSize ]: Integer read REGetTextSize;
    {* |<#richedit>
       For RichEdit control, it returns text size, measured in desired units
       (rtsChars - characters, including OLE objects, counted as a single
       character; rtsBytes - presize length of text image (if it would be stored
       in file or stream). Please note, that for RichEdit1.0, only size in
       characters can be obtained. }
    function RE_TextSizePrecise: Integer;
    {* |<#richedit>
       By Savva. Returns length of rich edit text. }

    property RE_CharFmtArea: TRichFmtArea read fRECharArea write fRECharArea;
    {* |<#richedit>
       By default, this property is raSelection. Changing it, You determine in
       for which area characters format is applyed, when changing
       character formatting properties below (not paragraph formatting).
       |&A=<a href=#RE_CharFmtArea target=main>%0</a>
    }
    property RE_CharFormat: TCharFormat read REGetCharformat write RESetCharFormat;
    {* |<#richedit>
       In differ to follow properties, which allow to control certain formatting
       attributes, this property provides low level access for formatting current
       character area (see RE_CharFmtArea). It returns TCharFormat structure,
       filled in with formatting attributes, and by assigning another value to
       this property You can change desired attributes as You wish. Even if
       RichEdit1.0 is used, TCharFormat2 is returned (but extended fields are
       ignored for RichEdit1.0). }
    property RE_Font: PGraphicTool read REGetFont write RESetFont;
    {* |<#richedit>
       Font of the first character in current selection (when retrieve).
       When set (or subproperties of RE_Font are set), all font attributes are
       applied to entire <A area>. To apply only needed attributes, use another
       properties: RE_FmtBold, RE_FmtItalic, RE_FmtStrikeout, RE_FmtUnderline,
       RE_FmtName, etc.
       |<br>
       Note, that font size is measured in twips, which is about 1/10 of pixel. }
    property RE_FmtBold: Boolean index CFM_BOLD read REGetFontEffects write RESetFontEffect;
    {* |<#richedit>
       Formatting flag. When retrieve, returns True, if fsBold style RE_Font.FontStyle
       is valid for a first character in the selection. When set, changes fsBold
       style (True - set, False - reset) for all characters in <A area>. }
    property RE_FmtBoldValid: Boolean index CFM_BOLD read REGetFontMask;
    {* }
    property RE_FmtItalic: Boolean index CFM_ITALIC read REGetFontEffects write RESetFontEffect;
    {* |<#richedit>
       Formatting flag. Like RE_FmtBold, when retrieving, shows, is fsItalic
       style valid for the first character of the selection, and when set, changes
       only fsItalic style for an <A area>. }
    property RE_FmtItalicValid: Boolean index CFM_ITALIC read REGetFontMask;
    {* }
    property RE_FmtStrikeout: Boolean index CFM_STRIKEOUT read REGetFontEffects write RESetFontEffect;
    {* |<#richedit>
       Formatting flag. Like RE_FmtBold, when retrieving, shows, is fsStrikeout
       style valid for the first selected character, and when set, changes only
       fsStrikeout style for an <A area>. }
    property RE_FmtStrikeoutValid: Boolean index CFM_STRIKEOUT read REGetFontMask;
    {* }
    property RE_FmtUnderline: Boolean index CFM_UNDERLINE read REGetFontEffects write RESetFontEffect;
    {* |<#richedit>
       Formatting flag. Like RE_FmtBold, when retrieving, shows, is fsUnderline
       style valid for the first selected character, and when set, changes
       fsUnderline style for an <A area>. }
    property RE_FmtUnderlineValid: Boolean index CFM_UNDERLINE read REGetFontMask;
    {* }
    property RE_FmtUnderlineStyle: TRichUnderline
             read REGetUnderlineEx write RESetUnderlineEx;
    {* |<#richedit>
       Extended underline style. To check, if this property is valid for
       entire selection, examine RE_FmtUnderlineValid value. }
    property RE_FmtProtected: Boolean index CFM_PROTECTED read REGetFontEffects write RESetFontEffect;
    {* |<#richedit>
       Formatting flag. When retrieving, shows, is the first character of the selection
       is protected from changing it by user (True) or not (False). To get know,
       if retrived value is valid for entire selection, check the property
       RE_FmtProtectedValid. When set, makes all characters in <A area> protected (
       True) or not (False). }
    property RE_FmtProtectedValid: Boolean index CFM_PROTECTED read REGetFontMask;
    {* |<#richedit>
       True, if property RE_FmtProtected is valid for entire selection, when
       retrieving it. }
    property RE_FmtHidden: Boolean index CFM_HIDDEN read REGetFontEffects write RESetFontEffect;
    {* |<#richedit>
       For RichEdit3.0, makes text hidden (not displayed). }
    property RE_FmtHiddenValid: Boolean index CFM_HIDDEN read REGetFontMask;
    {* |<#richedit>
       Returns True, if RE_FmtHidden style is valid for entire selection. }

    property RE_FmtLink: Boolean index $20 {CFM_LINK} read REGetFontEffects write RESetFontEffect;
    {* |<#richedit>
       Returns True, if the first selected character is a part of link (URL). }
       // by Sergey Shisminzev

    property RE_FmtLinkValid: Boolean index $20 {CFM_LINK} read REGetFontMask;
    {* }
    property RE_FmtFontSize: Integer index (12 shl 16) or CFM_SIZE read REGetFontAttr write RESetFontAttr;
    {* |<#richedit>
       Formatting value: font size, in twips (1/1440 of an inch, or 1/20 of a
       printer's point, or about 1/10 of pixel). When retrieving, returns
       RE_Font.FontHeight.
       When set, changes font size for entire <A area> (but does not change
       other font attributes). }
    property RE_FmtFontSizeValid: Boolean read REGetFontSizeValid;
    {* |<#richedit>
       Returns True, if property RE_FmtFontSize is valid for entire selection,
       when retrieving it. }
    property RE_FmtAutoBackColor: Boolean index CFM_BACKCOLOR read REGetFontEffects write RESetFontEffect;
    {* |<#richedit>
       True, when automatic back color is used. }
    property RE_FmtAutoBackColorValid: Boolean index CFM_BACKCOLOR read REGetFontMask;
    {* }
    property RE_FmtFontColor: Integer index (20 shl 16) or CFM_COLOR read REGetFontAttr write RESetFontAttr1;
    {* |<#richedit>
       Formatting value (font color). When retrieving, returns RE_Font.Color.
       When set, changes font color for entire <A area> (but does not change
       other font attributes). }
    property RE_FmtFontColorValid: Boolean index CFM_COLOR read REGetFontMask;
    {* |<#richedit>
       Returns True, if property RE_FmtFontColor valid for entire selection,
       when retrieving it. }
    property RE_FmtAutoColor: Boolean index CFM_COLOR read REGetFontEffects write RESetFontEffect;
    {* |<#richedit>
       True, when automatic text color is used (in such case, RE_FmtFontColor
       assignment is ignored for current area). }
    property RE_FmtAutoColorValid: Boolean index CFM_COLOR read REGetFontMask;
    {* }
    property RE_FmtBackColor: Integer index ((64
             {$IFDEF UNICODE_CTRLS} + 32 {$ENDIF}
              ) shl 16) or CFM_BACKCOLOR read REGetFontAttr write RESetFontAttr1;
    {* |<#richedit>
       Formatting value (back color). Only available for Rich Edit 2.0 and higher.
       When set, changes background color for entire <A area> (but does not change
       other font attributes). }
    property RE_FmtBackColorValid: Boolean index CFM_BACKCOLOR read REGetFontMask;
    {* }
    property RE_FmtFontOffset: Integer index (16 shl 16) or CFM_OFFSET read REGetFontAttr write RESetFontAttr;
    {* |<#richedit>
       Formatting value (font vertical offset from baseline, positive values
       correspond to subscript). When retrieving, returns offset for first
       character in the selection. When set, changes font offset for entire
       <A area>. To get know, is retrieved value valid for entire selction,
       check RE_FmtFontOffsetValid property. }
    property RE_FmtFontOffsetValid: Boolean index CFM_OFFSET read REGetFontMask;
    {* |<#richedit>
       Returns True, if property RE_FmtFontOffset is valid for entire selection,
       when retrieving it. }
    property RE_FmtFontCharset: Integer index (25 shl 16) or CFM_CHARSET read REGetFontAttr write RESetFontAttr;
    {* |<#richedit>
       Returns charset for first character in current selection, when retrieved
       (and to get know, if this value is valid for entire selection, check
       property RE_FmtFontCharsetValid). When set, changes charset for all
       characters in <A area>, but does not alter other formatting attributes. }
    property RE_FmtFontCharsetValid: Boolean index CFM_CHARSET read REGetFontMask;
    {* |<#richedit>
       Returns True, only if rerieved property RE_FmtFontCharset is valid for
       entire selection. }
    property RE_FmtFontName: KOLString read REGetFontName write RESetFontName;
    {* |<#richedit>
       Returns font face name for first character in the selection, when retrieved,
       and sets font name for entire <A area>, wnen assigned to (without
       changing of other formatting attributes). To get know, if retrived
       font name valid for entire selection, examine property RE_FmtFontNameValid. }
    property RE_FmtFontNameValid: Boolean index CFM_FACE read REGetFontMask;
    {* |<#richedit>
       Returns True, only if the font name is the same for entire selection,
       thus is, if rerieved property value RE_FmtFontName is valid for entire
       selection. }

    property RE_ParaFmt: TParaFormat read REGetParaFmt write RESetParaFmt;
    {* |<#richedit>
       Allows to retrieve or set paragraph formatting attributes for currently
       selected paragraph(s) in RichEdit control. See also following properties,
       which allow to do the same for certain paragraph format attributes
       separately. }
    property RE_TextAlign: TRichTextAlign read REGetTextAlign write RESetTextAlign;
    {* |<#richedit>
       Returns text alignment for current selection and allows to change it
       (without changing other formatting attributes). }
    property RE_TextAlignValid: Boolean index PFM_ALIGNMENT read REGetParaAttrValid;
    {* |<#richedit>
       Returns True, if property RE_TextAlign is valid for entire selection. If
       False, it is concerning only start of selection. }
    property RE_Numbering: Boolean read REGetNumbering write RESetNumbering;
    {* |<#richedit>
       Returns True, if selected text is numbered (or has style of list with
       bullets). To get / change numbering style, see properties
       RE_NumStyle and RE_NumBrackets. }
    property RE_NumStyle: TRichNumbering read REGetNumStyle write RESetNumStyle;
    {* |<#richedit>
       Advanced numbering style, such as rnArabic etc. If You use it, do not
       change RE_Numbering property simultaneously - this can cause changing
       style to rnBullets only. }
    property RE_NumStart: Integer read REGetNumStart write RESetNumStart;
    {* |<#richedit>
       Starting number for advanced numbering style. If this property is not
       set, numbering is starting by default from 0. For rnLRoman and rnURoman
       this cause, that first item has no number to be shown (ancient Roman
       people did not invent '0'). }
    property RE_NumBrackets: TRichNumBrackets read REGetNumBrackets write RESetNumBrackets;
    {* |<#richedit>
       Brackets style for advanced numbering. rnbPlain is default
       brackets style, and every time, when RE_NumStyle is changed,
       RE_NumBrackets is reset to rnbPlain. }
    property RE_NumTab: Integer read REGetNumTab write RESetNumTab;
    {* |<#richedit>
       Tab between start of number and start of paragraph text. If too small too
       view number, number is not displayed. (Default value seems to be sufficient
       though). }
    property RE_NumberingValid: Boolean index PFM_NUMBERING read REGetParaAttrValid;
    {* |<#richedit>
       Returns True, if RE_Numbering, RE_NumStyle, RE_NumBrackets, RE_NumTab,
       RE_NumStart properties are valid for entire selection. }
    property RE_Level: Integer read REGetLevel;
    {* |<#richedit>
       Outline level (for numbering paragraphs?). Read only. }
    property RE_SpaceBefore: Integer index 0 or PFM_SPACEBEFORE read REGetSpacing write RESetSpacing;
    {* |<#richedit>
       Spacing before paragraph. }
    property RE_SpaceBeforeValid: Boolean index PFM_SPACEBEFORE read REGetParaAttrValid;
    {* |<#richedit>
       True, if RE_SpaceBefore value is valid for all selected paragraph (if
       False, this value is valid only for first paragraph. }
    property RE_SpaceAfter: Integer index 4 or PFM_SPACEAFTER read REGetSpacing write RESetSpacing;
    {* |<#richedit>
       Spacing after paragraph. }
    property RE_SpaceAfterValid: Boolean index PFM_SPACEAFTER read REGetParaAttrValid;
    {* |<#richedit>
       True, only if RE_SpaceAfter value is valid for all selected paragraphs. }
    property RE_LineSpacing: Integer index 8 or PFM_LINESPACING read REGetSpacing write RESetSpacing;
    {* |<#richedit>
       Linespacing in paragraph (this value is based on RE_SpacingRule property). }
    property RE_SpacingRule: Integer read REGetSpacingRule write RESetSpacingRule;
    {* |<#richedit>
       Linespacing rule. Do not know what is it. }
    property RE_LineSpacingValid: Boolean index PFM_LINESPACING read REGetParaAttrValid;
    {* |<#richedit>
       True, only if RE_LineSpacing and RE_SpacingRule values are valid for
       entire selection. }
    property RE_Indent: Integer index (20 shl 16) or PFM_OFFSET read REGetParaAttr write RESetParaAttr;
    {* |<#richedit>
       Returns left indentation for paragraph in current selection and allows
       to change it (without changing other formatting attributes). }
    property RE_IndentValid: Boolean index PFM_OFFSET read REGetParaAttrValid;
    {* |<#richedit>
       Returns True, if RE_Indent property is valid for entire selection. }
    property RE_StartIndent: Integer index (12 shl 16) or PFM_STARTINDENT read REGetParaAttr write RESetParaAttr;
    {* |<#richedit>
       Returns left indentation for first line in paragraph for current
       selection, and allows to change it (without changing other formatting
       attributes). }
    property RE_StartIndentValid: Boolean read REGetStartIndentValid;
    {* |<#richedit>
       Returns True, if property RE_StartIndent is valid for entire selection. }
    property RE_RightIndent: Integer index (16 shl 16) or PFM_RIGHTINDENT read REGetParaAttr write RESetParaAttr;
    {* |<#richedit>
       Returns right indent for paragraph in current selection, and allow to
       change it (without changing other formatting attributes). }
    property RE_RightIndentValid: Boolean index PFM_RIGHTINDENT read REGetParaAttrValid;
    {* |<#richedit>
       Returns True, if property RE_RightIndent is valid for entire selection only. }
    property RE_TabCount: Integer read REGetTabCount write RESetTabCount;
    {* |<#richedit>
       Number of tab stops in current selection. This value can not be set greater
       then MAX_TAB_COUNT (32). }
    property RE_Tabs[ Idx: Integer ]: Integer read REGetTabs write RESetTabs;
    {* |<#richedit>
       Tab stops for RichEdit control. }
    property RE_TabsValid: Boolean index PFM_TABSTOPS read REGetParaAttrValid;
    {* |<#richedit>
       Returns True, if properties RE_Tabs[ ] and RE_TabCount are valid for
       entire selection. }

    // following does not work now :
    property RE_BorderWidth[ Side: TBorderEdge ]: Integer index 2 read REGetBorder write RESetBorder;
    { * |<#richedit>
       Border width. }
    property RE_BorderSpace[ Side: TBorderEdge ]: Integer index 0 read REGetBorder write RESetBorder;
    { * |<#richedit>
       Border space. }
    property RE_BorderStyle[ Side: TBorderEdge ]: Integer index 4 read REGetBorder write RESetBorder;
    { * |<#richedit>
       Border style. }
    property RE_BorderValid: Boolean index PFM_BORDER read REGetParaAttrValid;
    { * |<#richedit>
       Returns True, if border style, space and width are the same for all
       paragraphs in selection. }
    property RE_Table: Boolean index $C000 read REGetParaEffect write RESetParaEffect;
    { * |<#richedit>
       True, if current paragraph is a part of table (row, cell or cell end).
       seems working as read only property. }
    // end of experiment section

    function RE_FmtStandard: PControl;
    {* |<#richedit>
       "Transparent" method (returns @Self as a result), which (when called)
       provides "standard" keyboard interface for formatting Rich text (just
       call this method, for example:
       !    RichEd1 := NewRichEdit( Panel1, [ ] ).SetAlign( caClient ).RE_FmtStandard;
       Following keys will be maintained additionally:
       |<pre>
       CTRL+I - switch "Italic",
       CTRL+B - switch "Bold",
       CTRL+U - switch "Underline",
       CTRL+SHIFT+U - swith underline type
                    and turn underline on (note, that some of underline styles
                    can not be shown properly in RichEdit v2.0 and lower,
                    though RichEdit2.0 stores data successfully).
       CTRL+O - switch "StrikeOut",
       CTRL+'gray+' - increase font size,
       CTRL+'gray-' - decrease font size,
       CTRL+SHIFT+'gray+' - superscript,
       CTRL+SHIFT+'gray-' - subscript.
       CTRL+SHIFT+Z - ReDo
       |</pre>
       And, though following standard formatting keys are provided by RichEdit
       control itself in Windows2000, some of these are not functioning
       automatically in earlier Windows versions, even for RichEdit2.0. So,
       functionality of some of these (marked with (*) ) are added here too:
       |<pre>
       CTRL+L - align paragraph left,           (*)
       CTRL+R - align paragraph right,          (*)
       CTRL+E - align paragraph center,         (*)
       CTRL+A - select all,                     (*)
       double-click on word - select word,
       CTRL+Right - to next word,
       CTRL+Left - to previous word,
       CTRL+Home - to the beginning of text,
       CTRL+End - to the end of text.
       CTRL+Z - UnDo
       |</pre>
       If You originally assign some (plain) text to Text property, switching "underline"
       can also change other font attributes, e.g., "bold" - if fsBold style is
       in default Font. To prevent such behavior, select entire text first (see
       SelectAll) and make assignment to RE_Font property, e.g.:
       !        RichEd1.SelectAll;
       !        RichEd1.RE_Font := RichEd1.RE_Font;
       !        RichEd1.SelLength := 0;
       |<br>
       And, some other notices about formatting. Please remember, that only True
       Type fonts can be succefully scaled and transformed to get desired effects
       (e.g., bold). By default, RichEdit uses System font face name, which can
       even have problems with fsBold style. Please remember also, that assigning
       RE_Font to RE_Font just initializying formatting attributes, making all
       those valid in entire text, but does not change font attributes. To use
       True Type font, directly assign face name You wish, e.g.:
       !        RichEd1.SelectAll;
       !        RichEd1.RE_Font := RichEd1.RE_Font;
       !        RichEd1.RE_Font.FontName := 'Arial';
       !        RichEd1.SelLength := 0;
    }
    procedure RE_CancelFmtStandard;
    {* Cancels RE_FmtStandard (detaching window procedure handler). }
    property RE_AutoKeyboard: Boolean index 1 read REGetLangOptions write RESetLangOptions;
    {* |<#richedit>
       True if autokeyboard on (lovely "feature" of automatic switching keyboard
       language when caret is over another language text). For older RichEdit,
       is 'on' always, for newest - 'off' by default. }
    property RE_AutoFont: Boolean index 2 read REGetLangOptions write RESetLangOptions;
    {* |<#richedit>
       True if autofont on (automatic switching font when keyboard layout is
       changes). By default, is 'on' always. It is suggested to turn this option
       off for Unicode control. }
    property RE_AutoFontSizeAdjust: Boolean index 16 read REGetLangOptions write RESetLangOptions;
    {* |<#richedit>
       See IMF_AUTOFONTSIZEADJUST option in SDK:
       Font-bound font sizes are scaled from insertion point size according to
       script. For example, Asian fonts are slightly larger than Western ones.
       This option is turned on by default. }
    property RE_DualFont: Boolean index 128 read REGetLangOptions write RESetLangOptions;
    {* |<#richedit>
       See IMF_DUALFONT option in SDK:
       Sets the control to dual-font mode. Used for Asian language support.
       The control uses an English font for ASCII text and a Asian font for
       Asian text. }
    property RE_UIFonts: Boolean index 32 read REGetLangOptions write RESetLangOptions;
    {* |<#richedit>
       See IMF_UIFONTS option in SDK:
       Use user-interface default fonts. This option is turned off by default. }
    property RE_IMECancelComplete: Boolean index 4 read REGetLangOptions write RESetLangOptions;
    {* |<#richedit>
       See IMF_IMECANCELCOMPLETE option in SDK:
       This flag determines how the control uses the composition string of an
       IME if the user cancels it. If this flag is set, the control discards
       the composition string. If this flag is not set, the control uses the
       composition string as the result string. }
    property RE_IMEAlwaysSendNotify: Boolean index 8 read REGetLangOptions write RESetLangOptions;
    {* |<#richedit>
       See IMF_IMEALWAYSSENDNOTIFY option in SDK:
       Controls how Rich Edit notifies the client during IME composition:
       |<br>
       0: No EN_CHANGED or EN_SELCHANGE notifications during undetermined state.
          Send notification when final string comes in. (default)
       |<br>
       1: Send EN_CHANGED and EN_SELCHANGE events during undetermined state. }

    property RE_OverwriteMode: Boolean read REGetOverwite write RESetOverwrite;
    {* |<#richedit>
       This property allows to control insert/overwrite mode. First, to examine, if
       insert or overwrite mode is current (but it is necessary either to
       access this property, at least once, immediately after creating RichEdit
       control, or to assign event OnRE_InsOvrMode_Change to your handler).
       Second, to set desired mode programmatically - by assigning value to
       this property (You also have to initialize monitoring procedure by either
       reading RE_OverwriteMode property or assigning handler to event
       OnRE_InsOvrMode_Change immediately following RichEdit control creation). }
    property OnRE_InsOvrMode_Change: TOnEvent read fOnREInsModeChg write fOnREInsModeChg;
    {* |<#richedit>
       This event is called, whenever key INSERT is pressed in control (and for
       RichEdit, this means, that insert mode is changed). }
    property RE_DisableOverwriteChange: Boolean read fReOvrDisable write RESetOvrDisable;
    {* |<#richedit>
       It is possible to disable switching between "insert" and "overwrite" mode
       by user (therefore, event OnRE_InsOvrMode_Change continue works, but it
       just called when key INSERT is pressed, though RE_OverwriteMode property
       is not actually changed if switching is disabled). }

    function RE_LoadFromStream( Stream: PStream; Length: Integer;
                                Format: TRETextFormat; SelectionOnly: Boolean ): Boolean;
    {* |<#richedit>
       Use this method rather then assignment to RE_Text property, if
       source is stored in file or stream (to minimize resources during
       loading of RichEdit content). Data is loading starting from current
       position in stream and no more then Length bytes are loaded (use -1
       value to load to the end of stream). Loaded data replaces entire
       content of RichEdit control, or selection only, depending on SelectionOnly
       flag.
       |<br>&nbsp;&nbsp;&nbsp;
       If You want to provide progress (e.g. in form of progress bar), assign
       OnProgress event to your handler - and to examine current position of
       loading, read TSream.Position property of soiurce stream). }
    function RE_SaveToStream( Stream: PStream; Format: TRETextFormat; SelectionOnly: Boolean ): Boolean;
    {* |<#richedit>
       Use this method rather then RE_TextProperty to store data to file
       or stream (to minimize resources during saving of RichEdit content).
       Data is saving starting from current position in a stream (until
       end of RichEdit data). If SelectionOnly flag is True, only selected
       part of RichEdit text is saved.
       |<br>&nbsp;&nbsp;&nbsp;
       Like for RE_LoadFromStream, it is possible to assign your method to
       OnProgress event (but to calculate progress of save-to-stream operation,
       compare current stream position with RE_Size[ rsBytes ] property
       value). }

    property OnProgress: TOnEvent read fOnProgress write fOnProgress;
    {* |<#richedit>
       This event is called during RE_SaveToStream, RE_LoadFromStream (and also
       during RE_SaveToFile, RE_LoadFromFile and while accessing or changing
       RE_Text property). To calculate relative progress, it is possible to
       examine current position in stream/file with its total size while reading,
       or with rich edit text size, while writing (property RE_TextSize[ rsBytes ]).
    }
    function RE_LoadFromFile( const Filename: KOLString; Format: TRETextFormat;
             SelectionOnly: Boolean ): Boolean;
    {* |<#richedit>
       Use this method rather then other assignments to RE_Text property,
       if a source for RichEdit is the file. See also RE_LoadFromStream. }
    function RE_SaveToFile( const Filename: KOLString; Format: TRETextFormat;
             SelectionOnly: Boolean ): Boolean;
    {* |<#richedit>
       Use this method rather then other similar, if You want to store
       entire content of RichEdit or selection only of RichEdit to a file. }

    property RE_Text[ Format: TRETextFormat; SelectionOnly: Boolean ]: KOLString read REReadText write REWriteText;
    {* |<#richedit>
       This property allows to get / replace content of RichEdit control
       (entire text or selection only). Using different formats, it is
       possible to exclude or replace undesired formatting information
       (see TRETextFormat specification). To get or replace entire text
       in reText mode (plain text only), it is possible to use habitual
       for edit controls Text property.
       |<br>&nbsp;&nbsp;&nbsp;
       Note: it is possible to append text to the end of RichEdit control
       using method Add, but only if property RE_Text is accessed at least
       once:
       !               RichEdit1.RE_Text[ reText, True ];
       (This line can be written immediatelly after creating RichEdit control). }

    procedure RE_Append( const S: KOLString; ACanUndo: Boolean );
    {* }
    procedure RE_InsertRTF( const S: KOLString );
    {* }
    property RE_Error: Integer read fREError;
    {* |<#richedit>
       Contains error code, if access to RE_Text failed. }

    procedure RE_HideSelection( aHide: Boolean );
    {* |<#richedit>
       Allows to hide / show selection in RichEdit. }

    function RE_SearchText( const Value: KOLString; MatchCase, WholeWord, ScanForward: Boolean;
                            SearchFrom, SearchTo: Integer ): Integer;
    {* |<#richedit>
       Searches given string starting from SearchFrom position up to SearchTo
       position (to the end of text, if SearchTo is -1). Returns zero-based
       character position of the next match, or -1 if there are no more matches.
       To search in bacward direction, set ScanForward to False, and pass
       SearchFrom > SearchTo (or even SearchFrom = -1 and SearchTo = 0). }
    {$IFNDEF DISABLE_DEPRECATED}
    {$IFNDEF _FPC}
    {$IFNDEF _D2} //------- WideString not supported in D2
    function RE_WSearchText( const Value: WideString; MatchCase, WholeWord, ScanForward: Boolean;
                            SearchFrom, SearchTo: Integer ): Integer;
    {* |<#richedit>
       Searches given string starting from SearchFrom position up to SearchTo
       position (to the end of text, if SearchTo is -1). Returns zero-based
       character position of the next match, or -1 if there are no more matches.
       To search in bacward direction, set ScanForward to False, and pass
       SearchFrom > SearchTo (or even SearchFrom = -1 and SearchTo = 0). }
    {$ENDIF}
    {$ENDIF}
    {$ENDIF DISABLE_DEPRECATED}

    property RE_AutoURLDetect: Boolean read REGetAutoURLDetect write RESetAutoURLDetect;
    {* |<#richedit>
       If set to True, automatically detects URLs (and highlights it with
       blue color, applying fsItalic and fsUnderline font styles (while
       typing and loading). Default value is False. Note: if event OnRE_URLClick
       or event OnRE_OverURL are set, property RE_AutoURLDetect is set to True
       automatically. }

    property RE_URL: KOLString read fREUrl;
    {* |<#richedit>
       Detected URL (valid in OnRE_OverURL and OnRE_URLClick event handlers). }
    property OnRE_OverURL: TOnEvent index 0
             {$IFDEF F_P}   read REGetOnURL
             {$ELSE DELPHI} read fOnREOverURL
             {$ENDIF F_P/DELPHI} write RESetOnURL;
    {* |<#richedit>
       Is called when mouse is moving over URL. This can be used to set
       cursor, for example, depending on type of URL (to determine URL type
       read property RE_URL). }
    property OnRE_URLClick: TOnEvent index 8
             {$IFDEF F_P}   read REGetOnURL
             {$ELSE DELPHI} read fOnREURLClick
             {$ENDIF F_P/DELPHI} write RESetOnURL;
    {* |<#richedit>
       Is called when click on URL detected. }

    //property RE_SelectionBar: Boolean read REGetSelectionBar write RESetSelectionBar;
    //{* ??? - don't know that is this... }
    function RE_NoOLEDragDrop: PControl;
    {* |<#richedit>
       Just prevents drop OLE objects to the rich edit control. Seems not
       working for some cases. }

    //function RE_Wyswig: PControl;

    function RE_Bottomless: PControl;
    // finished ?

    property RE_Transparent: Boolean read REGetTransparent write RESetTransparent;
    {* |<#richedit>
       Use this property to make richedit control transparent, instead of
       Ed_Transparent or Transparent. But do not place such transparent
       richedit control directly on form - it can be draw incorrectly when
       form is activated and rich editr control is not current active control.
       Use at least panel as a parent instead.
       }
    property RE_Zoom: TSmallPoint read REGetZoom write RESetZoom;
    {* |<#richedit>
       To set zooming for rich edit control (3.0 and above), pass X as numerator
       and Y as denominator. Resulting X/Y must be between 1/64 and 64. }
    {$ENDIF NOT_USE_RICHEDIT}

    //========== both for Edit and RichEdit: =====================
    function CanUndo: Boolean;
    {* |<#richedit>
       |<#edit>
       |<#memo>
       Returns True, if the edit (or RichEdit) control can correctly process
       the EM_UNDO message. }
    procedure EmptyUndoBuffer;
    {* |<#richedit>
       |<#edit>
       |<#memo>
       Reset the undo flag of an edit control, preventing undoing all previous
       changes. }
    function Undo: Boolean;
    {* |<#richedit>
       |<#edit>
       |<#memo>
       For a single-line edit control, the return value is always TRUE. For a
       multiline edit control and RichEdit control, the return value is TRUE if
       the undo operation is successful, or FALSE if the undo operation fails. }

    {$IFNDEF NOT_USE_RICHEDIT}
    function RE_Redo: Boolean;
    {* |<#richedit>
       Only for RichEdit control: Returns True if successful. }
    {$ENDIF NOT_USE_RICHEDIT}

    //----------------------------------------------------------------------
    // DateTimePicker
    property OnDTPUserString: TDTParseInputEvent read FOnDTPUserString
             write FOnDTPUserString;
    {* Special event to parse input from the application. Option dtpoParseInput
       must be set when control is created. }
    property DateTime: TDateTime read GetDateTime write SetDateTime;
    {* DateTime for DateTimePicker control only. }
    property Date: TDateTime read GetDate write SetDate;
    {* Date only for DateTimePicker control only. }
    property Time: TDateTime read GetTime write SetTime;
    {* Time only for DateTimePicker control only. }
    property SystemTime: TSystemTime read Get_SystemTime write Set_SystemTime;
    {* Date and Time as TSystemTime. When assing, use year 0 to set "no value". }
    property DateTimeRange: TDateTimeRange read GetDateTimeRange
      write SetDateTimeRange;
    {* DateTimePicker range. If first date in the agrument assigned is NAN,
       minimum system allowed value is used as the left bound, and if the second is
       NAN, maximum system allowed is used as the right one. }
    property DateTimePickerColors[ Index: TDateTimePickerColor ]: TColor
      read GetDateTimePickerColor write SetDateTimePickerColor;
    property DateTimeFormat: AnsiString write SetDateTimeFormat;

    //----------------------------------------------------------------------

    //----------------------------------------------------------------------
    // ScrollBar
    property SBMin: Longint read fSBMinMax.X write SetSBMin;
    {* Minimum scrolling area position. }
    property SBMax: Longint read fSBMinMax.Y write SetSBMax;
    {* Maximum scrolling area position (size of the text or image to be scrolling).
       For case when SCROLL_OLD defined, this value should be set as scrolling
       object size without SBPageSize. }
    property SBMinMax: TPoint read fSBMinMax write SetSBMinMax;
    {* The property to adjust SBMin and SBMax for a single call (set X to a minimum
       and Y to a maximum value). }
    property SBPosition: Integer read fSBPosition write SetSBPosition;
    {* Current scroll position. When set, should be between SBMin and
       SBMax - max(0, SBPageSize-1) }
    property SBPageSize: Integer read fSBPageSize write SetSBPageSize;
    {* }

    property OnSBBeforeScroll: TOnSBBeforeScroll read FOnSBBeforeScroll write FOnSBBeforeScroll;
    {* }
    property OnSBScroll: TOnSBScroll read FOnSBScroll write FOnSBScroll;
    {* }

    function SBSetScrollInfo(const SI: TScrollInfo): Integer;
    function SBGetScrollInfo(var SI: TScrollInfo): Boolean;
    function GetSBMinMax: TPoint;
    function GetSBPageSize: Integer;
    function GetSBPosition: Integer;
    //----------------------------------------------------------------------

    // "Through", or "transparent" methods to simplify initial
    // adjustment of controls and make non-visual designing of
    // forms more easy. All these functions return @Self as a
    // result, so, it is possible to use such methods immediately
    // in constructing statement, concatenating it with dots, e.g.:
    //
    // NewButton( MyForm, 'Click here' ).PlaceUnder.ResizeParentBottom;
    //
    {$ENDIF GDI}
    function PlaceRight: PControl;
    {* Places control right (to previously created on the same parent). }
    function PlaceDown: PControl;
    {* Places control below (to previously created on the same parent).
       Left position is not changed (thus is, kept equal to Parent.Margin). }
    function PlaceUnder: PControl;
    {* Places control below (to previously created one, aligning its
       Left position to Left position of previous control). }
    function SetSize( W, H: Integer ): PControl;
    {* Changes size of a control. If W or H less or equal to 0,
       correspondent size is not changed. }
    {$IFDEF GDI}
    function Size( W, H: Integer ): PControl;
    {* Like SetSize, but provides automatic resizing of parent control
       (recursively). Especially useful for aligned controls. }
    function SetClientSize( W, H: Integer ): PControl;
    {* Like SetSize, but works setting W = ClientWidth, H = ClientHeight.
       Use this method for forms, which can not be resized (dialogs). }

    {$ENDIF GDI}
    function AutoSize( AutoSzOn: Boolean ): PControl;
    {$IFDEF GDI}
    function MakeWordWrap: PControl;

    {* Determines if to autosize control (like label, button, etc.) }
    function IsAutoSize: Boolean;
    {* TRUE, if a control is autosizing. }
    function AlignLeft( P: PControl ): PControl;
    {* assigns Left := P.Left }
    function AlignTop( P: PControl ): PControl;
    {* assigns Top := P.Top }
    function ResizeParent: PControl;
    {* Resizes parent, calling ResizeParentRight and ResizeParentBottom. }
    function ResizeParentRight: PControl;
    {* Resizes parent right edge (Margin of parent is added to right
       coordinate of a control). If called second time (for the same
       parent), resizes only for increasing of right edge of parent. }

    function ResizeParentBottom: PControl;
    {* Resizes parent bottom edge (Margin of parent is added to
       bottom coordinate of a control). }
    function CenterOnParent: PControl;
    {* Centers control on parent, or if applied to a form, centers
       form on screen. }

    function Shift( dX, dY : Integer ): PControl;
    {* Moves control respectively to current position (Left := Left + dX,
       Top := Top + dY). }
    {$ENDIF GDI}
    function SetPosition( X, Y: Integer ): PControl;
    {* Moves control directly to the specified position. }
    {$IFDEF GDI}

    function Tabulate: PControl;
    {* Call it once for form/applet to provide tabulation between controls on
       form/on all forms using TAB / SHIFT+TAB and arrow keys. }
    function TabulateEx: PControl;
    {* Call it once for form/applet to provide tabulation between controls on
       form/on all forms using TAB / SHIFT+TAB and arrow keys. Arrow keys are
       used more smart, allowing go to nearest control in certain direction. }

    function SetAlign( AAlign: TControlAlign ): PControl;
    {* Assigns passed value to property Align, aligning control on parent,
       and returns @Self (so it is "transparent" function, which can be
       used to adjust control at the creation, e.g.:
       ! MyLabel := NewLabel( MyForm, 'Label1' ).SetAlign( caBottom );
       See also property Align. }
    function PreventResizeFlicks: PControl;
    {* If called, prevents resizing flicks for child controls, aligned to
       right and bottom (but with a lot of code added to executable - about 3,5K).
       There is sensible to set DoubleBuffered to True also to eliminate the
       most of flicks.
       |<br>&nbsp;&nbsp;&nbsp;
       This method been applied to a form, prevents, resizing flicks for
       form and all controls on the form. If it is called for applet window,
       all forms are affected. And if You want, You can apply it for certain
       control only - in such case only given control and its children will
       be resizing without flicks (e.g., using splitter control). }

    property Checked: Boolean read GetChecked write Set_Checked;
    {* |<#checkbox>
       |<#radiobox>
       For checkbox and radiobox - if it is checked. Do not assign
       value for radiobox - use SetRadioChecked instead. }
    function SetChecked(const Value: Boolean): PControl;
    {* |<#checkbox>
       Use it to check/uncheck check box control or push button.
       Do not apply it to check radio buttons - use SetRadioChecked
       method below. }
    function SetRadioChecked : PControl;
    {* |<#radiobox>
       Use it to check radio button item correctly (unchecking all
       alternative ones). Actually, method Click is called, and control
       itself is returned. }
    function SetRadioCheckedOld: PControl;
    {* |<#radiobox>
       Old version of SetRadioChecked (implemented using recommended API
       call. It does not work properly, if control is not visible
       (together with its form). }
    property Check3: TTriStateCheck read GetCheck3 write SetCheck3;
    {* |<#checkbox>
       State of checkbox with BS_AUTO3STATE style. }
    procedure Click;
    {* |<#button>
       |<#checkbox>
       |<#radiobox>
       Emulates click on control programmatically, sending WM_COMMAND
       message with BN_CLICKED code. This method is sensible only for
       buttons, checkboxes and radioboxes. }

    function Perform( msgcode: DWORD; wParam, lParam: Integer): Integer; stdcall;
    {* Sends message to control's window (created if needed). }
    function Postmsg( msgcode: DWORD; wParam, lParam: Integer): Boolean; stdcall;
    {* Sends message to control's window (created if needed). }
    procedure AttachProc( Proc: TWindowFunc );
    {* It is possible to attach dynamically any message handler to window
       procedure using this method. Last attached procedure is called first.
       If procedure returns True, further processing of a message is stopped.
       Attached procedure can be detached using DetachProc (but do not
       attach/detach procedures during handling of attached procedure -
       this can hang application). }
    procedure AttachProcEx( Proc: TWindowFunc; ExecuteAfterAppletTerminated: Boolean );
    {* The same as AttachProc, but a handler is executed even after terminating
       the main message loop processing (i.e. after assigning true to
       AppletTerminated global variable. }
    function IsProcAttached( Proc: TWindowFunc ): Boolean;
    {* Returns True, if given procedure is already in chain of attached
       ones for given control window proc. }
    procedure DetachProc( Proc: TWindowFunc );
    {* Detaches procedure attached earlier using AttachProc. }

    property OnDropFiles: TOnDropFiles read FOnDropFiles write SetOnDropFiles;
    {* Assign this event to your handler, if You want to accept drag and drop
       files from other applications such as explorer onto your control. When
       this event is assigned to a control or form, this has effect also for
       all its child controls too. }

    property CustomData: Pointer read fCustomData write fCustomData;
    {* Can be used to exend the object when new type of control added. Memory,
       pointed by this pointer, released automatically in the destructor. }
    property CustomObj: PObj read fCustomObj write fCustomObj;
    {* Can be used to exend the object when new type of control added. Object,
       pointed by this pointer, released automatically in the destructor. }
    procedure SetAutoPopupMenu( PopupMenu: PObj );
    {* To assign a popup menu to the control, call SetAutoPopupMenu method of
       the control with popup menu object as a parameter. }

    function SupportMnemonics: PControl;
    {* This method provides supporting mnemonic keys in menus, buttons, checkboxes,
       toolbar buttons. }
    property OnScroll: TOnScroll read FOnScroll write SetOnScroll;
    {* }
  protected
    {$IFDEF USE_DROPDOWNCOUNT}
    fDropDownCount: Cardinal;
    {$ENDIF}
    fGraphCtlMouseEvent: TOnGraphCtlMouse;
  public
    {$IFDEF USE_DROPDOWNCOUNT}
    property DropDownCount: Cardinal read fDropDownCount write fDropDownCount;
    {$ENDIF}
  protected
    fPushedBtn: PControl;
    fFocused: Boolean;
    fEditOptions: TEditOptions;
    fEditCtl: PControl;
    fSetFocus: procedure of object;
    fSaveCursor: HCursor;
    fLeave: TOnEvent;
    fKeyboardProcess: TOnMessage;
    fHot: Boolean;
    fPressed : Boolean;
    fHotCtl: PControl;
    fMouseLeaveProc: TOnEvent;
    fIsGroupBox: Boolean;
    fIsBitBtn: Boolean;
    fIsSplitter: Boolean;
    fErasingBkgnd: Boolean;
    fButtonIcon: HIcon;
    fActivating: Boolean;
    fFixingModal: Integer;
    {$IFDEF USE_GRAPHCTLS}
    function DoGraphCtlPrepaint: TRect;
    procedure GraphicLabelPaint( DC: HDC );
    procedure GraphicCheckBoxPaint( DC: HDC );
    procedure GraphicCheckBoxMouse( var Msg: TMsg );
    procedure GraphicRadioBoxPaint( DC: HDC );
    procedure GraphicButtonPaint( DC: HDC );
    procedure GraphicButtonMouse( var Msg: TMsg );
    procedure GraphButtonSetFocus;
    function GraphButtonKeyboardProcess( var Msg: TMsg; var Rslt: Integer ): Boolean;
    procedure LeaveGraphButton( Sender: PObj );
    procedure GraphicEditPaint( DC: HDC );
    procedure GraphicEditMouse( var Msg: TMsg );
    function EditGraphEdit: PControl;
    procedure DestroyGraphEdit( Sender: PObj );
    procedure LeaveGraphEdit( Sender: PObj );
    procedure ChangeGraphEdit( Sender: PObj );
    procedure GraphEditboxSetFocus;
    procedure GraphCtlDrawFocusRect( DC: HDC; const R: TRect );
    {$IFDEF GRAPHCTL_HOTTRACK}
    procedure MouseLeaveFromParentOfGraphCtl( Sender: PObj );
    {$ENDIF GRAPHCTL_HOTTRACK}
    procedure GroupBoxPaint( DC: HDC );
    {$ENDIF USE_GRAPHCTLS}
    {$IFDEF KEY_PREVIEW}
  protected
    fKeyPreview: Boolean;
    fKeyPreviewing: Boolean;
    fKeyPreviewCount: Integer;
  public
    property KeyPreview: Boolean read fKeyPreview write fKeyPreview;
    property KeyPreviewing: Boolean read fKeyPreviewing write fKeyPreviewing;
    {$ENDIF KEY_PREVIEW}
  protected
    fAnchorLeft: Boolean; //+Sormart
    fAnchorTop: Boolean;  //+Sormart
    fAnchorRight: Boolean;
    fAnchorBottom: Boolean;
    fOldWidth, fOldHeight: Integer;
    procedure SetAnchorLeft(const Value: Boolean); //+Sormart
    procedure SetAnchorTop(const Value: Boolean);  //+Sormart
    procedure SetAnchorRight( Value: Boolean );
    procedure SetAnchorBottom( Value: Boolean );
  public
    property AnchorLeft: Boolean read fAnchorLeft write SetAnchorLeft default true; //+Sormart
    property AnchorTop: Boolean read fAnchorTop write SetAnchorTop default true;    //+Sormart
    property AnchorRight: Boolean read fAnchorRight write SetAnchorRight;
    property AnchorBottom: Boolean read fAnchorBottom write SetAnchorBottom;
    function Anchor( aLeft, aTop, aRight, aBottom: Boolean ): PControl;
  public
    {$IFDEF USE_CONSTRUCTORS}
    //------------------------------------------------------------
    // constructors here:
    constructor CreateWindowed( AParent: PControl; AClassName: PKOLChar; ACtl3D: Boolean );
    constructor CreateApplet( const ACaption: AnsiString );
    constructor CreateForm( AParent: PControl; const ACaption: AnsiString );
    constructor CreateControl( AParent: PControl; AClassName: PAnsiChar; AStyle: DWORD;
                               ACtl3D: Boolean; Actions: PCommandActions );
    constructor CreateButton( AParent: PControl; const ACaption: AnsiString );
    constructor CreateBitBtn( AParent: PControl; const ACaption: AnsiString;
         AOptions: TBitBtnOptions; ALayout: TGlyphLayout; AGlyphBitmap: HBitmap;
         AGlyphCount: Integer);
    constructor CreateLabel( AParent: PControl; const ACaption: AnsiString );
    constructor CreateWordWrapLabel( AParent: PControl; const ACaption: AnsiString );
    constructor CreateLabelEffect( AParent: PControl; ACaption: AnsiString; AShadowDeep: Integer );
    constructor CreatePaintBox( AParent: PControl );
    constructor CreateGradientPanel( AParent: PControl; AColor1, AColor2: TColor );
    constructor CreateGradientPanelEx( AParent: PControl; AColor1, AColor2: TColor;
                             AStyle: TGradientStyle; ALayout: TGradientLayout );
    constructor CreateGroupbox( AParent: PControl; const ACaption: AnsiString );
    constructor CreateCheckbox( AParent: PControl; const ACaption: AnsiString );
    constructor CreateRadiobox( AParent: PControl; const ACaption: AnsiString );
    constructor CreateEditbox( AParent: PControl; AOptions: TEditOptions );
    constructor CreatePanel( AParent: PControl; AStyle: TEdgeStyle );
    constructor CreateSplitter( AParent: PControl; AMinSizePrev, AMinSizeNext: Integer;
                EdgeStyle: TEdgeStyle );
    constructor CreateListbox( AParent: PControl; AOptions: TListOptions );
    constructor CreateCombobox( AParent: PControl; AOptions: TComboOptions );
    constructor CreateCommonControl( AParent: PControl; AClassName: PAnsiChar; AStyle: DWORD;
                            ACtl3D: Boolean; Actions: PCommandActions );
    constructor CreateRichEdit( AParent: PControl; AOptions: TEditOptions );
    constructor CreateRichEdit1( AParent: PControl; AOptions: TEditOptions );
    constructor CreateProgressbar( AParent: PControl );
    constructor CreateProgressbarEx( AParent: PControl; AOptions: TProgressbarOptions );
    constructor CreateListView( AParent: PControl; AStyle: TListViewStyle; AOptions: TListViewOptions;
                      AImageListSmall, AImageListNormal, AImageListState: PImageList );
    constructor CreateTreeView( AParent: PControl; AOptions: TTreeViewOptions;
                      AImgListNormal, AImgListState: PImageList );
    constructor CreateTabControl( AParent: PControl; ATabs: array of String;
         AOptions: TTabControlOptions; AImgList: PImageList; AImgList1stIdx: Integer );
    constructor CreateToolbar( AParent: PControl; AAlign: TControlAlign; AOptions: TToolbarOptions;
                     ABitmap: HBitmap; AButtons: array of PChar;
                     ABtnImgIdxArray: array of Integer );
    {$ENDIF USE_CONSTRUCTORS}

    {$IFDEF USE_CUSTOMEXTENSIONS}
      {$I CUSTOM_TCONTROL_EXTENSION.inc}
    {$ENDIF}
    // If an option USE_CUSTOMEXTENSIONS is enabled (at the beginning of this
    // unit), You can freely extend TControl definition by your own fields,
    // methods and properties. This provides You with capability to extend
    // TControl implementing another kinds of visual controls without deriving
    // new descendant objects from TControl. This way is provided to avoid too
    // large grow of executable size. You also can derive your own controls
    // from TControl using standard OOP capabilities. In such case an option
    // USE_CONSTRUCTORS should be turned on (see it at the start of this unit).
    //   If You choose this "flat" model of extending the TControl with your
    // own properties, fieds, methods, events, etc. You should provide three
    // inc-files: CUSTOM_TCONTROL_EXTENSION.inc, containing such definitions
    // for TControl, CUSTOM_KOL_EXTENSION.inc, containing needed global
    // declarations, and CUSTOM_CODE_EXTENSION.inc, the implementation of those
    // two.
    //   Because KOL is always grow and constantly is extending by me, I also can
    // add my own complements for TControl. To avoid naming conflicts, I suggest
    // to use the same naming rule for all of You. Name your fields, properies, etc.
    // using a form idx_SomeName, where idx is a prefix, containing several
    // (at least one) letters and digits. E.g. ZK65_OnSomething.

  protected
     fParentCoordX: Integer;
     fParentCoordY: Integer;
  // last changes (1-Jul-06) from ECM [Michalichenko Eugeny, rest in peace, friend]:
  //======== ListBox
  private
    function  GetLBTopIndex: Integer;
    procedure SetLBTopIndex(const Value: Integer);
  public
    function LBItemAtPos(X,Y: Integer): Integer;
    {* |<#listbox>
       Return index of item at the given position. }
    property LBTopIndex: Integer read GetLBTopIndex write SetLBTopIndex;
    {* |<#listbox>
       Index of the first visible item in a list box}
  //_________
{$ENDIF GDI}
  end;
//[END OF TControl DEFINITION]

  {$IFDEF USE_MHTOOLTIP}
  {$DEFINE interface}
  {$I KOLMHToolTip}
  {$UNDEF interface}
  {$ENDIF}

{$IFDEF WIN_GDI}
function ToolbarButtonRect( Toolbar: PControl; BtnID: Integer ): TRect;
{* Use this function instead of reading TControl.TBButtonRect, if you want
   to have it working the same way when standard toolbar is used or GRushControl
   toolbar provided in ToGRush.pas unit.
}
procedure ToolbarSetTooltips( Toolbar: PControl; BtnID1st: Integer; const Tooltips: array of PKOLChar );
{* Use this function instead of TContol.TBSetTooltips in your project, when
   you use ToGRush unit.
}
function ToolbarButtonEnabled( Toolbar: PControl; BtnID: Integer ): Boolean;
{* Use this function instead of reading the property TControl.TBButtonEnabled
   when tou use ToGRush unit. }
procedure EnableToolbarButton( Toolbar: PControl; BtnID: Integer; Enable: Boolean );
{* Use this procedure instead of writing the property TControl.TBButtonEnabled
   when you use ToGRush unit. }
function ToolbarButtonVisible( Toolbar: PControl; BtnID: Integer ): Boolean;
{* Use this function instead of reading the property TControl.TBButtonVisible
   when tou use ToGRush unit. }
procedure ShowHideToolbarButton( Toolbar: PControl; BtnID: Integer; Show: Boolean );
{* Use this procedure instead of writing the property TControl.TBButtonVisible
   when you use ToGRush unit. }
function ToolbarButtonChecked( Toolbar: PControl; BtnID: Integer): Boolean;
{* }
procedure ToolbarButtonSetChecked( Toolbar: PControl; BtnID: Integer; Checked: Boolean );
{* }

function  Scrollbar_GetMinPos( sb: PControl ): Integer;
procedure Scrollbar_SetMinPos( sb: PControl; m: Integer );
procedure Scrollbar_SetAll( sb: PControl; min, max, pg, cur: Integer );
function  Scrollbar_GetMaxPos( sb: PControl ): Integer;
procedure Scrollbar_SetMaxPos( sb: PControl; m: Integer );
function  Scrollbar_GetCurPos( sb: PControl ): Integer;
procedure Scrollbar_SetCurPos( sb: PControl; newp: Integer );
procedure Scrollbar_SetPageSz( sb: PControl; psz: Integer );
function  Scrollbar_GetPageSz( sb: PControl ): Integer;
procedure Scrollbar_SetLineSz( sb: PControl; lnz: Integer );
function  Scrollbar_GetLineSz( sb: PControl ): Integer;
{$ENDIF WIN_GDI}

var ToolbarsIDcmd: Integer = 100;

//[Paint Background PROCEDURE]
type
  TOnPaintBkgnd = procedure( Sender: PControl; DC: HDC; Rect: PRect );
  {* Global event definition. Used to define Global_OnPaintBackground
     event placeholder. }

procedure DefaultPaintBackground( Sender: PControl; DC: HDC; Rect: PRect );

var
  Global_OnPaintBkgnd: TOnPaintBkgnd = DefaultPaintBackground;
  {* Global event. It is assigned in XBackgounds.pas add-on to replace
     PaintBackground method for all TVisual objects, allowing great
     visualization effect: transparent controls over [animated] bitmap
     background. Idea:
     | <a href=mailto:"bw@sunv.com">Wei&nbsp;Bao</a>. Implementation:
     | <a href=mailto:"bonanzas@xcl.cjb.net">Kladov&nbsp;Vladimir</a>. }

procedure DummyPaintProc( Sender: PControl; DC: HDC );

//[GetShiftState DECLARATION]
function GetShiftState: DWORD;
{* Returns shift state. }

{$IFDEF WIN_GDI}
//[WndProcXXX DECLARATIONS]
function WndProcMouse( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;
function WndProcKeybd( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;
function WndProcDummy( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;
function WndProcMenu( Sender: PControl; var Msg: TMsg; var Rslt: Integer): Boolean;
{$IFDEF ALL_BUTTONS_RESPOND_TO_ENTER}
function WndProcBtnReturnClick( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;
{$ENDIF}
function AutoMinimizeApplet(Self_: PControl; var Msg: TMsg; var Rslt: Integer): Boolean;
{* By Sergey Shishmintzev.
   Attach this handler to your modal dialog form handle to provide automatic
   minimization of all other forms in the application together with the dialog. }

//[InitCommonXXXX DECLARATIONS]
procedure InitCommonControlSizeNotify( Ctrl: PControl );
procedure InitCommonControlCommonNotify( Ctrl: PControl );

//[Buffered Draw DECLARATIONS]
procedure DummyAttachProcExtension ( DynHandlers: PList );
procedure TransparentAttachProcExtension ( DynHandlers: PList );

{$IFNDEF SMALLEST_CODE}
var Global_AttachProcExtension: procedure( DynHandlers: PList ) = DummyAttachProcExtension;
{$ENDIF}
{$ENDIF WIN_GDI}
var HelpFilePath: PAnsiChar;
  {* Path to application help file. If not assigned, application path with
     extension replaced to '.hlp' used. To use '.chm' file (HtmlHelp),
     call AssignHtmlHelp with a path to a html help file (or a name). }

{$IFDEF WIN_GDI}
//[Html Help DECLARATIONS]
procedure AssignHtmlHelp( const HtmlHelpPath: KOLString );
procedure HtmlHelpCommand( Wnd: HWnd; const HelpFilePath: AnsiString; Cmd, Data: Integer );
{* Use this wrapper procedure to call HtmlHelp API function. }
//+++++++++++ HTML HELP DEFINITIONS SECTION:
// this section is from
//   HTML Help API Interface Unit
//   Copyright (c) 1999 The Helpware Group
// provided for KOL by Alexey Babenko
const
  HH_DISPLAY_TOPIC        = $0000;  {**}
  HH_HELP_FINDER          = $0000;  // WinHelp equivalent
  HH_DISPLAY_TOC          = $0001;  // not currently implemented
  HH_DISPLAY_INDEX        = $0002;  // not currently implemented
  HH_DISPLAY_SEARCH       = $0003;  // not currently implemented
  HH_SET_WIN_TYPE         = $0004;
  HH_GET_WIN_TYPE         = $0005;
  HH_GET_WIN_HANDLE       = $0006;
  HH_ENUM_INFO_TYPE       = $0007;  // Get Info type name, call repeatedly to enumerate, -1 at end
  HH_SET_INFO_TYPE        = $0008;  // Add Info type to filter.
  HH_SYNC                 = $0009;
  HH_RESERVED1            = $000A;
  HH_RESERVED2            = $000B;
  HH_RESERVED3            = $000C;
  HH_KEYWORD_LOOKUP       = $000D;
  HH_DISPLAY_TEXT_POPUP   = $000E;  // display string resource id or text in a popup window
  HH_HELP_CONTEXT         = $000F;  {**}// display mapped numeric value in dwData
  HH_TP_HELP_CONTEXTMENU  = $0010;  // text popup help, same as WinHelp HELP_CONTEXTMENU
  HH_TP_HELP_WM_HELP      = $0011;  // text popup help, same as WinHelp HELP_WM_HELP
  HH_CLOSE_ALL            = $0012;  // close all windows opened directly or indirectly by the caller
  HH_ALINK_LOOKUP         = $0013;  // ALink version of HH_KEYWORD_LOOKUP
  HH_GET_LAST_ERROR       = $0014;  // not currently implemented // See HHERROR.h
  HH_ENUM_CATEGORY        = $0015;	// Get category name, call repeatedly to enumerate, -1 at end
  HH_ENUM_CATEGORY_IT     = $0016;  // Get category info type members, call repeatedly to enumerate, -1 at end
  HH_RESET_IT_FILTER      = $0017;  // Clear the info type filter of all info types.
  HH_SET_INCLUSIVE_FILTER = $0018;  // set inclusive filtering method for untyped topics to be included in display
  HH_SET_EXCLUSIVE_FILTER = $0019;  // set exclusive filtering method for untyped topics to be excluded from display
  HH_INITIALIZE           = $001C;  // Initializes the help system.
  HH_UNINITIALIZE         = $001D;  // Uninitializes the help system.
  HH_PRETRANSLATEMESSAGE  = $00fd;  // Pumps messages. (NULL, NULL, MSG*).
  HH_SET_GLOBAL_PROPERTY  = $00fc;  // Set a global property. (NULL, NULL, HH_GPROP)

  { window properties }

const
  HHWIN_PROP_TAB_AUTOHIDESHOW = $00000001;  // (1 << 0)  Automatically hide/show tri-pane window
  HHWIN_PROP_ONTOP            = $00000002;  // (1 << 1)  Top-most window
  HHWIN_PROP_NOTITLEBAR       = $00000004;  // (1 << 2)  no title bar
  HHWIN_PROP_NODEF_STYLES     = $00000008;  // (1 << 3)  no default window styles (only HH_WINTYPE.dwStyles)
  HHWIN_PROP_NODEF_EXSTYLES   = $00000010;  // (1 << 4)  no default extended window styles (only HH_WINTYPE.dwExStyles)
  HHWIN_PROP_TRI_PANE         = $00000020;  // (1 << 5)  use a tri-pane window
  HHWIN_PROP_NOTB_TEXT        = $00000040;  // (1 << 6)  no text on toolbar buttons
  HHWIN_PROP_POST_QUIT        = $00000080;  // (1 << 7)  post WM_QUIT message when window closes
  HHWIN_PROP_AUTO_SYNC        = $00000100;  // (1 << 8)  automatically ssync contents and index
  HHWIN_PROP_TRACKING         = $00000200;  // (1 << 9)  send tracking notification messages
  HHWIN_PROP_TAB_SEARCH       = $00000400;  // (1 << 10) include search tab in navigation pane
  HHWIN_PROP_TAB_HISTORY      = $00000800;  // (1 << 11) include history tab in navigation pane
  HHWIN_PROP_TAB_FAVORITES    = $00001000;  // (1 << 12) include favorites tab in navigation pane
  HHWIN_PROP_CHANGE_TITLE     = $00002000;  // (1 << 13) Put current HTML title in title bar
  HHWIN_PROP_NAV_ONLY_WIN     = $00004000;  // (1 << 14) Only display the navigation window
  HHWIN_PROP_NO_TOOLBAR       = $00008000;  // (1 << 15) Don't display a toolbar
  HHWIN_PROP_MENU             = $00010000;  // (1 << 16) Menu
  HHWIN_PROP_TAB_ADVSEARCH    = $00020000;  // (1 << 17) Advanced FTS UI.
  HHWIN_PROP_USER_POS         = $00040000;  // (1 << 18) After initial creation, user controls window size/position
  HHWIN_PROP_TAB_CUSTOM1      = $00080000;  // (1 << 19) Use custom tab #1
  HHWIN_PROP_TAB_CUSTOM2      = $00100000;  // (1 << 20) Use custom tab #2
  HHWIN_PROP_TAB_CUSTOM3      = $00200000;  // (1 << 21) Use custom tab #3
  HHWIN_PROP_TAB_CUSTOM4      = $00400000;  // (1 << 22) Use custom tab #4
  HHWIN_PROP_TAB_CUSTOM5      = $00800000;  // (1 << 23) Use custom tab #5
  HHWIN_PROP_TAB_CUSTOM6      = $01000000;  // (1 << 24) Use custom tab #6
  HHWIN_PROP_TAB_CUSTOM7      = $02000000;  // (1 << 25) Use custom tab #7
  HHWIN_PROP_TAB_CUSTOM8      = $04000000;  // (1 << 26) Use custom tab #8
  HHWIN_PROP_TAB_CUSTOM9      = $08000000;  // (1 << 27) Use custom tab #9
  HHWIN_TB_MARGIN             = $10000000;  // (1 << 28) the window type has a margin

  { window parameters }

const
  HHWIN_PARAM_PROPERTIES      = $00000002;  // (1 << 1)  valid fsWinProperties
  HHWIN_PARAM_STYLES          = $00000004;  // (1 << 2)  valid dwStyles
  HHWIN_PARAM_EXSTYLES        = $00000008;  // (1 << 3)  valid dwExStyles
  HHWIN_PARAM_RECT            = $00000010;  // (1 << 4)  valid rcWindowPos
  HHWIN_PARAM_NAV_WIDTH       = $00000020;  // (1 << 5)  valid iNavWidth
  HHWIN_PARAM_SHOWSTATE       = $00000040;  // (1 << 6)  valid nShowState
  HHWIN_PARAM_INFOTYPES       = $00000080;  // (1 << 7)  valid apInfoTypes
  HHWIN_PARAM_TB_FLAGS        = $00000100;  // (1 << 8)  valid fsToolBarFlags
  HHWIN_PARAM_EXPANSION       = $00000200;  // (1 << 9)  valid fNotExpanded
  HHWIN_PARAM_TABPOS          = $00000400;  // (1 << 10) valid tabpos
  HHWIN_PARAM_TABORDER        = $00000800;  // (1 << 11) valid taborder
  HHWIN_PARAM_HISTORY_COUNT   = $00001000;  // (1 << 12) valid cHistory
  HHWIN_PARAM_CUR_TAB         = $00002000;  // (1 << 13) valid curNavType

  { button constants }

const
  HHWIN_BUTTON_EXPAND         = $00000002;  // (1 << 1)  Expand/contract button
  HHWIN_BUTTON_BACK           = $00000004;  // (1 << 2)  Back button
  HHWIN_BUTTON_FORWARD        = $00000008;  // (1 << 3)  Forward button
  HHWIN_BUTTON_STOP           = $00000010;  // (1 << 4)  Stop button
  HHWIN_BUTTON_REFRESH        = $00000020;  // (1 << 5)  Refresh button
  HHWIN_BUTTON_HOME           = $00000040;  // (1 << 6)  Home button
  HHWIN_BUTTON_BROWSE_FWD     = $00000080;  // (1 << 7)  not implemented
  HHWIN_BUTTON_BROWSE_BCK     = $00000100;  // (1 << 8)  not implemented
  HHWIN_BUTTON_NOTES          = $00000200;  // (1 << 9)  not implemented
  HHWIN_BUTTON_CONTENTS       = $00000400;  // (1 << 10) not implemented
  HHWIN_BUTTON_SYNC           = $00000800;  // (1 << 11) Sync button
  HHWIN_BUTTON_OPTIONS        = $00001000;  // (1 << 12) Options button
  HHWIN_BUTTON_PRINT          = $00002000;  // (1 << 13) Print button
  HHWIN_BUTTON_INDEX          = $00004000;  // (1 << 14) not implemented
  HHWIN_BUTTON_SEARCH         = $00008000;  // (1 << 15) not implemented
  HHWIN_BUTTON_HISTORY        = $00010000;  // (1 << 16) not implemented
  HHWIN_BUTTON_FAVORITES      = $00020000;  // (1 << 17) not implemented
  HHWIN_BUTTON_JUMP1          = $00040000;  // (1 << 18)
  HHWIN_BUTTON_JUMP2          = $00080000;  // (1 << 19)
  HHWIN_BUTTON_ZOOM           = $00100000;  // (1 << 20)
  HHWIN_BUTTON_TOC_NEXT       = $00200000;  // (1 << 21)
  HHWIN_BUTTON_TOC_PREV       = $00400000;  // (1 << 22)

  HHWIN_DEF_BUTTONS           = (HHWIN_BUTTON_EXPAND
                                 OR HHWIN_BUTTON_BACK
                                 OR HHWIN_BUTTON_OPTIONS
                                 OR HHWIN_BUTTON_PRINT);

  { Button IDs }

const
  IDTB_EXPAND             = 200;
  IDTB_CONTRACT           = 201;
  IDTB_STOP               = 202;
  IDTB_REFRESH            = 203;
  IDTB_BACK               = 204;
  IDTB_HOME               = 205;
  IDTB_SYNC               = 206;
  IDTB_PRINT              = 207;
  IDTB_OPTIONS            = 208;
  IDTB_FORWARD            = 209;
  IDTB_NOTES              = 210; // not implemented
  IDTB_BROWSE_FWD         = 211;
  IDTB_BROWSE_BACK        = 212;
  IDTB_CONTENTS           = 213; // not implemented
  IDTB_INDEX              = 214; // not implemented
  IDTB_SEARCH             = 215; // not implemented
  IDTB_HISTORY            = 216; // not implemented
  IDTB_FAVORITES          = 217; // not implemented
  IDTB_JUMP1              = 218;
  IDTB_JUMP2              = 219;
  IDTB_CUSTOMIZE          = 221;
  IDTB_ZOOM               = 222;
  IDTB_TOC_NEXT           = 223;
  IDTB_TOC_PREV           = 224;

  { Notification codes }

const
  HHN_FIRST       = (0-860);
  HHN_LAST        = (0-879);

  HHN_NAVCOMPLETE   = (HHN_FIRST-0);
  HHN_TRACK         = (HHN_FIRST-1);
  HHN_WINDOW_CREATE = (HHN_FIRST-2);

type
  {*** Used by command HH_GET_LAST_ERROR
   NOTE: Not part of the htmlhelp.h but documented in HH Workshop help
         You must call SysFreeString(xx.description) to free BSTR
  }
  tagHH_LAST_ERROR = packed record
    cbStruct:      Integer;     // sizeof this structure
    hr:            Integer;     // Specifies the last error code.
    description:   PWideChar;   // (BSTR) Specifies a Unicode string containing a description of the error.
  end;
  HH_LAST_ERROR = tagHH_LAST_ERROR;
  THHLastError = tagHH_LAST_ERROR;

type
  {*** Notify event info for HHN_NAVCOMPLETE, HHN_WINDOW_CREATE }
  PHHNNotify = ^THHNNotify;
  tagHHN_NOTIFY = packed record
    hdr:    TNMHdr;
    pszUrl: PAnsiChar;              //PCSTR: Multi-byte, null-terminated string
  end;
  HHN_NOTIFY = tagHHN_NOTIFY;
  THHNNotify = tagHHN_NOTIFY;

  {** Use by command HH_DISPLAY_TEXT_POPUP}
  PHHPopup = ^THHPopup;
  tagHH_POPUP = packed record
    cbStruct:      Integer;     // sizeof this structure
    hinst:         HINST;       // instance handle for string resource
    idString:      cardinal;    // string resource id, or text id if pszFile is specified in HtmlHelp call
    pszText:       PAnsiChar;       // used if idString is zero
    pt:            TPOINT;      // top center of popup window
    clrForeground: COLORREF;    // use -1 for default
    clrBackground: COLORREF;    // use -1 for default
    rcMargins:     TRect;       // amount of space between edges of window and text, -1 for each member to ignore
    pszFont:       PAnsiChar;       // facename, point size, char set, BOLD ITALIC UNDERLINE
  end;
  HH_POPUP = tagHH_POPUP;
  THHPopup = tagHH_POPUP;

  {** Use by commands - HH_ALINK_LOOKUP, HH_KEYWORD_LOOKUP}
  PHHAKLink = ^THHAKLink;
  tagHH_AKLINK = packed record
    cbStruct:      integer;     // sizeof this structure
    fReserved:     BOOL;        // must be FALSE (really!)
    pszKeywords:   PAnsiChar;       // semi-colon separated keywords
    pszUrl:        PAnsiChar;       // URL to jump to if no keywords found (may be NULL)
    pszMsgText:    PAnsiChar;       // Message text to display in MessageBox if pszUrl is NULL and no keyword match
    pszMsgTitle:   PAnsiChar;       // Message text to display in MessageBox if pszUrl is NULL and no keyword match
    pszWindow:     PAnsiChar;       // Window to display URL in
    fIndexOnFail:  BOOL;        // Displays index if keyword lookup fails.
  end;
  HH_AKLINK = tagHH_AKLINK;
  THHAKLink = tagHH_AKLINK;

const
  HHWIN_NAVTYPE_TOC          = 0;
  HHWIN_NAVTYPE_INDEX        = 1;
  HHWIN_NAVTYPE_SEARCH       = 2;
  HHWIN_NAVTYPE_FAVORITES    = 3;
  HHWIN_NAVTYPE_HISTORY      = 4;   // not implemented
  HHWIN_NAVTYPE_AUTHOR       = 5;
  HHWIN_NAVTYPE_CUSTOM_FIRST = 11;

const
  IT_INCLUSIVE = 0;
  IT_EXCLUSIVE = 1;
  IT_HIDDEN    = 2;

type
  PHHEnumIT = ^THHEnumIT;
  tagHH_ENUM_IT = packed record                  //tagHH_ENUM_IT, HH_ENUM_IT, *PHH_ENUM_IT
    cbStruct:           Integer;     // size of this structure
    iType:              Integer;     // the type of the information type ie. Inclusive, Exclusive, or Hidden
    pszCatName:         PAnsiChar;   // Set to the name of the Category to enumerate the info types in a category; else NULL
    pszITName:          PAnsiChar;   // volitile pointer to the name of the infotype. Allocated by call. Caller responsible for freeing
    pszITDescription:   PAnsiChar;   // volitile pointer to the description of the infotype.
  end;
  THHEnumIT = tagHH_ENUM_IT;

type
  PHHEnumCat = ^THHEnumCat;
  tagHH_ENUM_CAT = packed record                 //tagHH_ENUM_CAT, HH_ENUM_CAT, *PHH_ENUM_CAT
    cbStruct:           Integer;     // size of this structure
    pszCatName:         PAnsiChar;   // volitile pointer to the category name
    pszCatDescription:  PAnsiChar;   // volitile pointer to the category description
  end;
  THHEnumCat = tagHH_ENUM_CAT;

type
  PHHSetInfoType = ^THHSetInfoType;
  tagHH_SET_INFOTYPE = packed record             //tagHH_SET_INFOTYPE, HH_SET_INFOTYPE, *PHH_SET_INFOTYPE
    cbStruct:           Integer;     // the size of this structure
    pszCatName:         PAnsiChar;   // the name of the category, if any, the InfoType is a member of.
    pszInfoTypeName:    PAnsiChar;   // the name of the info type to add to the filter
  end;
  THHSetInfoType = tagHH_SET_INFOTYPE;

type
  HH_INFOTYPE = DWORD;
  THHInfoType = HH_INFOTYPE;
  PHHInfoType = ^THHInfoType;        //PHH_INFOTYPE

const
  HHWIN_NAVTAB_TOP    = 0;
  HHWIN_NAVTAB_LEFT   = 1;
  HHWIN_NAVTAB_BOTTOM = 2;

const
  HH_MAX_TABS  = 19;                 // maximum number of tabs
const
  HH_TAB_CONTENTS     = 0;
  HH_TAB_INDEX        = 1;
  HH_TAB_SEARCH       = 2;
  HH_TAB_FAVORITES    = 3;
  HH_TAB_HISTORY      = 4;
  HH_TAB_AUTHOR       = 5;
  HH_TAB_CUSTOM_FIRST = 11;
  HH_TAB_CUSTOM_LAST  = HH_MAX_TABS;

  HH_MAX_TABS_CUSTOM = (HH_TAB_CUSTOM_LAST - HH_TAB_CUSTOM_FIRST + 1);

  { HH_DISPLAY_SEARCH Command Related Structures and Constants }

const
  HH_FTS_DEFAULT_PROXIMITY = (-1);

type
  {** Used by command HH_DISPLAY_SEARCH}
  PHHFtsQuery = ^THHFtsQuery;
  tagHH_FTS_QUERY = packed record          //tagHH_FTS_QUERY, HH_FTS_QUERY
    cbStruct:          integer;      // Sizeof structure in bytes.
    fUniCodeStrings:   BOOL;         // TRUE if all strings are unicode.
    pszSearchQuery:    PAnsiChar;        // String containing the search query.
    iProximity:        LongInt;      // Word proximity.
    fStemmedSearch:    Bool;         // TRUE for StemmedSearch only.
    fTitleOnly:        Bool;         // TRUE for Title search only.
    fExecute:          Bool;         // TRUE to initiate the search.
    pszWindow:         PAnsiChar;        // Window to display in
  end;
  THHFtsQuery = tagHH_FTS_QUERY;

  { HH_WINTYPE Structure }

type
  {** Used by commands HH_GET_WIN_TYPE, HH_SET_WIN_TYPE}
  PHHWinType = ^THHWinType;
  tagHH_WINTYPE = packed record             //tagHH_WINTYPE, HH_WINTYPE, *PHH_WINTYPE;
    cbStruct:          Integer;      // IN: size of this structure including all Information Types
    fUniCodeStrings:   BOOL;         // IN/OUT: TRUE if all strings are in UNICODE
    pszType:           PAnsiChar;        // IN/OUT: Name of a type of window
    fsValidMembers:    DWORD;        // IN: Bit flag of valid members (HHWIN_PARAM_)
    fsWinProperties:   DWORD;        // IN/OUT: Properties/attributes of the window (HHWIN_)

    pszCaption:        PAnsiChar;        // IN/OUT: Window title
    dwStyles:          DWORD;        // IN/OUT: Window styles
    dwExStyles:        DWORD;        // IN/OUT: Extended Window styles
    rcWindowPos:       TRect;        // IN: Starting position, OUT: current position
    nShowState:        Integer;      // IN: show state (e.g., SW_SHOW)

    hwndHelp:          HWND;         // OUT: window handle
    hwndCaller:        HWND;         // OUT: who called this window

    paInfoTypes:       PHHInfoType;  // IN: Pointer to an array of Information Types

    { The following members are only valid if HHWIN_PROP_TRI_PANE is set }

    hwndToolBar:       HWND;         // OUT: toolbar window in tri-pane window
    hwndNavigation:    HWND;         // OUT: navigation window in tri-pane window
    hwndHTML:          HWND;         // OUT: window displaying HTML in tri-pane window
    iNavWidth:         Integer;      // IN/OUT: width of navigation window
    rcHTML:            TRect;        // OUT: HTML window coordinates

    pszToc:            PAnsiChar;        // IN: Location of the table of contents file
    pszIndex:          PAnsiChar;        // IN: Location of the index file
    pszFile:           PAnsiChar;        // IN: Default location of the html file
    pszHome:           PAnsiChar;        // IN/OUT: html file to display when Home button is clicked
    fsToolBarFlags:    DWORD;        // IN: flags controling the appearance of the toolbar (HHWIN_BUTTON_)
    fNotExpanded:      BOOL;         // IN: TRUE/FALSE to contract or expand, OUT: current state
    curNavType:        Integer;      // IN/OUT: UI to display in the navigational pane
    tabpos:            Integer;      // IN/OUT: HHWIN_NAVTAB_TOP, HHWIN_NAVTAB_LEFT, or HHWIN_NAVTAB_BOTTOM
    idNotify:          Integer;      // IN: ID to use for WM_NOTIFY messages
    tabOrder: packed array[0..HH_MAX_TABS] of Byte;  // IN/OUT: tab order: Contents, Index, Search, History, Favorites, Reserved 1-5, Custom tabs
    cHistory:          Integer;       // IN/OUT: number of history items to keep (default is 30)
    pszJump1:          PAnsiChar;         // Text for HHWIN_BUTTON_JUMP1
    pszJump2:          PAnsiChar;         // Text for HHWIN_BUTTON_JUMP2
    pszUrlJump1:       PAnsiChar;         // URL for HHWIN_BUTTON_JUMP1
    pszUrlJump2:       PAnsiChar;         // URL for HHWIN_BUTTON_JUMP2
    rcMinSize:         TRect;         // Minimum size for window (ignored in version 1)

    cbInfoTypes:       Integer;       // size of paInfoTypes;
    pszCustomTabs:     PAnsiChar;         // multiple zero-terminated strings
  end;
  HH_WINTYPE = tagHH_WINTYPE;
  THHWinType = tagHH_WINTYPE;

const
  HHACT_TAB_CONTENTS   = 0;
  HHACT_TAB_INDEX      = 1;
  HHACT_TAB_SEARCH     = 2;
  HHACT_TAB_HISTORY    = 3;
  HHACT_TAB_FAVORITES  = 4;

  HHACT_EXPAND         = 5;
  HHACT_CONTRACT       = 6;
  HHACT_BACK           = 7;
  HHACT_FORWARD        = 8;
  HHACT_STOP           = 9;
  HHACT_REFRESH        = 10;
  HHACT_HOME           = 11;
  HHACT_SYNC           = 12;
  HHACT_OPTIONS        = 13;
  HHACT_PRINT          = 14;
  HHACT_HIGHLIGHT      = 15;
  HHACT_CUSTOMIZE      = 16;
  HHACT_JUMP1          = 17;
  HHACT_JUMP2          = 18;
  HHACT_ZOOM           = 19;
  HHACT_TOC_NEXT       = 20;
  HHACT_TOC_PREV       = 21;
  HHACT_NOTES          = 22;

  HHACT_LAST_ENUM      = 23;

type
  {*** Notify event info for HHN_TRACK }
  PHHNTrack = ^THHNTrack;
  tagHHNTRACK = packed record                  //tagHHNTRACK, HHNTRACK;
    hdr:               TNMHdr;
    pszCurUrl:         PAnsiChar;                  // Multi-byte, null-terminated string  
    idAction:          Integer;                // HHACT_ value
    phhWinType:        PHHWinType;             // Current window type structure
  end;
  HHNTRACK = tagHHNTRACK;
  THHNTrack = tagHHNTRACK;

///////////////////////////////////////////////////////////////////////////////
//
// Global Control Properties.
//
const
  HH_GPROPID_SINGLETHREAD     = 1;      // VARIANT_BOOL: True for single thread
  HH_GPROPID_TOOLBAR_MARGIN   = 2;      // long: Provides a left/right margin around the toolbar.
  HH_GPROPID_UI_LANGUAGE      = 3;      // long: LangId of the UI.
  HH_GPROPID_CURRENT_SUBSET   = 4;      // BSTR: Current subset.
  HH_GPROPID_CONTENT_LANGUAGE = 5;      // long: LandId for desired content.

type
  tagHH_GPROPID = HH_GPROPID_SINGLETHREAD..HH_GPROPID_CONTENT_LANGUAGE;                //tagHH_GPROPID, HH_GPROPID
  HH_GPROPID = tagHH_GPROPID;
  THHGPropID = HH_GPROPID;

///////////////////////////////////////////////////////////////////////////////
//
// Global Property structure
//
{type
  PHHGlobalProperty = ^THHGlobalProperty;
  tagHH_GLOBAL_PROPERTY = record                  //tagHH_GLOBAL_PROPERTY, HH_GLOBAL_PROPERTY
    id:                THHGPropID;
    Dummy:             Integer;                  // Added to enforce 8-byte packing
    var_:              VARIANT;
  end;
  HH_GLOBAL_PROPERTY = tagHH_GLOBAL_PROPERTY;
  THHGlobalProperty = tagHH_GLOBAL_PROPERTY;}
//[END OF HTMLHELP DECLARATIONS]
{$ENDIF WIN_GDI}

{$IFDEF WIN_GDI}
//[GetCtlBrush DECLARATIONS]
function SimpleGetCtlBrushHandle( Sender: PControl ): HBrush; 

var
  Global_GetCtlBrushHandle: function( Sender: PControl ): HBrush = SimpleGetCtlBrushHandle;
  {* Is called to obtain brush handle. }
{$ENDIF WIN_GDI}

  Global_Align: procedure( Sender: PObj ) = DummyObjProc;
  {* Is set to perform aligning of control, and only if property Align
     is changed for TControl, or SetAlign method is called for it. }

{$IFDEF WIN_GDI}
//[WndFunc DECLARATION]
function WndFunc( W: HWnd; Msg: Cardinal; wParam, lParam: Integer )
                                   : Integer; stdcall;
{* Global message handler for window. Redirects all messages to
   destination windows, obtaining target TControl object address from
   window itself, using GetProp API call. }
{$ENDIF WIN_GDI} //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//[Applet VARIABLES]
var AppletRunning: Boolean;
    {* Is set to True while message loop is processing (in Run procedure). }
    AppletTerminated: Boolean;
    {* Is set to True when message loop is terminated. }
    Applet: PControl;
    {* Applet window object. Actually, can be set to main form if program
       not needed in special applet button window (useful to make applet
       button invisible on taskbar, or to have several forms with single
       applet button - crete it in that case using NewApplet). }
    AppButtonUsed: Boolean;
    {* True if special window to represent applet button (may be invisible)
       is used. If no, every form is represented with its own taskbar button
       (always visible). }

{$IFDEF WIN_GDI} //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
//[Screen DECLARATIONS]
    ScreenCursor: HCursor;
    {* Set this global variable to override any cursor settings of current
       form or control. }

function ScreenWidth: Integer;
{* Returns screen width in pixels. }
function ScreenHeight: Integer;
{* Returns screen height in pixels. }

//[Status DECLARATIONS]
type
  TStatusOption = ( soNoSizeGrip, soTop );
  {* Options available for status bars. }
  TStatusOptions = Set of TStatusOption;
  {* Status bar options. }

procedure DrawFormattedText( Ctl: PControl; DC: HDC; var R: TRect; Flags: DWORD {EditCtl: Boolean} );
{* This procedure can be useful to draw control's text in custom-defined controls. }

{$IFDEF USE_GRAPHCTLS}

{$IFDEF GRAPHCTL_XPSTYLES}
var DoNotDrawGraphCtlsUsingXPStyles: Boolean;
procedure DrawFormattedTextXP( Theme: THandle; Ctl: PControl; DC: HDC;
  var R: TRect; CtlType, CtlStates, Flags1, Flags2: Integer );
{* This procedure can be useful to draw control's text in custom-defined controls. }
{$ENDIF}

function _NewGraphCtl( AParent: PControl; ATabStop: Boolean ): PControl;
{* Creates graphic control basics. }

function NewGraphLabel( AParent: PControl; const ACaption: AnsiString ): PControl;
{* Creates graphic label, which does not require a window handle. }

function NewWordWrapGraphLabel( AParent: PControl; const ACaption: KOLString ): PControl;
{* Creates graphic label, which does not require a window handle. }

function NewGraphPaintBox( AParent: PControl ): PControl;
{* Creates graphic paint box (just the same as graphic label, but with empty Caption). }

function NewGraphCheckBox( AParent: PControl; const ACaption: KOLString ): PControl;
{* Creates graphic checkbox. }

function NewGraphRadioBox( AParent: PControl; const ACaption: KOLString ): PControl;
{* Creates graphic radiobox. }

function NewGraphButton( AParent: PControl; const ACaption: KOLString ): PControl;
{* Creates graphic button. }

function NewGraphEditbox( AParent: PControl; Options: TEditOptions ): PControl;
{* Creates graphic edit box. To do editing, this box should be replaced with
   real edit box with a handle (actually, it is enough to place an edit box
   on the same Parent having the same BoundsRect). }
{$ENDIF USE_GRAPHCTLS}
{$ENDIF WIN_GDI}

//[Run DECLARATION]
procedure Run( var AppletWnd: PControl );
{* |<#appbutton>
   Call this procedure to process messages loop of your program.
   Pass here pointer to applet button object (if You have created it
   - see NewApplet) or your main form object of type PControl (created
   using NewForm).
     |<br><br>
     |<h1 align=center><font color=#FF8040><a name="visual_objects_constructors"></a>
       Visual objects constructing functions
     |</font></h1>
   Following constructing functions for visual controls are available:
   |#control
}

{$IFDEF WIN_GDI}

procedure TerminateExecution( var AppletWnd: PControl );

//[Applet FUNCTIONS DECLARATIONS]
procedure AppletMinimize;
{* Minimizes the application (Applet should be assigned to have effect). }
procedure AppletHide;
{* Minimizes and hides application. }
procedure AppletRestore;
{* Restores Applet when minimized. }

//[Idle handler DECALRATIONS]
{YS+}
procedure RegisterIdleHandler( const OnIdle: TOnEvent );
{* Registers new Idle handler. Idle handler is called each time when
   message queue becomes empty. }
procedure UnRegisterIdleHandler( const OnIdle: TOnEvent );
{* Unregisters Idle handler. }
{YS-}

//[InitCommonXXXX ANOTHER DECLARATIONS]

{* ComCtrl32 controls initialization. }
procedure InitCommonControls; stdcall;
procedure DoInitCommonControls( dwICC: DWORD );
{* Calls extended initialization for Common Controls (from ComCtrl32).
   Pass one of following constants:
   |<pre>
  ICC_LISTVIEW_CLASSES   = $00000001; // listview, header
  ICC_TREEVIEW_CLASSES   = $00000002; // treeview, tooltips
  ICC_BAR_CLASSES        = $00000004; // toolbar, statusbar, trackbar, tooltips
  ICC_TAB_CLASSES        = $00000008; // tab, tooltips
  ICC_UPDOWN_CLASS       = $00000010; // updown
  ICC_PROGRESS_CLASS     = $00000020; // progress
  ICC_HOTKEY_CLASS       = $00000040; // hotkey
  ICC_ANIMATE_CLASS      = $00000080; // animate
  ICC_WIN95_CLASSES      = $000000FF;
  ICC_DATE_CLASSES       = $00000100; // month picker, date picker, time picker, updown
  ICC_USEREX_CLASSES     = $00000200; // comboex
  ICC_COOL_CLASSES       = $00000400; // rebar (coolbar) control
  ICC_INTERNET_CLASSES   = $00000800;
  ICC_PAGESCROLLER_CLASS = $00001000; // page scroller
  ICC_NATIVEFNTCTL_CLASS = $00002000; // native font control
   |</pre>
    }

const
  ICC_LISTVIEW_CLASSES   = $00000001; // listview, header
  ICC_TREEVIEW_CLASSES   = $00000002; // treeview, tooltips
  ICC_BAR_CLASSES        = $00000004; // toolbar, statusbar, trackbar, tooltips
  ICC_TAB_CLASSES        = $00000008; // tab, tooltips
  ICC_UPDOWN_CLASS       = $00000010; // updown
  ICC_PROGRESS_CLASS     = $00000020; // progress
  ICC_HOTKEY_CLASS       = $00000040; // hotkey
  ICC_ANIMATE_CLASS      = $00000080; // animate
  ICC_WIN95_CLASSES      = $000000FF;
  ICC_DATE_CLASSES       = $00000100; // month picker, date picker, time picker, updown
  ICC_USEREX_CLASSES     = $00000200; // comboex
  ICC_COOL_CLASSES       = $00000400; // rebar (coolbar) control
  ICC_INTERNET_CLASSES   = $00000800;
  ICC_PAGESCROLLER_CLASS = $00001000; // page scroller
  ICC_NATIVEFNTCTL_CLASS = $00002000; // native font control

//[Ole DECLARATIONS]
function OleInit: Boolean;
{* Calls OleInitialize (once - all other calls are simulated by incrementing
   call counter. Every OleInit shoud be complemented with correspondent OleUninit.
   (Though, it is possible to call API function OleUnInitialize once to
   cancel all OleInit calls). }
procedure OleUnInit;
{* Decrements counter and calls OleUnInitialize when it is zeroed. }
var OleInitCount: Integer;
{-}

function StringToOleStr(const Source: Ansistring): PWideChar;
{* }

{+}
function SysAllocStringLen(psz: PWideChar; len: Integer): PWideChar; stdcall;
procedure SysFreeString( psz: PWideChar ); stdcall;

{$ENDIF WIN_GDI}
{ -- Contructors for visual controls -- }
//[NewXXXX DECLARATIONS]

//[_NewWindowed DECLARATION]
{$IFDEF GDI}
function _NewWindowed( AParent: PControl; ControlClassName: PKOLChar; Ctl3D: Boolean ): PControl;
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
function _NewWindowed( AParent: PControl; ControlClassName: PAnsiChar;
  widget: PGtkWidget; need_eventbox: Boolean ): PControl;
{$ENDIF GTK}
{$ENDIF _X_}

{$IFDEF WIN_GDI} //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
//[NewApplet DECLARATION]
function NewApplet( const Caption: KOLString ): PControl;
{* |<#control>
   Creates applet button window, which has to be parent of all other forms
   in your project (but this is *not must*). See also comments about NewForm.
   |<br>
   Following methods, properties and events are useful to work with applet
   control:
   |#appbutton }

{$ENDIF WIN_GDI}
//[NewForm DECLARATION]
function NewForm( AParent: PControl; const Caption: KOLString ): PControl;
{* |<#control>
   Creates form window object and returns pointer to it. If You use only one form,
   and You are not going to do applet button on task bar invisible, it is not
   necessary to create also special applet button window - just pass
   your (main) form object to Run procedure. In that case, it is a good
   idea to assign pointer to your main form object to Applet variable
   immediately following creating it - because some objects (e.g. TTimer)
   want to have Applet assigned to something.
   |<br>
   |&D=<a href="tcontrol.htm#%1" target=_top> %0 </a>
   Following methods, properties and events are useful to work with forms
   (ones common for all visual objects, such as <D Left>, <D Top>, <D Width>,
   <D Height>, etc. are not listed here - look TControl for it):
   |#form }

function NewAlienPanel( AParentWnd: HWnd; EdgeStyle: TEdgeStyle ): PControl;

//[_NewControl DECLARATION]
{$IFDEF GDI}
function _NewControl( AParent: PControl; ControlClassName: PKOLChar;
         Style: DWORD; Ctl3D: Boolean; Actions: PCommandActions ): PControl;
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
function _NewControl( AParent: PControl; ControlClassName: PAnsiChar;
         Style: DWORD; Ctl3D: Boolean; widget: PGtkWidget; need_eventbox: Boolean ): PControl;
{$ENDIF GTK}
{$ENDIF _X_}

//[NewButton DECLARATION]
function NewButton( AParent: PControl; const Caption: KOLString ): PControl;
{* |<#control>
   Creates button on given parent control or form.
   Please note, that in Windows, buttons can not change its <D Font> color
   and to be <D Transparent>.
   |<br> Following methods, properies and events are (especially) useful with
   a button:
   |#button }

{$IFDEF WIN_GDI} //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
//[NewBitBtn DECLARATION]
function NewBitBtn( AParent: PControl; const Caption: KOLString;
         Options: TBitBtnOptions; Layout: TGlyphLayout; GlyphBitmap: HBitmap; GlyphCount: Integer ): PControl;
{* |<#control>
   Creates image button (actually implemented as owner-drawn). In Options,
   it is possible to determine, whether bitmap or image list used to contain
   one or more (up to 5) images, correspondent to certain BitBtn state.
   |<br>&nbsp;&nbsp;&nbsp;
   For case of imagelist (option bboImageList), it is possible to use a
   number of glyphs from the image list, starting from image index given
   by GlyphCount parameter. Number of used glyphs is passed in that case
   in high word of GlyphCount parameter (if 0, one image is used therefore).
   For bboImageList, BitBtn can be Transparent (and in that case bboNoBorder
   style can be useful to draw custom buttons of non-rectangular shape).
   |<br>&nbsp;&nbsp;&nbsp;
   For case of bitmap BitBtn, image is stretched down (if too big), but can
   not be transparent. It is not necessary for bitmap BitBtn to pass correct
   GlyphCount - it is calculated on base of bitmap size, if 0 is passed.
   |<br>&nbsp;&nbsp;&nbsp;
   And, certainly, BitBtn can be without glyph image (text only). For that
   case, it is therefore is more flexible and power than usual Button (but
   requires more code). E.g., BitBtn can change its <D Font>, <D Color>,
   and to be totally <D Transparent>.
   Moreover, BitBtn can be <D Flat>, bboFixed, <D SpeedButton> and
   have property <D RepeatInterval>.
   |<br>&nbsp;&nbsp;&nbsp;
   Note: if You use bboFixed Style, use OnChange event instead of OnClick,
   because <D Checked> state is changed immediately however OnClick occure
   only when mouse or space key released (and can be not called at all if
   mouse button is released out of BitBtn bounds). Also, bboFixed defines
   only which glyph to show (the border if it is not turned off behaves as
   usual for a button, i.e. it becomes lowered and then raised again at any click).
   Here You can find references to other properties, events and methods
   applicable to BitBtn:
   |#bitbtn }

{$ENDIF GDI}
//[NewLabel DECLARATION]
function NewLabel( AParent: PControl; const Caption: KOLString ): PControl;
{* |<#control>
   Creates static text control (native Windows STATIC control).
   Use property <D Caption> at run time to change label text. Also
   it is possible to adjust label <D Font>, <D Brush> or <D Color>.
   Label can be <D Transparent>. If You want to have rotated text
   label, call NewLabelEffect instead and change its <D Font>.FontOrientation.
   Other references certain for a label:
   |#label }
{$IFDEF GDI}

//[NewWordWrapLabel DECLARATION]
function NewWordWrapLabel( AParent: PControl; const Caption: KOLString ): PControl;
{* |<#control>
   Creates multiline static text control (native Windows STATIC control),
   which can wrap long text onto several lines. See also NewLabel.
   See also:
   |#wwlabel
   |#label }

//[NewLabelEffect DECLARATION]
function NewLabelEffect( AParent: PControl; const Caption: KOLString; ShadowDeep: Integer ): PControl;
{* |<#control>
   Creates 3D-label with capability to rotate its text <D Caption>, which
   is controlled by changing <D Font>.FontOrientation property. If You want
   to get flat effect label (e.g. to rotate it only), pass <D ShadowDeep> = 0.
   Please note, that drawing procedure uses <D Canvas> property, so using of
   LabelEffect leads to increase size of executable.
   See also:
   |#3dlabel
   |#label }

{$ENDIF GDI}
//[NewPaintbox DECLARATION]
function NewPaintbox( AParent: PControl ): PControl;
{* |<#control>
   Creates owner-drawn STATIC control. Set its <D OnPaint> event to
   perform custom painting.
   |#paintbox }
{$IFDEF GDI}

//[NewImageShow DECLARATION]
function NewImageShow( AParent: PControl; AImgList: PImageList; ImgIdx: Integer ): PControl;
{* |<#control>
   Creates an image show control, implemented as a paintbox which is used to
   draw an image from the imagelist. At run-time, use property CurIndex to
   select another image from the imagelist, and a property ImageListNormal to
   use another image list. When the control is created, its size becomes
   equal to dimensions of imagelist (if any). }

//[NewScrollBar DECLARATION]
function NewScrollBar( AParent: PControl; BarSide: TScrollerBar ): PControl;
{* |<#control>
   Creates simple scroll bar. }

//[NewScrollBox DECLARATION]
function NewScrollBox( AParent: PControl; EdgeStyle: TEdgeStyle;
         Bars: TScrollerBars ): PControl;
{* |<#control>
   Creates simple scrolling box, which can be used any way you wish, e.g. to scroll
   certain large image. To provide automatic scrolling of a set of child controls,
   use advanced scroll box, created with NewScrollBoxEx. }

procedure NotifyScrollBox( Self_, Child: PControl );

function NewScrollBoxEx( AParent: PControl; EdgeStyle: TEdgeStyle ): PControl;
{* |<#control>
   Creates extended scrolling box control, which automatically scrolls child
   controls (if any). }

//[NewGradientPanel DECLARATION]
function NewGradientPanel( AParent: PControl; Color1, Color2: TColor ): PControl;
{* |<#control>
   Creates gradient-filled STATIC control. To adjust colors at the
   run time, change <D Color1> and <D Color2> properties (which initially are
   assigned from Color1, Color2 parameters), and call <D Invalidate> method
   to repaint control. }

function NewGradientPanelEx( AParent: PControl; Color1, Color2: TColor;
                             Style: TGradientStyle; Layout: TGradientLayout ): PControl;
{* |<#control>
   Creates gradient-filled STATIC control. To adjust colors at the
   run time, change <D Color1> and <D Color2> properties (which initially are
   assigned from Color1, Color2 parameters), and call <D Invalidate> method
   to repaint control. Depending on style and first line/point layout, can
   looking different. Idea: Vladimir Stojiljkovic. }

//[NewPanel DECLARATION]
function NewPanel( AParent: PControl; EdgeStyle: TEdgeStyle ): PControl;
{* |<#control>
   Creates panel, which can be parent for other controls (though, any
   control can be used as a parent for other ones, but panel is specially
   designed for such purpose). }

//[NewMDIxxx DECLARATIONS]
function NewMDIClient( AParent: PControl; WindowMenu: THandle ): PControl;
{* |<#control>
   Creates MDI client window, which is a special type of child window,
   containing all MDI child windows, created calling NewMDIChild function.
   On a form, MDI client behaves like a panel, so it can be placed and sized
   (or aligned) like any other controls. To minimize flick during resizing
   main form having another aligned controls, place MDI client window on
   a panel and align it caClient in the panel.
   |<br>Note:
   MDI client must be a single on the form. }

function NewMDIChild( AParent: PControl; const ACaption: KOLString ): PControl;
{* |<#control>
   Creates MDI client window. AParent should be a MDI client window,
   created with NewMDIClient function. }

//[NewSplitter DECLARATIONS]
function NewSplitter( AParent: PControl; MinSizePrev, MinSizeNext: Integer ): PControl;
{* |<#control>
   Creates splitter control, which will separate previous one (i.e. last
   created one before splitter on the same parent) from created
   next, allowing to user to adjust size of separated controls by dragging
   the splitter in desired direction. Created splitter becomes vertical
   or horizontal depending on Align style of previous control on the same
   parent (if caLeft/caRight then vertical, if caTop/caBottom then horizontal).
   |<br>&nbsp;&nbsp;&nbsp;
   Please note, what if previous control has no Align equal to caLeft/caRight
   or caTop/caBottom, splitter will not be able to function normally. If
   previous control does not exist, it is yet possible to use splitter as
   a resizeable panel (but set its initial Align value first - otherwise it
   is not set by default. Also, change Cursor property as You wish in that
   case, since it is not set too in case, when previous control does not
   exist).
   |<br>&nbsp;&nbsp;&nbsp;
   Additional parameters determine, which minimal size (width or height -
   correspondently to split direction) is allowed for left (top) control
   and to rest of client area of parent, correspondently. (It is possible
   later to set second control for checking its size with MinSizeNext
   value - using TControl.SecondControl property). If -1 passed,
   correspondent control size is not checked during dragging of splitter.
   Usually 0 is more suitable value (with this value, it is garantee, that
   splitter will be always available even if mouse was released far from the
   edge of form).
   |<br>&nbsp;&nbsp;&nbsp;
   It is possible for user to press Escape any time while dragging splitter
   to abort all adjustments made starting from left mouse button push and
   begin of drag the splitter. But remember please, that such event is
   controlled using timer, and therefore correspondent keyboard events
   are received by currently focused control. Be sure, that pressing Escape
   will not affect to any control on form, which could be focused, otherwise
   filter keyboard messages (by yourself) to prevent undesired handling of
   Escape key by certain controls while splitting. (Use Dragging property
   to check if splitter is dragging by user with mouse).
   |<br>&nbsp;&nbsp;&nbsp;
   See also:
   NewSplitterEx
   |#splitter }

function NewSplitterEx( AParent: PControl; MinSizePrev, MinSizeNext: Integer;
         EdgeStyle: TEdgeStyle ): PControl;
{* |<#control>
   Creates splitter control. Difference from NewSplitter is what it is possible
   to determine if a splitter will be beveled or not. See also NewSplitter. }

//[NewGroupbox DECLARATION]
function NewGroupbox( AParent: PControl; const Caption: KOLString ): PControl;
{* |<#control>
   Creates group box control. Note, that to group radio items, group
   box is not necessary - any parent can play role of group for radio items.
   See also NewPanel. }

//[NewCheckbox DECLARATION]
function NewCheckbox( AParent: PControl; const Caption: KOLString ): PControl;
{* |<#control>
   Creates check box control. Special properties, methods, events:
   |#checkbox }

function NewCheckBox3State( AParent: PControl; const Caption: KOLString ): PControl;
{* |<#control>
   Creates check box control with 3 states. Special properties, methods,
   events:
   |#checkbox }

//[NewRadiobox DECLARATION]
function NewRadiobox( AParent: PControl; const Caption: KOLString ): PControl;
{* |<#control>
   Creates radio box control. Alternative radio items must have the
   same parent window (regardless of its kind, either groupbox (NewGroupbox),
   panel (NewPanel) or form itself). Following properties, methods and events
   are specially for radiobox controls:
   |#radiobox }

//[NewEditbox DECLARATION]
function NewEditbox( AParent: PControl; Options: TEditOptions ): PControl;
{* |<#control>
   Creates edit box control. To create multiline edit box, similar to
   TMemo in VCL, apply eoMultiline in Options. Following properties, methods,
   events are special for edit controls:
   |#edit }

{$IFNDEF NOT_USE_RICHEDIT}
var FRichEditModule: Integer;
    RichEditClass: PKOLChar;

const RichEditLibnames: array[ 0..3 ] of PKOLChar =
      ( 'msftedit', 'riched20',
        'riched32', 'riched' );
      RichEditClasses: array[ 0..3 ] of PKOLChar =
      ( 'RichEdit50W', 'RichEdit20A',
        'RichEdit', 'RichEdit'  );
var   RichEditIdx: Byte = High( RichEditLibnames );

//[NewRichEdit DECLARATION]
function NewRichEdit( AParent: PControl; Options: TEditOptions ): PControl;
{* |<#control>
   Creates rich text edit control. A rich edit control is a window in which
   the user can enter and edit text. The text can be assigned character and
   paragraph formatting, and can include embedded OLE objects. Rich edit
   controls provide a programming interface for formatting text. However, an
   application must implement any user interface components necessary to make
   formatting operations available to the user.
   |<br>&nbsp;&nbsp;&nbsp;
   Note: eoPassword, eoMultiline options have no effect for RichEdit control.
   Some operations are supersided with special versions of those, created
   especially for RichEdit, but in some cases it is necessary to use
   another properties and methods, specially designed for RichEdit (see
   methods and properties, which names are starting from RE_...).
   |<br>&nbsp;&nbsp;&nbsp;
   Following properties, methods, events are special for edit controls:
   |#richedit
   }

function NewRichEdit1( AParent: PControl; Options: TEditOptions ): PControl;
{* |<#control>
   Like NewRichEdit, but to work with older RichEdit control version 1.0
   (window class 'RichEdit' forced to use instead of 'RichEdit20A', even
   if library RICHED20.DLL found and loaded successfully). One more
   difference - OleInit is not called, so the most of OLE capabilities
   of RichEdit could not working. }
{$ENDIF NOT_USE_RICHEDIT}

//[NewListbox DECLARATION]
function NewListbox( AParent: PControl; Options: TListOptions ): PControl;
{* |<#control>
   Creates list box control. Following properties, methods and events are
   special for Listbox:
   |#listbox }

//[NewCombobox DECLARATION]
function NewCombobox( AParent: PControl; Options: TComboOptions ): PControl;
{* |<#control>
   Creates new combo box control. Note, that it is not possible to align
   combobox caLeft or caRight: this can cause infinite recursion in the
   application.
   |<br>Following properties, methods and events are
   special for Combobox:
   |#combo }

//[_NewCommonControl DECLARATION]
function _NewCommonControl( AParent: PControl; ClassName: PKOLChar; Style: DWORD;
                            Ctl3D: Boolean; Actions: PCommandActions ): PControl;

//[NewProgressbar DECLARATION]
function NewProgressbar( AParent: PControl ): PControl;
{* |<#control>
   Creates progress bar control. Following properties are special for
   progress bar:
   |#progressbar
   See also NewProgressEx. }

function NewProgressbarEx( AParent: PControl; Options: TProgressbarOptions ): PControl;
{* |<#control>
   Can create progress bar with smooth style (progress is not segmented
   onto bricks) or/and vertical progress bar - using additional parameter.
   For list of properties, suitable for progress bars, see NewProgressbar. }

//[NewListVew DECLARATION]
function NewListView( AParent: PControl; Style: TListViewStyle; Options: TListViewOptions;
  ImageListSmall, ImageListNormal, ImageListState: PImageList ): PControl;
{* |<#control>
   Creates list view control. It is very powerful control, which can partially
   compensate absence of grid controls (in lvsDetail view mode). Properties,
   methods and events, special for list view control are:
   |#listview }

//[NewTreeView DECLARATION]
function NewTreeView( AParent: PControl; Options: TTreeViewOptions;
                      ImgListNormal, ImgListState: PImageList ): PControl;
{* |<#control>
   Creates tree view control. See tree view methods and properties:
   |#treeview }

//[NewTabControl DECLARATION]
function NewTabControl( AParent: PControl; const Tabs: array of PKOLChar; Options: TTabControlOptions;
         ImgList: PImageList; ImgList1stIdx: Integer ): PControl;
{* |<#control>
   Creates new tab control (like notebook). To place child control on a certain
   page of TabControl, use property Pages[ Idx ], for example:
   ! Label1 := NewLabel( TabControl1.Pages[ 0 ], 'Label1' );
   | &nbsp;&nbsp;&nbsp;
   To determine number of pages at run time, use property <D Count>;
   |<br> to determine which page is currently selected (or to change
   selection), use property <D CurIndex>;
   |<br> to feedback to switch between tabs assign your handler to OnSelChange
   event;
   |<br>Note, that by default, tab control is created with a border lowered to
   tab control's parent. To remove it, you can apply WS_EX_TRANSPARENT extended
   style (see TControl.ExStyle property), but painting of some child controls
   can be strange a bit in this case (no border drawing for edit controls was
   found, but not always...). You can also apply style WS_THICKFRAME (TControl.Style
   property) to make the border raised.
   |<br> Other methods and properties, suitable for tab control, are:
   |#tabcontrol }
{$IFNDEF OLD_ALIGN}
function NewTabEmpty( AParent: PControl; Options: TTabControlOptions;
         ImgList: PImageList ): PControl;
{* |<#control>
   Creates new empty tab control for using metods TC_Insert (to create Pages as Panel),
   or TC_InsertControl (if you want using your custom Pages).}
{$ENDIF}

//[NewToolbar DECLARATION]
function NewToolbar( AParent: PControl; Align: TControlAlign; Options: TToolbarOptions;
                     Bitmap: HBitmap; const Buttons: array of PKOLChar;
                     const BtnImgIdxArray: array of Integer ) : PControl;
{* |<#control>
   Creates toolbar control. Bitmap (if present) must contain images for all buttons
   excluding separators (defined by string '-' in Buttons array) and system images,
   otherwise last buttons will no have images at all. Image width for every button
   is assumed to be equal to Bitmap height (if last of "squares" has
   insufficient width, it will not be used). To define fixed buttons, use
   characters '+' or '-' as a prefix for button string (even empty). To
   create groups of (radio-)buttons, use also '!' follow '+' or '-'. (These rules
   are similar used in menu creation). To define drop down button, use (as
   first) prefix '^'. (Do not forget to set <D OnTBDropDown> event for this
   case). If You want to assign images to buttons not in the same order
   how these are placed in Bitmap (or You use system bitmap), define for every
   button (in BtnImgIdxArray array) indexes for every button (excluding
   separator buttons). Otherwise, it is possible to define index only for first
   button (e.g., [0]). It is also possible to change TBImages[ ] property
   for such purpose, or do the same in method TBSetBtnImgIdx).
   |<br>
   Following properties, methods and event are specially designed to work with
   toolbar control:
   |#toolbar
   |<br>&nbsp;&nbsp;&nbsp;
   If your project uses Align property to align controls, this can conflict with
   toolbar native aligning. To solve such problem, place toolbar to parent panel,
   which has its own Align property assigned to desired value.
   |<br>
   To create toolbar with buttons, drawn from top to bottom, instead from left
   to right, combine caLeft / caRight in Align parameter and style tboWrapable
   when create toolbar. To adjust width of vertically aligned toolbar, it is
   possible to call ResizeParentLeft for it. E.g.:

   ! P0 := NewPanel( W, esRaised ) .SetSize( 30, 0 ) .SetAlign( caLeft );
   ! //                            ^^^^^^^^^^^^^^^^^            //////
   !TB := NewToolbar( P0, caLeft, [ tboNoDivider, tboWrapable ], DWORD(-1),
   ! //                   //////                  ///////////
   !                  [ ' ', ' ', ' ', '-', ' ', ' ' ],
   !      [ STD_FILEOPEN ] ).ResizeParentRight;
   !//Note, that caLeft is *must*, and tboWrapable style too. SetSize for
   !//parent panel is not necessary, but only if ResizeParentRight is called
   !//than for Toolbar.
   |<br><br>
   One more note: if You create toolbar without text labels (passing ' ' for
   each button You add), include also option tboTextRight to fix incorrect
   sizing of buttons under Windows9x.
   |<br>
   And, certainly, if you use image lists rather then bitmap, all written
   above about Bitmap become absolutely incorrect.
   }

//[NewDateTimePicker DECLARATION]
function NewDateTimePicker( AParent: PControl; Options: TDateTimePickerOptions )
         : PControl;
{* |<#control>
   Creates date and time picker common control.
}

{ -- Constructor for Image List objet -- }

//[NewImageList DECLARATION]
function NewImageList( AOwner: PControl ): PImageList;
{* Constructor of TImageList object. Unlike other non-visual objects, image list
   can be parented by TControl object (but this does not *must*), and in that
   case it is destroyed automatically when its parent control is destroyed.
   Every control can have several TImageList objects, linked to a simple list.
   But if any TImageList object is destroyed, all following ones are destroyed
   too (at least, now I implemented it so). }

{$ENDIF WIN_GDI}

//[TIMER]
type
  TTimerKind = ( tkReal, tkProcess, tkProfiler ); // only for UNIX!
  {++}(*TTimer = class;*){--}
  PTimer = {-}^{+}TTimer;
{ ----------------------------------------------------------------------
                            TTimer object
----------------------------------------------------------------------- }
//[TTimer DEFINITION]
  TTimer = object( TObj )
  {* Easy timer incapsulation object. It uses separate topmost window,
     common for all timers in the application, to handle WM_TIMER message.
     This allows using timers in non-windowed application (but anyway it
     should contain message handling loop for a thread).
     |<br>
     Note: in UNIX, there are no special windows created, certainly. }
  protected
    fHandle : Integer;
    fEnabled: Boolean;
    fInterval: Integer;
    fOnTimer: TOnEvent;
    {$IFDEF LIN}
    {$IFNDEF GTK}
    {$IFNDEF QT}
    fPrev, fNext: PTimer; //    __ 
    fTimeStart: clock_t;
    fExpireNext: clock_t;
    fExpireTotal: Int64;
    fTimerHandled: Boolean;
    fResolution: Integer;
    fPeriodic: Boolean;
    fMultimedia: Boolean;
    {$ENDIF  QT}
    {$ENDIF  GTK}
    {$ENDIF}
    procedure SetEnabled(const Value: Boolean); {$IFDEF WIN} virtual; {$ENDIF}
    procedure SetInterval(const Value: Integer);
  protected
  {++}(*public*){--}
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* Destructor. }
  public
    property Handle : Integer read fHandle;
    {* Windows timer object handle. }
    property Enabled : Boolean read fEnabled write SetEnabled;
    {* True, is timer is on. Initially, always False. }
    property Interval : Integer read fInterval write SetInterval;
    {* Interval in milliseconds (1000 is default and means 1 second).
       Note: in UNIX, if an Interval can be set to a value large then 30 minutes,
       add a conditional definition SUPPORT_LONG_TIMER to the project options. }
    property OnTimer : TOnEvent read fOnTimer write fOnTimer;
    {* Event, which is called when time interval is over. }
    {$IFDEF LIN}
    {$IFNDEF GTK}
    {$IFNDEF QT}
    property Resolution: Integer read fResolution write fResolution; // dummy property, just for compatibility
    property Periodic: Boolean read fPeriodic write fPeriodic;
    {$ENDIF  QT}
    {$ENDIF  GTK}
    {$ENDIF LIN}
  end;
//[END OF TTimer DEFINITION]

//[NewTimer DECLARATION]
function NewTimer( Interval: Integer ): PTimer;
{* Constructs initially disabled timer with interval 1000 (1 second). }

{$IFDEF WIN}
//[MULTIMEDIA TIMER]
type
  {++}(*TMMTimer = class;*){--}
  PMMTimer = {-}^{+}TMMTimer;

//[TMMTimer DEFINITION]
  TMMTimer = object( TTimer )
  {* Multimedia timer incapsulation object. Does not require Applet or special
     window to handle it. System creates a thread for each high resolution
     timer, so using many such objects can degrade total PC performance. }
  protected
    FResolution: Integer;
    FPeriodic: Boolean;
    procedure SetEnabled(const Value: Boolean); {-}virtual;{+}{++}(*override;*){--}
  public
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* }
    property Resolution: Integer read FResolution write FResolution;
    {* Minimum timer resolution. The less the more accuracy (0 is exactly
       Interval milliseconds between timer shots). It is recommended to set
       this property greater to prevent entire system from reducing overhead.
       If you change this value, reset and then set Enabled again to apply
       changes. }
    property Periodic: Boolean read FPeriodic write FPeriodic;
    {* TRUE, if timer is periodic (default). Otherwise, timer is one-shot
       (set it Enabled every time in such case for each shot). If you change
       this property, reset and set Enabled property again to get effect. }
  end;
//[END OF TMMTimer DEFINITION]

//[NewMMTimer DECLARATION]
function NewMMTimer( Interval: Integer ): PMMTimer;
{* Creates multimedia timer object. Initially, it has Resolution = 0,
   Periodic = TRUE and Enabled = FALSE. Do not forget also to assign your
   event handler to OnTimer to do something on timer shot. }
{$ENDIF WIN}

{$IFDEF LIN}
function NewMMTimer( Interval: Integer ): PTimer;
{$ENDIF LIN}

{$IFDEF WIN_GDI} //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
{ -- TTrayIcon object -- }
//[TRAYICON]

type
  TOnTrayIconMouse = procedure( Sender: PObj; Message : Word ) of object;
  {* Event type to be called when Applet receives a message from an icon,
     added to the taskbar tray. }

  {++}(*TTrayIcon = class;*){--}
  PTrayIcon = {-}^{+}TTrayIcon;
{ ----------------------------------------------------------------------
                TTrayIcon - icon in tray area of taskbar
----------------------------------------------------------------------- }
//[TTrayIcon DEFINITION]
  TTrayIcon = object(TObj)
  {* Object to place (and change) a single icon onto taskbar tray. }
  protected
    FIcon: HIcon;
    FActive: Boolean;
    FTooltip: KOLString;
    FOnMouse: TOnTrayIconMouse;
    FControl: PControl;
    fAutoRecreate: Boolean;
    FNoAutoDeactivate: Boolean;
    FWnd: HWnd;
    procedure SetIcon(const Value: HIcon);
    procedure SetActive(const Value: Boolean);
    procedure SetTrayIcon( const Value : DWORD );
    procedure SetTooltip(const Value: KOLString);
    procedure SetAutoRecreate(const Value: Boolean);
  protected
  {++}(*public*){--}
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* Destructor. Use Free method instead (as usual). }
  public
    property Icon : HIcon read FIcon write SetIcon;
    {* Icon to be shown on taskbar tray. If not set, value of Active
       property has no effect. It is also possible to assign a value
       to Icon property after assigning True to Active to install
       icon first time or to replace icon with another one (e.g. to
       get animation effect).
       |<br>&nbsp;&nbsp;&nbsp;
       Previously allocated icon (if any) is not deleted using
       DeleteObject. This is normal for icons, loaded from resource
       (e.g., by LoadIcon API call). But if icon was created (e.g.) by
       CreateIconIndirect, your code is responsible for destroying
       of it). }
    property Active : Boolean read FActive write SetActive;
    {* Set it to True to show assigned Icon on taskbar tray. Default
       is False. Has no effect if Icon property is not assigned.
       TrayIcon is deactivated automatically when Applet is finishing
       (but only if Applet window is used as a "parent" for tray
       icon object). }
    property Tooltip : KOLString read FTooltip write SetTooltip;
    {* Tooltip string, showing automatically when mouse is moving
       over installed icon. Though "huge string" type is used, only
       first 63 characters are considered. Also note, that only in
       most recent versions of Windows multiline tooltips are supported. }
    property OnMouse : TOnTrayIconMouse read FOnMouse write FOnMouse;
    {* Is called then mouse message is taking place concerning installed
       icon. Only type of message can be obtained (e.g. WM_MOUSEMOVE,
       WM_LBUTTONDOWN etc.) }
    property AutoRecreate: Boolean read fAutoRecreate write SetAutoRecreate;
    {* If set to TRUE, auto-recreating of tray icon is proveded in case,
       when Explorer is restarted for some (unpredictable) reasons. Otherwise,
       your tray icon is disappeared forever, and if this is the single way
       to communicate with your application, the user nomore can achieve it. }
    property NoAutoDeactivate: Boolean read FNoAutoDeactivate write FNoAutoDeactivate;
    {* If set to true, tray icon is not removed from tray automatically on
       WM_CLOSE message receive by owner control. Set Active := FALSE in
       your code for such case before accepting closing the form. }
    property Wnd: HWnd read FWnd write FWnd;
    {* A window to use as a base window for tray icon messages. Overrides
       parent Control handle is assigned. Note, that if Wnd property used,
       message handling is not done automatically, and you should do this in
       your code, or at least for one tray icon object, call AttachProc2Wnd. }
    procedure AttachProc2Wnd;
    {* Call this method for a tray icon object in case if Wnd used rather then
       control. It is enough to call this method once for each Wnd used, even
       if several other tray icons are also based on the same Wnd. See also
       DetachProc2Wnd method. }
    procedure DetachProc2Wnd;
    {* Call this method to detach window procedure attached via AttachProc2Wnd.
       Do it once for a Wnd, used as a base to handle tray icon messages.
       Caution! If you do not call this method before destroying Wnd, the
       application will not functioning normally. }
  end;
  {* When You create invisible application, which should be represented by
     only the tray icon, prepare a handle for the window, resposible for
     messages handling. Remember, that window handle is created automatically
     only when a window is showing first time. If window's property Visible is
     set to False, You should to call CreateWindow manually.
     <br>
     There is a known bug exist with similar invisible tray-iconized applications.
     When a menu is activated in response to tray mouse event, if there was
     not active window, belonging to the application, the menu is not disappeared
     when mouse is clicked anywhere else. This bug is occure in Windows9x/ME.
     To avoid it, activate first your form window. This last window shoud have
     status visible (but, certainly, there are no needs to place it on visible
     part of screen - change its position, so it will not be visible for user,
     if You wish).
     <br>
     Also, to make your application "invisible" but until special event is occure,
     use Applet separate from the main form, and make for both Visible := False.
     This allows for You to make your form visible any time You wish, and without
     making application button visible if You do not wish.
  }
  {=     ,    
        ,   Handle  , 
       . ,  Handle   
        ,       .  
      Visible   FALSE,   CreateWindow .
     <br>
       BUG      
     .         ,
             .    Windows9x/ME.
        ,     ().  
        (, ,      
      ,       ).
     <br>
      ,    ,   ,   
     ,     TControl - 
      Applet,   FALSE   Visible.
  }
//[END OF TTrayIcon DEFINITION]

//[NewTrayIcon DECLARATION]
function NewTrayIcon( Wnd: PControl; Icon: HIcon ): PTrayIcon;
{* Constructor of TTrayIcon object. Pass main form or applet as Wnd
   parameter. }

//[JUST ONE]
{ -- JustOne -- }

type
  TOnAnotherInstance = procedure( const CmdLine: KOLString ) of object;
  {* Event type to use in JustOneNotify function. }

function JustOne( Wnd: PControl; const Identifier : AnsiString ) : Boolean;
{* Returns True, if this is a first instance. For all other instances
   (application is already running), False is returned. }

function JustOneNotify( Wnd: PControl; const Identifier : KOLString;
                        const aOnAnotherInstance: TOnAnotherInstance ) : Boolean;
{* Returns True, if this is a first instance. For all other instances
   (application is already running), False is returned. If handler
   aOnAnotherInstance passed, it is called (in first instance) every time
   when another instance of an application is started, receiving command
   line used to run it. }

{ -- string (mainly) utility procedures and functions. -- }

{$IFDEF GDI}
//[Message Box DECLARATIONS]
function MsgBox( const S: KOLString; Flags: DWORD ): DWORD;
{* Displays message box with the same title as Applet.Caption. If applet
   is not running, and Applet global variable is not assigned, caption
   'Error' is displayed (but actually this is not an error - the system
   does so, if nil is passed as a title).
   |<br>&nbsp;&nbsp;&nbsp;
   Returns ID_... result (correspondently to flags passed (MB_OK, MBYESNO,
   etc. -> ID_OK, ID_YES, ID_NO, etc.) }
procedure MsgOK( const S: KOLString );
{* Displays message box with the same title as Applet.Caption (or 'Error',
   if Applet is not running). }
function ShowMsg( const S: KOLString; Flags: DWORD ): DWORD;
{* Displays message box like MsgBox, but uses Applet.Handle as a parent
   (so the message has no button on a task bar). }
procedure ShowMessage( const S: KOLString );
{* Like ShowMsg, but has only styles MB_OK and MB_SETFOREGROUND. }
{$ENDIF GDI}
{$IFDEF WIN}
procedure SpeakerBeep( Freq: Word; Duration: DWORD );
{* On Windows NT, calls Windows.Beep. On Windows 9x, produces beep on speaker
   of desired frequency during given duration time (in milliseconds). }
{$ENDIF WIN}

{++}(*
function FormatMessage(dwFlags: DWORD; lpSource: Pointer; dwMessageId: DWORD; dwLanguageId: DWORD;
  lpBuffer: PAnsiChar; nSize: DWORD; Arguments: Pointer): DWORD; stdcall;
*){--}
function SysErrorMessage(ErrorCode: Integer): KOLString;
{* Creates and returns a string containing formatted system error message.
   It is possible then to display this message or write it to a log
   file, e.g.:
   !  ShowMsg( SysErrorMessage( GetLastError ) );

   |&R=<a name="%0"></a><font color=#FF8040><h1>%0</h1></font>
   <R 64-bit integer numbers>
}
{$ENDIF WIN_GDI}
//[I64 TYPE]
type
  I64 = record
  {* 64 bit integer record. Use it and correspondent functions below in KOL
     projects to avoid dependancy from Delphi version (earlier versions of
     Delphi had no Int64 type). }
    Lo, Hi: DWORD;
  end;
  PI64 = ^I64;
  {* }

{-}
{$IFNDEF _D4orHigher}
  Int64 = I64;
  PInt64 = PI64;
{$ENDIF}

function MakeInt64( Lo, Hi: DWORD ): I64;
{* }
function Int2Int64( X: Integer ): I64;
{* }
procedure IncInt64( var I64: I64; Delta: Integer );
{* I64 := I64 + Delta; }
procedure DecInt64( var I64: I64; Delta: Integer );
{* I64 := I64 - Delta; }
function Add64( const X, Y: I64 ): I64;
{* Result := X + Y; }
function Sub64( const X, Y: I64 ): I64;
{* Result := X - Y; }
function Neg64( const X: I64 ): I64;
{* Result := -X; }
function Mul64i( const X: I64; Mul: Integer ): I64;
{* Result := X * Mul; }
function Div64i( const X: I64; D: Integer ): I64;
{* Result := X div D; }
function Mod64i( const X: I64; D: Integer ): Integer;
{* Result := X mod D; }
function Sgn64( const X: I64 ): Integer;
{* Result := sign( X ); i.e.:
   |<br>
   if X < 0 then -1
   |<br>
   if X = 0 then 0
   |<br>
   if X > 0 then 1 }
function Cmp64( const X, Y: I64 ): Integer;
{* Result := sign( X - Y ); i.e.
   |<br>
   if X < Y then -1
   |<br>
   if X = Y then 0
   |<br>
   if X > Y then 1 }
function Int64_2Str( X: I64 ): AnsiString;
{* }
function Int64_2Hex( X: I64; MinDigits: Integer ): AnsiString;
{* }
function Str2Int64( const S: AnsiString ): I64;
{* }
function Int64_2Double( const X: I64 ): Double;
{* }
function Double2Int64( D: Double ): I64;
{*

  <R Floating point numbers>
}

const
  NAN = 0.0 / 0.0;
  Infinity =  1.0 / 0.0;
{+}
  {++}(*const NAN = 1e-100;*){--}

function IsNan(const AValue: Double): Boolean;
{* Checks if an argument passed is NAN. }
function IsInfinity(const AValue: Double): Boolean;
{* Checks if an argument passed is Infinite. }

function IntPower(Base: Extended; Exponent: Integer): Extended;
{* Result := Base ^ Exponent; }

function NextPowerOf2( n: DWORD ): DWORD;
{* 0->1, 1->1, 2->2, 3->4, 4->4, 5->8, ... }

//[String<->Double DECLARATIONS]
function Str2Double( const S: AnsiString ): Double;
{* }

function Str2Extended( const S: AnsiString ): Extended;
{* }

function Double2Str( D: Double ): AnsiString;
{* }
function Extended2Str( E: Extended ): AnsiString;
{* }
function Extended2StrDigits( D: Double; n: Integer ): AnsiString;
{* Converts floating point number to string, leaving exactly n digits
   following floating point. }

function Double2StrEx( D: Double ): AnsiString;
{* experimental, do not use }

function TruncD( D: Double ): Double;
{* Result := trunc( D ) as Double;
|<hr>

  <R Small bit arrays (max 32 bits in array)>
  See also TBits object.
}

function IfThenElseBool( t, e, Cond: Boolean ): Boolean;
function IfThenElseInt( t, e: Integer; Cond: Boolean ): Integer;
function IfThenElseStr( const t, e: AnsiString; Cond: Boolean ): AnsiString;
{$IFDEF _D5orHigher}
function IfThenElse( t, e: Boolean; Cond: Boolean ): Boolean; overload;
function IfThenElse( t, e: Integer; Cond: Boolean ): Integer; overload;
function IfThenElse( t, e: AnsiString; Cond: Boolean ): AnsiString; overload;
function IfThenElse( t, e: Double; Cond: Boolean ): Double; overload;
{$ENDIF}

//[SMALL BIT ARRAYS DECLARATIONS]
function GetBits( N: DWORD; first, last: Byte ): DWord;
{* Retuns bits straing from <first> and to <last> inclusively. }
function GetBitsL( N: DWORD; from, len: Byte ): DWord;
{* Retuns len bits starting from index <from>.
|<hr>

  <R Arithmetics, geometry and other utility functions>

  See also units KolMath.pas, CplxMath.pas and Err.pas.
}
//[MulDiv DECLARATION]
{$IFNDEF FPC}
function MulDiv( A, B, C: Integer ): Integer;
{* Returns A * B div C. Small and fast. }
{$ENDIF}

//[TMethod TYPE]
type
///////////////////////////////////////////
{$ifndef _D6orHigher}                    //
///////////////////////////////////////////
   TMethod = packed record
   {* Is defined here because using of VCL classes.pas unit is
      not recommended in XCL. This record type is used often
      to set/access event handlers, referring to a procedure
      of object (usually to set such event to an ordinal
      procedure setting Data field to nil. }
    Code: Pointer; // Pointer to method code.
    {* If used to fake assigning to event handler of type 'procedure
       of object' with ordinal procedure pointer, use symbol '@'
       before method:
       |<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font face="Courier"><b>
       |    Method.Code := @MyProcedure;
       |</b></font> }
    Data: Pointer; // Pointer to object, owning the method.
    {* To fake event of type 'procedure of object' with setting it to
       ordinal procedure assign here NIL; }
   end;
   {* When assigning TMethod record to event handler, typecast it with
      desired event type, e.g.:
      |<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font face="Courier"><b>
      |     SomeObject.OnSomeEvent := TOnSomeEvent( Method );
      |</b></font><br> }
///////////////////////////////////////////
{$endif}                                 //
///////////////////////////////////////////
   PMethod = ^TMethod;
   {* }

   function MakeMethod( Data, Code: Pointer ): TMethod;
   {* Help function to construct TMethod record. Can be useful to
      assign regular type procedure/function as event handler for
      event, defined as object method (do not forget, that in that
      case it must have first dummy parameter to replace @Self,
      passed in EAX to methods of object). }

//[Rectangles&Points DECLARATIONS]
   function MakeRect( Left, Top, Right, Bottom: Integer ): TRect; stdcall;
   {* Use it instead of VCL Rect function }
   function RectsEqual( const R1, R2: TRect ): Boolean;
   {* Returns True if rectangles R1 and R2 have the same bounds }
   function RectsIntersected( const R1, R2: TRect ): Boolean;
   {* Returns TRUE if rectangles R1 and R2 have at least one common point.
      Note, that right and bottom bounds of rectangles are not their part,
      so, if such points are lying on that bounds, FALSE is returned. }
   function PointInRect( const P: TPoint; const R: TRect ): Boolean;
   {* Returns True if point P is located in rectangle R (including
      left and top bounds but without right and bottom bounds of the
      rectangle). }
   function OffsetPoint( const T: TPoint; dX, dY: Integer ): TPoint;
   {* }
   function OffsetSmallPoint( const T: TSmallPoint; dX, dY: SmallInt ): TSmallPoint;
   {* }
   function Point2SmallPoint( const T: TPoint ): TSmallPoint;
   {* }
   function SmallPoint2Point( const T: TSmallPoint ): TPoint;
   {* }
   function MakePoint( X, Y: Integer ): TPoint;
   {* Use instead of VCL function Point }
   function MakeSmallPoint( X, Y: Integer ): TSmallPoint;
   {* Use to construct TSmallPoint }
//[MakeFlags DECLARATION]
   function MakeFlags( FlgSet: PDWORD; FlgArray: array of Integer): Integer;
   {* }

  function MakeDateTimeRange( D1, D2: TDateTime ): TDateTimeRange;
  {* Returns TDateTimeRange from two TDateTime bounds. }

//[Integer FUNCTIONS DECLARATIONS]
   procedure Swap( var X, Y: Integer );
   {* exchanging values }
   function Min( X, Y: Integer ): Integer;
   {* minimum of two integers }
   function Max( X, Y: Integer ): Integer;
   {* maximum of two integers }
{$IFDEF REDEFINE_ABS}
   function Abs( X: Integer ): Integer;
   {* absolute value }
{$ENDIF}
   function Sgn( X: Integer ): Integer;
   {* sign of X: if X < 0, -1 is returned, if > 0, then +1, otherwise 0. }
   function iSqrt( X: Integer ): Integer;
   {* square root }
   function iCbrt( X: DWORD ): Integer;
   {* cubic root
   |<hr>

  <R String to number and number to string conversions>
}
//[Integer<->String DECLARATIONS]
function Int2Hex( Value : DWord; Digits : Integer ) : AnsiString;
{* Converts integer Value into string with hex number. Digits parameter
   determines minimal number of digits (will be completed by adding
   necessary number of leading zeroes). }
function Int2Str( Value : Integer ) : AnsiString;
{* Obvious. }
procedure Int2PChar( s: PAnsiChar; Value: Integer );
{* Converts Value to string and puts it into buffer s. Buffer must have
   enough size to store the number converted: buffer overflow does
   not checked anyway! }
function UInt2Str( Value: DWORD ): AnsiString;
{* The same as Int2Str, but for unsigned integer value. }
function Int2StrEx( Value, MinWidth: Integer ): AnsiString;
{* Like Int2Str, but resulting string filled with leading spaces to provide
   at least MinWidth characters. }
function Int2Rome( Value: Integer ): AnsiString;
{* Represents number 1..8999 to Rome numer. }
function Int2Ths( I : Integer ) : AnsiString;
{* Converts integer into string, separating every three digits from each
   other by character ThsSeparator. (Convert to thousands). You  }
function Int2Digs( Value, Digits : Integer ) : AnsiString;
{* Converts integer to string, inserting necessary number of leading zeroes
   to provide desired length of string, given by Digits parameter. If
   resulting string is greater then Digits, string is not truncated anyway. }
function Num2Bytes( Value : Double ) : AnsiString;
{* Converts double float to string, considering it as a bytes count.
   If Value is sufficiently large, number is represented in kilobytes (with
   following letter K), or in megabytes (M), gigabytes (G) or terabytes (T).
   Resulting string number is truncated to two decimals (.XX) or to one (.X),
   if the second is 0. }
function S2Int( S: PAnsiChar ): Integer;
{* Converts null-terminated string to Integer. Scanning stopped when any
   non-digit character found. Even empty string or string not containing
   valid integer number silently converted to 0. }
function Str2Int(const Value : AnsiString) : Integer;
{* Converts string to integer. First character, which can not be
   recognized as a part of number, regards as a separator. Even
   empty string or string without number silently converted to 0. }
function Hex2Int( const Value : AnsiString) : Integer;
{* Converts hexadecimal number to integer. Scanning is stopped
   when first non-hexadicimal character is found. Leading dollar ('$')
   character is skept (if present). Minus ('-') is not concerning as
   a sign of number and also stops scanning.}
function cHex2Int( const Value : AnsiString) : Integer;
{* As Hex2Int, but also checks for leading '0x' and skips it. }
function Octal2Int( const Value: AnsiString ) : Integer;
{* Converts octal number to integer. Scanning is stopped on first
   non-octal digit (any char except 0..7). There are no checking if
   there octal numer in the parameter. If the first char is not octal
   digit, 0 is returned. }
function Binary2Int( const Value: AnsiString ) : Integer;
{* Converts binary number to integer. Like Octal2Int, but only digits
   0 and 1 are allowed. }
type Radix_int = {$IFDEF _D5orHigher} Int64 {$ELSE} Integer {$ENDIF};
function ToRadix( number: Radix_int; radix, min_digits: Integer ): KOLString;
{* Converts unsigned number to string representing it literally in a numeric
   base given by radix parameter. }
function FromRadixStr( var Rslt: Radix_int; s: PKOLChar; radix: Integer ): PKOLChar;
{* Converts unsigned number from string representation in a numeric base given by
   a radix parameter. Returns a pointer to a character next to the last digit of
   the number. }
function FromRadix( const s: AnsiString; radix: Integer ): Radix_int;
{* Converts unsigned number from string representation in a numeric base given by
   a radix parameter. See also: FromRadixStr function. }
function InsertSeparators( const s: KOLString; chars_between: Integer;
    Separator: KOLChar ): KOLString;
{* Inserts given Separator between symbols in s, separating each portion of
   chars_between characters with a Separator starting from right side. See also:
   Int2Ths function. }
{$IFDEF WIN}
{$IFNDEF _FPC}
function Format( const fmt: KOLString; params: array of const ): KOLString;
{* Uses API call to wvsprintf, so does not understand extra formats,
   such as floating point, date/time, currency conversions. See list of
   available formats in win32.hlp (topic wsprintf).
|<hr>

   <R Working with null-terminated and ansi strings>
}
{$ENDIF _FPC}
{$ENDIF WIN}
//[String FUNCTIONS DECLARATIONS]
function StrComp(const Str1, Str2: PAnsiChar): Integer;
{* Compares two strings fast. -1: Str1<Str2; 0: Str1=Str2; +1: Str1>Str2 }
{$IFDEF SMALLER_CODE}
function StrComp_NoCase(const Str1, Str2: PAnsiChar): Integer;
{* Compares two strings fast without case sensitivity.
   Returns: -1 when Str1<Str2; 0 when Str1=Str2; +1 when Str1>Str2 }
function StrLComp_NoCase(const Str1, Str2: PAnsiChar; MaxLen: Cardinal): Integer;
{* Compare two strings fast without case sensitivity.
   Terminating 0 is not considered, so if strings are equal,
   comparing is continued up to MaxLen bytes.
   Since this, pass minimum of lengths as MaxLen. }
{$ELSE}
function StrComp_NoCase1(const Str1, Str2: PAnsiChar): Integer;
var StrComp_NoCase: function(const Str1, Str2: PAnsiChar): Integer = StrComp_NoCase1;
{* Compares two strings fast without case sensitivity.
   Returns: -1 when Str1<Str2; 0 when Str1=Str2; +1 when Str1>Str2 }
function StrLComp_NoCase1(const Str1, Str2: PAnsiChar; MaxLen: Cardinal): Integer;
var StrLComp_NoCase: function(const Str1, Str2: PAnsiChar; MaxLen: Cardinal): Integer = StrLComp_NoCase1;
{$ENDIF}

function StrLComp(const Str1, Str2: PAnsiChar; MaxLen: Cardinal): Integer;
{* Compare two strings (fast). Terminating 0 is not considered, so if
   strings are equal, comparing is continued up to MaxLen bytes.
   Since this, pass minimum of lengths as MaxLen. }

function StrCopy( Dest, Source: PAnsiChar ): PAnsiChar;
{* Copy source string to destination (fast). Pointer to Dest is returned. }
function StrCat( Dest, Source: PAnsiChar ): PAnsiChar;
{* Append source string to destination (fast). Pointer to Dest is returned. }
function StrLen(const Str: PAnsiChar): Cardinal;
{* StrLen returns the number of characters in Str, not counting the null
  terminator. }
function StrScanLen(Str: PAnsiChar; Chr: AnsiChar; Len: Integer): PAnsiChar;
{* Fast scans string Str of length Len searching character Chr.
   Pointer to a character next to found or to Str[Len] (if no one found)
   is returned. }
function StrScan(Str: PAnsiChar; Chr: AnsiChar): PAnsiChar;
{* Fast search of given character in a string. Pointer to found character
   (or nil) is returned. }
function StrRScan(const Str: PAnsiChar; Chr: AnsiChar): PAnsiChar;
{* StrRScan returns a pointer to the last occurrence of Chr in Str. If Chr
  does not occur in Str, StrRScan returns NIL. The null terminator is
  considered to be part of the string. }
function StrIsStartingFrom( Str, Pattern: PKOLChar ): Boolean;
{* Returns True, if string Str is starting from Pattern, i.e. if
   Copy( Str, 1, StrLen( Pattern ) ) = Pattern. Str must not be nil! }
function StrIsStartingFromNoCase( Str, Pattern: PAnsiChar ): Boolean;
{* Like StrIsStartingFrom above, but without case sensitivity. }
function TrimLeft(const S: KOLString): KOLString;
{* Removes spaces, tabulations and control characters from the starting
   of string S. }
function TrimRight(const S: KOLString): KOLString;
{* Removes spaces, tabulates and other control characters from the
   end of string S. }
function Trim( const S : KOLString): KOLString;
{* Makes TrimLeft and TrimRight for given string. }
function RemoveSpaces( const S: KOLString ): KOLString;
{* Removes all characters less or equal to ' ' in S and returns it. }
procedure Str2LowerCase( S: PAnsiChar );
{* Converts null-terminated string to lowercase (inplace). }
function LowerCase(const S: Ansistring): Ansistring;
{* Obvious. }
function UpperCase(const S: Ansistring): Ansistring;
{* Obvious. }
function AnsiUpperCase(const S: Ansistring): Ansistring;
{* Obvious. }
function AnsiLowerCase(const S: Ansistring): Ansistring;
{* Obvious. }
{$IFNDEF _D2}
{$IFNDEF _FPC}
function WAnsiUpperCase(const S: WideString): WideString;
{* Obvious. }
function WAnsiLowerCase(const S: WideString): WideString;
{* Obvious. }
function WStrComp(const S1, S2: WideString): Integer;
{* }
function _WStrComp(S1, S2: PWideChar): Integer;
{* }
function WStrScan(Str: PWideChar; Chr: WideChar): PWideChar;
{* Fast search of given character in a string. Pointer to found character
   (or nil) is returned. }
function WStrRScan(const Str: PWideChar; Chr: WideChar): PWideChar;
{* StrRScan returns a pointer to the last occurrence of Chr in Str. If Chr
  does not occur in Str, StrRScan returns NIL. The null terminator is
  considered to be part of the string. }
{$ENDIF _FPC}
{$ENDIF _D2}
//--- set of functions to work either with AnsiString or with WideString
//    depending on UNICODE_CTRLS symbol ----------------------------------------
function AnsiCompareStr(const S1, S2: KOLString): Integer;
{* AnsiCompareStr compares S1 to S2, with case-sensitivity. The compare
  operation is controlled by the current Windows locale. The return value
  is the same as for CompareStr. }
function _AnsiCompareStr(S1, S2: PKOLChar): Integer;
{* The same, but for PChar ANSI strings }
function AnsiCompareStrNoCase(const S1, S2: KOLString): Integer;
{* AnsiCompareStr compares S1 to S2, with case-sensitivity. The compare
  operation is controlled by the current Windows locale. The return value
  is the same as for CompareStr. }
function _AnsiCompareStrNoCase(S1, S2: PKOLChar): Integer;
{* The same, but for PChar ANSI strings }
function AnsiCompareText( const S1, S2: KOLString ): Integer;
{* }
function AnsiEq( const S1, S2 : KOLString ) : Boolean;
{* Returns True, if AnsiLowerCase(S1) = AnsiLowerCase(S2). I.e., if ANSI
   stringsare equal to each other without caring of characters case
   sensitivity. }

//--- set of functions to work always with AnsiString
//    even if UNICODE_CTRLS symbol is defined ----------------------------------
function AnsiCompareStrA(const S1, S2: AnsiString): Integer;
{* AnsiCompareStr compares S1 to S2, with case-sensitivity. The compare
  operation is controlled by the current Windows locale. The return value
  is the same as for CompareStr. }
function _AnsiCompareStrA(S1, S2: PAnsiChar): Integer;
{* The same, but for PChar ANSI strings }
function AnsiCompareStrNoCaseA(const S1, S2: AnsiString): Integer;
{* AnsiCompareStr compares S1 to S2, with case-sensitivity. The compare
  operation is controlled by the current Windows locale. The return value
  is the same as for CompareStr. }
function _AnsiCompareStrNoCaseA(S1, S2: PAnsiChar): Integer;
{* The same, but for PChar ANSI strings }
function AnsiCompareTextA( const S1, S2: AnsiString ): Integer;
{* }

{$IFDEF WIN}
{$IFNDEF _FPC}
function LStrFromPWCharLen(Source: PWideChar; Length: Integer): AnsiString;
{* from Delphi5 - because D2 does not contain it. }
function LStrFromPWChar(Source: PWideChar): AnsiString;
{* from Delphi5 - because D2 does not contain it. }
{$ENDIF _FPC}
function WCharIn( C: KOLChar; const Chars: array of KOLChar ): Boolean;
{$ENDIF WIN}

function CopyEnd( const S : KOLString; Idx : Integer ) : KOLString;
{* Returns copy of source string S starting from Idx up to the end of
   string S. Works correctly for case, when Idx > Length( S ) (returns
   empty string for such case). }
function CopyTail( const S : KOLString; Len : Integer ) : KOLString;
{* Returns last Len characters of the source string. If Len > Length( S ),
   entire string S is returned. }
procedure DeleteTail( var S : KOLString; Len : Integer );
{* Deletes last Len characters from string. }
function IndexOfChar( const S : KOLString; Chr : KOLChar ) : Integer;
{* Returns index of given character (1..Length(S)), or
   -1 if a character not found. }
function IndexOfCharsMin( const S, Chars : KOLString ) : Integer;
{* Returns index (in string S) of those character, what is taking place
   in Chars string and located nearest to start of S. If no such
   characters in string S found, -1 is returned. }
{$IFNDEF _D2}
{$IFNDEF _FPC}
function IndexOfWideCharsMin( const S, Chars : WideString ) : Integer;
{* Returns index (in wide string S) of those wide character, what
   is taking place in Chars wide string and located nearest to start of S.
   If no such characters in string S found, -1 is returned. }
{$ENDIF _FPC}
{$ENDIF _D2}

function IndexOfStr( const S, Sub : KOLString ) : Integer;
{* Returns index of given substring in source string S. If found,
   1..Length(S)-Length(Sub), if not found, -1. }
function Parse( var S : KOLString; const Separators : KOLString ) : KOLString;
{* Returns first characters of string S, separated from others by
   one of characters, taking place in Separators string, assigning
   a tail of string (after found separator) to source string. If
   no separator characters found, source string S is returned, and
   source string itself becomes empty. }
{$IFNDEF _FPC}
{$IFNDEF _D2}
function WParse( var S : WideString; const Separators : WideString ) : WideString;
{* Returns first wide characters of wide string S, separated from others
   by one of wide characters, taking place in Separators wide string,
   assigning a tail of wide string (following found separator) to the
   source one. If there are no separator characters found, source wide
   string S is returned, and source wide string itself becomes empty. }
{$ENDIF _D2}
{$ENDIF _FPC}
function ParsePascalString( var S : AnsiString; const Separators : AnsiString ) : AnsiString;
{* Returns first characters of string S, separated from others by
   one of characters, taking place in Separators string, assigning
   a tail of string (after the found separator) to source string. If
   there are no separator characters found, the source string S is returned,
   and the source string itself becomes empty. Additionally: if the first (after
   a blank space) is the quote "'" or '#', pascal string is assumung first
   and is converted to usual string (without quotas) before analizing
   of other separators. }
function String2PascalStrExpr( const S : AnsiString ) : AnsiString;
{* Converts string to Pascal-like string expression (concatenation of
   strings with quotas and characters with leading '#'). }
function StrEq( const S1, S2 : AnsiString ) : Boolean;
{* Returns True, if LowerCase(S1) = LowerCase(S2). I.e., if strings
   are equal to each other without caring of characters case sensitivity
   (ASCII only). }
{$IFNDEF _D2}
{$IFNDEF _FPC}
function WAnsiEq( const S1, S2 : WideString ) : Boolean;
{* Returns True, if AnsiLowerCase(S1) = AnsiLowerCase(S2). I.e., if ANSI
   stringsare equal to each other without caring of characters case
   sensitivity. }
{$ENDIF _FPC}
{$ENDIF _D2}

function StrIn( const S : AnsiString; const A : array of String ) : Boolean;
{* Returns True, if S is "equal" to one of strings, taking place
   in A array. To check equality, StrEq function is used, i.e.
   comaprison is taking place without case sensitivity. }
{$IFNDEF _FPC}
type TSetOfChar = Set of AnsiChar;
{$IFNDEF _D2}
function WStrIn( const S : WideString; const A : array of WideString ) : Boolean;
{* Returns True, if S is "equal" to one of strings, taking place
   in A array. To check equality, WAnsiEq function is used, i.e.
   comaprison is taking place without case sensitivity. }
function CharIn( C: KOLChar; const A: TSetOfChar ): Boolean;
{* To replace expressions like S[1] in [ '0'..'z' ] to CharIn( S[ 1 ], [ '0'..'z' ] )
   (and to avoid problems with Unicode version of code). }
{$ENDIF _D2}
{$ENDIF _FPC}
function StrIs( const S : AnsiString; const A : Array of AnsiString; var Idx: Integer ) : Boolean;
{* Returns True, if S is "equal" to one of strings, taking place
   in A array, and in such Case Idx also is assigned to an index of A element
   equal to S. To check equality, StrEq function is used, i.e.
   comaprison is taking place without case sensitivity. }
function IntIn( Value: Integer; const List: array of Integer ): Boolean;
{* Returns TRUE, if Value is found in a List. }
function _StrSatisfy( S, Mask : PKOLChar ) : Boolean;
{* }
function _2StrSatisfy( S, Mask: PKOLChar ): Boolean;
{* }
function StrSatisfy( const S, Mask : KOLString ) : Boolean;
{* Returns True, if S is satisfying to a given Mask (which can contain
   wildcard symbols '*' and '?' interpeted correspondently as 'any
   set of characters' and 'single any character'. If there are no
   such wildcard symbols in a Mask, result is True only if S is maching
   to Mask string.) }
function StrReplace( var S: AnsiString; const From, ReplTo: AnsiString ): Boolean;
{* Replaces first occurance of From to ReplTo in S, returns True,
   if pattern From was found and replaced. }
function KOLStrReplace( var S: KOLString; const From, ReplTo: KOLString ): Boolean;
{* Replaces first occurance of From to ReplTo in S, returns True,
   if pattern From was found and replaced. }
{$IFNDEF _FPC}
{$IFNDEF _D2}
function WStrReplace( var S: WideString; const From, ReplTo: WideString ): Boolean;
{* Replaces first occurance of From to ReplTo in S, returns True,
   if pattern From was found and replaced. See also function StrReplace.
   This function is not available in Delphi2 (this version of Delphi
   does not support WideString type). }
{$ENDIF _D2}
{$ENDIF _FPC}

function StrRepeat( const S: AnsiString; Count: Integer ): AnsiString;
{* Repeats given string Count times. E.g., StrRepeat( 'A', 5 ) gives 'AAAAA'. }
{$IFNDEF _FPC}
{$IFNDEF _D2}
function WStrRepeat( const S: WideString; Count: Integer ): WideString;
{* Repeats given wide string Count times. E.g., StrRepeat( 'A', 5 ) gives 'AAAAA'. }
{$ENDIF _D2}
{$ENDIF _FPC}

procedure NormalizeUnixText( var S: AnsiString );
{* In the string S, replaces all occurances of character #10 (without leading #13)
   to the character #13. }
procedure Koi8ToAnsi( s: PAnsiChar );
{* Converts Koi8 text to Ansi (in place) }

function StrPCopy(Dest: PAnsiChar; const Source: Ansistring): PAnsiChar;
{* Copyes Pascal-style string into null-terminaed one. }
function StrLCopy(Dest: PAnsiChar; const Source: PAnsiChar; MaxLen: Cardinal): PAnsiChar;
{* Copyes first MaxLen characters of Pascal-style string into
   null-terminated one. }

function DelimiterLast( const Str, Delimiters: KOLString ): Integer;
{* Returns index of the last of delimiters given by same named parameter
   among characters of Str. If there are no delimiters found, length of
   Str is returned. This function is intended mainly to use in filename
   parsing functions. }
function __DelimiterLast( Str, Delimiters: PKOLChar ): PKOLChar;
{* Returns address of the last of delimiters given by Delimiters parameter
   among characters of Str. If there are no delimeters found, position of
   the null terminator in Str is returned. This function is intended
   mainly to use in filename parsing functions. }
{$IFDEF _D3orHigher}
function W__DelimiterLast( Str, Delimiters: PWideChar ): PWideChar;
{* }
{$ENDIF _D3orHigher}
function SkipSpaces( P: PKOLChar ): PKOLChar;
{* Skips all characters #1..' ' in a string.
}
{$IFDEF F_P}
function DummyStrFun( const S: AnsiString ): AnsiString;
{$ENDIF}

//[Memory FUNCTIONS DECLARATIONS]
function CompareMem(P1, P2: Pointer; Length: Integer): Boolean;
{* Fast compare of two memory blocks. }
function AllocMem( Size : Integer ) : Pointer;
{* Allocates global memory and unlocks it. }
procedure DisposeMem( var Addr : Pointer );
{* Locks global memory block given by pointer, and frees it.
   Does nothing, if the pointer is nil.
   |<hr>

  <R Text in clipboard operations>
}
{$IFDEF WIN_GDI}

//[clipboard FUNCTIONS DECLARATIONS]
function ClipboardHasText: Boolean;
{* Returns true, if the clipboard contain text to paste from. }
function Clipboard2Text: AnsiString;
{* If clipboard contains text, this function returns it for You. }
{$IFNDEF _FPC}
{$IFNDEF _D2}
function Clipboard2WText: WideString;
{* If clipboard contains text, this function returns it for You (as Unicode string). }
{$ENDIF _D2}
{$ENDIF _FPC}
function Text2Clipboard( const S: AnsiString ): Boolean;
{* Puts given string to a clipboard. }
{$IFNDEF _FPC}
{$IFNDEF _D2}
function WText2Clipboard( const WS: WideString ): Boolean;
{* Puts given Unicode string to a clipboard.
|<hr>
}
{$ENDIF _D2}
{$ENDIF _FPC}

//[Mnemonics FUNCTIONS DECLARATIONS]
var SearchMnemonics: function ( const S: KOLString ): KOLString
    = {$IFDEF F_P} DummyStrFun {$ELSE}
    {$IFDEF UNICODE_CTRLS} WAnsiUpperCase {$ELSE} AnsiUpperCase {$ENDIF} {$ENDIF};
    MnemonicsLocale: Integer;

procedure SupportAnsiMnemonics( LocaleID: Integer );
{* Provides encoding to work with given locale. Call this global function to
   extend TControl.SupportMnemonics capability (also should be called for a form
   or for Applet variable).

   <R Date and time handling>
}
{$ENDIF WIN_GDI}
{$IFDEF WIN_GDI}
//[TDateTime TYPE DEFINITION]
type
  //TDateTime = Double; // well, it is already defined so in System.pas
  {* Basic date and time type. Integer part represents year and days (as is,
     i.e. 1-Jan-2000 is representing by value 730141, which is a number of
     days from 1-Jan-0001 to 1-Jan-2000 inclusively). Fractional part is
     representing hours, minutes, seconds and milliseconds of a day
     proportionally (like in VCL TDateTime type, e.g. 0.5 = 12:00, 0.25 = 6:00,
     etc.). }

  PDayTable = ^TDayTable;
  TDayTable = array[1..12] of Word;

  TDateFormat = ( dfShortDate, dfLongDate );
  {* Date formats available to use in formatting date/time to string. }
  TTimeFormatFlag = ( tffNoMinutes, tffNoSeconds, tffNoMarker, tffForce24 );
  {* Additional flags, used for formatting time. }
  TTimeFormatFlags = Set of TTimeFormatFlag;
  {* Set of flags, used for formatting time. }

const
  MonthDays: array [Boolean] of TDayTable =
    ((31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31),
     (31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31));
  {* The MonthDays array can be used to quickly find the number of
    days in a month:  MonthDays[IsLeapYear(Y), M].      }

  SecsPerDay = 24 * 60 * 60;
  {* Seconds per day. }
  MSecsPerDay = SecsPerDay * 1000;
  {* Milliseconds per day. }

  VCLDate0 = 693594;
  {* Value to convert VCL "date 0" to KOL "date 0" and back.
     This value corresponds to 30-Dec-1899, 0:00:00. So,
     to convert VCL date to KOL date, just subtract this
     value from VCL date. And to convert back from KOL date
     to VCL date, add this value to KOL date.}

{++}(*
procedure GetLocalTime(var lpSystemTime: TSystemTime); stdcall;
procedure GetSystemTime(var lpSystemTime: TSystemTime); stdcall;
*){--}

//[Date&Time FUNCTIONS DECLARATIONS]
function Now : TDateTime;
{* Returns local date and time on running PC. }
function Date: TDateTime;
{* Returns todaylocal date. }
procedure DecodeDateFully( DateTime: TDateTime; var Year, Month, Day, DayOfWeek: WORD );
{* Decodes date. }
procedure DecodeDate( DateTime: TDateTime; var Year, Month, Day: WORD );
{* Decodes date. }
function EncodeDate( Year, Month, Day: WORD; var DateTime: TDateTime ): Boolean;
{* Encodes date. }
function CompareSystemTime(const D1, D2 : TSystemTime) : Integer;
{* Compares to TSystemTime records. Returns -1, 0, or 1 if, correspondantly,
   D1 < D2, D1 = D2 and D1 > D2. }
procedure IncDays( var SystemTime : TSystemTime; DaysNum : Integer );
{* Increases/decreases day in TSystemTime record onto given days count
   (can be negative). }
procedure IncMonths( var SystemTime : TSystemTime; MonthsNum : Integer );
{* Increases/decreases month number in TSystemTime record onto given
   months count (can be negative). Correct result is not garantee if
   day number is incorrect for newly obtained month. }
function IsLeapYear(Year: Integer): Boolean;
{* Returns True, if given year is "leap" (i.e. has 29 days in the February). }
function DayOfWeek(Date: TDateTime): Integer;
{* Returns day of week (0..6) for given date. }
function SystemTime2DateTime(const SystemTime : TSystemTime; var DateTime : TDateTime ) : Boolean;
{* Converts TSystemTime record to XDateTime variable. }
function DateTime2SystemTime(const DateTime : TDateTime; var SystemTime : TSystemTime ) : Boolean;
{* Converts TDateTime variable to TSystemTime record. }
function DateTime_System2Local( DTSys: TDateTime ): TDateTime;
{* Converts DTSys representing system time (+0 Grinvich) to local time. }
function DateTime_Local2System( DTLoc: TDateTime ): TDateTime;
{* Converts DTLoc representing local time to system time (+0 Grinvich) }
function FileTime2DateTime( const ft: TFileTime; var DT: TDateTime ): Boolean;
{* }
function DateTime2FileTime( DT: TDateTime; var ft: TFileTime ): Boolean;
{* }

procedure DivMod(Dividend: Integer; Divisor: Word; var Result, Remainder: Word);
{* Dividing of integer onto divisor with obtaining both result of division
   and remainder. }

function SystemDate2Str( const SystemTime : TSystemTime; const LocaleID : DWORD;
                         const DfltDateFormat : TDateFormat;
                         const DateFormat : PKOLChar ) : KOLString;
{* Formats date, stored in TSystemTime record into string, using given locale
   and date/time formatting flags. (E.g.: GetUserDefaultLangID). }
function SystemTime2Str( const SystemTime : TSystemTime; const LocaleID : DWORD;
                         const Flags : TTimeFormatFlags;
                         const TimeFormat : PKOLChar ) : KOLString;
{* Formats time, stored in TSystemTime record into string, using given locale
   and date/time formatting flags. }

function Date2StrFmt( const Fmt: KOLString; D: TDateTime ): KOLString;
{* Represents date as a string correspondently to Fmt formatting string.
   See possible pictures in definition of the function Str2DateTimeFmt
   (the first part). If Fmt string is empty, default system date format
   for short date string used. }
function Time2StrFmt( const Fmt: KOLString; D: TDateTime ): KOLString;
{* Represents time as a string correspondently to Fmt formatting string.
   See possible pictures in definition of the function Str2DateTimeFmt
   (the second part). If Fmt string is empty, default system time format
   for short date string used. }
function DateTime2StrShort( D: TDateTime ): KOLString;
{* Formats date and time to string in short date format using current user
   locale. }
function Str2DateTimeFmt( const sFmtStr, sS: KOLString ): TDateTime;
{* Restores date or/and time from string correspondently to a format string.
   Date and time formatting string can contain following pictures (case
   sensitive):
   |<pre>
        DATE PICTURES
   d    Day of the month as digits without leading zeros for single digit days.
   dd   Day of the month as digits with leading zeros for single digit days
   ddd  Day of the week as a 3-letter abbreviation as specified by a
        LOCALE_SABBREVDAYNAME value.
   dddd Day of the week as specified by a LOCALE_SDAYNAME value.
   M    Month as digits without leading zeros for single digit months.
   MM   Month as digits with leading zeros for single digit months
   MMM  Month as a three letter abbreviation as specified by a LOCALE_SABBREVMONTHNAME value.
   MMMM Month as specified by a LOCALE_SMONTHNAME value.
   y    Year represented only be the last digit.
   yy   Year represented only be the last two digits.
   yyyy Year represented by the full 4 digits.
   gg   Period/era string as specified by the CAL_SERASTRING value. The gg
        format picture in a date string is ignored if there is no associated era
        string. In Enlish locales, usual values are BC or AD.

        TIME PICTURES
   h    Hours without leading zeros for single-digit hours (12-hour clock).
   hh   Hours with leading zeros for single-digit hours (12-hour clock).
   H    Hours without leading zeros for single-digit hours (24-hour clock).
   HH   Hours with leading zeros for single-digit hours (24-hour clock).
   m    Minutes without leading zeros for single-digit minutes.
   mm   Minutes with leading zeros for single-digit minutes.
   s    Seconds without leading zeros for single-digit seconds.
   ss   Seconds with leading zeros for single-digit seconds.
   t    One charactertime marker string (usually P or A, in English locales).
   tt   Multicharactertime marker string (usually PM or AM, in English locales).
   |</pre>
   E.g., 'D, yyyy/MM/dd h:mm:ss'.
   See also Str2DateTimeShort function.
  }
function Str2DateTimeShort( const S: KOLString ): TDateTime;
{* Restores date and time from string correspondently to current user locale. }
function Str2DateTimeShortEx( const S: KOLString ): TDateTime;
{* Like Str2DateTimeShort above, but uses locale defined date and time
   separators to avoid recognizing time as a date in some cases.
|<hr>

  <R File and directory routines>
}
{$ENDIF WIN_GDI}

//[OpenFile CONSTANTS]
const
  ofOpenRead          = {$IFDEF LIN} O_RDONLY {$ELSE} $80000000 {$ENDIF};
  {* Use this flag (in combination with others) to open file for "read" only. }
  ofOpenWrite         = {$IFDEF LIN} O_WRONLY {$ELSE} $40000000 {$ENDIF};
  {* Use this flag (in combination with others) to open file for "write" only. }
  ofOpenReadWrite     = {$IFDEF LIN} O_RDWR {$ELSE} $C0000000 {$ENDIF};
  {* Use this flag (in combination with others) to open file for "read" and "write". }

  ofShareExclusive    = {$IFDEF LIN} $10 {$ELSE} $00 {$ENDIF};
  {* Use this flag (in combination with others) to open file for exclusive use. }
  ofShareDenyWrite    = {$IFDEF LIN} $20 {$ELSE} $01 {$ENDIF};
  {* Use this flag (in combination with others) to open file in share mode, when
     only attempts to open it in other process for "write" will be impossible.
     I.e., other processes could open this file simultaneously for read only
     access. }
  ofShareDenyRead     = {$IFDEF LIN} 0 {not supported} {$ELSE} $02 {$ENDIF};
  {* Use this flag (in combination with others) to open file in share mode, when
     only attempts to open it for "read" in other processes will be disabled.
     I.e., other processes could open it for "write" only access. }
  ofShareDenyNone     = {$IFDEF LIN} $30 {$ELSE} $03 {$ENDIF};
  {* Use this flag (in combination with others) to open file in full sharing mode.
     I.e. any process will be able open this file using the same share flag. }
  ofCreateNew         = {$IFDEF LIN} O_CREAT or O_TRUNC {$ELSE} $100 {$ENDIF};
  {* Default creation disposition. Use this flag for creating new file (usually
     for write access. }
  ofCreateAlways      = {$IFDEF LIN} O_CREAT {$ELSE} $200 {$ENDIF};
  {* Use this flag (in combination with others) to open existing or creating new
     file. If existing file is opened, it is truncated to size 0. }
  ofOpenExisting      = {$IFDEF LIN} 0 {$ELSE} $300 {$ENDIF};
  {* Use this flag (in combination with others) to open existing file only. }
  ofOpenAlways        = {$IFDEF LIN} O_CREAT {$ELSE} $400 {$ENDIF};
  {* Use this flag (in combination with others) to open existing or create new
     (if such file is not yet exists). }
  ofTruncateExisting  = {$IFDEF LIN} O_TRUNC {$ELSE} $500 {$ENDIF};
  {* Use this flag (in combination with others) to open existing file and truncate
     it to size 0. }

  ofAttrReadOnly = {$IFDEF LIN} 0 {$ELSE} $10000 {$ENDIF};
  {* Use this flag to create Read-Only file (?). }
  ofAttrHidden   = {$IFDEF LIN} 0 {$ELSE} $20000 {$ENDIF};
  {* Use this flag to create hidden file. }
  ofAttrSystem   = {$IFDEF LIN} 0 {$ELSE} $40000 {$ENDIF};
  {* Use this flag to create system file. }
  ofAttrTemp       = {$IFDEF LIN} 0 {$ELSE} $1000000 {$ENDIF};
  {* Use this flag to create temp file. }
  ofAttrArchive  = {$IFDEF LIN} 0 {$ELSE} $200000 {$ENDIF};
  {* Use this flag to create archive file. }
  ofAttrCompressed = {$IFDEF LIN} 0 {$ELSE} $8000000 {$ENDIF};
  {* Use this flag to create compressed file. Has effect only on NTFS, and
     only if ofAttrCompressed is not specified also. }
  ofAttrOffline    = {$IFDEF LIN} 0 {$ELSE} $10000000 {$ENDIF};
  {* Use this flag to create offline file. }
//[END OF OpenFileConstants]

//[File FUNCTIONS DECLARATIONS]
{$IFDEF _D3orHigher}
function WFileCreate(const FileName: WideString; OpenFlags: DWord): THandle;
{* }
{$ENDIF}
function FileCreate(const FileName: KOLString; OpenFlags: DWord): THandle;
{* Call this function to open existing or create new file. OpenFlags
   parameter can be a combination of up to three flags (by one from
   each group:
   |<table border=0>
   |&L=<tr><td valign=top>%0</td><td valign=top>
   |&E=</td></tr>
   <L ofOpenRead, ofOpenWrite, ofOpenReadWrite> - 1st group. Here You decide
      wish You open file for read, write or read-and-write operations; <E>
   <L ofShareExclusive, ofShareDenyWrite, ofShareDenyRead, ofShareDenyNone> -2nd
      group - sharing. Here You can mark out sharing mode, which is used to
      open file. <E>
   <L ofCreateNew, ofCreateAlways, ofOpenExisting, ofOpenAlways, ofTruncateExisting>
      - 3rd group - creation disposition. Here You determine, either to create new
      or open existing file and if to truncate existing or not.
   |</table> }
function FileClose(Handle: THandle): Boolean;
{* Call it to close opened earlier file. }
function FileExists( const FileName: KOLString ) : Boolean;
{* Returns True, if given file exists.
   |<br>Note (by Dod):
   It is not documented in a help for GetFileAttributes, but it seems that
   under NT-based Windows systems, FALSE is always returned for files
   opened for excluseve use like pagefile.sys. }
{$IFDEF _D3orHigher}
function WFileExists( const FileName: WideString ) : Boolean;
{* Returns True, if given file exists.
   |<br>Note (by Dod):
   It is not documented in a help for GetFileAttributes, but it seems that
   under NT-based Windows systems, FALSE is always returned for files
   opened for excluseve use like pagefile.sys. }
{$ENDIF}
function FileSeek(Handle: THandle; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveMethod: TMoveMethod): TStrmSize;
{* Changes current position in file. }
function FileRead(Handle: THandle; var Buffer; Count: DWord): DWord;
{* Reads bytes from current position in file to buffer. Returns number of
   read bytes. }
{$IFDEF LIN}
function GetFileSize( Handle: THandle; HiSize: PDWORD ): DWORD;
{$ENDIF LIN}
function File2Str(Handle: THandle): AnsiString;
{* Reads file from current position to the end and returns result as ansi string. }
{$IFNDEF _D2}
function File2WStr(Handle: THandle): WideString;
{* Reads UNICODE file from current position to the end and returns result as
   unicode string. }
{$ENDIF}
function FileWrite(Handle: THandle; const Buffer; Count: DWord): DWord;
{* Writes bytes from buffer to file from current position, extending its
   size if needed. }
function FileEOF( Handle: THandle ) : Boolean;
{* Returns True, if EOF is achieved during read operations or last byte is
   overwritten or append made to extend file during last write operation. }
function FileFullPath( const FileName : KOLString ) : KOLString;
{* Returns full path name for given file. Validness of source FileName path
   is not checked at all. }
{$IFDEF WIN} //--------------- these functions have not sense in Linux: --------
function FileShortPath( const FileName: KOLString ): KOLString;
{* Returns short path to the file or directory. }
function FileIconSystemIdx( const Path: KOLString ): Integer;
{* Returns index of the index of the system icon correspondent to the file or
   directory in system icon image list. }
function FileIconSysIdxOffline( const Path: KOLString ): Integer;
{* The same as FileIconSystemIdx, but an icon is calculated for the file
   as it were offline (it is possible to get an icon for file even if
   it is not existing, on base of its extension only). }
function DirIconSysIdxOffline( const Path: KOLString ): Integer;
{* The same as FileIconSysIdxOffline, but for a folder rather then for a file. }
{$ENDIF WIN} //-----------------------------------------------------------------
procedure LogFileOutput( const filepath, str: KOLString );
{* Debug function. Use it to append given string to the end of the given file. }

function Str2File( Filename: PKOLChar; Str: PAnsiChar ): Boolean;
{* Save null-terminated string to file directly. If file does not exists, it is
   created. If it exists, it is overriden. If operation failed, FALSE is returned. }
function WStr2File( Filename: PKOLChar; Str: PWideChar ): Boolean;
{* Save null-terminated wide string to file directly. If file does not exists, it is
   created. If it exists, it is overriden. If operation failed, FALSE is returned. }
function StrSaveToFile( const Filename: KOLString; const Str: AnsiString ): Boolean;
{* Saves a string to a file without any changes. If file does not exists, it is
   created. If it exists, it is overriden. If operation failed, FALSE is returned. }
function StrLoadFromFile( const Filename: KOLString ): AnsiString;
{* Reads entire file and returns its content as a string. If operation failed,
   an empty strinng is returned.
   |<br>by Sergey Shishmintzev: it is possible to pass Filename = 'CON' to
   read input from redirected console output. }
{$IFNDEF _D2}
function WStrSaveToFile( const Filename: KOLString; const Str: WideString ): Boolean;
{* Saves a string to a file without any changes. If file does not exists, it is
   created. If it exists, it is overriden. If operation failed, FALSE is returned. }
function WStrLoadFromFile( const Filename: KOLString ): WideString;
{* Reads entire file and returns its content as a string. If operation failed,
   an empty strinng is returned.
   |<br>by Sergey Shishmintzev: it is possible to pass Filename = 'CON' to
   read input from redirected console output. }
{$ENDIF}

function Mem2File( Filename: PKOLChar; Mem: Pointer; Len: Integer ): Integer;
{* Saves memory block to a file (if file exists it is overriden, created new if
   not exists). }
function File2Mem( Filename: PKOLChar; Mem: Pointer; MaxLen: Integer ): Integer;
{* Loads file content to memory. }

{$IFDEF WIN}
type
  PFindFileData = ^TFindFileData;
  TFindFileData = packed record
    // from TWin32FindData: -------------
    dwFileAttributes: DWORD;
    ftCreationTime: TFileTime;
    ftLastAccessTime: TFileTime;
    ftLastWriteTime: TFileTime;
    nFileSizeHigh: DWORD;
    nFileSizeLow: DWORD;
    dwReserved0: DWORD;
    dwReserved1: DWORD;
    cFileName: Array[0..MAX_PATH - 1] of KOLChar;
    cAlternateFileName: Array[0..13] of KOLChar;
    //-------- + handle:
    FindHandle: THandle;
  end;
{$ENDIF WIN}
function Find_First( const FilePathName: KOLString; var F: TFindFileData ): Boolean;
function Find_Next( var F: TFindFileData ): Boolean;
procedure Find_Close( var F: TFindFileData );
{$IFDEF _D2orD3}
function FileSize( const Path: KOLString ) : Integer;
{$ELSE}
function FileSize( const Path: KOLString ) : Int64;
{$ENDIF}
{* Returns file size in bytes without opening it. If file too large
   to represent its size as Integer, -1 is returned. }
procedure FileTime( const Path: KOLString;
  CreateTime, LastAccessTime, LastModifyTime: PFileTime );
{* Returns file times without opening it. }
function GetUniqueFilename( PathName: KOLString ) : KOLString;
{* If file given by PathName exists, modifies it to create unique
   filename in target folder and returns it. Modification is performed
   by incrementing last number in name (if name part of file does not
   represent a number, such number is generated and concatenated to
   it). E.g., if file aaa.aaa is already exist, the function checks
   names aaa1.aaa, aaa2.aaa, ..., aaa10.aaa, etc. For name abc123.ext,
   names abc124.ext, abc125.ext, etc. will be checked. }
function FileTimeCompare( const FT1, FT2 : TFileTime ) : Integer;
{* Compares time of file (createing, writing, accessing. Returns
   -1, 0, 1 if correspondantly FT1<FT2, FT1=FT2, FT1>FT2. }
function DirectoryExists(const Name: KOLString): Boolean;
{* Returns True if given directory (folder) exists. }
function DiskPresent( const DrivePath: KOLString ): Boolean;
{* Returns TRUE if the disk is present }
{$IFDEF _D3orHigher}
function WDirectoryExists(const Name: WideString): Boolean;
{* }
{$ENDIF}
function CheckDirectoryContent( const Name: KOLString; SubDirsOnly: Boolean; const Mask: AnsiString ): Boolean;
{* Returns TRUE if directory does not contain files (or directories only)
   satisfying given mask. }
function DirectoryEmpty(const Name: KOLString): Boolean;
{* Returns True if given directory is not exists or empty. }
//[Directory FUNCTIONS DECLARATIONS]
function DirectoryHasSubdirs( const Path: KOLString ): Boolean;
{* Returns TRUE if given directory exists and has subdirectories. }
function GetStartDir: KOLString;
{* Returns path to directory where executable is located (regardless
   of current directory). }
function ExePath: KOLString;
{* Returns the path to the exe-file (in case of dll hook, this is exe-file
   of the process in which context dll hook function is called). }
function ModulePath: KOLString;
{* Returns the path to the module (exe, dll) itself. }



//---------------------------------------------------------
// Following functions/procedures are created by Edward Aretino:
// IncludeTrailingPathDelimiter, ExcludeTrailingPathDelimiter,
// ForceDirectories, CreateDir, ChangeFileExt
//---------------------------------------------------------
function ExcludeTrailingChar( const S: KOLString; C: KOLChar ): KOLString;
{* If S is finished with character C, it is excluded. }
function IncludeTrailingChar( const S: KOLString; C: KOLChar ): KOLString;
{* If S is not finished with character C, it is added. }
function IncludeTrailingPathDelimiter(const S: KOLString): KOLString;
{* by Edward Aretino. Adds '\' to the end if it is not present. }
function ExcludeTrailingPathDelimiter(const S: KOLString): KOLString;
{* by Edward Aretino. Removes '\' at the end if it is present. }

function ExtractFileDrive( const Path: KOLString ) : KOLString;
{* Returns only drive part from exact path to a file or a directory.
   For network paths, returns a computer name together with a following
   name of shared directory (like '\\compname\shared\' ). }
function ExtractFilePath( const Path: KOLString ) : KOLString;
{* Returns only path part from exact path to file. }
{$IFDEF _D3orHigher}
function WExtractFilePath( const Path: WideString ) : WideString;
{* Returns only path part from exact path to file. }
{$ENDIF}
function IsNetworkPath( const Path: KOLString ): Boolean;
{* Returns TRUE, if Path is starting from '\\'. }
function ExtractFileName( const Path: KOLString ) : KOLString;
{* Extracts file name from exact path to file. }
function ExtractFileNameWOext( const Path: KOLString ) : KOLString;
{* Extracts file name from path to file or from filename. }
function ExtractFileExt( const Path: KOLString ) : KOLString;
{* Extracts extention from file name (returns it with dot '.' first) }
function ReplaceExt( const Path, NewExt: KOLString ): KOLString;
{* Returns Path to a file with extension replaced to a new extension.
   Pass a new extension started with '.', e.g. '.txt'. }

function ForceDirectories(Dir: KOLString): Boolean;
{* by Edward Aretino. Creates given directory if not present. All needed
   subdirectories are created if necessary. }
function CreateDir(const Dir: KOLString): Boolean;
{* by Edward Aretino. Creates given directory. }
function ChangeFileExt(FileName: KOLString; const Extension: KOLString): KOLString;
{* by Edward Aretino. Changes file extention. }
function ReplaceFileExt( const Path, NewExt: KOLString ): KOLString;
{* Returns a path with extension replaced to a given one. }
{$IFDEF WIN} //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
function ExtractShortPathName( const Path: KOLString ): KOLString;
{* }
{$IFDEF GDI}
function FilePathShortened( const Path: KOLString; MaxLen: Integer ): KOLString;
{* Returns shortened file path to fit MaxLen characters. }
function FilePathShortenPixels( const Path: KOLString; DC: HDC; MaxPixels: Integer ): KOLString;
{* Returns shortened file path to fit MaxPixels for a given DC. If you pass
   Canvas.Handle of any control or bitmap object, ensure that font is valid
   for it (or call TCanvas.RequiredState( FontValid ) method before. If DC passed
   = 0, call is equivalent to call FilePathShortened, and MaxPixels means in such
   case maximum number of characters. }
function MinimizeName( const Path: KOLString; DC: HDC; MaxPixels: Integer ): KOLString;
{* Exactly the same as MinimizeName in FileCtrl.pas (VCL). }
{$ENDIF GDI}

function GetSystemDir: KOLString;
{* Returns path to windows system directory. }
function GetWindowsDir : KOLString;
{* Returns path to Windows directory. }
{$ENDIF WIN} //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
function GetWorkDir : KOLString;
{* Returns path to application's working directory. }
function GetTempDir : KOLString;
{* Returns path to default temp folder (directory to place temporary files). }
function CreateTempFile( const DirPath, Prefix: KOLString ): KOLString;
{* Returns path to just created temporary file. }
function  GetFileListStr(FPath{e.g.'c:\tmp\'}, FMask{e.g.'*.*'}: KOLString): KOLString;
{* List of files in string, separating each path from others with a character stored
   in FileOpSeparator variables (#13 by default).
   E.g.: 'c:\tmp\unit1.dcu'#13'c:\tmp\unit1.~pa' (for use with DeleteFile2Recycle())}
function DeleteFiles( const DirPath: KOLString ): Boolean;
{* Deletes files by file mask (given with wildcards '*' and '?'). }
{$IFDEF WIN_GDI} //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
var FileOpSeparator: KOLChar = {$IFDEF OLD_COMPAT}';'{$ELSE}#13{$ENDIF};
function DoFileOp( const FromList, ToList: KOLString; FileOp: UINT; Flags: Word;
         Title: PKOLChar): Boolean;
{* By Unknown Mystic. FileOp can be: FO_MOVE, FO_COPY, FO_DELETE, FO_RENAME.
   Flags can be a combination of values: FOF_MULTIDESTFILES, FOF_CONFIRMMOUSE,
   FOF_SILENT, FOF_RENAMEONCOLLISION, FOF_NOCONFIRMATION, FOF_WANTMAPPINGHANDLE,
   FOF_ALLOWUNDO, FOF_FILESONLY, FOF_SIMPLEPROGRESS, FOF_NOCONFIRMMKDIR,
   FOF_NOERRORUI. Title used only with FOF_SIMPLEPROGRESS. }
function DeleteFile2Recycle( const Filename : KOLString ) : Boolean;
{* Deletes file to recycle bin. This operation can be very slow, when
   called for a single file. To delete group of files at once (fast),
   pass a list of paths to files to be deleted, separating each path
   from others with a character stored in FileOpSeparator variable (by default #13,
   but in case when OLD_COMPAT symbol added - ';'). E.g.: 'unit1.dcu'#13'unit1.~pa'
   |<br>
   FALSE is returned only in case when at least one file was not deleted
   successfully.
   |<br>
   Note, that files are deleted not to recycle bin, if wildcards are
   used or not fully qualified paths to files. }
function CopyMoveFiles( const FromList, ToList: KOLString; Move: Boolean ): Boolean;
{* }
{-}
function DiskFreeSpace( const Path: KOLString ): I64; {+}
{* Returns disk free space in bytes. Pass a path to root directory,
   e.g. 'C:\'.
  |<hr>

  <R Wrappers to registry API functions>

  These functions can be used independently to simplify access to Windows
  registry. }
{$ENDIF WIN_GDI} //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

{$IFDEF WIN_GDI} //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
//[Registry FUNCTIONS DECLARATIONS]
{++}(*
function RegSetValueEx(hKey: HKEY; lpValueName: PAnsiChar;
  Reserved: DWORD; dwType: DWORD; lpData: Pointer; cbData: DWORD): Longint; stdcall;
*){--}
function RegKeyOpenRead( Key: HKey; const SubKey: KOLString ): HKey;
{* Opens registry key for read operations (including enumerating of subkeys).
   Pass either handle of opened earlier key or one of constans
   HKEY_CLASSES_ROOT, HKEY_CURRENT_USER, HKEY_LOCAL_MACHINE, HKEY_USERS
   as a first parameter. If not successful, 0 is returned. }
function RegKeyOpenWrite( Key: HKey; const SubKey: KOLString ): HKey;
{* Opens registry key for write operations (including adding new values or
   subkeys), as well as for read operations too. See also RegKeyOpenRead. }
function RegKeyOpenCreate( Key: HKey; const SubKey: KOLString ): HKey;
{* Creates and opens key. }
function RegKeyGetStr( Key: HKey; const ValueName: KOLString ): KOLString;
{* Reads key, which must have type REG_SZ (null-terminated string). If
   not successful, empty string is returned. This function as well as all
   other registry manipulation functions, does nothing, if Key passed is 0
   (without producing any error). }
function RegKeyGetStrEx( Key: HKey; const ValueName: KOLString ): KOLString;
{* Like RegKeyGetStr, but accepts REG_EXPAND_SZ type, expanding all
   environment variables in resulting string.
   |<br>
   Code provided by neuron, e-mailto:neuron@hollowtube.mine.nu }
function RegKeyGetDw( Key: HKey; const ValueName: KOLString ): DWORD;
{* Reads key value, which must have type REG_DWORD. If ValueName passed
   is '' (empty string), unnamed (default) value is reading. If not
   successful, 0 is returned. }
function RegKeySetStr(Key: HKey; const ValueName: KOLString; const Value: KOLString ): Boolean;
{* Writes new key value as null-terminated string (type REG_SZ). If not
   successful, returns False. }
function RegKeySetStrEx( Key: HKey; const ValueName: KOLString; const Value: KOLString;
                         expand: Boolean): Boolean;
{* Writes new key value as REG_SZ or REG_EXPAND_SZ. - by neuron, e-mailto:neuron@hollowtube.mine.nu }
function RegKeySetDw( Key: HKey; const ValueName: KOLString; Value: DWORD ): Boolean;
{* Writes new key value as dword (with type REG_DWORD). Returns False,
   if not successful. }
procedure RegKeyClose( Key: HKey );
{* Closes key, opened using RegKeyOpenRead or RegKeyOpenWrite. (But does
   nothing, if Key passed is 0). }
function RegKeyDelete( Key: HKey; const SubKey: KOLString ): Boolean;
{* Deletes key. Does nothing if key passed is 0 (returns FALSE). }
function RegKeyDeleteValue( Key: HKey; const SubKey: KOLString ): Boolean;
{* Deletes value. - by neuron, e-mailto:neuron@hollowtube.mine.nu }
function RegKeyExists( Key: HKey; const SubKey: AnsiString ): Boolean;
{* Returns TRUE, if given subkey exists under given Key. }
function RegKeyValExists( Key: HKey; const ValueName: KOLString ): Boolean;
{* Returns TRUE, if given value exists under the Key.
}
function RegKeyValueSize( Key: HKey; const ValueName: KOLString ): Integer;
{* Returns a size of value. This is a size of buffer needed to store
   registry key value. For string value, size returned is equal to a
   length of string plus 1 for terminated null character. }
function RegKeyGetBinary( Key: HKey; const ValueName: KOLString; var Buffer; Count: Integer ): Integer;
{* Reads binary data from a registry, writing it to the Buffer.
   It is supposed that size of Buffer provided is at least Count bytes.
   Returned value is actul count of bytes read from the registry and written
   to the Buffer.
   |<br>
   This function can be used to get data of any type from the registry, not
   only REG_BINARY. }
function RegKeySetBinary( Key: HKey; const ValueName: KOLString; const Buffer; Count: Integer ): Boolean;
{* Stores binary data in the registry. }
function RegKeyGetDateTime(Key: HKey; const ValueName: KOLString): TDateTime;
{* Returns datetime variable stored in registry in binary format. }
function RegKeySetDateTime(Key: HKey; const ValueName: KOLString; DateTime: TDateTime): Boolean;
{* Stores DateTime variable in the registry. }

//-------------------------------------------------------
// registry functions by Valerian Luft <luft@valerian.de>
//-------------------------------------------------------
function RegKeyGetSubKeys( const Key: HKEY; List: PKOLStrList): Boolean;
{* The function enumerates subkeys of the specified open registry key.
   True is returned, if successful.
}
function RegKeyGetValueNames(const Key: HKEY; List: PKOLStrList): Boolean;
{* The function enumerates value names of the specified open registry key.
   True is returned, if successful.
}
function RegKeyGetValueTyp (const Key:HKEY; const ValueName: KOLString) : DWORD;
{* The function receives the type of data stored in the specified value.
   |<br>
   If the function fails, the return value is the Key value.
   |<br>
   If the function succeeds, the return value return will be one of the following:
   |<br>
   REG_BINARY , REG_DWORD, REG_DWORD_LITTLE_ENDIAN,
   REG_DWORD_BIG_ENDIAN, REG_EXPAND_SZ, REG_LINK , REG_MULTI_SZ,
   REG_NONE, REG_RESOURCE_LIST, REG_SZ

|<hr>

  <R Data sorting (quicksort implementation)>
  This part contains implementation of 'quick sort' algorithm,
   based on following code:

|<pre>
| TQSort by Mike Junkin 10/19/95.
| DoQSort routine adapted from Peter Szymiczek's QSort procedure which
| was presented in issue#8 of The Unofficial Delphi Newsletter.

| TQSort changed by Vladimir Kladov (Mr.Bonanzas) to allow 32-bit
| sorting (of big arrays with more than 64K elements).
|</pre>

  Finally, this sort procedure is adapted to XCL (and then to KOL)
  requirements (no references to SysUtils, Classes etc. TQSort object
  is transferred to a single procedure call and DoQSort method is
  renamed to SortData - which is a regular procedure now). }

{$ENDIF WIN_GDI} //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//[Sorting TYPES]
type
  TCompareEvent = function (const Data: Pointer; const e1,e2 : Dword) : Integer;
  {* Event type to define comparison function between two elements of an array.
     This event handler must return -1 or +1 (correspondently for cases e1<e2
     and e2>e2). Items are enumerated from 0 to uNElem. }
  TSwapEvent = procedure (const Data : Pointer; const e1,e2 : Dword);
  {* Event type to define swap procedure which is swapping two elements of an
     array. }

//[SortData FUNCTIONS DECLARATIONS]
procedure SortData( const Data: Pointer; const uNElem: Dword;
                    const CompareFun: TCompareEvent;
                    const SwapProc: TSwapEvent );
{* Call it to sort any array of data of any kind, passing total
   number of items in an array and two defined (regular) function
   and procedure to perform custom compare and swap operations.
   First procedure parameter is to pass it to callback function
   CompareFun and procedure SwapProc. Items are enumerated from
   0 to uNElem-1. }

procedure SwapListItems( const L: Pointer; const e1, e2: DWORD );
{* Use this function as the last parameter for SortData call when a PList
   object is sorting. SwapListItems just exchanges two items of the list. }

procedure SortIntegerArray( var A : array of Integer );
{* procedure to sort array of integers. }

procedure SortDwordArray( var A : array of DWORD );
{* Procedure to sort array of unsigned 32-bit integers.
|<hr>
}
{ -- directory list object -- }
//[DirList Object]

type
  TDirItemAction = ( diSkip, diAccept, diCancel );
  TOnDirItem = procedure( Sender: PObj; var DirItem: TFindFileData; var Accept: TDirItemAction )
             of object;
  TSortDirRules = ( sdrNone, sdrFoldersFirst, sdrCaseSensitive, sdrByName, sdrByExt,
                    sdrBySize, sdrBySizeDescending, sdrByDateCreate, sdrByDateChanged,
                    sdrByDateAccessed );
  {* List of rules (options) to sort directories. Rules are passed to Sort
     method in an array, and first placed rules are applied first. }

  {++}(*TDirList = class;*){--}
  PDirList = {-}^{+}TDirList;
{ ----------------------------------------------------------------------
                TDirList - Directory scanning
----------------------------------------------------------------------- }
//[TDirList DEFINITION]
  TDirList = object( TObj )
  {* Allows easy directory scanning. This is not visual object, but
     storage to simplify working with directory content. }
  protected
    FList : PList;
    FPath: KOLString;
    fFilters: {$IFDEF UNICODE_CTRLS} PWStrList {$ELSE} PStrList {$ENDIF};
    fOnItem: TOnDirItem;
    function Get(Idx: Integer): PFindFileData;
    function GetCount: Integer;
    function GetNames(Idx: Integer): KOLString;
    function GetIsDirectory(Idx: Integer): Boolean;
  protected
    function SatisfyFilter( FileName : PKOLChar; FileAttr, FindAttr : DWord ) : Boolean;
  {++}(*public*){--}
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* Destructor. As usual, call Free method to destroy an object. }
  public
    property Items[ Idx : Integer ] : PFindfileData read Get; default;
    {* Full access to scanned items (files and subdirectories). }
    property IsDirectory[ Idx: Integer ]: Boolean read GetIsDirectory;
    {* Returns TRUE, if specified item represents a directory, not a file. }
    property Count : Integer read GetCount;
    {* Number of items. }
    property Names[ Idx : Integer ] : KOLString read GetNames;
    {* Full long names of directory items. }
    property Path : KOLString read FPath;
    {* Path of scanned directory. }
    procedure Clear;
    {* Call it to clear list of files. }
    procedure ScanDirectory( const DirPath, Filter : KOLString; Attr : DWord );
    {* Call it to rescan directory or to scan another directory content
       (method Clear is called first). Pass path to directory, file filter
       and attributes to scan directory immediately.
       |<br>&nbsp;&nbsp;&nbsp;
       Note: Pass FILE_ATTRIBUTE_... constants or-combination as Attr
       parameter. If 0 passed, both files and directories are listed. }
    procedure ScanDirectoryEx( const DirPath, Filters : KOLString; Attr : DWord );
    {* Call it to rescan directory or to scan another directory content
       (method Clear is called first). Pass path to directory, file filter
       and attributes to scan directory immediately.
       |<br>&nbsp;&nbsp;&nbsp;
       Note: Pass FILE_ATTRIBUTE_... constants or-combination as Attr
       parameter. }
    procedure Sort( Rules : array of TSortDirRules );
   {* Sorts directory entries. If empty rules array passed, default rules
      array DefSortDirRules is used. }
   function FileList( const Separator {e.g.: ';', or #13}: KOLString;
            Dirs, FullPaths: Boolean ): KOLString;
   {* Returns a string containing all names separated with Separator.
      If Dirs=FALSE, only files are returned. }
   property OnItem: TOnDirItem read fOnItem write fOnItem;
   {* This event is called on reading each item while scanning directory.
      To use it, first create PDirList object with empty path to scan, then
      assign OnItem event and call ScanDirectory with correct path. }
  end;
//[END OF TDirList DEFINITION]

//[NewDirList DECLARATIONS]
function NewDirList( const DirPath, Filter: KOLString; Attr: DWORD ): PDirList;
{* Creates directory list object using easy one-string filter. If Attr = FILE_ATTRIBUTE_NORMAL,
   only files are scanned without directories. If Attr = 0, both files and
   directories are listed. }

function NewDirListEx( const DirPath, Filters: KOLString; Attr: DWORD ): PDirList;
{* Creates directory list object using several filters, separated by ';'.
   Filters starting from '^' consider to be anti-filters, i.e. files,
   satisfying to those masks, are skept during scanning. }

const DefSortDirRules : array[ 0..3 ] of TSortDirRules = ( sdrFoldersFirst,
      sdrByName, sdrBySize, sdrByDateCreate );
{* Default rules to sort directory entries. }

//[DirectorySize DECLARATION]
{-}
function DirectorySize( const Path: KOLString ): I64;
{* Returns directory size in bytes as large 64 bit integer. }
{+}

{$IFDEF WIN_GDI} //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
//[OpenSaveDialog OPTIONS]
type
  TOpenSaveOption = ( OSCreatePrompt,
                      OSExtensionDiffent,
                      OSFileMustExist,
                      OSHideReadonly,
                      OSNoChangedir,
                      OSNoReferenceLinks,
                      OSAllowMultiSelect,
                      OSNoNetworkButton,
                      OSNoReadonlyReturn,
                      OSOverwritePrompt,
                      OSPathMustExist,
                      OSReadonly,
                      OSNoValidate
  //{$IFDEF OpenSaveDialog_Extended}
                      ,
                      OSTemplate,
                      OSHook
  //{$ENDIF}
                    );
  TOpenSaveOptions = set of TOpenSaveOption;
  {* Options available for TOpenSaveDialog. }

  {++}(*TOpenSaveDialog = class;*){--}
  POpenSaveDialog = {-}^{+}TOpenSaveDialog;
{ ----------------------------------------------------------------------
                              TOpenSaveDialog
----------------------------------------------------------------------- }
//[TOpenSaveDialog DEFINITION]
  TOpenSaveDialog = object( TObj )
  {* Object to show standard Open/Save dialog. Initially provided
     for XCL by Carlo Kok. }
  protected
    FFilter : KOLString;
    fFilterIndex : Integer;
    fOpenDialog : Boolean;
    FInitialDir : KOLString;
    FDefExtension : KOLString;
    FFilename : KOLString;
    FTitle : KOLString;
    FOptions : TOpenSaveOptions;
    fWnd: THandle;
    fOpenReadOnly: Boolean;
  public
    TemplateName: KOLString; // do not forget to add OpenSaveDialog_Extended
    HookProc: Pointer;    // to project options conditionals!
    NoPlaceBar: Boolean;  // TRUE, if place bar is disabled in the new style
                          // dialogs (if the symbol OpenSaveDialog_Extended is
                          // not added in project options, place bar is always
                          // enabled in Windows 2000 and higher).
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* destructor }
    Function Execute : Boolean;
    {* Call it after creating to perform selecting of file by user. }
    property Filename : KOLString read FFilename write FFileName;
    {*
    Filename is separated by #13 when multiselect is true and the first
    file, is the path of the files selected.
    |<pre>
    |  C:\Projects
    |  Test1.Dpr
    |  Test2.Dpr
    |</pre>
    If only one file is selected, it is provided as (e.g.)
    C:\Projects\Test1.dpr
    |<br> For case when OSAllowMultiselect option used, after each
    call initial value for a Filename containing several files prevents
    system from opening the dialog. To fix this, assign another initial
    value to Filename property in your code, when you use multiselect.
    }
    property InitialDir : KOLString read FInitialDir write FInitialDir;
    {* Initial directory path. If not set, current directory (usually
       directory when program is started) is used. }
    property Filter : KOLString read FFilter write FFilter;
    {* A list of pairs of filter names and filter masks, separated with '|'.
       If a mask contains more than one mask, it should be separated with ';'.
       E.g.:
       ! 'All files|*.*|Text files|*.txt;*.1st;*.diz' }
    property FilterIndex : Integer read FFilterIndex write FFilterIndex;
    {* Index of default filter mask (0 by default, which means "first"). }
    property OpenDialog : Boolean read FOpenDialog write FOpenDialog;
    {* True, if "Open" dialog. False, if "Save" dialog. True is default. }
    property Title : KOLString read Ftitle write Ftitle;
    {* Title for dialog. }
    property Options : TOpenSaveOptions read FOptions write FOptions;
    {* Options. }
    property DefExtension : KOLString read FDefExtension write FDefExtension;
    {* Default extention. Set it to desired extension without leading period,
       e.g. 'txt', but not '.txt'. }
    property WndOwner: THandle read fWnd write fWnd;
    {* Owner window handle. If not assigned, Applet.Handle is used (whenever
       possible). Assign it, if your application has stay-on-top forms, and
       a separate Applet object is used. }
    property OpenReadOnly: Boolean read fOpenReadOnly;
    {* TRUE after Execute, if Read Only check box was checked by the user.
       Options are not affected anyway. } 
  end;
//[END OF TOpenSaveDialog DEFINITION]

//[Default OpenSaveDialog OPTIONS]
const DefOpenSaveDlgOptions: TOpenSaveOptions = [ OSHideReadonly,
  OSOverwritePrompt, OSFileMustExist, OSPathMustExist ];

//[NewOpenSaveDialog DECLARATION]
function NewOpenSaveDialog( const Title, StrtDir: KOLString;
         Options: TOpenSaveOptions ): POpenSaveDialog;
{* Creates object, which can be used (several times) to open file(s)
   selecting dialog. }

//[OpenDirectory Object]
type
  {++}(*TOpenDirDialog = class;*){--}
  POpenDirDialog = {-}^{+}TOpenDirDialog;

  TOpenDirOption = ( odBrowseForComputer, odBrowseForPrinter, odDontGoBelowDomain,
                   odOnlyFileSystemAncestors, odOnlySystemDirs, odStatusText,
                   odBrowseIncludeFiles, odEditBox, odNewDialogStyle );
  {* Flags available for TOpenDirDialog object. }
                   // odfStatusText - do not support status callback
  TOpenDirOptions = set of TOpenDirOption;
  {* Set of all flags used to control ZOpenDirDialog class. }

  TOnODSelChange = procedure( Sender: POpenDirDialog; NewSelDir: PKOL_Char;
                              var EnableOK: Integer; var StatusText: KOL_String )
                              of object;
  {* Event type to be called when user select another directory in OpenDirDialog.
     Set EnableOK to -1 to disable OK button, or to +1 to enable it.
     It is also possible to set new StatusText string. }

{ ----------------------------------------------------------------------
                               TOpenDirDialog
----------------------------------------------------------------------- }
//[TOpenDirDialog DEFINITION]
  TOpenDirDialog = object( TObj )
  {* Dialog for open directories, uses SHBrowseForFolder. }
  protected
    FTitle: KOLString;
    FOptions: TOpenDirOptions;
    FCallBack: Pointer;
    FCenterProc: procedure( Wnd: HWnd );
    FBuf : array[ 0..MAX_PATH ] of KOLChar;
    FInitialPath: KOLString;
    FCenterOnScreen: Boolean;
    FDoSelChanged: procedure( Wnd: HWnd; Msg: DWORD; lParam, lpData: LParam ); stdcall;
    FOnSelChanged: TOnODSelChange;
    FStatusText: KOLString;
    FWnd, FDialogWnd: HWnd;
    function GetPath: KOLString;
    procedure SetInitialPath(const Value: KOLString);
    procedure SetCenterOnScreen(const Value: Boolean);
    procedure SetOnSelChanged(const Value: TOnODSelChange);
    function GetInitialPath: KOLString;
  public
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* destructor }
    function Execute : Boolean;
    {* Call it to select directory by user. Returns True, if operation was
       not cancelled by user. }
    property Title : KOLString read FTitle write FTitle;
    {* Title for a dialog. }
    property Options : TOpenDirOptions read FOptions write FOptions;
    {* Option flags. }
    property Path : KOLString read GetPath;
    {* Resulting (selected by user) path. }
    property InitialPath: KOLString read GetInitialPath write SetInitialPath;
    {* Set this property to a path of directory to be selected initially
       in a dialog. }
    property CenterOnScreen: Boolean read FCenterOnScreen write SetCenterOnScreen;
    {* Set it to True to center dialog on screen. }
    property OnSelChanged: TOnODSelChange read FOnSelChanged write SetOnSelChanged;
    {* This event is called every time, when user selects another directory.
       It is possible to enable/disable OK button in dialog and/or change
       dialog status text in responce to event. }
    property WndOwner: HWnd read FWnd write FWnd;
    {* Owner window. If you want to provide your dialog visible over stay-on-top
       form, fire it as a child of the form, assigning the handle of form window
       to this property first. }
    property DialogWnd: HWnd read FDialogWnd;
    {* Handle to the open directory dialog itself, become available on the
       first call of callback procedure (i.e. on the first call to OnSelChanged).
    }
  end;
//[END OF TOpenDirDialog DEFINITION]

//[NewOpenSaveDialog DECLARATION]
function NewOpenDirDialog( const Title: KOLString; Options: TOpenDirOptions ):
         POpenDirDialog;
{* Creates object, which can be used (several times) to open directory
   selecting dialog (using SHBrowseForFolder API call). }

//[Color Dialog Object]
type
  TColorCustomOption = ( ccoFullOpen, ccoShortOpen, ccoPreventFullOpen );

{$IFDEF KOL_MCK}
type  TKOLOpenDirDialog = POpenDirDialog;
{$ENDIF}

  {++}(*TColorDialog = class;*){--}
  PColorDialog = {-}^{+}TColorDialog;
{ ----------------------------------------------------------------------
                               TColorDialog
----------------------------------------------------------------------- }
//[TColorDialog DEFINITION]
  TColorDialog = object( TObj )
  {* Color choosing dialog. }
  protected
  public
    OwnerWindow: HWnd;
    {* Owner window (can be 0). }
    CustomColors: array[ 1..16 ] of TColor;
    {* Array of stored custom colors. }
    ColorCustomOption: TColorCustomOption;
    {* Options (how to open a dialog). }
    Color: TColor;
    {* Returned color (if the result of Execute is True). }
    function Execute: Boolean;
    {* Call this method to open a dialog and wait its result. }
  end;
//[END OF TColorDialog DEFINITION]

//[NewColorDialog DECLARATION]
function NewColorDialog( FullOpen: TColorCustomOption ): PColorDialog;
{* Creates color choosing dialog object. }
{$ENDIF WIN_GDI}
{$IFDEF WIN_GDI}
//[Ini files]
type
  TIniFileMode = ( ifmRead, ifmWrite );
  {* ifmRead is default mode (means "read" data from ini-file.
     Set mode to ifmWrite to write data to ini-file, correspondent to
     TIniFile. }

  {++}(*TIniFile = class;*){--}
  PIniFile = {-}^{+}TIniFile;

{ ----------------------------------------------------------------------
                TIniFile - store/load data to ini-files
----------------------------------------------------------------------- }
//[TIniFile DEFINITION]
  TIniFile = object( TObj )
  {* Ini file incapsulation. The main feature is what the same block of
     read-write operations could be defined (difference must be only in
     Mode value).
     |*Ini file sample.
     This sample shows how the same Pascal operators can be used both
     for read and write for the same variables, when working with TIniFile:
     !    procedure ReadWriteIni( Write: Boolean );
     !    var Ini: PIniFile;
     !    begin
     !      Ini := OpenIniFile( 'MyIniFile.ini' );
     !      Ini.Section := 'Main';
     !      if Write then            // if Write, the same operators will save
     !         Ini.Mode := ifmWrite; // data rather then load.
     !      MyForm.Left := Ini.ValueInteger( 'Left', MyForm.Left );
     !      MyForm.Top  := Ini.ValueInteger( 'Top',  MyForm.Top );
     !      Ini.Free;
     !    end;
     !
     |*  }
  protected
    fMode: TIniFileMode;
    fFileName: KOLString;
    fSection: KOLString;
  protected
  public
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* destructor }
    property Mode: TIniFileMode read fMode write fMode;
    {* ifmWrite, if write data to ini-file rather than read it. }
    property FileName: KOLString read fFileName;
    {* Ini file name. }
    property Section: KOLString read fSection write fSection;
    {* Current ini section. }
    function ValueInteger( const Key: KOLString; Value: Integer ): Integer;
    {* Reads or writes integer data value. }
    function ValueString( const Key: KOLString; const Value: KOLString ): KOLString;
    {* Reads or writes string data value. }
    function ValueDouble( const Key: KOLString; const Value: Double ): Double;
    {* Reads or writes Double data value. }
    function ValueBoolean( const Key: KOLString; Value: Boolean ): Boolean;
    {* Reads or writes Boolean data value. }
    function ValueData( const Key: KOLString; Value: Pointer; Count: Integer ): Boolean;
    {* Reads or writes data from/to buffer. Returns True, if success. }
    procedure ClearAll;
    {* Clears all sections of ini-file. }
    procedure ClearSection;
    {* Clears current Section of ini-file. }
    procedure ClearKey( const Key: KOLString );
    {* Clears given key in current section. }

    /////////////// + by Vyacheslav A. Gavrik:
    procedure GetSectionNames(Names:PKOLStrList);
    {* Retrieves section names, storing it in string list passed as a parameter.
       String list does not cleared before processing. Section names are added
       to the end of the string list. }
    procedure SectionData(Names:PKOLStrList);
    {* Read/write current section content to/from string list. (Depending on
       current Mode value). }
    ///////////////

  end;
//[END OF TIniFile DEFINITION]

//[OpenIniFile DECLARATION]
function OpenIniFile( const FileName: KOLString ): PIniFile;
{* Opens ini file, creating TIniFile object instance to work with it. }
{$ENDIF WIN_GDI}
//[MENU OBJECT]

type
  TMenuitemInfo = packed record
    cbSize: UINT;
    fMask: UINT;
    fType: UINT;             { used if MIIM_TYPE}
    fState: UINT;            { used if MIIM_STATE}
    wID: UINT;               { used if MIIM_ID}
    hSubMenu: HMENU;         { used if MIIM_SUBMENU}
    hbmpChecked: HBITMAP;    { used if MIIM_CHECKMARKS}
    hbmpUnchecked: HBITMAP;  { used if MIIM_CHECKMARKS}
    dwItemData: DWORD;       { used if MIIM_DATA}
    dwTypeData: PKOLChar;    { used if MIIM_TYPE}
    cch: UINT;               { used if MIIM_TYPE}
    hbmpItem: HBITMAP;       { used if MIIM_BITMAP - not exists under Windows95 }
  end;

const
  TPM_HORPOSANIMATION = $0400;
  TPM_HORNEGANIMATION = $0800;
  TPM_VERPOSANIMATION = $1000;
  TPM_VERNEGANIMATION = $2000;
  TPM_NOANIMATION     = $4000;

type
  {++}(*TMenu = class;*){--}
  PMenu = {-}^{+}TMenu;

  TOnMenuItem = procedure( Sender : PMenu; Item : Integer ) of object;
  {* Event type to define OnMenuItem event. }

  TMenuAccelerator = packed Record
  {* Menu accelerator record. Use MakeAccelerator function to combine desired
     attributes into a record, describing the accelerator. }
    fVirt: Byte; // or-combination of FSHIFT, FCONTROL, FALT, FVIRTKEY, FNOINVERT
    Key: Word;   // character or virtual key code (FVIRTKEY flag is present above)
    NotUsed: Byte; // not used
  end;

  // by Sergey Shisminzev:
  TMenuOption = (moDefault, moDisabled, moChecked,
          moCheckMark, moRadioMark, moSeparator, moBitmap, moSubMenu,
          moBreak, moBarBreak);
  {* Options to add menu items dynamically. }
  TMenuOptions = set of TMenuOption;
  {* Set of options for menu item to use it in TMenu.AddItem method. }

  TMenuBreak = ( mbrNone, mbrBreak, mbrBarBreak );
  {* Possible menu item break types. }

{ ----------------------------------------------------------------------
                TMenu - main, popup menu and menu item
----------------------------------------------------------------------- }
//[TMenu DEFINITION]
  TMenu = object( TObj )
  protected
  {$IFDEF GDI}
    function GetItemHelpContext(Idx: Integer): Integer;
    procedure SetItemHelpContext(Idx: Integer; const Value: Integer);
  {* Dynamic menu incapsulation object. Can play role of form main menu or popup
     menu, depending on kind of parent window (form or control) and order of
     creation (created first (for a form) become main menu). Does not allow
     merging menus, but items can be hidden. Additionally checkmark bitmaps,
     shortcut key accelerators and other features are available. }
  protected
    FHandle: HMenu;
    FId: Integer;
    FControl: PControl;
    {$ENDIF GDI}
    fNextMenu : PMenu;
    {$IFDEF GDI}
    FMenuBreak: TMenuBreak;
    FOnMenuItem : TOnMenuItem;
    FOnRadioOff : TOnMenuItem;
    fOnPopup: TOnEvent;
    fByAccel: Boolean;
    FPopupFlags: DWORD;
    //fAutoPopup: Boolean;
    FSavedState: DWORD;
    FData: Pointer;
    FOwnerDraw: Boolean;
    {$ENDIF GDI}
    FParentMenu: PMenu;
    FMenuItems: PList;
    FRadioGroup: Integer;
    FIsCheckItem: Boolean;
    FIsSeparator: Boolean;
    FVisible: Boolean;
    FCaption: KOLString;
    {$IFDEF _X_}
    {$IFDEF GTK}
    fChecked: Boolean;
    fMnemonics: AnsiString;
    fGtkMenuItem: PGtkWidget;
    fGtkMenuShell: PGtkWidget;
    fGtkMenuBar: PGtkWidget;
    {$ENDIF GTK}
    {$ENDIF _X_}
    {$IFDEF GDI}
    FBitmap: HBitmap;
    FBmpChecked: HBitmap;
    FBmpItem: HBitmap;
    ClearBitmapsProc: procedure( Sender: PMenu );
    FClearBitmaps: Boolean;
    FNotPopup: Boolean;
    FAccelerator: TMenuAccelerator;
    FHelpContext: Integer;
    FOnMeasureItem: TOnMeasureItem;
    FOnDrawItem: TOnDrawItem;
    {$IFDEF USE_MENU_CURCTL}
    fCurCtl: PControl;
    {$ENDIF USE_MENU_CURCTL}
    function GetItems( Id: HMenu ): PMenu;
    function GetCount: Integer;
    function GetTopParent: PMenu;
    function GetState( const Index: Integer ): Boolean;
    procedure SetState( const Index: Integer; Value: Boolean );
    procedure SetVisible( Value: Boolean );
    procedure SetData( Value: Pointer );
    procedure SetMenuItemCaption( const Value: KOLString );
    function FillMenuItems(AHandle: HMenu; StartIdx: Integer;
      const Template: array of PKOLChar): Integer;
    procedure SetMenuBreak( Value: TMenuBreak );
    function GetControl: PControl;
    function GetInfo( var MII: TMenuItemInfo ): Boolean;
    function SetInfo( var MII: TMenuItemInfo ): Boolean;
    function SetTypeInfo( var MII: TMenuItemInfo ): Boolean;
    procedure SetBitmap( Value: HBitmap );
    procedure SetBmpChecked( Value: HBitmap );
    procedure SetBmpItem( Value: HBitmap );
    procedure ClearBitmaps;
    procedure SetAccelerator( const Value: TMenuAccelerator );
    {$IFDEF GDI}
    procedure SetHelpContext( Value: Integer );
    {$ENDIF GDI}
    procedure SetSubmenu( Value: HMenu );
    procedure SetOnMeasureItem( const Value: TOnMeasureItem );
    procedure SetOnDrawItem( const Value: TOnDrawItem );
    procedure SetOwnerDraw( Value: Boolean );
  protected
    function GetItemChecked( Item : Integer ) : Boolean;
    procedure SetItemChecked( Item : Integer; Value : Boolean );
    function GetItemBitmap(Idx: Integer): HBitmap;
    procedure SetItemBitmap(Idx: Integer; const Value: HBitmap);
	function GetItemText(Idx: Integer): KOLString;
	procedure SetItemText(Idx: Integer; const Value: KOLString);
    function GetItemEnabled(Idx: Integer): Boolean;
    procedure SetItemEnabled(Idx: Integer; const Value: Boolean);
    function GetItemVisible(Idx: Integer): Boolean;
    procedure SetItemVisible(Idx: Integer; const Value: Boolean);
    function GetItemAccelerator(Idx: Integer): TMenuAccelerator;
    procedure SetItemAccelerator(Idx: Integer; const Value: TMenuAccelerator);
    function GetItemSubMenu( Idx: Integer ): HMenu;
    {$ENDIF GDI}
  public
    destructor Destroy; {-}virtual;{+}{++}(*override;*){--}
    {* To release menu dynamically, call Free method instead. All (popup)
       menus created after this (for the same control) are destroyed in
       that case too.
       |<br>
       It is not necessary to release menu object manually: all menus,
       created with given form (or control), are automatically released,
       when owner form (or control) is destroyed.
    }
    {$IFDEF GDI}
    property Handle : HMenu read FHandle;
    {* Handle of Windows menu object. }
    property MenuId: Integer read FId;
    {* Id of the menu item object. If menu item has subitems, it has
       also submenu Handle. Top parent menu object itself has no Id.
       Id-s areassigned automatically starting from 4096. Do not
       (re)create menu items instantly, because such values are not
       reused, and maximum possible Id value must not exceed 65535. }
    property Parent: PMenu read FParentMenu;
    {* Parent menu item (or parent menu). }
    property TopParent: PMenu read GetTopParent;
    {* Top parent menu, owning all nested subitems. }
    property Owner: PControl read GetControl;
    {* Parent control or form. }
    property Caption: KOLString read FCaption write SetMenuItemCaption;
    {* Menu item caption text (including '&' indicating mnemonic characters,
       and keyboard accelerator representation string, usually following
       tabulation character). }
    property Items[ Id: HMenu ]: PMenu read GetItems;
    {* Returns menu item object by its index or by menu id. Since menu id
       values are starting from 4096, values from 0 to 4095 are interpreted
       as absolute index of menu item. Be careful accessing menu items or
       submenus by index, if you dynamically insert or delete items or
       submenus. In this version, separators are enumerating too, like
       all other items. Use index -1 to access object itself. The first
       item of a menu (or the first subitem of submenu item) has index 0.
       Children are enumerating before all siblings. The maximum available
       index is (Count - 1), when accessing menu items by index. }
    property Count: Integer read GetCount;
    {* Count of items together with all its nested subitems. }
    function IndexOf( Item: PMenu ): Integer;
    {* Returns index of an item. This index can be used to access
       menu item. Value -2 is returned, if the Item is not a child for menu
       or menu item, and has no parents, which are children for it, etc.
       Menu object itself always has index -1. }
    property OnMenuItem : TOnMenuItem read FOnMenuItem write FOnMenuItem;
    {* Is called when menu item is clicked. Absolute index of menu item
       clicked is passed as the second parameter. TopParent always is
       passed as a Sender parameter. }
    property ByAccel: Boolean read fByAccel;
    {* True, when OnMenuItem is called not by mouse, but by accelerator key.
       Check this flag for entire menu (TopParent), not for item itself.
       (Note, that Sender in OnMenuItem always is TopParent menu object). )
    }
    property IsSeparator: Boolean read FIsSeparator;
    {* TRUE, if a separator menu item. }
    property MenuBreak: TMenuBreak read FMenuBreak write SetMenuBreak;
    {* Menu item break type. }
    property OnUncheckRadioItem : TOnMenuItem read FOnRadioOff write FOnRadioOff;
    {* Is called when radio item becomes unchecked in menu in result of
       checking another radio item of the same radio group. }
    property RadioGroup: Integer read FRadioGroup write FRadioGroup;
    {* Radio group index. Several neighbour items with the same radio group
       index form radio group. Only single item from the same group can be
       checked at a time. }
    property IsCheckItem: Boolean read FIsCheckItem;
    {* If menu item is defined as check item, it is checked automatically
       when clicked. }
    procedure RadioCheckItem;
    {* Call this method to check radio item. (Calling this method for
       an item, which is not belonging to a radio group, just sets its
       Checked state to TRUE). }
    property Checked: Boolean index MFS_CHECKED read GetState write SetState;
    {* Checked state of the item. }
    property Enabled: Boolean
             {$IFDEF F_P}
             index $80000000 or MFS_DISABLED
             {$ELSE DELPHI}
             index Integer( $80000000 or MFS_DISABLED )
             {$ENDIF F_P/DELPHI}
             read GetState write SetState;
    {* Enabled state of the item. Whaen assigned, Grayed state also is
       set to arbitrary value (i.e., when Enabled is set to true, Grayed
       is set to FALSE. }
    property DefaultItem: Boolean index MFS_DEFAULT read GetState write SetState;
    {* Set this property to TRUE to make menu item default. Default item
       is drawn with bold.
       |<br>If you change DefaultItem at run-time and whant
       to provide changing its visual state, recreate the item first resetting
       Visible property, then setting it again. }
    property Highlight: Boolean index MFS_HILITE read GetState write SetState;
    {* Highlight state of the item. }
    property Visible: Boolean read FVisible write SetVisible;
    {* Visibility of menu item. }
    property Data: Pointer read FData write SetData;
    {* Data pointer, associated with the menu item. }
    property Bitmap: HBitmap read FBitmap write SetBitmap;
    {* Bitmap used for unchecked state of the menu item. }
    property BitmapChecked: HBitmap read FBmpChecked write SetBmpChecked;
    {* Bitmap used for checked state of the menu item. }
    property BitmapItem: HBitmap read FBmpItem write SetBmpItem;
    {* Bitmap used for item itself. In addition, following special values
       are possible:
       HBMMENU_CALLBACK, HBMMENU_MBAR_CLOSE, HBMMENU_MBAR_CLOSE_D,
       HBMMENU_MBAR_MINIMIZE, HBMMENU_MBAR_MINIMIZE_D, HBMMENU_MBAR_RESTORE,
       HBMMENU_POPUP_CLOSE, HBMMENU_POPUP_MAXIMIZE, HBMMENU_POPUP_MINIMIZE,
       HBMMENU_POPUP_RESTORE, HBMMENU_SYSTEM. }
    property Accelerator: TMenuAccelerator read FAccelerator write SetAccelerator;
    {* Accelerator for menu item. }
    {$IFDEF GDI}
    property HelpContext: Integer read FHelpContext write SetHelpContext;
    {* Help context for entire menu (help context can not be assigned to
       individual menu items). }
    {$ENDIF GDI}

    procedure AssignEvents( StartIdx: Integer; const Events: array of TOnMenuItem );
    {* It is possible to assign its own event handler to every menu item
       using this call. This procedure also is called automatically in
       a constructor NewMenuEx. }

    function Popup( X, Y : Integer ): Integer;  {!ecm}
    {* Only for popup menu - to popup it at the given position on screen.
       Return: If you specify TPM_RETURNCMD in the uFlags parameter, the return
       value is the menu-item identifier of the item that the user selected.
       If the user cancels the menu without making a selection, or if an error
       occurs, then the return value is zero.
       If you do not specify TPM_RETURNCMD in the uFlags parameter, the return
       value is nonzero if the function succeeds and zero if it fails. }
    function PopupEx( X, Y: Integer ): Integer; {!ecm}
    {* This version of popup command is very useful, when popup menu is activated
       when its parent window is not visible (e.g., for a kind of applications,
       which always are invisible, and can be activated only using tray icon).
       PopupEx method provides correct tracking of menu disappearing when mouse
       is clicked anywhere else on screen, fixing strange menu behavior in some
       Windows versions (NT).
       |<br>
       Actually, when PopupEx used, parent form is shown but below of visible
       screen, and when menu is disappearing, previous state of the form (visibility
       and position) are restored. If such solvation is not satisfying You,
       You can do something else (e.g., use region clipping, etc.) }
    property OnPopup: TOnEvent read fOnPopup write fOnPopup;
    {* This event occurs before the popup menu is shown. }
    property NotPopup: Boolean read FNotPopup write FNotPopup;
    {* Set this property to true to prevent popup of popup menu, e.g. in
       OnPopup event handler. }
    property Flags: DWORD read FPopupFlags write FPopupFlags;
    {* Pop-up flags, which are used to call TrackPopupMenuEx, when Popup or
       PopupEx method is called. Can be a combination of following values:
       |<br>
       TPM_CENTERALIGN or TPM_LEFTALIGN or TPM_RIGHTALIGN
       |<br>
       TPM_BOTTOMALIGN or TPM_TOPALIGN or TPM_VCENTERALIGN
       |<br>
       TPM_NONOTIFY or TPM_RETURNCMD
       |<br>
       TPM_LEFTBUTTON or TPM_RIGHTBUTTON
       |<br>
       TPM_HORNEGANIMATION or TPM_HORPOSANIMATION or TPM_NOANIMATION or
       TPM_VERNEGANIMATION or TPM_VERPOSANIMATION
       |<br>
       TPM_HORIZONTAL or TPM_VERTICAL.
       |<br>
       By default, a combination TPM_LEFTALIGN or TPM_LEFTBUTTON is used. }
    function Insert(InsertBefore: Integer; ACaption: PKOLChar; Event: TOnMenuItem;
         Options: TMenuOptions): PMenu;
    {* Inserts new menu item before item, given by Id (>=4096) or index
       value InsertBefore. Pointer to an object created is returned. }
    property SubMenu: HMenu read FHandle; // write SetSubMenu;
    {* Submenu associated with the menu item. The same as Handle. It was possible
       in ealier versions to change this value, replacing (removing, assigning)
       entire popup menu as a submenu for menu item.
       But in modern version of TMenu, this is not possible.
       Instead, entire menu object should be added or removed using
       InsertSubmenu or RemoveSubmenu methods. }
    procedure InsertSubMenu( SubMenuToInsert: PMenu; InsertBefore: Integer );
    {* Inserts existing menu item (together with its subitems if any present)
       into given position. See also RemoveSubMenu. }
    function RemoveSubMenu( ItemToRemove: Integer ): PMenu;
    {* Removes menu item from the menu, returning TMenu object, representing it,
       if submenu item, having its own children, detached. If an individual menu
       item is removed, nil is returned.
       This function can be useful to add or remove dynamically entire submenus
       (created together with its subitems). }
    property OnMeasureItem: TOnMeasureItem read FOnMeasureItem write SetOnMeasureItem;
    {* This event is called for owner-drawn menu items. Event handler should return
       menu item height in lower word of a result and item width (for menu) in
       high word of result. If either for height or for width returned value is 0,
       a default one is used. }
    property OnDrawItem: TOnDrawItem read FOnDrawItem write SetOnDrawItem;
    {* This event is called for owner-drawn menu items. }
    property OwnerDraw: Boolean read FOwnerDraw write SetOwnerDraw;
    {* Set this property to true for some items to make it owner-draw. }

    // For compatibility with old code (be sure that item with given index
    // actually exists):
    function GetMenuItemHandle( Idx : Integer ): DWORD;
    {* Returns Id of menu item with given index. }
    property ItemHandle[ Idx: Integer ]: DWORD read GetMenuItemHandle;
    {* Returns handle for item given by index. }
    property ItemChecked[ Idx : Integer ] : Boolean read GetItemChecked write SetItemChecked;
    {* True, if correspondent menu item is checked. }
    procedure RadioCheck( Idx : Integer );
    {* Call this method to check radio item. For radio items, do not
       use assignment to ItemChecked or Checked properties. }
    property ItemBitmap[ Idx: Integer ]: HBitmap read GetItemBitmap write SetItemBitmap;
    {* This property allows to assign bitmap to menu item (for unchecked state
       only - for checked menu items default checkmark bitmap is used). }
    procedure AssignBitmaps( StartIdx: Integer; Bitmaps: array of HBitmap );
    {* Can be used to assign bitmaps to several menu items during one call. }
	property ItemText[ Idx: Integer ]: KOLString read GetItemText write SetItemText;
    {* This property allows to get / modify menu item text at run time. }
    property ItemEnabled[ Idx: Integer ]: Boolean read GetItemEnabled write SetItemEnabled;
    {* Controls enabling / disabling menu items. Disabled menu items are
       displayed (grayed) but inaccessible to click. }
    property ItemVisible[ Idx: Integer ]: Boolean read GetItemVisible write SetItemVisible;
    {* This property allows to simulate visibility of menu items (implementing
       it by removing or inserting again if needed. For items of submenu, which
       is made invisible, True is returned. If such item made Visible, entire
       submenu with all its parent menu items becomes visible. To release menu
       properly it is necessary to make before all its items visible again.
       This does not matter, if menu is released at the end of execution, but
       can be sensible if owner form is destroyed and re-created at run time
       dynamically. }
    property ItemHelpContext[ Idx: Integer ]: Integer read GetItemHelpContext
      write SetItemHelpContext;
    function ParentItem( Idx: Integer ): Integer;
    {* Returns index of parent menu item (for submenu item). If there are no
       such item (Idx corresponds to root level menu item), -1 is returned. }
    property ItemAccelerator[ Idx: Integer ]: TMenuAccelerator read GetItemAccelerator write SetItemAccelerator;
    {* Allows to get / change accelerator key kodes assigned to menu items.
       Has no effect unless SupportMnemonics called for a form. }
    property ItemSubmenu[ Idx: Integer ]: HMenu read GetItemSubmenu; // write SetItemSubmenu;
    {* Retrieves submenu item dynamically. See also SubMenu property. }

    // by Sergey Shisminzev:
	function AddItem(ACaption: PKOLChar; Event: TOnMenuItem; Options: TMenuOptions): Integer;
    {* Adds menu item dynamically. Returns ID of the added item. }
	function InsertItem(InsertBefore: Integer; ACaption: PKOLChar; Event: TOnMenuItem; Options: TMenuOptions): Integer;
    {* Inserts menu item before an item with ID, given by InsertBefore parameter. }
	function InsertItemEx(InsertBefore: Integer; ACaption: PKOLChar; Event: TOnMenuItem; Options: TMenuOptions;
             ByPosition: Boolean): Integer;
    {* Inserts menu item by command or by position, dependant on ByPosition parameter }
    procedure RedrawFormMenuBar;
    {* }

    {$IFDEF USE_MENU_CURCTL}
    property CurCtl: PControl read fCurCtl write fCurCtl;
    {* By Alexander Pravdin. This property is assigned to a control which were
       initiated a pop-up, for popup menu. }
    {$ENDIF USE_MENU_CURCTL}
  {$ENDIF GDI}
  end;
//[END OF TMenu DEFINITION]

{$IFDEF WIN_GDI}
//[MenuStructSize VARIABLE]
function MenuStructSize: Integer;
{* Returns 44 under Windows95, and 48 (=sizeof(TMenuItemInfo) under all other
   Windows versions. }

var FDynamicMenuID: DWORD = $1000;
{$ENDIF WIN_GDI}
//[NewMenu DECLARATION]
function NewMenu( AParent : PControl; MaxCmdReserve: DWORD;
  const Template : array of PKOLChar; aOnMenuItem: TOnMenuItem ): PMenu;
{* Menu constructor. First created menu becomes main menu of form (if AParent
   is a form). All other menus becomes popup (can be activated using Popup
   method). To provide dynamic replacing of main menu, create all popup
   menus as children of any other control, not form itself.
   When Menu is created, pass FirstCmd integer value to set it
   as ID of first menu item (all other ID's obtained by incrementing this value),
   and Template, which is an array of PChar (usually array of string constants),
   containing list of menu item identifiers and/or formatting characters.
|<br>&nbsp;&nbsp;&nbsp;
  FirstCmd value is assigned to first menu item created as its ID,
  all follow menu items are assigned to ID's obtained from FirstCmd incrementing
  it by 1. It is desirable to provide not intersected ranges of ID's for
  defferent menus in the applet.
|<br>&nbsp;&nbsp;&nbsp;
  Following formatting characters can be used in menu template strings:
|&L=<br><b>%1</b>
  <L &amp; (in identifier)> - to underline next character and use it as a shortcut character
           when possible;
  <L + (in front of identifier)> - to make item checked. If also
|<b>!</b> is used before <b>
  &
|</b> than radioitem is defined;
  <L - (in front of identifier)> - item not checked;
  <L - (separate)> - separator (between two items);
  <L ( (separate)> - start of submenu;
  <L ) (separate)> - end of submenu;
|<br>&nbsp;&nbsp;&nbsp;
  To get access to menu items, use constants 0, 1, etc. It is a good idea
  to create special enumerated type to index correspondent menu items
  using Ord( ) operator. Note in that case, that it is necessary only to
  define constants correspondent to identifiers (positions, correspondent
  to separators or submenu brackets are not identified by numbers).
|<br>&nbsp;&nbsp;&nbsp;
}

function NewMenuEx( AParent : PControl; FirstCmd : Integer;
  const Template : array of PKOLChar; aOnMenuItems: array of TOnMenuItem ): PMenu;
{* Creates menu, assigning its own event handler for every (enough) menu item. }
{$IFDEF WIN_GDI}

//[MakeAccelerator DECLARATION]
function MakeAccelerator( fVirt: Byte; Key: Word ): TMenuAccelerator;
{* Creates accelerator item to assign it to TMenu.ItemAccelerator[ ] property
   easy.}

//[GetAcceleratorText DECLARATION]
// {YS} added 7 Aug 2004
function GetAcceleratorText( const Accelerator: TMenuAccelerator ): KOLString;
{* Returns text representation of accelerator.
   |<hr>

   <R System functions and working with windows>
}
//[Window FUNCTIONS DECLARATIONS]
type
  TWindowChildKind = ( wcActive, wcFocus, wcCapture, wcMenuOwner,
                       wcMoveSize, wcCaret );
  {* Type of window child kind. Used in function GetWindowChild. }

function GetWindowChild( Wnd: HWnd; Kind: TWindowChildKind ): HWnd;
{* Returns child of given top-level window, having given characteristics.
   For example, it is possible to get know for foreground window,
   which of its child window has focus. This function does not work in old
   Windows 95 (returns Wnd in that case). But for Windows 98, Windows NT/2000
   this function works fine. To obtain focused child of the window,
   use GetFocusedWindow, which is independant from Windows version. }

function GetFocusedChild( Wnd: HWnd ): HWnd;
{* Returns focused child of given window (which should be foreground
   and active, certainly). 0 is returned either if Wnd is not active
   or Wnd has no focused child window. }

function Stroke2Window( Wnd: HWnd; const S: AnsiString ): Boolean;
{* Posts characters from string S to those child window of Wnd, which
   has focus now (top-level window Wnd must be foreground, and have
   focused edit-aware control to receive the stroke).
   |<br>
   This function allows only to post typeable characters (including
   such special symbols as #13 (Enter), #9 (Tab), #8 (BackSpace), etc.
   |<br>
   See also function Stroke2WindowEx, which allows to post any key down
   and up events, simulating keyboard for given (automated) application. }

function Stroke2WindowEx( Wnd: HWnd; const S: AnsiString; Wait: Boolean ): Boolean;
{* In addition to function Stroke2Window, this one can send special keys
   to given window, including functional keys and navigation keys. To
   post special key to target window, place a combination of names of
   such key together with keys, which should be passed simultaneously,
   between square or figure brackets. For example, [Ctrl F1], [Alt Shift Home],
   [Ctrl E]. For letters and usual characters, it is not necessary to
   simulate pressing it with determining all Shift combinations and it is
   sufficient to pass characters as is. (E.g., not '[Shift 1]', but '!'). }

function FindWindowByThreadID( ThreadID : DWORD ) : HWnd;
{* Searches for window, belonging to a given thread. }

function DesktopPixelFormat: TPixelFormat;
{* Returns the pixel format correspondent to current desktop color resolution.
   Use this function to decide which format to use for converting bitmap,
   planned to draw transparently using TBitmap.DrawTransparent or
   TBitmap.StretchDrawTransparent methods. }

function GetDesktopRect : TRect;
{* Returns rectangle of screen, free of taskbar and other
   similar app-bars, which reduces size of available desktop
   when created. }
function GetWorkArea: TRect;
{* The same as GetDesktopRect, but obtained calling SystemParametersInfo. }

function ExecuteWait( const AppPath, CmdLine, DfltDirectory: KOLString;
         Show: DWORD; TimeOut: DWORD; ProcID: PDWORD ): Boolean;
{* Allows to execute an application and wait when it is finished. Pass
   INFINITE constant as TimeOut, if You sure that application is finished
   anyway. If another value passed as a TimeOut (in milliseconds), and
   application was not finished for that time, ExecuteWait is returning
   FALSE, and if ProcID is not nil, than ProcID^ contains started process
   handle (it can be used to wait it more, or to terminate it using
   TerminateProcess API function).
   |<br>
   Launching application can be console or GUI - it does not matter.
   Pass SW_SHOW, SW_HIDE or other SW_XXX constant as Show parameter
   as appropriate.
   |<br>
   True is returned only in case when application specified was launched
   successfully and finished for TimeOut specified. Otherwise, check
   ProcID^ variable: if it is 0, process could not be launched (and it
   is possible to get information about error using GetLastError API
   function in a such case). You can freely pass nil in place of ProcID
   parameter, but this is acually correct only when TimeOut is INFINITE. }
function ExecuteIORedirect( const AppPath, CmdLine, DfltDirectory: KOLString;
         Show: DWORD; ProcID: PDWORD; InPipe, OutPipeWr, OutPipeRd: PHandle ): Boolean;
{* Executes an application with its console input and output redirection.
   Terminating of the application is not waiting, but if ProcID pointer
   is defined, it receives process Id launched, so it is possible to
   call WaitForSingleObject for it. InPipe is a pointer to THandle variable
   which receives a handle to input pipe of the console redirected. The same
   is for OutPipeWr and OutPipeRd, but for output of the console redirected.
   Before reading from OutPipeRd^, first close OutPipeWr^. If you run
   simple console application, for which you want to read results after its
   termination, you can use ExecuteConsoleAppIORedirect instead.
   |<br>&nbsp;&nbsp;&nbsp;
   Notes: if your application is not console and it does not create console
   using AllocConsole, this function will fail to redirect input-output. }
function ExecuteConsoleAppIORedirect( const AppPath, CmdLine, DfltDirectory: AnsiString;
         Show: DWORD; const InStr: AnsiString; var OutStr: AnsiString; WaitTimeout: DWORD )
         : Boolean;
{* Executes an application, redirecting its console input and output.
   After redirecting input and output and launching the application,
   content of InStr is written to input stream of the application, then
   the application is waiting for its termination (WaitTimeout milliseconds
   or INFINITE, as passed) and console output of the application is read to
   OutStr. TRUE is returned only in case, when all these tasks are
   completed successfully.
   |<br>&nbsp;&nbsp;&nbsp;
   Notes: if your application is not console and it does not create console
   using AllocConsole, this function will fail to redirect input-output. }

function WindowsShutdown( const Machine : KOLString; Force, Reboot : Boolean ) : Boolean;
{* Shut down of Windows NT. Pass Machine = '' to shutdown this PC.
   Pass Reboot = True to reboot immediatelly after shut down. }
function WindowsLogoff( Force : Boolean ) : Boolean;
{* Logoff of Windows. }


type
  TWindowsVersion = ( wv31, wv95, wv98, wvME, wvNT, wvY2K, wvXP, wvServer2003,
                  wvVista, wvSeven );
  {* Windows versions constants. }
  TWindowsVersions = Set of TWindowsVersion;
  {* Set of Windows version (e.g. to define a range of versions supported by the
     application). }

function WinVer : TWindowsVersion;
{* Returns Windows version. }
function IsWinVer( Ver : TWindowsVersions ) : Boolean;
{* Returns True if Windows version is in given range of values. }
//[Parameters FUNCTIONS DECLARATIONS]
function ParamStr( Idx: Integer ): KOLString;
{* Returns command-line parameter by index. This function supersides
   standard ParamStr function. }
function ParamCount: Integer;
{* Returns number of parameters in command line.
|<hr>
}
{$ENDIF WIN_GDI}

{$IFDEF INPACKAGE}
  {$IFDEF ASM_VERSION}
    {$UNDEF ASM_VERSION}
  {$ENDIF}
{$ENDIF}

{$IFDEF WIN_GDI}
//{$DEFINE CHK_BITBLT}
procedure Chk_BitBlt;
{$IFDEF ASM_VERSION}
  {$DEFINE ASM_DC}
{$ENDIF}
{$IFDEF ASM_DC}
procedure StartDC;
procedure FinishDC;
{$ENDIF ASM_VERSION}

//[WndProcXXX OTHER DECLARATIONS]
function WndProcCtrl( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;
function WndProcDoEraseBkgnd( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;

var CreatingWindow: PControl;
    //ActiveWindow: HWnd;
{$ENDIF WIN_GDI}
//[Assert OPERATOR DECLARATION]
{-}
{$IFDEF _D2}
// Assert operator was not available in Delphi2. Provide here easy Assert
// procedure for Delphi2.
procedure Assert( Cond: Boolean; const Msg: AnsiString );

var AssertErrorProc: procedure( const Message, Filename: AnsiString; LineNumber: Integer );
{$ENDIF}
{+}

//[CUSTOM EXTENSIONS]
{$IFDEF USE_CUSTOMEXTENSIONS}
  {$I CUSTOM_KOL_EXTENSION.inc} // See comments in TControl
{$ENDIF}

{$IFDEF DEBUG_ENDSESSION}
var EndSession_Initiated: Boolean;
{$ENDIF}

{$IFDEF WIN_GDI}
//[FMMNotify VARIABLE]
var
  FMMNotify: procedure( var Msg: TMsg );

//[procedure ClearText forward declaration]
procedure ClearText( Sender: PControl );
//[procedure ClearListbox forward declaration]
procedure ClearListbox( Sender: PControl );
//[procedure ClearCombobox forward declaration]
procedure ClearCombobox( Sender: PControl );
//[procedure ClearListView forward declaration]
procedure ClearListView( Sender: PControl );
//[procedure ClearTreeView forward declaration]
procedure ClearTreeView( TV: PControl );

//[START OF ACTIONS]
const
  ButtonActions: TCommandActions = (
    aClear: ClearText;
    aAddText: nil;
    aClick: BN_CLICKED;
    aEnter: BN_SETFOCUS;
    aLeave: BN_KILLFOCUS;
    aChange: 0; //BN_CLICKED;
    aSelChange: 0;
    aGetCount: 0;
    aSetCount: 0;
    aGetItemLength: 0;
    aGetItemText: 0;
    aSetItemText: 0;
    aGetItemData: 0;
    aSetItemData: 0;
    aAddItem: 0;
    aDeleteItem: 0;
    aInsertItem: 0;
    aFindItem: 0;
    aFindPartial: 0;
    aItem2Pos: 0;
    aPos2Item: 0;
    //aGetSelStart: 0;
    aGetSelCount: 0;
    aGetSelected: 0;
    aGetSelRange: 0;
    //aExGetSelRange: 0;
    aGetCurrent: 0;
    aSetSelected: 0;
    aSetCurrent: 0;
    aSetSelRange: 0;
    aExSetSelRange: 0;
    aGetSelection: 0;
    aReplaceSel: 0;
    aTextAlignLeft: BS_LEFT;
    aTextAlignRight: BS_RIGHT;
    aTextAlignCenter: BS_CENTER;
    aTextAlignMask: 0;
    aVertAlignCenter: BS_VCENTER shr 8;
    aVertAlignTop: BS_TOP shr 8;
    aVertAlignBottom: BS_BOTTOM shr 8;
    aDir: 0;
    aSetLimit: 0;
    aSetImgList: 0;
    aAutoSzX: 14;
    aAutoSzY: 6;
    aSetBkColor: 0;
  );

const
  LabelActions: TCommandActions = (
    aClear: ClearText;
    aAddText: nil;
    aClick: 0;
    aEnter: 0;
    aLeave: 0;
    aChange: 0;
    aSelChange: 0;
    aGetCount: 0;
    aSetCount: 0;
    aGetItemLength: 0;
    aGetItemText: 0;
    aSetItemText: 0;
    aGetItemData: 0;
    aSetItemData: 0;
    aAddItem: 0;
    aDeleteItem: 0;
    aInsertItem: 0;
    aFindItem: 0;
    aFindPartial: 0;
    aItem2Pos: 0;
    aPos2Item: 0;
    //aGetSelStart: 0;
    aGetSelCount: 0;
    aGetSelected: 0;
    aGetSelRange: 0;
    //aExGetSelRange: 0;
    aGetCurrent: 0;
    aSetSelected: 0;
    aSetCurrent: 0;
    aSetSelRange: 0;
    aExSetSelRange: 0;
    aGetSelection: 0;
    aReplaceSel: 0;
    aTextAlignLeft: SS_LEFT;
    aTextAlignRight: SS_RIGHT;
    aTextAlignCenter: SS_CENTER;
    aTextAlignMask: SS_LEFTNOWORDWRAP;
    aVertAlignCenter: SS_CENTERIMAGE shr 8;
    aVertAlignTop: 0;
    aVertAlignBottom: 0;
    aDir: 0;
    aSetLimit: 0;
    aSetImgList: 0;
    aAutoSzX: 1;
    aAutoSzY: 1;
    aSetBkColor: 0;
  );

const
  EN_LINK                             = $070b;
  EditActions: TCommandActions = (
    aClear: ClearText;
    aAddText: nil;
    aClick: 0;
    aEnter: EN_SETFOCUS;
    aLeave: EN_KILLFOCUS;
    aChange: EN_CHANGE;
    aSelChange: 0;
    aGetCount: EM_GETLINECOUNT;
    aSetCount: 0;
    aGetItemLength: EM_LINELENGTH;
    aGetItemText: EM_GETLINE;
    aSetItemText: EM_REPLACESEL;
    aGetItemData: 0;
    aSetItemData: 0;
    aAddItem: 0;
    aDeleteItem: 0;
    aInsertItem: 0;
    aFindItem: 0;
    aFindPartial: 0;
    aItem2Pos: EM_LINEINDEX;
    aPos2Item: EM_LINEFROMCHAR;
    //aGetSelStart: 0;
    aGetSelCount: EM_GETSEL;
    aGetSelected: 0;
    aGetSelRange: EM_GETSEL;
    //aExGetSelRange: 0;
    aGetCurrent: EM_LINEINDEX;
    aSetSelected: 0;
    aSetCurrent: 0;
    aSetSelRange: EM_SETSEL;
    aExSetSelRange: 0;
    aGetSelection: 0;
    aReplaceSel: EM_REPLACESEL;
    aTextAlignLeft: ES_LEFT;
    aTextAlignRight: ES_RIGHT;
    aTextAlignCenter: ES_CENTER;
    aTextAlignMask: 0;
    aVertAlignCenter: 0;
    aVertAlignTop: 0;
    aVertAlignBottom: 0;
    aDir: 0;
    aSetLimit: EM_SETLIMITTEXT;
    aSetImgList: 0;
    aAutoSzX: 0;
    aAutoSzY: 6;
    aSetBkColor: 0;
    aItem2XY: EM_POSFROMCHAR;
  );

const
  ListActions: TCommandActions = (
    aClear: ClearListbox;
    aAddText: nil;
    aClick: LBN_DBLCLK;
    aEnter: LBN_SETFOCUS;
    aLeave: LBN_KILLFOCUS;
    aChange: 0;
    aSelChange: LBN_SELCHANGE;
    aGetCount: LB_GETCOUNT;
    aSetCount: LB_SETCOUNT;
    aGetItemLength: LB_GETTEXTLEN;
    aGetItemText: LB_GETTEXT;
    aSetItemText: 0;
    aGetItemData: LB_GETITEMDATA;
    aSetItemData: LB_SETITEMDATA;
    aAddItem: LB_ADDSTRING;
    aDeleteItem: LB_DELETESTRING;
    aInsertItem: LB_INSERTSTRING;
    aFindItem: LB_FINDSTRINGEXACT;
    aFindPartial: LB_FINDSTRING;
    aItem2Pos: 0;
    aPos2Item: 0;
    //aGetSelStart: 0;
    aGetSelCount: LB_GETSELCOUNT;
    aGetSelected: LB_GETSEL;
    aGetSelRange: 0;
    //aExGetSelRange: 0;
    aGetCurrent: LB_GETCURSEL;
    aSetSelected: LB_SETSEL;
    aSetCurrent: LB_SETCURSEL;
    aSetSelRange: 0;
    aExSetSelRange: 0;
    aGetSelection: 0;
    aReplaceSel: 0;
    aTextAlignLeft: 0;
    aTextAlignRight: 0;
    aTextAlignCenter: 0;
    aTextAlignMask: 0;
    aVertAlignCenter: 0;
    aVertAlignTop: 0;
    aVertAlignBottom: 0;
    aDir: LB_DIR;
    aSetLimit: 0;
    aSetImgList: 0;
    aAutoSzX: 0;
    aAutoSzY: 0;
    aSetBkColor: 0;
    aItem2XY: LB_GETITEMRECT;
  );

const
  ComboActions: TCommandActions = (
    aClear: ClearCombobox;
    aAddText: nil;
    aClick: CBN_DBLCLK;
    aEnter: CBN_SETFOCUS;
    aLeave: CBN_KILLFOCUS;
    aChange: CBN_EDITCHANGE;
    aSelChange: CM_CBN_SELCHANGE; // CBN_SELCHANGE;
    aGetCount: CB_GETCOUNT;
    aSetCount: 0;
    aGetItemLength: CB_GETLBTEXTLEN;
    aGetItemText: CB_GETLBTEXT;
    aSetItemText: 0;
    aGetItemData: CB_GETITEMDATA;
    aSetItemData: CB_SETITEMDATA;
    aAddItem: CB_ADDSTRING;
    aDeleteItem: CB_DELETESTRING;
    aInsertItem: CB_INSERTSTRING;
    aFindItem: CB_FINDSTRINGEXACT;
    aFindPartial: CB_FINDSTRING;
    aItem2Pos: 0;
    aPos2Item: 0;
    //aGetSelStart: 0;
    aGetSelCount: 0;
    aGetSelected: CB_GETCURSEL;
    aGetSelRange: 0;
    //aExGetSelRange: 0;
    aGetCurrent: CB_GETCURSEL;
    aSetSelected: 0;
    aSetCurrent: CB_SETCURSEL;
    aSetSelRange: 0;
    aExSetSelRange: 0;
    aGetSelection: 0;
    aReplaceSel: 0;
    aTextAlignLeft: 0; //ES_LEFT;
    aTextAlignRight: 0; //ES_RIGHT;
    aTextAlignCenter: 0; //ES_CENTER;
    aTextAlignMask: 0;
    aVertAlignCenter: 0;
    aVertAlignTop: 0;
    aVertAlignBottom: 0;
    aDir: CB_DIR;
    aSetLimit: 0;
    aSetImgList: 0;
    aAutoSzX: 0;
    aAutoSzY: 6;
    aSetBkColor: 0;
  );

const
  ListViewActions: TCommandActions = (
    aClear: ClearListView;
    aAddText: nil;
    aClick: 0;
    aEnter: 0;
    aLeave: 0;
    aChange: LVN_ITEMCHANGED;
    aSelChange: 0;
    aGetCount: LVM_GETITEMCOUNT;
    aSetCount: LVM_SETITEMCOUNT;
    aGetItemLength: 0;
    aGetItemText: 0;
    aSetItemText: 0;
    aGetItemData: 0;
    aSetItemData: 0;
    aAddItem: 0;
    aDeleteItem: 0;
    aInsertItem: 0;
    aFindItem: 0;
    aFindPartial: 0;
    aItem2Pos: 0;
    aPos2Item: 0;
    //aGetSelStart: LVM_GETSELECTIONMARK;
    aGetSelCount: { $8000 or} LVM_GETSELECTEDCOUNT;
    aGetSelected: LVM_GETITEMSTATE;
    aGetSelRange: 0;
    //aExGetSelRange: 0;
    aGetCurrent: LVM_GETNEXTITEM;
    aSetSelected: 0;
    aSetCurrent: 0;
    aSetSelRange: 0;
    aExSetSelRange: 0;
    aGetSelection: 0;
    aReplaceSel: 0;
    aTextAlignLeft: 0;
    aTextAlignRight: 0;
    aTextAlignCenter: 0;
    aTextAlignMask: 0;
    aVertAlignCenter: 0;
    aVertAlignTop: 0;
    aVertAlignBottom: 0;
    aDir: 0;
    aSetLimit: 0;
    aSetImgList: LVM_SETIMAGELIST;
    aAutoSzX: 0;
    aAutoSzY: 0;
    aSetBkColor: LVM_SETBKCOLOR;
    aItem2XY: LVM_GETITEMRECT;
  );

const
  TreeViewActions: TCommandActions = (
    aClear: ClearTreeView;
    aAddText: nil;
    aClick: 0;
    aEnter: 0;
    aLeave: 0;
    aChange: TVN_ENDLABELEDIT;
    aSelChange: TVN_SELCHANGED;
    aGetCount: TVM_GETCOUNT;
    aSetCount: 0;
    aGetItemLength: 0;
    aGetItemText: 0;
    aSetItemText: 0;
    aGetItemData: 0;
    aSetItemData: 0;
    aAddItem: 0;
    aDeleteItem: 0;
    aInsertItem: 0;
    aFindItem: 0;
    aFindPartial: 0;
    aItem2Pos: 0;
    aPos2Item: 0;
    //aGetSelStart: 0;
    aGetSelCount: 0;
    aGetSelected: 0;
    aGetSelRange: 0;
    //aExGetSelRange: 0;
    aGetCurrent: 0;
    aSetSelected: 0;
    aSetCurrent: 0;
    aSetSelRange: 0;
    aExSetSelRange: 0;
    aGetSelection: 0;
    aReplaceSel: 0;
    aTextAlignLeft: 0;
    aTextAlignRight: 0;
    aTextAlignCenter: 0;
    aTextAlignMask: 0;
    aVertAlignCenter: 0;
    aVertAlignTop: 0;
    aVertAlignBottom: 0;
    aDir: CB_DIR;
    aSetLimit: 0;
    aSetImgList: TVM_SETIMAGELIST;
    aAutoSzX: 0;
    aAutoSzY: 0;
    aSetBkColor: TVM_SETBKCOLOR;
    aItem2XY: TVM_GETITEMRECT;
  );

const
  TabControlActions: TCommandActions = (
    aClear: ClearText;
    aAddText: nil;
    aClick: 0;
    aEnter: 0;
    aLeave: 0;
    aChange: TCN_SELCHANGE;
    aSelChange: TCN_SELCHANGE;
    aGetCount: TCM_GETITEMCOUNT;
    aSetCount: 0;
    aGetItemLength: 0;
    aGetItemText: 0;
    aSetItemText: 0;
    aGetItemData: 0;
    aSetItemData: 0;
    aAddItem: 0;
    aDeleteItem: 0;
    aInsertItem: 0;
    aFindItem: 0;
    aFindPartial: 0;
    aItem2Pos: 0;
    aPos2Item: 0;
    //aGetSelStart: 0;
    aGetSelCount: 0;
    aGetSelected: 0;
    aGetSelRange: 0;
    //aExGetSelRange: 0;
    aGetCurrent: TCM_GETCURSEL;
    aSetSelected: 0;
    aSetCurrent: TCM_SETCURSEL; //TCM_SETCURFOCUS;
    aSetSelRange: 0;
    aExSetSelRange: 0;
    aGetSelection: 0;
    aReplaceSel: 0;
    aTextAlignLeft: 0;
    aTextAlignRight: 0;
    aTextAlignCenter: 0;
    aTextAlignMask: 0;
    aVertAlignCenter: 0;
    aVertAlignTop: 0;
    aVertAlignBottom: 0;
    aDir: CB_DIR;
    aSetLimit: 0;
    aSetImgList: TCM_SETIMAGELIST;
    aAutoSzX: 0;
    aAutoSzY: 0;
    aSetBkColor: 0;
    aItem2XY: TCM_GETITEMRECT;
  );

{$IFNDEF NOT_USE_RICHEDIT}
const
  RichEditActions: TCommandActions = (
    aClear: ClearText;
    aAddText: nil;
    aClick: 0;
    aEnter: EN_SETFOCUS;
    aLeave: EN_KILLFOCUS;
    aChange: EN_CHANGE;
    aSelChange: EN_SELCHANGE;
    aGetCount: EM_GETLINECOUNT;
    aSetCount: 0;
    aGetItemLength: EM_LINELENGTH;
    aGetItemText: EM_GETLINE;
    aSetItemText: EM_REPLACESEL;
    aGetItemData: 0;
    aSetItemData: 0;
    aAddItem: 0;
    aDeleteItem: 0;
    aInsertItem: 0;
    aFindItem: 0;
    aFindPartial: 0;
    aItem2Pos: EM_LINEINDEX;
    aPos2Item: EM_LINEFROMCHAR;
    //aGetSelStart: 0;
    aGetSelCount: EM_GETSEL;
    aGetSelected: 0;
    aGetSelRange: EM_GETSEL;
    //aExGetSelRange: EM_EXGETSEL;
    aGetCurrent: EM_LINEINDEX;
    aSetSelected: 0;
    aSetCurrent: 0;
    aSetSelRange: 0;
    aExSetSelRange: EM_EXSETSEL;
    aGetSelection: EM_GETSELTEXT;
    aReplaceSel: EM_REPLACESEL;
    aTextAlignLeft: ES_LEFT;
    aTextAlignRight: ES_RIGHT;
    aTextAlignCenter: ES_CENTER;
    aTextAlignMask: 0;
    aVertAlignCenter: 0;
    aVertAlignTop: 0;
    aVertAlignBottom: 0;
    aDir: 0;
    aSetLimit: EM_EXLIMITTEXT;
    aSetImgList: 0;
    aAutoSzX: 0;
    aAutoSzY: 0;
    aSetBkColor: EM_SETBKGNDCOLOR;
    aItem2XY: EM_POSFROMCHAR;
  );
{$ENDIF NOT_USE_RICHEDIT}

const
  BaseFileMethods: TStreamMethods = (
    fSeek: SeekFileStream;
    fGetSiz: GetSizeFileStream;
    fSetSiz: DummySetSize;
    fRead: DummyReadWrite;
    fWrite: DummyReadWrite;
    fClose: CloseFileStream;
    fCustom: nil;
  );

  MemoryMethods: TStreamMethods = (
    fSeek: SeekMemStream;
    fGetSiz: GetSizeMemStream;
    fSetSiz: SetSizeMemStream;
    fRead: ReadMemStream;
    fWrite: WriteMemStream;
    fClose: CloseMemStream;
    fCustom: nil;
  );

  ConcatStreamMethods: TStreamMethods = (
    fSeek: SeekConcatStream;
    fGetSiz: GetSizeConcatStream;
    fSetSiz: SetSizeConcatStream;
    fRead: ReadConcatStream;
    fWrite: WriteConcatStream;
    fClose: CloseConcatStream;
    fCustom: nil;
  );

  SubStreamMethods: TStreamMethods = (
    fSeek: SeekSubStream;
    fGetSiz: GetSizeSubStream;
    fSetSiz: SetSizeSubStream;
    fRead: ReadSubStream;
    fWrite: WriteSubStream;
    fClose: CloseSubStream;
    fCustom: nil;
  );
{$ENDIF WIN_GDI}

{$IFDEF DEBUG_MCK}
procedure dummy_Log( const s: AnsiString );
var mck_Log: procedure( const s: AnsiString ) = dummy_Log;
{$ENDIF}

type
  TThemedElement = (
    teButton,
    teClock,
    teComboBox,
    teEdit,
    teExplorerBar,
    teHeader,
    teListView,
    teMenu,
    tePage,
    teProgress,
    teRebar,
    teScrollBar,
    teSpin,
    teStartPanel,
    teStatus,
    teTab,
    teTaskBand,
    teTaskBar,
    teToolBar,
    teToolTip,
    teTrackBar,
    teTrayNotify,
    teTreeview,
    teWindow
  );

var DrawThemeBackground: function(hTheme: DWORD; hdc: HDC; iPartId, iStateId: Integer;
    const pRect: TRect; pClipRect: PRECT): HRESULT; stdcall;
    OpenThemeData: function(hwnd: HWND; pszClassList: LPCWSTR): DWORD; stdcall;
    ThemeLibrary: THandle;
    IsThemeBackgroundPartiallyTransparent: function(hTheme: DWORD;
      iPartId, iStateId: Integer): BOOL; stdcall;
    DrawThemeParentBackground: function(hwnd: HWND; hdc: HDC; prc: PRECT): HRESULT; stdcall;
    CloseThemeData: function(hTheme: DWORD): HRESULT; stdcall;
    DrawThemeText: function(hTheme: DWORD; hdc: HDC; iPartId, iStateId: Integer;
      pszText: LPCWSTR; iCharCount: Integer; dwTextFlags, dwTextFlags2: DWORD;
      var pRect: TRect): HRESULT; stdcall;
    IsThemeActive: function: BOOL; stdcall;
    IsAppThemed: function: BOOL; stdcall;
    GetThemeColor: function(hTheme: DWORD; iPartId, iStateId, iPropId: Integer;
      var pColor: COLORREF): HRESULT; stdcall;

const
  themelib = 'uxtheme.dll';

type
  PThemedElementDetails = ^TThemedElementDetails;
  TThemedElementDetails = record
    Element: TThemedElement;
    Part,
    State: Integer;
  end;
  TThemedEdit = (
    teEditDontCare,
    teEditRoot,
    teEditTextNormal, teEditTextHot, teEditTextSelected, teEditTextDisabled, teEditTextFocused, teEditTextReadOnly, teEditTextAssist,
    teEditCaret
  );

function CrackStack_MapInResource( const MapName: KOLString; Max_length: Integer;
    HandleSuspiciousAddresses: Boolean ): KOLString;
{* Allows to list all procedures and functions called before current cracking
   stack frames. This version loads map-file from the resource.
   Important note: you must provide latest map file created at the last
   application build in the resource! See also CrackStack_MapInFile below. }
function CrackStack_MapInFile( const MapFileName: KOLString; Max_length: Integer;
    HandleSuspiciousAddresses: Boolean ): KOLString;
{* Allows to list all procedures and functions called before current cracking
   stack frames. This version loads map-file from the file.
   Important note: you must have the latest map file created at the last
   application build on a path specified! For example, use path GetStartDir +
   appname_wo_extention + '.map' and do not forget to set flag Map file -
   Detailed in Project Options | Linker. Use flag HandleSuspiciousAddresses
   to show all suspicious addresses found in stack (this may help to find
   errors not shown even by Delphi debugger since stack frames in some cases give
   no enough data). }

{$IFDEF _D2006orHigher}
	{$I MCKfakeClasses200x.inc} // Dufa
{$ENDIF}
//[IMPLEMENTATION]
implementation

//[USES-2]
{uses
  //ShellAPI,
  //commdlg  // removing reference to commdlg decreases executable about 0.5 K
  ; //, commctrl;
            // in Delphi3, including of commctrl.pas increases executable
            // onto about 30K. So, all needed definitions are copied here
            // (see commctrl.inc).}
//[END OF USES-2]

{$IFDEF _X_}
  {$undef uses_2}
  {$IFNDEF NOT_USE_KOLMATH}
    {$define uses_2}
  {$ENDIF NOT_USE_KOLMATH}
  {$IFDEF uses_2}
    uses {$IFNDEF NOT_USE_KOLMATH} KOLmath
           {$IFNDEF NOT_USE_EXCEPTION} , err
             {$IFDEF REDECLARATION_INSERTED_AUTOMATICALLY}
               , gdk2, pango, gtk2
             {$ENDIF REDECLARATION_INSERTED_AUTOMATICALLY}
           {$ENDIF  NOT_USE_EXCEPTION}
         {$ENDIF NOT_USE_KOLMATH};
  {$ENDIF uses_2}
{$ELSE}
  {$IFDEF USE_GRUSH}
    uses ToGRush;
  {$ELSE}
    {$IFDEF INPACKAGE}
      uses mirror, SysUtils;
    {$ENDIF INPACKAGE}
  {$ENDIF USE_GRUSH}
{$ENDIF _X_}

{$IFDEF WIN}
  {$IFDEF UNICODE_CTRLS}
    {$DEFINE implementation_part} {$I KOL_unicode.inc} {$UNDEF implementation_part}
  {$ELSE} // ANSI_CTRLS
    {$DEFINE implementation_part} {$I KOL_ansi.inc} {$UNDEF implementation_part}
  {$ENDIF UNICODE_CTRLS}
{$ENDIF WIN}

{$IFDEF DEBUG_MCK}
procedure dummy_Log( const s: AnsiString );
begin
  //
end;
{$ENDIF}
{$IFDEF WIN}
type
  PSHFileInfoA = ^TSHFileInfoA;
  PSHFileInfoW = ^TSHFileInfoW;
  PSHFileInfo = PSHFileInfoA;
  _SHFILEINFOA = record
    hIcon: HICON;                      { out: icon }
    iIcon: Integer;                    { out: icon index }
    dwAttributes: DWORD;               { out: SFGAO_ flags }
    szDisplayName: array [0..MAX_PATH-1] of  AnsiChar; { out: display name (or path) }
    szTypeName: array [0..79] of AnsiChar;             { out: type name }
  end;
  _SHFILEINFOW = record
    hIcon: HICON;                      { out: icon }
    iIcon: Integer;                    { out: icon index }
    dwAttributes: DWORD;               { out: SFGAO_ flags }
    szDisplayName: array [0..MAX_PATH-1] of WideChar; { out: display name (or path) }
    szTypeName: array [0..79] of WideChar;             { out: type name }
  end;
  _SHFILEINFO = {$IFDEF UNICODE_CTRLS} _SHFILEINFOW {$ELSE} _SHFILEINFOA {$ENDIF};
  TSHFileInfoA = _SHFILEINFOA;
  TSHFileInfoW = _SHFILEINFOW;
  TSHFileInfo = {$IFDEF UNICODE_CTRLS} TSHFileInfoW {$ELSE} TSHFileInfoA {$ENDIF};
  SHFILEINFOA = _SHFILEINFOA;
  SHFILEINFOW = _SHFILEINFOW;
  SHFILEINFO = {$IFDEF UNICODE_CTRLS} SHFILEINFOW {$ELSE} SHFILEINFOA {$ENDIF};

const
  SHGFI_ICON              = $000000100;     { get icon }
  SHGFI_DISPLAYNAME       = $000000200;     { get display name }
  SHGFI_TYPENAME          = $000000400;     { get type name }
  SHGFI_ATTRIBUTES        = $000000800;     { get attributes }
  SHGFI_ICONLOCATION      = $000001000;     { get icon location }
  SHGFI_EXETYPE           = $000002000;     { return exe type }
  SHGFI_SYSICONINDEX      = $000004000;     { get system icon index }
  SHGFI_LINKOVERLAY       = $000008000;     { put a link overlay on icon }
  SHGFI_SELECTED          = $000010000;     { show icon in selected state }
  SHGFI_LARGEICON         = $000000000;     { get large icon }
  SHGFI_SMALLICON         = $000000001;     { get small icon }
  SHGFI_OPENICON          = $000000002;     { get open icon }
  SHGFI_SHELLICONSIZE     = $000000004;     { get shell size icon }
  SHGFI_PIDL              = $000000008;     { pszPath is a pidl }
  SHGFI_USEFILEATTRIBUTES = $000000010;     { use passed dwFileAttribute }

function SHGetFileInfoA(pszPath: PAnsiChar; dwFileAttributes: DWORD;
  var psfi: TSHFileInfo; cbFileInfo, uFlags: UINT): DWORD; stdcall;
  external 'shell32.dll' name 'SHGetFileInfoA';
{$IFDEF UNICODE_CTRLS}
function SHGetFileInfoW(pszPath: PWideChar; dwFileAttributes: DWORD;
  var psfi: TSHFileInfo; cbFileInfo, uFlags: UINT): DWORD; stdcall;
  external 'shell32.dll' name 'SHGetFileInfoW';
{$ENDIF UNICODE_CTRLS}

type
  FILEOP_FLAGS = Word;
  PRINTEROP_FLAGS = Word;

  PSHFileOpStructA = ^TSHFileOpStructA;
  PSHFileOpStructW = ^TSHFileOpStructW;
  PSHFileOpStruct = PSHFileOpStructA;
  _SHFILEOPSTRUCTA = packed record
    Wnd: HWND;
    wFunc: UINT;
    pFrom: PAnsiChar;
    pTo: PAnsiChar;
    fFlags: FILEOP_FLAGS;
    fAnyOperationsAborted: BOOL;
    hNameMappings: Pointer;
    lpszProgressTitle: PAnsiChar; { only used if FOF_SIMPLEPROGRESS }
  end;
  _SHFILEOPSTRUCTW = packed record
    Wnd: HWND;
    wFunc: UINT;
    pFrom: PWideChar;
    pTo: PWideChar;
    fFlags: FILEOP_FLAGS;
    fAnyOperationsAborted: BOOL;
    hNameMappings: Pointer;
    lpszProgressTitle: PWideChar; { only used if FOF_SIMPLEPROGRESS }
  end;
  _SHFILEOPSTRUCT = _SHFILEOPSTRUCTA;
  TSHFileOpStructA = _SHFILEOPSTRUCTA;
  TSHFileOpStructW = _SHFILEOPSTRUCTW;
  TSHFileOpStruct = TSHFileOpStructA;
  SHFILEOPSTRUCTA = _SHFILEOPSTRUCTA;
  SHFILEOPSTRUCTW = _SHFILEOPSTRUCTW;
  SHFILEOPSTRUCT = SHFILEOPSTRUCTA;

const
  FO_MOVE           = $0001;
  FO_COPY           = $0002;
  FO_DELETE         = $0003;
  FO_RENAME         = $0004;

  FOF_MULTIDESTFILES         = $0001;
  FOF_CONFIRMMOUSE           = $0002;
  FOF_SILENT                 = $0004;  { don't create progress/report }
  FOF_RENAMEONCOLLISION      = $0008;
  FOF_NOCONFIRMATION         = $0010;  { Don't prompt the user. }
  FOF_WANTMAPPINGHANDLE      = $0020;  { Fill in SHFILEOPSTRUCT.hNameMappings
                                         Must be freed using SHFreeNameMappings }
  FOF_ALLOWUNDO              = $0040;
  FOF_FILESONLY              = $0080;  { on *.*, do only files }
  FOF_SIMPLEPROGRESS         = $0100;  { means don't show names of files }
  FOF_NOCONFIRMMKDIR         = $0200;  { don't confirm making any needed dirs }
  FOF_NOERRORUI              = $0400;  { don't put up error UI }


{$IFDEF UNICODE_CTRLS}
function SHFileOperationW(const lpFileOp: TSHFileOpStructW): Integer; stdcall;
         external 'shell32.dll' name 'SHFileOperationW';
{$ENDIF}

function SHFileOperationA(const lpFileOp: TSHFileOpStructA): Integer; stdcall;
         external 'shell32.dll' name 'SHFileOperationA';

type
  PNotifyIconDataA = ^TNotifyIconDataA;
  PNotifyIconDataW = ^TNotifyIconDataW;
  PNotifyIconData = PNotifyIconDataA;
  _NOTIFYICONDATAA = record
    cbSize: DWORD;
    Wnd: HWND;
    uID: UINT;
    uFlags: UINT;
    uCallbackMessage: UINT;
    hIcon: HICON;
    szTip: array [0..63] of AnsiChar;
  end;
  _NOTIFYICONDATAW = record
    cbSize: DWORD;
    Wnd: HWND;
    uID: UINT;
    uFlags: UINT;
    uCallbackMessage: UINT;
    hIcon: HICON;
    szTip: array [0..63] of WideChar;
  end;
  _NOTIFYICONDATA = _NOTIFYICONDATAA;
  TNotifyIconDataA = _NOTIFYICONDATAA;
  TNotifyIconDataW = _NOTIFYICONDATAW;
  TNotifyIconData = TNotifyIconDataA;
  NOTIFYICONDATAA = _NOTIFYICONDATAA;
  NOTIFYICONDATAW = _NOTIFYICONDATAW;
  NOTIFYICONDATA = NOTIFYICONDATAA;

const
  NIM_ADD         = $00000000;
  NIM_MODIFY      = $00000001;
  NIM_DELETE      = $00000002;

  NIF_MESSAGE     = $00000001;
  NIF_ICON        = $00000002;
  NIF_TIP         = $00000004;

{$IFDEF UNICODE_CTRLS}
function Shell_NotifyIcon(dwMessage: DWORD; lpData: PNotifyIconDataW): BOOL; stdcall;
         external 'shell32.dll' name 'Shell_NotifyIconW';
{$ELSE}
function Shell_NotifyIcon(dwMessage: DWORD; lpData: PNotifyIconData): BOOL; stdcall;
         external 'shell32.dll' name 'Shell_NotifyIconA';
{$ENDIF UNICODE_CTRLS}

{$IFDEF UNICODE_CTRLS}
function ExtractIcon(hInst: HINST; lpszExeFileName: PKOLChar;
  nIconIndex: UINT): HICON; stdcall;
  external 'shell32.dll' name 'ExtractIconW';
{$ELSE}
function ExtractIcon(hInst: HINST; lpszExeFileName: PKOLChar;
  nIconIndex: UINT): HICON; stdcall;
  external 'shell32.dll' name 'ExtractIconA';
{$ENDIF UNICODE_CTRLS}
{$ENDIF WIN}
{$IFDEF WIN_GDI}

type
  HDROP = Longint;

function DragQueryPoint(Drop: HDROP; var Point: TPoint): BOOL; stdcall;
         external 'shell32.dll' name 'DragQueryPoint';
{$IFDEF UNICODE_CTRLS}
function DragQueryFile(Drop: HDROP; FileIndex: UINT; FileName: PWideChar; cb: UINT): UINT; stdcall;
         external 'shell32.dll' name 'DragQueryFileW';
{$ELSE}
function DragQueryFile(Drop: HDROP; FileIndex: UINT; FileName: PAnsiChar; cb: UINT): UINT; stdcall;
         external 'shell32.dll' name 'DragQueryFileA';
{$ENDIF UNICODE_CTRLS}
procedure DragFinish(Drop: HDROP); stdcall;
          external 'shell32.dll' name 'DragFinish';
procedure DragAcceptFiles(Wnd: HWND; Accept: BOOL); stdcall;
          external 'shell32.dll' name 'DragAcceptFiles';

const
  OFN_READONLY = $00000001;
  OFN_OVERWRITEPROMPT = $00000002;
  OFN_HIDEREADONLY = $00000004;
  OFN_NOCHANGEDIR = $00000008;
  OFN_SHOWHELP = $00000010;
  OFN_ENABLEHOOK = $00000020;
  OFN_ENABLETEMPLATE = $00000040;
  OFN_ENABLETEMPLATEHANDLE = $00000080;
  OFN_NOVALIDATE = $00000100;
  OFN_ALLOWMULTISELECT = $00000200;
  OFN_EXTENSIONDIFFERENT = $00000400;
  OFN_PATHMUSTEXIST = $00000800;
  OFN_FILEMUSTEXIST = $00001000;
  OFN_CREATEPROMPT = $00002000;
  OFN_SHAREAWARE = $00004000;
  OFN_NOREADONLYRETURN = $00008000;
  OFN_NOTESTFILECREATE = $00010000;
  OFN_NONETWORKBUTTON = $00020000;
  OFN_NOLONGNAMES = $00040000;
  OFN_EXPLORER = $00080000;
  OFN_NODEREFERENCELINKS = $00100000;
  OFN_LONGNAMES = $00200000;
  OFN_ENABLEINCLUDENOTIFY = $00400000;
  OFN_ENABLESIZING = $00800000;
  OFN_DONTADDTORECENT = $02000000;
  OFN_FORCESHOWHIDDEN = $10000000;    // Show All files including System and hidden files
  OFN_EX_NOPLACESBAR = $00000001;
  OFN_SHAREFALLTHROUGH = 2;
  OFN_SHARENOWARN = 1;
  OFN_SHAREWARN = 0;
type
  POpenFilename = ^TOpenFilename;
  tagOFN = packed record
    lStructSize: DWORD;
    hWndOwner: HWND;
    hInstance: HINST;
    lpstrFilter: PKOLChar;
    lpstrCustomFilter: PKOLChar;
    nMaxCustFilter: DWORD;
    nFilterIndex: DWORD;
    lpstrFile: PKOLChar;
    nMaxFile: DWORD;
    lpstrFileTitle: PKOLChar;
    nMaxFileTitle: DWORD;
    lpstrInitialDir: PKOLChar;
    lpstrTitle: PKOLChar;
    Flags: DWORD;
    nFileOffset: Word;
    nFileExtension: Word;
    lpstrDefExt: PKOLChar;
    lCustData: LPARAM;
    lpfnHook: function(Wnd: HWND; Msg: UINT; wParam: WPARAM; lParam: LPARAM): UINT stdcall;
    lpTemplateName: PKOLChar;
    {$IFDEF OpenSaveDialog_Extended}
    //---------- added from Windows2000:
    pvReserved: Pointer;
    dwReserved: DWORD;
    FlagsEx: DWORD;
    {$ENDIF}
  end;
  TOpenFilename = tagOFN;
  OPENFILENAME = tagOFN;
{$IFDEF UNICODE_CTRLS}
function GetOpenFileName(var OpenFile: TOpenFilename): Bool; stdcall;
         external 'comdlg32.dll'  name 'GetOpenFileNameW';
function GetSaveFileName(var OpenFile: TOpenFilename): Bool; stdcall;
         external 'comdlg32.dll'  name 'GetSaveFileNameW';
{$ELSE}
function GetOpenFileName(var OpenFile: TOpenFilename): Bool; stdcall;
         external 'comdlg32.dll'  name 'GetOpenFileNameA';
function GetSaveFileName(var OpenFile: TOpenFilename): Bool; stdcall;
         external 'comdlg32.dll'  name 'GetSaveFileNameA';
{$ENDIF UNICODE_CTRLS}

type
  PChooseColorA = ^TChooseColorA;
  PChooseColorW = ^TChooseColorW;
  PChooseColor = PChooseColorA;
  tagCHOOSECOLORA = packed record
    lStructSize: DWORD;
    hWndOwner: HWND;
    hInstance: HWND;
    rgbResult: COLORREF;
    lpCustColors: ^COLORREF;
    Flags: DWORD;
    lCustData: LPARAM;
    lpfnHook: function(Wnd: HWND; Message: UINT; wParam: WPARAM; lParam: LPARAM): UINT stdcall;
    lpTemplateName: PAnsiChar;
  end;
  tagCHOOSECOLORW = packed record
    lStructSize: DWORD;
    hWndOwner: HWND;
    hInstance: HWND;
    rgbResult: COLORREF;
    lpCustColors: ^COLORREF;
    Flags: DWORD;
    lCustData: LPARAM;
    lpfnHook: function(Wnd: HWND; Message: UINT; wParam: WPARAM; lParam: LPARAM): UINT stdcall;
    lpTemplateName: PWideChar;
  end;
  tagCHOOSECOLOR = tagCHOOSECOLORA;
  TChooseColorA = tagCHOOSECOLORA;
  TChooseColorW = tagCHOOSECOLORW;
  TChooseColor = TChooseColorA;

const
  CC_RGBINIT = $00000001;
  CC_FULLOPEN = $00000002;
  CC_PREVENTFULLOPEN = $00000004;
  CC_SHOWHELP = $00000008;
  CC_ENABLEHOOK = $00000010;
  CC_ENABLETEMPLATE = $00000020;
  CC_ENABLETEMPLATEHANDLE = $00000040;
  CC_SOLIDCOLOR = $00000080;
  CC_ANYCOLOR = $00000100;

function ChooseColor(var CC: TChooseColor): Bool; stdcall;
         external 'comdlg32.dll'  name 'ChooseColorA';

{$IFDEF GDI}
//[procedure Chk_BitBlt_ShowError]
procedure Chk_BitBlt_ShowError;
var Rslt: Integer;
begin
    Rslt := GetLastError;
    ShowMessage( 'BitBlt ERROR: ' + Int2Str( Rslt )
                 + ' ' + SysErrorMessage( Rslt ) );
end;
//[END Chk_BitBlt_ShowError]

//[procedure Chk_BitBlt]
procedure Chk_BitBlt;
var Rslt: Integer;
begin
  asm
    MOV Rslt, EAX
  end;
  if Rslt = 0 then
  begin
    Chk_BitBlt_ShowError;
    asm
      int 3;
    end;
  end;
end;
//[END Chk_BitBlt]
{$ENDIF GDI}

{-}
{$ifdef _D2}

//[PROCEDURE Assert]
procedure Assert( Cond: Boolean; const Msg: AnsiString );
begin
  if not Cond then
  begin
    AssertErrorProc( Msg, '', 0 );
    //MsgOK( Msg );
    asm
      int 3;
    end;
  end;
end;

//[API CreateDIBSection]
function CreateDIBSection(DC: HDC; const p2: TBitmapInfo; p3: UINT;
  var p4: Pointer; p5: THandle; p6: DWORD): HBITMAP; stdcall;
external gdi32 name 'CreateDIBSection';

//[PROCEDURE _LStrFromPCharLen]
procedure _LStrFromPCharLen(var Dest: AnsiString; Source: PAnsiChar; Length: Integer);
asm
        { ->    EAX     pointer to dest }
        {       EDX source              }
        {       ECX length              }

        PUSH    EBX
        PUSH    ESI
        PUSH    EDI

        MOV     EBX,EAX
        MOV     ESI,EDX
        MOV     EDI,ECX

        { allocate new string }

        MOV     EAX,EDI

        CALL    System.@NewAnsiString
        MOV     ECX,EDI
        MOV     EDI,EAX

        TEST    ESI,ESI
        JE      @@noMove

        MOV     EDX,EAX
        MOV     EAX,ESI
        CALL    Move

        { assign the result to dest }

@@noMove:
        MOV     EAX,EBX
        CALL    System.@LStrClr
        MOV     [EBX],EDI

        POP     EDI
        POP     ESI
        POP     EBX
end;
{$endif}
{+}

{$IFDEF _D2009orHigher}
procedure _aLStrFromPCharLen(var Dest: AnsiString; Source: PAnsiChar; Length: Integer);
asm
  push 0
  CALL System.@LStrFromPCharLen
end;

procedure _aLStrFromPChar(var Dest: AnsiString; Source: PAnsiChar);
asm
  push ecx
  xor ecx, ecx
  CALL System.@LStrFromPChar
  pop ecx
end;
{$ENDIF}

//[API InitCommonControls]
procedure InitCommonControls; external cctrl name 'InitCommonControls';

type
  TInitCommonControlsEx = packed record
    dwSize: DWORD;
    dwICC: DWORD;
  end;
  PInitCommonControlsEx = ^TInitCommonControlsEx;

var ComCtl32_Module: HModule;
//[procedure DoInitCommonControls]
procedure DoInitCommonControls( dwICC: DWORD );
var Proc: procedure( ICC: PInitCommonControlsEx ); stdcall;
    ICC: TInitCommonControlsEx;
begin
  InitCommonControls;
  if ComCtl32_Module = 0 then
    ComCtl32_Module := LoadLibrary( 'comctl32' );
  @ Proc := GetProcAddress( ComCtl32_Module, 'InitCommonControlsEx' );
  if Assigned( Proc ) then
  begin
    ICC.dwSize := Sizeof( ICC );
    ICC.dwICC := dwICC;
    Proc( @ ICC );
  end;
end;
//[END DoInitCommonControls]

const size_TRect = 16; // used often in assembler versions of code
{-}

//22{$IFDEF ASM_VERSION}
const
  EmptyString: AnsiString = '';

//[PROCEDURE EAX2PChar]
procedure EAX2PChar;
asm
        TEST     EAX, EAX
        JNZ      @@exit
        MOV      EAX, offset[EmptyString]
@@exit:
end;

//[PROCEDURE EDX2PChar]
procedure EDX2PChar;
asm
        TEST     EDX, EDX
        JNZ      @@exit
        MOV      EDX, offset[EmptyString]
@@exit:
end;

//[PROCEDURE ECX2PChar]
procedure ECX2PChar;
asm
        JECXZ   @@convert
        RET
@@convert:
        MOV     ECX, offset[EmptyString]
@@exit:
end;

//[PROCEDURE RemoveStr]
procedure RemoveStr;
asm
        { <- [ESP+4] = string to remove
          -> ESP := ESP + 4
             EAX = 0
        }
        POP      EAX
        XCHG     EAX, [ESP]
        PUSH     EAX
        MOV      EAX, ESP
        CALL     System.@LStrClr
        POP      EAX
end;

{$IFDEF _D3orHigher}
//[PROCEDURE RemoveWStr]
procedure RemoveWStr;
asm
        { <- [ESP+4] = string to remove
          -> ESP := ESP + 4
             EAX = 0
        }
        POP      EAX
        XCHG     EAX, [ESP]
        PUSH     EAX
        MOV      EAX, ESP
        CALL     System.@WStrClr 
        POP      EAX
end;
{$ENDIF _D3orHigher}
//22{$ENDIF ASM_VERSION}
{+}

const PossibleColorBits : array[1..7] of Byte = ( 1, 4, 8, 16, 24, 32, 0 );

function FindFilter( const Filter: KOLString): KOLString; forward;
function WriteExMemoryStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize; forward;
procedure CreateComboboxWnd( Combo: PControl ); forward;
procedure ComboboxDropDown( Sender: PObj ); forward;
function WndProcParentResize(Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
function WndProcResize(Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
function WndProcJustOneNotify( Control: PControl; var Msg: TMsg; var Rslt: Integer ) : Boolean; forward;
function WndProcJustOne( Control: PControl; var Msg: TMsg; var Rslt: Integer ) : Boolean; forward;
function WndProcTreeView( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
function CompareAnsiStrListItems( const Sender : Pointer; const e1, e2 : DWORD ) : Integer; forward;
function CompareAnsiStrListItems_Case( const Sender : Pointer; const e1, e2 : DWORD ) : Integer; forward;
function CompareStrListItems_NoCase( const Sender : Pointer; const e1, e2 : DWORD ) : Integer; forward;
function CompareStrListItems_Case( const Sender : Pointer; const e1, e2 : DWORD ) : Integer; forward;
function CompareIntegers( const Sender : Pointer; const e1, e2 : DWORD ) : Integer; forward;
procedure SwapIntegers( const Sender : Pointer; const e1, e2 : DWORD ); forward;
function CompareDwords( const Sender : Pointer; const e1, e2 : DWORD ) : Integer; forward;
procedure ApplyImageLists2Control( Sender: PControl ); forward;
procedure ApplyImageLists2ListView( Sender: PControl ); forward;
function OpenDirCallBack( Wnd: HWnd; Msg: DWORD; lParam, lpData: LParam ): Integer;
         stdcall; forward;
function OpenDirSelChangeCallBack( Wnd: HWnd; Msg: DWORD; lParam, lpData: LParam ):
         Integer; stdcall; forward;
function WndProcShowModal( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
function TimerProc( Wnd : HWnd; Msg : Integer; T : PTimer; CurrentTime : DWord ): Integer;
          stdcall; forward;
function PrepareBitmapHeader( W, H, BitsPerPixel: Integer ): PBitmapInfo; forward;
procedure PreparePF16bit( DIBHeader: PBitmapInfo ); forward;
procedure _RotateBitmapMono( var DstBmp: PBitmap; SrcBmp: PBitmap ); forward;
procedure _RotateBitmap4bit( var DstBmp: PBitmap; SrcBmp: PBitmap ); forward;
procedure _RotateBitmap8bit( var DstBmp: PBitmap; SrcBmp: PBitmap ); forward;
procedure _RotateBitmap16bit( var DstBmp: PBitmap; SrcBmp: PBitmap ); forward;
procedure _RotateBitmap2432bit( var DstBmp: PBitmap; SrcBmp: PBitmap ); forward;
procedure _RotateBitmapRight( SrcBmp: PBitmap ); forward;
procedure _SetDIBPixels1bit( Bmp: PBitmap; X, Y: Integer; Value: TColor ); forward;
procedure _SetDIBPixelsPalIdx( Bmp: PBitmap; X, Y: Integer; Value: TColor ); forward;
procedure _SetDIBPixels16bit( Bmp: PBitmap; X, Y: Integer; Value: TColor ); forward;
procedure _SetDIBPixelsTrueColor( Bmp: PBitmap; X, Y: Integer; Value: TColor ); forward;
procedure FillBmpWithBkColor( Bmp: PBitmap; DC2: HDC; oldWidth, oldHeight: Integer ); forward;
procedure DetachBitmapFromCanvas( Sender: PBitmap ); forward;
function ColorBits( ColorsCount : Integer ) : Integer; forward;
procedure AlignChildrenProc(Sender: PObj); forward;
function WndProcUpdate( Sender: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
function CollectTabControls( Form: PControl ): PList; forward;
{$IFNDEF NOT_USE_RICHEDIT}
function WndProc_RE_LinkNotify( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
{$ENDIF NOT_USE_RICHEDIT}
function WndProc_DrawItem( Sender: PControl; var Msg: TMsg; var Rslt: Integer )
                          : Boolean; forward;
function WndProcTabControl( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;
  forward;
function WndProcSplitter( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;
  forward;
function Tabulate2ControlEx( Self_: PControl; Key: DWORD; checkOnly: Boolean ): Boolean;
  forward;
procedure Tabulate2Next( Form: PControl; Dir: Integer ); forward;
function Tabulate2Control( Self_: PControl; Key: DWORD; checkOnly: Boolean ): Boolean;
  forward;
function GetPrevCtrlBoundsRect( P: PControl; var R: TRect ): Boolean; forward;

////////////////////////////////////////////////////////////////////////////////
var MapFile: PStrList;
    LineNumbersFrom: Integer;
    MaxCrackStackLen: Integer;
    HandleSuspicious: Boolean;
    BelowBasePtr: PDWORD;
    CrackedStack: AnsiString;

function DoCrackSingleFrame( RetAddr: DWORD; BasePtr: DWORD ): Boolean;
var i, j, R: Integer;
    A, Prev_A, N, Prev_N: DWORD;
    s, CurUnit: AnsiString;
    Add_string: AnsiString;
    Line_found: Boolean;
begin
    Result := FALSE;
    if Length( CrackedStack ) > MaxCrackStackLen then Exit;
    Result := TRUE;
    if RetAddr >= $70000000 then
    begin
        CrackedStack := CrackedStack + #13#10'$' + Int2Hex( RetAddr, 8 );
        Exit;
    end;
    Result := FALSE;
    if RetAddr < $400000 then Exit;

    if HandleSuspicious then
        if (BelowBasePtr <> nil) and (BasePtr <> 0)
           and (DWORD( BelowBasePtr ) < BasePtr) then
        begin
            BelowBasePtr := Pointer( DWORD( BelowBasePtr ) + 4 );
            while DWORD( BelowBasePtr ) < BasePtr do
            begin
                A := BelowBasePtr^;
                if (A > $400000) and (A < $700000) then
                    DoCrackSingleFrame( A, 0 );
                BelowBasePtr := Pointer( DWORD( BelowBasePtr ) + 4 );
            end;
        end;
    if BasePtr <> 0 then
        BelowBasePtr := Pointer( BasePtr );

    Add_string := '';

    // 1st: find
    Prev_A := 0;
    for i := 0 to MapFile.Count-1 do
    begin
        s := MapFile.Items[ i ];
        if s = '' then
            Exit;
        R := 0;
        j := 1;
        while (j <= Length( s )) and (s[j] <= ' ') do inc( j );
        while (j <= Length( s )) and (s[j] in ['0'..'9','A'..'F']) do
        begin
            if s[j] <= '9' then R := R * 16 + Ord( s[j] ) - Ord( '0' )
            else R := R * 16 + Ord( s[j] ) - Ord( 'A' ) + 10;
            inc( j );
        end;
        if (j > Length( s )) or (s[ j ] <> ':') then Exit;
        inc( j );
        A := 0;
        while (j <= Length( s )) and (s[j] in ['0'..'9','A'..'F']) do
        begin
            if s[j] <= '9' then A := A * 16 + Ord( s[j] ) - Ord( '0' )
            else A := A * 16 + Ord( s[j] ) - Ord( 'A' ) + 10;
            inc( j );
        end;
        A := A + $401000;
        //if (j > Length( s )) then Exit;
        if (Prev_A <= RetAddr) and (A > RetAddr) and (Prev_A > 0) and (R = 1) then
        begin
            s := MapFile.Items[ i-1 ];
            j := pos( AnsiString(':'), s );
            if j <= 0 then Exit;
            s := Copy( s, j+1, MaxInt );
            for j := 1 to Length( s ) do
                if s[ j ] <= ' ' then
                begin
                    s := Trim( Copy( s, j, MaxInt ) );
                    Add_string := #13#10;
                    if BasePtr = 0 then
                        Add_string := Add_string + '? ' + Int2Hex( RetAddr, 8 ) + ':';
                    Add_string := Add_string + s;
                    Result := TRUE;
                    break;
                end;
        end;
        Prev_A := A;
        if Result then break;
    end;
    if not Result then Exit;

    // 2nd: find line no

    Line_found := FALSE;
    CurUnit := '';
    Prev_N := 0;
    Prev_A := 0;
    for i := LineNumbersFrom to MapFile.Count-1 do
    begin
        s := MapFile.Items[ i ];
        if Copy( s, 1, 4 ) = 'Line' then
        begin
            j := pos( AnsiString('('), s );
            if j > 0 then
            begin
                s := Copy( s, j+1, MaxInt );
                j := pos( AnsiString(')'), s );
                if j > 0 then
                    s := Copy( s, 1, j-1 );
            end;
            CurUnit := s;
            Prev_N := 0;
        end
          else
        if s <> '' then
        begin
            j := 1;
            while j < Length( s ) do
            begin
                while (j <= Length( s )) and (s[j] <= ' ') do inc( j );
                N := 0;
                while (j <= Length( s )) and (s[j] in [ '0'..'9' ]) do
                begin
                    N := N * 10 + Ord( s[j] ) - Ord( '0' );
                    inc( j );
                end;
                while (j <= Length( s )) and (s[j] <= ' ') do inc( j );
                R := 0;
                while (j < Length( s )) and (s[j] in [ '0'..'9', 'A'..'F' ]) do
                begin
                    if s[j] <= '9' then
                        R := R * 16 + Ord( s[j] ) - Ord( '0' )
                    else R := R * 16 + Ord( s[j] ) - Ord( 'A' ) + 10;
                    inc( j );
                end;
                while (j <= Length( s )) and (s[j] <= ' ') do inc( j );
                if (j <= Length(s)) and (s[ j ] = ':') then inc( j );
                while (j <= Length( s )) and (s[j] <= ' ') do inc( j );
                A := 0;
                while (j <= Length( s )) and (s[j] in [ '0'..'9', 'A'..'F' ]) do
                begin
                    if s[j] <= '9' then
                        A := A * 16 + Ord( s[j] ) - Ord( '0' )
                    else A := A * 16 + Ord( s[j] ) - Ord( 'A' ) + 10;
                    inc( j );
                end;
                A := A + $401000;
                if (Prev_A <= RetAddr) and (A > RetAddr) then
                begin
                    if (Prev_A > 0) and (Prev_N > 0) then
                    begin
                        Add_string := Add_string + ' in ' + CurUnit + ', line: ' +
                            Int2Str( Prev_N );
                        Line_found := TRUE;
                    end;
                    s := '';
                    break;
                end;
                Prev_N := N;
                Prev_A := A;
                if Line_found then break;
            end;
        end;
        if Line_found then break;
    end;
    if not Line_found and (BasePtr = 0) then Exit;
    CrackedStack := CrackedStack + Add_string;
    if Length( CrackedStack ) > MaxCrackStackLen then
    begin
        CrackedStack := Copy( CrackedStack, 1, MaxCrackStackLen );
        Result := FALSE; // stop cracking
    end;
end;

procedure DoCrackStack;
asm
    mov  edx, ebp
@@loop:
    mov  ecx, [edx]
    mov  eax, [edx+4]
    mov  edx, ecx
    push edx
    call DoCrackSingleFrame
    pop  edx
    test al, al
    jnz  @@loop
end;

function CrackStack( Max_length: Integer; HandleSuspiciousAddresses: Boolean ): AnsiString;
begin
    TRY
        MaxCrackStackLen := Max_length;
        HandleSuspicious := HandleSuspiciousAddresses;
        CrackedStack := '';
        DoCrackStack;
    EXCEPT
    END;
    Result := CrackedStack;
end;

procedure PrepareMapFile;
var i, j: Integer;
    s: AnsiString;
begin
    for i := 0 to MapFile.Count-1 do
    begin
        s := MapFile.Items[ i ];
        if pos( AnsiString('Publics by Value'), s ) > 0 then
        begin
            j := i;
            if Trim( MapFile.Items[ j+1 ] ) = '' then
                inc( j );
            for j := j downto 0 do
                MapFile.Delete( j );
            for j := 0 to MapFile.Count-1 do
            begin
                s := Trim( MapFile.Items[ j ] );
                if (s = '') and (LineNumbersFrom = 0) then
                begin
                    LineNumbersFrom := j;
                end;
                if s = 'Bound resource files' then
                begin
                    while MapFile.Count > j do
                        MapFile.Delete( j );
                    break;
                end;
            end;
            break;
        end;
    end;
end;

function CrackStack_MapInResource( const MapName: KOLString; Max_length: Integer;
    HandleSuspiciousAddresses: Boolean ): KOLString;
var MapStrm: PStream;
begin
    Result := '';
    if MapFile = nil then
    begin
        MapStrm := NewMemoryStream;
        TRY
            Resource2Stream( MapStrm, hInstance, PKOLChar( MapName ), PKOLChar(RT_RCDATA) );
            if MapStrm.Size = 0 then Exit;
            MapFile := NewStrList;
            MapStrm.Position := 0;
            MapFile.LoadFromStream( MapStrm, FALSE );
            PrepareMapFile;
        FINALLY
            MapStrm.Free;
        END;
    end;
    if MapFile = nil then Exit;
    Result := CrackStack( Max_length, HandleSuspiciousAddresses );
end;

function CrackStack_MapInFile( const MapFileName: KOLString; Max_length: Integer;
    HandleSuspiciousAddresses: Boolean ): KOLString;
begin
    Result := '';
    if MapFile = nil then
    begin
        MapFile := NewStrList;
        MapFile.LoadFromFile( MapFileName );
        if MapFile.Count = 0 then
            Free_And_Nil( MapFile )
        else PrepareMapFile;
    end;
    if MapFile = nil then Exit;
    Result := CrackStack( Max_length, HandleSuspiciousAddresses );
end;

{$IFDEF GRAPHCTL_XPSTYLES}
 {$I visual_xp_styles.inc}
{$ENDIF}

{$IFDEF SNAPMOUSE2DFLTBTN}
var FoundMsgBoxWnd: HWnd;

function EnumProcSnapMouse2DfltBtn( W: HWnd; lParam: Integer ): BOOL; stdcall;
var ClassBuf: array[ 0..31 ] of KOLChar;
begin
  GetClassName( W, ClassBuf, Sizeof( ClassBuf ) div Sizeof( KOLChar ) );
  Result := TRUE;
  if ClassBuf = '#32770' then
  begin
    FoundMsgBoxWnd := W;
    Result := FALSE;
  end;
end;

function WndProcSnapMouse2DfltBtn( Sender: PControl; var M: TMsg; var Rslt: Integer ): Boolean;
var W: HWnd;
    R: TRect;
    P: TPoint;
    SnapMouse: Integer;
begin
  SnapMouse := 0;
  if SystemParametersInfo( {SPI_GETSNAPTODEFBUTTON}95, 0, @ SnapMouse, 0 ) then
  if SnapMouse <> 0 then
  begin
    FoundMsgBoxWnd := 0;
    EnumThreadWindows( GetCurrentThreadID, @ EnumProcSnapMouse2DfltBtn, 0 );
    if FoundMsgBoxWnd <> 0 then
    begin
      W := GetWindow( FoundMsgBoxWnd, GW_CHILD );
      while W <> 0 do
      begin
        if GetWindowLong( W, GWL_STYLE ) and BS_DEFPUSHBUTTON <> 0 then
        begin
          GetWindowRect( W, R );
          P.X := (R.Left + R.Right) div 2;
          P.Y := (R.Top + R.Bottom) div 2;
          SetCursorPos( P.X, P.Y );
        end;
        W := GetWindow( W, GW_HWNDNEXT );
      end;
      Applet.DetachProc( @WndProcSnapMouse2DfltBtn );
    end;
  end;
  Result := FALSE;
end;
{$ENDIF SNAPMOUSE2DFLTBTN}

{$IFDEF GDI}
//[function MsgBox]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function MsgBox( const S: KOLString; Flags: DWORD ): DWORD;
var Title: PKOLChar;
begin
  Title := nil;
  if assigned( Applet ) then
  begin
    Title := PKOLChar( Applet.fCaption );
  end;
  {$IFDEF SNAPMOUSE2DFLTBTN}
  if Assigned( Applet ) then
  begin
    Applet.AttachProc( WndProcSnapMouse2DfltBtn );
    Applet.Postmsg( 0, 0, 0 );
  end;
  {$ENDIF}
  Result := MessageBox( 0, PKOLChar( S ), Title, Flags );
  {$IFDEF SNAPMOUSE2DFLTBTN}
  if Assigned( Applet ) then
    Applet.DetachProc( WndProcSnapMouse2DfltBtn );
  {$ENDIF}
end;
//[END MsgBox]
{$ENDIF ASM_VERSION}

//[PROCEDURE MsgOK]
procedure MsgOK( const S: KOLString );
begin
  MsgBox( S, MB_OK );
end;

//[function ShowMsg]
{$IFDEF ASM_UNICODE}
function ShowMsg( const S: KOLString; Flags: DWORD ): DWORD;
asm
  push edx // Flags
  mov  ecx, [Applet]
  {$IFDEF SNAPMOUSE2DFLTBTN}
  jecxz @@0
  pushad
  xchg eax, ecx
  mov  edx, offset[WndProcSnapMouse2DfltBtn]
  call TControl.AttachProc
  popad
@@0:
  {$ENDIF}
  mov  edx, 0
  jecxz @@1
  mov  edx, [ecx].TControl.fHandle
  mov  ecx, [ecx].TControl.fCaption
@@1: push ecx // Title
  push eax    // S
  push edx    // Wnd
  call MessageBox
  {$IFDEF SNAPMOUSE2DFLTBTN}
  mov  ecx, [Applet]
  jecxz @@2
  pushad
  xchg eax, ecx
  mov  edx, offset[WndProcSnapMouse2DfltBtn]
  call TControl.DetachProc
  popad
@@2:
  {$ENDIF}
end;
{$ELSE PASCAL}
function ShowMsg( const S: KOLString; Flags: DWORD ): DWORD;
var Title: PKOLChar;
    Wnd: HWnd;
begin
  {$IFDEF SNAPMOUSE2DFLTBTN}
  if Assigned( Applet ) then
    Applet.AttachProc( WndProcSnapMouse2DfltBtn );
  {$ENDIF}
  Title := nil;
  Wnd := 0;
  if assigned( Applet ) then
  begin
     Title := PKOLChar( Applet.fCaption );
     //{$IFNDEF SNAPMOUSE2DFLTBTN}
     Wnd := Applet.Handle;
     //{$ENDIF}
  end;
  Result := MessageBox( Wnd, PKOLChar( S ), Title, Flags );
  {$IFDEF SNAPMOUSE2DFLTBTN}
  if Assigned( Applet ) then
    Applet.DetachProc( WndProcSnapMouse2DfltBtn );
  {$ENDIF}
end;
{$ENDIF ASM_VERSION}
//[END ShowMsg]

//[procedure ShowMessage]
procedure ShowMessage( const S: KOLString );
begin
  ShowMsg( S, MB_OK or MB_SETFOREGROUND or MB_DEFBUTTON1 );
end;
//[END ShowMessage]
{$ENDIF GDI}

{$IFDEF WIN_GDI}
//[procedure SpeakerBeep]
procedure SpeakerBeep( Freq: Word; Duration: DWORD );
begin
  if WinVer >= wvNT then
    Windows.Beep( Freq, Duration )
  else
  begin
    if Freq < 18 then Exit;
    Freq := 1193181 div Freq;
    if Freq = 0 then Exit;
    asm
        mov al,0b6H
        out 43H,al
        mov ax,Freq
        //xchg al, ah
        out 42h,al
        xchg al, ah
        out 42h,al
        in  al,61H
        or  al,03H
        out 61H,al
    end {$IFDEF F_P} [ 'EAX' ] {$ENDIF} ;
    Sleep(Duration);
    asm
        in  al,61H
        and al,0fcH
        out 61H,al
    end {$IFDEF F_P} [ 'EAX' ] {$ENDIF} ;
  end;
end;
//[END SpeakerBeep]
{$ENDIF WIN_GDI}

{++}(*
//[API FormatMessage]
function FormatMessage; external kernel32 name 'FormatMessageA';
*){--}

//[FUNCTION SysErrorMessage]
function SysErrorMessage(ErrorCode: Integer): KOLString;
var
  Len: Integer;
  Buffer: array[0..255] of KOLChar;
begin
  Len := FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM or
    FORMAT_MESSAGE_ARGUMENT_ARRAY, nil, ErrorCode, 0, Buffer,
    SizeOf(Buffer), nil);
  while (Len > 0) and ((Buffer[Len - 1] >= #0) and (Buffer[Len - 1] <= ' ')) do Dec(Len);
  SetString(Result, Buffer, Len);
end;
//[END SysErrorMessage]
{$ENDIF WIN_GDI}

//[function GetShiftState]
function GetShiftState: DWORD;
{$IFDEF WIN}
const Buttons: array[0..6] of Byte = ( VK_SHIFT, VK_CONTROL, VK_MENU, VK_LBUTTON,
  VK_RBUTTON, VK_MBUTTON, VK_CAPITAL );
      Flags: array[0..6] of Byte = ( MK_SHIFT, MK_CONTROL, MK_ALT, MK_LBUTTON,
  MK_RBUTTON, MK_MBUTTON, MK_LOCK );
var i, mask: Integer;
{$ENDIF WIN} //todo: for Linux / GTK ?
begin
  Result := 0;
  {$IFDEF WIN}
  mask := 1;
  for i := High( Buttons ) downto 0 do
  begin
    if GetKeyState( Buttons[ i ] ) and mask <> 0 then
      Result := Result or Flags[ i ];
    mask := $8000;
  end;
  {$ENDIF WIN}
end;
//[END GetShiftState]

//[function MakeMethod]
function MakeMethod( Data, Code: Pointer ): TMethod;
begin
  Result.Data := Data;
  Result.Code := Code;
end;
//[END MakeMethod]

//[FUNCTION MakeRect]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function MakeRect( Left, Top, Right, Bottom: Integer ): TRect; stdcall;
begin
   Result.Left := Left;
   Result.Top  := Top;
   Result.Right:= Right;
   Result.Bottom := Bottom;
end;
{$ENDIF ASM_VERSION}
//[END MakeRect]

//[FUNCTION RectsEqual]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function RectsEqual( const R1, R2: TRect ): Boolean;
begin
  Result := CompareMem( @R1, @R2, Sizeof( TRect ) );
end;
{$ENDIF ASM_VERSION}
//[END RectsEqual]

//[function RectsIntersected]
function RectsIntersected( const R1, R2: TRect ): Boolean;
begin
  Result := ((R1.Left <= R2.Left) and (R1.Right > R2.Left ) or
             (R1.Left <= R2.Right) and (R1.Right >= R2.Right) or
             (R1.Left >= R2.Left) and (R1.Right <= R2.Right))
             and
            ((R1.Top <= R2.Top) and (R1.Bottom > R2.Top) or
             (R1.Top <= R2.Bottom) and (R1.Bottom >= R2.Bottom) or
             (R1.Top >= R2.Top) and (R1.Bottom <= R2.Bottom)) ;
end;
//[END RectsIntersected]

//[FUNCTION PointInRect]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function PointInRect( const P: TPoint; const R: TRect ): Boolean;
begin
   Result := (P.x >= R.Left) and (P.x < R.Right)
             and (P.y >= R.Top) and (P.y < R.Bottom);
end;
{$ENDIF ASM_VERSION}
//[END PointInRect]

//[FUNCTION OffsetPoint]
{$IFDEF ASM_VERSION}
function OffsetPoint( const T: TPoint; dX, dY: Integer ): TPoint;
asm
  ADD  EDX, [EAX].TPoint.X
  ADD  ECX, [EAX].TPoint.Y
  MOV  EAX, [Result]
  MOV  [EAX].TPoint.X, EDX
  MOV  [EAX].TPoint.Y, ECX
end;
{$ELSE ASM_VERSION} // Pascal
function OffsetPoint( const T: TPoint; dX, dY: Integer ): TPoint;
begin
  Result := MakePoint( T.X + dX, T.Y + dY );
end;
{$ENDIF ASM_VERSION}

//[FUNCTION OffsetSmallPoint]
{$IFDEF ASM_VERSION}
function OffsetSmallPoint( const T: TSmallPoint; dX, dY: SmallInt ): TSmallPoint;
asm
  SHL  EDX, 16
  SHLD ECX, EDX, 16
  CALL @@1
@@1:
  ROL  EAX, 16
  ROL  ECX, 16
  ADD  AX, CX
end;
{$ELSE ASM_VERSION} // Pascal
function OffsetSmallPoint( const T: TSmallPoint; dX, dY: SmallInt ): TSmallPoint;
begin
  Result.x := T.x + dX;
  Result.y := T.y + dY;
end;
{$ENDIF ASM_VERSION}

{$IFDEF ASM_VERSION}
function Point2SmallPoint( const T: TPoint ): TSmallPoint;
asm
  XCHG EDX, EAX
  MOV  EAX, [EDX].TPoint.Y-2
  MOV  AX,  word ptr [EDX].TPoint.X  
end;
{$ELSE ASM_VERSION} // Pascal
function Point2SmallPoint( const T: TPoint ): TSmallPoint;
begin
  Result.x := T.X;
  Result.y := T.Y;
end;
{$ENDIF ASM_VERSION}

{$IFDEF ASM_VERSION}
function SmallPoint2Point( const T: TSmallPoint ): TPoint;
asm
  MOVSX ECX, AX
  MOV   [EDX].TPoint.X, ECX
  SAR   EAX, 16
  MOV   [EDX].TPoint.Y, EAX
end;
{$ELSE ASM_VERSION} //Pascal
function SmallPoint2Point( const T: TSmallPoint ): TPoint;
begin
  Result := MakePoint( T.x, T.y );
end;
{$ENDIF ASM_VERSION}

//[FUNCTION MakePoint]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function MakePoint( X, Y: Integer ): TPoint;
begin
   Result.x := X;
   Result.y := Y;
end;
{$ENDIF ASM_VERSION}
//[END MakePoint]

{$IFDEF ASM_VERSION}
function MakeSmallPoint( X, Y: Integer ): TSmallPoint;
asm
  SHL EAX, 16
  SHRD EAX, EDX, 16
end;
{$ELSE ASM_VERSION} // Pascal
function MakeSmallPoint( X, Y: Integer ): TSmallPoint;
begin
  Result.x := X;
  Result.y := Y;
end;
{$ENDIF ASM_VERSION}

//[FUNCTION MakeFlags]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function MakeFlags( FlgSet: PDWORD; FlgArray: array of Integer): Integer;
var I : Integer;
    Mask : DWORD;
begin
  Result := 0;
  Mask := FlgSet^;
  for I := 0 to High( FlgArray ) do
  begin
    if (FlgArray[ I ] < 0) and not LongBool( Mask and 1 ) then
       Result := Result or not FlgArray[ I ]
    else
    if (FlgArray[ I ] >= 0) and LongBool( Mask and 1 ) then
       Result := Result or FlgArray[ I ];
    Mask := Mask shr 1;
  end;
end;
{$ENDIF ASM_VERSION}
//[END MakeFlags]

function MakeDateTimeRange( D1, D2: TDateTime ): TDateTimeRange;
begin
  Result.FromDate := D1;
  Result.ToDate   := D2;
end;

//[procedure Swap]
procedure Swap( var X, Y: Integer );
{$IFDEF F_P}
var Tmp: Integer;
begin
  Tmp := X;
  X := Y;
  Y := Tmp;
end;
{$ELSE DELPHI}
asm
  MOV  ECX, [EDX]
  XCHG ECX, [EAX]
  MOV  [EDX], ECX
end;
//[END Swap]
{$ENDIF F_P/DELPHI}

//[function Min]
function Min( X, Y: Integer ): Integer;
asm
  {$IFDEF F_P}
  MOV EAX, [X]
  MOV EDX, [Y]
  {$ENDIF F_P}
  {$IFDEF USE_CMOV}
  CMP   EAX, EDX
  CMOVG EAX, EDX
  {$ELSE}
  CMP EAX, EDX
  JLE @@exit
  MOV EAX, EDX
@@exit:
  {$ENDIF}
end {$IFDEF F_P} [ 'EAX', 'EDX' ] {$ENDIF};
//[END Min]

//[function Max]
function Max( X, Y: Integer ): Integer;
asm
  {$IFDEF F_P}
  MOV EAX, [X]
  MOV EDX, [Y]
  {$ENDIF F_P}
  {$IFDEF USE_CMOV}
  CMP EAX, EDX
  CMOVL EAX, EDX
  {$ELSE}
  CMP EAX, EDX
  JGE @@exit
  MOV EAX, EDX
@@exit:
  {$ENDIF}
end {$IFDEF F_P} [ 'EAX', 'EDX' ] {$ENDIF};
//[END Max]

{$IFDEF REDEFINE_ABS}
//[function Abs]
function Abs( X: Integer ): Integer;
asm
  {$IFDEF F_P}
  MOV EAX, [X]
  {$ENDIF F_P}
  cdq
  xor eax, edx
  sub eax, edx
end {$IFDEF F_P} [ 'EAX' ] {$ENDIF};
//[END Abs]
{$ENDIF}

//[function Sgn]
function Sgn( X: Integer ): Integer;
asm
  CMP EAX, 0
  {$IFDEF USE_CMOV}
  MOV EDX, -1
  CMOVL EAX, EDX
  MOV EDX, 1
  CMOVG EAX, EDX
  {$ELSE}
  JZ  @@exit
  MOV EAX, 1
  JG  @@exit
  MOV EAX, -1
@@exit:
  {$ENDIF}
end;
//[END Sgn]

//[function iSqrt]
function iSQRT( X: Integer ): Integer;
{$IFDEF _D4orHigher}
// new version is more efficient but code is not compatible with older compilers
var I, N: Int64;
begin
  Result := 0;
  while Result < X do
  begin
    I := 1;
    while I > 0 do
    begin
      N := (Result + I) * (Result + I);
      if N > X then
      begin
        I := I shr 1;
        break;
      end
        else
      if N = X then
      begin
        Result := Result + I;
        Exit;
      end;
      I := I * 2;
    end;
    if I <= 0 then Exit;
    Result := Result + I;
  end;
end;
{$ELSE _D3 or below or FPC1}
var m, y, b: DWORD;
begin
  m := $40000000;
  y := 0;
  while m <> 0 do // 16 times
  begin
    b := y or m;
    y := y shr 1;
    if x >= b then
    begin
      x := x - b;
      y := y or m;
    end;
    m := m shr 2;
  end;
  Result := y;
end;
{$ENDIF}
//[END iSqrt]

function iCbrt( X: DWORD ): Integer;
var s: Integer;
    y, b: DWORD;
begin
  s := 30;
  y := 0;
  while s >= 0 do // 11 times
  begin
    y := 2 * y;
    b := (3 * y * (y+1) + 1) shl s;
    s := s - 3;
    if x >= b then
    begin
      x := x - b;
      y := y + 1;
    end;
  end;
  Result := y;
end;
{$IFDEF WIN_GDI}

{$IFDEF ASM_DC}
//[PROCEDURE StartDC]
procedure StartDC;
asm
  { <- EBX : PBitmap
    -> EAX = dc
       [ESP+8] = var dc
       [ESP+4] = var SaveBmp
  }
        PUSH     0
        CALL     CreateCompatibleDC
        POP      EDX
        PUSH     EAX
        PUSH     EDX
        MOV      EAX, EBX
        CALL     [EBX].TBitmap.fDetachCanvas
        MOV      EAX, EBX
        CALL     TBitmap.GetHandle
        PUSH     EAX
        PUSH     dword ptr [ESP+8]
        CALL     SelectObject
        POP      EDX
        PUSH     EAX
        PUSH     EDX
        MOV      EAX, [ESP+8]
end;
//[END StartDC]

//[procedure FinishDC]
procedure FinishDC;
asm
        POP      ECX
        POP      EAX
        POP      EDX
        PUSH     ECX
        PUSH     EDX
        PUSH     EAX
        PUSH     EDX
        CALL     SelectObject
        CALL     DeleteDC
end;
//[END FinishDC]
{$ENDIF ASM_DC}

//[function EnumDynHandlers FORWARD DECLARATION]
function EnumDynHandlers( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean;
  forward;

{$ENDIF WIN_GDI}
//[procedure DummyObjProc]
procedure DummyObjProc( Sender: PObj );
begin
end;

//[procedure DummyObjProcParam]
procedure DummyObjProcParam( Sender: PObj; Param: Pointer );
begin
end;

//[procedure DummyPaintProc]
procedure DummyPaintProc( Sender: PControl; DC: HDC );
begin
end;
{$IFDEF WIN}

{$ENDIF WIN}
{-}
{ _TObj }

//[procedure Free_And_Nil]
procedure Free_And_Nil( var Obj );
var Obj1: PObj;
begin
  Obj1 := PObj( Obj );
  Pointer( Obj ) := nil;
  Obj1.Free;
end;

//[procedure _TObj.Init]
procedure _TObj.Init;
begin
{$IFDEF _D2orD3}
  FillChar( Pointer( Integer(@Self) + 4 )^, Sizeof( Self ) - 4, 0 );
{$ENDIF}
end;

//[function _TObj.VmtAddr]
function _TObj.VmtAddr: Pointer;
asm
   MOV EAX, [EAX]
end;

{ TObj }

class function TObj.AncestorOfObject(Obj: Pointer): Boolean;
asm
        MOV     ECX, [EAX]
        MOV     EAX, EDX
        JMP     @@loop1
@@loop:
        MOV     EAX,[EAX]
@@loop1:
        TEST    EAX,EAX
        JE      @@exit
        CMP     EAX,ECX
        JNE     @@loop
@@success:
        MOV     AL,1
@@exit:
end;

{+}

{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
constructor TObj.Create;
begin
  Init;
  {++}(* inherited; *){--}
end;
{$ENDIF ASM_VERSION}

{$IFDEF OLD_REFCOUNT}
//[procedure TObj.DoDestroy]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TObj.DoDestroy;
begin
  {$IFDEF OLD_REFCOUNT}
  if fRefCount > 0 then
  begin
    if not LongBool( fRefCount and 1) then
    Dec( fRefCount, 2 );
    RefDec;
  end
  else
     Self.Destroy;
  if fRefCount <> 0 then
  begin
    if not LongBool( fRefCount and 1) then
       Dec( fRefCount );
  end
  else
     Self.Destroy;
  {$ELSE}
  if fRefCount > 0 then
    RefDec
  else
    Self.Destroy;
  {$ENDIF}
end;
{$ENDIF ASM_VERSION}
{$ENDIF OLD_REFCOUNT}

//[procedure TObj.RefDec]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TObj.RefDec: Integer;
begin
  Result := 0; // stop Delphi alerting the Warning
  if @ Self = nil then Exit;
  Dec( fRefCount, 2 );
  {$IFDEF OLD_REFCOUNT}
  if (fRefCount < 0) and LongBool(fRefCount and 1) then
    Destroy;
  {$ELSE}
  if fRefCount < 0 then
    Destroy;
  {$ENDIF}
end;
{$ENDIF ASM_VERSION}

//[procedure TObj.RefInc]
procedure TObj.RefInc;
begin
  Inc( fRefCount, 2 );
end;

{-}
//[function TObj.VmtAddr]
function TObj.VmtAddr: Pointer;
asm
       MOV    EAX, [EAX - 4]
end;

//[function TObj.InstanceSize]
function TObj.InstanceSize: Integer;
asm
       MOV    EAX, [EAX]
       MOV    EAX,[EAX-4]
end;
{+}

{$IFDEF OLD_FREE}
//[procedure TObj.Free]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION}
procedure TObj.Free;
begin
  //if @ Self <> nil then
    RefDec;
end;
{$ENDIF ASM_VERSION}
{$ENDIF OLD_FREE}

{$UNDEF ASM_LOCAL}
{$IFDEF ASM_VERSION} {$DEFINE ASM_LOCAL} {$ENDIF}
{$IFDEF CRASH_DEBUG} {$UNDEF ASM_LOCAL} {$ENDIF}
{$IFDEF ASM_DEBUG} {$DEFINE ASM_LOCAL} {$ENDIF}

{$IFDEF ASM_LOCAL}
{$ELSE ASM_VERSION} //Pascal
destructor TObj.Destroy;
begin
  Final;

  {$IFDEF DEBUG_ENDSESSION}
  if EndSession_Initiated then
    LogFileOutput( GetStartDir + 'es_debug.txt',
                   'FINALLED: ' + Int2Hex( DWORD( @ Self ), 8 )
                   {$IFDEF USE_NAMES}
                   + ' (name:' + FName + ')'
                   {$ENDIF}
                    );
  {$ENDIF}
  {$IFDEF USE_NAMES}
  fName := '';
  if fNamedObjList <> nil then Free_And_Nil(fNamedObjList);
  {$ENDIF}
  {-}
  //Dispose( @Self );
  {$IFDEF CRASH_DEBUG}
  FillChar( Pointer( Integer(@Self) + 4 )^, Sizeof( Self ) - 4, #$DD );
  {$ENDIF}
  FreeMem( @ Self );
  {+} {++}(*
  inherited; *){--}
end;
{$ENDIF ASM_VERSION}

{++}(*
//[procedure TObj.Init]
procedure TObj.Init;
begin

end;
*){--}

{$IFDEF ASM_VERSION}
  {$DEFINE ASM_TLIST}
{$IFDEF TLIST_FAST}
  {$UNDEF ASM_TLIST}
{$ENDIF}
{$ENDIF}

//[procedure TObj.Final]
{$IFDEF ASM_TLIST}
procedure TObj.Final;
asm     //cmd    //opd
        PUSH     EBX
        XCHG     EBX, EAX
        XOR      ECX, ECX
        XCHG     ECX, [EBX].fOnDestroy.TMethod.Code
        JECXZ    @@freeloop
        MOV      EDX, EBX
        MOV      EAX, [EDX].fOnDestroy.TMethod.Data
        CALL     ECX
@@freeloop:
        MOV      ECX, [EBX].fAutoFree
        JECXZ    @@eloop
        MOV      EDX, [ECX].TList.fItems
        MOV      ECX, [ECX].TList.fCount
        JECXZ    @@eloop
        MOV      EAX, [EDX+ECX*4-4]
        MOV      EDX, [EDX+ECX*4-8]
        PUSH     EAX
        PUSH     EDX
        MOV      EAX, [EBX].fAutoFree
        LEA      EDX, [ECX-2]
        XOR      ECX, ECX
        MOV      CL, 2
        CALL     TList.DeleteRange
        POP      EDX
        POP      EAX
        CALL     EDX
        JMP      @@freeloop
@@eloop:
        XOR      EAX, EAX
        XCHG     [EBX].fAutoFree, EAX
        CALL     TObj.RefDec
@@exit:
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
procedure TObj.Final;
var N: Integer;
    ProcMethod: TMethod;
    {$IFDEF _D2orD3}
    Proc: TObjectMethod;
    {$ELSE}
    Proc: TObjectMethod Absolute ProcMethod;
    {$ENDIF}
begin
  if Assigned( fOnDestroy ) then
  begin
    fOnDestroy( @Self );
    fOnDestroy := nil;
  end;
  while (fAutoFree <> nil) and (fAutoFree.fCount > 0) do
  begin
    N := fAutoFree.fCount - 2;
    ProcMethod.Code := fAutoFree.Items[ N ];
    ProcMethod.Data := fAutoFree.Items[ N + 1 ];
    fAutoFree.DeleteRange( N, 2 );
    {-}
    {$IFDEF _D2orD3}
    Proc := TObjectMethod( ProcMethod );
    {$ENDIF}
    Proc;
    {+}{++}(*
    asm
      MOV  EAX, [ProcMethod.Data]
      {$IFDEF F_P}
      PUSH EAX
      {$ENDIF F_P}
      MOV  ECX, [ProcMethod.Code]
      CALL ECX
    end {$IFDEF F_P}[ 'EAX', 'EDX', 'ECX' ]{$ENDIF};
    *){--}
  end;
  fAutoFree.Free;
  fAutoFree := nil;
end;
{$ENDIF ASM_VERSION}

//[procedure TObj.Add2AutoFree]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TObj.Add2AutoFree(Obj: PObj);
begin
  if fAutoFree = nil then
    fAutoFree := NewList;
  fAutoFree.Insert( 0, Obj );
  fAutoFree.Insert( 0, Pointer( @TObj.RefDec ) );
end;
{$ENDIF ASM_VERSION}

//[procedure TObj.Add2AutoFreeEx]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TObj.Add2AutoFreeEx( Proc: TObjectMethod );
{$IFDEF F_P}
var Ptr1, Ptr2: Pointer;
{$ENDIF F_P}
begin
  if fAutoFree = nil then
    fAutoFree := NewList;
  {$IFDEF F_P}
  asm
    MOV  EAX, [Proc]
    MOV  [Ptr1], EAX
    MOV  EAX, [Proc+4]
    MOV  [Ptr2], EAX
  end [ 'EAX' ];
  fAutoFree.Insert( 0, Ptr2 );
  fAutoFree.Insert( 0, Ptr1 );
  {$ELSE DELPHI}
  fAutoFree.Insert( 0, Pointer( TMethod( Proc ).Data ) );
  fAutoFree.Insert( 0, Pointer( TMethod( Proc ).Code ) );
  {$ENDIF}
end;
{$ENDIF ASM_VERSION}

//[procedure TObj.RemoveFromAutoFree]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION}
procedure TObj.RemoveFromAutoFree(Obj: PObj);
var i: Integer;
begin
  if fAutoFree <> nil then
  begin
    i := fAutoFree.IndexOf( Obj );
    if i >= 0 then
    begin
      fAutoFree.DeleteRange( i and not 1, 2 );
      if fAutoFree.Count = 0 then
        Free_And_Nil( fAutoFree );
    end;
  end;
end;
{$ENDIF ASM_VERSION}

procedure TObj.RemoveFromAutoFreeEx(Proc: TObjectMethod);
var i: Integer;
begin
  if fAutoFree <> nil then
  begin
    for i := 0 to fAutoFree.Count-2 do
      if (fAutoFree.Items[ i ] = TMethod( Proc ).Data) and
         (fAutoFree.Items[ i+1 ] = TMethod( Proc ).Code) then
      begin
        fAutoFree.Delete( i );
        fAutoFree.Delete( i );
        break;
      end;
  end;
end;

{$IFDEF USE_NAMES}
procedure TObj.SetName( NewOwnerObj: PObj; NewName: AnsiString );
{$IFDEF UNIQUE_NAMES}
var i: Integer;
{$ENDIF}
begin
  if (FOwnerObj <> nil) then
    if FOwnerObj <> NewOwnerObj then
    begin
      FOwnerObj.fNamedObjList.Remove( @ Self );
    end;
  FOwnerObj := NewOwnerObj;
  if NewOwnerObj = nil then
  begin
    if NewName = '' then
     begin
      fName := '';
      Exit;
     end;
    //   ,     Applet' 
    //     ()
    FOwnerObj := @ Self; //     
    //  .    -     
    //  .
  end;
  if FOwnerObj.fNamedObjList = nil then
     FOwnerObj.fNamedObjList := NewList;
  {$IFDEF UNIQUE_NAMES}
  for i := 0 to FOwnerObj.fNamedObjList.Count-1 do
  begin
    if PObj( FOwnerObj.fNamedObjList.Items[ i ] ).FName = NewName then
    begin
      NewName := '';
      break;
    end;
  end;
  {$ENDIF}
  FName := NewName;
  if FName = '' then
     FOwnerObj.fNamedObjList.Remove( @ Self )
  else
  if FOwnerObj.fNamedObjList.IndexOf( @ Self ) < 0 then
     FOwnerObj.fNamedObjList.Add( @ Self );
end;

function TObj.FindObj(const ObjName: Ansistring): PObj;
var i: Integer;
    Obj: PObj;
begin
  if fNamedObjList <> nil then
  for i := 0 to fNamedObjList.Count-1 do
  begin
    Obj := fNamedObjList.Items[ i ];
    if ObjName = Obj.FName then
    begin
      Result := Obj; Exit;
    end;
  end;
  Result := nil;
end;
{$ENDIF}

{ TList }

{$IFDEF USE_CONSTRUCTORS}
procedure TList.Init;
begin
  {$IFDEF _D2orD3}
  inherited;
  {$ENDIF}
  fAddBy := 4;
  {$IFDEF TLIST_FAST}
  {$IFNDEF DFLT_TLIST_NOUSE_BLOCKS} // for debug only
  fUseBlocks := TRUE;
  {$ENDIF}
  {$ENDIF}
end;

//[function NewList]
function NewList: PList;
begin
  New( Result, Create );
  //Result.fAddBy := 4;
end;
//[END NewList]

{$ELSE not_USE_CONSTRUCTORS}
//[function NewList]
function NewList: PList;
begin
  {-}
  New( Result, Create );
  {+} {++}(* Result := PList.Create; *){--}
  Result.fAddBy := 4;
  {$IFDEF TLIST_FAST}
  {$IFNDEF DFLT_TLIST_NOUSE_BLOCKS} // for debug only
  Result.fUseBlocks := TRUE;
  {$ENDIF}
  {$ENDIF}
end;
//[END NewList]
{$ENDIF USE_CONSTRUCTORS}

//[procedure TList.Init]
{$IFDEF _D4orHigher}
function NewListInit( const AItems: array of Pointer ): PList;
var i: Integer;
begin
  Result := NewList;
  Result.Capacity := Length( AItems );
  for i := 0 to High( AItems ) do
    Result.Add( AItems[ i ] );
end;
{$ENDIF}

//[procedure HelpFastIncNum2Els]
procedure HelpFastIncNum2Els( DataArray: Pointer; Value, Count: Integer );
asm
  PUSH ESI
  PUSH EDI
  {$IFDEF F_P}
  MOV ESI, [DataArray]
  MOV EDX, [Value]
  MOV ECX, [Count]
  {$ELSE DELPHI}
  MOV ESI, EAX
  {$ENDIF F_P/DELPHI}
  MOV EDI, ESI
  CLD

@@1:
  LODSD
  ADD EAX, EDX
  STOSD
  LOOP @@1

  POP EDI
  POP ESI
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};
//[END HelpFastIncNum2Els]

//[procedure FastIncNum2Elements]
{$IFNDEF TLIST_FAST}
procedure FastIncNum2Elements( List: TList; FromIdx, Count, Value: Integer );
begin
  HelpFastIncNum2Els( @List.fItems[ FromIdx ], Value, Count );
end;
{$ENDIF}

{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
destructor TList.Destroy;
begin
   Clear;
   inherited;
end;
{$ENDIF ASM_VERSION}

//[procedure TList.Release]
{$IFDEF ASM_TLIST}
procedure TList.Release;
asm
       TEST      EAX, EAX
       JZ        @@e
       MOV       ECX, [EAX].fCount
       JECXZ     @@e
       MOV       EDX, [EAX].fItems
       PUSH      EAX
@@1:
       MOV       EAX, [EDX+ECX*4-4]
       TEST      EAX, EAX
       JZ        @@2
       PUSH      EDX
       PUSH      ECX
       CALL      System.@FreeMem
       POP       ECX
       POP       EDX
@@2:   LOOP      @@1
       POP       EAX
@@e:   CALL      TObj.RefDec
end;
{$ELSE ASM_VERSION} //Pascal
procedure TList.Release;
var I: Integer;
begin
  if @ Self = nil then Exit;
  for I := 0 to fCount - 1 do
    if {$IFDEF TLIST_FAST} Items {$ELSE} fItems {$ENDIF}[ I ] <> nil then
      FreeMem( {$IFDEF TLIST_FAST} Items {$ELSE} fItems {$ENDIF}[ I ] );
  Free;
end;
{$ENDIF ASM_VERSION}

//[procedure TList.ReleaseObjects]
procedure TList.ReleaseObjects;
var I: Integer;
begin
  if @ Self = nil then Exit;
  for I := fCount-1 downto 0 do
    PObj( {$IFDEF TLIST_FAST} Items {$ELSE} fItems {$ENDIF} [ I ] ).Free;
  Free;
end;

//[procedure TList.SetCapacity]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
//var NewItems: PPointerList;
procedure TList.SetCapacity( Value: Integer );
begin
  {$IFDEF TLIST_FAST}
  if  Value > 256 then // Capacitity       
      Value := 256;    //  -  256 ,     ,
                       // ..       256 
                       //  ,    .
  if fUseBlocks and (Assigned( fBlockList ) {or (Value > 256)}) then
  begin
    fCapacity := Value;
  end
  else
  {$ENDIF}
  begin
   if Value < Count then
      Value := Count;
   if Value = fCapacity then Exit;
   ReallocMem( fItems, Value * Sizeof( Pointer ) );
   fCapacity := Value;
  end;
end;
{$ENDIF ASM_VERSION}

//[procedure TList.Clear]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TList.Clear;
{$IFDEF TLIST_FAST}
var i: Integer;
{$ENDIF}
begin
   if fItems <> nil then
      FreeMem( fItems );
   fItems := nil;
   fCount := 0;
   fCapacity := 0;
   {$IFDEF TLIST_FAST}
   if fBlockList <> nil then
   begin
     for i := 0 to fBlockList.Count div 2 - 1 do
       FreeMem( fBlockList.Items[ i*2 ] );
     Free_And_Nil( fBlockList );
   end;
   fLastKnownBlockIdx := 0;
   fLastKnownCountBefore := 0;
   {$ENDIF}
end;
{$ENDIF ASM_VERSION}

//[procedure TList.SetAddBy]
procedure TList.SetAddBy(Value: Integer);
begin
  if Value < 1 then Value := 1;
  fAddBy := Value;
end;

//[procedure TList.Add]
{$IFDEF ASM_NO_VERSION}  /// ASM-version disabled due some problems - 20-May-2010
{$ELSE ASM_VERSION} //Pascal
procedure TList.Add( Value: Pointer );
{$IFDEF TLIST_FAST}
var LastBlockCount: Integer;
    LastBlockStart: Pointer;
{$ENDIF}
begin
  {$IFDEF TLIST_FAST}
   if fUseBlocks and ((fCount >= 256) or Assigned( fBlockList )) then
   begin
     if fBlockList = nil then
     begin
       fBlockList := NewList;
       fBlockList.fUseBlocks := FALSE;
       fBlockList.Add( fItems );
       fBlockList.Add( Pointer( fCount ) );
       fItems := nil;
     end;
     if fBlockList.fCount = 0 then
     begin
       fBlockList.Add( nil );
       fBlockList.Add( nil );
       LastBlockCount := 0;
     end
       else
     begin
       LastBlockCount := Integer( fBlockList.fItems[ fBlockList.fCount-1 ] );
       if LastBlockCount >= 256 then
       begin
         fBlockList.Add( nil );
         fBlockList.Add( nil );
         LastBlockCount := 0;
       end;
     end;
     LastBlockStart := fBlockList.Items[ fBlockList.fCount-2 ];
     if LastBlockStart = nil then
     begin
       GetMem( LastBlockStart, 256 * Sizeof( Pointer ) );
       fBlockList.Items[ fBlockList.fCount-2 ] := LastBlockStart;
     end;
     fBlockList.Items[ fBlockList.fCount-1 ] := Pointer( LastBlockCount+1 );
     PDWORD( Integer(LastBlockStart) + Sizeof(Pointer)*LastBlockCount )^ :=
       DWORD( Value );
   end
     else
  {$ENDIF}
  begin
     if fCapacity <= fCount then
     begin
       if fAddBy <= 0 then
         Capacity := fCount + Min( 1000, fCount div 4 + 1 )
       else
         Capacity := fCount + fAddBy;
     end;
     fItems[ fCount ] := Value;
  end;
  Inc( fCount );
end;
{$ENDIF ASM_VERSION}

{$IFDEF _D4orHigher}
procedure TList.AddItems(const AItems: array of Pointer);
var i: Integer;
begin
  Capacity := Count + Length( AItems );
  for i := 0 to High( AItems ) do
    Add( AItems[ i ] );
end;
{$ENDIF}

//[procedure TList.Delete]
procedure TList.Delete( Idx: Integer );
begin
  DeleteRange( Idx, 1 );
end;

//[procedure TList.DeleteRange]
{$IFDEF ASM_TLIST}
procedure TList.DeleteRange(Idx, Len: Integer);
asm     //cmd    //opd
        TEST     ECX, ECX
        JLE      @@exit
        CMP      EDX, [EAX].fCount
        JGE      @@exit
        PUSH     EBX
        XCHG     EBX, EAX
        LEA      EAX, [EDX+ECX]
        CMP      EAX, [EBX].fCount
        JBE      @@1
        MOV      ECX, [EBX].fCount
        SUB      ECX, EDX
@@1:
        MOV      EAX, [EBX].fItems
        PUSH     [EBX].fCount
        SUB      [EBX].fCount, ECX
        MOV      EBX, EDX
        LEA      EDX, [EAX+EDX*4]
        LEA      EAX, [EDX+ECX*4]
        ADD      EBX, ECX
        POP      ECX
        SUB      ECX, EBX
        SHL      ECX, 2
        CALL     System.Move
        POP      EBX
@@exit:
end;
{$ELSE ASM_VERSION} //Pascal
procedure TList.DeleteRange(Idx, Len: Integer);
{$IFDEF TLIST_FAST}
var i, DelFromBlock: Integer;
    CountBefore, CountCurrent: Integer;
    BlockStart: Pointer;
{$ENDIF}
begin
  if Len <= 0 then Exit;
  if Idx >= Count then Exit;
  Assert( (Idx >= 0), 'TList.DeleteRange: index out of bounds' );
  if DWORD( Idx + Len ) > DWORD( Count ) then
    Len := Count - Idx;
  {$IFDEF TLIST_FAST}
  if fUseBlocks and Assigned( fBlockList ) then
  begin
    CountBefore := 0;
    i := 0;
    if (fLastKnownBlockIdx > 0) and
       (Idx >= fLastKnownCountBefore) then
    begin
      i := fLastKnownBlockIdx;
      CountBefore := fLastKnownCountBefore;
    end;
    while i < fBlockList.fCount div 2 do
    begin
      BlockStart := fBlockList.fItems[ i * 2 ];
      CountCurrent := Integer( fBlockList.fItems[ i * 2 + 1 ] );
      if (Idx >= CountBefore) and (Idx < CountBefore + CountCurrent) then
      begin
        DelFromBlock := CountBefore + CountCurrent - Idx;
        if DelFromBlock > Len then
          DelFromBlock := Len;
        if DelFromBlock < CountCurrent then
        begin
          move( Pointer( Integer( BlockStart ) + (Idx - CountBefore + DelFromBlock) * Sizeof( Pointer ) )^,
                Pointer( Integer( BlockStart ) + (Idx - CountBefore) * Sizeof( Pointer ) )^,
                (CountCurrent - (Idx - CountBefore) - DelFromBlock) * Sizeof( Pointer ) );
          dec( CountCurrent, DelFromBlock );
          fBlockList.fItems[ i * 2 + 1 ] := Pointer( CountCurrent );
          dec( fCount, DelFromBlock );
          dec( Len, DelFromBlock );
          if Len <= 0 then Exit;
        end
          else
        begin // delete entire block
          //++ fix added: 21.06.08 ++ VK
          fLastKnownBlockIdx := 0;
          fLastKnownCountBefore := 0;
          //++++++++++++++++++++++++++++
          FreeMem( BlockStart );
          fBlockList.DeleteRange( i * 2, 2 );
          dec( fCount, CountCurrent );
          dec( Len, CountCurrent );
          if Len <= 0 then Exit;
          CountCurrent := 0;
          dec( i );
        end;
      end;
      inc( i );
      inc( CountBefore, CountCurrent );
    end;
  end
    else
  {$ENDIF}
  begin
    Move( fItems[ Idx + Len ], fItems[ Idx ], Sizeof( Pointer ) * (Count - Idx - Len) );
    Dec( fCount, Len );
  end;
end;
{$ENDIF ASM_VERSION}

//[procedure TList.Remove]
procedure TList.Remove(Value: Pointer);
var I: Integer;
begin
  I := IndexOf( Value );
  if I >= 0 then
    Delete( I );
end;

function TList.ItemAddress(Idx: Integer): Pointer;
{$IFDEF TLIST_FAST}
var i: Integer;
    BlockStart: Pointer;
    CountBefore, CountCurrent: Integer;
{$ENDIF}
begin
  {$IFDEF TLIST_FAST}
  if fUseBlocks and Assigned( fBlockList ) then
  begin
    CountBefore := 0;
    i := 0;
    if (fLastKnownBlockIdx > 0) and
       (Idx >= fLastKnownCountBefore) then
    begin
      CountBefore := fLastKnownCountBefore;
      i := fLastKnownBlockIdx;
    end;
    CountCurrent := CountBefore + Integer( fBlockList.fItems[ i*2+1 ] );
    if Idx - CountCurrent > fCount - CountCurrent then
    begin //       
      CountBefore := fCount;
      i := fBlockList.fCount div 2 - 1;
      while TRUE do
      begin
        BlockStart := fBlockList.fItems[ i * 2 ];
        CountCurrent := Integer( fBlockList.fItems[ i * 2 + 1 ] );
        if (CountBefore - CountCurrent <= Idx) and (Idx < CountBefore) then
        begin
          Result := Pointer( Integer( BlockStart ) +
                             (Idx - (CountBefore - CountCurrent))*Sizeof( Pointer ) );
          Exit;
        end;
        dec( CountBefore, CountCurrent );
        dec( i );
      end;
    end;
    while TRUE { i < fBlockList.Count div 2 } do
    begin
      BlockStart := fBlockList.fItems[ i * 2 ];
      CountCurrent := Integer( fBlockList.fItems[ i * 2 + 1 ] );
      if (CountBefore <= Idx) and (Idx < CountBefore + CountCurrent) then
      begin
        Result := Pointer( Integer( BlockStart ) + (Idx - CountBefore) * Sizeof( Pointer ) );
        Exit;
      end;
      inc( CountBefore, CountCurrent );
      inc( i );
    end;
  end
    else
  {$ENDIF}
  Result := Pointer( Integer( fItems ) + Idx * Sizeof( Pointer ) );
end;

//[procedure TList.Put]
{$IFDEF ASM_VERSION}
procedure TList.Put( Idx: Integer; Value: Pointer );
asm
  TEST   EDX, EDX
  JL     @@exit
  CMP    EDX, [EAX].fCount
  JGE    @@exit
  PUSH   ESI
  MOV    ESI, ECX
  {$IFDEF TLIST_FAST}
  CMP    [EAX].fUseBlocks, 0
  JZ     @@old
  MOV    ECX, [EAX].fBlockList
  JECXZ  @@old
  PUSH   EBX
  PUSH   ESI
  PUSH   EDI
  PUSH   EBP
  XCHG   EBX, EAX // EBX == @Self
  XOR    ECX, ECX // CountBefore := 0;
  XOR    EAX, EAX // i := 0;
  CMP    [EBX].fLastKnownBlockIdx, 0
  JLE    @@1
  CMP    EDX, [EBX].fLastKnownCountBefore
  JL     @@1
  MOV    ECX, [EBX].fLastKnownCountBefore
  MOV    EAX, [EBX].fLastKnownBlockIdx
@@1:
  MOV    ESI, [EBX].fBlockList
  MOV    ESI, [ESI].fItems
  MOV    EDI, [ESI+EAX*8]   // EDI = BlockStart
  MOV    ESI, [ESI+EAX*8+4] // ESI = CountCurrent
  CMP    ECX, EDX
  JG     @@next
  LEA    EBP, [ECX+ESI]
  CMP    EDX, EBP
  JGE    @@next
  MOV    [EBX].fLastKnownBlockIdx, EAX
  MOV    [EBX].fLastKnownCountBefore, ECX
  SUB    EDX, ECX
  LEA    EAX, [EDI+EDX*4]
  POP    EBP
  POP    EDI
  POP    ESI
  POP    EBX
  MOV    [EAX], ESI
  POP    ESI
  RET
@@next:
  ADD    ECX, ESI
  INC    EAX
  JMP    @@1
@@old:
  {$ENDIF}
  MOV    EAX, [EAX].fItems
  MOV    [EAX+EDX*4], ESI
  POP    ESI
@@exit:
end;
{$ELSE not ASM_VERSION}
procedure TList.Put( Idx: Integer; Value: Pointer );
{$IFDEF TLIST_FAST}
var i: Integer;
    BlockStart: Pointer;
    CountBefore, CountCurrent: Integer;
{$ENDIF}
begin
   if Idx < 0 then Exit;
   if Idx >= Count then Exit;
   {$IFDEF TLIST_FAST}
   if fUseBlocks and Assigned( fBlockList ) then
   begin
    CountBefore := 0;
    i := 0;
    if (fLastKnownBlockIdx > 0) and
       (Idx >= fLastKnownCountBefore) then
    begin
      i := fLastKnownBlockIdx;
      CountBefore := fLastKnownCountBefore;
    end;
    while i < fBlockList.fCount div 2 do
    begin
      BlockStart := fBlockList.fItems[ i * 2 ];
      CountCurrent := Integer( fBlockList.fItems[ i * 2 + 1 ] );
      if (CountBefore <= Idx) and (Idx < CountBefore + CountCurrent) then
      begin
        fLastKnownBlockIdx := i;
        fLastKnownCountBefore := CountBefore;
        PDWORD( Integer( BlockStart ) + (Idx - CountBefore) * Sizeof( Pointer ) )^ :=
          DWORD( Value );
        Exit;
      end;
      inc( CountBefore, CountCurrent );
      inc( i );
    end;
   end
     else
   {$ENDIF}
   fItems[ Idx ] := Value;
end;
{$ENDIF ASM_VERSION}

//[function TList.Get]
{$IFDEF ASM_VERSION}
function TList.Get( Idx: Integer ): Pointer;
asm
  TEST   EDX, EDX
  JL     @@ret_nil
  CMP    EDX, [EAX].fCount
  JGE    @@ret_nil
  {$IFDEF TLIST_FAST}
  CMP    [EAX].fUseBlocks, 0
  JZ     @@old
  MOV    ECX, [EAX].fBlockList
  JECXZ  @@old
  PUSH   EBX
  PUSH   ESI
  PUSH   EDI
  PUSH   EBP
  XCHG   EBX, EAX // EBX == @Self
  XOR    ECX, ECX // CountBefore := 0;
  XOR    EAX, EAX // i := 0;
  CMP    [EBX].fLastKnownBlockIdx, 0
  JLE    @@1
  CMP    EDX, [EBX].fLastKnownCountBefore
  JL     @@1
  MOV    ECX, [EBX].fLastKnownCountBefore
  MOV    EAX, [EBX].fLastKnownBlockIdx
@@1:
  MOV    ESI, [EBX].fBlockList
  MOV    ESI, [ESI].fItems
  MOV    EDI, [ESI+EAX*8]   // EDI = BlockStart
  MOV    ESI, [ESI+EAX*8+4] // ESI = CountCurrent
  CMP    ECX, EDX
  JG     @@next
  LEA    EBP, [ECX+ESI]
  CMP    EDX, EBP
  JGE    @@next
  MOV    [EBX].fLastKnownBlockIdx, EAX
  MOV    [EBX].fLastKnownCountBefore, ECX
  SUB    EDX, ECX
  MOV    EAX, [EDI+EDX*4]
  POP    EBP
  POP    EDI
  POP    ESI
  POP    EBX
  RET
@@next:
  ADD    ECX, ESI
  INC    EAX
  JMP    @@1
@@old:
  {$ENDIF}
  MOV    EAX, [EAX].fItems
  MOV    EAX, [EAX+EDX*4]
  RET
@@ret_nil:
  XOR    EAX, EAX
end;
{$ELSE not ASM_VERSION}
function TList.Get( Idx: Integer ): Pointer;
{$IFDEF TLIST_FAST}
var i: Integer;
    BlockStart: Pointer;
    CountBefore, CountCurrent: Integer;
{$ENDIF}
begin
  Result := nil;
  if Idx < 0 then Exit;
  if Idx >= fCount then Exit;
  {$IFDEF TLIST_FAST}
  if fUseBlocks and Assigned( fBlockList ) then
  begin
    CountBefore := 0;
    i := 0;
    if (fLastKnownBlockIdx > 0) and
       (Idx >= fLastKnownCountBefore) then
    begin
      i := fLastKnownBlockIdx;
      CountBefore := fLastKnownCountBefore;
    end;
    while {i < fBlockList.fCount div 2} TRUE do
    begin
      BlockStart := fBlockList.fItems[ i * 2 ];
      CountCurrent := Integer( fBlockList.fItems[ i * 2 + 1 ] );
      if (CountBefore <= Idx) and (Idx < CountBefore + CountCurrent) then
      begin
        fLastKnownBlockIdx := i;
        fLastKnownCountBefore := CountBefore;
        Result := Pointer( PDWORD( Integer( BlockStart ) + (Idx - CountBefore) * Sizeof( Pointer ) )^ );
        Exit;
      end;
      inc( CountBefore, CountCurrent );
      inc( i );
    end;
  end
    else
  {$ENDIF}
  Result := fItems[ Idx ];
end;
{$ENDIF ASM_VERSION}

//[function TList.IndexOf]
{$IFDEF ASM_TLIST}
function TList.IndexOf( Value: Pointer ): Integer;
asm
        PUSH      EDI

        MOV       EDI, [EAX].fItems
        MOV       ECX, [EAX].fCount
          PUSH      EDI
          DEC       EAX            // make "NZ" - EAX always <> 1
          MOV       EAX, EDX
          REPNZ     SCASD
          POP       EDX
        {$IFDEF USE_CMOV}
        CMOVNZ    EDI, EDX
        {$ELSE}
        JZ        @@succ
        MOV       EDI, EDX
@@succ: {$ENDIF}

        MOV       EAX, EDI
        STC
        SBB       EAX, EDX
        SAR       EAX, 2

        POP       EDI
end;
{$ELSE ASM_VERSION} //Pascal
function TList.IndexOf( Value: Pointer ): Integer;
var I: Integer;
    {$IFDEF TLIST_FAST}
    BlockStart: PDWORD;
    j: Integer;
    CountBefore, CountCurrent: Integer;
    {$ENDIF}
begin
  Result := -1;
  {$IFDEF DEBUG}
  TRY
  {$ENDIF}
     {$IFDEF TLIST_FAST}
     if fUseBlocks and Assigned( fBlockList ) then
     begin
       CountBefore := 0;
       for I := 0 to fBlockList.fCount div 2 - 1 do
       begin
         BlockStart := fBlockList.fItems[ I * 2 ];
         CountCurrent := Integer( fBlockList.fItems[ I * 2 + 1 ] );
         for j := 0 to CountCurrent-1 do
         begin
           if BlockStart^ = DWORD( Value ) then
           begin
             Result := CountBefore + j;
             Exit;
           end;
           inc( BlockStart );
         end;
         inc( CountBefore, CountCurrent );
       end;
     end
       else
     {$ENDIF}
     begin
       for I := 0 to fCount - 1 do
       begin
          if fItems[ I ] = Value then
          begin
             Result := I;
             break;
          end;
       end;
     end;
  {$IFDEF DEBUG}
  EXCEPT
    asm
      nop
    end;
  END;
  {$ENDIF}
end;
{$ENDIF ASM_VERSION}

//[procedure TList.Insert]
{$IFDEF ASM_TLIST}
procedure TList.Insert(Idx: Integer; Value: Pointer);
asm
        PUSH      ECX
        PUSH      EAX
        PUSH      [EAX].fCount
          PUSH      EDX
          CALL      TList.Add   // don't matter what to add
          POP       EDX         // EDX = Idx, Eax = Count-1
        POP       EAX
        SUB       EAX, EDX

        SAL       EAX, 2
        MOV       ECX, EAX      // ECX = (Count - Idx - 1) * 4
        POP       EAX
        MOV       EAX, [EAX].fItems
        LEA       EAX, [EAX + EDX*4]
        JL        @@1
          PUSH      EAX
          LEA       EDX, [EAX + 4]
          CALL      System.Move

          POP       EAX          // EAX = @fItems[ Idx ]
@@1:
        POP       ECX            // ECX = Value
        MOV       [EAX], ECX
end;
{$ELSE ASM_VERSION} //Pascal
procedure TList.Insert(Idx: Integer; Value: Pointer);
{$IFDEF TLIST_FAST}
var i: Integer;
    CountBefore, CountCurrent: Integer;
    BlockStart, NewBlock: Pointer;
{$ENDIF}
begin
   Assert( (Idx >= 0) and (Idx <= FCount+1), 'List index out of bounds' );
   {$IFDEF TLIST_FAST}
   if fUseBlocks and (Assigned( fBlockList ) or (fCount >= 256)) then
   begin
     if not Assigned( fBlockList ) then
     begin
       fBlockList := NewList;
       fBlockList.fUseBlocks := FALSE;
       fBlockList.Add( fItems );
       fBlockList.Add( Pointer( fCount ) );
       fItems := nil;
     end;
     if fBlockList.fCount = 0 then
     begin
       GetMem( NewBlock, 256 * Sizeof( Pointer ) );
       fBlockList.Add( NewBlock );
       fBlockList.Add( nil );
     end;
     CountBefore := 0;
     i := 0;
     if (fLastKnownBlockIdx > 0) and
        (Idx >= fLastKnownCountBefore) then
     begin
       i := fLastKnownBlockIdx;
       CountBefore := fLastKnownCountBefore;
     end;
     while TRUE {i < fBlockList.fCount div 2} do
     begin
       CountCurrent := Integer( fBlockList.Items[ i * 2 + 1 ] );
       if (Idx >= CountBefore) and
          ((Idx < CountBefore + CountCurrent) or
           (Idx = CountBefore + CountCurrent) and
           (CountCurrent < 256)) then // insert in block i
       begin
         BlockStart := fBlockList.fItems[ i * 2 ];
         if BlockStart = nil then
         begin
           GetMem( BlockStart, 256 * Sizeof( Pointer ) );
           fBlockList.fItems[ i * 2 ] := BlockStart;
         end;
         Idx := Idx - CountBefore;
         if CountCurrent < 256 then
         begin
           if Idx < CountCurrent then
             Move( Pointer( Integer( BlockStart ) + Idx * Sizeof( Pointer ) )^,
                   Pointer( Integer( BlockStart ) + (Idx+1) * Sizeof( Pointer ) )^,
                   (CountCurrent - Idx) * Sizeof( Pointer ) );
           PDWORD( Integer( BlockStart ) + Idx * Sizeof( Pointer ) )^ :=
             DWORD( Value );
           fBlockList.fItems[ i * 2 + 1 ] := Pointer( CountCurrent + 1 );
         end
           else // new block is created since current block is full 256 items
         begin
           GetMem( NewBlock, 256 * Sizeof( Pointer ) );
           fBlockList.Insert( (i+1)*2, Pointer( 256-Idx ) );
           fBlockList.Insert( (i+1)*2, NewBlock );
           move( Pointer( Integer( BlockStart ) + Idx * Sizeof( Pointer ) )^,
                 NewBlock^, (256 - Idx) * Sizeof( Pointer ) );
           PDWORD( Integer( BlockStart ) + Idx * Sizeof( Pointer ) )^ :=
             DWORD( Value );
           fBlockList.fItems[ i * 2 + 1 ] := Pointer( Idx + 1 );
         end;
         fLastKnownBlockIdx := i;
         fLastKnownCountBefore := CountBefore;
         inc( fCount );
         Exit;
       end;
       inc( CountBefore, CountCurrent );
       inc( i );
       if i >= fBlockList.fCount div 2 then
       begin
         fBlockList.Add( nil );
         fBlockList.Add( nil );
       end;
     end;
   end
     else
   {$ENDIF}
   begin
     Add( nil );
     if fCount > Idx then
       Move( FItems[ Idx ], FItems[ Idx + 1 ], (fCount - Idx - 1) * Sizeof( Pointer ) );
     FItems[ Idx ] := Value;
   end;
end;
{$ENDIF ASM_VERSION}

{$IFDEF ASM_VERSION} {$DEFINE MoveItem_ASM} {$ENDIF}
{$IFDEF TLIST_FAST}  {$UNDEF  MoveItem_ASM} {$ENDIF}

//[procedure TList.MoveItem]
{$IFDEF MoveItem_ASM}
{$ELSE ASM_VERSION} //Pascal
procedure TList.MoveItem(OldIdx, NewIdx: Integer);
var Item: Pointer;
begin
  if OldIdx = NewIdx then Exit;
  if NewIdx >= Count then Exit;
  Item := Items[ OldIdx ];
  Delete( OldIdx );
  Insert( NewIdx, Item );
end;
{$ENDIF ASM_VERSION}

//[function TList.Last]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TList.Last: Pointer;
begin
  if Count = 0 then
    Result := nil
  else
    Result := Items[ Count-1 ];
end;
{$ENDIF ASM_VERSION}

//[procedure TList.Swap]
{$IFDEF ASM_TLIST}
procedure TList.Swap(Idx1, Idx2: Integer);
asm
        MOV       EAX, [EAX].fItems
          PUSH      dword ptr [EAX + EDX*4]
            PUSH      ECX
            MOV       ECX, [EAX + ECX*4]
            MOV       [EAX + EDX*4], ECX
            POP       ECX
          POP       EDX
        MOV       [EAX + ECX*4], EDX
end;
{$ELSE ASM_VERSION} //Pascal
procedure TList.Swap(Idx1, Idx2: Integer);
var Tmp: DWORD;
    AItem1, AItem2: PDWORD;
begin
  {$IFDEF TLIST_FAST}
  AItem1 := ItemAddress( Idx1 );
  AItem2 := ItemAddress( Idx2 );
  {$ELSE}
  AItem1 := Pointer( Integer( fItems ) + Idx1 * Sizeof( Pointer ) );
  AItem2 := Pointer( Integer( fItems ) + Idx2 * Sizeof( Pointer ) );
  {$ENDIF}
  Tmp := AItem1^;
  AItem1^ := AItem2^;
  AItem2^ := Tmp;
end;
{$ENDIF ASM_VERSION}

//[procedure TList.SetCount]
procedure TList.SetCount(const Value: Integer);
begin
  if Value >= Count then exit;
  fCount := Value;
end;

//[procedure TList.Assign]
procedure TList.Assign(SrcList: PList);
{$IFDEF TLIST_FAST}
var i, CountCurrent: Integer;
    SrcBlock, DstBlock: Pointer;
{$ENDIF}
begin
  Clear;
  if SrcList.fCount > 0 then
  begin
    {$IFDEF TLIST_FAST}
    if SrcList.fUseBlocks and Assigned( SrcList.fBlockList ) then
    begin
      fBlockList := NewList;
      fBlockList.Assign( SrcList.fBlockList );
      for i := 0 to fBlockList.Count div 2 - 1 do
      begin
        SrcBlock := SrcList.fBlockList.fItems[ i*2 ];
        CountCurrent := Integer( fBlockList.fItems[ i*2+1 ] );
        GetMem( DstBlock, 256 * Sizeof( Pointer ) );
        fBlockList.fItems[ i*2 ] := DstBlock;
        move( SrcBlock^, DstBlock^, CountCurrent );
      end;
    end
      else
    {$ENDIF}
    begin
      Capacity := SrcList.fCount;
      Move( SrcList.FItems[ 0 ], FItems[ 0 ], Sizeof( Pointer ) * SrcList.fCount );
    end;
  end;
  fCount := SrcList.fCount;
end;

{$IFDEF WIN_GDI}

{ -- Window procedure -- }
(*
function CallCtlWndProc_1( Ctl: PControl; var Msg: TMsg ): Integer;
begin
  Result := Ctl.WndProc( Msg );
end;
function WndFunc_asm( W: HWnd; Msg: Cardinal; wParam, lParam: Integer )
                                   : Integer; stdcall;
const   size_TMsg = sizeof( TMsg );
asm
        ADD       ESP, -size_TMsg
        MOV       EDX, ESP

        PUSH      ESI
        PUSH      EDI

        MOV       EDI, EDX
        LEA       ESI, [W]

        MOVSD
        MOVSD
        MOVSD
        MOVSD

        MOV       EDI, EDX
        MOV       EAX, [EDI]
        TEST      EAX, EAX
        JZ        @@self_is_nil

        MOV       ECX, [CreatingWindow]
        JECXZ     @@get_self_prop

        MOV       [ECX].TControl.fHandle, EAX

        PUSH      ECX
          PUSH      ECX
          {$IFDEF USE_PROP}
          PUSH      Offset[ID_SELF]
          PUSH      EAX
          CALL      SetProp
          {$ELSE}
          PUSH      GWL_USERDATA
          PUSH      EAX
          CALL      SetWindowLong
          {$ENDIF}

          XOR       EAX, EAX
          MOV       [CreatingWindow], EAX
        POP       EAX                 // EAX = self_
        JMP       @@self_got

@@get_self_prop:
        {$IFDEF USE_PROP}
        PUSH      Offset[ID_SELF]
        PUSH      EAX
        CALL      GetProp
        {$ELSE}
        PUSH      GWL_USERDATA
        PUSH      EAX
        CALL      GetWindowLong
        {$ENDIF}
        TEST      EAX, EAX
        JNZ       @@self_got

@@self_is_nil:
        OR        EAX, [ Applet ]
        JNZ       @@self_got

        POP       EDI
        POP       ESI
        MOV       ESP, EBP
        POP       EBP
        JMP       DefWindowProc

@@self_got:
        MOV       ESI, EAX
        INC       [ESI].TControl.fNestedMsgHandling
        MOV       EDX, EDI
        CALL      CallCtlWndProc_1
        DEC       [ESI].TControl.fNestedMsgHandling
        JG        @@1
        CMP       [ESI].TControl.fBeginDestroying, 0
        JZ        @@1
        CMP       [ESI].TObj.fRefCount, 0
        JNZ       @@1
        CMP       ESI, [Applet]
        JZ        @@1
        XCHG      EAX, ESI
        CALL      TObj.RefDec
        XCHG      ESI, EAX
@@1:

        POP       EDI
        POP       ESI

        MOV       ESP, EBP
end;
*)

{$UNDEF ASM_LOCAL}
{$IFDEF ASM_noVERSION}
  {$IFNDEF _D2orD3}
  {$DEFINE ASM_LOCAL}
  {$ENDIF}
{$ENDIF}

{$IFDEF ASM_LOCAL} //!!//!!
//[FUNCTION CallCtlWndProc]
function CallCtlWndProc( Ctl: PControl; var Msg: TMsg ): Integer;
begin
  Result := Ctl.WndProc( Msg );
end;
//[END CallCtlWndProc]

//[function WndFunc]
function WndFunc( W: HWnd; Msg: Cardinal; wParam, lParam: Integer )
                                   : Integer; stdcall;
const   size_TMsg = sizeof( TMsg );
asm
        ADD       ESP, -size_TMsg
        MOV       EDX, ESP

        PUSH      ESI
        PUSH      EDI

        MOV       EDI, EDX
        LEA       ESI, [W]

        MOVSD
        MOVSD
        MOVSD
        MOVSD

        MOV       EDI, EDX
        MOV       EAX, [EDI]
        TEST      EAX, EAX
        JZ        @@self_is_nil

        MOV       ECX, [CreatingWindow]
        JECXZ     @@get_self_prop

        MOV       [ECX].TControl.fHandle, EAX

        PUSH      ECX
          PUSH      ECX
          {$IFDEF USE_PROP}
          PUSH      Offset[ID_SELF]
          PUSH      EAX
          CALL      SetProp
          {$ELSE}
          PUSH      GWL_USERDATA
          PUSH      EAX
          CALL      SetWindowLong
          {$ENDIF}

          XOR       EAX, EAX
          MOV       [CreatingWindow], EAX
        POP       EAX                 // EAX = self_
        JMP       @@self_got

@@get_self_prop:
        {$IFDEF USE_PROP}
        PUSH      Offset[ID_SELF]
        PUSH      EAX
        CALL      GetProp
        {$ELSE}
        PUSH      GWL_USERDATA
        PUSH      EAX
        CALL      GetWindowLong
        {$ENDIF}
        TEST      EAX, EAX
        JNZ       @@self_got

@@self_is_nil:
        OR        EAX, [ Applet ]
        JNZ       @@self_got

        POP       EDI
        POP       ESI
        MOV       ESP, EBP
        POP       EBP
        JMP       DefWindowProc

@@self_got:
        MOV       ESI, EAX
        INC       [ESI].TControl.fNestedMsgHandling
        MOV       EDX, EDI
        CALL      CallCtlWndProc
        DEC       [ESI].TControl.fNestedMsgHandling
        JA        @@1
        CMP       [ESI].TControl.fBeginDestroying, 0
        JZ        @@1
        CMP       [ESI].TObj.fRefCount, 0
        JNZ       @@1
        CMP       ESI, [Applet]
        JZ        @@1
        XCHG      EAX, ESI
        CALL      TObj.Free
        XCHG      ESI, EAX
@@1:

        POP       EDI
        POP       ESI

        MOV       ESP, EBP
end;
{$ELSE ASM_VERSION} //Pascal
function WndFunc( W: HWnd; Msg: Cardinal; wParam, lParam: Integer )
                                   : Integer; stdcall;
var M: TMsg;
    self_: PControl;
begin
  {if (Msg >= $BD33) and (Msg <= $BD33) then
  begin
    Result := WndFunc_asm( W, Msg, wParam, lParam );
    Exit;
  end;}

  {$IFDEF INPACKAGE}
  Log( '->WndFunc ' + Int2Hex( Msg, 4 ) + ' (' + Int2Str( Msg ) + ')' );
  TRY
  {$ENDIF INPACKAGE}

   M.hwnd := W;
   M.message := Msg;
   M.wParam := wParam;
   M.lParam := lParam;

   {$IFDEF DEBUG_ENDSESSION}
   if EndSession_Initiated then
   begin
     LogFileOutput( GetStartDir + 'es_debug.txt',
       'HWND:' + Int2Str( W ) + ' MSG:$' + Int2Hex( Msg, 4 ) +
       ' WParam: ' + Int2Str( wParam ) + '($' + Int2Hex( wParam, 8 ) + ')' +
       ' LParam: ' + Int2Str( lParam ) + '($' + Int2Hex( lParam, 8 ) + ')' );
   end;
   {$ENDIF}

   self_ := nil;
   if W <> 0 then
   begin
     if CreatingWindow <> nil then
     begin
       {$IFDEF INPACKAGE}
       Log( '//// CreatingWindow <> nil' );
       {$ENDIF INPACKAGE}
        {$IFDEF DEBUG_CREATEWINDOW}
        LogFileOutput( GetStartDir + 'Session.log',
                       'WndFunc: Creating window = ' + Int2Hex( Integer( CreatingWindow ), 4 ) +
                       ' hwnd=' + Int2Str( M.hwnd ) +
                       ' message=' + Int2Hex( M.message, 4 ) +
                       ' wParam=' + Int2Str( M.wParam ) + '=$' + Int2Hex( M.wParam, 4 ) +
                       ' lParam=' + Int2Str( M.lParam ) + '=$' + Int2Hex( M.lParam, 4 )
                     );
        {$ENDIF DEBUG_CREATEWINDOW}
        self_ := CreatingWindow;
        CreatingWindow.fHandle := W;
        {$IFDEF USE_PROP}
        {$IFDEF INPACKAGE}
        Log( '//// SetProp' );
        {$ENDIF INPACKAGE}
        SetProp( W, ID_SELF, THandle( CreatingWindow ) );
        {$ELSE}
        SetWindowLong( W, GWL_USERDATA, Integer( CreatingWindow ) );
        {$ENDIF}
        CreatingWindow := nil;
     end
        else
     {$IFDEF USE_PROP}
     self_ := Pointer( GetProp( W, ID_SELF ) );
     {$ELSE}
     self_ := Pointer( GetWindowLong( W, GWL_USERDATA ) );
     {$ENDIF}
   end;

   if self_ <> nil then
   begin
    {$IFDEF INPACKAGE}
    Log( '//// self_ <> nil, calling self_.WndProc' );
    {$ENDIF INPACKAGE}
     inc( self_.fNestedMsgHandling );
     Result := self_.WndProc( M );
     dec( self_.fNestedMsgHandling );
     if (self_.RefCount = 0) and (self_.fNestedMsgHandling <= 0) and
        self_.fBeginDestroying and (self_ <> Applet) then
       self_.Free;
   end
   else
   if Assigned( Applet ) then
      Result := Applet.WndProc( M )
   else
      Result := DefWindowProc( W, Msg, wParam, lParam );
   {$IFDEF DEBUG_ENDSESSION}
   if EndSession_Initiated then
   begin
     LogFileOutput( GetStartDir + 'es_debug.txt',
       'HWND:' + Int2Str( W ) + ' MSG:$' + Int2Hex( Msg, 4 ) +
       ' Result: ' + Int2Str( Result ) + '($' + Int2Hex( Result, 8 ) + ')' );
   end;
   {$ENDIF}
  {$IFDEF INPACKAGE}
    LogOK;
  FINALLY
    Log( '<-WndFunc' );
  END;
  {$ENDIF INPACKAGE}
end;
//[END WndFunc]
{$ENDIF ASM_VERSION}

var
  IdleHandlers: PList;
  ProcessIdle: procedure ( Sender: PObj ) = DummyObjProc;

//[procedure ProcessIdleProc]
procedure ProcessIdleProc( Sender: PObj );
var
  i: integer;
  m: TMethod;
begin
  if AppletTerminated then exit;  // YS +
  i := 0;
  with IdleHandlers{-}^{+} do
    while i < Count do begin
      m.Code:=Items[i];
      Inc(i);
      m.Data:=Items[i];
      Inc(i);
      TOnEvent(m)(Sender);
    end;
end;

//[function FindIdleHandler]
function FindIdleHandler( const OnIdle: TOnEvent ): integer;
var
  i: integer;
begin
  i := 0;
  if not AppletTerminated then //+ {Maxim Pushkar}
  with TMethod(OnIdle), IdleHandlers{-}^{+} do
    while i < Count do begin
      if (Items[i] = Code) and (Items[i + 1] = Data) then
      begin
        Result := i;
        exit;
      end;
      Inc(i, 2);
    end;
  Result := -1;
end;
//[END FindIdleHandler]

//[procedure RegisterIdleHandler]
procedure RegisterIdleHandler( const OnIdle: TOnEvent );
begin
  if IdleHandlers = nil then begin
    IdleHandlers := NewList;
    if Applet <> nil then
      Applet.Add2AutoFree(IdleHandlers);
  end;
  with TMethod(OnIdle) do
  begin
    IdleHandlers.Add(Code);
    IdleHandlers.Add(Data);
  end;
  ProcessIdle := @ProcessIdleProc;
end;

//[procedure UnRegisterIdleHandler]
procedure UnRegisterIdleHandler( const OnIdle: TOnEvent );
var
  i: integer;
begin
  i := FindIdleHandler(OnIdle);
  if i <> -1 then
  with IdleHandlers{-}^{+} do
  begin
    Delete(i);
    Delete(i);
  end;
end;

{$IFDEF GDI}
//[procedure TerminateExecution]
{$IFDEF ASM_noVERSION}
procedure TerminateExecution( var AppletWnd: PControl );
asm
          PUSH EBX
          PUSH ESI
          MOV  BX, $0100
          XCHG BX, word ptr [AppletRunning]
          XOR  ECX, ECX
          XCHG ECX, [Applet]
          JECXZ @@exit
          PUSH EAX

          XCHG EAX, ECX
          MOV  ESI, EAX
          CALL TObj.RefInc

          TEST BH, BH
          JE   @@closed

          MOV  EAX, ESI
          CALL TControl.ProcessMessages
          PUSH 0
          PUSH 0
          PUSH WM_CLOSE
          PUSH ESI
          CALL TControl.Perform
@@closed:
          POP  EAX
          XOR  ECX, ECX
          MOV  dword ptr [EAX], ECX
          MOV  EAX, ESI
          CALL TObj.Free
          XCHG EAX, ESI
          CALL TObj.RefDec
@@exit:
          POP  ESI
          POP  EBX
end;
{$ELSE ASM_VERSION}
procedure TerminateExecution( var AppletWnd: PControl );
var App: PControl;
    Appalreadyterminated: Boolean;
begin
  Appalreadyterminated := AppletTerminated;
  AppletTerminated := TRUE;
  AppletRunning := FALSE;
  App := Applet;
  Applet := nil;
  if (App <> nil) {and (App.RefCount >= 0)} then
  begin
    App.RefInc;
    if not Appalreadyterminated then
    begin
      App.ProcessMessages;
      App.Perform( WM_CLOSE, 0, 0 );
    end;
    AppletWnd := nil;
    App.Free;
    App.RefDec;
  end;
end;
{$ENDIF ASM_VERSION}

//[PROCEDURE CallTControlCreateWindow]
//22{$IFDEF ASM_VERSION}
function CallTControlCreateWindow( Ctl: PControl ): Boolean;
begin
  {$IFDEF SAFE_CODE}
  Result := FALSE;
  TRY
    if Ctl = nil then Exit;
    Result := Ctl.CreateWindow;
  EXCEPT
    asm
      nop
    end;
  END;
  {$ELSE}
  Result := Ctl.CreateWindow;
  {$ENDIF}
end;
//22{$ENDIF}
//[END CallTControlCreateWindow]
{$ENDIF GDI}
{$ENDIF WIN_GDI}

{$IFDEF GDI}
//[PROCEDURE Run]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure Run( var AppletWnd: PControl );
    {$IFDEF PSEUDO_THREADS}
var n: Integer;
    i: Integer;
    T: PThread;
    u: DWORD;
    M: TMsg;
    {$ENDIF}
begin
  AppletRunning := True;
  Applet := AppletWnd;
  AppletWnd.CreateWindow; //virtual!!!
  while not AppletTerminated do
  begin
    {$IFDEF PSEUDO_THREADS}
    if Assigned( MainThread ) then
    begin
      while not PeekMessage( M, 0, 0, 0, pm_noremove ) do
      begin
        u := GetTickCount;
        n := 0;
        for i := 1 to MainThread.AllThreads.Count-1 do
        begin
          T := MainThread.AllThreads.Items[ i ];
          if not T.Suspended and not T.Terminated and (T.DoNotWakeUntil < u) then
          begin
            inc( n );
            break;
          end;
        end;
        if n = 0 then WaitMessage
        else MainThread.NextThread;
      end;
    end
    else
      WaitMessage;
    {$ELSE}
    WaitMessage;
    {$ENDIF}
    AppletWnd.ProcessMessages;
    {$IFDEF USE_OnIdle}
    ProcessIdle( AppletWnd );
    {$ENDIF}
  end;
  if AppletWnd <> nil then
    TerminateExecution( AppletWnd );
end;
//[END Run]
{$ENDIF ASM_VERSION}
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
  procedure Run( var AppletWnd: PControl );
  begin
    AppletRunning := True;
    Applet := AppletWnd;
    AppletWnd.VisualizyWindow; // for GTK, show all windows having Visible = TRUE, recursively
    gtk_main( );
    if AppletWnd <> nil then
      //TerminateExecution( AppletWnd );
      Free_And_Nil( AppletWnd );
  end;
{$ENDIF GTK}
{$ENDIF _X_}

{$IFDEF WIN_GDI}
{$IFDEF GDI}
//[procedure AppletMinimize]
procedure AppletMinimize;
begin
  if Applet = nil then Exit;
  Applet.Perform( WM_SYSCOMMAND, SC_MINIMIZE, 0 );
end;

//[procedure AppletHide]
procedure AppletHide;
begin
  if Applet = nil then Exit;
  AppletMinimize;
  Applet.Hide;
end;

//[procedure AppletRestore]
procedure AppletRestore;
begin
  if Applet = nil then Exit;
  Applet.Show;
  Applet.Perform( WM_SYSCOMMAND, SC_RESTORE, 0 );
end;

//[function ScreenWidth]
function ScreenWidth: Integer;
begin
  Result := GetSystemMetrics( SM_CXSCREEN );
end;
//[END ScreenWidth]

//[function ScreenHeight]
function ScreenHeight: Integer;
begin
  Result := GetSystemMetrics( SM_CYSCREEN );
end;
//[END ScreenHeight]
{$ENDIF GDI}

//[WndProcXXX FORWARD DECLARATIONS]
//22{$IFDEF ASM_VERSION}
function WndProcAppAsm( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
//22{$ENDIF}
function WndProcAppPas( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
function WndProcForm( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
function WndProcPaint( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
function WndProcGradient( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
function WndProcGradientEx( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
function WndProcLabelEffect( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
function WndProcNotify( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
function WndProcCommonNotify( Self_: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean; forward;
var fGlobalProcKeybd: function( Sender: PControl; var Msg: TMsg; var Rslt: Integer ): Boolean =
    WndProcDummy;
//[END OF WndProcXXX FORWARD DECLARATIONS]

{ -- Graphics support -- }

{$ENDIF WIN_GDI}
//[function _NewGraphicTool]
function _NewGraphicTool: PGraphicTool;
begin
  {-}
  New( Result, Create );
  {+}
  {++}(*Result := PGraphicTool.Create;*){--}
end;
//[END _NewGraphicTool]
{$IFDEF WIN_GDI}

//[FUNCTION SimpleGetCtlBrushHandle]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION PAS_VERSION}
function SimpleGetCtlBrushHandle( Sender: PControl ): HBrush;
begin
  if (Sender.fParent <> nil) and (Sender.fColor = Sender.fParent.fColor) then
    Result := SimpleGetCtlBrushHandle( Sender.fParent )
  else
  begin
    {$IFDEF GDI}
    if (Sender.fTmpBrush <> 0) and
       (Color2RGB( Sender.fColor ) <> Sender.fTmpBrushColorRGB) then
    begin
      DeleteObject( Sender.fTmpBrush );
      Sender.fTmpBrush := 0;
    end;
    if Sender.fTmpBrush = 0 then
    begin
      Sender.fTmpBrushColorRGB := Color2RGB( Sender.fColor );
      Sender.fTmpBrush := CreateSolidBrush( Sender.fTmpBrushColorRGB );
    end;
    Result := Sender.fTmpBrush;
    {$ELSE} Result := 0; 
    {$ENDIF GDI}
  end;
end;
{$ENDIF ASM_VERSION}
//[END SimpleGetCtlBrushHandle]

//[function NormalGetCtlBrushHandle]
function NormalGetCtlBrushHandle( Sender: PControl ): HBrush;
begin
  {$IFDEF GDI}
  if (Sender.fParent <> nil) then
    Sender.Brush.fParentGDITool := Sender.fParent.Brush;
  Result := Sender.Brush.Handle;
  {$ELSE} Result := 0;
  {$ENDIF GDI}
end;
//[END NormalGetCtlBrushHandle]

{++}(*
//[API CreateFontIndirect]
function CreateFontIndirect(const p1: TLogFont): HFONT; stdcall;
external gdi32 name 'CreateFontIndirectA';
*){--}
//[MakeXXXHandle FORWARD DECLARATIONS]
function MakeFontHandle( Self_: PGraphicTool ): THandle; forward;
function MakeBrushHandle( Self_: PGraphicTool ): THandle; forward;
function MakePenHandle( Self_: PGraphicTool ): THandle; forward;
function MakeGeometricPenHandle( Self_: PGraphicTool ): THandle; forward;
//[END OF MakeXXXHandle FORWARD DECLARATIONS]

{$ENDIF WIN_GDI}
//[FUNCTION NewBrush]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function NewBrush: PGraphicTool;
begin
  {$IFDEF GDI}
  Global_GetCtlBrushHandle := NormalGetCtlBrushHandle;
  {$ENDIF GDI}
  Result := _NewGraphicTool;
  with Result {-}^{+} do
  begin
    fNewProc := @ NewBrush;
    fType := gttBrush;
    {$IFDEF GDI}
    fMakeHandleProc := @ MakeBrushHandle;
    {$ENDIF GDI}
    Result.fData.Color := clBtnFace;
    Result.fData.Brush.Style := bsSolid;
  end;
end;
{$ENDIF ASM_VERSION}
//[END NewBrush]

//[FUNCTION NewPen]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function NewPen: PGraphicTool;
begin
  Result := _NewGraphicTool;
  with Result{-}^{+} do
  begin
    fNewProc := @ NewPen;
    fType := gttPen;
    {$IFDEF GDI}
    fMakeHandleProc := @ MakePenHandle;
    {$ENDIF GDI}
    fData.Pen.Mode := pmCopy;
  end;
end;
{$ENDIF ASM_VERSION}
//[END NewPen]

var ApplyFont2Wnd_Proc: procedure( _Self: PControl ) = nil;
procedure DoApplyFont2Wnd( _Self: PControl ); forward;

const size_FontData = sizeof( Integer {fFontHeight} ) + sizeof( Integer {fFontWidth} ) +
                      sizeof( TFontPitch ) +  sizeof( TFontStyle ) +
                      sizeof( Integer {fFontOrientation} ) +
                      sizeof( Integer {fFontWeight} ) + sizeof( TFontCharset ) +
                      sizeof( TFontQuality );

//[FUNCTION NewFont]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function NewFont: PGraphicTool;
begin
  ApplyFont2Wnd_Proc := @ DoApplyFont2Wnd;
  Result := _NewGraphicTool;
  with Result {-}^{+} do
  begin
    fNewProc := @ NewFont;
    fType := gttFont;
    {$IFDEF GDI}
    fMakeHandleProc := @ MakeFontHandle;
    fData.Color := DefFontColor;
    Move( DefFont, fData.Font, Sizeof( TGDIFont ) );
    {$ENDIF GDI}
    {$IFDEF GTK}
    fData.Font.Weight := 400;
    {$ENDIF GTK}
  end;
end;
{$ENDIF ASM_VERSION}
//[END NewFont]

//[function Color2RGB]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION}
function Color2RGB( Color: TColor ): TColor;
begin
  if Color < 0 then
    Result := GetSysColor(Color and $7F) else
    Result := Color;
end;
{$ENDIF ASM_VERSION}
//[END Color2RGB]

function RGB2BGR( Color: TColor ): TColor;
begin
  Result := ((Color shr 16) or (Color shl 16) or Color and $00FF00)
            and $FFFFFF;
end;

//[function ColorsMix]
function ColorsMix( Color1, Color2: TColor ): TColor;
{$IFDEF F_P}
begin
  Result := ((Color2RGB( Color1 ) and $FEFEFE) shr 1) +
            ((Color2RGB( Color2 ) and $FEFEFE) shr 1);
end;
{$ELSE DELPHI}
asm
   PUSH EDX
   CALL Color2Rgb
   XCHG EAX, [ESP]
   CALL Color2Rgb
   POP EDX
   AND EAX, 0FEFEFEh
   AND EDX, 0FEFEFEh
   SHR EAX, 1
   SHR EDX, 1
   ADD EAX, EDX
end;
{$ENDIF F_P/DELPHI}
//[END ColorsMix]

{$IFDEF WIN_GDI}
//[FUNCTION Color2RGBQuad]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function Color2RGBQuad( Color: TColor ): TRGBQuad;
var C: Integer;
begin
  C := Color2RGB( Color );
  C := ((C shr 16) and $FF)
    or ((C shl 16) and $FF0000)
    or (C and $FF00);
  Result := TRGBQuad( C );
end;
{$ENDIF ASM_VERSION}
//[END Color2RGBQuad]

//[FUNCTION Color2Color16]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION}
function Color2Color16( Color: TColor ): WORD;
begin
  Color := Color2RGB( Color );
  Result := (Color shr 19) and $1F or
            (Color shr 5) and $7E0 or
            (Color shl 8) and $F800;
end;
{$ENDIF ASM_VERSION}
//[END Color2Color16]

//[FUNCTION Color2Color15]
function Color2Color15( Color: TColor ): WORD;
begin
  Color := Color2RGB( Color );
  Result := (Color shr 19) and $1F or
            (Color shr 6) and $3E0 or
            (Color shl 7) and $7C00;
end;
//[END Color2Color15]

{$ENDIF WIN_GDI}
{ TGraphicTool }

//[function TGraphicTool.Assign]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION}
function TGraphicTool.Assign(Value: PGraphicTool): PGraphicTool;
var _Self: PGraphicTool;
begin
  Result := nil;
  if Value = nil then
  begin
    {$IFDEF OLD_REFCOUNT}
    if @Self <> nil then
       DoDestroy;
    {$ELSE}
    Free;
    {$ENDIF}
    Exit;
  end;
  _Self := @Self;
  if _Self = nil then
    _Self := Value.fNewProc();
  Result := _Self;
  if _Self = Value then Exit; // to avoid infinite loop when assigning to itself
  {$IFDEF GDI}
  if _Self.fHandle <> 0 then
     if Value.fHandle = _Self.fHandle then Exit;
  {$ENDIF GDI}
  _Self.Changed; // to destroy handle if allocated and release it from the canvas (if any uses it)
  Assert( Value.fType = _Self.fType, 'Attempt to assign to different GDI tool type' );
  Move( Value.fData, _Self.fData, Sizeof( fData ) );
  _Self.Changed; // to inform owner control, that its tool (font, brush) changed
end;
{$ENDIF ASM_VERSION}
{$IFDEF WIN_GDI}

//[procedure TGraphicTool.AssignHandle]
procedure TGraphicTool.AssignHandle(NewHandle: Integer);
begin
  if fHandle <> 0 then                   //
    DeleteObject( fHandle );             //
  fHandle := NewHandle;
  GetObject( fHandle, Sizeof( TGDIFont ), @ fData.Font );
  Changed;
end;

{$ENDIF WIN_GDI}
//[procedure TGraphicTool.Changed]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TGraphicTool.Changed;
{$IFDEF GDI} var H: THandle; {$ENDIF GDI}
begin
   {$IFDEF GDI}
   H := 0;
   if fHandle <> 0 then
   begin
     H := fHandle;
     fHandle := 0;
   end;
   ////////////////////////////////
   if Assigned( fOnChange ) then
      fOnChange( @Self );
   ////////////////////////////////
   if H <> 0 then
   begin
     DeleteObject( H );
      {$IFDEF DEBUG_GDIOBJECTS}
      case fType of
      gttBrush:  Dec( BrushCount );
      gttFont:   Dec( FontCount );
      gttPen:    Dec( PenCount );
      end;
      {$ENDIF}
   end;
   {$ENDIF GDI}
   {$IFDEF GTK}
   if Assigned( fPangoFontDesc ) then
   begin
     pango_font_description_free( fPangoFontDesc );
     fPangoFontDesc := nil;
   end;
   if Assigned( fOnChange ) then
      fOnChange( @Self );
   {$ENDIF GTK}
end;
{$ENDIF ASM_VERSION}

//[destructor TGraphicTool.Destroy]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
destructor TGraphicTool.Destroy;
begin
  {$IFDEF GDI}
  case fType of
  gttBrush: if fData.Brush.Bitmap <> 0 then
               DeleteObject( fData.Brush.Bitmap );
  gttPen:   if fData.Pen.BrushBitmap <> 0 then
               DeleteObject( fData.Pen.BrushBitmap )
  end;
  if fHandle <> 0 then
  begin
     DeleteObject( fHandle );
     {$IFDEF DEBUG_GDIOBJECTS}
     case fType of
     gttPen:    Dec( PenCount );
     gttBrush:  Dec( BrushCount );
     gttFont:   Dec( FontCount );
     end;
     {$ENDIF}
     //fHandle := 0; Why to do this? It is now destroying!
  end;
  {$ENDIF GDI}
  inherited;
end;
{$ENDIF ASM_VERSION}

{$IFDEF WIN_GDI}
//[function TGraphicTool.HandleAllocated]
function TGraphicTool.HandleAllocated: Boolean;
begin
  Result := fHandle <> 0;
end;

//[function TGraphicTool.ReleaseHandle]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION PAS_VERSION}
function TGraphicTool.ReleaseHandle: Integer;
begin
  Changed;
  Result := fHandle;
  fHandle := 0;
end;
{$ENDIF ASM_VERSION}

{$ENDIF WIN_GDI}
//[procedure TGraphicTool.SetInt]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TGraphicTool.SetInt( const Index: Integer; Value: Integer );
var Where: PInteger;
begin
  Where := Pointer( Integer( @ fData ) + Index );
  if Where^ = Value then Exit;
  Where^ := Value;
  Changed;
end;
{$ENDIF ASM_VERSION}

//[function TGraphicTool.GetInt]
function TGraphicTool.GetInt(const Index: Integer): Integer;
var Where: PInteger;
begin
  Where := Pointer( Integer( @ fData ) + Index );
  Result := Where^;
end;
{$IFDEF WIN_GDI}

{$ENDIF WIN_GDI}
//[procedure TGraphicTool.SetColor]
procedure TGraphicTool.SetColor( Value: TColor );
begin
  SetInt( go_Color, Value );
  fColorRGB := Color2RGB( Value );
end;
{$IFDEF WIN_GDI}

//[function TGraphicTool.IsFontTrueType]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TGraphicTool.IsFontTrueType: Boolean;
var OldFont: HFont;
    DC: HDC;
begin
  Result := False;
  if GetHandle = 0 then Exit;
  DC := GetDC( 0 );
  OldFont := SelectObject( DC, fHandle );
  if GetFontData( DC, 0, 0, nil, 0 ) <> GDI_ERROR then
     Result := True;
  SelectObject( DC, OldFont );
  ReleaseDC( 0, DC );
end;
{$ENDIF ASM_VERSION}

//[function TGraphicTool.GetBrushBitmap]
function TGraphicTool.GetBrushBitmap: HBitmap;
begin
  Result := fData.Brush.Bitmap; // for BCB only
end;

//[procedure TGraphicTool.SetBrushBitmap]
procedure TGraphicTool.SetBrushBitmap(const Value: HBitmap);
begin
  if fData.Brush.Bitmap = Value then Exit;
  if fData.Brush.Bitmap <> 0 then
  begin
    Changed; // !!!
    DeleteObject( fData.Brush.Bitmap );
  end;
  fData.Brush.Bitmap := Value;
  Changed;
end;

//[function TGraphicTool.GetBrushStyle]
function TGraphicTool.GetBrushStyle: TBrushStyle;
begin
  Result := fData.Brush.Style; // for BCB only
end;

{$ENDIF WIN_GDI}
//[procedure TGraphicTool.SetBrushStyle]
procedure TGraphicTool.SetBrushStyle(const Value: TBrushStyle);
begin
  if fData.Brush.Style = Value then Exit;
  fData.Brush.Style := Value;
  Changed;
end;
{$IFDEF WIN_GDI}

//[function TGraphicTool.GetFontCharset]
function TGraphicTool.GetFontCharset: TFontCharset;
begin
  Result := fData.Font.CharSet; // for BCB only
end;

//[procedure TGraphicTool.SetFontCharset]
procedure TGraphicTool.SetFontCharset(const Value: TFontCharset);
begin
  if fData.Font.Charset = Value then Exit;
  fData.Font.Charset := Value;
  Changed;
end;

//[function TGraphicTool.GetFontQuality]
function TGraphicTool.GetFontQuality: TFontQuality;
begin
  Result := fData.Font.Quality; // for BCB only
end;

//[procedure TGraphicTool.SetFontQuality]
procedure TGraphicTool.SetFontQuality(const Value: TFontQuality);
begin
  if fData.Font.Quality = Value then Exit;
  fData.Font.Quality := Value;
  Changed;
end;
{$ENDIF WIN_GDI}

//[function TGraphicTool.GetFontName]
function TGraphicTool.GetFontName: KOLString;
begin
  Result := fData.Font.Name;
  {$IFDEF GTK}
  if Result = '' then
    Result := 'Sans Serif';
  {$ENDIF GTK}
end;

//[procedure TGraphicTool.SetFontName]
procedure TGraphicTool.SetFontName(const Value: KOLString);
begin
  if fData.Font.Name = Value then Exit;
  FillChar( fData.Font.Name[ 0 ], LF_FACESIZE, #0 );
  {$IFDEF UNICODE_CTRLS} WStrLCopy {$ELSE} StrLCopy {$ENDIF}
  ( PKOLChar(@fData.Font.Name[0]), PKOLChar( Value ), Length(Value) * SizeOf(KOLChar) {LF_FACESIZE} ); 
  Changed;
end;

{$IFDEF WIN_GDI}
//[procedure TextAreaEx]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TextAreaEx( Sender: PCanvas; var Sz : TSize; var Pt : TPoint );
var Orient : Integer;
    Pts : array[ 1..4 ] of TPoint;
    MinX, MinY, I : Integer;
    A : Double;
begin
   if not Sender.Font.IsFontTrueType then Exit;
   Orient := Sender.Font.FontOrientation;
   Pt.x := 0; Pt.y := 0;
   if Orient = 0 then
      Exit;
   A := Orient / 1800.0 * PI;
   Pts[ 1 ] := Pt;
   Pts[ 2 ].x := Round( Sz.cx * cos( A ) );
   Pts[ 2 ].y := - Round( Sz.cx * sin( A ) );
   Pts[ 4 ].x := - Round( Sz.cy * cos( A + PI / 2 ) );
   Pts[ 4 ].y := Round( Sz.cy * sin( A + PI / 2 ) );
   Pts[ 3 ].x := Pts[ 2 ].x + Pts[ 4 ].x;
   Pts[ 3 ].y := Pts[ 2 ].y + Pts[ 4 ].y;
   MinX := 0; MinY := 0;
   for I := 2 to 4 do
   begin
      if Pts[ I ].x < MinX then
         MinX := Pts[ I ].x;
      if Pts[ I ].y < MinY then
         MinY := Pts[ I ].y;
   end;
   Sz.cx := 0;
   Sz.cy := 0;
   for I := 1 to 4 do
   begin
      Pts[ I ].x := Pts[ I ].x - MinX;
      Pts[ I ].y := Pts[ I ].y - MinY;
      if Pts[ I ].x > Sz.cx then
         Sz.cx := Pts[ I ].x;
      if Pts[ I ].y > Sz.cy then
         Sz.cy := Pts[ I ].y;
   end;
   Pt := Pts[ 1 ];
end;
{$ENDIF ASM_VERSION}

//[function TGraphicTool.GetFontOrientation]
function TGraphicTool.GetFontOrientation: Integer;
begin
  Result := fData.Font.Orientation; // for BCB only
end;

//[procedure TGraphicTool.SetFontOrientation]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TGraphicTool.SetFontOrientation(Value: Integer);
begin
  GlobalGraphics_UseFontOrient := True;
  GlobalCanvas_OnTextArea := TextAreaEx;
  Value := Value mod 3600; // -3599..+3599
  SetInt( go_FontOrientation, Value );
  SetInt( go_FontEscapement, Value );
end;
{$ENDIF ASM_VERSION}

//[function TGraphicTool.GetFontPitch]
function TGraphicTool.GetFontPitch: TFontPitch;
begin
  Result := fData.Font.Pitch; // for BCB only
end;

//[procedure TGraphicTool.SetFontPitch]
procedure TGraphicTool.SetFontPitch(const Value: TFontPitch);
begin
  if fData.Font.Pitch = Value then Exit;
  fData.Font.Pitch := Value;
  Changed;
end;
{$ENDIF WIN_GDI}

//[function TGraphicTool.GetFontStyle]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TGraphicTool.GetFontStyle: TFontStyle;
type PFontStyle = ^TFontStyle;
begin
  Result := [ ];
  if fData.Font.Weight >= 700 then Result := [ fsBold ];
  if fData.Font.Italic        then Result := Result + [ fsItalic ];
  if fData.Font.Underline     then Result := Result + [ fsUnderline ];
  if fData.Font.StrikeOut     then Result := Result + [ fsStrikeOut ];
end;
{$ENDIF ASM_VERSION}

//[procedure TGraphicTool.SetFontStyle]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TGraphicTool.SetFontStyle(const Value: TFontStyle);
begin
  if FontStyle = Value then Exit;
  if fsBold in Value then
  begin
    if fData.Font.Weight < 700 then
      fData.Font.Weight := 700;
  end
    else
  begin
    if fData.Font.Weight >= 700 then
      fData.Font.Weight := 0;
  end;
  fData.Font.Italic := fsItalic in Value;
  fData.Font.Underline := fsUnderline in Value;
  fData.Font.StrikeOut := fsStrikeOut in Value;
  Changed;
end;
{$ENDIF ASM_VERSION}

{$IFDEF WIN_GDI}
//[function TGraphicTool.GetPenMode]
function TGraphicTool.GetPenMode: TPenMode;
begin
  Result := fData.Pen.Mode; // for BCB only
end;

//[procedure TGraphicTool.SetPenMode]
procedure TGraphicTool.SetPenMode(const Value: TPenMode);
begin
  if fData.Pen.Mode = Value then Exit;
  fData.Pen.Mode := Value;
  Changed;
end;

//[function TGraphicTool.GetPenStyle]
function TGraphicTool.GetPenStyle: TPenStyle;
begin
  Result := fData.Pen.Style; // for BCB only
end;

//[procedure TGraphicTool.SetPenStyle]
procedure TGraphicTool.SetPenStyle(const Value: TPenStyle);
begin
  if fData.Pen.Style = Value then Exit;
  fData.Pen.Style := Value;
  Changed;
end;

//[function TGraphicTool.GetHandle]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TGraphicTool.GetHandle: THandle;
begin
  Result := fHandle;
  if Result <> 0 then
  begin
    if Color2RGB( fData.Color ) <> fColorRGB then
    begin
      DeleteObject( ReleaseHandle );
      Result := 0;
    end;
  end;
  if Result = 0 then
  begin
    if Assigned( fParentGDITool ) then
    begin
      if CompareMem( @ fData, @ fParentGDITool.fData, Sizeof( fData ) ) then
      begin
        Result := fParentGDITool.Handle;
        Exit;
      end;
    end;
    fColorRGB := Color2RGB( fData.Color );
    fMakeHandleProc( @Self );
    Result := fHandle;
  end;
end;
{$ENDIF ASM_VERSION}

//[FUNCTION MakeBrushHandle]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function MakeBrushHandle( Self_: PGraphicTool ): THandle;
var
  LogBrush: TLogBrush;
begin
  if Self_.fHandle = 0 then
  begin
   LogBrush.lbColor := Color2RGB( Self_.fData.Color );
   if Self_.fData.Brush.Bitmap <> 0 then
   begin
     LogBrush.lbStyle := BS_PATTERN;
     LogBrush.lbHatch := Self_.fData.Brush.Bitmap;
   end
      else
   begin
     LogBrush.lbHatch := 0;
     case Self_.fData.Brush.Style of
       bsSolid: LogBrush.lbStyle := BS_SOLID;
       bsClear: LogBrush.lbStyle := BS_NULL;
     else
       LogBrush.lbStyle := BS_HATCHED;
       LogBrush.lbHatch := Ord( Self_.fData.Brush.Style ) - Ord( bsHorizontal );
       LogBrush.lbColor := Color2RGB( Self_.fData.Brush.LineColor );
     end;
   end;
   Self_.fHandle := CreateBrushIndirect(LogBrush);
   {$IFDEF DEBUG_GDIOBJECTS}
   if Self_.fHandle <> 0 then
     Inc( BrushCount )
   else
     ShowMessage( 'Could not create brush, error ' + Int2Str( GetLastError ) +
                  ': ' + SysErrorMessage( GetLastError ) );
   {$ENDIF}
  end;
  Result := Self_.fHandle;
end;
{$ENDIF ASM_VERSION}
//[END MakeBrushHandle]

{$UNDEF ASM_LOCAL}
{$IFNDEF UNICODE_CTRLS}
  {$IFDEF ASM_VERSION}
    {$IFNDEF AUTO_REPLACE_CLEARTYPE}
      {$DEFINE ASM_LOCAL}
    {$ENDIF  AUTO_REPLACE_CLEARTYPE}
  {$ENDIF ASM_VERSION}
{$ENDIF}

//[FUNCTION MakeFontHandle]
{$IFDEF ASM_LOCAL}
function MakeFontHandle( Self_: PGraphicTool ): THandle;
asm
         XCHG   EDX, EAX
         MOV    EAX, [EDX].TGraphicTool.fHandle
         TEST   EAX, EAX
         JNZ    @@exit
         PUSH   EDX
         LEA    ECX, [EDX].TGraphicTool.fData.Font
         PUSH   ECX
         CALL   CreateFontIndirect
         POP    EDX
         MOV    [EDX].TGraphicTool.fHandle, EAX
@@exit:
end;
{$ELSE ASM_VERSION} //Pascal
function MakeFontHandle( Self_: PGraphicTool ): THandle;
{$IFDEF AUTO_REPLACE_CLEARTYPE}
var LF: TLogFont;
{$ENDIF}
begin
  with Self_{-}^{+} do
  begin
    if fHandle = 0 then
    begin
      {$IFDEF AUTO_REPLACE_CLEARTYPE}
      Move( fData.Font, LF, Sizeof( LF ) );
      if WinVer < wvXP then
      begin
        if LF.lfQuality > ANTIALIASED_QUALITY then
          LF.lfQuality := ANTIALIASED_QUALITY;
      end;
      fHandle := CreateFontIndirect( LF );
      {$ELSE}
      fHandle := CreateFontIndirect( PLogFont( @ fData.Font )^ );
      {$ENDIF}
      {$IFDEF DEBUG_GDIOBJECTS}
      Inc( FontCount );
      {$ENDIF}
    end;
    Result := fHandle;
  end;
end;
{$ENDIF ASM_VERSION}
//[END MakeFontHandle]

//[FUNCTION MakePenHandle]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function MakePenHandle( Self_: PGraphicTool ): THandle;
var
  LogPen: TLogPen;
begin
  with Self_{-}^{+} do
  begin
    //GlobalGraphics_OnObjectCreating( @Self );
    if fHandle = 0 then
    with LogPen do
    begin
      lopnStyle := Byte( fData.Pen.Style );
      lopnWidth.X := fData.Pen.Width;
      lopnColor := Color2RGB( fData.Color );
      fHandle := CreatePenIndirect( LogPen );
      {$IFDEF DEBUG_GDIOBJECTS}
      Inc( PenCount );
      {$ENDIF}
    end;
    //GlobalGraphics_OnObjectCreated( @Self );
    Result := fHandle;
  end;
end;
{$ENDIF ASM_VERSION}
//[END MakePenHandle]

//+

//[function GetGeometricPen]
function TGraphicTool.GetGeometricPen: Boolean;
begin
  Result := fData.Pen.Geometric; // for BCB only
end;

//[procedure TGraphicTool.SetGeometricPen]
procedure TGraphicTool.SetGeometricPen(const Value: Boolean);
begin
  if fData.Pen.Geometric = Value then Exit;
  fData.Pen.Geometric := Value;
  fMakeHandleProc := MakeGeometricPenHandle;
  Changed;
end;

//[function TGraphicTool.GetPenEndCap]
function TGraphicTool.GetPenEndCap: TPenEndCap;
begin
  Result := fData.Pen.EndCap; // for BCB only
end;

//[procedure TGraphicTool.SetPenEndCap]
procedure TGraphicTool.SetPenEndCap(const Value: TPenEndCap);
begin
  if fData.Pen.EndCap = Value then Exit;
  fData.Pen.EndCap := Value;
  Changed;
end;

//[function TGraphicTool.GetPenJoin]
function TGraphicTool.GetPenJoin: TPenJoin;
begin
  Result := fData.Pen.Join; // for BCB only
end;

//[procedure TGraphicTool.SetPenJoin]
procedure TGraphicTool.SetPenJoin(const Value: TPenJoin);
begin
  if fData.Pen.Join = Value then Exit;
  fData.Pen.Join := Value;
  Changed;
end;

//[FUNCTION MakeGeometricPenHandle]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function MakeGeometricPenHandle( Self_: PGraphicTool ): THandle;
const
  PenStyles: array[ TPenStyle ] of Word =
    (PS_SOLID, PS_DASH, PS_DOT, PS_DASHDOT, PS_DASHDOTDOT, PS_NULL,
     PS_INSIDEFRAME);
  PenEndCapStyles: array[ TPenEndCap ] of Word =
    (PS_ENDCAP_ROUND, PS_ENDCAP_SQUARE, PS_ENDCAP_FLAT);
  PenJoinStyles: array[ TPenJoin ] of Word =
    (PS_JOIN_ROUND, PS_JOIN_BEVEL, PS_JOIN_MITER );
var
  LogBrush: TLogBrush;
begin
  if Self_.fHandle = 0 then
  with Self_{-}^{+}, LogBrush do
  begin
      lbColor := Color2RGB( fData.Color );
      lbHatch := 0;
      if fData.Pen.BrushBitmap <> 0 then
      begin
        lbStyle := BS_PATTERN;
        lbHatch := fData.Pen.BrushBitmap;
      end
         else
      case fData.Pen.BrushStyle of
      bsSolid: lbStyle := BS_SOLID;
      bsClear: lbStyle := BS_NULL;
      else  begin
               lbStyle := BS_HATCHED;
               case fData.Pen.BrushStyle of
               bsHorizontal: lbHatch := HS_HORIZONTAL;
               bsVertical:   lbHatch := HS_VERTICAL;
               bsFDiagonal:  lbHatch := HS_FDIAGONAL;
               bsBDiagonal:  lbHatch := HS_BDIAGONAL;
               bsCross:      lbHatch := HS_CROSS;
               bsDiagCross:  lbHatch := HS_DIAGCROSS;
               end;
            end;
      end;
  end;
  Self_.fHandle := ExtCreatePen( PS_GEOMETRIC or Byte( Self_.fData.Pen.Style ) or
                           PenEndCapStyles[ Self_.fData.Pen.EndCap ] or
                           PenJoinStyles[ Self_.fData.Pen.Join ],
             Self_.fData.Pen.Width, LogBrush, 0, nil );
  {Assert( Self_.fHandle <> 0, 'Error ' + Int2Str( GetLastError ) +
                              ': ' + SysErrorMessage( GetLastError ) );}
  {$IFDEF DEBUG_GDIOBJECTS}
  Inc( PenCount );
  {$ENDIF}
  Result := Self_.fHandle;
end;
{$ENDIF ASM_VERSION}
//[END MakeGeometricPenHandle]

{$ENDIF WIN_GDI}
//[function TGraphicTool.GetFontWeight]
function TGraphicTool.GetFontWeight: Integer;
begin
  Result := fData.Font.Weight; // for BCB only
end;

//[procedure TGraphicTool.SetFontWeight]
procedure TGraphicTool.SetFontWeight(const Value: Integer);
begin
  if fData.Font.Weight = Value then Exit;
  fData.Font.Weight := Value;
  Changed;
end;
{$IFDEF WIN_GDI}

//[procedure TGraphicTool.SetLogFontStruct]
procedure TGraphicTool.SetLogFontStruct(const Value: TLogFont);
begin
  if  CompareMem(@fData.Font, @Value, SizeOf(TLogFont)) then Exit;
  Move(Value, fData.Font, SizeOF(TLogFont));
  Changed;
end;

//[function TGraphicTool.GetLogFontStruct]
function TGraphicTool.GetLogFontStruct: TLogFont;
begin
  Move(fData.Font, Result, SizeOf(TLogFont));
end;
{$ENDIF WIN_GDI}

{$IFDEF _X_}
{$IFDEF GTK}
function TGraphicTool.GetPangoFontDesc: PPangoFontDescription;
var s: AnsiString;
    i: Integer;
    function IfThen( cond: Boolean; const s: AnsiString ): AnsiString;
    begin
      Result := '';
      if cond then Result := s;
    end;
{const Weights: array[0..9] of String = ( 'Ultralight',
   'Ultralight', 'Ultralight',
   'Light', 'Normal', 'Normal', 'Normal',
   'Bold', 'Ultrabold', 'Heavy' );}
begin
  if not Assigned( fPangoFontDesc ) then
  begin
    s := FontName; { + ' ' +
      IfThen( FontWeight <> 400, Weights[ FontWeight div 100 ] + ' ' ) +
      IfThen( fsItalic in FontStyle, 'Italic ' ) {+
      Int2Str( FontHeight )};
    fPangoFontDesc := pango_font_description_from_string( PAnsiChar( s ) );
    i := FontHeight;
    if i > 0 then
      pango_font_description_set_absolute_size( fPangoFontDesc, i * PANGO_SCALE );
    //i := pango_font_description_get_size( fPangoFontDesc );
    i := PANGO_STYLE_NORMAL;
    if fsItalic in FontStyle then i := PANGO_STYLE_ITALIC;
    pango_font_description_set_style( fPangoFontDesc, i );
    pango_font_description_set_weight( fPangoFontDesc, FontWeight );
  end;
  Result := fPangoFontDesc;
end;

function Color2GDKColor( Color: TColor ): TGdkColor;
begin
  Color := Color2RGB( Color );
  Result.pixel := 0;
  Result.red   := (Color and $FF) shl 8;
  Result.green := Color and $FF00;
  Result.blue  := (Color shr 8) and $FF00;
end;
{$ENDIF GTK}
{$ENDIF _X_}
{$IFDEF WIN_GDI}

{ TCanvas }

type
  TStock = Packed Record
    StockPen: HPEN;
    StockBrush: HBRUSH;
    StockFont: HFONT;
  end;

var
  Stock: TStock;

//[destructor TCanvas.Destroy]
destructor TCanvas.Destroy;
begin
  Handle := 0;
  fPen.Free;
  fBrush.Free;
  fFont.Free;
  inherited;
end;

//[function TCanvas.Assign]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TCanvas.Assign(SrcCanvas: PCanvas): Boolean;
begin
  fFont := fFont.Assign( SrcCanvas.fFont );
  fBrush := fBrush.Assign( SrcCanvas.fBrush );
  fPen := fPen.Assign( SrcCanvas.fPen );
  AssignChangeEvents;
  Result := (fFont <> nil) or (fBrush <> nil) or (fPen <> nil);
  if (SrcCanvas.PenPos.x <> PenPos.x) or (SrcCanvas.PenPos.y <> PenPos.y) then
  begin
     Result := True;
     PenPos := SrcCanvas.PenPos;
  end;
  if SrcCanvas.ModeCopy <> ModeCopy then
  begin
     Result := True;
     ModeCopy := SrcCanvas.ModeCopy;
  end;
end;
{$ENDIF ASM_VERSION}

//[procedure TCanvas.CreateBrush]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.CreateBrush;
begin
  if assigned( fBrush ) then
  begin
    SelectObject( GetHandle, fBrush.Handle );
    AssignChangeEvents;
    if fBrush.fData.Brush.Style = bsSolid then
    begin
      SetBkColor( fHandle, Color2RGB( fBrush.fData.Color ) );
      SetBkMode( fHandle, OPAQUE );
    end
       else
    begin
      { Win95 doesn't draw brush hatches if bkcolor = brush color }
      { Since bkmode is transparent, nothing should use bkcolor anyway }
      SetBkColor( fHandle, not Color2RGB( fBrush.fData.Color ) );
      SetBkMode( fHandle, TRANSPARENT );
    end;
  end
     else
  if Assigned( fOwnerControl ) then
  begin
    SetBkColor( GetHandle, Color2RGB( PControl( fOwnerControl ).fColor ) );
    SetBkMode( fHandle, OPAQUE );
  end;
end;
{$ENDIF ASM_VERSION}

//[procedure TCanvas.CreateFont]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.CreateFont;
begin
  if assigned( fFont ) then
  begin
    SelectObject( GetHandle, fFont.Handle );
    SetTextColor( fHandle, Color2RGB( fFont.fData.Color ) );
    AssignChangeEvents;
  end
     else
  if Assigned( fOwnerControl ) then
  begin
    SetTextColor( fHandle, Color2RGB( PControl( fOwnerControl ).fTextColor ) );
  end;
end;
{$ENDIF ASM_VERSION}

//[procedure TCanvas.CreatePen]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.CreatePen;
begin
  if assigned( fPen ) then
  begin
    SelectObject( GetHandle, fPen.Handle );
    SetROP2( fHandle, Ord( fPen.fData.Pen.Mode ) + 1 );
    AssignChangeEvents;
  end;
end;
{$ENDIF ASM_VERSION}

//[function TCanvas.GetPixels]
function TCanvas.GetPixels(X, Y: Integer): TColor;
begin
  RequiredState( HandleValid );
  Result := Windows.GetPixel(FHandle, X, Y);
end;

//[procedure TCanvas.SetPixels]
procedure TCanvas.SetPixels(X, Y: Integer; const Value: TColor);
begin
  Changing;
  RequiredState( HandleValid );
  Windows.SetPixel(FHandle, X, Y, Color2RGB( Value ));
end;

procedure TCanvas.OffsetAndRotate(Xoff, Yoff: Integer; Angle: Double);
var F: TXForm;
begin
    SetGraphicsMode( fHandle, GM_ADVANCED );
    F.eM11 := cos( Angle );
    F.eM12 := sin( Angle );
    F.eM21 := -F.eM12;
    F.eM22 := F.eM11;
    F.eDx := Xoff;
    F.eDy := Yoff;
    SetWorldTransform( fHandle, F );
    if  (Angle = 0) and (Xoff = 0) and (Yoff = 0) then
        SetGraphicsMode( fHandle, GM_COMPATIBLE );
end;

{$ENDIF WIN_GDI}

{$IFDEF _X_}
{$IFDEF GTK}
procedure TCanvas.SaveState;
begin
  gdk_gc_get_values( fHandle, @ fSavedState );
end;

procedure TCanvas.RestoreState;
var mask: DWORD;
begin
  mask := $1FFFF;
  if fSavedState.font = nil then mask := mask and not GDK_GC_FONT;
  if fSavedState.stipple = nil then mask := mask and not GDK_GC_STIPPLE;
  gdk_gc_set_values( fHandle, @ fSavedState, mask );
  DeselectHandles;
end;
{$ENDIF GTK}
{$ENDIF _X_}

//[procedure TCanvas.DeselectHandles]
{$IFDEF GDI}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.DeselectHandles;
begin
   if (fHandle <> 0) and
      LongBool(fState and (PenValid or BrushValid or FontValid)) then
   with Stock do
   begin
     if StockPen = 0 then
     begin
       StockPen := GetStockObject(BLACK_PEN);
       StockBrush := GetStockObject(HOLLOW_BRUSH);
       StockFont := GetStockObject(SYSTEM_FONT);
     end;
     SelectObject( fHandle, StockPen );
     SelectObject( fHandle, StockBrush );
     SelectObject( fHandle, StockFont );
     fState := fState and not( PenValid or BrushValid or FontValid );
   end;
end;
{$ENDIF ASM_VERSION}
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
procedure TCanvas.DeselectHandles;
begin
  {$IFDEF GDI}
  Free_And_Nil( fBrush );
  Free_And_Nil( fPen );
  Free_And_Nil( fFont );
  {$ENDIF GDI}
  if Assigned( fFont ) and Assigned( fFont.fPangoFontDesc ) then
  begin
    pango_font_description_free( fFont.fPangoFontDesc );
    fFont.fPangoFontDesc := nil;
  end;
  fState := fState and not( PenValid or BrushValid or FontValid );
end;
{$ENDIF GTK}
{$ENDIF _X_}

{$IFDEF WIN_GDI}
//[function TCanvas.RequiredState]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TCanvas.RequiredState(ReqState: DWORD): HDC; stdcall;
var
  NeededState: Byte;
begin
  if Boolean(ReqState and ChangingCanvas) then
     Changing;
  ReqState := ReqState and 15;
  NeededState := Byte( ReqState ) and not fState;
  Result := 0;
    if Boolean(ReqState and HandleValid) then
    begin
      if GetHandle = 0 then Exit; // Important!
    end;
  if NeededState <> 0 then
  begin
    if Boolean( NeededState and FontValid ) then
       CreateFont;
    if Boolean( NeededState and PenValid ) then
    begin
      CreatePen;
      if assigned( fPen ) then
      if fPen.fData.Pen.Style in [psDash, psDot, psDashDot, psDashDotDot] then
        NeededState := NeededState or BrushValid;
    end;
    if Boolean( NeededState and BrushValid ) then
       CreateBrush;
    fState := fState or NeededState;
  end;
  Result := fHandle;
end;
{$ENDIF ASM_VERSION}
{$ENDIF WIN_GDI}

{$IFDEF _X_}
{$IFDEF GTK}
procedure TCanvas.ForeBack(fg_color, bk_color: TColor); // install colors just before drawing
begin
  fg_color := RGB2BGR( Color2RGB( fg_color ) );
  bk_color := RGB2BGR( Color2RGB( bk_color ) );
  gdk_rgb_gc_set_foreground( fHandle, fg_color );
  gdk_rgb_gc_set_background( fHandle, bk_color );
end;
{$ENDIF GTK}
{$ENDIF _X_}

{$IFDEF WIN_GDI}

//[procedure TCanvas.SetHandle]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.SetHandle(Value: HDC);
{$IFDEF F_P}
var Ptr1: Pointer;
{$ENDIF F_P}
begin
  if fHandle = Value then Exit;
  if fHandle <> 0 then
  begin
    DeselectHandles;
    {$IFDEF GDI}
      if not( assigned(fOwnerControl) and
              (PControl(fOwnerControl).fPaintDC = fHandle) ) then
      begin
        {$IFDEF F_P}
        Ptr1 := Self;
        asm
          MOV  EAX, [Ptr1]
          MOV  EAX, [EAX].TCanvas.fOnGetHandle
          MOV  [Ptr1], EAX
        end [ 'EAX' ];
        if Ptr1 = @ TControl.DC2Canvas then
        {$ELSE DELPHI}
      //////////////////// SLAG
        if   TMethod(fOnGetHandle).Code =
             @TControl.Dc2Canvas then
        {$ENDIF F_P/DELPHI}
             ReleaseDC(PControl(fOwnerControl).Handle, fHandle )
        else
             DeleteDC( fHandle );
      ////////////////////
      end;
    {$ENDIF GDI}
    fHandle := 0;
    fIsPaintDC := False;
    fState := fState and not HandleValid;
  end;
  if Value <> 0 then
  begin
    fState := fState or HandleValid;
    fHandle := Value;
    SetPenPos( fPenPos );
  end;
end;
{$ENDIF ASM_VERSION}
{$ENDIF WIN_GDI}

//[procedure TCanvas.SetPenPos]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.SetPenPos(const Value: TPoint);
begin
  fPenPos := Value;
  {$IFDEF GDI}
  MoveTo( Value.x, Value.y );
  {$ENDIF GDI}
end;
{$ENDIF ASM_VERSION}
{$IFDEF WIN_GDI}

//[procedure TCanvas.Changing]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.Changing;
begin
  if Assigned( fOnChange ) then
     fOnChange( @Self );
end;
{$ENDIF ASM_VERSION}

{$ENDIF WIN_GDI}
//[procedure TCanvas.Arc]
{$IFDEF GDI}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.Arc(X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer); stdcall;
begin
  RequiredState( HandleValid or PenValid or ChangingCanvas );
  Windows.Arc(FHandle, X1, Y1, X2, Y2, X3, Y3, X4, Y4);
end;
{$ENDIF ASM_VERSION}
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
procedure TCanvas.Arc(X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer); stdcall;
var C: TPoint;
    angle1, angle2: Integer;
    A1, A2: Double;
begin
  ////RequiredState( {HandleValid or} PenValid or ChangingCanvas );
  C := MakePoint( (X1 + X2) div 2, (Y1 + Y2) div 2 );
  {$IFDEF NOT_USE_EXCEPTION}
    A1 := ArcTan2( Y3-C.Y, X3-C.X );
    A2 := ArcTan2( Y4-C.Y, X4-C.X );
  {$ELSE USE_EXCEPTION}
  TRY
    A1 := ArcTan2( Y3-C.Y, X3-C.X );
  EXCEPT
    A1 := 0;
  END;
  TRY
    A2 := ArcTan2( Y4-C.Y, X4-C.X );
  EXCEPT
    A2 := 0;
  END;
  {$ENDIF NOT_USE_EXCEPTION}
  angle1 := -Round(A1 * 180 * 64 / PI);
  angle2 := -Round(A2 * 180 * 64 / PI);
  if Brush.BrushStyle <> bsClear then
  begin
    ForeBack( Brush.Color, Brush.Color );
    gdk_draw_arc( fDrawable, fHandle, 1, X1, Y1, X2-X1, Y2-Y1, angle1, angle2 );
  end;
  ForeBack( Pen.Color, Brush.Color );
  gdk_draw_arc( fDrawable, fHandle, 0, X1, Y1, X2-X1, Y2-Y1, angle1, angle2 );
end;
{$ENDIF GTK}
{$ENDIF _X_}
{$IFDEF WIN_GDI}

//[procedure TCanvas.Chord]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.Chord(X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer); stdcall;
begin
  RequiredState( HandleValid or PenValid or BrushValid or ChangingCanvas );
  Windows.Chord(FHandle, X1, Y1, X2, Y2, X3, Y3, X4, Y4);
end;
{$ENDIF ASM_VERSION}

//[procedure TCanvas.CopyRect]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.CopyRect(const DstRect: TRect; SrcCanvas: PCanvas;
  const SrcRect: TRect);
begin
  RequiredState( HandleValid or FontValid or BrushValid or ChangingCanvas );
  SrcCanvas.RequiredState( HandleValid or BrushValid );
  StretchBlt( fHandle, DstRect.Left, DstRect.Top, DstRect.Right - DstRect.Left,
    DstRect.Bottom - DstRect.Top, SrcCanvas.Handle, SrcRect.Left, SrcRect.Top,
    SrcRect.Right - SrcRect.Left, SrcRect.Bottom - SrcRect.Top, ModeCopy);
end;
{$ENDIF ASM_VERSION}

//[procedure TCanvas.DrawFocusRect]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.DrawFocusRect({$IFNDEF FPC}const{$ENDIF} Rect: TRect);
begin
  RequiredState( HandleValid or BrushValid or FontValid or ChangingCanvas );
  Windows.DrawFocusRect(FHandle, Rect);
end;
{$ENDIF ASM_VERSION}

//[procedure TCanvas.Ellipse]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.Ellipse(X1, Y1, X2, Y2: Integer);
begin
  RequiredState( HandleValid or PenValid or BrushValid or ChangingCanvas );
  Windows.Ellipse(FHandle, X1, Y1, X2, Y2);
end;
{$ENDIF ASM_VERSION}

{$ENDIF WIN_GDI}
//[procedure TCanvas.FillRect]
{$IFDEF GDI}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.FillRect({$IFNDEF FPC}const{$ENDIF} Rect: TRect);
var Br: HBrush;
begin
  RequiredState( HandleValid or BrushValid or ChangingCanvas );
  if assigned( fBrush ) then
  begin
    Windows.FillRect(fHandle, Rect, fBrush.Handle);
  end
    else
  if assigned( fOwnerControl ) then
  begin
    {$IFDEF GDI}
    if assigned( PControl( fOwnerControl ).fBrush ) then
      Windows.FillRect( fHandle, Rect, PControl( fOwnerControl ).fBrush.Handle )
    else
    begin
      Br := CreateSolidBrush( Color2RGB(PControl(fOwnerControl).fColor) );
      Windows.FillRect(fHandle, Rect, Br );
      DeleteObject( Br );
    end;
    {$ENDIF GDI}
  end
  else
  begin
    Windows.FillRect(fHandle, Rect, HBrush(COLOR_WINDOW + 1) );
  end;
end;
{$ENDIF ASM_VERSION}
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
procedure TCanvas.FillRect({$IFNDEF FPC}const{$ENDIF} Rect: TRect);
begin
  if (fBrush <> nil) and (fBrush.BrushStyle = bsClear) then Exit;
  ////RequiredState( {HandleValid or} BrushValid or ChangingCanvas );
  ForeBack( Brush.Color, Brush.Color );
  gdk_draw_rectangle( fDrawable, fHandle, 1, Rect.Left, Rect.Top,
    Rect.Right-Rect.Left, Rect.Bottom-Rect.Top );
end;
{$ENDIF GTK}
{$ENDIF _X_}
{$IFDEF WIN_GDI}

//[procedure TCanvas.FillRgn]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.FillRgn(const Rgn: HRgn);
var Br : HBrush;
begin
  RequiredState( HandleValid or BrushValid or ChangingCanvas );
  if assigned( fBrush ) then
    Windows.FillRgn(FHandle, Rgn, fBrush.Handle )
    else
  if assigned( fOwnerControl ) then
  begin
    {$IFDEF GDI}
    if Assigned( PControl( fOwnerControl ).fBrush ) then
      Windows.FillRgn( FHandle, Rgn, PControl( fOwnerControl ).fBrush.Handle )
    else
    begin
      Br := CreateSolidBrush( Color2RGB(PControl(fOwnerControl).fColor) );
      Windows.FillRgn( fHandle, Rgn, Br );
      DeleteObject( Br );
    end;
    {$ENDIF GDI}
  end
     else
  begin
    Br := CreateSolidBrush( DWORD(clWindow) );
    Windows.FillRgn( fHandle, Rgn, Br );
    DeleteObject( Br );
  end;
end;
{$ENDIF ASM_VERSION}

//[procedure TCanvas.FloodFill]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.FloodFill(X, Y: Integer; Color: TColor;
  FillStyle: TFillStyle);
const
  FillStyles: array[TFillStyle] of Word =
    (FLOODFILLSURFACE, FLOODFILLBORDER);
begin
  RequiredState( HandleValid or BrushValid or ChangingCanvas );
  Windows.ExtFloodFill(FHandle, X, Y, Color, FillStyles[FillStyle]);
end;
{$ENDIF ASM_VERSION}

//[procedure TCanvas.FrameRect]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.FrameRect({$IFNDEF FPC}const{$ENDIF} Rect: TRect);
var SolidBr : HBrush;
begin
  RequiredState( HandleValid or ChangingCanvas );
  if assigned( fBrush ) then
    SolidBr := CreateSolidBrush( Color2RGB( fBrush.fData.Color ) )
  else
  if assigned( fOwnerControl ) then
    SolidBr := CreateSolidBrush( PControl(fOwnerControl).fColor )
  else
    SolidBr := CreateSolidBrush( clWhite );
  Windows.FrameRect(FHandle, Rect, SolidBr);
  DeleteObject( SolidBr );
end;
{$ENDIF ASM_VERSION}

{$ENDIF WIN_GDI}
//[procedure TCanvas.LineTo]
{$IFDEF GDI}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.LineTo(X, Y: Integer);
begin
  RequiredState( HandleValid or PenValid or BrushValid or ChangingCanvas );
  Windows.LineTo( fHandle, X, Y );
end;
{$ENDIF ASM_VERSION}
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
procedure TCanvas.LineTo(X, Y: Integer);
begin
  //RequiredState( HandleValid or PenValid or BrushValid or ChangingCanvas );
  ////RequiredState( PenValid or BrushValid or ChangingCanvas );
  ForeBack( Pen.Color, Brush.Color );
  gdk_draw_line( fDrawable, fHandle, fPenPos.X, fPenPos.Y, X, Y );
  fPenPos := MakePoint( X, Y );
end;
{$ENDIF GTK}
{$ENDIF _X_}

//[procedure TCanvas.MoveTo]
{$IFDEF GDI}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.MoveTo(X, Y: Integer);
begin
  RequiredState( HandleValid );
  Windows.MoveToEx( fHandle, X, Y, nil );
end;
{$ENDIF ASM_VERSION}
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
procedure TCanvas.MoveTo(X, Y: Integer);
begin
  fPenPos := MakePoint( X, Y );
end;
{$ENDIF GTK}
{$ENDIF _X_}

//[procedure TCanvas.ObjectChanged]
procedure TCanvas.ObjectChanged(Sender: PGraphicTool);
begin
  DeselectHandles;
end;

{$IFDEF WIN_GDI}
//[procedure TCanvas.Pie]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.Pie(X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer); stdcall;
begin
  RequiredState( HandleValid or PenValid or BrushValid or ChangingCanvas );
  Windows.Pie( fHandle, X1, Y1, X2, Y2, X3, Y3, X4, Y4);
end;
{$ENDIF ASM_VERSION}

{++}(*
{$IFDEF F_P}
//[Windows API FUNCTIONS ADDITIONAL DECLARATIONS FOR Free Pascal]
function Windows_Polygon; external gdi32 name 'Polygon';
function Windows_Polyline; external gdi32 name 'Polyline';
function FillRect; external user32 name 'FillRect';
function OffsetRect; external user32 name 'OffsetRect';
function CreateAcceleratorTable; external user32 name 'CreateAcceleratorTableA';
function TrackPopupMenu; external user32 name 'TrackPopupMenu';
function AdjustTokenPrivileges(TokenHandle: THandle; DisableAllPrivileges: BOOL;
  const NewState: TTokenPrivileges; BufferLength: DWORD;
  var PreviousState: TTokenPrivileges; var ReturnLength: DWORD): BOOL; external advapi32 name 'AdjustTokenPrivileges';
function InflateRect; external user32 name 'InflateRect';
{$IFDEF F_P105ORBELOW}
function InvalidateRect; external user32 name 'InvalidateRect';
function ValidateRect; external user32 name 'ValidateRect';
{$ENDIF F_P105ORBELOW}
//[END OF Windows API FUNCTIONS ADDITIONAL DECLARATIONS FOR Free Pascal]
{$ENDIF}
*){--}

//[procedure TCanvas.Polygon]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.Polygon(const Points: array of TPoint);
type
  PPoints = ^TPoints;
  TPoints = array[0..0] of TPoint;
begin
  RequiredState( HandleValid or PenValid or BrushValid or ChangingCanvas );
  {$IFDEF F_P} Windows_Polygon
  {$ELSE DELPHI} Windows.Polygon
  {$ENDIF}( fHandle, PPoints(@Points)^, High(Points) + 1);
end;
{$ENDIF ASM_VERSION}

//[procedure TCanvas.Polyline]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.Polyline(const Points: array of TPoint);
type
  PPoints = ^TPoints;
  TPoints = array[0..0] of TPoint;
begin
  RequiredState( HandleValid or PenValid or BrushValid or ChangingCanvas );
  {$IFDEF F_P}Windows_Polyline
  {$ELSE DELPHI}Windows.Polyline
  {$ENDIF}( fHandle, PPoints(@Points)^, High(Points) + 1);
end;
{$ENDIF ASM_VERSION}

//[procedure TCanvas.Rectangle]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.Rectangle(X1, Y1, X2, Y2: Integer);
begin
  RequiredState( HandleValid or BrushValid or PenValid or ChangingCanvas );
  Windows.Rectangle( fHandle, X1, Y1, X2, Y2);
end;
{$ENDIF ASM_VERSION}

//[procedure TCanvas.RoundRect]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.RoundRect(X1, Y1, X2, Y2, X3, Y3: Integer);
begin
  RequiredState( HandleValid or BrushValid or PenValid or ChangingCanvas );
  Windows.RoundRect( fHandle, X1, Y1, X2, Y2, X3, Y3);
end;
{$ENDIF ASM_VERSION}
{$ENDIF WIN_GDI}

//[procedure TCanvas.TextArea]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.TextArea(const Text: AnsiString; var Sz: TSize;
  var P0: TPoint);
begin
  Sz := TextExtent( Text );
  P0.x := 0; P0.y := 0;
  if Assigned( GlobalCanvas_OnTextArea ) then
     GlobalCanvas_OnTextArea( @Self, Sz, P0 );
end;
{$ENDIF ASM_VERSION}

{$IFDEF _D3orHigher}
procedure TCanvas.WTextArea(const Text: WideString; var Sz: TSize;
  var P0: TPoint);
begin
  Sz := WTextExtent( Text );
  P0.x := 0; P0.y := 0;
  if Assigned( GlobalCanvas_OnTextArea ) then
     GlobalCanvas_OnTextArea( @Self, Sz, P0 );
end;
{$ENDIF _D3orHigher}

//[function TCanvas.TextExtent]
{$IFDEF GDI}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TCanvas.TextExtent(const Text: AnsiString): TSize;
var DC : HDC;
    ClearHandle : Boolean;
begin
  ClearHandle := False;
  RequiredState( HandleValid or FontValid );
  DC := fHandle;
  if DC = 0 then
  begin
     DC := CreateCompatibleDC( 0 );
     ClearHandle := True;
     SetHandle( DC );
     If Not fIsPaintDC then
       ClearHandle := True; //************ // Added By Gerasimov
  end;
  RequiredState( HandleValid or FontValid );
  Windows.GetTextExtentPoint32A( fHandle, PAnsiChar(Text), Length(Text), Result); // KOL_ANSI
  if ClearHandle then
    SetHandle( 0 );
    { DC must be freed here automatically (never leaks):
      if Canvas created on base of existing DC, no memDC created,
      if Canvas has fHandle:HDC = 0, it is not fIsPaintDC always. }
end;
{$ENDIF ASM_VERSION}
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
function TCanvas.TextExtent(const Text: Ansistring): TSize;
var layout: PPangoLayout;
    context: PPangoContext;
begin
  //RequiredState( HandleValid or FontValid );
  if fOwnerControl <> nil then
  begin
    context := nil;
    layout := gtk_widget_create_pango_layout(
      PControl( fOwnerControl ).fEventboxHandle, nil );
  end
    else
  begin //todo: seems not working in such way... What to do for memory bitmap?
    context := pango_context_new;
    //layout := gtk_widget_create_pango_layout( fHandle, PChar( Text ) );
    layout := pango_layout_new( context );
  end;
  pango_layout_set_font_description( layout, Font.FontHandle );
  pango_layout_set_text( layout, PAnsiChar( Text ), Length( Text ) );
  pango_layout_get_size( layout, @ Result.cx, @ Result.cy );
  g_object_unref( layout );
  if context <> nil then g_object_unref( context );
end;
{$ENDIF GTK}
{$ENDIF _X_}

//[function TCanvas.TextHeight]
function TCanvas.TextHeight(const Text: Ansistring): Integer;
begin
  Result := TextExtent(Text).cY;
end;

//[procedure TCanvas.TextOut]
{$IFDEF GDI}
procedure TCanvas.TextOutA(X, Y: Integer; const Text: AnsiString); stdcall;
begin
  RequiredState( HandleValid or FontValid or BrushValid or ChangingCanvas );
  Windows.TextOutA(FHandle, X, Y, PAnsiChar(Text), Length(Text));
end;

{$IFDEF ASM_UNICODE}
procedure TCanvas.TextOut(X, Y: Integer; const Text: KOLString); stdcall;
asm
        PUSH     EBX
        MOV      EBX, [EBP+8]

        MOV      EAX, [Text]
        PUSH     EAX
        CALL     System.@LStrLen
        XCHG     EAX, [ESP]             // prepare Length(Text)

        //CALL     System.@LStrToPChar  // string does not need to be null-terminated !
        PUSH     EAX                    // prepare PChar(Text)
        PUSH     [Y]                    // prepare Y
        PUSH     [X]                    // prepare X

        PUSH     HandleValid or FontValid or BrushValid or ChangingCanvas
        PUSH     EBX
        CALL     RequiredState
        PUSH     EAX                    // prepare fHandle
        CALL     Windows.TextOutA // KOL_ANSI

        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.TextOut(X, Y: Integer; const Text: KOLString); stdcall;
begin
  RequiredState( HandleValid or FontValid or BrushValid or ChangingCanvas );
  {$IFDEF UNICODE_CTRLS}Windows.TextOutW
  {$ELSE}               Windows.TextOutA
  {$ENDIF}(FHandle, X, Y, PKOLChar(Text), Length(Text));
end;
{$ENDIF ASM_VERSION}
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
procedure TCanvas.TextOut(X, Y: Integer; const Text: AnsiString); stdcall;
var Options: Integer;
begin
  Options := 0;
  if Brush.BrushStyle <> bsClear then Options := ETO_OPAQUE;
  ExtTextOut( X, Y, Options, MakeRect( 0,0,0,0 ), Text, [ ] );
end;
{$ENDIF GTK}
{$ENDIF _X_}

//[procedure TCanvas.TextRect]
{$IFDEF GDI}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.TextRect(const Rect: TRect; X, Y: Integer; const Text: Ansistring);
var
  Options: Integer;
begin
  //Changing;
  RequiredState( HandleValid or FontValid or BrushValid or ChangingCanvas );
  Options := ETO_CLIPPED;
  if assigned( fBrush ) and (fBrush.fData.Brush.Style <> bsClear)
  or not assigned( fBrush ) then Inc(Options, ETO_OPAQUE);
  Windows.ExtTextOutA( fHandle, X, Y, Options,
                       @Rect, PAnsiChar(Text),
                       Length(Text), nil); // KOL_ANSI
end;
{$ENDIF ASM_VERSION}
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
procedure TCanvas.TextRect(const Rect: TRect; X, Y: Integer; const Text: Ansistring);
var Options: Integer;
begin
  Options := ETO_CLIPPED;
  if Brush.BrushStyle <> bsClear then Options := Options or ETO_OPAQUE;
  ExtTextOut( X, Y, Options, Rect, Text, [] ); // KOL_ANSI
end;
{$ENDIF GTK}
{$ENDIF _X_}

//[procedure TCanvas.ExtTextOut]
{$IFDEF GDI}
procedure TCanvas.ExtTextOut( X, Y: Integer; Options: DWORD; const Rect: TRect; const Text: AnsiString;
          const Spacing: array of Integer );
begin
  RequiredState( HandleValid or FontValid or BrushValid or ChangingCanvas );
  windows.ExtTextOutA(FHandle, X, Y, Options, @Rect, PAnsiChar(Text), Length(Text), @Spacing[ 0 ]); // KOL_ANSI have not Ex
end;
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
procedure TCanvas.ExtTextOut( X, Y: Integer; Options: DWORD; const Rect: TRect; const Text: AnsiString;
          const Spacing: array of Integer );
var context: PPangoContext;
    layout: PPangoLayout;
    w, h: Integer;
    pixmap: PGdkPixmap;
begin
  ////RequiredState( {HandleValid or} FontValid or BrushValid or ChangingCanvas );
  w := Rect.Right - Rect.Left;
  h := Rect.Bottom - Rect.Top;
  if fOwnerControl <> nil then
  begin
    context := nil;
    layout := gtk_widget_create_pango_layout(
      PControl( fOwnerControl ).fEventboxHandle, nil );
  end
    else
  begin //todo: seems not working in such way... What to do for memory bitmap?
    context := pango_context_new;
    //layout := gtk_widget_create_pango_layout( fHandle, PChar( Text ) );
    layout := pango_layout_new( context );
  end;
  pango_layout_set_font_description( layout, Font.FontHandle );
  pango_layout_set_text( layout, PAnsiChar( Text ), Length( Text ) );
  if Options and ETO_CLIPPED = 0 then
  begin
    pango_layout_get_size( layout, @ w, @ h );
    w := w div PANGO_SCALE;
    h := h div PANGO_SCALE;
  end;
  pixmap := gdk_pixmap_new( PControl( fOwnerControl ).fEventboxHandle.window,
    w, h, -1 ); //todo: use MainForm
  if Options and ETO_OPAQUE <> 0 then
  begin
    ForeBack( Brush.Color, Brush.Color );
    gdk_draw_rectangle( GDK_DRAWABLE( pixmap ), fHandle, 1, 0, 0, w, h );
  end
    else
  begin
    gdk_draw_drawable( GDK_DRAWABLE( pixmap ), fHandle, fDrawable,
      Rect.Left, Rect.Top, 0, 0, w, h );
  end;
  ForeBack( Font.Color, Brush.Color );
  gdk_draw_layout( GDK_DRAWABLE( pixmap ), fHandle, X, Y, layout );
  g_object_unref( layout );
  gdk_draw_drawable( fDrawable, fHandle, GDK_DRAWABLE( pixmap ),
    0, 0, Rect.Left, Rect.Top, w, h );
  g_object_unref( pixmap );
  if context <> nil then
    g_object_unref( context );
end;
{$ENDIF GTK}
{$ENDIF _X_}

{$IFDEF WIN_GDI}
//[procedure TCanvas.DrawText]
procedure TCanvas.DrawText(Text: AnsiString; var Rect:TRect; Flags:DWord);
begin
  RequiredState( HandleValid or FontValid or BrushValid or ChangingCanvas );
  Windows.DrawTextA(Handle, PAnsiChar(Text), Length(Text), Rect, Flags); // KOL_ANSI
end;

//[function TCanvas.ClipRect]
function TCanvas.ClipRect: TRect;
begin
  RequiredState( HandleValid or FontValid or BrushValid or ChangingCanvas );
  GetClipBox(Handle, Result);
end;
{$ENDIF WIN_GDI}

//[function TCanvas.TextWidth]
function TCanvas.TextWidth(const Text: Ansistring): Integer;
begin
  Result := TextExtent(Text).cX;
end;

//[function TCanvas.GetBrush]
{$IFDEF GDI}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TCanvas.GetBrush: PGraphicTool;
begin
  if not assigned( fBrush ) then
  begin
    fBrush := NewBrush;
    if assigned( fOwnerControl ) then
    begin
      fBrush.fData.Color := PControl(fOwnerControl).fColor;
      if assigned( PControl(fOwnerControl).fBrush ) then
         {fBrush := }fBrush.Assign( PControl(fOwnerControl).fBrush );
      // both statements above needed
    end;
    //fBrush.OnChange := ObjectChanged;
    AssignChangeEvents;
  end;
  Result := fBrush;
end;
{$ENDIF ASM_VERSION}
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
function TCanvas.GetBrush: PGraphicTool;
begin
  if not assigned( fBrush ) then
  begin
    fBrush := NewBrush;
    if assigned( fOwnerControl ) then
    begin
      fBrush.fData.Color := PControl(fOwnerControl).fColor;
      if assigned( PControl(fOwnerControl).fBrush ) then
         {fBrush := }fBrush.Assign( PControl(fOwnerControl).fBrush );
      // both statements above needed
    end;
    //fBrush.OnChange := ObjectChanged;
    AssignChangeEvents;
  end;
  Result := fBrush;
end;
{$ENDIF GTK}
{$ENDIF _X_}

//[function TCanvas.GetFont]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TCanvas.GetFont: PGraphicTool;
begin
  if not assigned( fFont ) then
  begin
    fFont := NewFont;
    if assigned( fOwnerControl ) then
    begin
      fFont.Color := PControl(fOwnerControl).fTextColor;
      if assigned( PControl(fOwnerControl).fFont ) then
        {fFont := }fFont.Assign( PControl(fOwnerControl).fFont );
    end;
    //fFont.OnChange := ObjectChanged;
    AssignChangeEvents;
  end;
  Result := fFont;
end;
{$ENDIF ASM_VERSION}

//[function TCanvas.GetPen]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TCanvas.GetPen: PGraphicTool;
begin
  if not assigned( fPen ) then
  begin
    fPen := NewPen;
    AssignChangeEvents;
  end;
  Result := fPen;
end;
{$ENDIF ASM_VERSION}

//[function TCanvas.GetHandle]
{$IFDEF GDI}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TCanvas.GetHandle: HDC;
begin
  if assigned( fOnGetHandle ) then
  begin
    Result := fOnGetHandle( @Self );
    //fHandle := Result;
    SetHandle( Result );
  end
  else
    Result := fHandle;
end;
{$ENDIF ASM_VERSION}
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}
function TCanvas.GetHandle: HDC;
begin
  if Assigned( fOnGetHandle ) then
    fHandle := fOnGetHandle( @Self );
  Result := fHandle;
end;
{$ENDIF GTK}
{$ENDIF _X_}

//[procedure TCanvas.AssignChangeEvents]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TCanvas.AssignChangeEvents;
begin
  if assigned( fBrush ) then
     fBrush.fOnChange := ObjectChanged;
  if assigned( fPen ) then
     fPen.fOnChange := ObjectChanged;
  if assigned( fFont ) then
     fFont.fOnChange := ObjectChanged;
end;
{$ENDIF ASM_VERSION}
{$IFDEF WIN_GDI}

{$IFNDEF _FPC}
{$IFNDEF _D2}
//[procedure TCanvas.WDrawText]
procedure TCanvas.WDrawText(WText: WideString; var Rect: TRect;
  Flags: DWord);
begin
  RequiredState( HandleValid or FontValid or BrushValid or ChangingCanvas );
  Windows.DrawTextW(Handle,PWideChar(WText),Length(WText),Rect,Flags);
end;

//[procedure TCanvas.WExtTextOut]
procedure TCanvas.WExtTextOut(X, Y: Integer; Options: DWORD;
  const Rect: TRect; const WText: WideString;
  const Spacing: array of Integer);
begin
  RequiredState( HandleValid or FontValid or BrushValid or ChangingCanvas );
  Windows.ExtTextOutW(FHandle, X, Y, Options, @Rect, PWideChar(WText), Length(WText), @Spacing[ 0 ]);
end;

//[procedure TCanvas.WTextOut]
procedure TCanvas.WTextOut(X, Y: Integer; const WText: WideString);
begin
  RequiredState( HandleValid or FontValid or BrushValid or ChangingCanvas );
  Windows.TextOutW(FHandle, X, Y, PWideChar(WText), Length(WText));
  MoveTo(X + WTextWidth(WText), Y);
end;

//[procedure TCanvas.WTextRect]
procedure TCanvas.WTextRect(const Rect: TRect; X, Y: Integer;
  const WText: WideString);
var
  Options: Integer;
begin
  //Changing;
  RequiredState( HandleValid or FontValid or BrushValid or ChangingCanvas );
  Options := ETO_CLIPPED;
  if assigned( fBrush ) and (fBrush.fData.Brush.Style <> bsClear)
  or not assigned( fBrush ) then Inc(Options, ETO_OPAQUE);
  Windows.ExtTextOutW( fHandle, X, Y, Options,
                      @Rect, PWideChar(WText),
                      Length(WText), nil);
end;

//[function TCanvas.WTextExtent]
function TCanvas.WTextExtent(const WText: WideString): TSize;
var DC : HDC;
    ClearHandle : Boolean;
begin
  ClearHandle := False;
  RequiredState( HandleValid or FontValid );
  DC := fHandle;
  if DC = 0 then
  begin
     DC := CreateCompatibleDC( 0 );
     ClearHandle := True;
     SetHandle( DC );
  end;
  RequiredState( HandleValid or FontValid );
  Windows.GetTextExtentPoint32W( fHandle, PWideChar(WText), Length(WText), Result);
  if ClearHandle then
    SetHandle( 0 );
end;

//[function TCanvas.WTextHeight]
function TCanvas.WTextHeight(const WText: WideString): Integer;
begin
  Result := WTextExtent( WText ).cy;
end;

//[function TCanvas.WTextWidth]
function TCanvas.WTextWidth(const WText: WideString): Integer;
begin
  Result := WTextExtent( WText ).cx;
end;
{$ENDIF _D2}
{$ENDIF _FPC}

{$ENDIF WIN_GDI}
{-}
//[function MakeInt64]
function MakeInt64( Lo, Hi: DWORD ): I64;
begin
  Result.Lo := Lo;
  Result.Hi := Hi;
end;

//[function Int2Int64]
function Int2Int64( X: Integer ): I64;
asm
  MOV  [EDX], EAX
  MOV  ECX, EDX
  CDQ
  MOV  [ECX+4], EDX
end;

//[procedure IncInt64]
procedure IncInt64( var I64: I64; Delta: Integer );
asm
  ADD  [EAX], EDX
  ADC  dword ptr [EAX+4], 0
end;

//[procedure DecInt64]
procedure DecInt64( var I64: I64; Delta: Integer );
asm
  SUB  [EAX], EDX
  SBB  dword ptr [EDX], 0
end;

//[function Add64]
function Add64( const X, Y: I64 ): I64;
asm
  PUSH  ESI
  XCHG  ESI, EAX
  LODSD
  ADD   EAX, [EDX]
  MOV   [ECX], EAX
  LODSD
  ADC   EAX, [EDX+4]
  MOV   [ECX+4], EAX
  POP   ESI
end;

//[function Sub64]
function Sub64( const X, Y: I64 ): I64;
asm
  PUSH  ESI
  XCHG  ESI, EAX
  LODSD
  SUB   EAX, [EDX]
  MOV   [ECX], EAX
  LODSD
  SBB   EAX, [EDX+4]
  MOV   [ECX+4], EAX
  POP   ESI
end;

//[function Neg64]
function Neg64( const X: I64 ): I64;
asm
  MOV  ECX, [EAX]
  NEG  ECX
  MOV  [EDX], ECX
  MOV  ECX, 0
  SBB  ECX, [EAX+4]
  MOV  [EDX+4], ECX
end;

//[function Mul64EDX]
function Mul64EDX( const X: I64; M: Integer ): I64;
asm
  PUSH  ESI
  PUSH  EDI
  XCHG  ESI, EAX
  MOV   EDI, ECX
  MOV   ECX, EDX
  LODSD
  MUL   ECX
  STOSD
  XCHG  EDX, ECX
  LODSD
  MUL  EDX
  ADD   EAX, ECX
  STOSD
  POP   EDI
  POP   ESI
end;

//[FUNCTION Mul64i]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function Mul64i( const X: I64; Mul: Integer ): I64;
var Minus: Boolean;
begin
  Minus := FALSE;
  if Mul < 0 then
  begin
    Minus := TRUE;
    Mul := -Mul;
  end;
  Result := Mul64EDX( X, Mul );
  if Minus then
    Result := Neg64( Result );
end;
{$ENDIF ASM_VERSION}
//[END Mul64i]

//[function Div64EDX]
function Div64EDX( const X: I64; D: Integer ): I64;
asm
  PUSH  ESI
  PUSH  EDI
  XCHG  ESI, EAX
  MOV   EDI, ECX
  MOV   ECX, EDX
  MOV   EAX, [ESI+4]
  CDQ
  DIV  ECX
  MOV   [EDI+4], EAX
  LODSD
  DIV  ECX
  STOSD
  POP   EDI
  POP   ESI
end;

//[FUNCTION Div64i]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function Div64i( const X: I64; D: Integer ): I64;
var Minus: Boolean;
begin
  Minus := FALSE;
  if D < 0 then
  begin
    D := -D;
    Minus := TRUE;
  end;
  Result := X;
  if Sgn64( Result ) < 0 then
  begin
    Result := Neg64( Result );
    Minus := not Minus;
  end;
  Result := Div64EDX( Result, D );
  if Minus then
    Result := Neg64( Result );
end;
{$ENDIF ASM_VERSION}
//[END Div64i]

//[function Mod64i]
function Mod64i( const X: I64; D: Integer ): Integer;
begin
  Result := Sub64( X, Mul64i( Div64i( X, D ), D ) ).Lo;
end;

//[function Sgn64]
function Sgn64( const X: I64 ): Integer;
asm
  XOR  EDX, EDX
  CMP  [EAX+4], EDX
  XCHG EAX, EDX
  JG   @@ret_1
  JL   @@ret_neg
  CMP  [EDX], EAX
  JZ   @@exit
@@ret_1:
  INC  EAX
  RET
@@ret_neg:
  DEC  EAX
@@exit:
end;

//[function Cmp64]
function Cmp64( const X, Y: I64 ): Integer;
begin
  Result := Sgn64( Sub64( X, Y ) );
end;

//[function Int64_2Str]
function Int64_2Str( X: I64 ): AnsiString;
var M: Boolean;
    Y: Integer;
    Buf: array[ 0..31 ] of AnsiChar;
    I: Integer;
begin
  M := FALSE;
  case Sgn64( X ) of
  -1: begin M := TRUE; X := Neg64( X ); end;
  0:  begin Result := '0'; Exit; end;
  end;
  I := 31;
  Buf[ 31 ] := #0;
  while Sgn64( X ) > 0 do
  begin
    Dec( I );
    Y := Mod64i( X, 10 );
    Buf[ I ] := AnsiChar( Y + Integer( '0' ) );
    X := Div64i( X, 10 );
  end;
  if M then
  begin
    Dec( I );
    Buf[ I ] := '-';
  end;
  Result := PAnsiChar( @Buf[ I ] );
end;

function Int64_2Hex( X: I64; MinDigits: Integer ): AnsiString;
begin
  if (MinDigits <= 8) and (X.Hi <> 0) then
    Result := Int2Hex( X.Hi, 1 ) + Int2Hex( X.Lo, 8 )
  else if X.Hi <> 0 then
    Result := Int2Hex( X.Hi, MinDigits - 8 ) + Int2Hex( X.Lo, 8 )
  else
    Result := Int2Hex( X.Lo, MinDigits );
end;

//[function Str2Int64]
function Str2Int64( const S: AnsiString ): I64;
var I: Integer;
    M: Boolean;
begin
  Result.Lo := 0;
  Result.Hi := 0;
  I := 1;
  if S = '' then Exit;
  M := FALSE;
  if S[ 1 ] = '-' then
  begin
    M := TRUE;
    Inc( I );
  end
    else
  if S[ 1 ] = '+' then
    Inc( I );
  while I <= Length( S ) do
  begin
    if not( S[ I ] in [ '0'..'9' ] ) then
      break;
    Result := Mul64i( Result, 10 );
    IncInt64( Result, Integer( S[ I ] ) - Integer( '0' ) );
    Inc( I );
  end;
  if M then
    Result := Neg64( Result );
end;

//[function Int64_2Double]
function Int64_2Double( const X: I64 ): Double;
asm
  FILD qword ptr [EAX]
  FSTP @Result
end;

//[function Double2Int64]
function Double2Int64( D: Double ): I64;
asm
  FLD   D
  FISTP qword ptr [EAX]
end;

{+}
function IsNan(const AValue: Double): Boolean;
{$IFDEF _D2orD3}
type PI64 = ^I64;
{$ENDIF}
begin
  {-}
  Result := (PI64(@AValue).Hi and $7FF00000 = $7FF00000) and
            ((PI64(@AValue).Hi and $000FFFFF <> 0) or (PI64(@AValue).Lo <> 0));
  {+}{++}(*Result := AValue = NAN;*){--}
end;

function IsInfinity(const AValue: Double): Boolean;
{$IFDEF _D2orD3}
type PI64 = ^I64;
{$ENDIF}
begin
  {-}
  Result := (PI64(@AValue).Hi and $7FF00000 = $7FF00000) and
            (PI64(@AValue).Hi and $000FFFFF = $00000000);
  {+}{++}(*Result := AValue = Infinite;*){--}
end;

//[function IntPower]
function IntPower(Base: Extended; Exponent: Integer): Extended;
{$IFDEF F_P}
begin
  {if Exponent = 0 then
  begin
    Result := 1.0;
    Exit;
  end;
  if Exponent < 0 then
  begin
    Exponent := -Exponent;
    Base := 1.0 / Base;
  end;
  Result := Base;
  REPEAT
    Result := Result * Base;
    Dec( Exponent );
  UNTIL Exponent <= 0;}
  Result := 1.0;
  if Exponent = 0 then exit;
  if Exponent < 0 then begin
    Exponent := -Exponent;
    Base := 1.0 / Base;
  end;
  REPEAT
    Result := Result * Base;
    Dec( Exponent );
  UNTIL Exponent=0;
end;
{$ELSE DELPHI}
// This version of code by Galkov:
// Changes in comparison to Delphi standard:
// no Overflow exception if Exponent is very big negative value
// (just 0 in result in such case).
asm
        fld1             { Result := 1 }
        test    eax,eax  // check Exponent for 0, return 0 ** 0 = 1
        jz      @@3      // (though Mathematics says that this is not so...)
        fld     Base
        jg      @@2
        fdivr   ST,ST(1) { Base := 1 / Base }
        neg     eax
        jmp     @@2
@@1:    fmul    ST,ST    { X := Base * Base }
@@2:    shr     eax,1
        jnc     @@1
        fmul    ST(1),ST { Result := Result * X }
        jnz     @@1
        fstp    st       { pop X from FPU stack }
@@3:    fwait
end;
{$ENDIF F_P/DELPHI}

function NextPowerOf2( n: DWORD ): DWORD;
begin
    Result := 1;
    while (Result < n) and (Result <> 0) do
        Result := Result shl 1;
end;

//[function Str2Double]
function Str2Double( const S: AnsiString ): Double;
var I: Integer;
    M, Pt: Boolean;
    D: Double;
    Ex: Integer;
begin
  Result := 0.0;
  if S = '' then Exit;
  M := FALSE;
  I := 1;
  if S[ 1 ] = '-' then
  begin
    M := TRUE;
    Inc( I );
  end;
  Pt := FALSE;
  D := 1.0;
  while I <= Length( S ) do
  begin
    case S[ I ] of
    '.': if not Pt then Pt := TRUE else break;
    '0'..'9': if not Pt then
                 Result := Result * 10.0 + Integer( S[ I ] ) - Integer( '0' )
              else
              begin
                D := D * 0.1;
                Result := Result + (Integer( S[ I ] ) - Integer( '0' )) * D;
              end;
    'e', 'E': begin
                Ex := Str2Int( CopyEnd( S, I + 1 ) );
                Result := Result * IntPower( 10.0, Ex );
                break;
              end;
    end;
    Inc( I );
  end;
  if M then
    Result := -Result;
end;

function Str2Extended( const S: AnsiString ): Extended;
var I: Integer;
    M, Pt: Boolean;
    D: Extended;
    Ex: Integer;
begin
  Result := 0.0;
  if S = '' then Exit;
  M := FALSE;
  I := 1;
  if S[ 1 ] = '-' then
  begin
    M := TRUE;
    Inc( I );
  end;
  Pt := FALSE;
  D := 1.0;
  while I <= Length( S ) do
  begin
    case S[ I ] of
    '.': if not Pt then Pt := TRUE else break;
    '0'..'9': if not Pt then
                 Result := Result * 10.0 + Integer( S[ I ] ) - Integer( '0' )
              else
              begin
                D := D * 0.1;
                Result := Result + (Integer( S[ I ] ) - Integer( '0' )) * D;
              end;
    'e', 'E': begin
                Ex := Str2Int( CopyEnd( S, I + 1 ) );
                Result := Result * IntPower( 10.0, Ex );
                break;
              end;
    end;
    Inc( I );
  end;
  if M then
    Result := -Result;
end;

//[function TruncD]
function TruncD( D: Double ): Double;
{-}
asm
  FLD    D
  PUSH   ECX
  FNSTCW [ESP]
  POP    ECX
  PUSH   ECX
  OR     byte ptr [ESP+1], $0C
  FLDCW  [ESP]
  PUSH   ECX
  FRNDINT
  FSTP   @Result
  FLDCW  [ESP]
  POP    ECX
  POP    ECX
end;
{+}{++}(*
begin
  Result := Trunc( D );
end;
*){--}

function IfThenElseBool( t, e: Boolean; Cond: Boolean ): Boolean;
begin
  if cond then Result := t else Result := e;
end;
function IfThenElseInt( t, e: Integer; Cond: Boolean ): Integer;
begin
  if cond then Result := t else Result := e;
end;
function IfThenElseStr( const t, e: AnsiString; Cond: Boolean ): AnsiString;
begin
  if cond then Result := t else Result := e;
end;
{$IFDEF _D5orHigher}
function IfThenElse( t, e: Boolean; Cond: Boolean ): Boolean; overload;
begin
  if cond then Result := t else Result := e;
end;
function IfThenElse( t, e: Integer; Cond: Boolean ): Integer; overload;
begin
  if cond then Result := t else Result := e;
end;
function IfThenElse( t, e: AnsiString; Cond: Boolean ): AnsiString; overload;
begin
  if cond then Result := t else Result := e;
end;
function IfThenElse( t, e: Double; Cond: Boolean ): Double; overload;
begin
  if cond then Result := t else Result := e;
end;
{$ENDIF}

// Precision 15
//[function Extended2Str]
function Extended2Str( E: Extended ): AnsiString;
    function UnpackFromBuf( const Buf: array of Byte; N: Integer ): AnsiString;
    var I, J, K, L: Integer;
    begin
      SetLength( Result, 16 );
      J := 1;
      for I := 7 downto 0 do
      begin
        K := Buf[ I ] shr 4;
        Result[ J ] := AnsiChar( Ord('0') + K );
        Inc( J );
        K := Buf[ I ] and $F;
        Result[ J ] := AnsiChar( Ord('0') + K );
        Inc( J );
      end;

      Assert( Result[ 1 ] = '0', 'error!' );
      Delete( Result, 1, 1 );

      if N <= 0 then
      begin
        while N < 0 do
        begin
          Result := '0' + Result;
          Inc( N );
        end;
        Result := '0.' + Result;
      end
        else
      if N < Length( Result ) then
      begin
        Result := Copy( Result, 1, N ) + '.' + CopyEnd( Result, N + 1 );
      end
        else
      begin
        while N > Length( Result ) do
        begin
          Result := Result + '0';
        end;
        Exit;
      end;

      L := Length( Result );
      while L > 1 do
      begin
        if not (Result[ L ] in ['0','.']) then break;
        Dec( L );
        if Result[ L + 1 ] = '.' then break;
      end;
      if L < Length( Result ) then Delete( Result, L + 1, MaxInt );

    end;

var
  S: Boolean;
var F: Extended;
    N: Integer;
    Buf1: array[ 0..9 ] of Byte;
    I10: Integer;
begin
  Result := '0';
  if E = 0 then Exit;
  S := E < 0;
  if S then E := -E;

  N := 15;
  F := 5E12;
  I10 := 10;
  while E < F do
  begin
    Dec( N );
    E := E * I10;
  end;
  if N = 15 then
  while E >= 1E13 do
  begin
    Inc( N );
    E := E / I10;
  end;

  while TRUE do
  begin
    asm
      FLD    [E]
      FBSTP  [Buf1]
    end;
    if Buf1[ 7 ] <> 0 then break;
    E := E * I10;
    Dec( N );
  end;

  Result := UnpackFromBuf( Buf1, N );

  if S then Result := '-' + Result;
end;

function Extended2StrDigits( D: Double; n: Integer ): AnsiString;
var i, m: Integer;
label start;
begin
start:
    Result := Extended2Str( D );
    i := pos( '.', Result );
    if  n <= 0 then
    begin
        if  i <= 0 then Exit;
        delete( Result, i, MaxInt );
    end
      else
    begin
        if  i <= 0 then
        begin
            i := Length( Result ) + 1;
            Result := Result + '.';
        end;
        if  Length( Result ) - i < n then
            Result := Result + StrRepeat( '0', n + i - Length( Result ) )
        else
        begin
            m := i + n;
            if  Length( Result ) <= m then Exit;
            if  (Result[m+1] > '5')
            or  (Length( Result ) > m+1)
            and (Result[m+2] > '0') then
            begin
                //D := D + 1/IntPower( 10, n-1 );
                //goto start;
                n := m;
                inc( Result[n] );
                while Result[n] > '9' do
                begin
                      Result[n] := '0';
                      dec( n );
                      if  n = 0 then
                      begin
                          Result := '1' + Result;
                          break;
                      end;
                      if  Result[n] = '.' then dec(n);
                      inc( Result[n] );
                end;
            end;
            delete( Result, m+1, MaxInt );
        end;
    end;
end;

//[function Double2Str]
function Double2Str( D: Double ): AnsiString;
begin
  Result := Extended2Str( D );
end;

//[function Double2StrEx]
function Double2StrEx( D: Double ): AnsiString;
var E, E1, E2: Double;
    S: AnsiString;
begin
  Result := Double2Str( D );
  E := Str2Double( Result );
  E1 := E - D;
  if E1 < 0.0 then E1 := -E1;
  if E1 < 1e-307 then Exit;
  while TRUE do
  begin
    E := D - (E - D) * 0.3;
    S := Double2Str( E );
    if S = Result then break;
    E := Str2Double( S );
    E2 := E - D;
    if E2 < 0.0 then E2 := -E2;
    if E2 > E1 * 0.75 then break;
    Result := S;
    if E2 < E1 * 0.1 then break;
  end;
end;

//[function GetBits]
function GetBits( N: DWORD; first, last: Byte ): DWord;
{$IFDEF F_P}
begin
  Result := 0;
  if last > 31 then last := 31;
  if first > last then Exit;
  Result := (N and not ($FFFFFFFF shl last)) shr first;
end;
{$ELSE DELPHI}
asm
   XCHG EAX, EDX  // (1) EDX=N, AL=first
   {$IFDEF PARANOIA} DB $3C, 31 {$ELSE} CMP AL, 31 {$ENDIF} // first(AL) > 31 ?
   JBE  @@1       // (2)  ,  Result := 0;
@@0:
   XOR  EAX, EAX  // (2)
   RET            // (1)
@@1:

   XCHG EAX, ECX  // (1) AL = last CL = first
   SHR  EDX, CL   // (2) EDX = N shr first
   SUB  AL,  CL	  // (2) AL = last - first
   JL @@0         // (2)  last < first  Result := 0;

   {$IFDEF PARANOIA} DB $3C, 32 {$ELSE} CMP AL, 32 {$ENDIF} // (2) last - first >= 32 ?
   XCHG ECX, EAX  // (1) CL = last - first
   XCHG EAX, EDX  // (1) EAX = N shr first
   JAE  @@exit    // (2)  last - first > 31,  Result := EAX;
   SBB  EDX, EDX  // (2) EDX = -1
   DEC  EDX       // (1) EDX = 1111...10 = -2
   SHL  EDX, CL   // (2) EDX = 111...100..0 ( n(0)=last-first+1)
   NOT  EDX       // (2) EDX =  000..0111...1 ( n(1)=last-first+1)
   AND  EAX, EDX  // (2)
@@exit:
   // EAX = , (1    RET)
end;
{$ENDIF F_P/DELPHI}

//[function GetBitsL]
function GetBitsL( N: DWORD; from, len: Byte ): DWord;
{$IFDEF F_P}
begin
  Result := GetBits( N, from, from + len - 1 );
end;
{$ELSE DELPHI}
asm
   ADD  CL, DL
   DEC  CL
   JMP  GetBits
end;
{$ENDIF F_P/DELPHI}

//[FUNCTION MulDiv]
{$IFNDEF FPC}
function MulDiv( A, B, C: Integer ): Integer;
asm
  IMUL EDX
  IDIV ECX
end;
{$ENDIF}
//[END MulDiv]

//[FUNCTION Int2Hex]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal (mixed)
function Int2Hex( Value : DWord; Digits : Integer ) : AnsiString;
var Buf: array[ 0..8 ] of AnsiChar;
    Dest : PAnsiChar;

    function HexDigit( B : Byte ) : AnsiChar;
    {$IFDEF F_P}
    const
      HexDigitChr: array[ 0..15 ] of AnsiChar = ( '0','1','2','3','4','5','6','7',
                                                  '8','9','A','B','C','D','E','F' ); // TODO: FP may havn't UnicodeString
    begin
      Result := HexDigitChr[ B and $F ];
    end;
    {$ELSE DELPHI}
    asm
             {$IFDEF PARANOIA} DB $3C,9 {$ELSE} CMP AL,9 {$ENDIF}
             JA   @@1
             {$IFDEF PARANOIA} DB $04, $30-$41+$0A {$ELSE} ADD AL,30h-41h+0Ah {$ENDIF}
    @@1:
             {$IFDEF PARANOIA} DB $04, $41-$0A {$ELSE} ADD  AL,41h-0Ah {$ENDIF}
    end;
    {$ENDIF F_P/DELPHI}
begin
  Dest := @Buf[ 8 ];
  Dest^ := #0;
  repeat
    Dec( Dest );
    Dest^ := '0';
    if Value <> 0 then
    begin
      Dest^ := HexDigit( Value and $F );
      Value := Value shr 4;
    end;
    Dec( Digits );
  until (Value = 0) and (Digits <= 0);
  Result := Dest;
end;
{$ENDIF ASM_VERSION}
//[END Int2Hex]

//[FUNCTION Hex2Int]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function Hex2Int( const Value : AnsiString) : Integer;
var I : Integer;
begin
  Result := 0;
  I := 1;
  if Value = '' then Exit;
  if Value[ 1 ] = '$' then Inc( I );
  while I <= Length( Value ) do
  begin
    if Value[ I ] in [ '0'..'9' ] then
       Result := (Result shl 4) or (Ord(Value[I]) - Ord('0'))
    else
    if Value[ I ] in [ 'A'..'F' ] then
       Result := (Result shl 4) or (Ord(Value[I]) - Ord('A') + 10)
    else
    if Value[ I ] in [ 'a'..'f' ] then
       Result := (Result shl 4) or (Ord(Value[I]) - Ord('a') + 10)
    else
      break;
    Inc( I );
  end;
end;
{$ENDIF ASM_VERSION}
//[END Hex2Int]

//[FUNCTION Octal2Int]
function Octal2Int( const Value: AnsiString ) : Integer;
var I: Integer;
begin
  Result := 0;
  for I := 1 to Length( Value ) do
  begin
    if Value[ I ] in [ '0'..'7' ] then
      Result := Result * 8 + Ord( Value[ I ] ) - Ord( '0' )
    else break;
  end;
end;
//[END Octal2Int]

//[FUNCTION Binary2Int]
function Binary2Int( const Value: AnsiString ) : Integer;
var I: Integer;
begin
  Result := 0;
  for I := 1 to Length( Value ) do
  begin
    if Value[ I ] in [ '0'..'1' ] then
      Result := Result * 2 + Ord( Value[ I ] ) - Ord( '0' )
    else break;
  end;
end;
//[END Binary2Int]

function ToRadix( number: Radix_Int; radix: Integer; min_digits: Integer ): KOLString;
var Buf: array[ 0..64 ] of KOLChar;
    p: PKOLChar;
    n: Integer;
    {$IFDEF _D5orHigher}
    numd: Extended;
    {$ENDIF}
begin
  Assert( (radix >= 2) and (radix <= 36), 'Radix base must be between 2 and 36' );
  Assert( min_digits <= 64, 'Maximum possible digits number is 64' );
    p := @ Buf[ 64 ];
    p^ := #0;
    while (number <> 0) do
    begin
        dec( p );
        {$IFDEF _D5orHigher}
        if number < 0 then
        begin
            numd := 1.0 * I64( number ).Hi * $10000 * $10000 + I64( number ).Lo;
            number := Round( numd / radix );
            n := Round( numd - 1.0 * number * radix );
            if n < 0 then
            begin
              n := radix + n;
              dec( number );
            end;
        end
          else
        {$ENDIF}
        begin
            n := number mod radix;
            number := number div radix;
        end;
        if n <= 9 then p^ := KOLChar( n + Ord( '0' ) )
        else p^ := KOLChar( n - 10 + Ord( 'A' ) );
        dec( min_digits );
    end;
    while (min_digits > 0) do
    begin
        dec( p );
        p^ := '0';
        dec( min_digits );
    end;
    Result := p;
end;

function FromRadixStr( var Rslt: Radix_int; s: PKOLChar; radix: Integer ): PKOLChar;
var n: Integer;
begin
  Assert( (radix >= 2) and (radix <= 36), 'Radix base must be between 2 and 36' );
    Rslt := 0;
    while s^ <> #0 do
    begin
        CASE s^ OF
        '0'..'9': n := Ord( s^ ) - Ord( '0' );
        'a'..'z': n := Ord( s^ ) - Ord( 'a' ) + 10;
        'A'..'Z': n := Ord( s^ ) - Ord( 'A' ) + 10;
        else n := 100;
        END;
        if n >= radix then break;
        Rslt := Rslt * radix + n;
        inc( s );
    end;
    Result := s;
end;

function FromRadix( const s: AnsiString; radix: Integer ): Radix_int;
begin
    Result := 0;
    if s = '' then Exit;
    FromRadixStr( Result, @ s[ 1 ], radix );
end;

function InsertSeparators( const s: KOLString; chars_between: Integer; Separator: KOLChar ): KOLString;
var L, from_L, n: Integer;
begin
  if (s = '') or (chars_between <= 0) then
  begin
      Result := s;
      Exit;
  end;
    From_L := Length( s );
    L := From_L + From_L div chars_between;
    SetLength( Result, L );
    while L >= 1 do
    begin
        for n := 1 to chars_between do
        begin
            Result[ L ] := s[ from_L ];
            dec( L );
            dec( from_L );
            if L < 1 then Exit;
        end;
        Result[ L ] := Separator;
        dec( L );
    end;
end;

//[FUNCTION cHex2Int]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION}
function cHex2Int( const Value : AnsiString) : Integer;
begin
  if StrEq( Copy( Value, 1, 2 ), '0x' ) then
    Result := Hex2Int( CopyEnd( Value, 3 ) )
  else Result := Hex2Int( Value );
end;
{$ENDIF ASM_VERSION}
//[END cHex2Int]

//[FUNCTION Int2Str]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function Int2Str( Value : Integer ) : AnsiString;
var Buf : Array[ 0..15 ] of AnsiChar;
    Dst : PAnsiChar;
    Minus : Boolean;
    D: DWORD;
begin
  Dst := @Buf[ 15 ];
  Dst^ := #0;
  Minus := False;
  if Value < 0 then
  begin
    Value := -Value;
    Minus := True;
  end;
  D := Value;
  repeat
    Dec( Dst );
    Dst^ := AnsiChar( (D mod 10) + Byte( '0' ) );
    D := D div 10;
  until D = 0;
  if Minus then
  begin
    Dec( Dst );
    Dst^ := '-';
  end;
  Result := Dst;
end;
{$ENDIF ASM_VERSION}
//[END Int2Str]

procedure Int2PChar( s: PAnsiChar; Value: Integer );
var Buf : array[ 0..15 ] of AnsiChar;
    Dst : PAnsiChar;
    Minus : Boolean;
    D: DWORD;
begin
  Dst := @Buf[ 15 ];
  Dst^ := #0;
  Minus := False;
  if Value < 0 then
  begin
    Value := -Value;
    Minus := True;
  end;
  D := Value;
  repeat
    Dec( Dst );
    Dst^ := AnsiChar( (D mod 10) + Byte( '0' ) );
    D := D div 10;
  until D = 0;
  if Minus then
  begin
    Dec( Dst );
    Dst^ := '-';
  end;
  StrCopy( s, Dst );
end;

//[function UInt2Str]
function UInt2Str( Value: DWORD ): AnsiString;
var Buf : Array[ 0..15 ] of AnsiChar;
    Dst : PAnsiChar;
    D: DWORD;
begin
  Dst := @Buf[ 15 ];
  Dst^ := #0;
  D := Value;
  repeat
    Dec( Dst );
    Dst^ := AnsiChar( (D mod 10) + Byte( '0' ) );
    D := D div 10;
  until D = 0;
  Result := Dst;
end;

//[function Int2StrEx]
function Int2StrEx( Value, MinWidth: Integer ): AnsiString;
begin
  Result := Int2Str( Value );
  while Length( Result ) < MinWidth do
    Result := ' ' + Result;
end;

//[function Int2Rome]
function Int2Rome( Value: Integer ): AnsiString;
const RomeDigs = AnsiString('IVXLCDMT');
  function RomeNum( N, FromIdx: Integer ): AnsiString;
  begin
    CASE N OF
    1, 2, 3:    Result := StrRepeat( RomeDigs[ FromIdx ], N );
    4:          Result := RomeDigs[ FromIdx ] + RomeDigs[ FromIdx + 1 ];
    5, 6, 7, 8: Result := RomeDigs[ FromIdx + 1 ] + StrRepeat( RomeDigs[ FromIdx ],
                       N - 5 );
    9:          Result := RomeDigs[ FromIdx ] + RomeDigs[ FromIdx + 2 ]
    else Result := '';
    END;
  end;
var I, J: Integer;
begin
  Result := '';
  if Value < 1 then Exit;
  if Value > 8999 then Exit;
  // maximum possible is TMMMCMXCIX, i.e. 8999
  J := 1;
  for I := 1 to 3 do
  begin
    Result := RomeNum( Value mod 10, J ) + Result;
    Value := Value div 10;
    if Value = 0 then Exit;
    Inc( J, 2 );
  end;
end;

//[FUNCTION Int2Ths]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function Int2Ths( I : Integer ) : AnsiString;
var S : AnsiString;
begin
  S := Int2Str( I );
  Result := '';
  while S <> '' do
  begin
    if Result <> '' then
       Result := ThsSeparator + Result;
    Result := CopyTail( S, 3 ) + Result;
    S := Copy( S, 1, Length( S ) - 3 );
  end;
  if Copy( Result, 1, 2 ) = '-' + ThsSeparator then
     Result := '-' + CopyEnd( Result, 3 );
end;
{$ENDIF ASM_VERSION}
//[END Int2Ths]

//[FUNCTION Int2Digs]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function Int2Digs( Value, Digits : Integer ) : AnsiString;
var M : AnsiString;
begin
  Result := Int2Str( Value );
  M := '';
  if Value < 0 then
  begin
    M := '-';
    Result := CopyEnd( Result, 2 );
  end;
  if Digits >= 0 then
    while Length( M + Result ) < Digits do
          Result := '0' + Result
  else
    while Length( Result ) < -Digits do
          Result := '0' + Result;
  Result := M + Result;
end;
{$ENDIF ASM_VERSION}
//[END Int2Digs]

//[FUNCTION Num2Bytes]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function Num2Bytes( Value : Double ) : AnsiString;
const Suffix = 'KMGT';
var V, I : Integer;
begin
  Result := '';
  I := 0;
  while (Value >= 1024) and (I < 4) do
  begin
    Inc( I );
    Value := Value / 1024.0;
  end;
  Result := Int2Str( Trunc( Value ) );
  V := Trunc( (Value - Trunc( Value )) * 100 );
  if V <> 0 then
  begin
    if (V mod 10) = 0 then
       V := V div 10;
    Result := Result + ',' + Int2Str( V );
  end;
  if I > 0 then
     Result := Result + Suffix[ I ];
end;
{$ENDIF ASM_VERSION}
//[END Num2Bytes]

//[FUNCTION S2Int]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function S2Int( S: PAnsiChar ): Integer;
var M : Integer;
begin
   Result := 0;
   if S = '' then Exit;
   M := 1;
   if S^ = '-' then
   begin
      M := -1;
      Inc( S );
   end
     else
   if S^ = '+' then
     Inc( S );
   while S^ in [ '0'..'9' ] do
   begin
      Result := Result * 10 + Integer( S^ ) - Integer( '0' );
      Inc( S );
   end;
   if M < 0 then
      Result := -Result;
end;
{$ENDIF ASM_VERSION}
//[END S2Int]

//[FUNCTION Str2Int]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function Str2Int(const Value : AnsiString) : Integer;
begin
  Result := S2Int( PAnsiChar( Value ) );
end;
{$ENDIF ASM_VERSION}
//[END Str2Int]

//[function StrCopy]
function StrCopy( Dest, Source: PAnsiChar ): PAnsiChar; assembler;
asm
  {$IFDEF F_P}
        MOV     EAX, [Dest]
        MOV     EDX, [Source]
  {$ENDIF F_P}
        PUSH    EDI
        PUSH    ESI
        MOV     ESI,EAX
        MOV     EDI,EDX
        OR      ECX, -1
        XOR     AL,AL
        REPNE   SCASB
        NOT     ECX
        MOV     EDI,ESI
        MOV     ESI,EDX
        MOV     EDX,ECX
        MOV     EAX,EDI
        SHR     ECX,2
        REP     MOVSD
        MOV     ECX,EDX
        AND     ECX,3
        REP     MOVSB
        POP     ESI
        POP     EDI
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};

function StrCat( Dest, Source: PAnsiChar ): PAnsiChar;
begin
  StrCopy( StrScan( Dest, #0 ), Source );
  Result := Dest;
end;

//[function StrScan]
function StrScan(Str: PAnsiChar; Chr: AnsiChar): PAnsiChar; assembler;
asm
  {$IFDEF F_P}
  MOV   EAX, [Str]
  MOVZX EDX, [Chr]
  {$ENDIF}
        PUSH    EDI
        PUSH    EAX
        MOV     EDI,Str
        OR      ECX, -1
        XOR     AL,AL
        REPNE   SCASB
        NOT     ECX
        POP     EDI
        XCHG    EAX, EDX
        REPNE   SCASB

        XCHG    EAX, EDI
        POP     EDI

        JE      @@1
        XOR     EAX, EAX
        RET

@@1:    DEC     EAX
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};

//[function StrRScan]
function StrRScan(const Str: PAnsiChar; Chr: AnsiChar): PAnsiChar; assembler;
asm
  {$IFDEF F_P}
        MOV     EAX, [Str]
        MOVZX   EDX, [Chr]
  {$ENDIF F_P}
        PUSH    EDI
        MOV     EDI,Str
        MOV     ECX,0FFFFFFFFH
        XOR     AL,AL
        REPNE   SCASB
        NOT     ECX
        STD
        DEC     EDI
        MOV     AL,Chr
        REPNE   SCASB
        MOV     EAX,0
        JNE     @@1
        MOV     EAX,EDI
        INC     EAX
@@1:    CLD
        POP     EDI
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};

//[function StrScanLen]
function StrScanLen(Str: PAnsiChar; Chr: AnsiChar; Len: Integer): PAnsiChar; assembler;
asm
  {$IFDEF F_P}
        MOV     EAX, [Str]
        MOVZX   EDX, [Chr]
        MOV     ECX, [Len]
  {$ENDIF F_P}
        PUSH    EDI
        XCHG    EDI, EAX
        XCHG    EAX, EDX
        REPNE   SCASB
        XCHG    EAX, EDI
        POP     EDI
        { -> EAX => to next character after found or to the end of Str,
             ZF = 0 if character found. }
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};

//[FUNCTION TrimLeft]
{$IFDEF ASM_UNICODE}
function TrimLeft(const S: Ansistring): Ansistring;
asm
        XCHG     EAX, EDX
        CALL     EDX2PChar
        DEC      EDX
@@1:    INC      EDX
        MOVZX    ECX, byte ptr [EDX]
        JECXZ    @@fin
        CMP      CL, ' '
        JBE      @@1
@@fin:
        {$IFDEF _D2009orHigher}
        XOR      ECX, ECX
        {$ENDIF}
        CALL     System.@LStrFromPChar
end;
{$ELSE ASM_VERSION} //Pascal
function TrimLeft(const S: KOLString): KOLString;
var
  I, L: Integer;
begin
  L := Length(S);
  I := 1;
  while (I <= L) and (S[I] <= ' ') do Inc(I);
  Result := Copy(S, I, Maxint);
end;
{$ENDIF ASM_VERSION}
//[END TrimLeft]

//[FUNCTION TrimRight]
{$IFDEF ASM_UNICODE}
function TrimRight(const S: Ansistring): Ansistring;
asm
        PUSH     EDX
        PUSH     EAX

        PUSH     EAX
        CALL     System.@LStrLen
        XCHG     EAX, [ESP]
        CALL     EAX2PChar
        POP      ECX
        INC      ECX
@@1:    DEC      ECX
        MOV      DL, [EAX+ECX]
        JL       @@fin
        CMP      DL, ' '
        JBE      @@1
@@fin:
        INC      ECX
        POP      EAX
        XOR      EDX, EDX
        INC      EDX
        CALL     System.@LStrCopy
end;
{$ELSE ASM_VERSION} //Pascal
function TrimRight(const S: KOLString): KOLString;
var
  I: Integer;
begin
  I := Length(S);
  while (I > 0) and (S[I] <= ' ') do Dec(I);
  Result := Copy(S, 1, I);
end;
{$ENDIF ASM_VERSION}
//[END TrimRight]

//[FUNCTION Trim]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function Trim( const S : KOLString): KOLString;
begin
   Result := TrimLeft( TrimRight( S ) );
end;
{$ENDIF ASM_VERSION}
//[END Trim]

//[function RemoveSpaces]
function RemoveSpaces( const S: KOLString ): KOLString;
var I: Integer;
begin
  Result := S;
  for I := Length( S ) downto 1 do
    if S[ I ] <= ' ' then Delete( Result, I, 1 );
end;

//[procedure Str2LowerCase]
procedure Str2LowerCase( S: PAnsiChar );
asm
  {$IFDEF F_P}
        MOV      EAX, [S]
  {$ENDIF}
        XOR      ECX, ECX
@@1:
        MOV      CL, byte ptr [EAX]
        JECXZ    @@exit
        SUB      CL, 'A'
        CMP      CL, 'Z'-'A'
        JA       @@2
        ADD      byte ptr [EAX], 32
@@2:    INC      EAX
        JMP      @@1
@@exit:
end {$IFDEF F_P} [ 'EAX', 'ECX' ] {$ENDIF};

//[FUNCTION LowerCase]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function LowerCase(const S: Ansistring): Ansistring;
var I : Integer;
begin
  Result := S;
  for I := 1 to Length( S ) do
    if Result[ I ] in [ 'A'..'Z' ] then
       Inc( Result[ I ], 32 );
end;
{$ENDIF ASM_VERSION}
//[END LowerCase]

//[FUNCTION UpperCase]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function UpperCase(const S: Ansistring): Ansistring;
var I : Integer;
begin
  Result := S;
  for I := 1 to Length( S ) do
    if Result[ I ] in [ 'a'..'z' ] then
       Dec( Result[ I ], 32 );
end;
{$ENDIF ASM_VERSION}
//[END UpperCase]

{$IFDEF F_P}
//[function DummyStrFun]
function DummyStrFun( const S: AnsiString ): AnsiString;
begin
  Result := S;
end;
{$ENDIF F_P}

//[FUNCTION CopyEnd]
{$IFDEF ASM_UNICODE}
function CopyEnd( const S : AnsiString; Idx : Integer ) : AnsiString;
asm
        PUSH     ECX
        PUSH     EAX
        PUSH     EDX

        CALL     System.@LStrLen

        POP      EDX
        TEST     EDX, EDX
        JG       @@1
        XOR      EDX, EDX
        INC      EDX
@@1:
        SUB      EAX, EDX
        MOV      ECX, EAX

        POP      EAX
        JGE      @@ret_end

        POP      EAX
        JL       System.@LStrClr

@@ret_end:
        INC      ECX
        CALL     System.@LStrCopy
end;
{$ELSE ASM_VERSION} //Pascal
function CopyEnd( const S : KOLString; Idx : Integer ) : KOLString;
begin
  Result := Copy( S, Idx, MaxInt );
end;
{$ENDIF ASM_VERSION}
//[END CopyEnd]

//[FUNCTION CopyTail]
{$IFDEF ASM_UNICODE}
function CopyTail( const S : AnsiString; Len : Integer ) : AnsiString;
asm
        PUSH     ECX
        PUSH     EAX
          PUSH     EDX
            CALL     System.@LStrLen
          POP      ECX
          CMP      ECX, EAX
          {$IFDEF USE_CMOV}
          CMOVG    ECX, EAX
          {$ELSE}
          JLE      @@1
          MOV      ECX, EAX
@@1:      {$ENDIF}

        MOV      EDX, EAX
        SUB      EDX, ECX
        INC      EDX
        POP      EAX
        CALL     System.@LStrCopy
end;
{$ELSE ASM_VERSION} //Pascal
function CopyTail( const S : KOLString; Len : Integer ) : KOLString;
var L : Integer;
begin
  L := Length( S );
  if L < Len then
     Len := L;
  Result := '';
  if Len = 0 then Exit;
  Result := Copy( S, L - Len + 1, Len );
end;
{$ENDIF ASM_VERSION}
//[END CopyTail]

//[PROCEDURE DeleteTail]
{$IFDEF ASM_UNICODE}
procedure DeleteTail( var S : AnsiString; Len : Integer );
asm
        PUSH     EAX
        PUSH     EDX
        MOV      EAX, [EAX]
        CALL     System.@LStrLen
        POP      ECX
        CMP      ECX, EAX
        {$IFDEF USE_CMOV}
        CMOVG    ECX, EAX
        {$ELSE}
        JLE      @@1
        MOV      ECX, EAX
@@1:    {$ENDIF}

        MOV      EDX, EAX
        SUB      EDX, ECX
        INC      EDX
        POP      EAX
        CALL     System.@LStrDelete
end;
{$ELSE ASM_VERSION} //Pascal
procedure DeleteTail( var S : KOLString; Len : Integer );
var L : Integer;
begin
  L := Length( S );
  if Len > L then
     Len := L;
  Delete( S, L - Len + 1, Len );
end;
{$ENDIF ASM_VERSION}
//[END DeleteTail]

{$IFNDEF TEST_INDEXOFCHARS_COMPAT}
//[FUNCTION IndexOfChar]
{$IFDEF ASM_UNICODE}
function IndexOfChar( const S : KOLString; Chr : KOLChar ) : Integer;
asm
        CALL     EAX2PChar
        PUSH     EAX
        //PUSH     EDX
        MOV      ECX, [EAX-4]
        CALL     StrScanLen
        //POP      ECX
        POP      EDX
        //TEST     EAX, EAX
        //JE       @@exit__1
        JZ       @@1
        //CMP      [EAX-1], CL
        //JE       @@1
        LEA      EDX, [EAX+1]
@@1:    SUB      EAX, EDX
        //RET
//@@exit__1:
        //DEC      EAX
end;
{$ELSE ASM_VERSION} //Pascal
function IndexOfChar( const S : KOLString; Chr : KOLChar ) : Integer;
var //P, F : PChar;
 i, l : integer;
begin
 Result := -1;
 if S = '' then exit;
 l := Length(S);
 for I := 1 to l do
  begin
   if S[I] = Chr then
    begin
     Result := I;
     break;
    end;
  end;
  
(*   P := PKOLChar( S );
   {$IFDEF INPACKAGE}
   F := StrScan( P, Chr );
   {$ELSE}
   F := StrScanLen( P, Chr, Length( S ) );
   {$ENDIF}
   Result := -1;
   if (F = nil) or (S = '') then Exit;
   Result := (Integer( F ) - Integer( P )) {$IFDEF UNICODE_CTRLS} div SizeOfKOLChar {$ENDIF}
          {$IFDEF INPACKAGE} + 1 {$ENDIF}; // by byte

   if {(Result > Length(S)) or} (S[ Result ] <> Chr) then
     Result := -1;   *)
end;
{$ENDIF ASM_VERSION}
//[END IndexOfChar]
{$ELSE TEST_INDEXOFCHARS_COMPAT}////////////////////////////////////////////////
function IndexOfChar_Old( const S : AnsiString; Chr : AnsiChar ) : Integer;
var P, F : PAnsiChar;
begin
   P := PAnsiChar( S );
   F := StrScan( P, Chr );
   Result := -1;
   if F = nil then Exit;
   Result := Integer( F ) - Integer( P ) + 1;
end; ///////////////////////////////////////////////////////////////////////////
function IndexOfChar_New( const S : AnsiString; Chr : AnsiChar ) : Integer;
var P, F : PAnsiChar;
begin
   P := PAnsiChar( S );
   F := StrScanLen( P, Chr, Length( S ) );
   Result := -1;
   if F = nil then Exit;
   Result := Integer( F ) - Integer( P );
   if {(Result > Length(S)) or} (S[ Result ] <> Chr) then
     Result := -1;
end; ///////////////////////////////////////////////////////////////////////////
function Replace0with_( const s: AnsiString ): AnsiString;
var i: Integer;
begin
  Result := s;
  for i := 1 to Length( s ) do
      if s[i] = #0 then Result[i] := '_';
end;
function IndexOfChar( const S : KOLString; Chr : KOLChar ) : Integer;
begin
   Result := IndexOfChar_Old( S, Chr );
   if Result <> IndexOfChar_New( S, Chr ) then
   begin
     LogFileOutput( 'c:\kol\TEST_INDEXOFCHARS_COMPAT.txt',
       'S=' + Replace0with_( S ) + #13#10 +
       'C=' + Replace0with_( Chr ) + ' Old=' + Int2Str( Result ) +
       ' New=' + Int2Str( IndexOfChar_New( S, Chr ) ) + #13#10 );
   end;
end;
{$ENDIF}

//[FUNCTION IndexOfCharsMin]
{$IFDEF ASM_UNICODE}
function IndexOfCharsMin( const S, Chars : AnsiString ) : Integer;
asm     PUSH     ESI
        PUSH     EBX
        PUSH     EAX
        CALL     EDX2PChar
        MOV      ESI, EDX

        OR       EBX, -1
        MOV      ECX, [EDX-4]
        JECXZ    @@EXIT

@@1:    LODSB

        XCHG     EDX, EAX
        POP      EAX
        PUSH     EAX

        PUSH     ECX
        CALL     IndexOfChar
        POP      ECX
        TEST     EAX, EAX
        JLE      @@NEXT

        TEST     EBX, EBX
        JLE      @@ASGN
        CMP      EAX, EBX
        JGE      @@NEXT
@@ASGN:
        XCHG     EAX, EBX
@@NEXT: LOOP     @@1

@@EXIT: XCHG     EAX, EBX
        POP      ECX
        POP      EBX
        POP      ESI
end;
{$ELSE ASM_VERSION} //Pascal
function IndexOfCharsMin( const S, Chars : KOLString ) : Integer;
var I, J : Integer;
begin
  Result := -1;
  for I := 1 to Length( Chars ) do
  begin
    J := IndexOfChar( S, Chars[ I ] );
    if J > 0 then
    begin
      if (Result <= 0) or (J < Result) then
         Result := J;
    end;
  end;
end;
{$ENDIF ASM_VERSION}
//[END IndexOfCharsMin]

{$IFNDEF _FPC}
{$IFNDEF _D2}
//[function IndexOfWideCharsMin]
function IndexOfWideCharsMin( const S, Chars : WideString ) : Integer;
var I, J : Integer;
begin
  Result := -1;
  for I := 1 to Length( Chars ) do
  begin
    J := pos( Chars[ I ], S );
    if J > 0 then
    begin
      if (Result < 0) or (J < Result) then
         Result := J;
    end;
  end;
end;
{$ENDIF _D2}
{$ENDIF _FPC}

//[FUNCTION IndexOfStr]
{$IFDEF ASM_UNICODE}
function IndexOfStr( const S, Sub : KOLString ) : Integer;
asm
        PUSH     EBX
        PUSH     ESI
        PUSH     EDI

        PUSH     EAX
        MOV      EAX, EDX
        PUSH     EDX
        CALL     System.@LStrLen
        MOV      EDI, EAX
        POP      EAX
        //CALL     System.@LStrToPChar
        CALL     EAX2PChar
        MOV      BL, [EAX]
        XCHG     EAX, [ESP]
        //CALL     System.@LStrToPChar
        CALL     EAX2PChar

        MOV      ESI, EAX

        DEC      EAX
@@1:    INC      EAX
        MOV      DL, BL
        MOV      ECX, [ESI-4]
        SUB      ECX, EAX
        ADD      ECX, ESI

        CMP      ECX, EDI
        JL       @@ret__1

        CALL     StrScanLen
        TEST     EAX, EAX
        JE       @@exit__1
        DEC      EAX

        POP      EDX
        PUSH     EDX

        MOV      ECX, EDI
        PUSH     EAX
        //CALL     StrLComp
        CALL     CompareMem
        TEST     AL, AL
        POP      EAX
        JZ       @@1

        SUB      EAX, ESI
        INC      EAX
        JMP      @@exit

@@ret__1:
        XOR      EAX, EAX
@@exit__1:
        DEC      EAX
@@exit:
        POP      EDX
        POP      EDI
        POP      ESI
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
function IndexOfStr( const S, Sub : KOLString ) : Integer;
var I : Integer;
begin
  Result := Length( S );
  if Sub = '' then Exit;
  Result := 0;
  if S = '' then Exit;
  if Length( Sub ) > Length( S ) then Exit;
  Result := 1;
  while Result + Length( Sub ) - 1 <= Length( S ) do
  begin
    I := IndexOfChar( CopyEnd( S, Result ), Sub[ 1 ] );
    if I <= 0 then break;
    Result := Result + I - 1;
    if Result <= 0 then Exit;
    if Copy( S, Result, Length( Sub ) ) = Sub then Exit;
    Inc( Result );
  end;
  Result := -1;
end;
{$ENDIF ASM_VERSION}
//[END IndexOfStr]

//[FUNCTION Parse]
{$IFDEF ASM_UNICODE} //???
function Parse( var S : AnsiString; const Separators : AnsiString ) : AnsiString;
asm
         PUSH    EBX
         PUSH    ESI
         PUSH    EDI
         MOV     EDI, ECX
         XCHG    ESI, EAX
         MOV     EAX, [ESI]
         CALL    IndexOfCharsMin
         XCHG    EBX, EAX
         TEST    EBX, EBX
         JG      @@1
         MOV     EAX, [ESI]
         CALL    System.@LStrLen
         XCHG    EBX, EAX
         INC     EBX
@@1:
         XOR     EDX, EDX
         INC     EDX
         PUSH    EDX

         PUSH    EDI
         MOV     ECX, EBX
         DEC     ECX
         MOV     EAX, [ESI]
         CALL    System.@LStrCopy
         XCHG    EAX, ESI
         MOV     ECX, EBX
         POP     EDX
         CALL    System.@LStrDelete
         POP     EDI
         POP     ESI
         POP     EBX
end;
{$ELSE ASM_VERSION} //Pascal
function Parse( var S : KOLString; const Separators : KOLString ) : KOLString;
var Pos : Integer;
begin
  Pos := IndexOfCharsMin( S, Separators );
  if Pos <= 0 then
     Pos := Length( S )+1;
  Result := Copy( S, 1, Pos-1 );
  Delete( S, 1, Pos );
end;
{$ENDIF ASM_VERSION}
//[END Parse]

{$IFNDEF _FPC}
{$IFNDEF _D2}
//[function WParse]
function WParse( var S : WideString; const Separators : WideString ) : WideString;
var Pos : Integer;
begin
  Pos := IndexOfWideCharsMin( S, Separators );
  if Pos <= 0 then
     Pos := Length( S ) + 1;
  Result := S;
  S := Copy( Result, Pos + 1, MaxInt );
  Result := Copy( Result, 1, Pos - 1 );
end;
{$ENDIF _D2}
{$ENDIF _FPC}

//[function ParsePascalString]
function ParsePascalString( var S : AnsiString; const Separators : AnsiString ) : AnsiString;
var Pos, Idx : Integer;
    Hex, Spc : Boolean;
    procedure SkipSpaces;
    begin
      if not Spc then
        while (Length( S ) >= Pos) and (S[ Pos ] = ' ') do
          Inc( Pos );
    end;
var Buf : AnsiString;
    Ou, Val : Integer;
begin
  Pos := 1;
  Spc := IndexOfChar( Separators, ' ' ) >= 0;
  SkipSpaces;
  if Length( S ) < Pos then
  begin
    Result := S;
    S := '';
    exit;
  end;
  Buf := PAnsiChar( S );
  Ou := 1;
  if S[ Pos ] in [ '''', '#' ] then
  begin
    // skip here string constant expression
    while Pos <= Length( S ) do
    begin
      if S[ Pos ] = '''' then
      begin
        Inc( Pos );
        while Pos <= Length( S ) do
        begin
          if S[ Pos ] = '''' then
            if (Pos = Length( S )) or (S[ Pos+1 ] <> '''') then
            begin
              Inc( Pos );
              break;
            end
            else Inc( Pos );
          Buf[ Ou ] := S[ Pos ];
          Inc( Ou );
          Inc( Pos );
        end;
      end
         else
      if S[ Pos ] = '#' then
      begin
        Inc( Pos ); Hex := False; Val := 0;
        if (Pos < Length( S )) and (S[ Pos ] = '$') then
        begin
           Inc( Pos ); Hex := True;
        end;
        Dec( Pos );
        while Pos < Length( S ) do
        begin
          Inc( Pos );
          if (S[ Pos ] in [ '0'..'9' ]) or
             Hex and (S[ Pos ] in [ 'a'..'f', 'A'..'F' ]) then
          begin
            if Hex then
               Val := Val * 16
            else
               Val := Val * 10;
            if S[ Pos ] <= '9' then
               Val := Val + Integer( S[ Pos ] ) - Integer( '0' )
            else
            if S[ Pos ] <= 'F' then
               Val := Val + 10 + Integer( S[ Pos ] ) - Integer( 'A' )
            else
               Val := Val + 10 + Integer( S[ Pos ] ) - Integer( 'a' );
            continue;
          end;
          Inc( Pos ); break;
        end;
        Buf[ Ou ] := AnsiChar( Val );
        Inc( Ou );
      end
         else break;
      SkipSpaces;
      if S[ Pos ] <> '+' then break;
      SkipSpaces;
    end;
  end;
  Idx := IndexOfCharsMin( CopyEnd( S, Pos ), Separators );
  if Idx <= 0 then
  begin
    Result := Copy( Buf, 1, Ou - 1 ) + CopyEnd( S, Pos );
    S := '';
  end
     else
  begin
    Result := Copy( Buf, 1, Ou - 1 ) + Copy( S, Pos, Idx - 1 );
    S := CopyEnd( S, Pos + Idx );
  end;
end;

//[function String2PascalStrExpr]
function String2PascalStrExpr( const S : AnsiString ) : AnsiString;
var I, Strt : Integer;
  function String2DoubleQuotas( const S : AnsiString ) : AnsiString;
  var I, J : Integer;
  begin
    if IndexOfChar( S, '''' ) <= 0 then
       Result := S
    else
    begin
      J := 0;
      for I := 1 to Length( S ) do
        if S[ I ] = '''' then Inc( J );
      SetLength( Result, Length( S ) + J );
      J := 1;
      for I := 1 to Length( S ) do
      begin
        Result[ J ] := S[ I ];
        Inc( J );
        if S[ I ] = '''' then
        begin
          Result[ J ] := '''';
          Inc( J );
        end;
      end;
    end;
  end;
begin
  Result := '';
  if S = '' then
  begin
    Result := '''''';
    exit;
  end;
  Strt := 1;
  for I := 1 to Length( S ) + 1 do
  begin
    if (I > Length( S )) or (S[ I ] < ' ') or (S[ I ] >= #$7F) then
    begin
      if (I > Strt) and (I > 1) then
      begin
        if Result <> '' then
           Result := Result + '+';
        Result := Result + '''' + String2DoubleQuotas( Copy( S, Strt, I - Strt ) ) + '''';
      end;
      if I > Length( S ) then break;
      if Result <> '' then
         Result := Result + '+'
      else
         Result := Result + '''''+';
      Result := Result + '#' + Int2Str( Integer( S[ I ] ) );
      Strt := I + 1;
    end;
  end;
end;

//[function CompareMem]
function CompareMem(P1, P2: Pointer; Length: Integer): Boolean; assembler;
asm
  {$IFDEF F_P}
        MOV     EAX, [P1]
        MOV     EDX, [P2]
        MOV     ECX, [Length]
  {$ENDIF}
        PUSH    ESI
        PUSH    EDI
        MOV     ESI,P1
        MOV     EDI,P2
        MOV     EDX,ECX
        XOR     EAX,EAX
        AND     EDX,3
        SHR     ECX,1
        SHR     ECX,1
        REPE    CMPSD
        JNE     @@2
        MOV     ECX,EDX
        REPE    CMPSB
        JNE     @@2
@@1:    INC     EAX
@@2:    POP     EDI
        POP     ESI
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};

//[FUNCTION AllocMem]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function AllocMem( Size : Integer ) : Pointer;
begin
   Result := nil;
   if Size > 0 then
   begin
     GetMem( Result, Size );
     FillChar( Result^, Size, 0 );
   end;
end;
{$ENDIF ASM_VERSION}
//[END AllocMem]

//[procedure DisposeMem]
procedure DisposeMem( var Addr : Pointer );
begin
   if Addr <> nil then
      FreeMem( Addr );
   Addr := nil;
end;

{$IFDEF WIN}
//[function AnsiUpperCase]
function AnsiUpperCase(const S: Ansistring): Ansistring;
var Len: Integer;
begin
  Len := Length(S);
  SetString(Result, PAnsiChar(S), Len);
  if Len > 0 then CharUpperBuffA(Pointer(Result), Len);
end;

//[function AnsiLowerCase]
function AnsiLowerCase(const S: Ansistring): Ansistring;
var
  Len: Integer;
begin
  Len := Length(S);
  SetString(Result, PAnsiChar(S), Len);
  if Len > 0 then CharLowerBuffA(Pointer(Result), Len);
end;
{$ENDIF WIN}

{$IFNDEF _D2}
{$IFNDEF _FPC}

//[function WAnsiUpperCase]
{$IFDEF WIN}
function WAnsiUpperCase(const S: WideString): WideString;
var Len: Integer;
begin
  Result := S;
  Len := Length(S);
  if Len > 0 then CharUpperBuffW(Pointer(Result), Len);
end;
{$ENDIF WIN}

//[function WAnsiLowerCase]
{$IFDEF WIN}
function WAnsiLowerCase(const S: WideString): WideString;
var Len: Integer;
begin
  Result := S;
  Len := Length(S);
  if Len > 0 then CharLowerBuffW(Pointer(Result), Len);
end;
{$ENDIF WIN}

{$IFDEF WIN}
function WStrComp(const S1, S2: WideString): Integer;
var i: Integer;
begin
  for i := 1 to min( Length( S1 ), Length( S2 ) ) do
  begin
    Result := Ord( S1[ i ] ) - Ord( S2[ i ] );
    if Result <> 0 then Exit;
  end;
  Result := Length( S1 ) - Length( S2 );
end;

function _WStrComp(S1, S2: PWideChar): Integer;
var
  L, R : PWideChar;
begin
  L := S1;
  R := S2;
  Result := 0;
  repeat
    if L^ = R^ then
    begin
      if L^ = #0 then exit;
      Inc(L);
      Inc(R);
    end
    else
    begin
      Result := (Word(L^) - Word(R^));
      exit;
    end;
  until (False);
end;

function WStrScan(Str: PWideChar; Chr: WideChar): PWideChar;
begin
  while (Str^ <> Chr) and (Str^ <> #0) do inc( Str );
  Result := Str;
end;

function WStrRScan(const Str: PWideChar; Chr: WideChar): PWideChar;
begin
  Result := Str;
  while Result^ <> #0 do inc( Result );
  while (DWORD( Result ) >= DWORD( Str )) and
        (Result^ <> Chr) do dec( Result );
  if (DWORD( Result ) < DWORD( Str )) then
    Result := nil;
end;
{$ENDIF WIN}
{$ENDIF _FPC}
{$ENDIF _D2}

//[function AnsiCompareStr]
{$IFDEF WIN}
function AnsiCompareStr(const S1, S2: KOLString): Integer;
begin
  Result := CompareString(LOCALE_USER_DEFAULT, 0, PKOLChar(S1), -1, PKOLChar(S2), -1 ) - 2;
end;
{$ENDIF WIN}

//[function AnsiCompareStrA]
{$IFDEF WIN}
function AnsiCompareStrA(const S1, S2: AnsiString): Integer;
begin
  Result := CompareStringA(LOCALE_USER_DEFAULT, 0, PAnsiChar(S1), -1, PAnsiChar(S2), -1 ) - 2;
end;
{$ENDIF WIN}

//[function _AnsiCompareStr]
{$IFDEF WIN}
function _AnsiCompareStr(S1, S2: PKOLChar): Integer;
begin
  Result := CompareString( LOCALE_USER_DEFAULT, 0, S1, -1,
                           S2, -1) - 2;
end;
{$ENDIF WIN}

//[function _AnsiCompareStrA]
{$IFDEF WIN}
function _AnsiCompareStrA(S1, S2: PAnsiChar): Integer;
begin
  Result := CompareStringA( LOCALE_USER_DEFAULT, 0, S1, -1,
                           S2, -1) - 2;
end;
{$ENDIF WIN}

//[function AnsiCompareStrNoCase]
{$IFDEF WIN}
function AnsiCompareStrNoCase(const S1, S2: KOLString): Integer;
begin
  Result := CompareString(LOCALE_USER_DEFAULT, NORM_IGNORECASE, PKOLChar(S1), -1,
    PKOLChar(S2), -1 ) - 2;
end;
{$ENDIF WIN}

//[function AnsiCompareStrNoCaseA]
{$IFDEF WIN}
function AnsiCompareStrNoCaseA(const S1, S2: AnsiString): Integer;
begin
  Result := CompareStringA(LOCALE_USER_DEFAULT, NORM_IGNORECASE, PAnsiChar(S1), -1,
    PAnsiChar(S2), -1 ) - 2;
end;
{$ENDIF WIN}

//[function _AnsiCompareStrNoCase]
{$IFDEF WIN}
function _AnsiCompareStrNoCase(S1, S2: PKOLChar): Integer;
begin
  Result := CompareString( LOCALE_USER_DEFAULT, NORM_IGNORECASE, S1, -1,
                           S2, -1) - 2;
end;
{$ENDIF WIN}

//[function _AnsiCompareStrNoCaseA]
{$IFDEF WIN}
function _AnsiCompareStrNoCaseA(S1, S2: PAnsiChar): Integer;
begin
  Result := CompareStringA( LOCALE_USER_DEFAULT, NORM_IGNORECASE, S1, -1,
                           S2, -1) - 2;
end;
{$ENDIF WIN}

//[function AnsiCompareText]
function AnsiCompareText( const S1, S2: KOLString ): Integer;
begin
  Result := AnsiCompareStrNoCase( S1, S2 );
end;

//[function AnsiCompareTextA]
function AnsiCompareTextA( const S1, S2: AnsiString ): Integer;
begin
  Result := AnsiCompareStrNoCaseA( S1, S2 );
end;

//[function StrLCopy]
function StrLCopy(Dest: PAnsiChar; const Source: PAnsiChar; MaxLen: Cardinal): PAnsiChar; assembler;
asm
  {$IFDEF F_P}
        MOV     EAX, [Dest]
        MOV     EDX, [Source]
        MOV     ECX, [MaxLen]
  {$ENDIF F_P}
        PUSH    EDI
        PUSH    ESI
        PUSH    EBX
        MOV     ESI,EAX
        MOV     EDI,EDX
        MOV     EBX,ECX
        XOR     AL,AL
        TEST    ECX,ECX
        JZ      @@1
        REPNE   SCASB
        JNE     @@1
        INC     ECX
@@1:    SUB     EBX,ECX
        MOV     EDI,ESI
        MOV     ESI,EDX
        MOV     EDX,EDI
        MOV     ECX,EBX
        SHR     ECX,2
        REP     MOVSD
        MOV     ECX,EBX
        AND     ECX,3
        REP     MOVSB
        STOSB
        MOV     EAX,EDX
        POP     EBX
        POP     ESI
        POP     EDI
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};

//[FUNCTION StrPCopy]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function StrPCopy(Dest: PAnsiChar; const Source: Ansistring): PAnsiChar;
begin
  Result := StrLCopy(Dest, PAnsiChar(Source), Length(Source));
end;
{$ENDIF ASM_VERSION}
//[END StrPCopy]

//[FUNCTION StrEq]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function StrEq( const S1, S2 : AnsiString ) : Boolean;
begin
  Result := (Length( S1 ) = Length( S2 )) and
            (LowerCase( S1 ) = LowerCase( S2 ));
end;
{$ENDIF ASM_VERSION}
//[END StrEq]

//[FUNCTION AnsiEq]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function AnsiEq( const S1, S2 : KOLString ) : Boolean;
begin
  Result := AnsiCompareStrNoCase( S1, S2 ) = 0;
end;
{$ENDIF ASM_VERSION}
//[END AnsiEq]

{$IFNDEF _D2}
{$IFNDEF _FPC}
//[function WAnsiEq]
function WAnsiEq( const S1, S2 : WideString ) : Boolean;
begin
  Result := WAnsiLowerCase( S1 )=WAnsiLowerCase( S2 );
end;
{$ENDIF _FPC}
{$ENDIF _D2}

//[FUNCTION StrIn]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function StrIn(const S: AnsiString; const A: array of String): Boolean;
var I : Integer;
begin
  for I := Low( A ) to High( A ) do
      if StrEq( S, A[ I ] ) then
      begin
        Result := True;
        Exit;
      end;
  Result := False;
end;
{$ENDIF ASM_VERSION}
//[END StrIn]

{$IFNDEF _D2}
{$IFNDEF _FPC}
//[function WStrIn]
function WStrIn( const S : WideString; const A : array of WideString ) : Boolean;
var I : Integer;
begin
  for I := Low( A ) to High( A ) do
      if WAnsiEq( S, A[ I ] ) then
      begin
        Result := True;
        Exit;
      end;
  Result := False;
end;
{$ENDIF _FPC}
{$ENDIF _D2}

function CharIn( C: KOLChar; const A: TSetofChar ): Boolean;
begin
  Result := (DWord( C ) <= 255) and (AnsiChar( C ) in A);
end;

//[function StrIs]
function StrIs( const S : AnsiString; const A : Array of AnsiString; var Idx: Integer ) : Boolean;
var I : Integer;
begin
  Idx := -1;
  for I := Low( A ) to High( A ) do
      if StrEq( S, A[ I ] ) then
      begin
        Idx := I;
        Result := True;
        Exit;
      end;
  Result := False;
end;

//[function IntIn]
function IntIn( Value: Integer; const List: array of Integer ): Boolean;
var I: Integer;
begin
  Result := FALSE;
  for I := 0 to High( List ) do
  begin
    if Value = List[ I ] then
    begin
      Result := TRUE;
      break;
    end;
  end;
end;

//[FUNCTION _StrSatisfy]
{$IFDEF ASM_UNICODE}
function _StrSatisfy( S, Mask : PKOLChar ) : Boolean;
asm
    TEST EAX, EAX
    JZ   @@exit
        XCHG     ECX, EAX
        //       EDX <- Mask
        //       ECX <- S
        XOR      EAX, EAX
        MOV      AL, '*'
@@rest_satisfy:
        PUSH     ECX
        PUSH     EDX

@@nx_char:
        MOV      AH, [EDX]
        OR       AH, [ECX]
        JZ       @@fin //@@ret_true

        MOV      AH, 0

        CMP      word ptr [EDX], AX //'*'
        JE       @@fin //@@ret_true

        CMP      byte ptr [ECX], AH
        JNE      @@10

        DEC      EDX
@@1:
        INC      EDX
        CMP      byte ptr [EDX], AL //'*'
        JE       @@1

        CMP      byte ptr [EDX], AH
        SETZ     AL
        JMP      @@fin

@@10:   CMP      byte ptr [EDX], AH
        JE       @@ret_false

        CMP      byte ptr [EDX], '?'
        JNE      @@11

@@go_nx_char:
        INC      ECX
        INC      EDX
        JMP      @@nx_char

@@11:
        CMP      byte ptr [EDX], AL //'*'
        JNE      @@20

        INC      EDX
@@12:   CMP      byte ptr [ECX], AH
        JE       @@ret_false

        CALL     @@rest_satisfy
        TEST     AL, AL
        JNE      @@fin
        MOV      AL, '*'

        INC      ECX
        JMP      @@12

@@20:   MOV      AH, [EDX]
        XOR      AH, [ECX]

        JE       @@go_nx_char
@@ret_false:
        XOR      EAX, EAX

@@fin:
        POP      EDX
        POP      ECX
@@exit:
end;
{$ELSE ASM_VERSION} //Pascal
function _StrSatisfy( S, Mask : PKOLChar ) : Boolean;
label next_char;
begin
next_char:
  Result := True;
  if (S^ = #0) and (Mask^ = #0) then exit;
  if (Mask^ = '*') and (Mask[1] = #0) then exit;
  if S^ = #0 then
  begin
    while Mask^ = '*' do
          Inc( Mask );
    Result := Mask^ = #0;
    exit;
  end;
  Result := False;
  if Mask^ = #0 then exit;
  if Mask^ = '?' then
  begin
    Inc( S ); Inc( Mask ); goto next_char;
  end;
  if Mask^ = '*' then
  begin
    Inc( Mask );
    while S^ <> #0 do
    begin
      Result := _StrSatisfy( S, Mask );
      if Result then exit;
      Inc( S );
    end;
    exit; // (Result = False)
  end;
  Result := S^ = Mask^;
  Inc( S ); Inc( Mask );
  if Result then goto next_char;
end;
{$ENDIF ASM_VERSION}
//[END _StrSatisfy]

//[FUNCTION StrSatisfy]
{$IFDEF ASM_UNICODE}
function StrSatisfy( const S, Mask: AnsiString ): Boolean;
asm
        PUSH     ESI
        XCHG     ESI, EAX
        PUSH     0
        XCHG     EAX, EDX
        CALL     EAX2PChar
        MOV      EDX, ESP

        CMP      byte ptr [EAX], 0
        JZ       @@0
        CALL     AnsiLowerCase
@@0:
        XCHG     EAX, ESI
        PUSH     0
        CALL     EAX2PChar
        MOV      EDX, ESP

        CMP      byte ptr [EAX], 0
        JZ       @@1
        CALL     AnsiLowerCase
@@1:
        POP      EAX
        POP      EDX
        PUSH     EDX
        PUSH     EAX
        CALL     _StrSatisfy

        XCHG     ESI, EAX

        CALL     RemoveStr
        CALL     RemoveStr
        XCHG     EAX, ESI

        POP      ESI
end;
{$ELSE ASM_VERSION} //Pascal
function StrSatisfy( const S, Mask: KOLString ): Boolean;
begin
  Result := _StrSatisfy( PKOLChar( {$IFDEF UNICODE_CTRLS} WAnsiLowerCase
                                   {$ELSE} AnsiLowerCase {$ENDIF} ( S ) ),
                         PKOLChar( {$IFDEF UNICODE_CTRLS} WAnsiLowerCase
                                   {$ELSE} AnsiLowerCase {$ENDIF} ( Mask ) ) );
end;
{$ENDIF ASM_VERSION}
//[END StrSatisfy]

//[FUNCTION _2StrSatisfy]
{$IFDEF ASM_UNICODE}
function _2StrSatisfy( S, Mask: PAnsiChar ): Boolean;
asm     //     //
        PUSH   EBX
        PUSH   ECX 
        XCHG   EBX, EAX
        PUSH   0
        MOV    EAX, ESP
        {$IFDEF _D2009orHigher}
        XOR      ECX, ECX
        {$ENDIF}
        CALL   System.@LStrFromPChar
        PUSH   0
        MOV    EAX, ESP
        MOV    EDX, EBX
        {$IFDEF _D2009orHigher}
        XOR      ECX, ECX
        {$ENDIF}
        CALL   System.@LStrFromPChar
        POP    EAX
        POP    EDX
        PUSH   EDX
        PUSH   EAX
        CALL   StrSatisfy
        XCHG   EBX, EAX
        CALL   RemoveStr
        CALL   RemoveStr
        XCHG   EAX, EBX
        POP    ECX
        POP    EBX
end;
{$ELSE ASM_VERSION} // Pascal
function _2StrSatisfy( S, Mask: PKOLChar ): Boolean;
begin
  Result := StrSatisfy( S, Mask );
end;
{$ENDIF ASM_VERSION}
//[END _2StrSatisfy]

//[function StrReplace]
function StrReplace( var S: AnsiString; const From, ReplTo: AnsiString ): Boolean;
var I: Integer;
begin
  I := pos( From, S );
  if I > 0 then
  begin
    S := Copy( S, 1, I - 1 ) + ReplTo + CopyEnd( S, I + Length( From ) );
    Result := TRUE;
  end
  else Result := FALSE;
end;

function KOLStrReplace( var S: KOLString; const From, ReplTo: KOLString ): Boolean;
var I: Integer;
begin
  I := pos( From, S );
  if I > 0 then
  begin
    S := Copy( S, 1, I - 1 ) + ReplTo + CopyEnd( S, I + Length( From ) );
    Result := TRUE;
  end
  else Result := FALSE;
end;

{-}
{$IFDEF _FPC}
//[procedure SetLengthW]
procedure SetLengthW( var W: WideString; NewLength: Integer );
begin
  while Length( W ) < NewLength do
    W := W + ' ' + W;
  if Length( W ) > NewLength then
    Delete( W, NewLength + 1, Length( W ) - NewLength );
end;

//[function CopyW]
function CopyW( const W: WideString; From, Count: Integer ): WideString;
begin
  Result := '';
  if Count <= 0 then Exit;
  SetLengthW( Result, Count );
  Move( W[ From ], Result[ 1 ], Count * Sizeof( WideChar ) );
end;

//[function posW]
function posW( const S1, S2: AnsiString ): Integer;
var I, L1: Integer;
begin
  L1 := Length( S1 );
  for I := 1 to Length( S2 )-L1+1 do
  begin
    if Copy( S2, I, L1 ) = S1 then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := 0;
end;
{$ENDIF _FPC}

{$IFNDEF _FPC}
{$IFNDEF _D2}
//[function WStrReplace]
function WStrReplace( var S: WideString; const From, ReplTo: WideString ): Boolean;
var I: Integer;
begin
  I := pos( From, S );
  if I > 0 then
  begin
    S := Copy( S, 1, I - 1 ) + ReplTo + Copy( S, I + Length( From ), MaxInt );
    Result := TRUE;
  end
  else Result := FALSE;
end;

//[function WStrRepeat]
function WStrRepeat( const S: WideString; Count: Integer ): WideString;
var I, L: Integer;
begin
  L := Length( S );
  SetLength( Result, L * Count );
  for I := 0 to Count-1 do
    Move( S[ 1 ], Result[ 1 + I * L ], L * Sizeof( WideChar ) );
end;
{$ENDIF _D2}
{$ENDIF _FPC}

{+}
//[function StrRepeat]
function StrRepeat( const S: AnsiString; Count: Integer ): AnsiString;
var I, L: Integer;
begin
  L := Length( S );
  SetLength( Result, L * Count );
  for I := 0 to Count-1 do
    Move( S[ 1 ], Result[ 1 + I * L ], L );
end;

//[PROCEDURE NormalizeUnixText]
{$IFDEF ASM_noVERSION}
{$ELSE ASM_VERSION} //Pascal
procedure NormalizeUnixText( var S: AnsiString );
var I, J, N: Integer;
begin
  if S <> '' then
  begin
    N := 0;
    if S[ 1 ] = #10 then
    begin
      S[ 1 ] := #0;
      inc( N );
    end;
    for I := Length(S) downto 2 do
    begin
        if (S[I]=#10) and (S[I-1]<>#13) then
          S[I] := #0;
        if S[I] = #0 then inc( N );
    end;
    if N > 0 then
    begin
        SetLength( S, N+Length(S) );
        J := Length(S);
        for I := Length(S)-N downto 1 do
        begin
            if S[I] = #0 then
            begin
                S[J] := #13;
                S[J-1] := #10;
                dec( J );
            end
              else
                S[J] := S[I];
            dec(J);
        end;
    end;
  end;
end;
{$ENDIF ASM_VERSION}
//[END NormalizeUnixText]

var Koi8_to_Ansi: array[ Char ] of AnsiChar;
procedure Koi8ToAnsi( s: PAnsiChar );
const KOI8_Rus: array[ #$C0..#$FF ] of AnsiChar = (
     { '',
       '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
       '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
       '',
       '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
       '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''}
       #$FE,
       #$E0, #$E1, #$F6, #$E4, #$E5, #$F4, #$E3, #$F5, #$E8, #$E9, #$EA, #$EB, #$EC, #$ED, #$EE, #$EF,
       #$FF, #$F0, #$F1, #$F2, #$F3, #$E6, #$E2, #$FC, #$FB, #$E7, #$F8, #$FD, #$F9, #$F7, #$FA, 
       #$DE,
       #$C0, #$C1, #$D6, #$C4, #$C5, #$D4, #$C3, #$D5, #$C8, #$C9, #$CA, #$CB, #$CC, #$CD, #$CE, #$CF,
       #$DF, #$D0, #$D1, #$D2, #$D3, #$C6, #$C2, #$DC, #$DB, #$C7, #$D8, #$DD, #$D9, #$D7, #$DA
      );
var c: AnsiChar;
begin
  if Koi8_to_Ansi[ #0 ] = #0 then
  begin
    for c := #1 to #255 do
    begin
      Koi8_to_Ansi[ c ] := c;
      if (c >= #$C0) and (c <= #$FF) then
        Koi8_to_Ansi[ c ] := KOI8_Rus[ c ];
    end;
    Koi8_to_Ansi[ #0 ] := #1;
  end;
  while s^ <> #0 do
  begin
    s^ := Koi8_to_Ansi[ s^ ];
    inc( s );
  end;
end;

//[function StrComp]
function StrComp(const Str1, Str2: PAnsiChar): Integer; assembler;
asm
  {$IFDEF F_P}
        MOV     EAX, [Str1]
        MOV     EDX, [Str2]
  {$ENDIF F_P}
        PUSH    EDI
        PUSH    ESI
        MOV     EDI,EDX
        XCHG    ESI,EAX
        OR      ECX, -1
        XOR     EAX,EAX
        REPNE   SCASB
        NOT     ECX
        MOV     EDI,EDX
        XOR     EDX,EDX
        REPE    CMPSB
        MOV     AL,[ESI-1]
        MOV     DL,[EDI-1]
        SUB     EAX,EDX
        POP     ESI
        POP     EDI
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};

var Upper: array[ AnsiChar ] of AnsiChar;
    Upper_initialized: Boolean;

procedure Init_Upper;
var c: Char;
begin
    if  not Upper_initialized then
    begin
        for c := Low(c) to High(c) do
            Upper[c] := AnsiUpperCase(c+' ')[1];
        Upper_initialized := TRUE;
    end;
end;

{$IFDEF SMALLER_CODE}
function StrComp_NoCase(const Str1, Str2: PAnsiChar): Integer;
asm
  {$IFDEF F_P}
        MOV     EAX, [Str1]
        MOV     EDX, [Str2]
  {$ENDIF F_P}
        PUSH    EDI
        PUSH    ESI
        MOV     EDI,EDX
        XCHG    ESI,EAX
        OR      ECX, -1
        XOR     EAX,EAX
        REPNE   SCASB

        NOT     ECX
        MOV     EDI,EDX
  @@0:
        XOR     EDX,EDX
        REPE    CMPSB
        MOV     AL,[ESI-1]
        MOV     AH, AL
        SUB     AH, 'a'
        CMP     AH, 25
        JA      @@1
        SUB     AL, $20
  @@1:
        MOV     DL,[EDI-1]
        MOV     AH, DL
        SUB     AH, 'a'
        CMP     AH, 25
        JA      @@2
        SUB     DL, $20
  @@2:
        MOV     AH, 0
        SUB     EAX,EDX
        JNZ     @@exit
        CMP     DL, 0
        JNZ     @@0

  @@exit:
        POP     ESI
        POP     EDI
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};

//[function StrLComp_NoCase]
function StrLComp_NoCase(const Str1, Str2: PAnsiChar; MaxLen: Cardinal): Integer;
asm
  {$IFDEF F_P}
        MOV     EAX, [Str1]
        MOV     EDX, [Str2]
        MOV     ECX, [MaxLen]
  {$ENDIF F_P}
        PUSH    EDI
        PUSH    ESI
        PUSH    EBX
        MOV     EDI,EDX
        MOV     ESI,EAX
        MOV     EBX,ECX
        XOR     EAX,EAX
        OR      ECX,ECX
        JE      @@exit
        REPNE   SCASB
        SUB     EBX,ECX
        MOV     ECX,EBX
        MOV     EDI,EDX
  @@0:
        XOR     EDX,EDX
        REPE    CMPSB
        MOV     AL,[ESI-1]
        MOV     AH, AL
        SUB     AH, 'a'
        CMP     AH, 25
        JA      @@1
        SUB     AL, $20
  @@1:
        MOV     DL,[EDI-1]
        MOV     AH, DL
        SUB     AH, 'a'
        CMP     AH, 25
        JA      @@2
        SUB     DL, $20
  @@2:
        MOV     AH, 0
        SUB     EAX,EDX
        JECXZ   @@exit
        JZ      @@0

  @@exit:
        POP     EBX
        POP     ESI
        POP     EDI
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};
{$ELSE not SMALLER_CODE}
function StrComp_NoCase2(const Str1, Str2: PAnsiChar): Integer;
asm
  {$IFDEF F_P}
        MOV     EAX, [Str1]
        MOV     EDX, [Str2]
  {$ENDIF F_P}
        PUSH    ESI
        XCHG    ESI, EAX
  @@1:  MOVZX   EAX, BYTE PTR [EDX]
        INC     EDX
        MOV     CL,  BYTE PTR [EAX+Upper]
        LODSB
        SUB     CL,  BYTE PTR [EAX+Upper]
        JNZ     @@fin
        CMP     AL,  CL
        JNZ     @@1
  @@fin:MOVSX   EAX, CL
        POP     ESI
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};

function StrComp_NoCase1(const Str1, Str2: PAnsiChar): Integer;
begin
    Init_Upper;
    StrComp_NoCase := @StrComp_NoCase2;
    Result := StrComp_NoCase2( Str1, Str2 );
end;

//[function StrLComp_NoCase]
function StrLComp_NoCase2(const Str1, Str2: PAnsiChar; MaxLen: Cardinal): Integer;
asm
  {$IFDEF F_P}
        MOV     EAX, [Str1]
        MOV     EDX, [Str2]
        MOV     ECX, [MaxLen]
  {$ENDIF F_P}
        PUSH    EDI
        PUSH    ESI
        PUSH    EBX
        MOV     EDI,EDX
        XCHG    ESI,EAX
        XOR     EBX, EBX
        JECXZ   @@fin
  @@1:  MOV     AL, BYTE PTR [EDI]
        INC     EDI
        MOV     BL, BYTE PTR [EAX+Upper]
        LODSB
        SUB     BL, BYTE PTR [EAX+Upper]
        JNZ     @@fin
        AND     AL, BL
        JNZ     @@1
  @@fin:MOVSX   EAX, BL
        POP     EBX
        POP     ESI
        POP     EDI
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};

function StrLComp_NoCase1(const Str1, Str2: PAnsiChar;  MaxLen: Cardinal): Integer;
begin
    Init_Upper;
    StrComp_NoCase := @StrComp_NoCase2;
    Result := StrLComp_NoCase2( Str1, Str2, MaxLen );
end;
{$ENDIF}

//[function StrLComp]
function StrLComp(const Str1, Str2: PAnsiChar; MaxLen: Cardinal): Integer; assembler;
asm
  {$IFDEF F_P}
        MOV     EAX, [Str1]
        MOV     EDX, [Str2]
        MOV     ECX, [MaxLen]
  {$ENDIF F_P}
        PUSH    EDI
        PUSH    ESI
        PUSH    EBX
        MOV     EDI,EDX
        MOV     ESI,EAX
        MOV     EBX,ECX
        XOR     EAX,EAX
        OR      ECX,ECX
        JE      @@1
        REPNE   SCASB
        SUB     EBX,ECX
        MOV     ECX,EBX
        MOV     EDI,EDX
        XOR     EDX,EDX
        REPE    CMPSB
        MOV     AL,[ESI-1]
        MOV     DL,[EDI-1]
        SUB     EAX,EDX
@@1:    POP     EBX
        POP     ESI
        POP     EDI
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};

//[function StrLen]
function StrLen(const Str: PAnsiChar): Cardinal; assembler;
asm
  {$IFDEF F_P}
        MOV     EAX, [Str]
  {$ENDIF F_P}
        XCHG    EAX, EDI
        XCHG    EDX, EAX
        OR      ECX, -1
        XOR     EAX, EAX
        CMP     EAX, EDI
        JE      @@exit0
        REPNE   SCASB
        DEC     EAX
        DEC     EAX
        SUB     EAX,ECX
@@exit0:
        MOV     EDI,EDX
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};

//[FUNCTION __DelimiterLast]
{$IFDEF ASM_UNICODE}
{$ELSE ASM_VERSION} //Pascal
function __DelimiterLast( Str, Delimiters: PKOLChar ): PKOLChar;
var
    P, F : PKOLChar;
begin
  P := Str;
  Result := P + {$IFDEF UNICODE_CTRLS} WStrLen {$ELSE} StrLen {$ENDIF}( Str );
  while Delimiters^ <> #0 do
  begin
    F := {$IFDEF UNICODE_CTRLS} WStrRScan {$ELSE} StrRScan {$ENDIF}
         ( P, Delimiters^ );
    if F <> nil then
    if (Result^ = #0) or (Integer(F) > Integer(Result)) then
       Result := F;
    Inc( Delimiters );
  end;
end;
{$ENDIF ASM_VERSION}
//[END __DelimiterLast]

{$IFDEF _D3orHigher}
function W__DelimiterLast( Str, Delimiters: PWideChar ): PWideChar;
var
    P, F : PWideChar;
begin
  P := Str;
  Result := P + WStrLen( Str );
  while Delimiters^ <> #0 do
  begin
    F := WStrRScan( P, Delimiters^ );
    if F <> nil then
    if (Result^ = #0) or (Integer(F) > Integer(Result)) then
       Result := F;
    Inc( Delimiters );
  end;
end;
{$ENDIF _D3orHigher}

//[function SkipSpaces]
function SkipSpaces( P: PKOLChar ): PKOLChar;
begin
  while True do
  begin
    while (P[0] <> #0) and (P[0] <= ' ') do Inc(P);
    if (P[0] = '"') and (P[1] = '"') then Inc(P, 2) else Break;
  end;
  Result := P;
end;

//[function SkipParam]
function SkipParam(P: PKOLChar): PKOLChar;
begin
  P := SkipSpaces( P );
  while P[0] > ' ' do
    if P[0] = '"' then
    begin
      Inc(P);
      while (P[0] <> #0) and (P[0] <> '"') do
        Inc(P);
      if P[0] <> #0 then Inc(P);
    end
      else
      Inc(P);
  Result := P;
end;
{$IFDEF WIN}

//[FUNCTION ParamStr]
function ParamStr( Idx: Integer ): KOLString;
var
  P, P1: PKOLChar;
  Buffer: array[ 0..260 ] of KOLChar;
begin
  if Idx = 0 then
    SetString( Result, Buffer, GetModuleFileName( 0, Buffer, Sizeof( Buffer ) ) )
  else
  begin
    P := GetCommandLine;
    repeat
      P := SkipSpaces( P );
      P1 := P;
      P := SkipParam(P);
      if Idx = 0 then Break;
      Dec(Idx);
    until (Idx < 0) or (P = P1);
    Result := Copy( P1, 1, P - P1 );
    if Length( Result ) >= 2 then
    if (Result[ 1 ] = '"') and (Result[ Length( Result ) ] = '"') then
      Result := Copy( Result, 2, Length( Result ) - 2 );
  end;
end;
//[END ParamStr]

//[FUNCTION ParamCount]
function ParamCount: Integer;
var
  S: Ansistring;
begin
  Result := 0;
  while True do
  begin
    S := ParamStr(Result + 1);
    if S = '' then Break;
    Inc(Result);
  end;
end;
//[END ParamCount]
{$ENDIF WIN}

//[FUNCTION DelimiterLast]
{$IFDEF ASM_UNICODE}
function __DelimiterLast( Str: PAnsiChar; Delimiters: PAnsiChar ): PAnsiChar;
asm
        PUSH     ESI

        CALL     EAX2PChar

        MOV      ESI, EDX
        MOV      EDX, EAX

@@tolast:
        CMP      byte ptr [EAX], 0
        JZ       @@next1
        INC      EAX
        JMP      @@tolast

@@next1:
        PUSH     EAX

@@next:
        LODSB
        TEST     AL, AL
        JZ       @@exit

        PUSH     EDX
        XCHG     EDX, EAX
        CALL     StrRScan
        POP      EDX

        TEST     EAX, EAX
        JZ       @@next

        POP      ECX
        CMP      byte ptr [ECX], 0
        JZ       @@next1

        CMP      EAX, ECX
        JG       @@next1

        PUSH     ECX
        JLE      @@next

@@exit: POP      EAX
        POP      ESI
end;

function DelimiterLast( const Str, Delimiters: AnsiString ): Integer;
asm
        CALL     EAX2PChar
        CALL     EDX2PChar
        PUSH     EAX
        CALL     __DelimiterLast
        POP      EDX
        SUB      EAX, EDX
        INC      EAX
end;
{$ELSE ASM_VERSION} //Pascal
function DelimiterLast( const Str, Delimiters: KOLString ): Integer;
var PStr: PKOLChar;
begin
  PStr := PKOLChar( Str );
  Result := Integer( __DelimiterLast( PStr, PKOLChar( Delimiters ) ) )
          - Integer( PStr )
          + {$IFDEF UNICODE_CTRLS} 2 {$ELSE} 1 {$ENDIF}; // {Viman}
  {$IFDEF UNICODE_CTRLS} Result := Result div SizeOf( WideChar ) {$ENDIF};
end;
{$ENDIF ASM_VERSION}
//[END DelimiterLast]

// Thanks to Marco Bobba - Marisa Bo for this code
//[function StrIsStartingFrom]
{$IFDEF ASM_UNICODE}
function StrIsStartingFrom( Str, Pattern: PKOLChar ): Boolean;
asm
  {$IFDEF F_P}
        MOV     EAX, [Str]
        MOV     EDX, [Pattern]
  {$ENDIF F_P}
        XOR     ECX, ECX
      @@1:
        MOV     CL, [EDX]   // pattern[ i ]
        INC     EDX
        MOV     CH, [EAX]   // str[ i ]
        INC     EAX
        JECXZ   @@2         // str = pattern; CL = #0, CH = #0
        CMP     CL, CH
        JE      @@1
      @@2:
        TEST    CL, CL
        SETZ    AL
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};
{$ELSE}
function StrIsStartingFrom( Str, Pattern: PKOLChar ): Boolean;
begin
  Result := FALSE;
  if (Str = nil) or (Pattern = nil) then
  begin
    Result := (Integer(Str) = Integer(Pattern));
    Exit;
  end;

  while Pattern^ <> #0 do
  begin
    if Str^ <> Pattern^ then Exit;
    inc( Str );
    inc( Pattern );
  end;
  Result := TRUE;
end;
{$ENDIF ASM_UNICODE}

function StrIsStartingFromNoCase( Str, Pattern: PAnsiChar ): Boolean;
asm
  {$IFDEF F_P}
        MOV     EAX, [Str]
        MOV     EDX, [Pattern]
  {$ENDIF F_P}
        XOR     ECX, ECX
      @@1:
        MOV     CL, [EDX]   // pattern[ i ]
        INC     EDX
        MOV     CH, [EAX]   // str[ i ]
        INC     EAX
        JECXZ   @@2         // str = pattern; CL = #0, CH = #0
        CMP     CL, 'a'
        JB      @@cl_ok
        CMP     CL, 'z'
        JA      @@cl_ok
        SUB     CL, 32
      @@cl_ok:
        CMP     CH, 'a'
        JB      @@ch_ok
        CMP     CH, 'z'
        JA      @@ch_ok
        SUB     CH, 32
      @@ch_ok:
        CMP     CL, CH
        JE      @@1
      @@2:
        TEST    CL, CL
        SETZ    AL
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};
{$IFDEF WIN}
{$IFNDEF _FPC}
//[FUNCTION Format]
{$IFDEF ASM_UNICODE}
function Format( const fmt: KOLString; params: array of const ): AnsiString;
asm
        PUSH    ESI
        PUSH    EDI
        PUSH    EBX
        MOV     EBX, ESP
        {$IFDEF UNICODE_CTRLS}
        ADD     ESP, -2048
        {$ELSE}
        ADD     ESP, -1024
        {$ENDIF}
        MOV     ESI, ESP

        INC     ECX
        JZ      @@2
@@1:
        MOV     EDI, [EDX + ECX*8 - 8]
        PUSH    EDI
        LOOP    @@1
@@2:
        PUSH    ESP
        PUSH    EAX
        PUSH    ESI

        CALL    wvsprintf

        MOV     EDX, ESI
        MOV     EAX, @Result
        {$IFDEF _D2009orHigher}
        PUSH     ECX
        XOR      ECX, ECX
        {$ENDIF}
        CALL    System.@LStrFromPChar
        {$IFDEF _D2009orHigher}
        POP      ECX
        {$ENDIF}

        MOV     ESP, EBX
        POP     EBX
        POP     EDI
        POP     ESI
end;
{$ELSE ASM_VERSION} //Pascal
function Format( const fmt: KOLString; params: Array of const ): KOLString;
var Buffer: array[ 0..1023 ] of KOLChar;
    ElsArray, El: PDWORD;
    I : Integer;
    P : PDWORD;
begin
  ElsArray := nil;
  if High( params ) >= 0 then
    GetMem( ElsArray, (High( params ) + 1) * sizeof( Pointer ) );
  El := ElsArray;
  for I := 0 to High( params ) do
  begin
    P := @params[ I ];
    P := Pointer( P^ );
    El^ := DWORD( P );
    Inc( El );
  end;
  wvsprintf( PKOLChar(@Buffer[0]), PKOLChar( fmt ), Pointer( ElsArray ) );
  Result := Buffer;
  if ElsArray <> nil then
     FreeMem( ElsArray );
end;
{$ENDIF ASM_VERSION}
//[END Format]
{$ENDIF WIN}

//[function LStrFromPWCharLen]
function LStrFromPWCharLen(Source: PWideChar; Length: Integer): AnsiString;
var
  DestLen: Integer;
  Buffer: array[0..2047] of AnsiChar;
begin
  if Length <= 0 then
  begin
    Result := '';
    Exit;
  end;
  if Length < SizeOf(Buffer) div 2 then
  begin
    DestLen := WideCharToMultiByte(0, 0, Source, Length,
      Buffer, SizeOf(Buffer), nil, nil);
    if DestLen > 0 then
    begin
      Result := Buffer;
      Exit;
    end;
  end;
  DestLen := WideCharToMultiByte(0, 0, Source, Length, nil, 0, nil, nil);
  // _LStrFromPCharLen(Dest, nil, DestLen);
  SetLength( Result, DestLen );
  WideCharToMultiByte(0, 0, Source, Length, Pointer(Result), DestLen, nil, nil);
end;

//[function LStrFromPWChar]
function LStrFromPWChar(Source: PWideChar): AnsiString;
{* from Delphi5 - because D2 does not contain it. }
asm
        PUSH    EDX
        XOR     EDX,EDX
        TEST    EAX,EAX
        JE      @@5
        PUSH    EAX
@@0:    CMP     DX,[EAX+0]
        JE      @@4
        CMP     DX,[EAX+2]
        JE      @@3
        CMP     DX,[EAX+4]
        JE      @@2
        CMP     DX,[EAX+6]
        JE      @@1
        ADD     EAX,8
        JMP     @@0
@@1:    ADD     EAX,2
@@2:    ADD     EAX,2
@@3:    ADD     EAX,2
@@4:    XCHG    EDX,EAX
        POP     EAX
        SUB     EDX,EAX
        SHR     EDX,1
@@5:    POP     ECX
        JMP     LStrFromPWCharLen 
end {$IFDEF F_P} [ 'EAX', 'EDX', 'ECX' ] {$ENDIF};
{$ENDIF _FPC}

function WCharIn( C: KOLChar; const Chars: array of KOLChar ): Boolean;
var i: Integer;
begin
  Result := TRUE;
  for i := 0 to High( Chars ) do
    if Chars[i] = C then Exit;
  Result := FALSE;
end;

/////////////////////////////////////////////////////////////////////////
//
//
//                          F   I   L   E   S
//
//
/////////////////////////////////////////////////////////////////////////
//[FILES]
{
   This part of the unit modified by Tim Slusher and Vladimir Kladov.
}

{* Set of utility methods to work with files
   and reqistry.
   When programming KOL, which is Windows API-oriented, You should
   avoid alien (for Windows) embedded Pascal files handling, and
   use API-calls which implemented very well. This set of functions
   is intended to make this easier.
   Also TDirList object implementation present here and some registry
   access functions, which allow to make code more elegant.
}

{$UNDEF ASM_LOCAL}
{$IFDEF ASM_VERSION}
  {$DEFINE ASM_LOCAL}
{$ENDIF ASM_VERSION}

//[FUNCTION FileCreate]
{$IFDEF WIN}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function FileCreate(const FileName: KOLString; OpenFlags: DWord): THandle;
var Attr: DWORD;
begin
  Attr := (OpenFlags shr 16) and $1FFF;
  if Attr = 0 then Attr := FILE_ATTRIBUTE_NORMAL;
  Result := CreateFile( PKOLChar(FileName), OpenFlags and $F0000000,
                        OpenFlags and $F, nil, (OpenFlags shr 8) and $F,
                        Attr, 0 );
end;
{$ENDIF ASM_VERSION}
{$ENDIF WIN}
//[END FileCreate]

{$IFDEF _D3orHigher}
function WFileCreate(const FileName: WideString; OpenFlags: DWord): THandle;
var Attr: DWORD;
begin
  Attr := (OpenFlags shr 16) and $1FFF;
  if Attr = 0 then Attr := FILE_ATTRIBUTE_NORMAL;
  Result := CreateFileW( PWideChar(FileName), OpenFlags and $F0000000,
                        OpenFlags and $F, nil, (OpenFlags shr 8) and $F,
                        Attr, 0 );
end;
{$ENDIF _D3orHigher}

//[FUNCTION FileClose]
{$IFDEF WIN}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function FileClose(Handle: THandle): Boolean;
begin
     Result := CloseHandle(Handle);
end;
{$ENDIF ASM_VERSION}
{$ENDIF WIN}
//[END FileClose]

{$UNDEF ASM_LOCAL}
{$IFDEF ASM_UNICODE}
  {$DEFINE ASM_LOCAL}
{$ENDIF}
{$IFDEF FILE_EXISTS_EX}
  {$UNDEF ASM_LOCAL}
{$ENDIF}

//[FUNCTION FileExists]
{$IFDEF WIN}
{$IFDEF ASM_LOCAL}
function FileExists( const FileName : KOLString ) : Boolean;
const size_TWin32FindData = sizeof( {$IFDEF UNICODE_CTRLS} TWin32FindDataW {$ELSE} TWin32FindDataA {$ENDIF} );
asm
        CALL     EAX2PChar
        PUSH     EAX
        CALL     GetFileAttributes
        INC      EAX
        JZ       @@exit
        DEC      EAX
        {$IFDEF PARANOIA} DB $24, FILE_ATTRIBUTE_DIRECTORY {$ELSE} AND AL, FILE_ATTRIBUTE_DIRECTORY {$ENDIF}
        SETZ     AL
@@exit:
end;
{$ELSE ASM_VERSION} //Pascal
function FileExists( const FileName : KOLString ) : Boolean;
{$IFDEF FILE_EXISTS_EX}
var FD: TFindFileData;
    //F: DWORD;
    LFT: TFileTime;
    Hi, Lo: Word;
{$ELSE}
var Code: Integer;
{$ENDIF}
begin
  {$IFDEF FILE_EXISTS_EX}
  Result := FALSE;
  if not Find_First( Filename, FD ) then Exit;
  if FD.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY <> 0 then Exit;
  FileTimeToLocalFileTime( FD.ftLastWriteTime, LFT );
  if FileTimeToDosDateTime( LFT, Hi, Lo ) then Result := TRUE;
  Find_Close( FD );
  {$ELSE}
  Code := GetFileAttributes(PKOLChar(FileName));
  Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code = 0);
  {$ENDIF}
end;
{$ENDIF ASM_VERSION}
{$ENDIF WIN}
//[END FileExists]

{$IFDEF _D3orHigher}
function WFileExists( const FileName: WideString ) : Boolean;
{$IFDEF notimplemented_FILE_EXISTS_EX}
var FD: TFindFileData;
    //F: DWORD;
    LFT: TFileTime;
    Hi, Lo: Word;
{$ELSE}
var Code: Integer;
{$ENDIF}
begin
  {$IFDEF notimplemented_FILE_EXISTS_EX}
  Result := FALSE;
  if not WFind_First( Filename, FD ) then Exit;
  if FD.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY <> 0 then Exit;
  FileTimeToLocalFileTime( FD.ftLastWriteTime, LFT );
  if FileTimeToDosDateTime( LFT, Hi, Lo ) then Result := TRUE;
  WFind_Close( FD );
  {$ELSE}
  Code := GetFileAttributesW(PWideChar(FileName));
  Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code = 0);
  {$ENDIF}
end;
{$ENDIF _D3orHigher}

//[FUNCTION FileSeek]
{$IFDEF WIN}
{$IFDEF ASM_STREAM}
function FileSeek(Handle: THandle; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveMethod: TMoveMethod): TStrmSize;
asm
        MOVZX    ECX, CL
        PUSH     ECX
        PUSH     0
        PUSH     EDX
        PUSH     EAX
        CALL     SetFilePointer
end;
{$ELSE ASM_VERSION} //Pascal
function FileSeek(Handle: THandle; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveMethod: TMoveMethod): TStrmSize;
{$IFDEF STREAM_LARGE64}
var HiPtr: DWORD;
{$ENDIF}
begin
  {$IFDEF STREAM_LARGE64}
  HiPtr := MoveTo shr 32;
  Result := SetFilePointer(Handle, DWORD( MoveTo ), @ HiPtr, Ord( MoveMethod ) );
  if (DWORD( Result ) = $FFFFFFFF {INVALID_SET_FILE_POINTER}) and
     (GetLastError <> NO_ERROR) then
     Result := -1; // Int64(-1)
  if Result >= 0 then
    Result := Result or (HiPtr shl 32);
  {$ELSE}
  Result := SetFilePointer(Handle, MoveTo, nil, Ord( MoveMethod ) );
  {$ENDIF}
end;
{$ENDIF ASM_VERSION}
{$ENDIF WIN}
//[END FileSeek]

//[FUNCTION FileRead]
{$IFDEF WIN}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function FileRead(Handle: THandle; var Buffer; Count: DWord): DWord;
begin
     if not ReadFile(Handle, Buffer, Count, Result, nil) then
       Result := 0;
end;
{$ENDIF ASM_VERSION}
{$ENDIF WIN}
//[END FileRead]

//[FUNCTION File2Str]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function File2Str(Handle: THandle): AnsiString;
var Pos, Size: DWORD;
begin
  Result := '';
  if Handle = 0 then Exit;
  Pos := FileSeek( Handle, 0, spCurrent );
  Size := GetFileSize( Handle, nil );
  SetString( Result, nil, Size - Pos + 1 );
  FileRead( Handle, Result[ 1 ], Size - Pos );
  Result[ Size - Pos + 1 ] := #0;
end;
{$ENDIF ASM_VERSION}
//[END File2Str]

{$IFNDEF _D2}
function File2WStr(Handle: THandle): WideString;
var Pos, Size: DWORD;
begin
  Result := '';
  if Handle = 0 then Exit;
  Pos := FileSeek( Handle, 0, spCurrent );
  Size := GetFileSize( Handle, nil );
  SetString( Result, nil, (Size - Pos + 1) div Sizeof( WideChar ) + 1 ); // fixed by zhoudi
  FileRead( Handle, Result[ 1 ], Size - Pos );
  Result[ Length(Result) ] := #0; // fixed by zhoudi 
end;
{$ENDIF _D2}

//[FUNCTION FileWrite]
{$IFDEF WIN}
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function FileWrite(Handle: THandle; const Buffer; Count: DWord): DWord;
begin
     if not WriteFile(Handle, Buffer, Count, Result, nil) then
       Result := 0;
end;
{$ENDIF ASM_VERSION}
{$ENDIF WIN}
//[END FileWrite]

//[FUNCTION FileEOF]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function FileEOF( Handle: THandle ) : Boolean;
var Siz, Pos : DWord;
begin
  Siz := GetFileSize( Handle, nil );
  Pos := FileSeek( Handle, 0, spCurrent );
  Result := Pos >= Siz;
end;
{$ENDIF ASM_VERSION}
//[END FileEOF]

//[FUNCTION FileFullPath]
{$IFDEF WIN}
{$IFDEF ASM_noVERSION_UNICODE}
function FileFullPath( const FileName: AnsiString ) : AnsiString;
const
  BkSlash: AnsiString = '\';
  szTShFileInfo = sizeof( TShFileInfo );
asm
        PUSH     EBX
        PUSH     ESI
        MOV      EBX, EDX
        PUSH     EAX

        XCHG     EAX, EDX
        CALL     System.@LStrClr

        POP      EDX
        PUSH     0
        MOV      EAX, ESP
        CALL     System.@LStrAsg
        MOV      ESI, ESP

@@loo:  CMP      dword ptr [ESI], 0
        JZ       @@fin

        MOV      EAX, ESI
        MOV      EDX, [BkSlash]
        PUSH     0
        MOV      ECX, ESP
        CALL     Parse

        CMP      dword ptr [EBX], 0
        JE       @@1
        MOV      EAX, EBX
        MOV      EDX, [BkSlash]
        CALL     System.@LStrCat
        JMP      @@2
@@1:
        POP      EAX
        PUSH     EAX
        CALL     System.@LStrLen
        CMP      EAX, 2
        JNE      @@2
        POP      EAX
        PUSH     EAX
        CMP      byte ptr [EAX+1], ':'
        JNE      @@2

        MOV      EAX, EBX
        POP      EDX
        PUSH     EDX
        CALL     System.@LStrAsg
        JMP      @@3
@@2:
        PUSH     0
        MOV      EAX, ESP
        MOV      EDX, [EBX]
        CALL     System.@LStrAsg
        MOV      EAX, ESP
        MOV      EDX, [ESP+4]
        CALL     System.@LStrCat
        POP      EAX
        PUSH     EAX
        SUB      ESP, szTShFileInfo
        MOV      EDX, ESP
        PUSH     SHGFI_DISPLAYNAME
        PUSH     szTShFileInfo
        PUSH     EDX
        PUSH     0
        PUSH     EAX
        CALL     ShGetFileInfo
        LEA      EDX, [ESP].TShFileInfo.szDisplayName
        CMP      byte ptr [EDX], 0
        JE       @@clr_stk
        LEA      EAX, [ESP+szTShFileInfo+4]
        {$IFDEF _D2009orHigher}
        XOR      ECX, ECX
        {$ENDIF}
        CALL     System.@LStrFromPChar
@@clr_stk:
        ADD      ESP, szTShFileInfo
        CALL     RemoveStr
        POP      EDX
        PUSH     EDX
        MOV      EAX, EBX
        CALL     System.@LStrCat

@@3:    CALL     RemoveStr
        JMP      @@loo

@@fin:  CALL     RemoveStr
        POP      ESI
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
function FileFullPath( const FileName: KOLString ) : KOLString;
var SFI: TShFileInfo;
    Src, S: KOLString;
begin
  Result := '';
  Src := FileName;
  while Src <> '' do
  begin
    S := Parse( Src, '\' );
    if Result <> '' then
      Result := Result + '\';
    if (Result = '') and (Length( S ) = 2) and (S[ 2 ] = ':') then
      Result := S
    else
    begin
      {$IFDEF UNICODE_CTRLS} ShGetFileInfoW {$ELSE} ShGetFileInfoA {$ENDIF}
        ( PKOLChar( Result + S ), 0, SFI, Sizeof( SFI ), SHGFI_DISPLAYNAME );
      if SFI.szDisplayName[ 0 ] <> #0 then
        S := SFI.szDisplayName;
      Result := Result + S;
    end;
  end;
  if ExtractFileExt( Result ) = '' then
  // case when flag 'Hide extensions for registered file types' is set on
  // in the Explorer:
    Result := Result + ExtractFileExt( FileName );
end;
{$ENDIF ASM_VERSION}
{$ENDIF WIN}
//[END FileFullPath]

{$IFDEF WIN}
//[function FileShortPath]
function FileShortPath( const FileName: KOLString ): KOLString;
var Buf: array[ 0..MAX_PATH ] of KOLChar;
begin
  GetShortPathName( PKOLChar( FileName ), Buf, Sizeof( Buf ) );
  Result := Buf;
end;

//[function FileIconSystemIdx]
function FileIconSystemIdx( const Path: KOLString ): Integer;
var SFI: TShFileInfo;
begin
  SFI.iIcon := 0; // Bartov
  {$IFDEF UNICODE_CTRLS} ShGetFileInfoW {$ELSE} ShGetFileInfoA {$ENDIF}
    ( PKOLChar( Path ), 0, SFI, sizeof( SFI ), SHGFI_SMALLICON or SHGFI_SYSICONINDEX );
  Result := SFI.iIcon;
end;

//[function FileIconSysIdxOffline]
function FileIconSysIdxOffline( const Path: KOLString ): Integer;
var SFI: TShFileInfo;
begin
  SFI.iIcon := 0; // Bartov
  {$IFDEF UNICODE_CTRLS} ShGetFileInfoW {$ELSE} ShGetFileInfoA {$ENDIF}
    ( PKOLChar( Path ), FILE_ATTRIBUTE_NORMAL, SFI, sizeof( SFI ),
    SHGFI_SMALLICON or SHGFI_SYSICONINDEX or SHGFI_USEFILEATTRIBUTES );
  Result := SFI.iIcon;
end;
{$ENDIF WIN}

//[procedure LogFileOutput]
procedure LogFileOutput( const filepath, str: KOLString );
var F: THandle;
    Tmp: KOLString;
begin
  F := FileCreate( filepath, ofOpenWrite or ofOpenAlways or ofShareDenyWrite );
  if F = INVALID_HANDLE_VALUE then Exit;
  FileSeek( F, 0, spEnd );
  Tmp := str + {$IFDEF LIN} #10 {$ELSE} #13#10 {$ENDIF};
  FileWrite( F, PKOLChar( Tmp )^, Length( Tmp ) * Sizeof(KOLChar) );
  FileClose( F );
end;

//[function StrLoadFromFile]
function StrLoadFromFile( const Filename: KOLString ): AnsiString;
var F: THandle;
begin
  {$IFDEF WIN}
  if StrEq( Filename, 'CON' ) then
    Result := File2Str(GetStdHandle(STD_INPUT_HANDLE))
  else
  {$ENDIF WIN}
  begin
    Result := '';
    F := FileCreate( Filename, ofOpenRead or ofOpenExisting or ofShareDenyWrite );
    if F = INVALID_HANDLE_VALUE then Exit;
    Result := File2Str( F );
    FileClose( F ); {Dark Knight}
  end;
end;

function Str2File( Filename: PKOLChar; Str: PAnsiChar ): Boolean;
var L: Integer;
begin
  L := StrLen( Str );
  Result := Mem2File( Filename, Str, L ) = L;
end;

function WStr2File( Filename: PKOLChar; Str: PWideChar ): Boolean;
var L: Integer;
begin
  L := WStrLen( Str );
  Result := Mem2File( Filename, Str, L * Sizeof(WideChar) ) = L;
end;

//[function StrSaveToFile]
function StrSaveToFile( const Filename: KOLString; const Str: AnsiString ): Boolean;
begin
  Result := Mem2File( PKOLChar( Filename ), PAnsiChar( Str ), Length( Str ) )
            = Length( Str );
end;

{$IFNDEF _D2}
function WStrLoadFromFile( const Filename: KOLString ): WideString;
var F: THandle;
begin
  {$IFDEF WIN}
  if StrEq( Filename, 'CON' ) then
    Result := File2WStr(GetStdHandle(STD_INPUT_HANDLE))
  else
  {$ENDIF WIN}
  begin
    Result := '';
    F := FileCreate( Filename, ofOpenRead or ofOpenExisting or ofShareDenyWrite );
    if F = INVALID_HANDLE_VALUE then Exit;
    Result := File2WStr( F );
    FileClose( F ); {Dark Knight}
  end;
end;

function WStrSaveToFile( const Filename: KOLString; const Str: WideString ): Boolean;
var BytesToSave: Integer;
begin
  BytesToSave := Length( Str ) * Sizeof(WideChar);
  Result := Mem2File( PKOLChar( Filename ), PWideChar( Str ), BytesToSave )
            = BytesToSave; // fixed by zhoudi 
end;
{$ENDIF _D2}


//[function Mem2File]
function Mem2File( Filename: PKOLChar; Mem: Pointer; Len: Integer ): Integer;
var F: THandle;
begin
  Result := 0;
  F := FileCreate( Filename, ofOpenWrite or ofCreateAlways );
  if F = INVALID_HANDLE_VALUE then Exit;
  Result := FileWrite( F, Mem^, Len );
  FileClose( F );
end;

//[function File2Mem]
function File2Mem( Filename: PKOLChar; Mem: Pointer; MaxLen: Integer ): Integer;
var F: THandle;
begin
  Result := 0;
  F := FileCreate( Filename, ofOpenRead or ofOpenExisting or ofShareDenyWrite );
  if F = INVALID_HANDLE_VALUE then Exit;
  Result := FileRead( F, Mem^, MaxLen );
  FileClose( F );
end;

{$IFDEF WIN}
function Find_First( const FilePathName: KOLString; var F: TFindFileData ): Boolean;
begin
  F.FindHandle := FindFirstFile( PKOLChar( FilePathName ),
    {$IFDEF UNICODE_CTRLS} PWin32FindDataW {$ELSE} PWin32FindData {$ENDIF}
    ( @ F )^ );
  Result := F.FindHandle <> INVALID_HANDLE_VALUE;
end;
function Find_Next( var F: TFindFileData ): Boolean;
begin
  Result := FindNextFile( F.FindHandle,
      {$IFDEF UNICODE_CTRLS} PWin32FindDataW {$ELSE} PWin32FindData {$ENDIF}
      ( @ F )^ );
end;
procedure Find_Close( var F: TFindFileData );
begin
  Windows.FindClose( F.FindHandle );
end;
{$ENDIF WIN}

//[FUNCTION FileSize]
{$IFDEF WIN}
function FileSize( const Path: KOLString ) : {$IFDEF _D2orD3} Integer {$ELSE} Int64 {$ENDIF};
var FD : TFindFileData;
begin
  Result := 0;
  if not Find_First( Path, FD ) then exit;
  {$IFDEF _D2orD3}
  Result := FD.nFileSizeLow;
  {$ELSE}
  I64( Result ).Lo := FD.nFileSizeLow;
  I64( Result ).Hi := FD.nFileSizeHigh;
  {$ENDIF}
  Find_Close( FD );
end;
{$ENDIF WIN}
//[END FileSize]

//[procedure FileTime]
procedure FileTime( const Path: KOLString;
  CreateTime, LastAccessTime, LastModifyTime: PFileTime );
var FD : TFindFileData;
begin
  if not Find_First( Path, FD ) then exit;
  if CreateTime <> nil then
    CreateTime^ := FD.ftCreationTime;
  if LastAccessTime <> nil then
    LastAccessTime^ := FD.ftLastAccessTime;
  if LastModifyTime <> nil then
    LastModifyTime^ := FD.ftLastWriteTime;
  Find_Close( FD );
end;

//[function GetUniqueFilename]
function GetUniqueFilename( PathName: KOLString ) : KOLString;
var Path, Nam, Ext : KOLString;
    I, J, K : Integer;
begin
  Result := PathName;
  Path := ExtractFilePath( PathName );
  if not DirectoryExists( Path ) then Exit;
  Nam := ExtractFileNameWOext( PathName );
  if Nam = '' then
  begin
    Path := ExcludeTrailingPathDelimiter( Path );
    PathName := Path;
    Result := Path;
  end;
  Nam := ExtractFileNameWOext( PathName );
  Ext := ExtractFileExt( PathName );
  I := Length( Nam );
  for J := I downto 1 do
  if not ((Nam[ J ] >= '0') and (Nam[ J ] <= '9')) then
  begin
    I := J;
    break;
  end;
  K := Str2Int( CopyEnd( Nam, I + 1 ) );
  while FileExists( Result ) do
  begin
    Inc( K );
    Result := Path + Copy( Nam, 1, I ) + Int2Str( K ) + Ext;
  end;
end;

{$IFDEF WIN}
//[FUNCTION CompareSystemTime]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function CompareSystemTime(const D1, D2 : TSystemTime) : Integer;
var R: Integer;
   procedure CompareFields(const F1, F2 : Integer);
   begin
      if R <> 0 then Exit;
      if F1 = F2 then Exit;
      if F1 < F2 then
         R := -1
      else
         R := 1;
   end;
begin
   R := 0;
   CompareFields( D1.wYear, D2.wYear );
   CompareFields( D1.wMonth, D2.wMonth );
   CompareFields( D1.wDay, D2.wDay );
   CompareFields( D1.wHour, D2.wHour );
   CompareFields( D1.wMinute, D2.wMinute );
   CompareFields( D1.wSecond, D2.wSecond );
   CompareFields( D1.wMilliseconds, D2.wMilliseconds );
   Result := R;
end;
{$ENDIF ASM_VERSION}
//[END CompareSystemTime]

//[function FileTimeCompare]
function FileTimeCompare( const FT1, FT2 : TFileTime ) : Integer;
var ST1, ST2 : TSystemTime;
begin
  FileTimeToSystemTime( FT1, ST1 );
  FileTimeToSystemTime( FT2, ST2 );
  Result := CompareSystemTime( ST1, ST2 );
end;
{$ENDIF WIN}

{$IFDEF WIN}
//[FUNCTION DirectoryExists]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function DirectoryExists(const Name: KOLString): Boolean;
var
  Code: Integer;
  e: DWORD;
begin
  e := SetErrorMode( SEM_NOOPENFILEERRORBOX or SEM_FAILCRITICALERRORS );
  Code := GetFileAttributes(PKOLChar(Name));
  Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
  SetErrorMode( e );
end;
{$ENDIF ASM_VERSION}
//[END DirectoryExists]

function DiskPresent( const DrivePath: KOLString ): Boolean;
var e: DWORD;
    restore: Boolean;
begin
  e := 0;
  Restore := FALSE;
  if (Copy( DrivePath, 1, 2 ) = '\\') then
  else
  CASE GetDriveType( PKOLChar( DrivePath ) ) OF
  DRIVE_REMOVABLE, DRIVE_CDROM, DRIVE_RAMDISK:
    begin
      e := SetErrorMode( SEM_NOOPENFILEERRORBOX or SEM_FAILCRITICALERRORS );
      Restore := TRUE;
    end;
  END;
  Result := DirectoryExists( DrivePath );
  if Restore then
    SetErrorMode( e );
end;

{$IFDEF _D3orHigher}
function WDirectoryExists(const Name: WideString): Boolean;
var
  Code: Integer;
begin
  Code := GetFileAttributesW(PWideChar(Name));
  Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;
{$ENDIF _D3orHigher}

{$ENDIF WIN}

//[function CheckDirectoryContent]
function CheckDirectoryContent( const Name: KOLString; SubDirsOnly: Boolean; const Mask: AnsiString ): Boolean;
var FD: TFindFileData;
begin
  if not DirectoryExists( Name ) then
    Result := TRUE
  else
  begin
    if not Find_First( IncludeTrailingPathDelimiter( Name ) + Mask, FD ) then
      Result := TRUE
    else
    begin
      Result := TRUE;
      repeat
        if not {$IFDEF UNICODE_CTRLS}WStrIn{$ELSE}StrIn{$ENDIF}( FD.cFileName, ['.','..'] ) then
        begin
          if SubDirsOnly and LongBool(FD.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY)
             or not SubDirsOnly then
          begin
            Result := FALSE;
            break;
          end;
        end;
      until not Find_Next( FD );
      Find_Close( FD );
    end;
  end;
end;

//[function DirectoryEmpty]
function DirectoryEmpty(const Name: KOLString): Boolean;
begin
  Result := CheckDirectoryContent( Name, FALSE, '*.*' );
end;

//[function DirectoryHasSubdirs]
function DirectoryHasSubdirs( const Path: KOLString ): Boolean;
begin
  Result := not CheckDirectoryContent( Path, TRUE, '*.*' );
end;

//[FUNCTION GetStartDir]
{$IFDEF ASM_UNICODE}
function GetStartDir : AnsiString;
asm
        PUSH     EBX
        MOV      EBX, EAX

        XOR      EAX, EAX
        MOV      AH, 2
        SUB      ESP, EAX
        MOV      EDX, ESP
        PUSH     EAX
        PUSH     EDX
        PUSH     0
        CALL     GetModuleFileName // in KOL_ANSI

        LEA      EDX, [ESP + EAX]
@@1:    DEC      EDX
        CMP      byte ptr [EDX], '\'
        JNZ      @@1

        INC      EDX
        MOV      byte ptr [EDX], 0

        MOV      EAX, EBX
        MOV      EDX, ESP
        {$IFDEF _D2009orHigher}
        XOR      ECX, ECX
        {$ENDIF}
        CALL     System.@LStrFromPChar // AnsiSafe!

        ADD      ESP, 200h
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
  {$IFDEF WIN}
    {$UNDEF LINUX_USE_HOME_STARTFDIR}
  {$ENDIF}
function GetStartDir : KOLString;
{$IFNDEF LINUX_USE_HOME_STARTFDIR}
var Buffer:array[0..MAX_PATH] of KOLChar;
    I : Integer;
{$ENDIF}
begin
  {$IFDEF LINUX_USE_HOME_STARTFDIR}
    Result := getenv( 'HOME' );
  {$ELSE}
    I := GetModuleFileName( 0, Buffer, MAX_PATH );
    for I := I downto 0 do
      if Buffer[ I ] = {$IFDEF LIN} '/' {$ELSE} '\' {$ENDIF} then
      begin
        Buffer[ I + 1 ] := #0;
        break;
      end;
    Result := Buffer;
  {$ENDIF}
end;
{$ENDIF ASM_VERSION}
//[END GetStartDir]

//[FUNCTION ExePath]
function ExePath: KOLString;
var Buffer: array[ 0..MAX_PATH+1 ] of KOLChar;
begin
  Buffer[ MAX_PATH+1 ] := #0;
  GetModuleFileName( 0, Buffer, MAX_PATH+1 );
  Result := Buffer;
end;

function ModulePath: KOLString;
var Buffer: array[ 0..MAX_PATH+1 ] of KOLChar;
begin
  Buffer[ MAX_PATH+1 ] := #0;
  GetModuleFileName( hInstance, Buffer, MAX_PATH+1 );
  Result := Buffer;
end;

{-}
//[function DirectorySize]
function DirectorySize( const Path: KOLString ): I64;
var DirList: PDirList;
    I: Integer;
begin
  Result := MakeInt64( 0, 0 );
  DirList := NewDirList( Path, {$IFDEF LIN} '*' {$ELSE} '*.*' {$ENDIF}, 0 );
  for I := 0 to DirList.Count-1 do
  begin
    if LongBool( DirList.Items[ I ].dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY ) then
      Result := Add64( Result, DirectorySize( DirList.Path + DirList.Names[ I ] ) )
    else
      Result := Add64( Result, MakeInt64( DirList.Items[ I ].nFileSizeLow,
             DirList.Items[ I ].nFileSizeHigh ) );
  end;
  DirList.Free;
end;
{+}

{$IFDEF WIN} //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
//[function GetFileList]
function GetFileList(const dir: Ansistring): PStrList;
var
   Srch: TFindFileData;
   succ: Boolean;
begin
   result := nil;
   succ := Find_First(dir, Srch);
   while succ do begin
      if (not (Srch.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY > 0))then begin
         if Result = nil then begin
            Result := NewStrList;
         end;
         Result.Add(AnsiString(Srch.cFileName)); // TODO: because AStrList
      end;
      succ := Find_Next(Srch);
   end;
   Find_Close(Srch);
end;

{$ENDIF WIN}
//[function ExcludeTrailingChar]
function ExcludeTrailingChar( const S: KOLString; C: KOLChar ): KOLString;
begin
  Result := S;
  if Result <> '' then
  if Result[ Length( Result ) ] = C then
    Delete( Result, Length( Result ), 1 );
end;

//[function IncludeTrailingChar]
{$IFDEF ASM_UNICODE}
function IncludeTrailingChar( const S: KOLString; C: KOLChar ): KOLString;
asm
  push edx
  push ecx
  xchg ecx, eax
  xchg edx, ecx
  call System.@LStrAsg
  pop  eax
  pop  edx
  mov  ecx, [eax]
  jecxz @@1
  add  ecx, [ecx-4]
  dec  ecx
  cmp  byte ptr [ecx], dl
  jz   @@exit
@@1:
  push eax
  push 0
  mov  eax, esp
  {$IFDEF _D2009orHigher}
  //push ecx
  xor ecx, ecx
  {$ENDIF}
  call System.@LStrFromChar
  {$IFDEF _D2009orHigher}
  //pop  ecx
  {$ENDIF}
  mov  edx, [esp]
  mov  eax, [esp+4]
  call System.@LStrCat 
  call RemoveStr
  pop  eax
@@exit:
end;
{$ELSE PASCAL}
function IncludeTrailingChar( const S: KOLString; C: KOLChar ): KOLString;
begin
  Result := S;
  if (Result = '') or (Result[ Length( Result ) ] <> C) then
    Result := Result + C;
end;
{$ENDIF ASM_VERSION}


//---------------------------------------------------------
// Following functions/procedures are created by Edward Aretino:
// IncludeTrailingPathDelimiter, ExcludeTrailingPathDelimiter,
// ForceDirectories, CreateDir, ChangeFileExt
//---------------------------------------------------------
//[function IncludeTrailingPathDelimiter]
function IncludeTrailingPathDelimiter(const S: KOLString): KOLString;
begin
   Result := IncludeTrailingChar( S, {$IFDEF UNIX} '/' {$ELSE} '\' {$ENDIF} );
end;

//[function ExcludeTrailingPathDelimiter]
function ExcludeTrailingPathDelimiter(const S: KOLString): KOLString;
begin
   Result := ExcludeTrailingChar( S, {$IFDEF UNIX} '/' {$ELSE} '\' {$ENDIF} );
end;

function ExtractFileDrive( const Path: KOLString ) : KOLString;
var i, j: Integer;
begin
  Result := Path;
  if Result = '' then Exit;
  if pos( KOLString(':'), Result ) > 1 then
    Result := Parse( Result, ':' ) + ':\'
  else
  if Length( Result ) > 2 then
  begin
    j := 0;
    for i := 3 to Length( Result ) do
      if Result[ i ] = '\' then
      begin
        inc( j );
        if j = 2 then
        begin
          Result := Copy( Result, 1, i );
          break;
        end;
      end;
    Result := IncludeTrailingPathDelimiter( Result );
  end
    else
  if Length( Result ) = 1 then
    Result := Result + ':\';
end;

//[FUNCTION ExtractFilePath]
{$IFDEF ASM_LStrFromPCharLen} // LStrFromPCharLen - there are no in D2
function ExtractFilePath( const Path : AnsiString ) : AnsiString;
asm
        PUSH     EDX
        MOV      EDX, [DirDelimiters]
        CALL     EAX2PChar
        PUSH     EAX
        CALL     __DelimiterLast
        XCHG     EDX, EAX
        XOR      ECX, ECX  // ECX = 0
        POP      EAX
        CMP      byte ptr [EDX], CL
        JZ       @@ret_0
        SUB      EDX, EAX
        INC      EDX
        XCHG     EDX, EAX
        XCHG     ECX, EAX  // EAX = 0
@@ret_0:
        POP      EAX
        {$IFDEF _D2009orHigher}
        PUSH     0 
        {$ENDIF}
        CALL     System.@LStrFromPCharLen
end;
{$ELSE} //Pascal
function ExtractFilePath( const Path : KOLString ) : KOLString;
//var I : Integer;
var P, P0: PKOLChar;
begin
  P0 := PKOLChar( Path );
  P := __DelimiterLast( P0, ':\/' );
  if P^ = #0 then
    Result := ''
  else
    Result := Copy( Path, 1, P - P0 + 1 );
end;
{$ENDIF ASM_VERSION}

{$IFDEF _D3orHigher}
function WExtractFilePath( const Path: WideString ) : WideString;
var P, P0: PWideChar;
begin
  P0 := PWideChar( Path );
  P := W__DelimiterLast( P0, ':\/' );
  if P^ = #0 then
    Result := ''
  else
    Result := Copy( Path, 1, P - P0 + 1 );
end;
{$ENDIF}

{$IFDEF ASM_VERSION}
{$IFNDEF _D2}
{$DEFINE ASM_LStrFromPCharLen}
{$ENDIF}
{$ENDIF ASM_VERSION}

function IsNetworkPath( const Path: KOLString ): Boolean;
begin
  Result := (Length( Path ) >= 2) and (Path[1] = '\') and (Path[2] = '\');
end;

//[FUNCTION ExtractFileName]
{$IFDEF ASM_UNICODE}
const
  DirDelimiters: PAnsiChar = ':\/';
function ExtractFileName( const Path : AnsiString ) : AnsiString;
asm
        PUSH     EDX
        PUSH     EAX
        MOV      EDX, [DirDelimiters]
        CALL     __DelimiterLast
        POP      EDX
        CMP      byte ptr [EAX], 0
        JZ       @@1
        XCHG     EDX, EAX
        INC      EDX
@@1:    POP      EAX
        {$IFDEF _D2009orHigher}
        XOR      ECX, ECX 
        {$ENDIF}
        CALL     System.@LStrFromPChar // Safe!
end;
{$ELSE ASM_VERSION} //Pascal
function ExtractFileName( const Path : KOLString ) : KOLString;
var P: PKOLChar;
begin
  P := __DelimiterLast( PKOLChar( Path ), ':\/' );
  if P^ = #0 then
    Result := Path
  else
    Result := P + 1;
end;
{$ENDIF ASM_VERSION}
//[END ExtractFileName]

//[function ExtractFileNameWOext]
{$IFDEF ASM_UNICODE}
function ExtractFileNameWOext( const Path : KOLString ) : KOLString;
asm
  push ebx

  push edx
  push eax
  call ExtractFileName
  pop  edx // Path -   
  mov  eax, [esp] // eax = Result = ExtractFileName(Path)
  mov  eax, [eax]
  push 0
  mov  edx, esp
  call ExtractFileExt
  mov  eax, [esp]
  call System.@LStrLen
  xchg ebx, eax   // ebx = Length(ExtractFileExt(Result))
  call RemoveStr  // ExtractFileExt -   
  mov  eax, [esp]
  mov  eax, [eax]
  call System.@LStrLen // eax = Length(Result)
  sub  eax, ebx
  xchg ecx, eax
  xor  edx, edx
  inc  edx
  mov  eax, [esp]
  mov  eax, [eax]
  call System.@LStrCopy

  pop  ebx
end;
{$ELSE PASCAL}
function ExtractFileNameWOext( const Path : KOLString ) : KOLString;
begin
  Result := ExtractFileName( Path );
  Result := Copy( Result, 1, Length( Result ) - Length( ExtractFileExt( Result ) ) );
end;
{$ENDIF ASM_VERSION}

{$IFDEF ASM_UNICODE}
const
  ExtDelimeters: PAnsiChar = '.';

//[function ExtractFileExt]
function ExtractFileExt( const Path : KOLString ) : KOLString;
asm
        PUSH     EDX
        MOV      EDX, [ExtDelimeters]
        CALL     EAX2PChar
        CALL     __DelimiterLast
@@1:    XCHG     EDX, EAX
        POP      EAX
        {$IFDEF _D2009orHigher}
        PUSH     ECX
        XOR      ECX, ECX
        {$ENDIF}
        CALL     System.@LStrFromPChar
        {$IFDEF _D2009orHigher}
        POP      ECX // this routine hasn't touch ECX
        {$ENDIF}
end;
{$ELSE ASM_VERSION} //Pascal
function ExtractFileExt( const Path : KOLString ) : KOLString;
var P: PKOLChar;
begin
  P := __DelimiterLast( PKOLChar( Path ), '.' );
  Result := P;
end;
{$ENDIF ASM_VERSION}
//[END ExtractFilePath]

//[function ReplaceExt]
{$IFDEF ASM_UNICODE}
function ReplaceExt( const Path, NewExt: KOLString ): KOLString;
asm
  push ecx // result
  push edx // NewExt
  push eax // Path

  push 0
  mov  edx, esp
  call ExtractFilePath
  pop  eax
  xchg [esp], eax // eax=Path, Path in stack replaced with ExtractFilePath(Path)

  push 0
  mov  edx, esp
  call ExtractFileNameWOext
  // now stack conatins: result,NewExt,ExtractFilePath(Path),ExtractFileNameWOext(Path)<-ESP

  mov  eax, [esp+12]
  mov  edx, esp
  push dword ptr [edx+4] // ExtractFilePath(Path)
  push dword ptr [edx]   // ExtractFileNameWOext(Path)
  push dword ptr [edx+8] // NewExt
  mov  edx,  3
  call System.@LStrCatN
  call RemoveStr
  call RemoveStr
  pop  ecx
  pop  ecx
end;
{$ELSE PASCAL}
function ReplaceExt( const Path, NewExt: KOLString ): KOLString;
begin
  Result := ExtractFilePath( Path ) + ExtractFileNameWOext( Path ) +
    NewExt;
end;
{$ENDIF}

//[function ForceDirectories]
function ForceDirectories(Dir: KOLString): Boolean;
begin
 Result := Length(Dir) > 0; {Centronix}
 If not Result then Exit;
 Dir := ExcludeTrailingPathDelimiter(Dir);
 If (Length(Dir) < 3) or DirectoryExists(Dir) or
   (ExtractFilePath(Dir) = Dir) then Exit; // avoid 'xyz:\' problem.
 Result := ForceDirectories(ExtractFilePath(Dir)) and CreateDir(Dir);
end;

//[function CreateDir]
function CreateDir(const Dir: KOLString): Boolean;
begin
   Result := {$IFDEF WIN} {Windows.}CreateDirectory(PKOLChar(Dir), nil)
             {$ELSE LIN} Libc.__mkdir(PAnsiChar(Dir), S_IRWXU or S_IRWXG or S_IRWXO) = 0
             {$ENDIF};
end;

//[function ChangeFileExt]
function ChangeFileExt(FileName: KOLString; const Extension: KOLString): KOLString;
var
   FileExt: KOLString;
begin
   FileExt := ExtractFileExt(FileName);
   DeleteTail(FileName, Length(FileExt));
   Result := FileName+ Extension;
end;

//[function ReplaceFileExt]
function ReplaceFileExt( const Path, NewExt: KOLString ): KOLString;
begin
  Result := ExtractFilePath( Path ) +
            ExtractFileNameWOext( ExtractFileName( Path ) ) +
            NewExt;
end;

{$IFDEF WIN} //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
//[function ExtractShortPathName]
function ExtractShortPathName( const Path: KOLString ): KOLString;
var
  Buffer: array[0..MAX_PATH - 1] of KOLChar;
begin
  SetString(Result, Buffer,
    GetShortPathName(PKOLChar(Path), Buffer, SizeOf(Buffer) div Sizeof(KOLChar)));
end;

{$IFDEF GDI}
//[function FilePathShortened]
function FilePathShortened( const Path: KOLString; MaxLen: Integer ): KOLString;
begin
  Result := FilePathShortenPixels( Path, 0, MaxLen );
end;

//[function PixelsLength]
function PixelsLength( DC: HDC; const Text: KOLString ): Integer;
var Sz: TSize;
begin
  if DC = 0 then
    Result := Length( Text )
  else
  begin
    {$IFDEF UNICODE_CTRLS}Windows.GetTextExtentPoint32W
    {$ELSE}               Windows.GetTextExtentPoint32A
    {$ENDIF}( DC, PKOLChar( Text ), Length( Text ), Sz );
    Result := Sz.cx;
  end;
end;

//[function FilePathShortenPixels]
function FilePathShortenPixels( const Path: KOLString; DC: HDC; MaxPixels: Integer ): KOLString;
var L0, L1: Integer;
    Prev: KOLString;
begin
 Result := Path;
 L0 := PixelsLength( DC, Result );
 while L0 > MaxPixels do
 begin
   Prev := Result;
   L1 := pos( KOLString('\...\'), Result ); // ambiguous
   if L1 <= 0 then
     Result := ExcludeTrailingPathDelimiter( ExtractFilePath( Result ) )
   else
     Result := Copy( Result, 1, L1 - 1 );
   if Result <> '' then
     Result := IncludeTrailingPathDelimiter( ExtractFilePath( Result ) ) + '...\' + ExtractFileName( Path );
   if (Result = '') or (Result = Prev) then
   begin
     L1 := Length( ExtractFilePath( Result ) );
     while (PixelsLength( DC, Result ) > MaxPixels) and (L1 > 1) do
     begin
       Dec( L1 );
       Result := Copy( Result, 1, L1 ) + '...\' + ExtractFileName( Result );
     end;
     if PixelsLength( DC, Result ) > MaxPixels then
     begin
       L1 := MaxPixels + 1;
       while ((MaxPixels > 0) and (L1 > 1) or (MaxPixels = 0) and (L1 > 0)) and
             (PixelsLength( DC, Result ) > MaxPixels) do
       begin
         Dec( L1 );
         Result := Copy( ExtractFileName( Path ), 1, L1 ) + '...';
       end;
     end;
     break;
   end;
   L0 := PixelsLength( DC, Result );
 end;
end;
{$ENDIF GDI}

//[procedure CutFirstDirectory]
procedure CutFirstDirectory(var S: KOLString);
var
  Root: Boolean;
  P: Integer;
begin
  if S = '\' then
    S := ''
  else
  begin
    if S[1] = '\' then
    begin
      Root := True;
      Delete(S, 1, 1);
    end
    else
      Root := False;
    if S[1] = '.' then
      Delete(S, 1, 4);
    P := Pos( KOLString('\'), S ); 
    if P <> 0 then
    begin
      Delete(S, 1, P);
      S := '...\' + S;
    end
    else
      S := '';
    if Root then
      S := '\' + S;
  end;
end;

{$IFDEF GDI}
//[function MinimizeName]
function MinimizeName( const Path: KOLString; DC: HDC; MaxPixels: Integer ): KOLString;
var
  Drive, Dir, Name: KOLString;
begin
  Result := Path;
  Dir := ExtractFilePath(Result);
  Name := ExtractFileName(Result);

  if (Length(Dir) >= 2) and (Dir[2] = ':') then
  begin
    Drive := Copy(Dir, 1, 2);
    Delete(Dir, 1, 2);
  end
  else
    Drive := '';
  while ((Dir <> '') or (Drive <> '')) and (PixelsLength(DC, Result) > MaxPixels) do
  begin
    if Dir = '\...\' then
    begin
      Drive := '';
      Dir := '...\';
    end
    else if Dir = '' then
      Drive := ''
    else
      CutFirstDirectory(Dir);
    Result := Drive + Dir + Name;
  end;
end;
{$ENDIF GDI}

//[function GetSystemDir]
function GetSystemDir: KOLString;
var Buf: array[ 0..MAX_PATH ] of KOLChar;
begin
  GetSystemDirectory( @ Buf[ 0 ], MAX_PATH + 1 );
  Result := IncludeTrailingPathDelimiter( PKOLChar( @ Buf[ 0 ] ) );
end;

//*
//[function GetWindowsDir]
function GetWindowsDir : KOLString;
var Buf : array[ 0..MAX_PATH ] of KOLChar;
begin
  GetWindowsDirectory( @Buf[ 0 ], MAX_PATH + 1 );
  Result := IncludeTrailingPathDelimiter( PKOLChar( @ Buf[ 0 ] ) );
end;
{$ENDIF WIN} //^^^^^^^^^^^

//[function GetWorkDir]
{$IFDEF WIN}
function GetWorkDir : KOLString;
var Buf: array[ 0..MAX_PATH ] of KOLChar;
begin
  GetCurrentDirectory( MAX_PATH + 1, @ Buf[ 0 ] );
  Result := IncludeTrailingPathDelimiter( PKOLChar( @ Buf[ 0 ] ) );
end;
{$ENDIF WIN}

//[function GetTempDir]
{$IFDEF ASM_UNICODE}
function GetTempDir : KOLString; 
asm
  push eax
  sub esp, 264
  push esp
  push 261
  call GetTempPath
  mov  edx, esp
  mov  eax, [esp+264]
  {$IFDEF _D2009orHigher}
  xor  ecx, ecx 
  {$ENDIF}
  call System.@LStrFromPChar
  add esp, 264
  pop edx
  mov eax, [edx]
  call IncludeTrailingPathDelimiter
end;
{$ELSE PASCAL}
function GetTempDir : KOLString;
{$IFDEF WIN} var Buf : Array[ 0..MAX_PATH ] of KOLChar; {$ENDIF WIN}
begin
  {$IFDEF LIN} Result := '/tmp/'; {$ELSE WIN}
  GetTempPath( MAX_PATH + 1, @Buf[ 0 ] );
  Result := IncludeTrailingPathDelimiter( PKOLChar( @ Buf[ 0 ] ) );
  {$ENDIF WIN}
end;
{$ENDIF}

{$IFDEF WIN}
//[function CreateTempFile]
{$IFDEF ASM_UNICODE}
function CreateTempFile( const DirPath, Prefix: KOLString ): KOLString;
asm
  push ecx
  call EAX2PCHAR
  call EDX2PCHAR
  sub  esp, 264
  push esp
  push 0
  push edx
  push eax
  call GetTempFileName
  mov  eax, [esp+264]
  mov  edx, esp
  {$IFDEF _D2009orHigher}
  xor ecx, ecx // ecx is argument
  {$ENDIF}
  call System.@LStrFromPChar 
  add  esp, 268
end;
{$ELSE PASCAL}
function CreateTempFile( const DirPath, Prefix: KOLString ): KOLString;
var Buf: array[ 0..MAX_PATH ] of KOLChar;
begin
  GetTempFileName( PKOLChar( DirPath ), PKOLChar( Prefix ), 0, Buf );
  Result := Buf;
end;
{$ENDIF ASM_VERSION}
{$ENDIF WIN}

//[function GetFileListStr]
function GetFileListStr(FPath{e.g.'c:\tmp\'}, FMask{e.g.'*.*'}: KOLString): KOLString;
{* List of files in string, separating each path from others with FileOpSeparator.
   E.g.: 'c:\tmp\unit1.dcu'#13'c:\tmp\unit1.~pa' (for use with DeleteFile2Recycle())}
var
   Srch: TFindFileData;
   succ: Boolean;
   dir:KOLString;
begin
   result := '';
   if (FPath<>'') then FPath := IncludeTrailingPathDelimiter( FPath );
   if (FMask<>'') and (FMask[1]={$IFDEF LIN} '/' {$ELSE} '\' {$ENDIF}) then
     FMask := CopyEnd(FMask,2);
   dir:=FPath+FMask;
   succ := Find_First(dir, Srch);
   while succ do begin
      if (not (Srch.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY > 0))then begin
         if Result<>''then Result:=Result+FileOpSeparator;
         Result:=Result+FPath+Srch.cFileName;
      end;
      succ := Find_Next(Srch);
   end;
   Find_Close(Srch);
end;

//[function DeleteFiles]
function DeleteFiles( const DirPath: KOLString ): Boolean;
var Files, Name: KOLString;
begin
  Files := GetFileListStr( ExtractFilePath( DirPath ), ExtractFileName( DirPath ) );
  Result := TRUE;
  while Files <> '' do
  begin
    Name := Parse( Files, FileOpSeparator );
    Result := Result and DeleteFile( PKOLChar( Name ) );
  end;
end;

{$IFDEF WIN_GDI} //>>>>>>>>>>>>
//[function DeleteFile2Recycle]
function DeleteFile2Recycle( const Filename : KOLString ) : Boolean;
begin
  Result := DoFileOp( Filename, '', FO_DELETE, FOF_ALLOWUNDO or
    FOF_NOCONFIRMATION or FOF_SIMPLEPROGRESS, 'Deleting...' );
end;

//[function CopyMoveFiles]
function CopyMoveFiles( const FromList, ToList: KOLString; Move: Boolean ): Boolean;
begin
  Result := DoFileOp(FromList, ToList, FO_COPY - Integer( Move ),
  FOF_ALLOWUNDO, nil);                   //|\\ FO_COPY = 2, FO_MOVE = 1

end;

{-}
//[function DiskFreeSpace]
function DiskFreeSpace( const Path: KOLString ): I64;
type TGetDFSEx = function( Path: PKOLChar; CallerFreeBytes, TotalBytes, FreeBytes: Pointer )
                 : Bool; stdcall;
var GetDFSEx: TGetDFSEx;
    Kern32: THandle;
    V: TOSVersionInfo;
    Ex: Boolean;
    SpC, BpS, NFC, TNC: DWORD;
    FBA, TNB: I64;
begin
  GetDFSEx := nil;
  V.dwOSVersionInfoSize := Sizeof( V );
  GetVersionEx
    ( POSVersionInfo( @ V )^ ); // bug in Windows.pas !
  Ex := FALSE;
  if V.dwPlatformId = VER_PLATFORM_WIN32_NT then
  begin
    Ex := V.dwMajorVersion >= 4;
  end
    else
  if V.dwPlatformId = VER_PLATFORM_WIN32_WINDOWS then
  begin
    Ex := V.dwMajorVersion > 4;
    if not Ex then
    if V.dwMajorVersion = 4 then
    begin
      Ex := V.dwMinorVersion > 0;
      if not Ex then
        Ex := LoWord( V.dwBuildNumber ) >= $1111;
    end;
  end;
  if Ex then
  begin
    Kern32 := GetModuleHandle( 'kernel32' );
    GetDFSEx := GetProcAddress( Kern32, 'GetDiskFreeSpaceExA' );
  end;
  if Assigned( GetDFSEx ) then
    GetDFSEx( PKOLChar( Path ), @ FBA, @ TNB, @Result )
  else
  begin
    GetDiskFreeSpace( PKOLChar( Path ), SpC, BpS, NFC, TNC );
    Result := Mul64i( MakeInt64( SpC * BpS, 0 ), NFC );
  end;
end;
{+}

//[END FILES]

//[function DoFileOp]
function DoFileOp( const FromList, ToList: KOLString; FileOp: UINT; Flags: Word;
  Title: PKOLChar): Boolean;
var FOS : {$IFDEF UNICODE_CTRLS}TSHFileOpStructW{$ELSE}TSHFileOpStruct{$ENDIF};
    Buf : PKOLChar;
    L : Integer;
begin
  L := Length( FromList );
  Buf := AllocMem( L+2 );
  Move( FromList[ 1 ], Buf^, L );
  for L := L downto 0 do
    if Buf[ L ] = FileOpSeparator then Buf[ L ] := #0;
  FillChar( FOS, Sizeof( FOS ), #0 );
  if Applet <> nil then
    FOS.Wnd := Applet.Handle;
  FOS.wFunc := FileOp;
  FOS.lpszProgressTitle := Title;
  FOS.pFrom := Buf;
  FOS.pTo := PKOLChar( ToList + #0 );
  FOS.fFlags := Flags;
  FOS.fAnyOperationsAborted := True;
  Result := {$IFDEF UNICODE_CTRLS}SHFileOperationW{$ELSE}SHFileOperationA{$ENDIF}( FOS ) = 0;
  if Result then
    Result := not FOS.fAnyOperationsAborted;
  FreeMem( Buf );
end;
{$ENDIF WIN_GDI}

{$IFDEF WIN}
//[function DirIconSysIdxOffline]
function DirIconSysIdxOffline( const Path: KOLString ): Integer;
var SFI: TShFileInfo;
begin
  SFI.iIcon := 0; // Bartov
  {$IFDEF UNICODE_CTRLS} ShGetFileInfoW {$ELSE} ShGetFileInfoA {$ENDIF}
    ( PKOLChar( Path ), FILE_ATTRIBUTE_DIRECTORY, SFI, sizeof( SFI ),
    SHGFI_SMALLICON or SHGFI_SYSICONINDEX or SHGFI_USEFILEATTRIBUTES );
  Result := SFI.iIcon;
end;
{$ENDIF WIN}

{ TDirList }

//[function NewDirList]
function NewDirList( const DirPath, Filter: KOLString; Attr: DWORD ): PDirList;
begin
  {-}
  New( Result, Create );
  {+}{++}(*Result := PDirList.Create;*){--}
  Result.ScanDirectory( DirPath, Filter, Attr );
end;
//[END NewDirList]

//[function NewDirListEx]
function NewDirListEx( const DirPath, Filters: KOLString; Attr: DWORD ): PDirList;
begin
  {-}
  New( Result, Create );
  {+}{++}(*Result := PDirList.Create;*){--}
  Result.ScanDirectoryEx( DirPath, Filters, Attr );
end;
//[END NewDirListEx]

//[procedure TDirList.Clear]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TDirList.Clear;
begin
  if FList <> nil then
    FList.Release;
  FList := nil;
end;
{$ENDIF ASM_VERSION}

//[destructor TDirList.Destroy]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
destructor TDirList.Destroy;
begin
  Clear;
  FPath := '';
  inherited;
end;
{$ENDIF ASM_VERSION}

//[FUNCTION FindFilter]
{$IFDEF ASM_UNICODE}
function FindFilter( const Filter: AnsiString): AnsiString;
asm
        XCHG     EAX, EDX
        PUSH     EAX
        CALL     System.@LStrAsg
        POP      EAX
        CMP      dword ptr [EAX], 0
        JNE      @@exit
        LEA      EDX, @@mask_all
        {$IFDEF _D2009orHigher}
        XOR      ECX, ECX 
        {$ENDIF}
        JE       System.@LStrFromPChar
@@mask_all:  DB  '*.*',0
@@exit:
end;
{$ELSE ASM_VERSION} //Pascal
function FindFilter(const Filter: KOLString): KOLString;
begin
  Result := Filter;
  if Result = '' then Result := '*.*';
end;
{$ENDIF ASM_VERSION}
//[END FindFilter]

//+
//[function TDirList.Get]
function TDirList.Get(Idx: Integer): PFindFileData;
begin
  Result := FList.Items[ Idx ];
end;

//[function TDirList.GetCount]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function TDirList.GetCount: Integer;
begin
  Result := 0;
  if FList = nil then Exit;
  Result := FList.Count;
end;
{$ENDIF ASM_VERSION}

//[function TDirList.GetNames]
{$IFDEF ASM_UNICODE}
function TDirList.GetNames(Idx: Integer): Ansistring;
asm
        MOV      EAX, [EAX].fList
        {$IFDEF TLIST_FAST}
        PUSH     ECX
        CALL     TList.Get
        LEA      EDX, [EAX + offset TWin32FindData.cFileName] //
        POP      EAX
        {$IFDEF _D2009orHigher}
        XOR      ECX, ECX
        {$ENDIF}
        CALL     System.@LStrFromPChar
        {$ELSE}
        MOV      EAX, [EAX].TList.fItems
        MOV      EDX, [EAX + EDX*4]
        ADD      EDX, offset TWin32FindData.cFileName //
        MOV      EAX, ECX
          {$IFDEF _D2009orHigher}
          XOR      ECX, ECX 
          {$ENDIF}
        CALL     System.@LStrFromPChar
        {$ENDIF}
end;
{$ELSE ASM_VERSION} //Pascal
function TDirList.GetNames(Idx: Integer): KOLString;
begin
  Result := PKOLChar(@PFindFileData(fList.Items[ Idx ]).cFileName[0]);
end;
{$ENDIF ASM_VERSION}

//[function TDirList.GetIsDirectory]
function TDirList.GetIsDirectory(Idx: Integer): Boolean;
begin
  Result := LongBool( Items[ Idx ].dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY );
end;

{$IFDEF ASM_noVERSION}
//[function TDirList.SatisfyFilter]
function TDirList.SatisfyFilter(FileName: PAnsiChar; FileAttr,
  FindAttr: DWord): Boolean;
asm
        PUSH     EBX
        PUSH     ESI
        PUSH     EDI
        XCHG     EBX, EAX // EBX = @ Self
        MOV      EAX, [FindAttr]
        MOV      EDI, EDX // EDI = FileName
        MOV      EDX, EAX
        AND      EDX, ECX
        CMP      EDX, EAX
        JE       @@1

        TEST AL, FILE_ATTRIBUTE_NORMAL
        JZ      @@ret_false
@@1:
        CMP      word ptr [EDI], '.'
        JE       @@1_1
        CMP      word ptr [EDI], '..'
        JNE      @@1_1
        CMP      byte ptr [EDI+2], 0
        JNE      @@1_1
@@1_0:
        MOV      ECX, [FindAttr]
        TEST     CL, FILE_ATTRIBUTE_NORMAL
        JZ       @@1_1
        CMP      ECX, FILE_ATTRIBUTE_NORMAL
        JE       @@1_1
        TEST     AL, FILE_ATTRIBUTE_DIRECTORY
        JZ       @@1_1
        TEST     CL, FILE_ATTRIBUTE_DIRECTORY
        JNZ      @@ret_true

@@1_1:
        MOV      ECX, [EBX].fFilters
        JECXZ    @@ret_false //?

        MOV      ESI, [ECX].TStrList.fList
        MOV      ESI, [ESI].TList.fItems
        MOV      ECX, [ECX].TStrList.fCount
        JECXZ    @@ret_false

@@2:
        LODSD
        TEST     EAX, EAX
        JZ       @@nx_filter

        PUSHAD

        MOV      EDX, [EAX]
        CMP      DX, $002E
        JE       @@F_d_dd
        AND      EDX, $FFFFFF
        CMP      EDX, $002E2E
        JE       @@F_d_dd

        MOV      EDX, [EDI]
        CMP      DX, $002E
        JE       @@4
        AND      EDX, $FFFFFF
        CMP      EDX, $002E2E
        JE       @@4
        JMP      @@chk_anti

@@F_d_dd:
        MOV      EDX, EDI
        PUSH     EAX
        CALL     StrComp
        TEST     EAX, EAX
        POP      EAX
        JZ       @@popad_ret_true

@@chk_anti:
        XCHG     EDX, EAX // EDX = filter[ i ]
        MOV      EAX, EDI // EAX = FileName
        CMP      byte ptr [EDX], '^'
        JNE      @@3

        INC      EDX
        CALL     _2StrSatisfy
        TEST     AL, AL
        JZ       @@4
        POPAD
        JMP      @@ret_false

@@3:    CALL     _2StrSatisfy
        TEST     AL, AL
        JZ       @@4
@@popad_ret_true:
        POPAD
@@ret_true:
        MOV      AL, 1
        JMP      @@exit

@@4:    POPAD
@@nx_filter:
        LOOP     @@2

@@ret_false:
        XOR      EAX, EAX
@@exit:
        POP      EDI
        POP      ESI
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
function TDirList.SatisfyFilter(FileName: PKOLChar; FileAttr,
  FindAttr: DWord): Boolean;
{$IFDEF F_P}
const Dot: AnsiString = '.';
{$ENDIF F_P}
var I: Integer;
    F: PKOLChar;
    HasOnlyNegFilters: Boolean;
begin
  Result := (((FileAttr and FindAttr) = FindAttr) or
            LongBool(FindAttr and FILE_ATTRIBUTE_NORMAL));
  if not Result then Exit;

  if (FileName <> {$IFDEF UNICODE_CTRLS} WideString( '.' )
                  {$ELSE} {$IFDEF F_P}Dot{$ELSE}'.'{$ENDIF}
                  {$ENDIF UNICODE_CTRLS} ) and
     (FileName <> '..') then
  if LongBool( FindAttr and FILE_ATTRIBUTE_NORMAL ) and
     (FindAttr <> FILE_ATTRIBUTE_NORMAL) then
     if LongBool( FindAttr and FILE_ATTRIBUTE_DIRECTORY ) and
        LongBool( FileAttr and FILE_ATTRIBUTE_DIRECTORY ) then Exit;

  HasOnlyNegFilters := TRUE;
  for I := 0 to fFilters.Count - 1 do
  begin
    F := PKOLChar(fFilters.fList.Items[ I ]);
    if F = '' then continue;

    if (F = {$IFDEF UNICODE_CTRLS} WideString( '.' ) {$ELSE}
            {$IFDEF F_P}Dot{$ELSE}'.'{$ENDIF}
            {$ENDIF UNICODE_CTRLS} ) or (F = '..') then
    begin
      if FileName = F then
        Exit;
    end
      else
    if (Filename = {$IFDEF UNICODE_CTRLS} WideString( '.' ) {$ELSE}
                   {$IFDEF F_P}Dot{$ELSE}'.'{$ENDIF}
                   {$ENDIF UNICODE_CTRLS} ) or (FileName = '..') then
      continue;

    if F[ 0 ] = '^' then
    begin
      if StrSatisfy( FileName, PKOLChar(@F[ 1 ]) ) then
      begin
         Result := False;
         Exit;
      end;
    end
      else
    begin
      HasOnlyNegFilters := FALSE;
      if StrSatisfy( FileName, F ) then
      begin
        Result := True;
        Exit;
      end;
    end;
  end;

  Result := HasOnlyNegFilters and
            (FileName <> {$IFDEF UNICODE_CTRLS} WideString( '.' ) {$ELSE}
                         {$IFDEF F_P}Dot{$ELSE}'.'{$ENDIF}
                         {$ENDIF UNICODE_CTRLS} ) and (FileName <> '..');
end;
{$ENDIF ASM_VERSION}

{$IFDEF ASM_nononoVERSION}
//[procedure TDirList.ScanDirectory]
procedure TDirList.ScanDirectory(const DirPath, Filter: KOLString;
  Attr: DWord);
const   sz_win32finddata = sizeof(TWin32FindData);
asm
        PUSH     EBX
        PUSH     EDI
        MOV      EBX, EAX

        PUSHAD
        CALL     Clear
        CALL     NewList
        MOV      [EBX].fList, EAX
        POPAD

        PUSHAD
        LEA      EAX, [EBX].fPath
        CALL     System.@LStrAsg
        POPAD

        MOV      EAX, [EBX].fPath
        TEST     EAX, EAX
        JE       @@exit

        PUSHAD
        LEA      EDX, [EBX].fPath
        MOV      EAX, [EDX]
        CALL     IncludeTrailingPathDelimiter

        MOV      EAX, [EBX].fFilters
        TEST     EAX, EAX
        JNZ      @@1
        CALL     NewStrList
        MOV      [EBX].fFilters, EAX
        POPAD

        PUSHAD
        PUSH     ECX
        XCHG     EAX, ECX
        MOV      EDX, offset[@@star_d_star]
        CALL     StrComp
        TEST     AL, AL
        POP      EDX
        JNZ      @@asg_Filter
        MOV      EDX, offset[@@star]
@@asg_Filter:
        MOV      EAX, [EBX].fFilters
        CALL     TStrList.Add
        JMP      @@1

@@star_d_star:
        DB       '*.*', 0 // PCHAR
        
        {$IFDEF _D2009orHigher}
        DW       0, 1 
        {$ENDIF}
        DD       -1, 1
@@star: DB       '*', 0

@@1:
        POPAD

        ADD      ESP, -sz_win32finddata
        XOR      EDX, EDX
        PUSH     EDX
        PUSH     EDX
        XCHG     EAX, ECX
        MOV      EDX, ESP
        CALL     FindFilter

        LEA      EAX, [ESP+4]
        MOV      EDX, [EBX].fPath
        POP      ECX
        PUSH     ECX
        CALL     System.@LStrCat3
        CALL     RemoveStr

        POP      EAX
        MOV      EDX, ESP
        PUSH     EAX
        PUSH     EDX
        PUSH     EAX
        CALL     FindFirstFile
        MOV      EDI, EAX
        INC      EAX
        MOV      EAX, ESP

        PUSHFD
        CALL     System.@LStrClr
        POPFD
        POP      ECX

        JZ       @@fin

@@loop:
        MOV      ECX, [ESP].TWin32FindData.dwFileAttributes
        PUSH     [Attr]
        LEA      EDX, [ESP+4].TWin32FindData.cFileName
        MOV      EAX, EBX
        CALL     SatisfyFilter

        TEST     AL, AL
        JZ       @@next

        MOV      ECX, [EBX].fOnItem.TMethod.Code
        JECXZ    @@accept
        MOV      EAX, [EBX].fOnItem.TMethod.Data
        MOV      ECX, ESP
        PUSH     1
        MOV      EDX, ESP
        PUSH     EDX
        MOV      EDX, EBX
        CALL     dword ptr [EBX].fOnItem.TMethod.Code
        POP      ECX
        JECXZ    @@next
        LOOP     @@fin

@@accept:
        MOV      EAX, sz_win32finddata
        PUSH     EAX
          CALL     System.@GetMem
          PUSH     EAX
            XCHG     EDX, EAX
            MOV      EAX, [EBX].fList
            CALL     TList.Add
          POP      EDX
        POP      ECX
        MOV      EAX, ESP
        CALL     System.Move

@@next:
        PUSH     ESP
        PUSH     EDI
        CALL     FindNextFile
        TEST     EAX, EAX
        JNZ      @@loop

        PUSH     EDI
        CALL     FindClose

@@fin:
        ADD      ESP, sz_win32finddata
@@exit:
        XOR      EAX, EAX
        XCHG     EAX, [EBX].fFilters
        CALL     TObj.Free
        POP      EDI
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
procedure TDirList.ScanDirectory(const DirPath, Filter: KOLString;
  Attr: DWord);
var FindData : TFindFileData;
    E : PFindFileData;
    Action: TDirItemAction;
    {$IFDEF FORCE_ALTERNATEFILENAME}
    IsUnicode: AnsiString;
    {$ENDIF}
begin
  Clear;
  FPath := DirPath;
  if FPath = '' then Exit;
  FPath := IncludeTrailingPathDelimiter( FPath );
  if not Assigned(fFilters) then 
  begin
    fFilters := {$IFDEF UNICODE_CTRLS} NewWStrList {$ELSE} NewStrList {$ENDIF};
    if Filter = '*.*' then
      fFilters.Add( '*' )
    else
      fFilters.Add( Filter );
  end;
  if Find_First( PKOLChar( FPath + FindFilter( Filter ) ), FindData ) then 
  begin // D[u]fa. fix mem leaks (FList, fFilters)
    FList := NewList;
  while True do
  begin
      {$IFDEF FORCE_ALTERNATEFILENAME} //+MtsVN
    IsUnicode := FindData.cFileName;
    if (IsUnicode <> '.') and (IsUnicode <> '..') then
    begin
     if pos('?', IsUnicode) > 0 then
         CopyMemory( @FindData.cFileName, @FindData.cAlternateFileName,
                     SizeOf(FindData.cAlternateFileName));
    end;
    {$ENDIF}
    if SatisfyFilter( PKOLChar(@FindData.cFileName[0]),
                      FindData.dwFileAttributes, Attr ) then
    begin
      Action := diAccept;
      if Assigned( OnItem ) then
        OnItem( @Self, FindData, Action );
      CASE Action OF
      diSkip: ;
      diAccept:
        begin
          GetMem( E, Sizeof( FindData ) );
          E^ := FindData;
          FList.Add( E );
        end;
      diCancel: break;
      END;
    end;
    if not Find_Next( FindData ) then break;
  end;
  Find_Close( FindData );
  end;
  Free_And_Nil(fFilters);                                                       //D[u]fa
end;
{$ENDIF ASM_VERSION}

//[procedure TDirList.ScanDirectoryEx]
{$IFDEF ASM_UNICODE}
procedure TDirList.ScanDirectoryEx(const DirPath, Filters: AnsiString;
  Attr: DWord);
asm
        PUSH     EBX
        MOV      EBX, EAX

        PUSHAD
        LEA      EAX, [EBX].fFilters
        CALL     Free_And_Nil

        CALL     NewStrList
        MOV      [EBX].fFilters, EAX
        POPAD

        PUSHAD
        PUSH     0
        MOV      EAX, ESP
        MOV      EDX, ECX
        CALL     System.@LStrLAsg
@@1:    MOV      ECX, [ESP]
        JECXZ    @@2
        MOV      EAX, ESP
        MOV      EDX, offset[@@semicolon]
        PUSH     0
        MOV      ECX, ESP
        CALL     Parse
        MOV      EAX, [ESP]
        MOV      EDX, ESP
        CALL     Trim
        POP      EDX
        PUSH     EDX
        TEST     EDX, EDX
        JZ       @@filt_added
        MOV      EAX, [EBX].fFilters
        CALL     TStrList.Add
@@filt_added:
        CALL     RemoveStr
        JMP      @@1

        //       ';' string literal
        {$IFDEF _D2009orHigher}
        DW       0, 1 
        {$ENDIF}
        DD       -1, 1
@@semicolon:
        DB       ';',0

@@2:    POP      ECX
        POPAD
        XOR      ECX, ECX
        PUSH     [Attr]
        CALL     ScanDirectory
        POP      EBX
@@exit:
end;
{$ELSE ASM_VERSION} //Pascal
procedure TDirList.ScanDirectoryEx(const DirPath, Filters: KOLString;
  Attr: DWord);
var F, FF: KOLString;
begin
  FF := Filters;
  Free_And_Nil( fFilters );
  fFilters := {$IFDEF UNICODE_CTRLS} NewWStrList {$ELSE} NewStrList {$ENDIF};
  repeat
    F := Trim( Parse( FF, ';' ) );
    if F <> '' then
      fFilters.Add( F );
  until FF = '';
  ScanDirectory( DirPath, '', Attr );
end;
{$ENDIF ASM_VERSION}

type
  PSortDirData = ^TSortDirData;
  TSortDirData = packed Record
    FoldersFirst, CaseSensitive : Boolean;
    Rules : array[ 0..11 ] of TSortDirRules;
    Dir : PDirList;
  end;

//[FUNCTION CompareDirItems]
{$DEFINE CompareDirItems_ASM}
{$IFNDEF ASM_VERSION} {$UNDEF CompareDirItems_ASM} {$ENDIF}
{$IFDEF TLIST_FAST}   {$UNDEF CompareDirItems_ASM} {$ENDIF}
{$IFDEF CompareDirItems_ASM} {$DEFINE SwapDirItems_ASM} {$ENDIF}

//[PROCEDURE SwapDirItems]
{$IFDEF SwapDirItems_ASM}
{$ELSE ASM_VERSION} //Pascal
procedure SwapDirItems( const Data : PSortDirData; const e1, e2 : DWORD );
var Tmp : Pointer;
begin
  Tmp := Data.Dir.FList.{$IFDEF TLIST_FAST} Items {$ELSE} fItems {$ENDIF} [ e1 ];
  Data.Dir.FList.{$IFDEF TLIST_FAST} Items {$ELSE} fItems {$ENDIF}[ e1 ] :=
    Data.Dir.FList. {$IFDEF TLIST_FAST} Items {$ELSE} fItems {$ENDIF}[ e2 ];
  Data.Dir.FList.{$IFDEF TLIST_FAST} Items {$ELSE} fItems {$ENDIF}[ e2 ] := Tmp;
end;
{$ENDIF ASM_VERSION}
//[END SwapDirItems]

{always!} {$UNDEF CompareDirItems_ASM}

{$IFDEF CompareDirItems_ASM}
function CompareDirItems( const Data : PSortDirData; const e1, e2 : DWORD ) : Integer;
asm
        PUSH     EBX
        PUSH     ESI
        PUSH     EDI
        XCHG     EBX, EAX
        MOV      EAX, [EBX].TSortDirData.Dir
        MOV      EAX, [EAX].TDirList.fList
        MOV      EAX, [EAX].TList.fItems
        MOV      ESI, [EAX+EDX*4]
        MOV      EDI, [EAX+ECX*4]
        MOV      DL, byte ptr[ESI].TWin32FindData.dwFileAttributes
        MOV      DH, byte ptr[EDI].TWin32FindData.dwFileAttributes
        AND      DX, 2020h
        XOR      EAX, EAX
        CMP      DL, DH
        JE       @@1
        CMP      [EBX].TSortDirData.FoldersFirst, AL
        JE       @@1
        OR       AL, DL
        JNE      @@exit_near
        DEC      EAX
@@exit_near:
        POP      EDI
        POP      ESI
        POP      EBX
        RET

@@sdrByDateChanged:
        LEA      EAX, [ESI].TWin32FindData.ftLastWriteTime
        LEA      EDX, [EDI].TWin32FindData.ftLastWriteTime
        JMP      @@sdrByDate1

@@sdrByDateAccessed:
        LEA      EAX, [ESI].TWin32FindData.ftLastAccessTime
        LEA      EDX, [EDI].TWin32FindData.ftLastAccessTime
        JMP      @@sdrByDate1

@@jmp_table:
        DD       offset[@@exit1], offset[@@2], offset[@@2]
        DD       offset[@@sdrByName], offset[@@sdrByExt]
        DD       offset[@@sdrBySize], offset[@@sdrBySize]
        DD       offset[@@sdrByDateCreate], offset[@@sdrByDateChanged]
        DD       offset[@@sdrByDateAccessed]

@@1:
        LEA      EDX, [EBX].TSortDirData.Rules
        PUSH     EDX
@@2:
        POP      EDX
        XOR      EAX, EAX
        MOV      AL, [EDX]
        INC      EDX
        PUSH     EDX

        JMP      dword ptr [@@jmp_table+EAX*4]

@@sdrByDateCreate:
        LEA      EAX, [ESI].TWin32FindData.ftCreationTime
        LEA      EDX, [EDI].TWin32FindData.ftCreationTime
@@sdrByDate1:
        PUSH     EDX
        PUSH     EAX
        CALL     CompareFileTime
        TEST     EAX, EAX
        JE       @@2
        JMP      @@exit1

@@sdrBySize:
        MOV      EAX, [ESI].TWin32FindData.nFileSizeHigh
        SUB      EAX, [EDI].TWin32FindData.nFileSizeHigh
        JNE      @@sdrBySize1
        MOV      EAX, [ESI].TWin32FindData.nFileSizeLow
        SUB      EAX, [EDI].TWin32FindData.nFileSizeLow
@@to_2:
        JE       @@2
@@sdrBySize1:
        POP      EDX
        DEC      EDX
        CMP      byte ptr[EDX], sdrBySizeDescending
        JNE      @@sdrBySize2
        NEG      EAX
@@sdrBySize2:
        JNE      @@exit

        {$IFDEF _D2009orHigher}
        DW       0, 1 
        {$ENDIF}
        DD       -1, 1
@@point:DB       '.',0

@@sdrByExt:
        LEA      EAX, [EDI].TWin32FindData.cFileName
        MOV      EDX, offset[@@point]
        PUSH     EDX
        CALL     __DelimiterLast
        POP      EDX
        PUSH     EAX
        LEA      EAX, [ESI].TWin32FindData.cFileName
        CALL     __DelimiterLast
        POP      EDX
        JMP      @@sdrByName0

@@sdrByName:
        LEA      EAX, [ESI].TWin32FindData.cFileName
        LEA      EDX, [EDI].TWin32FindData.cFileName
@@sdrByName0:
        CMP      [EBX].TSortDirData.CaseSensitive, 0
        JNE      @@sdrByName1
        CALL     _AnsiCompareStrNoCase
        JMP      @@sdrByName2
@@sdrByName1:
        CALL     _AnsiCompareStr
@@sdrByName2:
        TEST     EAX, EAX
        JE       @@to_2
        //JMP    @@exit1

@@exit1:
        POP      EDX
@@exit:
        POP      EDI
        POP      ESI
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
function CompareDirItems( const Data : PSortDirData; const e1, e2 : DWORD ) : Integer;
var I : Integer;
    Item1, Item2 : PFindFileData;
    S1, S2 : PKOLChar;
    IsDir1, IsDir2 : Boolean;
    Date1, Date2 : PFileTime;
begin
  Item1 := Data.Dir.fList.Items[ e1 ];
  Item2 := Data.Dir.fList.Items[ e2 ];
  Result := 0;
  IsDir1 := (Item1.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) <> 0;
  IsDir2 := (Item2.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) <> 0;
  if (IsDir1 <> IsDir2) and Data.FoldersFirst then
  begin
    if IsDir1 then Result := -1 else Result := 1;
    exit;
  end;
  for I := 0 to High(Data.Rules) do
  begin
    case Data.Rules[ I ] of
    sdrByName:
      begin
        S1 := Item1.cFileName;
        S2 := Item2.cFileName;
        if not Data.CaseSensitive then
          Result := {$IFDEF UNICODE_CTRLS}
                      WStrComp( WAnsiUpperCase( S1 ), WAnsiUpperCase( S2 ) )
                    {$ELSE} _AnsiCompareStrNoCase( S1, S2 ) {$ENDIF}
        else
          Result := {$IFDEF UNICODE_CTRLS}
                      _WStrComp( S1, S2 )
                    {$ELSE}
                      _AnsiCompareStr( S1, S2 )
                    {$ENDIF};
      end;
    sdrByExt:
      begin
        S1 := Item1.cFileName;
        S2 := Item2.cFileName;
        S1 := {$IFDEF UNICODE_CTRLS} @ S1[ DelimiterLast( WideString( S1 ), '.' ) - 1 ]
              {$ELSE} __DelimiterLast( S1, '.' ) {$ENDIF};
        S2 := {$IFDEF UNICODE_CTRLS} @ S2[ DelimiterLast( WideString( S2 ), '.' ) - 1 ]
              {$ELSE} __DelimiterLast( S2, '.' ) {$ENDIF};
        if not Data.CaseSensitive then
           Result := {$IFDEF UNICODE_CTRLS}
                       WStrComp( WAnsiUpperCase( S1 ), WAnsiUpperCase( S2 ) )
                     {$ELSE} _AnsiCompareStrNoCase( S1, S2 ) {$ENDIF}
        else
           Result := {$IFDEF UNICODE_CTRLS} WStrComp( S1, S2 )
                     {$ELSE} _AnsiCompareStr( S1, S2 ) {$ENDIF};
      end;
    sdrBySize, sdrBySizeDescending:
      begin
        if Item1.nFileSizeHigh < Item2.nFileSizeHigh then
           Result := -1
        else
        if Item1.nFileSizeHigh > Item2.nFileSizeHigh then
           Result := 1
        else
        if Item1.nFileSizeLow < Item2.nFileSizeLow then
           Result := -1
        else
        if Item1.nFileSizeLow > Item2.nFileSizeLow then
           Result := 1;
        if Data.Rules[ I ] = sdrBySizeDescending then
           Result := -Result;
      end;
    sdrByDateCreate:
      begin
        Date1 := @Item1.ftCreationTime;
        Date2 := @Item2.ftCreationTime;
        Result := FileTimeCompare( Date1^, Date2^ );
      end;
    sdrByDateChanged:
      begin
        Date1 := @Item1.ftLastWriteTime;
        Date2 := @Item2.ftLastWriteTime;
        Result := FileTimeCompare( Date1^, Date2^ );
      end;
    sdrByDateAccessed:
      begin
        Date1 := @Item1.ftLastAccessTime;
        Date2 := @Item2.ftLastAccessTime;
        Result := FileTimeCompare( Date1^, Date2^ );
      end;
    end; {case}
    if Result <> 0 then break;
  end;
end;
{$ENDIF ASM_VERSION}
//[END CompareDirItems]

{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure TDirList.Sort(Rules: array of TSortDirRules);
var SortDirData : TSortDirData;
    I, J : Integer;

    function RulePresent( Rule : TSortDirRules ) : Boolean;
    var K : Integer;
    begin
      Result := True;
      for K := J - 1 downto 0 do
        if Rule = SortDirData.Rules[ K ] then exit;
      Result := False;
    end;

    procedure AddRule( Rule : TSortDirRules );
    begin
      if J > High( SortDirData.Rules ) then exit;
      if RulePresent( Rule ) then exit;
      SortDirData.Rules[ J ] := Rule;
      Inc( J );
    end;
begin
  if fList = nil then Exit;
  J := 0;
  for I := 0 to High(Rules) do
    AddRule( Rules[ I ] );
  for I := 0 to High(DefSortDirRules) do
    AddRule( DefSortDirRules[ I ] );
  while J < High( SortDirData.Rules ) do
  begin
    SortDirData.Rules[ J ] := sdrNone;
    Inc( J );
  end;

  SortDirData.Dir := @Self;
  SortDirData.FoldersFirst := RulePresent( sdrFoldersFirst );
  SortDirData.CaseSensitive := RulePresent( sdrCaseSensitive );
  SortData( Pointer( @SortDirData ), fList.fCount, @CompareDirItems, @SwapDirItems );
end;
{$ENDIF ASM_VERSION}

//[function TDirList.FileList]
function TDirList.FileList(const Separator: KOLString; Dirs,
  FullPaths: Boolean): KOLString;
var I: Integer;
begin
  Result := '';
  for I := 0 to Count-1 do
  begin
    if not Dirs and IsDirectory[ I ] then Continue;
    if FullPaths then
      Result := Result + Path;
    Result := Result + Names[ I ] + Separator;
  end;
end;

{$IFDEF WIN_GDI} //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
////////////////////////////////////////////////////////////////////////
//                        R  E  G  I  S  T  R  Y
////////////////////////////////////////////////////////////////////////

{++}(*
function RegSetValueEx; external advapi32 name 'RegSetValueExA';
*){--}

{ -- registry -- }

//[function RegKeyOpenRead]
function RegKeyOpenRead( Key: HKey; const SubKey: KOLString ): HKey;
begin
  if RegOpenKeyEx( Key, PKOLChar( SubKey ), 0, KEY_READ, Result ) <> ERROR_SUCCESS then
     Result := 0;
end;

//[function RegKeyOpenWrite]
function RegKeyOpenWrite( Key: HKey; const SubKey: KOLString ): HKey;
begin
  if RegOpenKeyEx( Key, PKOLChar( SubKey ), 0, KEY_READ or KEY_WRITE, Result ) <> ERROR_SUCCESS then
     Result := 0;
end;

//[function RegKeyOpenCreate]
function RegKeyOpenCreate( Key: HKey; const SubKey: KOLString ): HKey;
var dwDisp: DWORD;
begin
  if RegCreateKeyEx( Key, PKOLChar( SubKey ), 0, nil, 0, KEY_ALL_ACCESS, nil, Result,
                     @dwDisp ) <> ERROR_SUCCESS then
    Result := 0;
end;

//[function RegKeyGetDw]
function RegKeyGetDw( Key: HKey; const ValueName: KOLString ): DWORD;
var dwType, dwSize: DWORD;
begin
  dwSize := sizeof( DWORD );
  Result := 0;
  if (Key = 0) or
     (RegQueryValueEx( Key, PKOLChar( ValueName ), nil, @dwType, PByte( @Result ), @dwSize ) <> ERROR_SUCCESS)
     or (dwType <> REG_DWORD) then Result := 0;
end;

//[function RegKeyGetStr]
function RegKeyGetStr( Key: HKey; const ValueName: KOLString ): KOLString;
var dwType, dwSize: DWORD;
    Buffer: PKOLChar;

    function Query: Boolean;
    begin
      Result := RegQueryValueEx( Key, PKOLChar( ValueName ), nil, @dwType,
                Pointer( Buffer ), @dwSize ) = ERROR_SUCCESS;
    end;
begin
  Result := '';
  if Key = 0 then Exit;
  dwSize := 0;
  Buffer := nil;
  if not Query or (dwType <> REG_SZ) then Exit;
  GetMem( Buffer, dwSize * Sizeof( KOLChar ) );
  if Query then
    Result := Buffer;
  FreeMem( Buffer );
end;

//[function RegKeyGetStrEx]
function RegKeyGetStrEx( Key: HKey; const ValueName: KOLString ): KOLString;
var dwType, dwSize: DWORD;
    Buffer, Buffer2: PKOLChar;
    Sz: Integer;
    function Query: Boolean;
    begin
      Result := RegQueryValueEx( Key, PKOLChar( ValueName ), nil, @dwType,
                Pointer( Buffer ), @dwSize ) = ERROR_SUCCESS;
    end;
begin
  Result := '';
  if Key = 0 then Exit;
  dwSize := 0;
  Buffer := nil;
  if not Query or ((dwType <> REG_SZ) and (dwtype <> REG_EXPAND_SZ)) then Exit;
  GetMem( Buffer, dwSize * Sizeof( KOLChar ) );
  if Query then
  begin
    if dwtype = REG_EXPAND_SZ then
    begin
      Sz := ExpandEnvironmentStrings(Buffer,nil,0);  // bug in size detection! sometimes we get an additional 2 bytes at the end...
      GetMem(Buffer2,Sz * Sizeof( KOLChar ));                            //
      ExpandEnvironmentStrings(Buffer, Buffer2, Sz); //
      Result:=Buffer2;                               //
      FreeMem(Buffer2);                              //
    end
      else
    Result := Buffer;
  end;
  FreeMem( Buffer );
end;

//[function RegKeySetDw]
function RegKeySetDw( Key: HKey; const ValueName: KOLString; Value: DWORD ): Boolean;
begin
  Result := (Key <> 0) and (RegSetValueEx( Key, PKOLChar( ValueName ), 0,
    REG_DWORD, @Value, sizeof( DWORD ) ) = ERROR_SUCCESS);
end;

//[function RegKeySetStr]
function RegKeySetStr( Key: HKey; const ValueName: KOLString; const Value: KOLString ): Boolean;
begin
  Result := (Key <> 0) and (RegSetValueEx( Key, PKOLChar( ValueName ), 0,
            REG_SZ, PKOLChar(Value),
             (Length( Value ) + 1)*Sizeof(KOLChar) ) = ERROR_SUCCESS);
end;

//[function RegKeySetStrEx]
function RegKeySetStrEx( Key: HKey; const ValueName: KOLString; const Value: KOLString;
                         expand: Boolean): Boolean;
var dwType: DWORD;
begin
  dwType := REG_SZ;
  if expand then
    dwType := REG_EXPAND_SZ;
  Result := (Key <> 0) and (RegSetValueEx(Key, PKOLChar(ValueName), 0, dwType,
            PKOLChar(Value), (Length(Value) + 1)*Sizeof(KOLChar)) = ERROR_SUCCESS);
end;

//[procedure RegKeyClose]
procedure RegKeyClose( Key: HKey );
begin
  if Key <> 0 then
    RegCloseKey( Key );
end;

//[function RegKeyDelete]
function RegKeyDelete( Key: HKey; const SubKey: KOLString ): Boolean;
begin
  Result := FALSE;
  if Key <> 0 then
    Result := RegDeleteKey( Key, PKOLChar( SubKey ) ) = ERROR_SUCCESS;
end;

//[function RegKeyDeleteValue]
function RegKeyDeleteValue( Key: HKey; const SubKey: KOLString ): Boolean;
begin
  Result := FALSE;
  if Key <> 0 then
    Result := RegDeleteValue( Key, PKOLChar( SubKey ) ) = ERROR_SUCCESS;
end;

//[function RegKeyExists]
function RegKeyExists( Key: HKey; const SubKey: AnsiString ): Boolean;
var K: Integer;
begin
  if Key = 0 then
  begin
    Result := FALSE;
    Exit;
  end;
  K := RegKeyOpenRead( Key, SubKey );
  Result := K <> 0;
  if K <> 0 then
    RegKeyClose( K );
end;

//[function RegKeyValExists]
function RegKeyValExists( Key: HKey; const ValueName: KOLString ): Boolean;
var dwType, dwSize: DWORD;
begin
  Result := (Key <> 0) and
            (RegQueryValueEx( Key, PKOLChar( ValueName ), nil,
            @dwType, nil, @dwSize ) = ERROR_SUCCESS);
end;

//[function RegKeyValueSize]
function RegKeyValueSize( Key: HKey; const ValueName: KOLString ): Integer;
begin
  Result := 0;
  if Key = 0 then Exit;
  RegQueryValueEx( Key, PKOLChar( ValueName ), nil, nil, nil, @ DWORD( Result ) );
end;

//[function RegKeyGetBinary]
function RegKeyGetBinary( Key: HKey; const ValueName: KOLString; var Buffer; Count: Integer ): Integer;
begin
  Result := 0;
  if Key = 0 then Exit;
  Result := Count;
  RegQueryValueEx( Key, PKOLChar( ValueName ), nil, nil, @ Buffer, @ Result );
end;

//[function RegKeySetBinary]
function RegKeySetBinary( Key: HKey; const ValueName: KOLString; const Buffer; Count: Integer ): Boolean;
begin
  Result := (Key <> 0) and (RegSetValueEx( Key, PKOLChar( ValueName ), 0,
                    REG_BINARY, @ Buffer, Count ) = ERROR_SUCCESS);
end;

//[function RegKeyGetDateTime]
function RegKeyGetDateTime(Key: HKey; const ValueName: KOLString): TDateTime;
begin
  RegKeyGetBinary( Key, ValueName, Result, Sizeof( Result ) );
end;

//[function RegKeySetDateTime]
function RegKeySetDateTime(Key: HKey; const ValueName: KOLString; DateTime: TDateTime): Boolean;
begin
  Result := RegKeySetBinary( Key, ValueName, DateTime, Sizeof( DateTime ) );
end;

{$IFDEF OLD_REGKEYGETSUBKEYS}
//-----------------------------------------------
// functions by Valerian Luft <luft@valerian.de>
//-----------------------------------------------
//[function RegKeyGetSubKeys]
function RegKeyGetSubKeys( const Key: HKEY; List: PStrList) : Boolean;
var
  I, Size, NumSubKeys, MaxSubKeyLen : DWORD;
  KeyName: AnsiString;
begin
  Result := False;
  List.Clear ;
  if RegQueryInfoKey(Key, nil, nil, nil, @NumSubKeys, @MaxSubKeyLen, nil, nil, nil, nil,
nil, nil) = ERROR_SUCCESS then
    begin
      if NumSubKeys > 0 then begin
        for I := 0 to NumSubKeys-1 do
        begin
          Size := MaxSubKeyLen+1;
          SetLength(KeyName, Size);
          //FillChar(KeyName[1],Size,#0);
          RegEnumKeyEx(Key, I, @KeyName[1], Size, nil, nil, nil, nil);
          SetLength(KeyName, lstrlen(@KeyName[1]));
          List.Add(KeyName);
        end;
      end;
      Result:= True;
  end;
end;
{$ELSE} // new (faster) version by Alex Shyshko (Psychedelic)
function RegKeyGetSubKeys(const Key: HKEY; List: PKOLStrList) : Boolean;
var
  i, MaxSubKeyLen, Size: DWORD;
  Buf: PKOLChar;
begin
 Result:=false;
 List.Clear;

 if RegQueryInfoKey(Key, nil, nil, nil, nil, @MaxSubKeyLen, nil, nil, nil, nil,
     nil, nil) = ERROR_SUCCESS then
  begin
  if MaxSubKeyLen > 0 then
    begin
      GetMem(Buf,MaxSubKeyLen + 1);
      i:=0;
      Size:=MaxSubKeyLen + 1;

      while RegEnumKeyEx(Key,i,buf,Size,nil,nil,nil,nil) <> ERROR_NO_MORE_ITEMS do
      begin
       List.Add(KOLString(Buf));
       Size:=MaxSubKeyLen + 1;
       inc(i);
      end;

      FreeMem(Buf{,MaxSubKeyLen + 1});
    end; // if MaxSubKeyLen
   Result:=true;
  end; // if RegQueryInfoKey

end;
{$ENDIF}

//[function RegKeyGetValueNames]
{$IFDEF OLD_REGKEYGETVALUENAMES}
function RegKeyGetValueNames(const Key: HKEY; List: PStrList): Boolean;
var
  I, Size, NumSubKeys, NumValueNames, MaxValueNameLen: DWORD;
  ValueName: AnsiString;
begin
  List.Clear ;
  Result:=False;
  if RegQueryInfoKey(Key, nil, nil, nil, @NumSubKeys, nil, nil, @NumValueNames,
@MaxValueNameLen, nil, nil, nil) = ERROR_SUCCESS then
  begin
     if NumValueNames > 0 then
        for I := 0 to NumValueNames - 1 do begin
          Size := MaxValueNameLen + 1;
          SetLength(ValueName, Size);
          //FillChar(ValueName[1],Size,#0);
          RegEnumValue(Key, I, @ValueName[1], Size, nil, nil, nil, nil);
          SetLength(ValueName, lstrlen(@ValueName[1]));
          List.Add(ValueName);
        end;
     Result := True;
  end ;
end;
{$ELSE} // new (faster) version by Alex Shyshko (Psychedelic)
function RegKeyGetValueNames(const Key: HKEY; List: PKOLStrList) : Boolean;
var
  i, MaxValueNameLen, Size: DWORD;
  Buf: PKOLchar;
begin
 Result:=false;
 List.Clear;

 if RegQueryInfoKey(Key, nil, nil, nil, nil, nil, nil, nil, @MaxValueNameLen, nil,
     nil, nil) = ERROR_SUCCESS then
  begin
  if MaxValueNameLen > 0 then
    begin
      GetMem(Buf,MaxValueNameLen + SizeOf(KOLChar) );
      i:=0;
      Size:=MaxValueNameLen+1;

      while RegEnumValue(Key,i,buf,Size,nil,nil,nil,nil) <> ERROR_NO_MORE_ITEMS do
      begin
       List.Add(KOLString(Buf)); 
       Size:=MaxValueNameLen+1;
       inc(i);
      end;

      FreeMem(Buf {,MaxValueNameLen + ... system always knows how long buffer is});
    end; // if MaxValueNameLen
   Result:=true;
  end; // if RegQueryInfoKey

end;
{$ENDIF}

//[function RegKeyGetValueTyp]
function RegKeyGetValueTyp (const Key:HKEY; const ValueName: KOLString) : DWORD;
begin
Result:= Key ;
if Key <> 0 then
   RegQueryValueEx (Key,@ValueName[1],NIL,@Result,NIL,NIL)
end;

//////////////////////////////////////////////////////////////////////
//                D  A  T  E     A  N  D     T  I  M  E
//////////////////////////////////////////////////////////////////////

{ -- date and time utilities -- }

{* This part of the unit contains date-time routines. It is not a simple compilation
   of Delphi VCL date-time. E.g., TDateTime type is not based on 31-Dec-1899,
   but it is based on 31-Dec-0000 instead, allowing easy manipulating of dates
   at all Christian era, and all other historical era too. }

//[procedure DivMod]
procedure DivMod(Dividend: Integer; Divisor: Word; var Result, Remainder: Word);
{$IFDEF F_P}
begin
        Result    := Dividend div Divisor;
        Remainder := Dividend mod Divisor;
end;
{$ELSE DELPHI}
asm
        PUSH    EBX
        MOV     EBX,EDX
        MOV     EDX,EAX
        SHR     EDX,16
        DIV     BX
        MOV     EBX,Remainder
        MOV     [ECX],AX
        MOV     [EBX],DX
        POP     EBX
end;
{$ENDIF}

{++}(*
//[API GetLocalTime, GetSystemTime]
procedure GetLocalTime; external kernel32 name 'GetLocalTime';
procedure GetSystemTime; external kernel32 name 'GetSystemTime';
*){--}

//*
//[function Now]
function Now : TDateTime;
var SystemTime : TSystemTime;
begin
   GetLocalTime( SystemTime );
   SystemTime2DateTime( SystemTime, Result );
end;

//[function Date]
function Date: TDateTime;
begin
  Result := Trunc( Now );
end;

//[procedure DecodeDateFully]
procedure DecodeDateFully( DateTime: TDateTime; var Year, Month, Day, DayOfWeek: WORD );
var ST: TSystemTime;
begin
  DateTime2SystemTime( DateTime, ST );
  Year := ST.wYear;
  Month := ST.wMonth;
  Day := ST.wDay;
  DayOfWeek := ST.wDayOfWeek;
end;

//[procedure DecodeDate]
procedure DecodeDate( DateTime: TDateTime; var Year, Month, Day: WORD );
var Dummy: Word;
begin
  DecodeDateFully( DateTime, Year, Month, Day, Dummy );
end;

//[function EncodeDate]
function EncodeDate( Year, Month, Day: WORD; var DateTime: TDateTime ): Boolean;
var ST: TSystemTime;
begin
  FillChar( ST, Sizeof( ST ), #0 );
  ST.wYear := Year;
  ST.wMonth := Month;
  ST.wDay := Day;
  Result := SystemTime2DateTime( ST, DateTime );
end;

//[procedure IncDays]
procedure IncDays( var SystemTime : TSystemTime; DaysNum : Integer );
var DateTime : TDateTime;
begin
   SystemTime2DateTime( SystemTime, DateTime );
   DateTime := DateTime + DaysNum;
   DateTime2SystemTime( DateTime, SystemTime );
end;

//*
//[procedure IncMonths]
procedure IncMonths( var SystemTime : TSystemTime; MonthsNum : Integer );
var M : Integer;
    DateTime : TDateTime;
begin
   M := SystemTime.wMonth + MonthsNum - 1;
   Inc( SystemTime.wYear, M div 12 );
   SystemTime.wMonth := M mod 12 + 1;

   // Normalize wDayOfWeek field:
   SystemTime2DateTime( SystemTime, DateTime );
   DateTime2SystemTime( DateTime, SystemTime );
end;

//*
//[function IsLeapYear]
function IsLeapYear(Year: Integer): Boolean;
begin
  Result := (Year mod 4 = 0) and ((Year mod 100 <> 0) or (Year mod 400 = 0));
end;

//*
//[function SystemTime2DateTime]
function SystemTime2DateTime(const SystemTime : TSystemTime; var DateTime : TDateTime ) : Boolean;
var I : Integer;
    _Day : Integer;
    DayTable: PDayTable;
begin
  Result := False;
  DateTime := 0.0;
  DayTable := @MonthDays[IsLeapYear(SystemTime.wYear)];
  with SystemTime do
  if {(wYear >= 0) !always true! and} (wYear <= 9999) and
    {(wMonth >= 1) and !otherwise can not convert time only!}
    (wMonth <= 12) and
    {(wDay >= 1) and !otherwise can not convert time only!}
    (wDay <= DayTable^[wMonth]) and                                      //
    (wHour < 24) and (wMinute < 60) and (wSecond < 60) and (wMilliSeconds < 1000) then   //
  begin
    _Day := wDay;
    for I := 1 to wMonth - 1 do
        Inc(_Day, DayTable^[I]);
    I := wYear - 1;
    //--------------- by Vadim Petrov ------++
    if I<0 then i := 0;                     //
    //--------------------------------------++
    DateTime := I * 365 + I div 4 - I div 100 + I div 400 + _Day
             + (wHour * 3600000 + wMinute * 60000 + wSecond * 1000 + wMilliSeconds) / MSecsPerDay;
    Result := True;
  end;
end;

//*
//[function DayOfWeek]
function DayOfWeek(Date: TDateTime): Integer;
begin
  Result := (Trunc( Date ) + 6) mod 7 + 1;
end;

//*
//[function DateTime2SystemTime]
function DateTime2SystemTime(const DateTime : TDateTime; var SystemTime : TSystemTime ) : Boolean;
const
  D1 = 365;
  D4 = D1 * 4 + 1;
  D100 = D4 * 25 - 1;
  D400 = D100 * 4 + 1;
var Days : Integer;
    Y, M, D, I: Word;
    MSec : Integer;
    DayTable: PDayTable;
    MinCount, MSecCount: Word;
begin
  Days := Trunc( DateTime );
  MSec := Round((DateTime - Days) * MSecsPerDay);
  Result := False;
  with SystemTime do
  if Days > 0 then
  begin
    Dec(Days);
    Y := 1;
    while Days >= D400 do
    begin
      Dec(Days, D400);
      Inc(Y, 400);
    end;
    DivMod(Days, D100, I, D);
    if I = 4 then
    begin
      Dec(I);
      Inc(D, D100);
    end;
    Inc(Y, I * 100);
    DivMod(D, D4, I, D);
    Inc(Y, I * 4);
    DivMod(D, D1, I, D);
    if I = 4 then
    begin
      Dec(I);
      Inc(D, D1);
    end;
    Inc(Y, I);
    DayTable := @MonthDays[IsLeapYear(Y)];
    M := 1;
    while True do
    begin
      I := DayTable^[M];
      if D < I then Break;
      Dec(D, I);
      Inc(M);
    end;
    wYear := Y;
    wMonth := M;
    wDay := D + 1;
    wDayOfWeek := KOL.DayOfWeek( DateTime );
    DivMod(MSec, 60000, MinCount, MSecCount);
    DivMod(MinCount, 60, wHour, wMinute);
    DivMod(MSecCount, 1000, wSecond, wMilliSeconds);
    Result := True;
  end;
end;

function DateTime_DiffSysLoc: TDateTime;
var ST, LT: TSystemTime;
    FT, FT1: TFileTime;
    D1, D2: TDateTime;
begin
  GetSystemTime( ST );
  SystemTimeToFileTime( ST, FT );
  FileTimeToLocalFileTime( FT, FT1 );
  FileTimeToSystemTime( FT1, LT );
  SystemTime2DateTime( ST, D1 );
  SystemTime2DateTime( LT, D2 );
  Result := D2 - D1;
end;

//[function DateTime_System2Local]
function DateTime_System2Local( DTSys: TDateTime ): TDateTime;
begin
  Result := DTSys + DateTime_DiffSysLoc;
end;

//[function DateTime_Local2System]
function DateTime_Local2System( DTLoc: TDateTime ): TDateTime;
begin
  Result := DTLoc - DateTime_DiffSysLoc;
end;

function FileTime2DateTime( const ft: TFileTime; var DT: TDateTime ): Boolean;
var ft1: TFileTime;
    st: TSystemTime;
begin
  Result := FileTimeToLocalFileTime( ft, ft1 ) and
            FileTimeToSystemTime( ft1, st ) and
            SystemTime2DateTime( st, dt );
end;

function DateTime2FileTime( DT: TDateTime; var ft: TFileTime ): Boolean;
var st: TSystemTime;
begin
  Result := DateTime2SystemTime( DT, ST ) and
            SystemTimeToFileTime( st, ft ) and
            LocalFileTimeToFileTime( ft, ft );
end;

//*
//[function SystemDate2Str]
function SystemDate2Str( const SystemTime : TSystemTime; const LocaleID : DWORD;
                         const DfltDateFormat : TDateFormat;
                         const DateFormat : PKOLChar ) : KOLString;
var Buf : PKOLChar;
    Sz : Integer;
    Flags : DWORD;
begin
   Sz := 100;
   Buf := nil;
   Result := '';
   Flags := 0;
   if DateFormat = nil then
   if DfltDateFormat = dfShortDate then
      Flags := DATE_SHORTDATE
   else
      Flags := DATE_LONGDATE;
   while True do
   begin
      if Buf <> nil then
         FreeMem( Buf );
      GetMem( Buf, Sz * Sizeof( KOLChar ) );
      if Buf = nil then Exit;
      if GetDateFormat( LocaleID, Flags, @SystemTime, DateFormat, Buf, Sz )
         = 0 then
      begin
         if GetLastError = ERROR_INSUFFICIENT_BUFFER then
            Sz := Sz * 2
         else
            break;
      end
         else
      begin
         Result := Buf;
         break;
      end;
   end;
   if Buf <> nil then
      FreeMem( Buf );
end;

//*
//[function SystemTime2Str]
function SystemTime2Str( const SystemTime : TSystemTime; const LocaleID : DWORD;
                         const Flags : TTimeFormatFlags;
                         const TimeFormat : PKOLChar ) : KOLString;
var Buf : PKOLChar;
    Sz : Integer;
    Flg : DWORD;
begin
   Sz := 100;
   Buf := nil;
   Result := '';
   Flg := 0;
   if tffNoMinutes in Flags then
      Flg := TIME_NOMINUTESORSECONDS
   else
   if tffNoSeconds in Flags then
      Flg := TIME_NOSECONDS;
   if tffNoMarker in Flags then
      Flg := Flg or TIME_NOTIMEMARKER;
   if tffForce24 in Flags then
      Flg := Flg or TIME_FORCE24HOURFORMAT;
   while True do
   begin
      if Buf <> nil then
         FreeMem( Buf );
      GetMem( Buf, Sz * Sizeof( KOLChar ) );
      if Buf = nil then Exit;
      if GetTimeFormat( LocaleID, Flg, @SystemTime, TimeFormat, Buf, Sz )
         = 0 then
      begin
         if GetLastError = ERROR_INSUFFICIENT_BUFFER then
            Sz := Sz * 2
         else
            break;
      end
         else
      begin
         Result := Buf;
         break;
      end;
   end;
   if Buf <> nil then
      FreeMem( Buf );
end;

//[function Date2StrFmt]
function Date2StrFmt( const Fmt: KOLString; D: TDateTime ): KOLString;
var ST: TSystemTime;
    lpFmt: PKOLChar;
begin
  DateTime2SystemTime( D, ST );
  lpFmt := nil;
  if Fmt <> '' then lpFmt := PKOLChar( Fmt );
  Result := SystemDate2Str( ST, LOCALE_USER_DEFAULT, dfShortDate, lpFmt );
end;

//[function Time2StrFmt]
function Time2StrFmt( const Fmt: KOLString; D: TDateTime ): KOLString;
var ST: TSystemTime;
    lpFmt: PKOLChar;
begin
  if D < 1 then D := D + 1;
  DateTime2SystemTime( D, ST );
  lpFmt := nil;
  if Fmt <> '' then lpFmt := PKOLChar( Fmt );
  Result := SystemTime2Str( ST, LOCALE_USER_DEFAULT, [], lpFmt );
end;

//[function DateTime2StrShort]
function DateTime2StrShort( D: TDateTime ): KOLString;
var ST: TSystemTime;
begin
  //--------- by Vadim Petrov --------++
  if D < 1 then D := D + 1;           //
  //----------------------------------++
  DateTime2SystemTime( D, ST );
  Result := SystemDate2Str( ST, LOCALE_USER_DEFAULT {GetUserDefaultLCID}, dfShortDate, nil ) + ' ' +
            SystemTime2Str( ST, LOCALE_USER_DEFAULT {GetUserDefaultLCID}, [], nil );
end;

//[function Str2DateTimeFmt]
function Str2DateTimeFmt( const sFmtStr, sS: KOLString ): TDateTime;
var h12, hAM: Boolean;
    FmtStr, S: PKOLChar;

  function GetNum( var S: PKOLChar; NChars: Integer ): Integer;
  begin
    Result := 0;
    while (S^ <> #0) and (NChars <> 0) do
    begin
      Dec( NChars );
      {$IFDEF UNICODE_CTRLS}
      if (S^ >= '0') and (S^ <= '9') then
      {$ELSE}
      if S^ in ['0'..'9'] then
      {$ENDIF}
      begin
        Result := Result * 10 + Ord(S^) - Ord('0');
        Inc( S );
      end
      else
        break;
    end;
  end;

  function GetYear( var S: PKOLChar; NChars: Integer ): Integer;
  var STNow: TSystemTime;
      OldDate: Boolean;
  begin
    Result := GetNum( S, NChars );
    GetSystemTime( STNow );
    OldDate := Result < 50;
    Result := Result + STNow.wYear - STNow.wYear mod 100;
    if OldDate then Dec( Result, 100 );
  end;

  function GetMonth( const fmt: KOLString; var S: PKOLChar ): Integer;
  var SD: TSystemTime;
      M: Integer;
      C, MonthStr: KOLString;
  begin
    GetSystemTime( SD );
    for M := 1 to 12 do
    begin
      SD.wMonth := M;
      C := SystemDate2Str( SD, LOCALE_USER_DEFAULT, dfLongDate, PKOLChar( fmt + '/dd/yyyy/' ) );
      MonthStr := Parse( C, '/' );
      if AnsiCompareStrNoCase( MonthStr, Copy( S, 1, Length( MonthStr ) ) ) = 0 then
      begin
        Result := M;
        Inc( S, Length( MonthStr ) );
        Exit;
      end;
    end;
    Result := 1;
  end;

  procedure SkipDayOfWeek( const fmt: KOLString; var S: PKOLChar );
  var SD: TSystemTime;
      Dt: TDateTime;
      D: Integer;
      C, DayWeekStr: KOLString;
  begin
    GetSystemTime( SD );
    SystemTime2DateTime( SD, Dt );
    Dt := Dt - SD.wDayOfWeek;
    for D := 0 to 6 do
    begin
      DateTime2SystemTime( Dt, SD );
      C := SystemDate2Str( SD, LOCALE_USER_DEFAULT, dfLongDate, PKOLChar( fmt + '/MM/yyyy/' ) );
      DayWeekStr := Parse( C, '/' );
      if AnsiCompareStrNoCase( DayWeekStr, Copy( S, 1, Length( DayWeekStr ) ) ) = 0 then
      begin
        Inc( S, Length( DayWeekStr ) );
        Exit;
      end;
      Dt := Dt + 1.0;
    end;
  end;

  procedure GetTimeMark( const fmt: KOLString; var S: PKOLChar );
  var SD: TSystemTime;
      AM: Boolean;
      C, TimeMarkStr: KOLString;
  begin
    GetSystemTime( SD );
    SD.wHour := 0;
    for AM := FALSE to TRUE do
    begin
      C := SystemDate2Str( SD, LOCALE_USER_DEFAULT, dfLongDate, PKOLChar( fmt + '/HH/mm' ) );
      TimeMarkStr := Parse( C, '/' );
      if AnsiCompareStrNoCase( TimeMarkStr, Copy( S, 1, Length( TimeMarkStr ) ) ) = 0 then
      begin
        Inc( S, Length( TimeMarkStr ) );
        hAM := AM;
        Exit;
      end;
      SD.wHour := 13;
    end;
    Result := 1;
  end;

  function FmtIs1( S: PKOLChar ): Boolean;
  begin
    if StrIsStartingFrom( FmtStr, S ) then
    begin
      Inc( FmtStr, {$IFDEF UNICODE_CTRLS} WStrLen {$ELSE} StrLen {$ENDIF}( S ) );
      Result := TRUE;
    end
      else
      Result := FALSE;
  end;

  function FmtIs( S1, S2: PKOLChar ): Boolean;
  begin
    Result := FmtIs1( S1 ) or FmtIs1( S2 );
  end;

var ST: TSystemTime;
begin
  FmtStr := PKOLChar( sFmtStr);
  S := PKOLChar( sS );
  FillChar( ST, Sizeof( ST ), #0 );
  h12 := FALSE;
  hAM := FALSE;
  while (FmtStr^ <> #0) and (S^ <> #0) do
  begin
    {$IFDEF UNICODE_CTRLS}
    if ((FmtStr^ >= 'a') and (FmtStr^ <= 'z') or
       (FmtStr^ >= 'A') and (FmtStr^ <= 'Z')) and
       (S^ >= '0') and (S^ <= '9') then
    {$ELSE}
    if (FmtStr^ in ['a'..'z','A'..'Z']) and (S^ in ['0'..'9']) then
    {$ENDIF}
    begin
      if      FmtIs1( 'yyyy'   ) then ST.wYear := GetNum( S, 4 )
      else if FmtIs1( 'yy' )     then ST.wYear := GetYear( S, 2 )
      else if FmtIs1( 'y' )      then ST.wYear := GetYear( S, -1 )
      else if FmtIs( 'dd', 'd' ) then ST.wDay := GetNum( S, 2 )
      else if FmtIs( 'MM', 'M' ) then ST.wMonth := GetNum( S, 2 )
      else if FmtIs( 'HH', 'H' ) then ST.wHour := GetNum( S, 2 )
      else if FmtIs( 'hh', 'h' ) then begin ST.wHour := GetNum( S, 2 ); h12 := TRUE end
      else if FmtIs( 'mm', 'm' ) then ST.wMinute := GetNum( S, 2 )
      else if FmtIs( 'ss', 's' ) then ST.wSecond := GetNum( S, 2 )
      else break; // + ECM
    end
      else
    {$IFDEF UNICODE_CTRLS}
    if (FmtStr^ = 'M') or (FmtStr^ = 'd') or (FmtStr^ = 'g') then
    {$ELSE}
    if (FmtStr^ in [ 'M', 'd', 'g' ]) then
    {$ENDIF}
    begin
      if      FmtIs1( 'MMMM' ) then ST.wMonth := GetMonth( 'MMMM', S )
      else if FmtIs1( 'MMM'  ) then ST.wMonth := GetMonth( 'MMM', S )
      else if FmtIs1( 'dddd' ) then SkipDayOfWeek( 'dddd', S )
      else if FmtIs1( 'ddd'  ) then SkipDayOfWeek( 'ddd', S )
      else if FmtIs1( 'tt'   ) then GetTimeMark( 'tt', S )
      else if FmtIs1( 't'    ) then GetTimeMark( 't', S )
      else break; // + ECM
    end
      else
    begin
      if FmtStr^ = S^ then
        Inc( FmtStr );
      Inc( S );
    end;
  end;

  if h12 then
  if hAM then
    Inc( ST.wHour, 12 );

  SystemTime2DateTime( ST, Result );
end;

var FmtBuf: PKOLChar;
    DateSeparator : KOLChar = #0; // + ECM

//[function Str2DateTimeShort]
function Str2DateTimeShort( const S: KOLString ): TDateTime;
var FmtStr, FmtStr2: KOLString;

  function EnumDateFmt( lpstrFmt: PKOLChar ): Boolean; stdcall;
  begin
    GetMem( FmtBuf, ({$IFDEF UNICODE_CTRLS} WStrLen {$ELSE} StrLen {$ENDIF}
      ( lpstrFmt ) + 1) * Sizeof( KOLChar ) );
    {$IFDEF UNICODE_CTRLS} WStrCopy {$ELSE} StrCopy {$ENDIF}
      ( FmtBuf, lpstrFmt );
    Result := FALSE;
  end;

begin
  FmtStr := 'dd.MM.yyyy';
  FmtBuf := nil;
  EnumDateFormats( @ EnumDateFmt, LOCALE_USER_DEFAULT, DATE_SHORTDATE );
  if FmtBuf <> nil then
  begin
    FmtStr := FmtBuf;
    FreeMem( FmtBuf );
  end;

  FmtStr2 := 'H:mm:ss';
  FmtBuf := nil;
  EnumTimeFormats( @ EnumDateFmt, LOCALE_USER_DEFAULT, 0 );
  if FmtBuf <> nil then
  begin
    FmtStr2 := FmtBuf;
    FreeMem( FmtBuf );
  end;

  Result := Str2DateTimeFmt( FmtStr + ' ' + FmtStr2, S );
end;

// + ECM
//[function Str2DateTimeShortEx]
function Str2DateTimeShortEx( const S: KOLString ): TDateTime;
var St: KOLString;
  Buff: Array[0..1] of KOLChar;
begin
  if DateSeparator = #0 then
  begin
    if GetLocaleInfo(GetThreadLocale,LOCALE_SDATE,Buff,2) > 0 then
      DateSeparator := Buff[0];
  end;
  St := S;
  if Pos(DateSeparator,S) = 0 then
    St := '0.0.0 '+S;
  Result := Str2DateTimeShort(St);
end;

///////////////////////////////////////////////////////////////////////
//                          T  H  R  E  A  D  S
///////////////////////////////////////////////////////////////////////

{ -- Thread -- }

//[function ThreadFunc]
function ThreadFunc(Thread: PThread): integer; stdcall;
begin
  Result := Thread.Execute;
end;

{$IFDEF USE_CONSTRUCTORS}
//[function NewThread]
function NewThread: PThread;
begin
  new( Result, ThreadCreate );
end;
//[END NewThread]
{$ELSE not_USE_CONSTRUCTORS}
//*
//[function NewThread]
function NewThread: PThread;
begin
  {$IFNDEF FPC105ORBELOW}
  IsMultiThread := True;
  {$ENDIF}
  {-}
  New( Result, Create );
  {+}
  {++}(*Result := PThread.Create;*){--}
  Result.FSuspended := True;
  {$IFDEF PSEUDO_THREADS}
  {$ELSE}
  Result.FHandle := CreateThread( nil, // no security
                                  0,   // the same stack size
                                  @ThreadFunc, // thread entry point
                                  Result,      // parameter to pass to ThreadFunc
                                  CREATE_SUSPENDED,   // always SUSPENDED
                                  Result.FThreadID ); // receive thread ID
  {$ENDIF}
end;
//[END NewThread]
{$ENDIF USE_CONSTRUCTORS}

{$IFDEF USE_CONSTRUCTORS}
//[function NewThreadEx]
function NewThreadEx( const Proc: TOnThreadExecute ): PThread;
begin
  new( Result, ThreadCreateEx( Proc ) );
end;
{$ELSE not_USE_CONSTRUCTORS}

//[FUNCTION NewThreadEx]
{$IFDEF ASM_!VERSION}
function NewThreadEx( const Proc: TOnThreadExecute ): PThread;
asm
        CALL     NewThread
        POP      EBP
        POP      ECX
        POP      EDX
        MOV      [EAX].TThread.fOnExecute.TMethod.Code, EDX
        POP      EDX
        MOV      [EAX].TThread.fOnExecute.TMethod.Data, EDX
        PUSH     ECX
        PUSH     EAX
        CALL     TThread.Resume
        POP      EAX
        RET
end;
{$ELSE ASM_VERSION} //Pascal
function NewThreadEx( const Proc: TOnThreadExecute ): PThread;
begin
  Result := NewThread;
  Result.OnExecute := {++}(*{$IFDEF F_P} @ {$ENDIF}*){--}Proc;
  Result.Resume;
end;
{$ENDIF ASM_VERSION}
//[END NewThreadEx]

{$ENDIF USE_CONSTRUCTORS}

//[function NewThreadAutoFree]
function NewThreadAutoFree( const Proc: TOnThreadExecute ): PThread;
begin
  Result := NewThread;
  Result.OnExecute := {++}(*{$IFDEF F_P} @ {$ENDIF}*){--}Proc;
  Result.F_AutoFree := TRUE;
  if Assigned( Proc ) then
    Result.Resume;
end;

{ TThread }

function WndProcCMExec( Sender: PControl; var Msg: TMsg; var Rslt: Integer )
                          : Boolean;
var Thread: PThread;
begin
  Result := FALSE;
  if Msg.message = CM_EXECPROC then
  begin
    //Global_Synchronized( Pointer( Msg.lParam ), Pointer( Msg.wParam ) );
    Thread := PThread( Msg.lParam );
    if Msg.wParam <> 0 then
      Thread.FMethodEx( Thread, Pointer( Msg.wParam ) )
    else
      Thread.FMethod( );
    Rslt := 0;
  end;
end;

{$IFDEF PSEUDO_THREADS}
function timeBeginPeriod(uPeriod: UINT): UINT; stdcall;
external 'winmm.dll' name 'timeBeginPeriod';
function timeEndPeriod(uPeriod: UINT): UINT; stdcall;
external 'winmm.dll' name 'timeEndPeriod';
{$ENDIF}

procedure TThread.Init;
begin
  {$IFDEF _D2orD3}
  inherited;
  {$ENDIF}
  if Applet <> nil then
    Applet.AttachProc( WndProcCMExec );
  {$IFDEF PSEUDO_THREADS}
  if (MainThread = nil) and not CreatingMainThread then
  begin // creating main thread
    CreatingMainThread := TRUE;
    new( MainThread, Create );
    CreatingMainThread := FALSE;
  end;
  if CreatingMainThread then
  begin
    MainThread := @ Self;
    {MainThread.}AllThreads := NewList;
    {MainThread.}CurrentThread := MainThread;
    TimeBeginPeriod( 10 );
  end;
  if not CreatingMainThread and (MainThread <> @ Self) then
  begin // creating other threads
    GetMem( StackBottom, PseudoThreadStackSize );
    CurStackPos := Pointer( DWORD( StackBottom ) + PseudoThreadStackSize );
    Stack_Empty := TRUE;
  end;
  MainThread.AllThreads.Add( @ Self );
  {$ENDIF}
end;

//[destructor TThread.Destroy]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
destructor TThread.Destroy;
begin
  RefInc;
  if not FTerminated then
  begin
    Terminate;
    WaitFor;
  end;
  if (FHandle <> 0) then
    CloseHandle(FHandle);
  {$IFDEF PSEUDO_THREADS}
  if StackBottom <> nil then
    FreeMem( StackBottom );
  if MainThread = @ Self then
  begin
    TimeEndPeriod( 10 );
    AllThreads.Free;
  end
    else
  if MainThread <> nil then
  begin
    MainThread.AllThreads.Remove( @ Self );
    if MainThread.AllThreads.Count <= 1 then
      Free_And_Nil( MainThread );
  end;
  {$ENDIF}
  inherited;
end;
{$ENDIF ASM_VERSION}

//*
//[function TThread.Execute]
function TThread.Execute: integer;
begin
  Result := 0;
  if Assigned( FOnExecute ) then
     Result := FOnExecute( @Self );
  FResult := Result;
  FTerminated := TRUE; // fake thread object (to prevent terminating while freeing)
  if F_AutoFree then
    Free;
end;

//*
//[function TThread.GetPriorityCls]
function TThread.GetPriorityCls: Integer;
begin
  {$IFDEF PSEUDO_THREADS}
  Result := FPrtyCls;
  {$ELSE}
  Result := GetPriorityClass(FHandle);
  {$ENDIF}
end;

//*
//[function TThread.GetThrdPriority]
function TThread.GetThrdPriority: Integer;
begin
  {$IFDEF PSEUDO_THREADS}
  Result := FPriority;
  {$ELSE}
  Result := GetThreadPriority(FHandle);
  {$ENDIF}
end;

//*
//[procedure TThread.Resume]
procedure TThread.Resume;
begin
  {$IFDEF PSEUDO_THREADS}
  if MainThread.CurrentThread = @ Self then
    Exit;
  MainThread.SwitchToThread( @ Self );
  {$ELSE}
  FSuspended := False;
  if (ResumeThread(FHandle) > 1) then
    FSuspended := True
  else
  if Assigned(FOnResume) then
    FOnResume(@Self);
  {$ENDIF}
end;

//*
//[procedure TThread.SetPriorityCls]
procedure TThread.SetPriorityCls(Value: Integer);
begin
  {$IFDEF DEBUG}
  if not SetPriorityClass(GetCurrentProcess, Value) then
  begin
    ShowMessage( SysErrorMessage( GetLastError ) );
  end;
  {$ELSE}
  {$IFDEF PSEUDO_THREADS}
  FPrtyCls := Value;
  {$ELSE}
  SetPriorityClass(GetCurrentProcess, Value);
  {$ENDIF}
  {$ENDIF}
end;

//*
//[procedure TThread.SetThrdPriority]
procedure TThread.SetThrdPriority(Value: Integer);
begin
  FPriority := Value;
  {$IFDEF PSEUDO_THREADS}
  {$ELSE}
  SetThreadPriority(FHandle, Value);
  {$ENDIF}
end;

//*
//[procedure TThread.Suspend]
procedure TThread.Suspend;
begin
  {$IFDEF PSEUDO_THREADS}
  if MainThread <> @ Self then
    FSuspended := TRUE;
  if MainThread.CurrentThread = @ Self then
    MainThread.NextThread;
  {$ELSE}
  FSuspended := TRUE;
  if Assigned(FOnSuspend) then
    Synchronize( FOnSuspend );
  SuspendThread(FHandle);
  {$ENDIF}
end;

{$IFDEF PSEUDO_THREADS}
procedure FinishThread;
begin
  MainThread.CurrentThread.fTerminated := TRUE;
  MainThread.CurrentThread.Stack_Empty := TRUE;
  MainThread.NextThread;
end;

procedure TThread.SwitchToThread(T: PThread);
begin
  if (T <> MainThread) and not Assigned( T.OnExecute ) then Exit;
  if Assigned( MainThread.CurrentThread.OnSuspend ) then
  begin
    MainThread.CurrentThread.OnExecute( MainThread.CurrentThread );
  end;
  asm
    mov edx, [T]
    // 1. Suspending current thread
    mov ecx, [MainThread]
    mov eax, [ecx].CurrentThread
    push ebx
    push ebp
    push esi
    push edi
    mov  [eax].CurStackPos, esp
    mov  [eax].Stack_Empty, 0
    // 2. Switching to another thread

    mov  [ecx].CurrentThread, edx

    cmp  [edx].Stack_Empty, 0
    jz   @@1
    // the first call
    mov  [edx].Stack_Empty, 0
    cmp  [edx].FSuspended, 0
    jz   @@0
    mov  [edx].FSuspended, 0

    mov  esp, [edx].CurStackPos
    mov  ecx, [edx].fOnResume.TMethod.Code
    jecxz @@0
    mov  eax, [edx].fOnResume.TMethod.Data
    call ecx // calling OnResume for resuming thread
  @@0:
    mov  eax, [edx].fOnExecute.TMethod.Data
    mov  ecx, [edx].fOnExecute.TMethod.Code
    push offset [FinishThread] // if thread will be finished it will jump there
    jmp  ecx
  @@1:
    // other calls - resuming
    mov  esp, [edx].CurStackPos
    pop edi
    pop esi
    pop ebp
    pop ebx
    cmp  [edx].FSuspended, 0
    jz   @@2
    mov  [edx].FSuspended, 0

    mov  ecx, [edx].fOnResume.TMethod.Code
    jecxz @@2
    mov  eax, [edx].fOnResume.TMethod.Data
    call ecx // calling OnResume for resuming thread
  @@2:
  end;
  // At this point, thread is resumed
end;

procedure TThread.NextThread;
var i: Integer;
    T: PThread;
    C: DWORD;
begin
  i := MainThread.AllThreads.IndexOf( MainThread.CurrentThread );
  if i >= 0 then
  begin
    C := GetTickCount;
    while TRUE do
    begin
      inc( i );
      if i >= MainThread.AllThreads.Count then i := 0;
      T := MainThread.AllThreads.Items[ i ];
      if (T.DoNotWakeUntil > C) and (T <> MainThread) then continue;
      if (T = MainThread) and (MainThread.CurrentThread = T) then Exit;
      if not T.Terminated and not ((T <> MainThread) and (T.Suspended)) then break;
    end;
    MainThread.SwitchToThread( MainThread.AllThreads.Items[ i ] );
  end;
end;

procedure Sleep( n: DWORD );
begin
  if Assigned( MainThread ) then
  begin
    MainThread.CurrentThread.DoNotWakeUntil := GetTickCount + n;
    MainThread.NextThread;
  end
  else
    if n > 0 then Windows.Sleep( n );
end;

function WaitForMultipleObjects( nCount: DWORD;
  lpHandles: PHandle; fWaitAll: BOOL; dwMilliseconds: DWORD ): DWORD; stdcall;
var i: Integer;
    w: DWORD;
    Ph: PHandle;
    Limit: DWORD;
begin
  if dwMilliseconds = INFINITE then
    Limit := INFINITE
  else
    Limit := GetTickCount + dwMilliseconds;
  while TRUE do
  begin
    Ph := lpHandles;
    w := 0;
    for i := 0 to nCount-1 do
    begin
      if Windows.WaitForSingleObject( Ph^, 0 ) = WAIT_OBJECT_0 then
      begin
        inc( w );
        if not fWaitAll then
        begin
          Result := WAIT_OBJECT_0 + i;
          Exit;
        end;
      end;
      inc( Ph );
    end;
    if w = nCount then
    begin
      Result := WAIT_OBJECT_0;
      Exit;
    end;
    if (Limit <> INFINITE) and (GetTickCount > Limit) then
    begin
      Result := WAIT_TIMEOUT;
      Exit;
    end;
    if Assigned( MainThread ) then
      MainThread.NextThread;
    {$IFDEF WAIT_SLEEP}
    Sleep( 10 );
    {$ENDIF}
  end;
end;

function WaitForSingleObject( hHandle: THandle; dwMilliseconds: DWORD ): DWORD; stdcall;
begin
  Result := WaitForMultipleObjects( 1, @ hHandle, TRUE, dwMilliseconds );
end;
{$ENDIF PSEUDO_THREADS}

//*
//[procedure TThread.Synchronize]
procedure TThread.Synchronize(Method: TThreadMethod);
begin
  {$IFDEF PSEUDO_THREADS}
  Method;
  {$ELSE}
  FMethod := Method;
  if Applet <> nil then
    SendMessage( Applet.fHandle, CM_EXECPROC, 0, Integer( @Self ) );
  {$ENDIF}
end;

//[procedure TThread.SynchronizeEx]
procedure TThread.SynchronizeEx( Method: TThreadMethodEx; Param: Pointer );
begin
  Assert( Param <> nil, 'Parameter must not be NIL' );
  {$IFDEF PSEUDO_THREADS}
  Method( TMethod( Method ).Data, Param );
  {$ELSE}
  FMethodEx := Method;
  SendMessage( Applet.fHandle, CM_EXECPROC, Integer( Param ), Integer( @Self ) );
  {$ENDIF}
end;

//*
//[procedure TThread.Terminate]
procedure TThread.Terminate;
begin
  {$IFDEF PSEUDO_THREADS}
  FTerminated := TRUE;
  if Assigned( MainThread ) then
  if MainThread.CurrentThread = @ Self then
    MainThread.NextThread;
  {$ELSE}
  TerminateThread(FHandle,0);
  FTerminated := True;
  {$ENDIF}
end;

//*
//[function TThread.WaitFor]
function TThread.WaitFor: Integer;
begin
  RefInc;
  Result := -1;
  {$IFDEF PSEUDO_THREADS}
  while not Terminated do
    Resume;
  if Terminated then
    Result := FResult;
  {$ELSE}
  if FHandle = 0 then Exit;
  WaitForSingleObject(FHandle, INFINITE);
  GetExitCodeThread(FHandle, DWORD(Result));
  {$ENDIF}
  RefDec;
end;

function TThread.WaitForTime(T: DWORD): Integer;
{$IFDEF PSEUDO_THREADS}
  var LimitTime: DWORD;
{$ENDIF}
begin
  {$IFDEF PSEUDO_THREADS}
  LimitTime := GetTickCount + T;
  RefInc;
  while not Terminated and (GetTickCount < LimitTime) do
    Resume;
  Result := -1;
  if Terminated then
    Result := FResult;
  RefDec;
  {$ELSE}
  Result := WAIT_OBJECT_0;
  RefInc;
  if FHandle = 0 then Exit;
  Result := WaitForSingleObject(FHandle, T);
  if Result = WAIT_OBJECT_0 then
    GetExitCodeThread(FHandle, T);
  RefDec;
  {$ENDIF}
end;

{$IFDEF _D2}
  {$DEFINE _D2orFPC}
{$ENDIF}
{$IFDEF _FPC}
  {$IFNDEF _D2orFPC}
    {$DEFINE _D2orFPC}
  {$ENDIF}
{$ENDIF}

function TThread.GetPriorityBoost: Boolean;
type TGetPriorityBoost = function(hThread: THandle;
         var DisablePriorityBoost: Bool): BOOL; stdcall;
var B: Bool;
    GPB: TGetPriorityBoost;
    M: THandle;
begin
  Result := TRUE;
  if fHandle = 0 then Exit;
  if (WinVer >= WvNT) then // by TK: only evaluate if this is true, regardless of evaluation settings
  begin
    M := GetModuleHandle( 'kernel32' );
    GPB := GetProcAddress( M, 'GetThreadPriorityBoost' );
    if Assigned( GPB ) then
    if GPB( fHandle, B ) then
      Result := B;
  end;
end;

procedure TThread.SetPriorityBoost(const Value: Boolean);
type TSetPriorityBoost = function(hThread: THandle;
         DisablePriorityBoost: Bool): Bool; stdcall;
var M: THandle;
    SPB: TSetPriorityBoost;
begin
  if fHandle = 0 then Exit;
  if WinVer >= WvNT then
  begin
    M := GetModuleHandle( 'kernel32' );
    SPB := GetProcAddress( M, 'SetThreadPriorityBoost' );
    if Assigned( SPB ) then
      SPB( fHandle, not Value );
  end;
end;

{ TStream }

{* This part of the unit contains implementation of streams for KOL. Please note,
   that both stream types (file stream and memory stream) are incapsulated
   by a single object type TStream. To avoid including unnedeed code,
   use constructing functions NewReadFileStream and NewWriteFileStream
   to work with file streams, which do not require both types of operation. }

{* To create new type of stream, define your own methods, and in your
   constructing function, pass it to _NewStream function (through
   TStreamMethods record). In a field Custom, You can store a reference to
   your own data of any type (but do not forget to define correct releasing
   of such data in your fClose procedure). }

//[function TStream.GetPosition]
function TStream.GetPosition: TStrmSize;
begin
  Result := Seek( 0, spCurrent );
end;

//[procedure TStream.SetPosition]
procedure TStream.SetPosition(const Value: TStrmSize);
begin
  Seek( Value, spBegin );
end;

//[function TStream.GetSize]
{$IFDEF ASM_STREAM}
function TStream.GetSize: TStrmSize;
asm
        CALL     [EAX].fMethods.fGetSiz
end;
{$ELSE ASM_VERSION} //Pascal
function TStream.GetSize: TStrmSize;
begin
  Result := fMethods.fGetSiz( @Self );
end;
{$ENDIF ASM_VERSION}

//[procedure TStream.SetSize]
{$IFDEF ASM_STREAM}
procedure TStream.SetSize(const NewSize: TStrmSize);
asm
        CALL     [EAX].fMethods.fSetSiz
end;
{$ELSE ASM_VERSION} //Pascal
procedure TStream.SetSize(const NewSize: TStrmSize);
begin
  fMethods.fSetSiz( @Self, NewSize );
end;
{$ENDIF ASM_VERSION}

//[function TStream.GetFileStreamHandle]
function TStream.GetFileStreamHandle: THandle;
begin
  Result := fData.fHandle;
end;

//[function TStream.Read]
{$IFDEF ASM_STREAM}
function TStream.Read(var Buffer; const Count: TStrmSize): TStrmSize;
asm
        CALL     [EAX].fMethods.fRead
end;
{$ELSE ASM_VERSION} //Pascal
function TStream.Read(var Buffer; const Count: TStrmSize): TStrmSize;
begin
  Result := fMethods.fRead( @Self, Buffer, Count );
end;
{$ENDIF ASM_VERSION}

//[function TStream.GetCapacity]
function TStream.GetCapacity: TStrmSize;
begin
  Result := fData.fCapacity;
end;

//[procedure TStream.SetCapacity]
procedure TStream.SetCapacity(const Value: TStrmSize);
var OldSize: DWORD;
    V: TStrmSize;
begin
  V := Value;
  {$IFDEF OLD_STREAM_CAPACITY}
  if fData.fCapacity >= Value then Exit;
  OldSize := Size;
  Size := V;
  Size := OldSize;
  {$ELSE}
  if Value < fData.fSize then V := fData.fSize;
  if Value > fData.fCapacity then
  begin
    OldSize := Size;
    Size := V;
    Size := OldSize;
  end
    else
  if fMemory <> nil then
  begin
    {$IFDEF _D4orHigher}
    fMemory := ReallocMemory( fMemory, V );
    {$ELSE}
    ReallocMem( fMemory, V );
    {$ENDIF}
    fData.fCapacity := V;
  end;
  {$ENDIF}
end;

//[function TStream.Busy]
function TStream.Busy: Boolean;
begin
  Result := Assigned( fData.fThread );
end;

//[function TStream.DoAsyncRead]
function TStream.DoAsyncRead( Sender: PThread ): Integer;
begin
  Read( Pointer( fParam1 )^, fParam2 );
  fData.fThread := nil;
  Result := 0;
end;

//[procedure TStream.ReadAsync]
procedure TStream.ReadAsync(var Buffer; Count: DWord);
begin
  if Busy then Wait;
  fData.fThread := NewThreadAutoFree( nil );
  fData.fThread.OnExecute := DoAsyncRead;
  fParam1 := DWORD( @ Buffer );
  fParam2 := Count;
  fData.fThread.Resume;
end;

//[function TStream.DoAsyncSeek]
function TStream.DoAsyncSeek( Sender: PThread ): Integer;
begin
  Seek( fParam1, TMoveMethod( fParam2 ) );
  fData.fThread := nil;
  Result := 0;
end;

//[procedure TStream.SeekAsync]
procedure TStream.SeekAsync(MoveTo: TStrmMove; MoveMethod: TMoveMethod);
begin
  if Busy then Wait;
  fData.fThread := NewThreadAutoFree( nil );
  fData.fThread.OnExecute := DoAsyncSeek;
  fParam1 := MoveTo;
  fParam2 := Ord( MoveMethod );
  fData.fThread.Resume;
end;

//[function TStream.DoAsyncWrite]
function TStream.DoAsyncWrite( Sender: PThread ): Integer;
begin
  Write( Pointer( fParam1 )^, fParam2 );
  fData.fThread := nil;
  Result := 0;
end;

//[procedure TStream.WriteAsync]
procedure TStream.WriteAsync(var Buffer; Count: DWord);
begin
  if Busy then Wait;
  fData.fThread := NewThreadAutoFree( nil );
  fData.fThread.OnExecute := DoAsyncWrite;
  fParam1 := DWORD( @ Buffer );
  fParam2 := Count;
  fData.fThread.Resume;
end;

//[procedure TStream.Wait]
procedure TStream.Wait;
begin
  if not Assigned( fData.fThread ) then Exit;
  if Assigned( fMethods.fWait ) then
    fMethods.fWait( @Self )
  else
    fData.fThread.WaitFor;
end;

//[function TStream.Write]
{$IFDEF ASM_STREAM}
function TStream.Write(var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize): TStrmSize;
asm
        CALL     [EAX].fMethods.fWrite
end;
{$ELSE ASM_VERSION} //Pascal
function TStream.Write(var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize): TStrmSize;
begin
  Result := fMethods.fWrite( @Self, Buffer, Count );
end;
{$ENDIF ASM_VERSION}

//[function TStream.WriteVal]
function TStream.WriteVal(Value, Count: DWORD): DWORD;
begin
  Result := Write( Value, Count );
end;

//[function TStream.WriteStr]
function TStream.WriteStr(S: AnsiString): DWORD;
begin
  if S <> '' then
    Result := fMethods.fWrite( @Self, S[1], Length( S ) )
  else
    Result := 0;
end;

//[function TStream.ReadStrZ]
function TStream.ReadStrZ: AnsiString;
var C: AnsiChar;
begin
  Result := '';
  REPEAT
    C := #0;
    Read( C, 1 );
    if C <> #0 then Result := Result + C;
  UNTIL C = #0;
end;

{$IFDEF _D3orHigher}
function TStream.ReadWStrZ: WideString;
var C: WideChar;
begin
  Result := '';
  REPEAT
    C := #0;
    Read( C, 2 );
    if C <> #0 then
      Result := Result +
       {$IFDEF _D3}
       WideString( C )
       {$ELSE}
       C
       {$ENDIF};
  UNTIL C = #0;
end;
{$ENDIF _D3orHigher}

//[function TStream.ReadStr]
function TStream.ReadStr: AnsiString;
var C: AnsiChar;
begin
  Result := '';
  REPEAT
    C := #0;
    Read( C, 1 );
    if C <> #0 then
    begin
      if C = #13 then
      begin
        C := #0;
        Read( C, 1 );
        if C <> #10 then Position := Position - 1;
        C := #13;
      end
        else
      if C = #10 then
        C := #13;
      if C <> #13 then
        Result := Result + C;
    end;
  UNTIL C in [ #13, #0 ];
end;

//[function TStream.ReadStrLen]
function TStream.ReadStrLen(Len: Integer): AnsiString;
var i: Integer;
begin
  SetLength( Result, Len );
  i := Read( Result[1], Len );
  SetLength( Result, i );
end;

//[function TStream.WriteStrZ]
function TStream.WriteStrZ(S: AnsiString): DWORD;
var C: AnsiChar;
begin
  if S = '' then
    begin
      C := #0;
      Result := Write( C, 1 );
    end
  else
    Result := Write( S[ 1 ], Length( S ) + 1 );
end;

{$IFDEF _D3orHigher}
function TStream.WriteWStrZ(S: WideString): DWORD;
var C: WideChar;
begin
  if S = '' then
    begin
      C := #0;
      Result := Write( C, 2 );
    end
  else
    Result := Write( S[ 1 ], (Length( S ) + 1) * 2 );
end;
{$ENDIF _D3orHigher}

//[function TStream.WriteStrEx]
function TStream.WriteStrEx(S: AnsiString): DWord;
var L: DWORD;
begin
  L := length(s);
  result:=fmethods.fwrite(@self,L,Sizeof(DWORD));
  if result = Sizeof(DWORD) then
    Inc( result, fmethods.fwrite(@self,s[1],L) );
end;

//[function TStream.ReadStrExVar]
function TStream.ReadStrExVar(var S: AnsiString): DWord;
begin
  fmethods.fread(@self,result,Sizeof(DWORD));
  setlength(s,result);
  if result<>0 then result:=fmethods.fread(@self,s[1],result);
end;

//[function TStream.ReadStrEx]
function TStream.ReadStrEx: AnsiString;
begin
  readstrexvar(result);
end;

//[function TStream.WriteStrPas]
function TStream.WriteStrPas( S: AnsiString ): DWORD;
var L: Integer;
begin
  Result := 0;
  L := Length( S );
  if L > 255 then L := 255;
  if Write( L, 1 ) < 1 then Exit;
  Result := 1;
  if L > 0 then
    Result := Write( S[ 1 ], L ) + 1;
end;

//[function TStream.ReadStrPas]
function TStream.ReadStrPas: AnsiString;
var L: Byte;
begin
  Result := '';
  if Read( L, 1 ) < 1 then Exit;
  SetLength( Result, L );
  L := Read( Result[ 1 ], L );
  Result := Copy( Result, 1, L );
end;

//[function TStream.Seek]
{$IFDEF ASM_STREAM}
function TStream.Seek({$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveMethod: TMoveMethod): TStrmSize;
//function TStream.Seek(MoveTo: TStrmMove; MoveMethod: TMoveMethod): TStrmSize;
asm
        CALL     [EAX].fMethods.fSeek
end;
{$ELSE ASM_VERSION} //Pascal
function TStream.Seek({$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveMethod: TMoveMethod): TStrmSize;
begin
  Result := fMethods.fSeek( @Self, MoveTo, MoveMethod );
end;
{$ENDIF ASM_VERSION}

//[destructor TStream.Destroy]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
destructor TStream.Destroy;
begin
  fMethods.fClose( @Self );
  fData.fThread.Free;
  inherited;
end;
{$ENDIF ASM_VERSION}

procedure TStream.SaveToFile(const Filename: KOLString; const Start, CountSave: TStrmSize);
var F: PStream;
    SavePos: DWORD;
begin
  F := NewWriteFileStream( Filename );
  SavePos := Position;
  Position := Start;
  Stream2Stream( F, @ Self, CountSave );
  Position := SavePos;
  F.Free;
end;

//+-
//[function _NewStream]
function _NewStream( const StreamMethods: TStreamMethods ): PStream;
begin
  {-}
  New( Result, Create );
  {+}{++}(*Result := PStream.Create;*){--}
  Move( StreamMethods, Result.fMethods, Sizeof( TStreamMethods ) );
  Result.fPMethods := @Result.fMethods;
end;

//+
//[function SeekFileStream]
function SeekFileStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveFrom: TMoveMethod ): TStrmSize;
begin
  Result := FileSeek( Strm.fData.fHandle, MoveTo, MoveFrom );
  {$IFDEF FILESTREAM_POSITION}
  Strm.fData.fPosition := Result;
  {$ENDIF}
end;

//+
//[function GetSizeFileStream]
function GetSizeFileStream( Strm: PStream ): TStrmSize;
{$IFDEF STREAM_LARGE64}
var SizeHigh: DWORD;
{$ENDIF}
begin
  {$IFDEF STREAM_LARGE64}
  Result := GetFileSize( Strm.fData.fHandle, @ SizeHigh );
  Result := Result or SizeHigh shl 32;
  {$ELSE}
  Result := GetFileSize( Strm.fData.fHandle, nil );
  if Result = DWORD( -1 ) then Result := 0;
  {$ENDIF}
end;

//[procedure DummySetSize]
procedure DummySetSize( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Value: TStrmSize );
begin
end;

//[procedure DummyStreamProc]
procedure DummyStreamProc(Strm: PStream);
begin
end;

//[function DummyReadWrite]
function DummyReadWrite( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
asm
  XOR EAX, EAX
end;

//[function ReadFileStream]
function ReadFileStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
begin
  Result := FileRead( Strm.fData.fHandle, Buffer, Count );
  {$IFDEF FILESTREAM_POSITION}
  inc( Strm.fData.fPosition, Result );
  {$ENDIF}
end;

function ReadFileStreamWithEvent( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
begin
  Result := FileRead( Strm.fData.fHandle, Buffer, Count );
  inc( Strm.fData.fPosition, Result );
  if (Result > 0) and Assigned( Strm.OnChangePos ) then
    Strm.OnChangePos( Strm );
end;

//[function WriteFileStream]
function WriteFileStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
begin
  Result := FileWrite( Strm.fData.fHandle, Buffer, Count );
  {$IFDEF FILESTREAM_POSITION}
  inc( Strm.fData.fPosition, Result );
  {$ENDIF}
end;

function WriteFileStreamWithEvent( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
begin
  Result := FileWrite( Strm.fData.fHandle, Buffer, Count );
  inc( Strm.fData.fPosition, Result );
  if (Result > 0) and Assigned( Strm.OnChangePos ) then
    Strm.OnChangePos( Strm );
end;

//[FUNCTION WriteFileStreamEOF]
{$IFDEF ASM_STREAM}
function WriteFileStreamEOF( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
asm
        PUSH     EBX
        PUSH     [EAX].TStream.fData.fHandle
        CALL     WriteFileStream
        XCHG     EBX, EAX
        CALL     SetEndOfFile
        XCHG     EAX, EBX
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
function WriteFileStreamEOF( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
begin
  Result := WriteFileStream( Strm, Buffer, Count );
  {$IFDEF FILESTREAM_POSITION}
  inc( Strm.fData.fPosition, Result );
  {$ENDIF}
  SetEndOfFile( Strm.fData.fHandle );
end;
{$ENDIF ASM_VERSION}
//[END WriteFileStreamEOF]

function WriteFileStreamEOFWithEvent( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
begin
  Result := WriteFileStream( Strm, Buffer, Count );
  inc( Strm.fData.fPosition, Result );
  SetEndOfFile( Strm.fData.fHandle );
  if (Result > 0) and Assigned( Strm.OnChangePos ) then
    Strm.OnChangePos( Strm );
end;

//[procedure CloseFileStream]
procedure CloseFileStream( Strm: PStream );
begin
  if Strm.fData.fHandle <> INVALID_HANDLE_VALUE then
    FileClose( Strm.fData.fHandle );
  Strm.fData.fHandle := INVALID_HANDLE_VALUE;
end;

//[FUNCTION SeekMemStream]
{$IFDEF ASM_STREAM}
function SeekMemStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF}
         MoveTo: TStrmMove; MoveFrom: TMoveMethod ): TStrmSize;
asm
        PUSH     EBX
        MOV      EBX, EDX
        AND      ECX, $FF
        LOOP     @@not_from_cur
        ADD      EBX, [EAX].TStream.fData.fPosition
@@not_from_cur:
        LOOP     @@not_from_end
        ADD      EBX, [EAX].TStream.fData.fSize
@@not_from_end:
        CMP      EBX, [EAX].TStream.fData.fSize
        JLE      @@space_ok
        PUSH     EAX
        MOV      EDX, EBX
        CALL     TStream.SetSize
        POP      EAX
@@space_ok:
        XCHG     EAX, EBX
        MOV      [EBX].TStream.fData.fPosition, EAX
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
function SeekMemStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF}
         MoveTo: TStrmMove; MoveFrom: TMoveMethod ): TStrmSize;
var NewPos: DWORD;
begin
  case MoveFrom of
  spBegin: NewPos := MoveTo;
  spCurrent: NewPos := Strm.fData.fPosition + DWORD( MoveTo );
  else //spEnd:
       NewPos := Strm.fData.fSize + DWORD( MoveTo );
  end;
  if NewPos > Strm.fData.fSize then
    Strm.SetSize( NewPos );
  Strm.fData.fPosition := NewPos;
  Result := NewPos;
end;
{$ENDIF ASM_VERSION}
//[END SeekMemStream]

function SeekMemStreamWithEvent( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveFrom: TMoveMethod ): TStrmSize;
var OldPos: DWORD;
begin
  OldPos := Strm.Position;
  Result := SeekMemStream( Strm, MoveTo, MoveFrom );
  if (OldPos <> Strm.Position) and Assigned( Strm.OnChangePos ) then
    Strm.OnChangePos( Strm );
end;

//[function GetSizeMemStream]
function GetSizeMemStream( Strm: PStream ): TStrmSize;
begin
  Result := Strm.fData.fSize;
end;

//[PROCEDURE SetSizeMemStream]
{$IFDEF ASM_STREAM}
procedure SetSizeMemStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} NewSize: TStrmSize );
asm
        push     ebx
        push     edx
        xchg     ebx, eax
        cmp      [ebx].TStream.fData.fCapacity, edx
        jae      @@mem_ok
        {$IFDEF OLD_MEMSTREAMS_SETSIZE}
        or       edx, [CapacityMask]
        inc      edx
        {$ENDIF}
        mov      [ebx].TStream.fData.fCapacity, edx
        mov      ecx, [ebx].TStream.fMemory
        jecxz    @@getmem
        lea      eax, [ebx].TStream.fMemory
        call     System.@ReallocMem
        jmp      @@setmem

@@getmem:
        or       ecx, edx
        jz       @@mem_ok
        xchg     eax, ecx
        call     System.@GetMem
@@setmem:
        mov      [ebx].TStream.fMemory, eax

@@mem_ok:
        pop      ecx // NewSize
        inc      ecx
        loop     @@set_new_sz
        cmp      [ebx].TStream.fData.fSize, ecx
        jz       @@set_new_sz

        mov      [ebx].TStream.fData.fCapacity, ecx
        xchg     ecx, [ebx].TStream.fMemory
        jecxz    @@mem_freed
        xchg     eax, ecx
        call     System.@FreeMem
@@mem_freed:
        xor      ecx, ecx

@@set_new_sz:
        mov      [ebx].TStream.fData.fSize, ecx
        cmp      [ebx].TStream.fData.fPosition, ecx
        jb       @@exit
        mov      [ebx].TStream.fData.fPosition, ecx

@@exit:
        pop      ebx
end;
{$ELSE ASM_VERSION} //Pascal
procedure SetSizeMemStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} NewSize: TStrmSize );
var S: PStream;
    NewCapacity: DWORD;
begin
  S := Strm;
  if S.fData.fCapacity < NewSize then
  begin
    {$IFDEF OLD_MEMSTREAMS_SETSIZE}
    NewCapacity := (NewSize or CapacityMask) + 1;
    {$ELSE}
    NewCapacity := NewSize;
    {$ENDIF}
    if S.fMemory = nil then
    begin
      if NewSize <> 0 then
         GetMem( S.fMemory, NewCapacity );
    end
      else
      ReallocMem( S.fMemory, NewCapacity );
    S.fData.fCapacity := NewCapacity;
  end
    else
  if (NewSize = 0) and (S.Size > 0) then
  begin
    if S.fMemory <> nil then
    begin
      FreeMem( S.fMemory );
      S.fMemory := nil;
      S.fData.fCapacity := 0;
    end;
  end;
  S.fData.fSize := NewSize;
  if S.fData.fPosition > S.fData.fSize then
     S.fData.fPosition := S.fData.fSize;
end;
{$ENDIF ASM_VERSION}
//[END SetSizeMemStream]

//[FUNCTION ReadMemStream]
{$IFDEF ASM_STREAM}
function ReadMemStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
asm
        PUSH     EBX
        XCHG     EBX, EAX
        MOV      EAX, [EBX].TStream.fData.fPosition
        ADD      EAX, ECX
        CMP      EAX, [EBX].TStream.fData.fSize
        JLE      @@count_ok
        MOV      ECX, [EBX].TStream.fData.fSize
        SUB      ECX, [EBX].TStream.fData.fPosition
@@count_ok:
        PUSH     ECX
        MOV      EAX, [EBX].TStream.fMemory
        ADD      EAX, [EBX].TStream.fData.fPosition
        CALL     System.Move
        POP      EAX
        ADD      [EBX].TStream.fData.fPosition, EAX
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
function ReadMemStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
var S: PStream;
    C: TStrmSize;
begin
  S := Strm;
  C := Count;
  if C + S.fData.fPosition > S.fData.fSize then
     C := S.fData.fSize - S.fData.fPosition;
  Result := C;
  Move( Pointer( DWORD(S.fMemory) + S.fData.fPosition )^, Buffer, Result );
  Inc( S.fData.fPosition, Result );
end;
{$ENDIF ASM_VERSION}
//[END ReadMemStream]

function ReadMemStreamWithEvent( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
begin
  Result := ReadMemStream( Strm, Buffer, Count );
  if (Result > 0) and Assigned( Strm.OnChangePos ) then
    Strm.OnChangePos( Strm );
end;

//[FUNCTION WriteMemStream]
{$IFDEF ASM_STREAM}
function WriteMemStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
asm
        PUSH     EBX
        XCHG     EBX, EAX
        MOV      EAX, [EBX].TStream.fData.fPosition
        ADD      EAX, ECX
        CMP      EAX, [EBX].TStream.fData.fSize
        PUSH     EDX
        PUSH     ECX
        JLE      @@count_ok
        XCHG     EDX, EAX
        MOV      EAX, EBX
        CALL     TStream.SetSize
@@count_ok:
        POP      ECX
        POP      EAX
        MOV      EDX, [EBX].TStream.fMemory
        ADD      EDX, [EBX].TStream.fData.fPosition
        PUSH     ECX
        CALL     System.Move
        POP      EAX
        ADD      [EBX].TStream.fData.fPosition, EAX
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
function WriteMemStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
var S: PStream;
begin
  S := Strm;
  if Count + S.fData.fPosition > S.fData.fSize then
     S.SetSize( S.fData.fPosition + Count );
  Result := Count;
  Move( Buffer, Pointer( DWORD(S.fMemory) + S.fData.fPosition )^, Result );
  Inc( S.fData.fPosition, Result );
end;
{$ENDIF ASM_VERSION}
//[END WriteMemStream]

function WriteMemStreamWithEvent( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
begin
  Result := WriteMemStream( Strm, Buffer, Count );
  if (Result > 0) and Assigned( Strm.OnChangePos ) then
    Strm.OnChangePos( Strm );
end;

//[PROCEDURE CloseMemStream]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
procedure CloseMemStream( Strm: PStream );
var S: PStream;
begin
  S := Strm;
  if S.fMemory <> nil then
  begin
    FreeMem( S.fMemory );
    S.fMemory := nil;
  end;
end;
{$ENDIF ASM_VERSION}
//[END CloseMemStream]

procedure DummyCloseStream( Strm: PStream );
begin
  // nothing here
end;

// by Roman Vorobets:
//[procedure SetSizeFileStream]
procedure SetSizeFileStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} NewSize: TStrmSize );
var
  P: DWORD;
begin
  P:=Strm.Position;
  Strm.Position:=NewSize;
  SetEndOfFile(Strm.Handle);
  if P < NewSize then
    Strm.Position:=P;
end;

function SeekConcatStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveFrom: TMoveMethod ): TStrmSize;
var NewPos: TStrmSize;
begin
  NewPos := MoveTo;
  CASE MoveFrom OF
  spCurrent: NewPos := TStrmMove( Strm.fData.fPosition ) + MoveTo;
  spEnd    : NewPos := TStrmMove( Strm.Size ) + MoveTo;
  END;
  if Strm.fData.fStream1.Size > NewPos then
  begin
    Strm.fData.fStream1.Position := NewPos;
    Strm.fData.fStream2.Position := 0;
  end
  else
  begin
    Strm.fData.fStream1.Position := Strm.fData.fStream1.Size;
    Strm.fData.fStream2.Position := NewPos - Strm.fData.fStream1.Size;
  end;
  Strm.fData.fPosition := Strm.fData.fStream1.Position + Strm.fData.fStream2.Position;
  Result := Strm.fData.fPosition;
end;

function GetSizeConcatStream( Strm: PStream ): TStrmSize;
begin
  Result := Strm.fData.fStream1.Size + Strm.fData.fStream2.Size;
end;

procedure SetSizeConcatStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} NewSize: TStrmSize );
var New_Sz, Sz1: TStrmSize;
begin
  New_Sz := NewSize;
  Sz1 := Strm.fData.fStream1.Size;
  if New_Sz < Sz1 then
    New_Sz := Sz1;
  Strm.fData.fStream2.Size := New_Sz - Sz1;
end;

function ReadConcatStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
var C, Sz1, ToRead: TStrmSize;
    ToAddr: PByte;
begin
  C := Count;
  Sz1 := Strm.fData.fStream1.Size;
  ToAddr := @ Buffer;
  Result := 0;
  if Strm.Position < Sz1 then
  begin
    ToRead := C;
    if Strm.Position + C > Sz1 then
      ToRead := Sz1 - Strm.Position;
    Result := Strm.fData.fStream1.Read( ToAddr^, ToRead );
    Strm.fData.fPosition := Strm.fData.fStream1.Position;
    dec( C, Result );
    inc( ToAddr, Result );
    if Result < ToRead then Exit;
    Strm.fData.fStream2.Position := 0;
  end;
  if C <= 0 then Exit;
  Result := Result + Strm.fData.fStream2.Read( ToAddr^, C );
  Strm.fData.fPosition := Strm.fData.fStream1.Size +
                          Strm.fData.fStream2.Position;
end;

function WriteConcatStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
var C, Sz1, ToWrite: TStrmSize;
    FromAddr: PByte;
begin
  C := Count;
  Sz1 := Strm.fData.fStream1.Size;
  FromAddr := @ Buffer;
  Result := 0;
  if Strm.Position < Sz1 then
  begin
    ToWrite := C;
    if Strm.Position + C > Sz1 then
      ToWrite := Sz1 - Strm.Position;
    Result := Strm.fData.fStream1.Write( FromAddr^, ToWrite );
    Strm.fData.fPosition := Strm.fData.fStream1.Position;
    dec( C, Result );
    inc( FromAddr, Result );
    if Result < ToWrite then Exit;
    Strm.fData.fStream2.Position := 0;
  end;
  if C <= 0 then Exit;
  Result := Result + Strm.fData.fStream2.Write( FromAddr^, C );
  Strm.fData.fPosition := Strm.fData.fStream1.Size +
                          Strm.fData.fStream2.Position;
end;

procedure CloseConcatStream( Strm: PStream );
begin
  Strm.fData.fStream1.fMethods.fClose( Strm.fData.fStream1 );
  Strm.fData.fStream2.fMethods.fClose( Strm.fData.fStream2 );
end;

function SeekSubStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} MoveTo: TStrmMove; MoveFrom: TMoveMethod ): TStrmSize;
var NewPos, OldPos: TStrmMove;
begin
  OldPos := Strm.fData.fBaseStream.Position - Strm.fData.fFromPos;
  {$IFDEF STREAM_LARGE64}
  if OldPos < 0 then OldPos := 0;
  {$ENDIF}
  CASE MoveFrom OF
  spCurrent: NewPos := OldPos + MoveTo;
  spEnd    : NewPos := TStrmMove( Strm.Size ) + MoveTo;
  else       NewPos := MoveTo;
  END;
  {$IFDEF STREAM_LARGE64}
  if NewPos < 0 then NewPos := 0;
  {$ENDIF}
  Strm.fData.fBaseStream.Position := Strm.fData.fFromPos + TStrmSize( NewPos );
  Result := Strm.fData.fBaseStream.Position - Strm.fData.fFromPos;
  if Result > Strm.fData.fSize then
    Strm.fData.fSize := Result;
end;

function GetSizeSubStream( Strm: PStream ): TStrmSize;
begin
  Result := Strm.fData.fSize;
end;

procedure SetSizeSubStream( Strm: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} NewSize: TStrmSize );
begin
  {$IFDEF STREAM_LARGE64}
  if NewSize >= 0 then
  {$ENDIF}
    Strm.fData.fSize := NewSize;
end;

function ReadSubStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
var C: TStrmSize;
begin
  C := Count;
  if Strm.Position + C > Strm.Size then
    C := Strm.Size - Strm.Position;
  Result := Strm.fData.fBaseStream.Read( Buffer, C );
end;

function WriteSubStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
begin
  Result := Strm.fData.fBaseStream.Write( Buffer, Count );
end;

procedure CloseSubStream( Strm: PStream );
begin
  Strm.fData.fBaseStream.fMethods.fClose( Strm.fData.fBaseStream );
end;


//[function NewFileStream]
function NewFileStream( const FileName: KOLString; Options: DWORD ): PStream;
begin
  Result := _NewStream( BaseFileMethods );
  Result.fMethods.fRead := ReadFileStreamProc;
  Result.fMethods.fWrite := WriteFileStream; // not WriteStreamEOF,  
  Result.fMethods.fSetSiz := SetSizeFileStream;
  Result.fData.fHandle := FileCreate( FileName, Options );
end;

function NewFileStreamWithEvent( const FileName: KOLString; Options: DWORD ): PStream;
begin
  Result := _NewStream( BaseFileMethods );
  Result.fMethods.fRead := ReadFileStreamWithEvent;
  Result.fMethods.fWrite := WriteFileStreamWithEvent; // not WriteStreamEOF,  
  Result.fMethods.fSetSiz := SetSizeFileStream;
  Result.fData.fHandle := FileCreate( FileName, Options );
end;

//[FUNCTION NewReadFileStream]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function NewReadFileStream( const FileName: KOLString ): PStream;
begin
  Result := _NewStream( BaseFileMethods );
  Result.fMethods.fRead := ReadFileStreamProc;
  Result.fData.fHandle := FileCreate( FileName,
                                      ofOpenRead or ofShareDenyWrite or ofOpenExisting );
end;
{$ENDIF ASM_VERSION}
//[END NewReadFileStream]

function NewReadFileStreamWithEvent( const FileName: KOLString ): PStream;
begin
  Result := _NewStream( BaseFileMethods );
  Result.fMethods.fRead := ReadFileStreamWithEvent;
  Result.fData.fHandle := FileCreate( FileName,
                                      ofOpenRead or ofShareDenyWrite or ofOpenExisting );
end;

function NewExFileStream( F: HFile ): PStream;
begin
  Result := _NewStream( BaseFileMethods );
  Result.fMethods.fRead := ReadFileStreamProc;
  Result.fMethods.fWrite := WriteFileStream;
  Result.fData.fHandle := F;
  Result.fMethods.fClose := DummyCloseStream;
end;

{$IFDEF _D3orHigher}
function NewReadFileStreamW( const FileName: WideString ): PStream;
begin
  Result := _NewStream( BaseFileMethods );
  Result.fMethods.fRead := ReadFileStreamProc;
  Result.fData.fHandle := WFileCreate( FileName,
                                      ofOpenRead or ofShareDenyWrite or ofOpenExisting );
end;
{$ENDIF _D3orHigher}

//[FUNCTION NewWriteFileStream]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function NewWriteFileStream( const FileName: KOLString ): PStream;
begin
  Result := _NewStream( BaseFileMethods );
  Result.fMethods.fWrite := WriteFileStreamEOF;
  Result.fMethods.fSetSiz := SetSizeFileStream;
  Result.fData.fHandle := FileCreate( FileName,
                                      ofOpenWrite or ofCreateAlways or ofShareDenyWrite );
end;
{$ENDIF ASM_VERSION}
//[END NewWriteFileStream]

function NewWriteFileStreamWithEvent( const FileName: KOLString ): PStream;
begin
  Result := _NewStream( BaseFileMethods );
  Result.fMethods.fWrite := WriteFileStreamEOFWithEvent;
  Result.fMethods.fSetSiz := SetSizeFileStream;
  Result.fData.fHandle := FileCreate( FileName,
                                      ofOpenWrite or ofCreateAlways or ofShareDenyWrite );
end;

{$IFDEF _D3orHigher}
function NewWriteFileStreamW( const FileName: WideString ): PStream;
begin
  Result := _NewStream( BaseFileMethods );
  Result.fMethods.fWrite := WriteFileStreamEOF;
  Result.fMethods.fSetSiz := SetSizeFileStream;
  Result.fData.fHandle := WFileCreate( FileName,
                                      ofOpenWrite or ofCreateAlways or ofShareDenyWrite );
end;
{$ENDIF _D3orHigher}

//[FUNCTION NewReadWriteFileStream]
{$IFDEF ASM_noVERSION}
function NewReadWriteFileStream( const FileName: AnsiString ): PStream;
asm
        PUSH     EBX
        XCHG     EBX, EAX
        MOV      EAX, offset[BaseFileMethods]
        CALL     _NewStream
        MOV      EDX, [ReadFileStreamProc]
        MOV      [EAX].TStream.fMethods.fRead, EDX
        MOV      [EAX].TStream.fMethods.fWrite, offset[WriteFileStream]
        MOV      [EAX].TStream.fMethods.fSetSiz, offset[SetSizeFileStream]
        XCHG     EBX, EAX

        PUSH     EAX
        CALL     FileExists
        MOV      EDX, ofOpenReadWrite or ofCreateAlways or ofShareDenyWrite
        ADD      DH, AL // $200 (ofCreateAlways) -> $300 (ofCreateExisting)
        POP      EAX

        CALL     FileCreate
        MOV      [EBX].TStream.fData.fHandle, EAX
        XCHG     EAX, EBX
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
function NewReadWriteFileStream( const FileName: KOLString ): PStream;
var Creation: DWORD;
begin
  Result := _NewStream( BaseFileMethods );
  Result.fMethods.fRead := ReadFileStreamProc;
  Result.fMethods.fWrite := WriteFileStream;
  Result.fMethods.fSetSiz := SetSizeFileStream;
  Creation := ofCreateAlways;
  if FileExists( FileName ) then Creation := ofOpenExisting;
  Result.fData.fHandle := FileCreate( FileName,
                          ofOpenReadWrite or Creation or ofShareDenyWrite );
end;
{$ENDIF ASM_VERSION}
//[END NewReadWriteFileStream]

{$IFDEF _D3orHigher}
function NewReadWriteFileStreamW( const FileName: WideString ): PStream;
var Creation: DWORD;
begin
  Result := _NewStream( BaseFileMethods );
  Result.fMethods.fRead := ReadFileStreamProc;
  Result.fMethods.fWrite := WriteFileStream;
  Result.fMethods.fSetSiz := SetSizeFileStream;
  Creation := ofCreateAlways;
  if WFileExists( FileName ) then Creation := ofOpenExisting;
  Result.fData.fHandle := WFileCreate( FileName,
                          ofOpenReadWrite or Creation or ofShareDenyWrite );
end;
{$ENDIF _D3orHigher}

//[function NewMemoryStream]
function NewMemoryStream: PStream;
begin
  Result := _NewStream( MemoryMethods );
end;

function NewMemoryStreamWithEvent: PStream;
begin
  Result := _NewStream( MemoryMethods );
  Result.fMethods.fRead := ReadMemStreamWithEvent;
  Result.fMethods.fWrite := WriteMemStreamWithEvent;
end;

//[FUNCTION WriteExMemoryStream]
{$IFDEF ASM_STREAM}
function WriteExMemoryStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
asm
        PUSH     EBX
        XCHG     EBX, EAX
        MOV      EAX, [EBX].TStream.fData.fSize
        SUB      EAX, [EBX].TStream.fData.fPosition
        CMP      EAX, ECX
        JGE      @@1
        XCHG     ECX, EAX
@@1:
        PUSH     EDX
        PUSH     ECX
        JLE      @@count_ok
        XCHG     EDX, EAX
        MOV      EAX, EBX
        CALL     TStream.SetSize
@@count_ok:
        POP      ECX
        POP      EAX
        MOV      EDX, [EBX].TStream.fMemory
        ADD      EDX, [EBX].TStream.fData.fPosition
        PUSH     ECX
        CALL     System.Move
        POP      EAX
        ADD      [EBX].TStream.fData.fPosition, EAX
        POP      EBX
end;
{$ELSE ASM_VERSION}
function WriteExMemoryStream( Strm: PStream; var Buffer; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize; 
var S: PStream;
    C: TStrmSize;
begin
  S := Strm;
  C := Count;
  if C + S.fData.fPosition > S.fData.fSize then
    C := S.fData.fSize - S.fData.fPosition;
  Result := C;
  Move( Buffer, Pointer( DWORD(S.fMemory) + S.fData.fPosition )^, Result );
  Inc( S.fData.fPosition, Result );
end;
{$ENDIF ASM_VERSION}
//[END WriteExMemoryStream]

//[procedure DummyClose_ExMemStream]
procedure DummyClose_ExMemStream( Strm: PStream );
begin
  // nothing to do - ignore call (memory is not released by any way)
end;

//[function NewExMemoryStream]
function NewExMemoryStream( ExistingMem: Pointer; Size: DWORD ): PStream;
begin
  Result := NewMemoryStream;
  Result.fMemory := ExistingMem;
  Result.fData.fCapacity := Size;
  Result.fData.fSize := Size;
  Result.fMethods.fWrite := WriteExMemoryStream;
  Result.fMethods.fSetSiz := DummySetSize;
  Result.fMethods.fClose := DummyClose_ExMemStream;
end;

function NewConcatStream( Stream1, Stream2: PStream ): PStream;
begin
  Result := _NewStream( ConcatStreamMethods );
  Result.fData.fStream1 := Stream1;
  Result.fData.fStream2 := Stream2;
  Result.Add2AutoFree( Stream1 );
  Result.Add2AutoFree( Stream2 );
end;

function NewSubStream( BaseStream: PStream; const FromPos, Size: TStrmSize ): PStream;
begin
  Result := _NewStream( SubStreamMethods );
  Result.fData.fBaseStream := BaseStream;
  Result.fData.fFromPos := FromPos;
  Result.fData.fSize := Size;
  Result.Position := 0;
  Result.Add2AutoFree( BaseStream );
end;

//*
//[function Stream2Stream]
function Stream2Stream( Dst, Src: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
var Buf: Pointer;
    C: TStrmSize;
begin
  C := Count;
  if Src.fMemory <> nil then
  begin
     if Src.fData.fPosition + C > Src.fData.fSize then
        C := Src.fData.fSize - Src.fData.fPosition;
     Result := Dst.Write( Pointer(DWORD(Src.fMemory)+Src.fData.fPosition)^,
                   C );
     Inc( Src.fData.fPosition, Result );
  end
     else
  if Dst.fMemory <> nil then
  begin
    if Dst.fData.fPosition + C > Dst.fData.fSize then
       Dst.SetSize( Dst.fData.fPosition + C );
    Result := Src.Read( Pointer( DWORD( Dst.fMemory ) + Dst.fData.fPosition )^,
                        C );
    Inc( Dst.fData.fPosition, Result );
  end
     else
  begin
    GetMem( Buf, C );
    C := Src.Read( Buf^, C );
    Result := Dst.Write( Buf^, C );
    FreeMem( Buf );
  end;
end;

//[function Stream2StreamEx]
function Stream2StreamEx( Dst, Src: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize ): TStrmSize;
begin
  Result := Stream2StreamExBufSz( Dst, Src, Count, 65536 );
end;

//[function Stream2StreamExBufSz]
function Stream2StreamExBufSz( Dst, Src: PStream; {$IFNDEF STREAM_COMPAT} const {$ENDIF} Count: TStrmSize; BufSz: DWORD ): TStrmSize;
var
  buf:pointer;
  rd, wr:dword;
  C: TStrmSize;
begin
  C := Count;
  if C=0 then result:=0 else
  begin
    result:=0;
    BufSz := Min( BufSz, C );
    if BufSz = 0 then BufSz := C;
    getmem(buf,BufSz);
    repeat
      if C<BufSz then rd:=c else rd:=BufSz;
      rd:=src.read(buf^,rd);
      wr := dst.write(buf^,rd);
      inc(result,wr);
      dec(C, rd);
    until (rd<>BufSz) or (C=0);
    freemem(buf);
  end;
end;

//[FUNCTION Resource2Stream]
{$IFDEF ASM_UNICODE}
  {$IFNDEF STREAM_LARGE64}
    {$DEFINE ASM_Resource2Stream}
  {$ENDIF}
{$ENDIF}

{$IFDEF ASM_Resource2Stream}
function Resource2Stream( DestStrm : PStream; Inst : HInst;
                          ResName : PAnsiChar; ResType : PAnsiChar ): Integer;
asm
        PUSH     EBX
        PUSH     ESI
        MOV      EBX, EDX // EBX = Inst
        PUSH     EAX      // DestStrm
        PUSH     ResType
        PUSH     ECX
        PUSH     EDX
        CALL     FindResource
        TEST     EAX, EAX
        JZ       @@exit0

        PUSH     EAX
        PUSH     EBX
        PUSH     EAX
        PUSH     EBX
        CALL     SizeofResource
        XCHG     EBX, EAX
        CALL     LoadResource
        TEST     EAX, EAX
        JZ       @@exit0
        XCHG     ESI, EAX

        PUSH     ESI
        CALL     GlobalLock
        TEST     EAX, EAX
        JNZ      @@P_ok

        CALL     GetLastError
        CMP      EAX, ERROR_INVALID_HANDLE
        JNZ      @@exit_00
        MOV      EAX, ESI

@@P_ok:
        XCHG     EDX, EAX
        POP      EAX // DestStrm
        PUSH     EDX
        MOV      ECX, EBX
        CALL     TStream.Write

        //EAX = Result (length of written data)
        XCHG     EBX, EAX
        POP      EAX
        CMP      ESI, EAX
        JE       @@not_unlock

        PUSH     ESI
        CALL     GlobalUnlock
@@not_unlock:
        XCHG     EAX, EBX
        JMP      @@exit

@@exit_00:
        XOR      EAX, EAX
@@exit0:
        POP      ECX
@@exit:
        POP      ESI
        POP      EBX
end;
{$ELSE ASM_VERSION} //Pascal
function Resource2Stream( DestStrm : PStream; Inst : HInst;
                          ResName : PKOLChar; ResType : PKOLChar ): Integer;
var R : HRSRC;
    G : HGlobal;
    P : PAnsiChar;
    Sz : DWORD;
    E : Integer;
begin
  Result := 0;
  R := FindResource( Inst, ResName, ResType );
  if R <> 0 then
  begin
    Sz := SizeofResource( Inst, R );
    G := LoadResource( Inst, R );
    if G <> 0 then
    begin
      P := GlobalLock( G );
      if P = nil then
      begin
        E := GetLastError;
        if E = ERROR_INVALID_HANDLE then
           P := Pointer( G )
        else
           Exit;
      end;
      Result := DestStrm.Write( P^, Sz );
      if P <> Pointer( G ) then
        GlobalUnlock( G );
      //FreeResource( G );
      { from Win32.hlp: "You do not need to call the FreeResource
        function to free a resource loaded by using the LoadResource
        function." }
    end;
  end;
end;
{$ENDIF ASM_VERSION}
//[END Resource2Stream]

///////////////////////////////////////////////////////////////////////////
//                        I  N  I  -  F  I  L  E  S
///////////////////////////////////////////////////////////////////////////

{ TIniFile }

//[destructor TIniFile.Destroy]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
destructor TIniFile.Destroy;
begin
  fFileName := '';
  fSection := '';
  inherited;
end;
{$ENDIF ASM_VERSION}

{$IFNDEF _D5orHigher}
// Place here correct definition for WritePrivateProfileStruct
// and GetPrivateProfileStruct (a bug in Delphi2, Delphi3 and Delphi4)
//[API WritePrivateProfileStruct]
//dufa
{function WritePrivateProfileStruct(lpszSection, lpszKey: PAnsiChar;
  lpStruct: Pointer; uSizeStruct: UINT; szFile: PAnsiChar): BOOL; stdcall;
  external kernel32 name 'WritePrivateProfileStructA';
//[API GetPrivateProfileStruct]
function GetPrivateProfileStruct(lpszSection, lpszKey: PAnsiChar;
  lpStruct: Pointer; uSizeStruct: UINT; szFile: PAnsiChar): BOOL; stdcall;
  external kernel32 name 'GetPrivateProfileStructA';}

// + by Slava A. Gavrik:
////////////////////////////////////////////////////////////////////////////
//[function WritePrivateProfileSection]
//dufa
{function WritePrivateProfileSection(lpAppName, lpString,
  lpFileName: PAnsiChar): BOOL; stdcall;
  external kernel32 name 'WritePrivateProfileSectionA';
//[function GetPrivateProfileSection]
function GetPrivateProfileSection(lpAppName: PAnsiChar; lpReturnedString: PAnsiChar;
  nSize: DWORD; lpFileName: PAnsiChar): DWORD; stdcall;
  external kernel32 name 'GetPrivateProfileSectionA';

//[function GetPrivateProfileSectionNames]
function GetPrivateProfileSectionNames(lpszReturnBuffer: PAnsiChar; nSize:
DWORD;
  lpFileName: PAnsiChar): DWORD; stdcall;
  external kernel32 name 'GetPrivateProfileSectionNamesA';}
////////////////////////////////////////////////////////////////////////////
{$ENDIF}

//[procedure TIniFile.ClearAll]
procedure TIniFile.ClearAll;
begin
  WritePrivateProfileString( nil, nil, nil,
                             PKOLChar( fFileName ) );
end;

//[procedure TIniFile.ClearKey]
procedure TIniFile.ClearKey(const Key: KOLString);
begin
  WritePrivateProfileString( PKOLChar( fSection ), PKOLChar( Key ), nil,
                             PKOLChar( fFileName ) );
end;

//[procedure TIniFile.ClearSection]
procedure TIniFile.ClearSection;
begin
  WritePrivateProfileString( PKOLChar( fSection ), nil, nil,
                             PKOLChar( fFileName ) );
end;

//[function TIniFile.ValueBoolean]
function TIniFile.ValueBoolean(const Key: KOLString; Value: Boolean): Boolean;
begin
  if fMode = ifmRead then
     Result := GetPrivateProfileInt( PKOLChar( fSection ), PKOLChar( Key ),
               Integer( Value ), PKOLChar( fFileName ) ) <> 0
  else
  begin
    WritePrivateProfileString( PKOLChar( fSection ), PKOLChar( Key ),
              PKOLChar( KOLString( Int2Str( Integer( Value ) ) ) ),
              PKOLChar( fFileName ) );
    Result := Value;
  end;
end;

//[function TIniFile.ValueData]
function TIniFile.ValueData(const Key: KOLString; Value: Pointer;
  Count: Integer): Boolean;
begin
  if fMode = ifmRead then
     Result := GetPrivateProfileStruct( PKOLChar( fSection ), PKOLChar( Key ),
               Value, Count, PKOLChar( fFileName ) )
  else
     Result := WritePrivateProfileStruct( PKOLChar( fSection ), PKOLChar( Key ),
               Value, Count, PKOLChar( fFileName ) );
end;

//[function TIniFile.ValueInteger]
function TIniFile.ValueInteger(const Key: KOLString; Value: Integer): Integer;
begin
  if fMode = ifmRead then
     Result := GetPrivateProfileInt( PKOLChar( fSection ), PKOLChar( Key ),
               Integer( Value ), PKOLChar( fFileName ) )
  else
  begin
     Result := Value;
     WritePrivateProfileString( PKOLChar( fSection ), PKOLChar( Key ),
               PKOLChar( KOLString( Int2Str( Value ) ) ), PKOLChar( fFileName ) );
  end;
end;

//[function TIniFile.ValueString]
function TIniFile.ValueString(const Key, Value: KOLString): KOLString;
var
  Buffer: array[0..4095] of KOLChar;
begin
  if fMode = ifmRead then
  begin
    Buffer[ 0 ] := #0;
    if GetPrivateProfileString(PKOLChar(fSection),
         PKOLChar(Key), PKOLChar(Value), Buffer, SizeOf(Buffer) div Sizeof(KOLChar),
         PKOLChar(fFileName)) <> 0 then
     Result := Buffer
    else
     Result := ''; //   ,  FPC     Key  INI- // MTsv DN
  end
    else
  begin
     Result := Value;
     WritePrivateProfileString( PKOLChar( fSection ), PKOLChar( Key ),
               PKOLChar( Value ), PKOLChar( fFileName ) );
  end;
end;

function TIniFile.ValueDouble(const Key: KOLString; const Value: Double): Double;
begin
  Result := Str2Double( ValueString( Key, Double2Str( Value ) ) );
end;

//[function OpenIniFile]
function OpenIniFile( const FileName: KOLString ): PIniFile;
begin
  {-}
  New( Result, Create );
  {+}{++}(*Result := PIniFile.Create;*){--}
  Result.fFileName := FileName;
end;

/////////////////////////////////////////////////// GetSectionNames, SectionData
// - by Vyacheslav A. Gavrik :

const
  IniBufferSize = 32767;
  IniBufferStrSize = IniBufferSize+4;         ///   :)

//[procedure TIniFile.GetSectionNames]
{$IFDEF ASM_UNICODE}
procedure _FillStrList;    //        
asm
///////////////////////////////
        OR      EAX,0
        JE      @@EXIT                  //ERROR
//        LEA     EAX,[EAX-IniBufferSize]
//        JE      @@EXIT
//        ...     :)
//        ...
//////////////////////////////
@@LOOP:
        LEA     EAX,[ESI+4]
        CALL    StrLen
        MOV     [ESI],EAX
        LEA     EDX,[ESI+4]
        INC     EAX
        ADD     ESI,EAX

        MOV     EAX,EDI

        CALL    TStrList.ADD

        CMP     byte ptr [ESI+4],0
        JNE     @@LOOP

@@EXIT:
        POP     EAX
        CALL    System.@FreeMem


        POP     ECX
        POP     EBX
        POP     EDI
        POP     ESI
end;

procedure TIniFile.GetSectionNames(Names: PStrList);
asm
        PUSH    ESI
        PUSH    EDI
        PUSH    EBX
        PUSH    ECX

        MOV     EBX,EAX
        MOV     EAX, IniBufferStrSize
        MOV     EDI,EDX

        CALL    System.@GetMem
        MOV     ESI,EAX
        PUSH    EAX

        PUSH    [EBX].fFileName
        MOV     EAX,IniBufferSize
        PUSH    EAX

        LEA     EAX,[ESI+4]
        PUSH    EAX

        CALL    GetPrivateProfileSectionNames
        JMP     _FillStrList
end;

procedure TIniFile.SectionData(Names: PStrList);
asm
        PUSH    ESI
        PUSH    EDI
        PUSH    EBX
        PUSH    ECX

        MOV     EBX,EAX
        MOV     EAX, IniBufferStrSize
        MOV     EDI,EDX

        CALL    System.@GetMem
        MOV     ESI,EAX
        PUSH    EAX

        OR     [EBX].fMode,0
        JNE     @@DOWrite

        PUSH    [EBX].fFileName
        MOV     EAX,IniBufferSize
        PUSH    EAX

        LEA     EAX,[ESI+4]
        PUSH    EAX
        PUSH    [EBX].fSection

        CALL    GetPrivateProfileSection
        JMP     _FillStrList

@@DOWrite:

        PUSH    EBX
        PUSH    ESI
        PUSH    EDX
        PUSH    EBP

        MOV     EDX,0
        MOV     EBP,[EDI].TStrList.fCount
        MOV     EBX,IniBufferSize-2 //    #0#0

{ECM+++>} OR      EBP,EBP  // otherwise GetPChars when StrList.Count = 0 crashed

@@LOOP:
        JE      @@ENDLOOP

        OR      EBX,EBX
        JE      @@ENDLOOP

        PUSH    EDX
        MOV     EAX,EDI
        CALL    TStrList.GetPChars

        PUSH    EAX
        CALL    StrLen
        POP     EAX

        XOR     ECX,-1
        MOV     EDX,ESI

        SUB     EBX,ECX
        JA      @@L1
        ADD     ECX,EBX
        XOR     EBX,EBX
@@L1:

        ADD     ESI,ECX

        CALL    MOVE
@@L2:
        POP     EDX
        INC     EDX
        DEC     EBP
        JMP     @@LOOP
@@ENDLOOP:
        MOV     WORD PTR [ESI],0

        POP     EBP
        POP     EDX
        POP     ESI
        POP     EBX
///////////////////////////////////
        MOV     EAX,EBX                 //  
        CALL    ClearSection
//////////////////////////////////

        PUSH    [EBX].fFileName
        PUSH    ESI
        PUSH    [EBX].fSection

        CALL    WritePrivateProfileSection

        POP     EAX
        CALL    System.@FreeMem

        POP     ECX
        POP     EBX
        POP     EDI
        POP     ESI

end;
{$ELSE ASM_VERSION} //Pascal
procedure TIniFile.GetSectionNames(Names:PKOLStrList);
var
  i:integer;
  Pc:PKOLChar;
  PcEnd:PKOLChar;
  Buffer:Pointer;
begin
  GetMem(Buffer,IniBufferSize * Sizeof( KOLChar ));
  Pc:=Buffer;
  i := GetPrivateProfileSectionNames(Buffer, IniBufferSize, PKOLChar(fFileName));
  PcEnd:=Pc+i;
  repeat
    Names.Add(Pc);
    Pc:=PC+Length(PC)+1;
  until PC>=PcEnd;
  FreeMem(Buffer);
end;

//[procedure TIniFile.SectionData]
procedure TIniFile.SectionData(Names: PKOLStrList);
var
  i:integer;
  Pc:PKOLChar;
  PcEnd:PKOLChar;
  Buffer:Pointer;
begin
  GetMem(Buffer,IniBufferSize * Sizeof(KOLChar));
  Pc:=Buffer;
  if fMode = ifmRead then
  begin
    i:=GetPrivateProfileSection(PKOLChar(fSection), Buffer, IniBufferSize, PKOLChar(fFileName));
    PcEnd:=Pc+i;
    while PC < PcEnd do // Chg by ECM from REPEAT-UNTIL: i=0 (empty section) => Names.Count=1
    begin
      Names.Add(Pc);
      Pc:=PC+Length(PC)+1;
    end;
  end else
  begin
    for i:= 0 to Names.Count-1 do
    begin
      {$IFDEF UNICODE_CTRLS} WStrCopy {$ELSE} StrCopy {$ENDIF}
        (Pc,Names.ItemPtrs[i]);
      Pc:=PC+Length(PC)+1;
    end;
    Pc[0]:=#0;
    ClearSection;
    WritePrivateProfileSection(PKOLChar(fSection), Buffer, PKOLChar(fFileName));

  end;
  FreeMem(Buffer);
end;
{$ENDIF ASM_VERSION}

/////////////////////////////////////////////////////////////////////////
//                                M  E  N  U
/////////////////////////////////////////////////////////////////////////

{ -- Menu implementation -- }

//[FUNCTION MakeAccelerator]
{$IFDEF ASM_VERSION}
{$ELSE ASM_VERSION} //Pascal
function MakeAccelerator( fVirt: Byte; Key: Word ): TMenuAccelerator;
begin
  Result.fVirt := fVirt;
  Result.Key := Key;
end;
{$ENDIF ASM_VERSION}
//[END MakeAccelerator]

//[FUNCTION GetAcceleratorText]
function GetAcceleratorText( const Accelerator: TMenuAccelerator ): KOLString;
var
  KeyName: array[0..255] of KOLChar;

  procedure AddKeyName( Code: Integer );
  begin
    Code := MapVirtualKey(Code, 0);
    if Code = 0 then exit;
    if GetKeyNameText(Code shl 16, KeyName, 256) > 0 then begin
      if Result <> '' then
        Result := Result + '+';
      Result := Result + KeyName;
    end;
  end;

begin
  Result := '';
  with Accelerator do begin
    if fVirt and FCONTROL <> 0 then
      AddKeyName(VK_CONTROL);
    if fVirt and FSHIFT <> 0 then
      AddKeyName(VK_SHIFT);
    if fVirt and FALT <> 0 then
      AddKeyName(VK_ALT);
    if fVirt and $20 <> 0 then
      AddKeyName(VK_LWIN);
    if fVirt and $40 <> 0 then
      AddKeyName(VK_RWIN);

    AddKeyName(Key);
  end;
end;
//[END GetAcceleratorText]

const
  MIDATA_CHECKITEM = $40000000;
  MIDATA_RADIOITEM = $80000000;

//[function WndProcMenu]
{$IFNDEF NEW_MENU_ACCELL}
function WndProcMenu( Sender: PControl; var Msg: TMsg; var Rslt: Integer): Boolean;
var M, M1: PMenu;
    Idx: Integer;
    Id: Integer;
begin
  Result := False;
  if Msg.message = WM_COMMAND then
  begin
     if (Msg.lParam = 0) and (HIWORD( Msg.wParam ) <= 1) then
     begin
       M := PMenu( Sender.fMenuObj );
       while (M = nil) and (Sender.Parent <> nil) do
       begin
         Sender := Sender.Parent;
         M := PMenu( Sender.fMenuObj );
       end;
       while M <> nil do
       begin
         Id := LoWord( Msg.wParam );
         M1 := M.Items[ Id ];
         if M1 <> nil then
         begin
           Result := True;
           Rslt := 0;
           Idx := M.IndexOf( M1 );
           M.fByAccel := HiWord( Msg.wParam ) <> 0;
           if M1.FRadioGroup <> 0 then
             M1.RadioCheckItem
           else
           if M1.FIsCheckItem then
             M1.Checked := not M1.Checked;
           if Assigned(M1.FOnMenuItem) then
             M1.FOnMenuItem( M, Idx )
           else if Assigned( M.FOnMenuItem ) then
             M.FOnMenuItem( M, Idx );
           break;
         end;
         M := M.fNextMenu;
       end;
     end;
  end;
end;

{$ELSE}

function WndProcMenu( Sender: PControl; var Msg: TMsg; var Rslt: Integer): Boolean;

  function ProcessMenuItem(M: PMenu; Id: Integer): Boolean;
  var
    M1: PMenu;
    Idx: Integer;
  begin
    M1 := M.Items[ Id ];
    Result := (M1 <> nil);
    if Result then
    begin
      Idx := M.IndexOf( M1 );
      M.fByAccel := HiWord( Msg.wParam ) <> 0;
      if M1.FRadioGroup <> 0 then
        M1.RadioCheckItem
      else
      if M1.FIsCheckItem then
        M1.Checked := not M1.Checked;
      if Assigned(M1.FOnMenuItem) then begin
      {$IFDEF USE_MENU_CURCTL} // fixed
        M.fCurCtl := Sender;   // fixed
      {$ENDIF}                 // fixed
        M1.FOnMenuItem( M, Idx )
      end
      else if Assigned( M.FOnMenuItem ) then
        M.FOnMenuItem( M, Idx );
    end;
  end;

var
  M: PMenu;
  Id: Integer;
begin
  Result := False;
  if Msg.message = WM_COMMAND then
    if (Msg.lParam = 0) and (HIWORD( Msg.wParam ) <= 1) then begin
      Id := LoWord(Msg.wParam);
      M := PMenu(Sender.fAutoPopupMenu);
      if (M <> nil) and ProcessMenuItem(M, Id) then begin
        Result := True;
        Rslt := 0;
      end
      else begin
        M := PMenu(Sender.fMenuObj);
        while M <> nil do begin
          if ProcessMenuItem(M, Id) then begin
            Result := True;
            Rslt := 0;
            Break;
          end;
          M := M.fNextMenu;
        end;
      end;
    end;
end;
{$ENDIF}

{$ENDIF WIN_GDI}

//[function NewMenu]
{$IFDEF GDI}
function NewMenu( AParent : PControl; MaxCmdReserve : DWORD;
  const Template : array of PKOLChar; aOnMenuItem: TOnMenuItem ): PMenu;
var M: PMenu;
    {$IFDEF INITIALFORMSIZE_FIXMENU}
    R: TRect;
    {$ENDIF}
begin
  {-}
  New( Result, Create );
  {+}{++}(*Result := PMenu.Create;*){--}
  Result.FVisible := TRUE;
  Result.FPopupFlags := TPM_LEFTALIGN or TPM_LEFTBUTTON;
  Result.FMenuItems := NewList;
  Result.FOnMenuItem := aOnMenuItem;
  if (High(Template)>=0) and (Template[0] <> nil) then
  begin
    if (AParent <> nil) and (AParent.fMenuObj = nil) and not AParent.fIsControl then
      Result.FHandle := CreateMenu
    else
      Result.FHandle := CreatePopupMenu;
    Result.FillMenuItems( Result.FHandle, 0, Template );
  end;
  if assigned( AParent ) then
  begin
    Result.FControl := AParent;
    if AParent.fMenuObj <> nil then
    begin
      // add popup menu to the end of menu chain
      M := PMenu( AParent.fMenuObj );
      while M.fNextMenu <> nil do
        M := M.fNextMenu;
      M.fNextMenu := Result;
    end
       else
    begin
      if not AParent.fIsControl then
      begin
        {$IFDEF INITIALFORMSIZE_FIXMENU}
        R := AParent.ClientRect;
        {$ENDIF}
        AParent.Menu := Result.FHandle;
        {$IFDEF INITIALFORMSIZE_FIXMENU}
        AParent.SetClientSize( R.Right, R.Bottom );
        {$ENDIF}
      end;
      AParent.fMenuObj := Result;
      AParent.AttachProc( WndProcMenu );
      {$IFDEF USE_AUTOFREE4CONTROLS}
      AParent.Add2AutoFree( Result );
      {$ENDIF}
    end;
  end;
end;
{$ENDIF GDI}
{$IFDEF _X_}
{$IFDEF GTK}

//--- some code from samples - may be useful to see "how to"
Function AddSeparatorToMenu( Menu : PGtkMenu ) : PgtkMenuItem ;
begin
  Result := PGtkMenuitem( gtk_menu_item_new ) ;
  gtk_menu_append( GTK_WIDGET( Menu ), PGtkWidget( Result ) ) ;
  gtk_widget_show( PGtkWidget ( Result ) ) ;
end;

Function AddItemToMenu( Menu : PGtkMenu;
                        ShortCuts : PGtkAccelGroup;
                        const Caption : AnsiString;
                        const ShortCut : AnsiString;
                        CallBack : TGtkSignalFunc;
                        CallBackdata : Pointer ) : PGtkMenuItem;
Var
  Key, Modifiers : DWORD;
  //LocalAccelGroup : PGtkAccelGroup; -- not used since gtk_menu_ensure_uline_accel_group not defined anywhere...
  TheLabel : PGtkLabel;
begin
  Result := PGtkMenuItem ( gtk_menu_item_new_with_label( '' ) ) ;
  TheLabel := GTK_LABEL(GTK_BIN( Result )^.child ) ;
  Key:= gtk_label_parse_uline( TheLabel , Pchar ( Caption ) ) ;
  //----------------
  {If Key<>0 then // gtk_menu_ensure_uline_accel_group -- not defined anywhere...
  begin
    LocalAccelGroup := gtk_menu_ensure_uline_accel_group( Menu );
    gtk_widget_add_accelerator( PGtkWidget ( Result ), 'activateitem',
                                LocalAccelGroup , Key ,
                                0 , TGtkAccelFlags ( 0 ) ) ;
  end;}
  //-----------------
  gtk_menu_append( GTK_WIDGET( Menu ), PGtkWidget( Result ) ) ;
  //-----------------
  If ( ShortCut<>'' ) and ( ShortCuts<> Nil ) then
  begin
    gtk_accelerator_parse ( pchar( ShortCut ) , @key , @modifiers ) ;
    gtk_widget_add_accelerator ( PGtkWidget ( Result ) , ' activateitem' ,
      ShortCuts, Key, modifiers, GTK_ACCEL_VISIBLE );
  end;
  //------------------
  If Assigned( CallBack ) then
  begin
    gtk_signal_connect( PGtkObject ( Result ) , 'activate' ,
                        CallBack , CallBackdata ) ;
    gtk_widget_show( PgtkWidget ( Result ) ) ;
  end ;
end;

Function AddMenuToMenuBar( MenuBar : PGtkMenuBar;
                           ShortCuts : PGtkAccelGroup;
                           Caption : AnsiString;
                           CallBack : TGtkSignalFunc;
                           CallBackdata : Pointer;
                           AlignRight : Boolean;
                           Var MenuItem : PgtkMenuItem ) : PGtkMenu;
Var Key : DWORD;
    TheLabel : PGtkLabel;
begin
  MenuItem := PGtkMenuItem( gtk_menu_item_new_with_label( '' ) ) ;
  If AlignRight Then
    gtk_menu_item_right_justify( MenuItem );
  TheLabel := GTK_LABEL( GTK_BIN( MenuItem )^ .child ) ;
  Key := gtk_label_parse_uline( TheLabel, Pchar ( Caption ) ) ;
  If Key<>0 then
    gtk_widget_add_accelerator( PGtkWidget( MenuItem ), 'activateitem',
      Shortcuts, Key, GDK_MOD1_MASK, GTK_ACCEL_LOCKED );
  Result := PGtkMenu( gtk_menu_new );
  If Assigned( CallBack ) then
    gtk_signal_connect( PGtkObject ( Result ), 'activate',
      CallBack, CallBackdata ) ;
  gtk_widget_show( PgtkWidget ( MenuItem ) ) ;
  gtk_menu_item_set_submenu( MenuItem, PGtkWidget( Result ) ) ;
  gtk_menu_bar_append( GTK_WIDGET( MenuBar ), PgtkWidget( MenuItem ) ) ;
end;

function NewMenu( AParent : PControl; MaxCmdReserve : DWORD;
  const Template : array of PKOLChar; aOnMenuItem: TOnMenuItem ): PMenu;
  procedure CreateMenuItems( ParentMenu: PMenu; var i: Integer );
  var Item, PrevItem: PMenu;
      s: AnsiString;
      j: Integer;
  begin
    PrevItem := nil;
    while i <= High( Template )-1 do
    begin
      inc( i );
      s := Template[ i ];
      if s = '' then break; // end of template

      if s = ')' then
      begin
        inc( i ); break; // end of submenu
      end;

      new( Item, Create );
      Item.FCaption := s;
      Item.FVisible := TRUE;
      Item.FParentMenu := ParentMenu;
      if ParentMenu.FItems = nil then
        ParentMenu.FItems := NewList;
      ParentMenu.FItems.Add( Item );

      if (s <> '') and (s[ 1 ] in [ '+', '-' ]) then
      begin
        Item.fIsCheckItem := TRUE;
        Item.fChecked := S[ 1 ] = '+';
        s := CopyEnd( s, 2 );
        if (s <> '') and (s[ 1 ] = '!') then
        begin
          if PrevItem <> nil then
          begin
            if PrevItem.fRadioGroup <> 0 then
              Item.fRadioGroup := PrevItem.fRadioGroup;
          end
          else inc( Item.fRadioGroup );
          s := CopyEnd( s, 2 );
        end;
      end;

      if s = '-' then
        Item.fIsSeparator := TRUE
      else
      begin
        // extract mnemonic
        for j := Length( s )-1 downto 1 do
        begin
          if (s[ j ] = '&') and (s[ j+1 ] <> '&') then // mnemonic
          begin
            Item.fMnemonics := Item.fMnemonics + s[ j+1 ];
            Delete( s, j, 1 );//?  <U>m</U> ?
          end;
        end;
      end;

      //---------------------------- now call gtk for create item's widget
      if Item.FIsSeparator then
        Item.fGtkMenuItem := gtk_menu_item_new
      else
        Item.fGtkMenuItem := gtk_menu_item_new_with_label( PAnsiChar( s ) );
      if ParentMenu.fGtkMenuBar <> nil then
        gtk_menu_bar_append(
          ParentMenu.fGtkMenuBar,
          Item.fGtkMenuItem )
      else
        gtk_menu_shell_append(
          GTK_MENU_SHELL( ParentMenu.fGtkMenuShell ),
          Item.fGtkMenuItem );

      if s = '(' then
      begin
        inc( i );
        if PrevItem <> nil then
        begin
          PrevItem.fGtkMenuShell := gtk_menu_new;
          gtk_menu_item_set_submenu(
            GTK_MENU_ITEM( PrevItem.fGtkMenuItem ),
            PrevItem.fGtkMenuShell );
          CreateMenuItems( PrevItem, i );
        end;
      end;

      PrevItem := Item;
    end;
  end;
var i: Integer;
begin
  new( Result, Create );
  i := -1;
  if AParent.fMenuObj = nil then
  begin //       ( ?  ?)
    AParent.fMenuObj := Result;
    Result.fGtkMenuBar := gtk_menu_bar_new;
    //AParent.fMenuBar  := Result.fGtkMenuBar;
    gtk_container_add( GTK_CONTAINER( AParent.fClient ), Result.fGtkMenuBar );
    gtk_widget_show( Result.fGtkMenuBar );
  end
    else
  begin
    PMenu( AParent.fMenuObj ).fNextMenu := Result;
    Result.fGtkMenuShell := gtk_menu_new;
  end;
  CreateMenuItems( Result, i );
end;
{$ENDIF GTK}
{$ENDIF _X_}
//[END NewMenu]

//[function NewMenuEx]
function NewMenuEx( AParent : PControl; FirstCmd : Integer;
  const Template : array of PKOLChar; aOnMenuItems: array of TOnMenuItem ): PMenu;
begin
  Result := NewMenu( AParent, FirstCmd, Template, nil );
  {$IFDEF GDI}
  Result.AssignEvents( 0, aOnMenuItems );
  {$ENDIF GDI}
end;
//[END NewMenuEx]

{$IFDEF WIN_GDI}
{ TMenu }

const
  Breaks: array[ TMenuBreak ] of DWORD = ( 0, MFT_MENUBREAK, MFT_MENUBARBREAK );

{ + by AK - Andrzej Kubaszek }
//[function MenuStructSize]
function MenuStructSize: Integer;
begin
  Result := 44;
  if not( WinVer in [wv31, wv95, wvNT] ) then
    Result := {48=} Sizeof( TMenuItemInfo );
end;
{$ENDIF WIN_GDI}

//[destructor TMenu.Destroy]
{$IFDEF GDI}
destructor TMenu.Destroy;
var Next, Prnt: PMenu;
begin
  {$IFDEF DEBUG_MENU_DESTROY}
  LogFileOutput( GetStartDir + 'TMenu.Destroy.txt',
    Int2Hex( DWORD( @ Self ), 6 ) + ' ' + Int2Str( RefCount ) );
  {$ENDIF}
  if Count > 0 then
  begin
    FMenuItems.ReleaseObjects;
    FMenuItems := NewList;
  end;
  if FParentMenu <> nil then
  begin
    Prnt := FParentMenu;
    Next := Prnt.RemoveSubMenu( FId );
    FParentMenu := nil;
    Prnt.FMenuItems.Remove( @ Self );
    if Next = nil then
    begin
      asm
        nop
      end;
      Exit;
    end;
  end;
   if (FControl <> nil) and (FControl.fMenu = FHandle) and (FHandle <> 0) then
   begin
     //if FControl.fHandle <> 0 then
     if not FControl.fDestroying then //!!!fix by Galkov
     begin
       Windows.SetMenu( FControl.fHandle, 0 );
       // this removes main menu from window, but does not destroy it
     end;
     FControl.fMenu := 0;
     Next := PMenu( FControl.fMenuObj );
     while Next <> nil  do
     begin
       if Next.fNextMenu = @Self then
       begin
         Next.fNextMenu := fNextMenu;
         break;
       end;
       Next := Next.fNextMenu;
     end;
   end;
  